
;CodeVisionAVR C Compiler V2.05.0 Advanced
;(C) Copyright 1998-2010 Pavel Haiduc, HP InfoTech s.r.l.
;http://www.hpinfotech.com

;Chip type                : ATmega128
;Program type             : Application
;Clock frequency          : 16.000000 MHz
;Memory model             : Small
;Optimize for             : Speed
;(s)printf features       : int, width
;(s)scanf features        : int, width
;External RAM size        : 0
;Data Stack size          : 1024 byte(s)
;Heap size                : 0 byte(s)
;Promote 'char' to 'int'  : No
;'char' is unsigned       : No
;8 bit enums              : Yes
;global 'const' stored in FLASH: Yes
;Enhanced core instructions    : On
;Smart register allocation     : On
;Automatic register allocation : On

	#pragma AVRPART ADMIN PART_NAME ATmega128
	#pragma AVRPART MEMORY PROG_FLASH 131072
	#pragma AVRPART MEMORY EEPROM 4096
	#pragma AVRPART MEMORY INT_SRAM SIZE 4351
	#pragma AVRPART MEMORY INT_SRAM START_ADDR 0x100

	#define CALL_SUPPORTED 1

	.LISTMAC
	.EQU UDRE=0x5
	.EQU RXC=0x7
	.EQU USR=0xB
	.EQU UDR=0xC
	.EQU SPSR=0xE
	.EQU SPDR=0xF
	.EQU EERE=0x0
	.EQU EEWE=0x1
	.EQU EEMWE=0x2
	.EQU EECR=0x1C
	.EQU EEDR=0x1D
	.EQU EEARL=0x1E
	.EQU EEARH=0x1F
	.EQU WDTCR=0x21
	.EQU MCUCR=0x35
	.EQU RAMPZ=0x3B
	.EQU SPL=0x3D
	.EQU SPH=0x3E
	.EQU SREG=0x3F
	.EQU XMCRA=0x6D
	.EQU XMCRB=0x6C

	.DEF R0X0=R0
	.DEF R0X1=R1
	.DEF R0X2=R2
	.DEF R0X3=R3
	.DEF R0X4=R4
	.DEF R0X5=R5
	.DEF R0X6=R6
	.DEF R0X7=R7
	.DEF R0X8=R8
	.DEF R0X9=R9
	.DEF R0XA=R10
	.DEF R0XB=R11
	.DEF R0XC=R12
	.DEF R0XD=R13
	.DEF R0XE=R14
	.DEF R0XF=R15
	.DEF R0X10=R16
	.DEF R0X11=R17
	.DEF R0X12=R18
	.DEF R0X13=R19
	.DEF R0X14=R20
	.DEF R0X15=R21
	.DEF R0X16=R22
	.DEF R0X17=R23
	.DEF R0X18=R24
	.DEF R0X19=R25
	.DEF R0X1A=R26
	.DEF R0X1B=R27
	.DEF R0X1C=R28
	.DEF R0X1D=R29
	.DEF R0X1E=R30
	.DEF R0X1F=R31

	.EQU __SRAM_START=0x0100
	.EQU __SRAM_END=0x10FF
	.EQU __DSTACK_SIZE=0x0400
	.EQU __HEAP_SIZE=0x0000
	.EQU __CLEAR_SRAM_SIZE=__SRAM_END-__SRAM_START+1

	.MACRO __CPD1N
	CPI  R30,LOW(@0)
	LDI  R26,HIGH(@0)
	CPC  R31,R26
	LDI  R26,BYTE3(@0)
	CPC  R22,R26
	LDI  R26,BYTE4(@0)
	CPC  R23,R26
	.ENDM

	.MACRO __CPD2N
	CPI  R26,LOW(@0)
	LDI  R30,HIGH(@0)
	CPC  R27,R30
	LDI  R30,BYTE3(@0)
	CPC  R24,R30
	LDI  R30,BYTE4(@0)
	CPC  R25,R30
	.ENDM

	.MACRO __CPWRR
	CP   R@0,R@2
	CPC  R@1,R@3
	.ENDM

	.MACRO __CPWRN
	CPI  R@0,LOW(@2)
	LDI  R30,HIGH(@2)
	CPC  R@1,R30
	.ENDM

	.MACRO __ADDB1MN
	SUBI R30,LOW(-@0-(@1))
	.ENDM

	.MACRO __ADDB2MN
	SUBI R26,LOW(-@0-(@1))
	.ENDM

	.MACRO __ADDW1MN
	SUBI R30,LOW(-@0-(@1))
	SBCI R31,HIGH(-@0-(@1))
	.ENDM

	.MACRO __ADDW2MN
	SUBI R26,LOW(-@0-(@1))
	SBCI R27,HIGH(-@0-(@1))
	.ENDM

	.MACRO __ADDW1FN
	SUBI R30,LOW(-2*@0-(@1))
	SBCI R31,HIGH(-2*@0-(@1))
	.ENDM

	.MACRO __ADDD1FN
	SUBI R30,LOW(-2*@0-(@1))
	SBCI R31,HIGH(-2*@0-(@1))
	SBCI R22,BYTE3(-2*@0-(@1))
	.ENDM

	.MACRO __ADDD1N
	SUBI R30,LOW(-@0)
	SBCI R31,HIGH(-@0)
	SBCI R22,BYTE3(-@0)
	SBCI R23,BYTE4(-@0)
	.ENDM

	.MACRO __ADDD2N
	SUBI R26,LOW(-@0)
	SBCI R27,HIGH(-@0)
	SBCI R24,BYTE3(-@0)
	SBCI R25,BYTE4(-@0)
	.ENDM

	.MACRO __SUBD1N
	SUBI R30,LOW(@0)
	SBCI R31,HIGH(@0)
	SBCI R22,BYTE3(@0)
	SBCI R23,BYTE4(@0)
	.ENDM

	.MACRO __SUBD2N
	SUBI R26,LOW(@0)
	SBCI R27,HIGH(@0)
	SBCI R24,BYTE3(@0)
	SBCI R25,BYTE4(@0)
	.ENDM

	.MACRO __ANDBMNN
	LDS  R30,@0+(@1)
	ANDI R30,LOW(@2)
	STS  @0+(@1),R30
	.ENDM

	.MACRO __ANDWMNN
	LDS  R30,@0+(@1)
	ANDI R30,LOW(@2)
	STS  @0+(@1),R30
	LDS  R30,@0+(@1)+1
	ANDI R30,HIGH(@2)
	STS  @0+(@1)+1,R30
	.ENDM

	.MACRO __ANDD1N
	ANDI R30,LOW(@0)
	ANDI R31,HIGH(@0)
	ANDI R22,BYTE3(@0)
	ANDI R23,BYTE4(@0)
	.ENDM

	.MACRO __ANDD2N
	ANDI R26,LOW(@0)
	ANDI R27,HIGH(@0)
	ANDI R24,BYTE3(@0)
	ANDI R25,BYTE4(@0)
	.ENDM

	.MACRO __ORBMNN
	LDS  R30,@0+(@1)
	ORI  R30,LOW(@2)
	STS  @0+(@1),R30
	.ENDM

	.MACRO __ORWMNN
	LDS  R30,@0+(@1)
	ORI  R30,LOW(@2)
	STS  @0+(@1),R30
	LDS  R30,@0+(@1)+1
	ORI  R30,HIGH(@2)
	STS  @0+(@1)+1,R30
	.ENDM

	.MACRO __ORD1N
	ORI  R30,LOW(@0)
	ORI  R31,HIGH(@0)
	ORI  R22,BYTE3(@0)
	ORI  R23,BYTE4(@0)
	.ENDM

	.MACRO __ORD2N
	ORI  R26,LOW(@0)
	ORI  R27,HIGH(@0)
	ORI  R24,BYTE3(@0)
	ORI  R25,BYTE4(@0)
	.ENDM

	.MACRO __DELAY_USB
	LDI  R24,LOW(@0)
__DELAY_USB_LOOP:
	DEC  R24
	BRNE __DELAY_USB_LOOP
	.ENDM

	.MACRO __DELAY_USW
	LDI  R24,LOW(@0)
	LDI  R25,HIGH(@0)
__DELAY_USW_LOOP:
	SBIW R24,1
	BRNE __DELAY_USW_LOOP
	.ENDM

	.MACRO __GETD1S
	LDD  R30,Y+@0
	LDD  R31,Y+@0+1
	LDD  R22,Y+@0+2
	LDD  R23,Y+@0+3
	.ENDM

	.MACRO __GETD2S
	LDD  R26,Y+@0
	LDD  R27,Y+@0+1
	LDD  R24,Y+@0+2
	LDD  R25,Y+@0+3
	.ENDM

	.MACRO __PUTD1S
	STD  Y+@0,R30
	STD  Y+@0+1,R31
	STD  Y+@0+2,R22
	STD  Y+@0+3,R23
	.ENDM

	.MACRO __PUTD2S
	STD  Y+@0,R26
	STD  Y+@0+1,R27
	STD  Y+@0+2,R24
	STD  Y+@0+3,R25
	.ENDM

	.MACRO __PUTDZ2
	STD  Z+@0,R26
	STD  Z+@0+1,R27
	STD  Z+@0+2,R24
	STD  Z+@0+3,R25
	.ENDM

	.MACRO __CLRD1S
	STD  Y+@0,R30
	STD  Y+@0+1,R30
	STD  Y+@0+2,R30
	STD  Y+@0+3,R30
	.ENDM

	.MACRO __POINTB1MN
	LDI  R30,LOW(@0+(@1))
	.ENDM

	.MACRO __POINTW1MN
	LDI  R30,LOW(@0+(@1))
	LDI  R31,HIGH(@0+(@1))
	.ENDM

	.MACRO __POINTD1M
	LDI  R30,LOW(@0)
	LDI  R31,HIGH(@0)
	LDI  R22,BYTE3(@0)
	LDI  R23,BYTE4(@0)
	.ENDM

	.MACRO __POINTW1FN
	LDI  R30,LOW(2*@0+(@1))
	LDI  R31,HIGH(2*@0+(@1))
	.ENDM

	.MACRO __POINTD1FN
	LDI  R30,LOW(2*@0+(@1))
	LDI  R31,HIGH(2*@0+(@1))
	LDI  R22,BYTE3(2*@0+(@1))
	LDI  R23,BYTE4(2*@0+(@1))
	.ENDM

	.MACRO __POINTB2MN
	LDI  R26,LOW(@0+(@1))
	.ENDM

	.MACRO __POINTW2MN
	LDI  R26,LOW(@0+(@1))
	LDI  R27,HIGH(@0+(@1))
	.ENDM

	.MACRO __POINTBRM
	LDI  R@0,LOW(@1)
	.ENDM

	.MACRO __POINTWRM
	LDI  R@0,LOW(@2)
	LDI  R@1,HIGH(@2)
	.ENDM

	.MACRO __POINTBRMN
	LDI  R@0,LOW(@1+(@2))
	.ENDM

	.MACRO __POINTWRMN
	LDI  R@0,LOW(@2+(@3))
	LDI  R@1,HIGH(@2+(@3))
	.ENDM

	.MACRO __POINTWRFN
	LDI  R@0,LOW(@2*2+(@3))
	LDI  R@1,HIGH(@2*2+(@3))
	.ENDM

	.MACRO __GETD1N
	LDI  R30,LOW(@0)
	LDI  R31,HIGH(@0)
	LDI  R22,BYTE3(@0)
	LDI  R23,BYTE4(@0)
	.ENDM

	.MACRO __GETD2N
	LDI  R26,LOW(@0)
	LDI  R27,HIGH(@0)
	LDI  R24,BYTE3(@0)
	LDI  R25,BYTE4(@0)
	.ENDM

	.MACRO __GETB1MN
	LDS  R30,@0+(@1)
	.ENDM

	.MACRO __GETB1HMN
	LDS  R31,@0+(@1)
	.ENDM

	.MACRO __GETW1MN
	LDS  R30,@0+(@1)
	LDS  R31,@0+(@1)+1
	.ENDM

	.MACRO __GETD1MN
	LDS  R30,@0+(@1)
	LDS  R31,@0+(@1)+1
	LDS  R22,@0+(@1)+2
	LDS  R23,@0+(@1)+3
	.ENDM

	.MACRO __GETBRMN
	LDS  R@0,@1+(@2)
	.ENDM

	.MACRO __GETWRMN
	LDS  R@0,@2+(@3)
	LDS  R@1,@2+(@3)+1
	.ENDM

	.MACRO __GETWRZ
	LDD  R@0,Z+@2
	LDD  R@1,Z+@2+1
	.ENDM

	.MACRO __GETD2Z
	LDD  R26,Z+@0
	LDD  R27,Z+@0+1
	LDD  R24,Z+@0+2
	LDD  R25,Z+@0+3
	.ENDM

	.MACRO __GETB2MN
	LDS  R26,@0+(@1)
	.ENDM

	.MACRO __GETW2MN
	LDS  R26,@0+(@1)
	LDS  R27,@0+(@1)+1
	.ENDM

	.MACRO __GETD2MN
	LDS  R26,@0+(@1)
	LDS  R27,@0+(@1)+1
	LDS  R24,@0+(@1)+2
	LDS  R25,@0+(@1)+3
	.ENDM

	.MACRO __PUTB1MN
	STS  @0+(@1),R30
	.ENDM

	.MACRO __PUTW1MN
	STS  @0+(@1),R30
	STS  @0+(@1)+1,R31
	.ENDM

	.MACRO __PUTD1MN
	STS  @0+(@1),R30
	STS  @0+(@1)+1,R31
	STS  @0+(@1)+2,R22
	STS  @0+(@1)+3,R23
	.ENDM

	.MACRO __PUTB1EN
	LDI  R26,LOW(@0+(@1))
	LDI  R27,HIGH(@0+(@1))
	CALL __EEPROMWRB
	.ENDM

	.MACRO __PUTW1EN
	LDI  R26,LOW(@0+(@1))
	LDI  R27,HIGH(@0+(@1))
	CALL __EEPROMWRW
	.ENDM

	.MACRO __PUTD1EN
	LDI  R26,LOW(@0+(@1))
	LDI  R27,HIGH(@0+(@1))
	CALL __EEPROMWRD
	.ENDM

	.MACRO __PUTBR0MN
	STS  @0+(@1),R0
	.ENDM

	.MACRO __PUTBMRN
	STS  @0+(@1),R@2
	.ENDM

	.MACRO __PUTWMRN
	STS  @0+(@1),R@2
	STS  @0+(@1)+1,R@3
	.ENDM

	.MACRO __PUTBZR
	STD  Z+@1,R@0
	.ENDM

	.MACRO __PUTWZR
	STD  Z+@2,R@0
	STD  Z+@2+1,R@1
	.ENDM

	.MACRO __GETW1R
	MOV  R30,R@0
	MOV  R31,R@1
	.ENDM

	.MACRO __GETW2R
	MOV  R26,R@0
	MOV  R27,R@1
	.ENDM

	.MACRO __GETWRN
	LDI  R@0,LOW(@2)
	LDI  R@1,HIGH(@2)
	.ENDM

	.MACRO __PUTW1R
	MOV  R@0,R30
	MOV  R@1,R31
	.ENDM

	.MACRO __PUTW2R
	MOV  R@0,R26
	MOV  R@1,R27
	.ENDM

	.MACRO __ADDWRN
	SUBI R@0,LOW(-@2)
	SBCI R@1,HIGH(-@2)
	.ENDM

	.MACRO __ADDWRR
	ADD  R@0,R@2
	ADC  R@1,R@3
	.ENDM

	.MACRO __SUBWRN
	SUBI R@0,LOW(@2)
	SBCI R@1,HIGH(@2)
	.ENDM

	.MACRO __SUBWRR
	SUB  R@0,R@2
	SBC  R@1,R@3
	.ENDM

	.MACRO __ANDWRN
	ANDI R@0,LOW(@2)
	ANDI R@1,HIGH(@2)
	.ENDM

	.MACRO __ANDWRR
	AND  R@0,R@2
	AND  R@1,R@3
	.ENDM

	.MACRO __ORWRN
	ORI  R@0,LOW(@2)
	ORI  R@1,HIGH(@2)
	.ENDM

	.MACRO __ORWRR
	OR   R@0,R@2
	OR   R@1,R@3
	.ENDM

	.MACRO __EORWRR
	EOR  R@0,R@2
	EOR  R@1,R@3
	.ENDM

	.MACRO __GETWRS
	LDD  R@0,Y+@2
	LDD  R@1,Y+@2+1
	.ENDM

	.MACRO __PUTBSR
	STD  Y+@1,R@0
	.ENDM

	.MACRO __PUTWSR
	STD  Y+@2,R@0
	STD  Y+@2+1,R@1
	.ENDM

	.MACRO __MOVEWRR
	MOV  R@0,R@2
	MOV  R@1,R@3
	.ENDM

	.MACRO __INWR
	IN   R@0,@2
	IN   R@1,@2+1
	.ENDM

	.MACRO __OUTWR
	OUT  @2+1,R@1
	OUT  @2,R@0
	.ENDM

	.MACRO __CALL1MN
	LDS  R30,@0+(@1)
	LDS  R31,@0+(@1)+1
	ICALL
	.ENDM

	.MACRO __CALL1FN
	LDI  R30,LOW(2*@0+(@1))
	LDI  R31,HIGH(2*@0+(@1))
	CALL __GETW1PF
	ICALL
	.ENDM

	.MACRO __CALL2EN
	LDI  R26,LOW(@0+(@1))
	LDI  R27,HIGH(@0+(@1))
	CALL __EEPROMRDW
	ICALL
	.ENDM

	.MACRO __GETW1STACK
	IN   R26,SPL
	IN   R27,SPH
	ADIW R26,@0+1
	LD   R30,X+
	LD   R31,X
	.ENDM

	.MACRO __GETD1STACK
	IN   R26,SPL
	IN   R27,SPH
	ADIW R26,@0+1
	LD   R30,X+
	LD   R31,X+
	LD   R22,X
	.ENDM

	.MACRO __NBST
	BST  R@0,@1
	IN   R30,SREG
	LDI  R31,0x40
	EOR  R30,R31
	OUT  SREG,R30
	.ENDM


	.MACRO __PUTB1SN
	LDD  R26,Y+@0
	LDD  R27,Y+@0+1
	SUBI R26,LOW(-@1)
	SBCI R27,HIGH(-@1)
	ST   X,R30
	.ENDM

	.MACRO __PUTW1SN
	LDD  R26,Y+@0
	LDD  R27,Y+@0+1
	SUBI R26,LOW(-@1)
	SBCI R27,HIGH(-@1)
	ST   X+,R30
	ST   X,R31
	.ENDM

	.MACRO __PUTD1SN
	LDD  R26,Y+@0
	LDD  R27,Y+@0+1
	SUBI R26,LOW(-@1)
	SBCI R27,HIGH(-@1)
	CALL __PUTDP1
	.ENDM

	.MACRO __PUTB1SNS
	LDD  R26,Y+@0
	LDD  R27,Y+@0+1
	ADIW R26,@1
	ST   X,R30
	.ENDM

	.MACRO __PUTW1SNS
	LDD  R26,Y+@0
	LDD  R27,Y+@0+1
	ADIW R26,@1
	ST   X+,R30
	ST   X,R31
	.ENDM

	.MACRO __PUTD1SNS
	LDD  R26,Y+@0
	LDD  R27,Y+@0+1
	ADIW R26,@1
	CALL __PUTDP1
	.ENDM

	.MACRO __PUTB1PMN
	LDS  R26,@0
	LDS  R27,@0+1
	SUBI R26,LOW(-@1)
	SBCI R27,HIGH(-@1)
	ST   X,R30
	.ENDM

	.MACRO __PUTW1PMN
	LDS  R26,@0
	LDS  R27,@0+1
	SUBI R26,LOW(-@1)
	SBCI R27,HIGH(-@1)
	ST   X+,R30
	ST   X,R31
	.ENDM

	.MACRO __PUTD1PMN
	LDS  R26,@0
	LDS  R27,@0+1
	SUBI R26,LOW(-@1)
	SBCI R27,HIGH(-@1)
	CALL __PUTDP1
	.ENDM

	.MACRO __PUTB1PMNS
	LDS  R26,@0
	LDS  R27,@0+1
	ADIW R26,@1
	ST   X,R30
	.ENDM

	.MACRO __PUTW1PMNS
	LDS  R26,@0
	LDS  R27,@0+1
	ADIW R26,@1
	ST   X+,R30
	ST   X,R31
	.ENDM

	.MACRO __PUTD1PMNS
	LDS  R26,@0
	LDS  R27,@0+1
	ADIW R26,@1
	CALL __PUTDP1
	.ENDM

	.MACRO __PUTB1RN
	MOVW R26,R@0
	SUBI R26,LOW(-@1)
	SBCI R27,HIGH(-@1)
	ST   X,R30
	.ENDM

	.MACRO __PUTW1RN
	MOVW R26,R@0
	SUBI R26,LOW(-@1)
	SBCI R27,HIGH(-@1)
	ST   X+,R30
	ST   X,R31
	.ENDM

	.MACRO __PUTD1RN
	MOVW R26,R@0
	SUBI R26,LOW(-@1)
	SBCI R27,HIGH(-@1)
	CALL __PUTDP1
	.ENDM

	.MACRO __PUTB1RNS
	MOVW R26,R@0
	ADIW R26,@1
	ST   X,R30
	.ENDM

	.MACRO __PUTW1RNS
	MOVW R26,R@0
	ADIW R26,@1
	ST   X+,R30
	ST   X,R31
	.ENDM

	.MACRO __PUTD1RNS
	MOVW R26,R@0
	ADIW R26,@1
	CALL __PUTDP1
	.ENDM

	.MACRO __PUTB1RON
	MOV  R26,R@0
	MOV  R27,R@1
	SUBI R26,LOW(-@2)
	SBCI R27,HIGH(-@2)
	ST   X,R30
	.ENDM

	.MACRO __PUTW1RON
	MOV  R26,R@0
	MOV  R27,R@1
	SUBI R26,LOW(-@2)
	SBCI R27,HIGH(-@2)
	ST   X+,R30
	ST   X,R31
	.ENDM

	.MACRO __PUTD1RON
	MOV  R26,R@0
	MOV  R27,R@1
	SUBI R26,LOW(-@2)
	SBCI R27,HIGH(-@2)
	CALL __PUTDP1
	.ENDM

	.MACRO __PUTB1RONS
	MOV  R26,R@0
	MOV  R27,R@1
	ADIW R26,@2
	ST   X,R30
	.ENDM

	.MACRO __PUTW1RONS
	MOV  R26,R@0
	MOV  R27,R@1
	ADIW R26,@2
	ST   X+,R30
	ST   X,R31
	.ENDM

	.MACRO __PUTD1RONS
	MOV  R26,R@0
	MOV  R27,R@1
	ADIW R26,@2
	CALL __PUTDP1
	.ENDM


	.MACRO __GETB1SX
	MOVW R30,R28
	SUBI R30,LOW(-@0)
	SBCI R31,HIGH(-@0)
	LD   R30,Z
	.ENDM

	.MACRO __GETB1HSX
	MOVW R30,R28
	SUBI R30,LOW(-@0)
	SBCI R31,HIGH(-@0)
	LD   R31,Z
	.ENDM

	.MACRO __GETW1SX
	MOVW R30,R28
	SUBI R30,LOW(-@0)
	SBCI R31,HIGH(-@0)
	LD   R0,Z+
	LD   R31,Z
	MOV  R30,R0
	.ENDM

	.MACRO __GETD1SX
	MOVW R30,R28
	SUBI R30,LOW(-@0)
	SBCI R31,HIGH(-@0)
	LD   R0,Z+
	LD   R1,Z+
	LD   R22,Z+
	LD   R23,Z
	MOVW R30,R0
	.ENDM

	.MACRO __GETB2SX
	MOVW R26,R28
	SUBI R26,LOW(-@0)
	SBCI R27,HIGH(-@0)
	LD   R26,X
	.ENDM

	.MACRO __GETW2SX
	MOVW R26,R28
	SUBI R26,LOW(-@0)
	SBCI R27,HIGH(-@0)
	LD   R0,X+
	LD   R27,X
	MOV  R26,R0
	.ENDM

	.MACRO __GETD2SX
	MOVW R26,R28
	SUBI R26,LOW(-@0)
	SBCI R27,HIGH(-@0)
	LD   R0,X+
	LD   R1,X+
	LD   R24,X+
	LD   R25,X
	MOVW R26,R0
	.ENDM

	.MACRO __GETBRSX
	MOVW R30,R28
	SUBI R30,LOW(-@1)
	SBCI R31,HIGH(-@1)
	LD   R@0,Z
	.ENDM

	.MACRO __GETWRSX
	MOVW R30,R28
	SUBI R30,LOW(-@2)
	SBCI R31,HIGH(-@2)
	LD   R@0,Z+
	LD   R@1,Z
	.ENDM

	.MACRO __GETBRSX2
	MOVW R26,R28
	SUBI R26,LOW(-@1)
	SBCI R27,HIGH(-@1)
	LD   R@0,X
	.ENDM

	.MACRO __GETWRSX2
	MOVW R26,R28
	SUBI R26,LOW(-@2)
	SBCI R27,HIGH(-@2)
	LD   R@0,X+
	LD   R@1,X
	.ENDM

	.MACRO __LSLW8SX
	MOVW R30,R28
	SUBI R30,LOW(-@0)
	SBCI R31,HIGH(-@0)
	LD   R31,Z
	CLR  R30
	.ENDM

	.MACRO __PUTB1SX
	MOVW R26,R28
	SUBI R26,LOW(-@0)
	SBCI R27,HIGH(-@0)
	ST   X,R30
	.ENDM

	.MACRO __PUTW1SX
	MOVW R26,R28
	SUBI R26,LOW(-@0)
	SBCI R27,HIGH(-@0)
	ST   X+,R30
	ST   X,R31
	.ENDM

	.MACRO __PUTD1SX
	MOVW R26,R28
	SUBI R26,LOW(-@0)
	SBCI R27,HIGH(-@0)
	ST   X+,R30
	ST   X+,R31
	ST   X+,R22
	ST   X,R23
	.ENDM

	.MACRO __CLRW1SX
	MOVW R26,R28
	SUBI R26,LOW(-@0)
	SBCI R27,HIGH(-@0)
	ST   X+,R30
	ST   X,R30
	.ENDM

	.MACRO __CLRD1SX
	MOVW R26,R28
	SUBI R26,LOW(-@0)
	SBCI R27,HIGH(-@0)
	ST   X+,R30
	ST   X+,R30
	ST   X+,R30
	ST   X,R30
	.ENDM

	.MACRO __PUTB2SX
	MOVW R30,R28
	SUBI R30,LOW(-@0)
	SBCI R31,HIGH(-@0)
	ST   Z,R26
	.ENDM

	.MACRO __PUTW2SX
	MOVW R30,R28
	SUBI R30,LOW(-@0)
	SBCI R31,HIGH(-@0)
	ST   Z+,R26
	ST   Z,R27
	.ENDM

	.MACRO __PUTD2SX
	MOVW R30,R28
	SUBI R30,LOW(-@0)
	SBCI R31,HIGH(-@0)
	ST   Z+,R26
	ST   Z+,R27
	ST   Z+,R24
	ST   Z,R25
	.ENDM

	.MACRO __PUTBSRX
	MOVW R30,R28
	SUBI R30,LOW(-@1)
	SBCI R31,HIGH(-@1)
	ST   Z,R@0
	.ENDM

	.MACRO __PUTWSRX
	MOVW R30,R28
	SUBI R30,LOW(-@2)
	SBCI R31,HIGH(-@2)
	ST   Z+,R@0
	ST   Z,R@1
	.ENDM

	.MACRO __PUTB1SNX
	MOVW R26,R28
	SUBI R26,LOW(-@0)
	SBCI R27,HIGH(-@0)
	LD   R0,X+
	LD   R27,X
	MOV  R26,R0
	SUBI R26,LOW(-@1)
	SBCI R27,HIGH(-@1)
	ST   X,R30
	.ENDM

	.MACRO __PUTW1SNX
	MOVW R26,R28
	SUBI R26,LOW(-@0)
	SBCI R27,HIGH(-@0)
	LD   R0,X+
	LD   R27,X
	MOV  R26,R0
	SUBI R26,LOW(-@1)
	SBCI R27,HIGH(-@1)
	ST   X+,R30
	ST   X,R31
	.ENDM

	.MACRO __PUTD1SNX
	MOVW R26,R28
	SUBI R26,LOW(-@0)
	SBCI R27,HIGH(-@0)
	LD   R0,X+
	LD   R27,X
	MOV  R26,R0
	SUBI R26,LOW(-@1)
	SBCI R27,HIGH(-@1)
	ST   X+,R30
	ST   X+,R31
	ST   X+,R22
	ST   X,R23
	.ENDM

	.MACRO __MULBRR
	MULS R@0,R@1
	MOVW R30,R0
	.ENDM

	.MACRO __MULBRRU
	MUL  R@0,R@1
	MOVW R30,R0
	.ENDM

	.MACRO __MULBRR0
	MULS R@0,R@1
	.ENDM

	.MACRO __MULBRRU0
	MUL  R@0,R@1
	.ENDM

	.MACRO __MULBNWRU
	LDI  R26,@2
	MUL  R26,R@0
	MOVW R30,R0
	MUL  R26,R@1
	ADD  R31,R0
	.ENDM

;NAME DEFINITIONS FOR GLOBAL VARIABLES ALLOCATED TO REGISTERS
	.DEF _rx_wr_index0=R4
	.DEF _rx_rd_index0=R3
	.DEF _rx_counter0=R6
	.DEF _tx_wr_index0=R5
	.DEF _tx_rd_index0=R8
	.DEF _tx_counter0=R7

	.CSEG
	.ORG 0x00

;START OF CODE MARKER
__START_OF_CODE:

;INTERRUPT VECTORS
	JMP  __RESET
	JMP  0x00
	JMP  0x00
	JMP  0x00
	JMP  0x00
	JMP  0x00
	JMP  0x00
	JMP  0x00
	JMP  0x00
	JMP  0x00
	JMP  0x00
	JMP  0x00
	JMP  _timer1_compa_isr
	JMP  0x00
	JMP  _timer1_ovf_isr
	JMP  0x00
	JMP  0x00
	JMP  0x00
	JMP  _usart0_rx_isr
	JMP  0x00
	JMP  _usart0_tx_isr
	JMP  0x00
	JMP  0x00
	JMP  0x00
	JMP  0x00
	JMP  0x00
	JMP  _timer3_compa_isr
	JMP  0x00
	JMP  0x00
	JMP  0x00
	JMP  0x00
	JMP  0x00
	JMP  0x00
	JMP  0x00
	JMP  0x00

_TxStartSound:
	.DB  0x0,0xC4,0x80,0x52,0x60,0x41,0x0,0xC4
_font4x6:
	.DB  0x0,0x0,0x0,0x0,0x0,0xE,0x15,0xE
	.DB  0x0,0xE,0x1B,0xE,0x0,0xE,0x1C,0xE
	.DB  0x0,0xC,0x1E,0xC,0x0,0x16,0x1F,0x16
	.DB  0x0,0x14,0x1F,0x14,0x0,0x0,0x4,0x0
	.DB  0x3F,0x3F,0x3B,0x3F,0x0,0x0,0x0,0x0
	.DB  0x0,0x0,0x0,0x0,0x0,0x18,0x1A,0x6
	.DB  0x0,0xA,0x1D,0xA,0x0,0x0,0x0,0x0
	.DB  0x0,0x4,0x13,0xE,0x0,0xE,0x1B,0xE
	.DB  0x0,0x1F,0xE,0x4,0x0,0x4,0xE,0x1F
	.DB  0x0,0xA,0x1F,0xA,0x0,0x17,0x0,0x17
	.DB  0x6,0x1F,0x1,0x1F,0x0,0x16,0x1B,0xD
	.DB  0x0,0xC,0xC,0x0,0x0,0x2A,0x3F,0x2A
	.DB  0x0,0x2,0x1F,0x2,0x0,0x8,0x1F,0x8
	.DB  0x4,0x4,0xE,0x4,0x4,0xE,0x4,0x4
	.DB  0x0,0xC,0x8,0x8,0x0,0xE,0x4,0xE
	.DB  0x0,0xC,0xE,0xC,0x0,0x6,0xE,0x6
	.DB  0x0,0x0,0x0,0x0,0x0,0x0,0x17,0x0
	.DB  0x0,0x3,0x0,0x3,0x0,0x1F,0xA,0x1F
	.DB  0x0,0x14,0x3F,0xA,0x0,0x9,0x4,0x12
	.DB  0x0,0x1A,0x15,0x1E,0x0,0x3,0x1,0x0
	.DB  0x0,0xE,0x11,0x0,0x0,0x11,0xE,0x0
	.DB  0x0,0x15,0xE,0x15,0x0,0x4,0xE,0x4
	.DB  0x0,0x30,0x10,0x0,0x0,0x4,0x4,0x4
	.DB  0x0,0x0,0x10,0x0,0x0,0x18,0x4,0x3
	.DB  0x0,0x1E,0x11,0xF,0x0,0x12,0x1F,0x10
	.DB  0x0,0x19,0x15,0x12,0x0,0x11,0x15,0xA
	.DB  0x0,0x6,0x4,0x1F,0x0,0x17,0x15,0x9
	.DB  0x0,0xE,0x15,0x8,0x0,0x1,0x1D,0x7
	.DB  0x0,0xA,0x15,0xA,0x0,0x2,0x15,0xE
	.DB  0x0,0x0,0x14,0x0,0x0,0x30,0x14,0x0
	.DB  0x0,0x4,0xA,0x11,0x0,0x14,0x14,0x14
	.DB  0x0,0x11,0xA,0x4,0x0,0x1,0x15,0x2
	.DB  0x0,0x1F,0x11,0x17,0x0,0x1E,0x5,0x1E
	.DB  0x0,0x1F,0x15,0xA,0x0,0xE,0x11,0x11
	.DB  0x0,0x1F,0x11,0xE,0x0,0x1F,0x15,0x11
	.DB  0x0,0x1F,0x5,0x1,0x0,0xE,0x11,0x1D
	.DB  0x0,0x1F,0x4,0x1F,0x0,0x11,0x1F,0x11
	.DB  0x0,0x8,0x10,0xF,0x0,0x1F,0x4,0x1B
	.DB  0x0,0x1F,0x10,0x10,0x0,0x1F,0x6,0x1F
	.DB  0x0,0x1F,0x2,0x1F,0x0,0xE,0x11,0xE
	.DB  0x0,0x1F,0x5,0x2,0x0,0xE,0x19,0x1E
	.DB  0x0,0x1F,0x5,0x1A,0x0,0x16,0x15,0xD
	.DB  0x0,0x1,0x1F,0x1,0x0,0x1F,0x10,0x1F
	.DB  0x0,0xF,0x10,0xF,0x0,0x1F,0xC,0x1F
	.DB  0x0,0x1B,0x4,0x1B,0x0,0x3,0x1C,0x3
	.DB  0x0,0x19,0x15,0x13,0x0,0x1F,0x11,0x0
	.DB  0x0,0x3,0x4,0x18,0x0,0x11,0x1F,0x0
	.DB  0x0,0x2,0x1,0x2,0x20,0x20,0x20,0x20
	.DB  0x0,0x1,0x3,0x0,0x0,0x18,0x14,0x1C
	.DB  0x0,0x1F,0x14,0x8,0x0,0x8,0x14,0x14
	.DB  0x0,0x8,0x14,0x1F,0x0,0xC,0x1C,0x14
	.DB  0x0,0x4,0x1E,0x5,0x0,0x2C,0x24,0x3C
	.DB  0x0,0x1F,0x4,0x18,0x0,0x0,0x1D,0x0
	.DB  0x0,0x20,0x3D,0x0,0x0,0x1F,0x8,0x14
	.DB  0x0,0x0,0x1F,0x0,0x0,0x1C,0xC,0x1C
	.DB  0x0,0x1C,0x4,0x18,0x0,0x8,0x14,0x8
	.DB  0x0,0x3C,0x14,0x8,0x0,0x8,0x14,0x3C
	.DB  0x0,0x1C,0x4,0x0,0x0,0x10,0x1C,0x4
	.DB  0x0,0x4,0x1E,0x14,0x0,0x1C,0x10,0x1C
	.DB  0x0,0xC,0x10,0xC,0x0,0x1C,0x18,0x1C
	.DB  0x0,0x14,0x8,0x14,0x0,0x2C,0x10,0xC
	.DB  0x0,0x4,0x1C,0x10,0x0,0x4,0x1F,0x11
	.DB  0x0,0x0,0x1F,0x0,0x0,0x11,0x1F,0x4
	.DB  0x2,0x1,0x2,0x1,0x0,0xC,0xA,0xC
	.DB  0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0
	.DB  0x0,0x3,0x1,0x0,0x0,0x0,0x0,0x0
	.DB  0x0,0x3,0x0,0x3,0x0,0x0,0x14,0x0
	.DB  0x4,0x4,0x3F,0x4,0xA,0xA,0x3B,0xA
	.DB  0x0,0x0,0x0,0x0,0x0,0x9,0x4,0x12
	.DB  0x0,0x0,0x0,0x0,0x0,0x4,0xA,0x11
	.DB  0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0
	.DB  0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0
	.DB  0x0,0x0,0x0,0x0,0x0,0x3,0x1,0x0
	.DB  0x0,0x3,0x1,0x0,0x0,0x3,0x0,0x3
	.DB  0x0,0x3,0x0,0x3,0x0,0x0,0x4,0x0
	.DB  0x0,0x4,0x4,0x4,0x0,0x4,0x4,0x4
	.DB  0x0,0x0,0x0,0x0,0x0,0x1,0x1F,0x1
	.DB  0x0,0x0,0x0,0x0,0x0,0x11,0xA,0x4
	.DB  0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0
	.DB  0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0
	.DB  0x0,0x0,0x0,0x0,0x17,0x15,0xF,0x0
	.DB  0x2C,0x12,0xC,0x0,0x0,0x0,0x0,0x0
	.DB  0x1E,0x12,0x1E,0x0,0x0,0x0,0x0,0x0
	.DB  0x0,0x0,0x3F,0x0,0x0,0x16,0x1B,0xD
	.DB  0x1F,0x15,0x11,0x0,0x0,0x8,0x14,0x14
	.DB  0xE,0x15,0x15,0x0,0x0,0x4,0xA,0x11
	.DB  0x4,0x4,0x3C,0x0,0x0,0x4,0x4,0x4
	.DB  0x0,0x1F,0x5,0x1A,0x1,0x1E,0x1,0x0
	.DB  0x0,0x2,0x5,0x2,0x0,0x4,0xE,0x4
	.DB  0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0
	.DB  0x0,0x0,0x0,0x0,0xC,0x8,0x1C,0x0
	.DB  0x6,0x1F,0x1,0x1F,0x0,0x0,0x4,0x0
	.DB  0xD,0x1C,0x15,0x0,0x1F,0xE,0x1F,0x0
	.DB  0x8,0x1C,0x14,0x0,0x0,0x11,0xA,0x4
	.DB  0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0
	.DB  0x0,0x0,0x0,0x0,0x4,0x18,0x4,0x0
	.DB  0x1E,0x5,0x1E,0x0,0x1F,0x15,0x9,0x0
	.DB  0x1F,0x15,0xA,0x0,0x1F,0x1,0x1,0x0
	.DB  0x18,0xF,0x18,0x0,0x1F,0x15,0x11,0x0
	.DB  0x1B,0xE,0x1B,0x0,0x11,0x15,0x1F,0x0
	.DB  0x1F,0xC,0x1F,0x0,0x1F,0xD,0x1F,0x0
	.DB  0x1F,0x6,0x19,0x0,0x1E,0x1,0x1F,0x0
	.DB  0x1F,0x2,0x1F,0x0,0x1F,0x4,0x1F,0x0
	.DB  0xE,0x11,0xE,0x0,0x1F,0x1,0x1F,0x0
	.DB  0x1F,0x5,0x2,0x0,0xE,0x11,0x11,0x0
	.DB  0x1,0x1F,0x1,0x0,0x17,0x14,0xF,0x0
	.DB  0xE,0x1B,0xE,0x0,0x1B,0x4,0x1B,0x0
	.DB  0x1F,0x10,0x1F,0x30,0x7,0x4,0x1F,0x0
	.DB  0x1F,0x1C,0x1F,0x0,0x1F,0x1C,0x1F,0x30
	.DB  0x1,0x1F,0x1C,0x0,0x1F,0x14,0x1F,0x0
	.DB  0x1F,0x14,0x8,0x0,0x11,0x15,0xE,0x0
	.DB  0x1F,0xE,0x1B,0xE,0x1A,0x5,0x1F,0x0
	.DB  0x8,0x14,0x1C,0x0,0x1C,0x1C,0x14,0x0
	.DB  0x1C,0x1C,0x18,0x0,0x1C,0x4,0x4,0x0
	.DB  0x18,0xC,0x18,0x0,0xC,0x1C,0x14,0x0
	.DB  0x14,0x1C,0x14,0x0,0x14,0x1C,0x1C,0x0
	.DB  0x1C,0x8,0x1C,0x0,0x1C,0x9,0x1C,0x0
	.DB  0x1C,0x8,0x14,0x0,0x18,0x4,0x1C,0x0
	.DB  0x1C,0x18,0x1C,0x0,0x1C,0x8,0x1C,0x0
	.DB  0x8,0x14,0x8,0x0,0x1C,0x4,0x1C,0x0
	.DB  0x3C,0x14,0x8,0x0,0x8,0x14,0x14,0x0
	.DB  0x4,0x1C,0x4,0x0,0x2C,0x10,0xC,0x0
	.DB  0x1C,0x34,0x1C,0x0,0x14,0x8,0x14,0x0
	.DB  0x1C,0x10,0x1C,0x30,0xC,0x8,0x1C,0x0
	.DB  0x1C,0x18,0x1C,0x0,0x1C,0x18,0x1C,0x30
	.DB  0x4,0x1C,0x18,0x0,0x1C,0x18,0x1C,0x0
	.DB  0x1C,0x18,0x18,0x0,0x14,0x1C,0x8,0x0
	.DB  0x1C,0x8,0x1C,0x8,0x14,0xC,0x1C,0x0
_font6x8:
	.DB  0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0
	.DB  0x0,0x3E,0x45,0x51,0x45,0x3E,0x0,0x0
	.DB  0x0,0x3E,0x6B,0x6F,0x6B,0x3E,0x0,0x0
	.DB  0x0,0x1C,0x3E,0x7C,0x3E,0x1C,0x0,0x0
	.DB  0x0,0x18,0x3C,0x7E,0x3C,0x18,0x0,0x0
	.DB  0x0,0x30,0x36,0x7F,0x36,0x30,0x0,0x0
	.DB  0x0,0x18,0x5C,0x7E,0x5C,0x18,0x0,0x0
	.DB  0x0,0x0,0x18,0x18,0x0,0x0,0x0,0x0
	.DB  0xFF,0xFF,0xE7,0xE7,0xFF,0xFF,0x0,0x0
	.DB  0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0
	.DB  0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0
	.DB  0x0,0x30,0x48,0x4A,0x36,0xE,0x0,0x0
	.DB  0x0,0x6,0x29,0x79,0x29,0x6,0x0,0x0
	.DB  0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0
	.DB  0x0,0x60,0x7E,0xA,0x35,0x3F,0x0,0x0
	.DB  0x0,0x2A,0x1C,0x36,0x1C,0x2A,0x0,0x0
	.DB  0x0,0x0,0x7F,0x3E,0x1C,0x8,0x0,0x0
	.DB  0x0,0x8,0x1C,0x3E,0x7F,0x0,0x0,0x0
	.DB  0x0,0x14,0x36,0x7F,0x36,0x14,0x0,0x0
	.DB  0x0,0x0,0x5F,0x0,0x5F,0x0,0x0,0x0
	.DB  0x0,0x6,0x9,0x7F,0x1,0x7F,0x0,0x0
	.DB  0x0,0x22,0x4D,0x55,0x59,0x22,0x0,0x0
	.DB  0x0,0x3C,0x3C,0x3C,0x3C,0x0,0x0,0x0
	.DB  0x0,0x14,0xB6,0xFF,0xB6,0x14,0x0,0x0
	.DB  0x0,0x4,0x6,0x7F,0x6,0x4,0x0,0x0
	.DB  0x0,0x10,0x30,0x7F,0x30,0x10,0x0,0x0
	.DB  0x0,0x8,0x8,0x3E,0x1C,0x8,0x0,0x0
	.DB  0x0,0x8,0x1C,0x3E,0x8,0x8,0x0,0x0
	.DB  0x0,0x78,0x40,0x40,0x40,0x40,0x0,0x0
	.DB  0x0,0x8,0x3E,0x8,0x3E,0x8,0x0,0x0
	.DB  0x0,0x30,0x3C,0x3F,0x3C,0x30,0x0,0x0
	.DB  0x0,0x3,0xF,0x3F,0xF,0x3,0x0,0x0
	.DB  0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0
	.DB  0x0,0x0,0x6,0x5F,0x6,0x0,0x0,0x0
	.DB  0x0,0x7,0x3,0x0,0x7,0x3,0x0,0x0
	.DB  0x0,0x24,0x7E,0x24,0x7E,0x24,0x0,0x0
	.DB  0x0,0x24,0x2B,0x6A,0x12,0x0,0x0,0x0
	.DB  0x0,0x63,0x13,0x8,0x64,0x63,0x0,0x0
	.DB  0x0,0x36,0x49,0x56,0x20,0x50,0x0,0x0
	.DB  0x0,0x0,0x7,0x3,0x0,0x0,0x0,0x0
	.DB  0x0,0x0,0x3E,0x41,0x0,0x0,0x0,0x0
	.DB  0x0,0x0,0x41,0x3E,0x0,0x0,0x0,0x0
	.DB  0x0,0x8,0x3E,0x1C,0x3E,0x8,0x0,0x0
	.DB  0x0,0x8,0x8,0x3E,0x8,0x8,0x0,0x0
	.DB  0x0,0x0,0xE0,0x60,0x0,0x0,0x0,0x0
	.DB  0x0,0x8,0x8,0x8,0x8,0x8,0x0,0x0
	.DB  0x0,0x0,0x60,0x60,0x0,0x0,0x0,0x0
	.DB  0x0,0x20,0x10,0x8,0x4,0x2,0x0,0x0
	.DB  0x0,0x3E,0x51,0x49,0x45,0x3E,0x0,0x0
	.DB  0x0,0x0,0x42,0x7F,0x40,0x0,0x0,0x0
	.DB  0x0,0x62,0x51,0x49,0x49,0x46,0x0,0x0
	.DB  0x0,0x22,0x49,0x49,0x49,0x36,0x0,0x0
	.DB  0x0,0x18,0x14,0x12,0x7F,0x10,0x0,0x0
	.DB  0x0,0x2F,0x49,0x49,0x49,0x31,0x0,0x0
	.DB  0x0,0x3C,0x4A,0x49,0x49,0x30,0x0,0x0
	.DB  0x0,0x1,0x71,0x9,0x5,0x3,0x0,0x0
	.DB  0x0,0x36,0x49,0x49,0x49,0x36,0x0,0x0
	.DB  0x0,0x6,0x49,0x49,0x29,0x1E,0x0,0x0
	.DB  0x0,0x0,0x6C,0x6C,0x0,0x0,0x0,0x0
	.DB  0x0,0x0,0xEC,0x6C,0x0,0x0,0x0,0x0
	.DB  0x0,0x8,0x14,0x22,0x41,0x0,0x0,0x0
	.DB  0x0,0x24,0x24,0x24,0x24,0x24,0x0,0x0
	.DB  0x0,0x0,0x41,0x22,0x14,0x8,0x0,0x0
	.DB  0x0,0x2,0x1,0x59,0x9,0x6,0x0,0x0
	.DB  0x0,0x3E,0x41,0x5D,0x55,0x1E,0x0,0x0
	.DB  0x0,0x7E,0x11,0x11,0x11,0x7E,0x0,0x0
	.DB  0x0,0x7F,0x49,0x49,0x49,0x36,0x0,0x0
	.DB  0x0,0x3E,0x41,0x41,0x41,0x22,0x0,0x0
	.DB  0x0,0x7F,0x41,0x41,0x41,0x3E,0x0,0x0
	.DB  0x0,0x7F,0x49,0x49,0x49,0x41,0x0,0x0
	.DB  0x0,0x7F,0x9,0x9,0x9,0x1,0x0,0x0
	.DB  0x0,0x3E,0x41,0x49,0x49,0x7A,0x0,0x0
	.DB  0x0,0x7F,0x8,0x8,0x8,0x7F,0x0,0x0
	.DB  0x0,0x0,0x41,0x7F,0x41,0x0,0x0,0x0
	.DB  0x0,0x30,0x40,0x40,0x40,0x3F,0x0,0x0
	.DB  0x0,0x7F,0x8,0x14,0x22,0x41,0x0,0x0
	.DB  0x0,0x7F,0x40,0x40,0x40,0x40,0x0,0x0
	.DB  0x0,0x7F,0x2,0x4,0x2,0x7F,0x0,0x0
	.DB  0x0,0x7F,0x2,0x4,0x8,0x7F,0x0,0x0
	.DB  0x0,0x3E,0x41,0x41,0x41,0x3E,0x0,0x0
	.DB  0x0,0x7F,0x9,0x9,0x9,0x6,0x0,0x0
	.DB  0x0,0x3E,0x41,0x51,0x21,0x5E,0x0,0x0
	.DB  0x0,0x7F,0x9,0x9,0x19,0x66,0x0,0x0
	.DB  0x0,0x26,0x49,0x49,0x49,0x32,0x0,0x0
	.DB  0x0,0x1,0x1,0x7F,0x1,0x1,0x0,0x0
	.DB  0x0,0x3F,0x40,0x40,0x40,0x3F,0x0,0x0
	.DB  0x0,0x1F,0x20,0x40,0x20,0x1F,0x0,0x0
	.DB  0x0,0x3F,0x40,0x3C,0x40,0x3F,0x0,0x0
	.DB  0x0,0x63,0x14,0x8,0x14,0x63,0x0,0x0
	.DB  0x0,0x7,0x8,0x70,0x8,0x7,0x0,0x0
	.DB  0x0,0x71,0x49,0x45,0x43,0x0,0x0,0x0
	.DB  0x0,0x0,0x7F,0x41,0x41,0x0,0x0,0x0
	.DB  0x0,0x2,0x4,0x8,0x10,0x20,0x0,0x0
	.DB  0x0,0x0,0x41,0x41,0x7F,0x0,0x0,0x0
	.DB  0x0,0x4,0x2,0x1,0x2,0x4,0x0,0x0
	.DB  0x40,0x40,0x40,0x40,0x40,0x40,0x0,0x0
	.DB  0x0,0x0,0x3,0x7,0x0,0x0,0x0,0x0
	.DB  0x0,0x20,0x54,0x54,0x54,0x78,0x0,0x0
	.DB  0x0,0x7F,0x44,0x44,0x44,0x38,0x0,0x0
	.DB  0x0,0x38,0x44,0x44,0x44,0x28,0x0,0x0
	.DB  0x0,0x38,0x44,0x44,0x44,0x7F,0x0,0x0
	.DB  0x0,0x38,0x54,0x54,0x54,0x8,0x0,0x0
	.DB  0x0,0x8,0x7E,0x9,0x9,0x0,0x0,0x0
	.DB  0x0,0x18,0xA4,0xA4,0xA4,0x7C,0x0,0x0
	.DB  0x0,0x7F,0x4,0x4,0x78,0x0,0x0,0x0
	.DB  0x0,0x0,0x0,0x7D,0x40,0x0,0x0,0x0
	.DB  0x0,0x40,0x80,0x84,0x7D,0x0,0x0,0x0
	.DB  0x0,0x7F,0x10,0x28,0x44,0x0,0x0,0x0
	.DB  0x0,0x0,0x0,0x7F,0x40,0x0,0x0,0x0
	.DB  0x0,0x7C,0x4,0x18,0x4,0x78,0x0,0x0
	.DB  0x0,0x7C,0x4,0x4,0x78,0x0,0x0,0x0
	.DB  0x0,0x38,0x44,0x44,0x44,0x38,0x0,0x0
	.DB  0x0,0xFC,0x44,0x44,0x44,0x38,0x0,0x0
	.DB  0x0,0x38,0x44,0x44,0x44,0xFC,0x0,0x0
	.DB  0x0,0x44,0x78,0x44,0x4,0x8,0x0,0x0
	.DB  0x0,0x8,0x54,0x54,0x54,0x20,0x0,0x0
	.DB  0x0,0x4,0x3E,0x44,0x24,0x0,0x0,0x0
	.DB  0x0,0x3C,0x40,0x20,0x7C,0x0,0x0,0x0
	.DB  0x0,0x1C,0x20,0x40,0x20,0x1C,0x0,0x0
	.DB  0x0,0x3C,0x60,0x30,0x60,0x3C,0x0,0x0
	.DB  0x0,0x6C,0x10,0x10,0x6C,0x0,0x0,0x0
	.DB  0x0,0x9C,0xA0,0x60,0x3C,0x0,0x0,0x0
	.DB  0x0,0x64,0x54,0x54,0x4C,0x0,0x0,0x0
	.DB  0x0,0x8,0x3E,0x41,0x41,0x0,0x0,0x0
	.DB  0x0,0x0,0x0,0x77,0x0,0x0,0x0,0x0
	.DB  0x0,0x0,0x41,0x41,0x3E,0x8,0x0,0x0
	.DB  0x0,0x2,0x1,0x2,0x1,0x0,0x0,0x0
	.DB  0x0,0x3C,0x26,0x23,0x26,0x3C,0x0,0x0
	.DB  0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0
	.DB  0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0
	.DB  0x0,0x0,0x7,0x3,0x0,0x0,0x0,0x0
	.DB  0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0
	.DB  0x0,0x7,0x3,0x0,0x7,0x3,0x0,0x0
	.DB  0x0,0x0,0x6C,0x6C,0x0,0x0,0x0,0x0
	.DB  0x8,0x8,0x8,0xFF,0x8,0x8,0x0,0x0
	.DB  0xA,0xA,0xA,0xFF,0xA,0xA,0x0,0x0
	.DB  0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0
	.DB  0x0,0x63,0x13,0x8,0x64,0x63,0x0,0x0
	.DB  0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0
	.DB  0x0,0x8,0x14,0x22,0x41,0x0,0x0,0x0
	.DB  0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0
	.DB  0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0
	.DB  0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0
	.DB  0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0
	.DB  0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0
	.DB  0x0,0x0,0x7,0x3,0x0,0x0,0x0,0x0
	.DB  0x0,0x0,0x7,0x3,0x0,0x0,0x0,0x0
	.DB  0x0,0x7,0x3,0x0,0x7,0x3,0x0,0x0
	.DB  0x0,0x7,0x3,0x0,0x7,0x3,0x0,0x0
	.DB  0x0,0x0,0x18,0x18,0x0,0x0,0x0,0x0
	.DB  0x0,0x8,0x8,0x8,0x8,0x8,0x0,0x0
	.DB  0x0,0x8,0x8,0x8,0x8,0x8,0x0,0x0
	.DB  0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0
	.DB  0x0,0x1,0x1,0x7F,0x1,0x1,0x0,0x0
	.DB  0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0
	.DB  0x0,0x0,0x41,0x22,0x14,0x8,0x0,0x0
	.DB  0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0
	.DB  0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0
	.DB  0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0
	.DB  0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0
	.DB  0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0
	.DB  0x0,0x27,0x48,0x4B,0x48,0x3F,0x0,0x0
	.DB  0x0,0x9C,0xA1,0x61,0x3C,0x0,0x0,0x0
	.DB  0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0
	.DB  0x2A,0x3E,0x14,0x14,0x3E,0x2A,0x0,0x0
	.DB  0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0
	.DB  0x0,0x0,0x0,0xFF,0x0,0x0,0x0,0x0
	.DB  0x0,0x22,0x4D,0x55,0x59,0x22,0x0,0x0
	.DB  0x0,0x7E,0x4B,0x4A,0x4B,0x42,0x0,0x0
	.DB  0x0,0x38,0x44,0x44,0x44,0x28,0x0,0x0
	.DB  0x0,0x3E,0x49,0x49,0x41,0x22,0x0,0x0
	.DB  0x0,0x8,0x14,0x22,0x41,0x0,0x0,0x0
	.DB  0x8,0x8,0x8,0xF8,0x0,0x0,0x0,0x0
	.DB  0x0,0x8,0x8,0x8,0x8,0x8,0x0,0x0
	.DB  0x0,0x7F,0x9,0x9,0x19,0x66,0x0,0x0
	.DB  0x0,0x1,0x40,0x7E,0x40,0x1,0x0,0x0
	.DB  0x0,0x6,0x9,0x9,0x6,0x0,0x0,0x0
	.DB  0x0,0x8,0x8,0x3E,0x8,0x8,0x0,0x0
	.DB  0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0
	.DB  0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0
	.DB  0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0
	.DB  0x0,0xC,0x10,0x10,0x10,0x7C,0x0,0x0
	.DB  0x0,0x6,0x9,0x7F,0x1,0x7F,0x0,0x0
	.DB  0x0,0x0,0x8,0x0,0x0,0x0,0x0,0x0
	.DB  0x0,0x38,0x55,0x54,0x55,0x8,0x0,0x0
	.DB  0x7F,0x6,0x18,0x7F,0x13,0x13,0x0,0x0
	.DB  0x0,0x38,0x54,0x54,0x44,0x28,0x0,0x0
	.DB  0x0,0x0,0x41,0x22,0x14,0x8,0x0,0x0
	.DB  0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0
	.DB  0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0
	.DB  0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0
	.DB  0x0,0x0,0x1,0x7C,0x41,0x0,0x0,0x0
	.DB  0x0,0x7E,0x11,0x11,0x11,0x7E,0x0,0x0
	.DB  0x0,0x7F,0x49,0x49,0x49,0x31,0x0,0x0
	.DB  0x0,0x7F,0x49,0x49,0x49,0x36,0x0,0x0
	.DB  0x0,0x7F,0x1,0x1,0x1,0x1,0x0,0x0
	.DB  0x60,0x3E,0x21,0x21,0x3F,0x60,0x0,0x0
	.DB  0x0,0x7F,0x49,0x49,0x49,0x41,0x0,0x0
	.DB  0x0,0x77,0x8,0x7F,0x8,0x77,0x0,0x0
	.DB  0x22,0x49,0x49,0x49,0x36,0x0,0x0,0x0
	.DB  0x0,0x7F,0x20,0x10,0x8,0x7F,0x0,0x0
	.DB  0x0,0x7F,0x20,0x13,0x8,0x7F,0x0,0x0
	.DB  0x0,0x7F,0x8,0x14,0x22,0x41,0x0,0x0
	.DB  0x0,0x40,0x7E,0x1,0x1,0x7F,0x0,0x0
	.DB  0x0,0x7F,0x2,0x4,0x2,0x7F,0x0,0x0
	.DB  0x0,0x7F,0x8,0x8,0x8,0x7F,0x0,0x0
	.DB  0x0,0x3E,0x41,0x41,0x41,0x3E,0x0,0x0
	.DB  0x0,0x7F,0x1,0x1,0x1,0x7F,0x0,0x0
	.DB  0x0,0x7F,0x9,0x9,0x9,0x6,0x0,0x0
	.DB  0x0,0x3E,0x41,0x41,0x41,0x22,0x0,0x0
	.DB  0x0,0x1,0x1,0x7F,0x1,0x1,0x0,0x0
	.DB  0x0,0x27,0x48,0x48,0x48,0x3F,0x0,0x0
	.DB  0x0,0xE,0x11,0x7F,0x11,0xE,0x0,0x0
	.DB  0x0,0x63,0x14,0x8,0x14,0x63,0x0,0x0
	.DB  0x0,0x7F,0x40,0x40,0x7F,0xC0,0x0,0x0
	.DB  0x0,0x7,0x8,0x8,0x8,0x7F,0x0,0x0
	.DB  0x0,0x7F,0x40,0x7F,0x40,0x7F,0x0,0x0
	.DB  0x0,0x7F,0x40,0x7F,0x40,0xFF,0x0,0x0
	.DB  0x3,0x1,0x7F,0x48,0x48,0x30,0x0,0x0
	.DB  0x0,0x7F,0x48,0x48,0x30,0x7F,0x0,0x0
	.DB  0x0,0x7F,0x48,0x48,0x48,0x30,0x0,0x0
	.DB  0x0,0x22,0x41,0x49,0x49,0x3E,0x0,0x0
	.DB  0x0,0x7F,0x8,0x3E,0x41,0x3E,0x0,0x0
	.DB  0x0,0x66,0x19,0x9,0x9,0x7F,0x0,0x0
	.DB  0x0,0x20,0x54,0x54,0x54,0x78,0x0,0x0
	.DB  0x0,0x3C,0x4A,0x4A,0x4A,0x31,0x0,0x0
	.DB  0x0,0x7C,0x54,0x54,0x54,0x28,0x0,0x0
	.DB  0x0,0x7C,0x4,0x4,0xC,0x0,0x0,0x0
	.DB  0x60,0x38,0x24,0x24,0x3C,0x60,0x0,0x0
	.DB  0x0,0x38,0x54,0x54,0x54,0x8,0x0,0x0
	.DB  0x0,0x6C,0x10,0x7C,0x10,0x6C,0x0,0x0
	.DB  0x0,0x28,0x44,0x54,0x54,0x28,0x0,0x0
	.DB  0x0,0x7C,0x20,0x10,0x8,0x7C,0x0,0x0
	.DB  0x0,0x7C,0x20,0x12,0xA,0x7C,0x0,0x0
	.DB  0x0,0x7C,0x10,0x28,0x44,0x0,0x0,0x0
	.DB  0x40,0x38,0x4,0x4,0x7C,0x0,0x0,0x0
	.DB  0x0,0x7C,0x8,0x10,0x8,0x7C,0x0,0x0
	.DB  0x0,0x7C,0x10,0x10,0x10,0x7C,0x0,0x0
	.DB  0x0,0x38,0x44,0x44,0x44,0x38,0x0,0x0
	.DB  0x0,0x7C,0x4,0x4,0x4,0x7C,0x0,0x0
	.DB  0x0,0xFC,0x44,0x44,0x44,0x38,0x0,0x0
	.DB  0x0,0x38,0x44,0x44,0x44,0x28,0x0,0x0
	.DB  0x0,0x4,0x4,0x7C,0x4,0x4,0x0,0x0
	.DB  0x0,0x9C,0xA0,0x60,0x3C,0x0,0x0,0x0
	.DB  0x0,0x18,0x24,0x7C,0x24,0x18,0x0,0x0
	.DB  0x0,0x6C,0x10,0x10,0x6C,0x0,0x0,0x0
	.DB  0x0,0x7C,0x40,0x40,0x7C,0xC0,0x0,0x0
	.DB  0x0,0xC,0x10,0x10,0x10,0x7C,0x0,0x0
	.DB  0x0,0x7C,0x40,0x7C,0x40,0x7C,0x0,0x0
	.DB  0x0,0x7C,0x40,0x7C,0x40,0xFC,0x0,0x0
	.DB  0xC,0x4,0x7C,0x50,0x50,0x20,0x0,0x0
	.DB  0x0,0x7C,0x50,0x50,0x20,0x7C,0x0,0x0
	.DB  0x0,0x7C,0x50,0x50,0x50,0x20,0x0,0x0
	.DB  0x0,0x28,0x44,0x54,0x54,0x38,0x0,0x0
	.DB  0x0,0x7C,0x10,0x38,0x44,0x38,0x0,0x0
	.DB  0x0,0x48,0x34,0x14,0x14,0x7C,0x0,0x0
_font8x8:
	.DB  0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0
	.DB  0x7E,0x81,0x95,0xB1,0xB1,0x95,0x81,0x7E
	.DB  0x7E,0xFF,0xEB,0xCF,0xCF,0xEB,0xFF,0x7E
	.DB  0xE,0x1F,0x3F,0x7E,0x3F,0x1F,0xE,0x0
	.DB  0x8,0x1C,0x3E,0x7F,0x3E,0x1C,0x8,0x0
	.DB  0x38,0x3A,0x9F,0xFF,0x9F,0x3A,0x38,0x0
	.DB  0x10,0x38,0xBC,0xFF,0xBC,0x38,0x10,0x0
	.DB  0x0,0x0,0x18,0x3C,0x3C,0x18,0x0,0x0
	.DB  0xFF,0xFF,0xE7,0xC3,0xC3,0xE7,0xFF,0xFF
	.DB  0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0
	.DB  0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0
	.DB  0x70,0xF8,0x88,0x88,0xFD,0x7F,0x7,0xF
	.DB  0x0,0x4E,0x5F,0xF1,0xF1,0x5F,0x4E,0x0
	.DB  0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0
	.DB  0xC0,0xFF,0x7F,0x5,0x5,0x65,0x7F,0x3F
	.DB  0x99,0x5A,0x3C,0xE7,0xE7,0x3C,0x5A,0x99
	.DB  0x7F,0x3E,0x3E,0x1C,0x1C,0x8,0x8,0x0
	.DB  0x8,0x8,0x1C,0x1C,0x3E,0x3E,0x7F,0x0
	.DB  0x0,0x24,0x66,0xFF,0xFF,0x66,0x24,0x0
	.DB  0x0,0x5F,0x5F,0x0,0x0,0x5F,0x5F,0x0
	.DB  0x6,0xF,0x9,0x7F,0x7F,0x1,0x7F,0x7F
	.DB  0xDA,0xBF,0xA5,0xA5,0xFD,0x59,0x3,0x2
	.DB  0x0,0x0,0x3C,0x3C,0x3C,0x3C,0x0,0x0
	.DB  0x80,0x94,0xB6,0xFF,0xFF,0xB6,0x94,0x80
	.DB  0x0,0x4,0x6,0x7F,0x7F,0x6,0x4,0x0
	.DB  0x0,0x10,0x30,0x7F,0x7F,0x30,0x10,0x0
	.DB  0x8,0x8,0x8,0x2A,0x3E,0x1C,0x8,0x0
	.DB  0x8,0x1C,0x3E,0x2A,0x8,0x8,0x8,0x0
	.DB  0x3C,0x3C,0x20,0x20,0x20,0x20,0x20,0x0
	.DB  0x8,0x1C,0x3E,0x8,0x8,0x3E,0x1C,0x8
	.DB  0x30,0x38,0x3C,0x3E,0x3E,0x3C,0x38,0x30
	.DB  0x6,0xE,0x1E,0x3E,0x3E,0x1E,0xE,0x6
	.DB  0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0
	.DB  0x0,0x6,0x5F,0x5F,0x6,0x0,0x0,0x0
	.DB  0x0,0x7,0x7,0x0,0x7,0x7,0x0,0x0
	.DB  0x14,0x7F,0x7F,0x14,0x7F,0x7F,0x14,0x0
	.DB  0x24,0x2E,0x6B,0x6B,0x3A,0x12,0x0,0x0
	.DB  0x46,0x66,0x30,0x18,0xC,0x66,0x62,0x0
	.DB  0x30,0x7A,0x4F,0x5D,0x37,0x7A,0x48,0x0
	.DB  0x4,0x7,0x3,0x0,0x0,0x0,0x0,0x0
	.DB  0x0,0x1C,0x3E,0x63,0x41,0x0,0x0,0x0
	.DB  0x0,0x41,0x63,0x3E,0x1C,0x0,0x0,0x0
	.DB  0x8,0x2A,0x3E,0x1C,0x1C,0x3E,0x2A,0x8
	.DB  0x8,0x8,0x3E,0x3E,0x8,0x8,0x0,0x0
	.DB  0x0,0xA0,0xE0,0x60,0x0,0x0,0x0,0x0
	.DB  0x8,0x8,0x8,0x8,0x8,0x8,0x0,0x0
	.DB  0x0,0x0,0x60,0x60,0x0,0x0,0x0,0x0
	.DB  0x60,0x30,0x18,0xC,0x6,0x3,0x1,0x0
	.DB  0x3E,0x7F,0x59,0x4D,0x7F,0x3E,0x0,0x0
	.DB  0x42,0x42,0x7F,0x7F,0x40,0x40,0x0,0x0
	.DB  0x62,0x73,0x59,0x49,0x6F,0x66,0x0,0x0
	.DB  0x22,0x63,0x49,0x49,0x7F,0x36,0x0,0x0
	.DB  0x18,0x1C,0x16,0x13,0x7F,0x7F,0x10,0x0
	.DB  0x27,0x67,0x45,0x45,0x7D,0x39,0x0,0x0
	.DB  0x3C,0x7E,0x4B,0x49,0x79,0x30,0x0,0x0
	.DB  0x3,0x63,0x71,0x19,0xF,0x7,0x0,0x0
	.DB  0x36,0x7F,0x49,0x49,0x7F,0x36,0x0,0x0
	.DB  0x6,0x4F,0x49,0x69,0x3F,0x1E,0x0,0x0
	.DB  0x0,0x0,0x6C,0x6C,0x0,0x0,0x0,0x0
	.DB  0x0,0xA0,0xEC,0x6C,0x0,0x0,0x0,0x0
	.DB  0x8,0x1C,0x36,0x63,0x41,0x0,0x0,0x0
	.DB  0x14,0x14,0x14,0x14,0x14,0x14,0x0,0x0
	.DB  0x0,0x41,0x63,0x36,0x1C,0x8,0x0,0x0
	.DB  0x2,0x3,0x51,0x59,0xF,0x6,0x0,0x0
	.DB  0x3E,0x7F,0x41,0x5D,0x5D,0x1F,0x1E,0x0
	.DB  0x7C,0x7E,0x13,0x13,0x7E,0x7C,0x0,0x0
	.DB  0x41,0x7F,0x7F,0x49,0x49,0x7F,0x36,0x0
	.DB  0x1C,0x3E,0x63,0x41,0x41,0x63,0x22,0x0
	.DB  0x41,0x7F,0x7F,0x41,0x63,0x7F,0x1C,0x0
	.DB  0x41,0x7F,0x7F,0x49,0x5D,0x41,0x63,0x0
	.DB  0x41,0x7F,0x7F,0x49,0x1D,0x1,0x3,0x0
	.DB  0x1C,0x3E,0x63,0x41,0x51,0x73,0x72,0x0
	.DB  0x7F,0x7F,0x8,0x8,0x7F,0x7F,0x0,0x0
	.DB  0x0,0x41,0x7F,0x7F,0x41,0x0,0x0,0x0
	.DB  0x30,0x70,0x40,0x41,0x7F,0x3F,0x1,0x0
	.DB  0x41,0x7F,0x7F,0x8,0x1C,0x77,0x63,0x0
	.DB  0x41,0x7F,0x7F,0x41,0x40,0x60,0x70,0x0
	.DB  0x7F,0x7F,0x6,0xC,0x6,0x7F,0x7F,0x0
	.DB  0x7F,0x7F,0x6,0xC,0x18,0x7F,0x7F,0x0
	.DB  0x1C,0x3E,0x63,0x41,0x63,0x3E,0x1C,0x0
	.DB  0x41,0x7F,0x7F,0x49,0x9,0xF,0x6,0x0
	.DB  0x1E,0x3F,0x21,0x71,0x7F,0x5E,0x0,0x0
	.DB  0x41,0x7F,0x7F,0x19,0x39,0x6F,0x46,0x0
	.DB  0x26,0x67,0x4D,0x59,0x7B,0x32,0x0,0x0
	.DB  0x3,0x41,0x7F,0x7F,0x41,0x3,0x0,0x0
	.DB  0x7F,0x7F,0x40,0x40,0x7F,0x7F,0x0,0x0
	.DB  0x1F,0x3F,0x60,0x60,0x3F,0x1F,0x0,0x0
	.DB  0x7F,0x7F,0x30,0x18,0x30,0x7F,0x7F,0x0
	.DB  0x63,0x77,0x1C,0x8,0x1C,0x77,0x63,0x0
	.DB  0x7,0x4F,0x78,0x78,0x4F,0x7,0x0,0x0
	.DB  0x67,0x73,0x59,0x4D,0x47,0x63,0x71,0x0
	.DB  0x0,0x7F,0x7F,0x41,0x41,0x0,0x0,0x0
	.DB  0x1,0x3,0x6,0xC,0x18,0x30,0x60,0x0
	.DB  0x0,0x41,0x41,0x7F,0x7F,0x0,0x0,0x0
	.DB  0x8,0xC,0x6,0x3,0x6,0xC,0x8,0x0
	.DB  0x40,0x40,0x40,0x40,0x40,0x40,0x40,0x40
	.DB  0x0,0x0,0x3,0x7,0x4,0x0,0x0,0x0
	.DB  0x20,0x74,0x54,0x54,0x3C,0x78,0x40,0x0
	.DB  0x41,0x3F,0x7F,0x44,0x44,0x7C,0x38,0x0
	.DB  0x38,0x7C,0x44,0x44,0x6C,0x28,0x0,0x0
	.DB  0x30,0x78,0x48,0x49,0x3F,0x7F,0x40,0x0
	.DB  0x38,0x7C,0x54,0x54,0x5C,0x18,0x0,0x0
	.DB  0x48,0x7E,0x7F,0x49,0x3,0x2,0x0,0x0
	.DB  0x98,0xBC,0xA4,0xA4,0xF8,0x7C,0x4,0x0
	.DB  0x41,0x7F,0x7F,0x8,0x4,0x7C,0x78,0x0
	.DB  0x0,0x44,0x7D,0x7D,0x40,0x0,0x0,0x0
	.DB  0x40,0xC4,0x84,0xFD,0x7D,0x0,0x0,0x0
	.DB  0x41,0x7F,0x7F,0x10,0x38,0x6C,0x44,0x0
	.DB  0x0,0x41,0x7F,0x7F,0x40,0x0,0x0,0x0
	.DB  0x7C,0x7C,0xC,0x18,0xC,0x7C,0x78,0x0
	.DB  0x7C,0x7C,0x4,0x4,0x7C,0x78,0x0,0x0
	.DB  0x38,0x7C,0x44,0x44,0x7C,0x38,0x0,0x0
	.DB  0x84,0xFC,0xF8,0xA4,0x24,0x3C,0x18,0x0
	.DB  0x18,0x3C,0x24,0xA4,0xF8,0xFC,0x84,0x0
	.DB  0x44,0x7C,0x78,0x44,0x1C,0x18,0x0,0x0
	.DB  0x48,0x5C,0x54,0x54,0x74,0x24,0x0,0x0
	.DB  0x0,0x4,0x3E,0x7F,0x44,0x24,0x0,0x0
	.DB  0x3C,0x7C,0x40,0x40,0x3C,0x7C,0x40,0x0
	.DB  0x1C,0x3C,0x60,0x60,0x3C,0x1C,0x0,0x0
	.DB  0x3C,0x7C,0x60,0x30,0x60,0x7C,0x3C,0x0
	.DB  0x44,0x6C,0x38,0x10,0x38,0x6C,0x44,0x0
	.DB  0x9C,0xBC,0xA0,0xA0,0xFC,0x7C,0x0,0x0
	.DB  0x4C,0x64,0x74,0x5C,0x4C,0x64,0x0,0x0
	.DB  0xFF,0x81,0x81,0x81,0x81,0x81,0x81,0xFF
	.DB  0xFF,0x81,0xBD,0xBD,0xBD,0xBD,0x81,0xFF
	.DB  0x1,0x31,0x79,0x79,0x7D,0x7F,0x7D,0x31
	.DB  0x11,0x11,0x11,0x10,0x10,0x10,0x38,0x10
	.DB  0x3E,0x8,0x1C,0x1C,0x7C,0x3E,0x1E,0x1E
	.DB  0x1E,0x1C,0x18,0x18,0x18,0x1C,0xE,0xE
	.DB  0xF0,0x8,0x4,0x2,0x1,0x51,0xF1,0xF1
	.DB  0xFD,0xF1,0xF1,0x71,0x1A,0xC,0x8,0xF0
	.DB  0xF,0x10,0x24,0x74,0x9C,0x8E,0x9F,0x9F
	.DB  0x9F,0x9F,0x9F,0x9E,0x40,0x20,0x10,0xF
	.DB  0x0,0x0,0x6C,0x6C,0x0,0x0,0x0,0x0
	.DB  0x10,0x10,0x10,0xFF,0xFF,0x10,0x10,0x10
	.DB  0x14,0x14,0x14,0xFF,0xFF,0x14,0x14,0x14
	.DB  0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0
	.DB  0x46,0x66,0x30,0x18,0xC,0x66,0x62,0x0
	.DB  0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0
	.DB  0x8,0x1C,0x36,0x63,0x41,0x0,0x0,0x0
	.DB  0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0
	.DB  0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0
	.DB  0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0
	.DB  0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0
	.DB  0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0
	.DB  0x4,0x7,0x3,0x0,0x0,0x0,0x0,0x0
	.DB  0x4,0x7,0x3,0x0,0x0,0x0,0x0,0x0
	.DB  0x0,0x7,0x7,0x0,0x7,0x7,0x0,0x0
	.DB  0x0,0x7,0x7,0x0,0x7,0x7,0x0,0x0
	.DB  0x0,0x0,0x18,0x3C,0x3C,0x18,0x0,0x0
	.DB  0x8,0x8,0x8,0x8,0x8,0x8,0x0,0x0
	.DB  0x8,0x8,0x8,0x8,0x8,0x8,0x0,0x0
	.DB  0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0
	.DB  0x3,0x41,0x7F,0x7F,0x41,0x3,0x0,0x0
	.DB  0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0
	.DB  0x0,0x41,0x63,0x36,0x1C,0x8,0x0,0x0
	.DB  0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0
	.DB  0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0
	.DB  0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0
	.DB  0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0
	.DB  0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0
	.DB  0x26,0x6E,0x48,0x49,0x48,0x7E,0x3E,0x0
	.DB  0x1F,0xBF,0xA0,0xA3,0xA0,0xFF,0x7F,0x0
	.DB  0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0
	.DB  0x5A,0x7E,0x24,0x24,0x24,0x7E,0x5A,0x0
	.DB  0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0
	.DB  0x0,0x0,0x0,0xFF,0xFF,0x0,0x0,0x0
	.DB  0xDA,0xBF,0xA5,0xA5,0xFD,0x59,0x3,0x2
	.DB  0x42,0x7F,0x7F,0x4A,0x4B,0x43,0x66,0x0
	.DB  0x38,0x7C,0x44,0x44,0x6C,0x28,0x0,0x0
	.DB  0x1C,0x3E,0x6B,0x49,0x49,0x63,0x22,0x0
	.DB  0x8,0x1C,0x36,0x63,0x41,0x0,0x0,0x0
	.DB  0x10,0x10,0x10,0xF0,0xF0,0x0,0x0,0x0
	.DB  0x8,0x8,0x8,0x8,0x8,0x8,0x0,0x0
	.DB  0x41,0x7F,0x7F,0x19,0x39,0x6F,0x46,0x0
	.DB  0x1,0x41,0x7E,0x7E,0x41,0x1,0x0,0x0
	.DB  0x0,0x6,0xF,0x9,0xF,0x6,0x0,0x0
	.DB  0x8,0x8,0x3E,0x3E,0x8,0x8,0x0,0x0
	.DB  0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0
	.DB  0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0
	.DB  0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0
	.DB  0xC,0x1C,0x10,0x10,0x10,0x7C,0x7C,0x0
	.DB  0x6,0xF,0x9,0x7F,0x7F,0x1,0x7F,0x7F
	.DB  0x0,0x0,0x0,0x10,0x10,0x0,0x0,0x0
	.DB  0x39,0x7D,0x54,0x54,0x5D,0x19,0x0,0x0
	.DB  0x7F,0x7E,0xC,0x18,0x7F,0x7F,0x9,0x0
	.DB  0x38,0x7C,0x54,0x54,0x44,0x6C,0x28,0x0
	.DB  0x0,0x41,0x63,0x36,0x1C,0x8,0x0,0x0
	.DB  0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0
	.DB  0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0
	.DB  0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0
	.DB  0x1,0x45,0x7C,0x7C,0x41,0x1,0x0,0x0
	.DB  0x7C,0x7E,0x13,0x11,0x11,0x7F,0x7F,0x0
	.DB  0x41,0x7F,0x7F,0x49,0x49,0x7B,0x33,0x0
	.DB  0x41,0x7F,0x7F,0x49,0x49,0x7F,0x36,0x0
	.DB  0x41,0x7F,0x7F,0x41,0x1,0x3,0x3,0x0
	.DB  0xC0,0xFC,0x7E,0x43,0x41,0x7F,0xFF,0xC0
	.DB  0x41,0x7F,0x7F,0x49,0x5D,0x41,0x63,0x0
	.DB  0x63,0x77,0x1C,0x7F,0x1C,0x77,0x63,0x0
	.DB  0x22,0x63,0x49,0x49,0x7F,0x36,0x0,0x0
	.DB  0x7F,0x7F,0x30,0x18,0xC,0x7F,0x7F,0x0
	.DB  0x7F,0x7F,0x30,0x19,0xC,0x7F,0x7F,0x0
	.DB  0x41,0x7F,0x7F,0x8,0x1C,0x77,0x63,0x0
	.DB  0x40,0x7E,0x3E,0x3,0x1,0x7F,0x7F,0x0
	.DB  0x7F,0x7F,0x6,0xC,0x6,0x7F,0x7F,0x0
	.DB  0x7F,0x7F,0x8,0x8,0x8,0x7F,0x7F,0x0
	.DB  0x1C,0x3E,0x63,0x41,0x63,0x3E,0x1C,0x0
	.DB  0x7F,0x7F,0x1,0x1,0x1,0x7F,0x7F,0x0
	.DB  0x41,0x7F,0x7F,0x49,0x9,0xF,0x6,0x0
	.DB  0x1C,0x3E,0x63,0x41,0x41,0x63,0x22,0x0
	.DB  0x3,0x41,0x7F,0x7F,0x41,0x3,0x0,0x0
	.DB  0x27,0x6F,0x48,0x48,0x48,0x7F,0x3F,0x0
	.DB  0xE,0x1F,0x51,0x7F,0x51,0x1F,0xE,0x0
	.DB  0x63,0x77,0x1C,0x8,0x1C,0x77,0x63,0x0
	.DB  0x7F,0x7F,0x40,0x40,0x7F,0xFF,0xC0,0x0
	.DB  0x7,0xF,0x8,0x8,0x8,0x7F,0x7F,0x0
	.DB  0x7F,0x7F,0x40,0x7F,0x40,0x7F,0x7F,0x0
	.DB  0x7F,0x7F,0x40,0x7F,0x40,0x7F,0xFF,0xC0
	.DB  0x7,0x3,0x7F,0x7F,0x48,0x78,0x30,0x0
	.DB  0x7F,0x7F,0x48,0x78,0x30,0x7F,0x7F,0x0
	.DB  0x1,0x7F,0x7F,0x49,0x48,0x78,0x30,0x0
	.DB  0x22,0x63,0x49,0x49,0x6B,0x3E,0x1C,0x0
	.DB  0x7F,0x7F,0x8,0x7F,0x41,0x7F,0x3E,0x0
	.DB  0x46,0x6F,0x39,0x19,0x19,0x7F,0x7F,0x0
	.DB  0x20,0x74,0x54,0x54,0x3C,0x78,0x40,0x0
	.DB  0x34,0x7E,0x4A,0x4A,0x4A,0x7B,0x31,0x0
	.DB  0x44,0x7C,0x7C,0x54,0x54,0x7C,0x28,0x0
	.DB  0x44,0x7C,0x7C,0x44,0x4,0xC,0xC,0x0
	.DB  0xC0,0xF8,0x7C,0x44,0x7C,0xFC,0xC0,0x0
	.DB  0x38,0x7C,0x54,0x54,0x5C,0x18,0x0,0x0
	.DB  0x44,0x6C,0x38,0x7C,0x38,0x6C,0x44,0x0
	.DB  0x28,0x6C,0x44,0x54,0x54,0x7C,0x28,0x0
	.DB  0x7C,0x7C,0x60,0x30,0x18,0x7C,0x7C,0x0
	.DB  0x7E,0x7E,0x60,0x31,0x18,0x7E,0x7E,0x0
	.DB  0x44,0x7C,0x7C,0x10,0x38,0x6C,0x44,0x0
	.DB  0x40,0x78,0x7C,0x4,0x4,0x7C,0x7C,0x0
	.DB  0x7C,0x7C,0x18,0x38,0x18,0x7C,0x7C,0x0
	.DB  0x7C,0x7C,0x10,0x10,0x10,0x7C,0x7C,0x0
	.DB  0x38,0x7C,0x44,0x44,0x7C,0x38,0x0,0x0
	.DB  0x7C,0x7C,0x4,0x4,0x4,0x7C,0x7C,0x0
	.DB  0x84,0xFC,0xFC,0xA4,0x24,0x3C,0x18,0x0
	.DB  0x38,0x7C,0x44,0x44,0x6C,0x28,0x0,0x0
	.DB  0x0,0xC,0x44,0x7C,0x7C,0x44,0xC,0x0
	.DB  0x1C,0xBC,0xA0,0xA0,0xA0,0xFC,0x7C,0x0
	.DB  0x18,0x3C,0xA4,0xFC,0xA4,0x3C,0x18,0x0
	.DB  0x44,0x6C,0x38,0x10,0x38,0x6C,0x44,0x0
	.DB  0x7C,0x7C,0x40,0x40,0x7C,0xFC,0xC0,0x0
	.DB  0xC,0x1C,0x10,0x10,0x10,0x7C,0x7C,0x0
	.DB  0x7C,0x7C,0x40,0x7C,0x40,0x7C,0x7C,0x0
	.DB  0x7C,0x7C,0x40,0x7C,0x40,0x7C,0xFC,0xC0
	.DB  0xC,0x4,0x7C,0x7C,0x50,0x70,0x20,0x0
	.DB  0x7C,0x7C,0x50,0x70,0x20,0x7C,0x7C,0x0
	.DB  0x4,0x7C,0x7C,0x54,0x50,0x70,0x20,0x0
	.DB  0x28,0x6C,0x44,0x54,0x54,0x7C,0x38,0x0
	.DB  0x7C,0x7C,0x10,0x7C,0x44,0x7C,0x38,0x0
	.DB  0x48,0x7C,0x34,0x14,0x14,0x7C,0x7C,0x0
_font8x12:
	.DB  0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0
	.DB  0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0
	.DB  0xFC,0x1,0x6,0x3,0x52,0x2,0xC2,0x2
	.DB  0xC2,0x2,0x52,0x2,0x6,0x3,0xFC,0x1
	.DB  0xFC,0x1,0xFE,0x3,0xAE,0x3,0x3E,0x3
	.DB  0x3E,0x3,0xAE,0x3,0xFE,0x3,0xFC,0x1
	.DB  0x78,0x0,0xFC,0x0,0xF8,0x1,0xF0,0x3
	.DB  0xF8,0x1,0xFC,0x0,0x78,0x0,0x0,0x0
	.DB  0x30,0x0,0x78,0x0,0xFC,0x0,0xFE,0x1
	.DB  0xFC,0x0,0x78,0x0,0x30,0x0,0x0,0x0
	.DB  0x70,0x0,0x70,0x2,0x7C,0x2,0x9E,0x3
	.DB  0x9E,0x3,0x7C,0x2,0x70,0x2,0x70,0x0
	.DB  0x30,0x0,0x78,0x2,0x7C,0x2,0xFE,0x3
	.DB  0xFE,0x3,0x7C,0x2,0x78,0x2,0x30,0x0
	.DB  0x0,0x0,0x60,0x0,0xF0,0x0,0xF0,0x0
	.DB  0xF0,0x0,0xF0,0x0,0x60,0x0,0x0,0x0
	.DB  0xFF,0xF,0x9F,0xF,0xF,0xF,0xF,0xF
	.DB  0xF,0xF,0xF,0xF,0x9F,0xF,0xFF,0xF
	.DB  0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0
	.DB  0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0
	.DB  0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0
	.DB  0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0
	.DB  0xE0,0x1,0xF0,0x3,0x3A,0x2,0x3A,0x2
	.DB  0xEE,0x3,0xC6,0x1,0x1E,0x0,0x0,0x0
	.DB  0x0,0x0,0x9C,0x0,0xBE,0x0,0xE2,0x3
	.DB  0xE2,0x3,0xBE,0x0,0x9C,0x0,0x0,0x0
	.DB  0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0
	.DB  0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0
	.DB  0x0,0x7,0xFE,0x7,0xFE,0x3,0xA,0x0
	.DB  0xA,0x0,0x8A,0x3,0xFE,0x3,0xFE,0x1
	.DB  0x68,0x1,0xF8,0x1,0xF0,0x0,0x9C,0x3
	.DB  0x9C,0x3,0xF0,0x0,0xF8,0x1,0x68,0x1
	.DB  0xFE,0x3,0xFC,0x1,0xF8,0x0,0x70,0x0
	.DB  0x70,0x0,0x20,0x0,0x20,0x0,0x0,0x0
	.DB  0x20,0x0,0x20,0x0,0x70,0x0,0x70,0x0
	.DB  0xF8,0x0,0xFC,0x1,0xFE,0x3,0x0,0x0
	.DB  0x0,0x0,0x88,0x0,0x8C,0x1,0xFE,0x3
	.DB  0xFE,0x3,0x8C,0x1,0x88,0x0,0x0,0x0
	.DB  0x0,0x0,0x3E,0x3,0x3E,0x3,0x0,0x0
	.DB  0x0,0x0,0x3E,0x3,0x3E,0x3,0x0,0x0
	.DB  0x1C,0x0,0x3E,0x0,0x22,0x0,0xFE,0x3
	.DB  0xFE,0x3,0x2,0x0,0xFE,0x3,0xFE,0x3
	.DB  0x0,0x2,0x66,0x6,0xFE,0x4,0x9A,0x4
	.DB  0x92,0x5,0xF2,0x7,0x66,0x6,0x4,0x0
	.DB  0x0,0x0,0x0,0x0,0xFC,0x3,0xFC,0x3
	.DB  0xFC,0x3,0xFC,0x3,0x0,0x0,0x0,0x0
	.DB  0x0,0x0,0x88,0x4,0x8C,0x5,0xFE,0x7
	.DB  0xFE,0x7,0x8C,0x5,0x88,0x4,0x0,0x0
	.DB  0x0,0x0,0x8,0x0,0xC,0x0,0xFE,0x3
	.DB  0xFE,0x3,0xC,0x0,0x8,0x0,0x0,0x0
	.DB  0x0,0x0,0x80,0x0,0x80,0x1,0xFE,0x3
	.DB  0xFE,0x3,0x80,0x1,0x80,0x0,0x0,0x0
	.DB  0x20,0x0,0x20,0x0,0x20,0x0,0xA8,0x0
	.DB  0xF8,0x0,0x70,0x0,0x20,0x0,0x0,0x0
	.DB  0x20,0x0,0x70,0x0,0xF8,0x0,0xA8,0x0
	.DB  0x20,0x0,0x20,0x0,0x20,0x0,0x0,0x0
	.DB  0xF0,0x0,0xF0,0x0,0x80,0x0,0x80,0x0
	.DB  0x80,0x0,0x80,0x0,0x80,0x0,0x0,0x0
	.DB  0x20,0x0,0x70,0x0,0xF8,0x0,0x20,0x0
	.DB  0x20,0x0,0xF8,0x0,0x70,0x0,0x20,0x0
	.DB  0x0,0x3,0xC0,0x3,0xF0,0x3,0xFC,0x3
	.DB  0xF0,0x3,0xC0,0x3,0x0,0x3,0x0,0x0
	.DB  0xC,0x0,0x3C,0x0,0xFC,0x0,0xFC,0x3
	.DB  0xFC,0x0,0x3C,0x0,0xC,0x0,0x0,0x0
	.DB  0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0
	.DB  0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0
	.DB  0x0,0x0,0x1C,0x0,0x7E,0x3,0x7E,0x3
	.DB  0x1C,0x0,0x0,0x0,0x0,0x0,0x0,0x0
	.DB  0x0,0x0,0xE,0x0,0x1E,0x0,0x0,0x0
	.DB  0x0,0x0,0x1E,0x0,0xE,0x0,0x0,0x0
	.DB  0x88,0x0,0xFE,0x3,0xFE,0x3,0x88,0x0
	.DB  0xFE,0x3,0xFE,0x3,0x88,0x0,0x0,0x0
	.DB  0x18,0x1,0x3C,0x1,0x27,0x7,0x27,0x7
	.DB  0xE4,0x1,0xC4,0x0,0x0,0x0,0x0,0x0
	.DB  0x18,0x3,0x98,0x1,0xC0,0x0,0x60,0x0
	.DB  0x30,0x3,0x18,0x3,0x0,0x0,0x0,0x0
	.DB  0xEC,0x1,0xFE,0x3,0x32,0x2,0x7E,0x3
	.DB  0xEC,0x1,0xC0,0x3,0x60,0x2,0x0,0x0
	.DB  0x0,0x0,0x10,0x0,0x1E,0x0,0xE,0x0
	.DB  0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0
	.DB  0x0,0x0,0x70,0x0,0xF8,0x0,0x8C,0x1
	.DB  0x6,0x3,0x2,0x2,0x0,0x0,0x0,0x0
	.DB  0x0,0x0,0x2,0x2,0x6,0x3,0x8C,0x1
	.DB  0xF8,0x0,0x70,0x0,0x0,0x0,0x0,0x0
	.DB  0x20,0x0,0xA8,0x0,0xF8,0x0,0x70,0x0
	.DB  0x70,0x0,0xF8,0x0,0xA8,0x0,0x20,0x0
	.DB  0x0,0x0,0x20,0x0,0x20,0x0,0xF8,0x0
	.DB  0xF8,0x0,0x20,0x0,0x20,0x0,0x0,0x0
	.DB  0x0,0x0,0x0,0x4,0x0,0x7,0x0,0x3
	.DB  0x0,0x3,0x0,0x0,0x0,0x0,0x0,0x0
	.DB  0x20,0x0,0x20,0x0,0x20,0x0,0x20,0x0
	.DB  0x20,0x0,0x20,0x0,0x20,0x0,0x0,0x0
	.DB  0x0,0x0,0x0,0x0,0x0,0x3,0x0,0x3
	.DB  0x0,0x3,0x0,0x0,0x0,0x0,0x0,0x0
	.DB  0x0,0x3,0x80,0x1,0xC0,0x0,0x60,0x0
	.DB  0x30,0x0,0x18,0x0,0xC,0x0,0x0,0x0
	.DB  0xFC,0x1,0xFE,0x3,0x2,0x2,0xFA,0x2
	.DB  0x2,0x2,0xFE,0x3,0xFC,0x1,0x0,0x0
	.DB  0x8,0x2,0x8,0x2,0xFC,0x3,0xFE,0x3
	.DB  0x0,0x2,0x0,0x2,0x0,0x0,0x0,0x0
	.DB  0xC,0x3,0x8E,0x3,0xC2,0x2,0x62,0x2
	.DB  0x3E,0x3,0x1C,0x3,0x0,0x0,0x0,0x0
	.DB  0x4,0x1,0x6,0x3,0x22,0x2,0x22,0x2
	.DB  0xFE,0x3,0xDC,0x1,0x0,0x0,0x0,0x0
	.DB  0x60,0x0,0x70,0x0,0x58,0x0,0x4C,0x2
	.DB  0xFE,0x3,0xFE,0x3,0x40,0x2,0x0,0x0
	.DB  0x3E,0x1,0x3E,0x3,0x22,0x2,0x22,0x2
	.DB  0xE2,0x3,0xC2,0x1,0x0,0x0,0x0,0x0
	.DB  0xF8,0x1,0xFC,0x3,0x26,0x2,0x22,0x2
	.DB  0xE2,0x3,0xC0,0x1,0x0,0x0,0x0,0x0
	.DB  0xE,0x0,0xE,0x0,0x82,0x3,0xC2,0x3
	.DB  0x62,0x0,0x3E,0x0,0x1E,0x0,0x0,0x0
	.DB  0xDC,0x1,0xFE,0x3,0x32,0x2,0x62,0x2
	.DB  0xFE,0x3,0xDC,0x1,0x0,0x0,0x0,0x0
	.DB  0x1C,0x0,0x3E,0x2,0x22,0x3,0xE2,0x3
	.DB  0xFE,0x0,0x3C,0x0,0x0,0x0,0x0,0x0
	.DB  0x0,0x0,0x0,0x0,0x98,0x1,0x98,0x1
	.DB  0x98,0x1,0x0,0x0,0x0,0x0,0x0,0x0
	.DB  0x0,0x0,0x0,0x0,0x98,0x5,0x98,0x7
	.DB  0x98,0x3,0x0,0x0,0x0,0x0,0x0,0x0
	.DB  0x20,0x0,0x70,0x0,0xD8,0x0,0x8C,0x1
	.DB  0x6,0x3,0x2,0x2,0x0,0x0,0x0,0x0
	.DB  0x0,0x0,0x50,0x0,0x50,0x0,0x50,0x0
	.DB  0x50,0x0,0x50,0x0,0x50,0x0,0x0,0x0
	.DB  0x0,0x0,0x2,0x2,0x6,0x3,0x8C,0x1
	.DB  0xD8,0x0,0x70,0x0,0x20,0x0,0x0,0x0
	.DB  0x4,0x0,0x6,0x0,0x62,0x3,0x72,0x3
	.DB  0x1E,0x0,0xC,0x0,0x0,0x0,0x0,0x0
	.DB  0xFC,0x1,0xFE,0x3,0x2,0x2,0x72,0x2
	.DB  0x72,0x2,0x7E,0x2,0x7C,0x0,0x0,0x0
	.DB  0xF8,0x3,0xFC,0x3,0x46,0x0,0x46,0x0
	.DB  0xFC,0x3,0xF8,0x3,0x0,0x0,0x0,0x0
	.DB  0x2,0x2,0xFE,0x3,0xFE,0x3,0x22,0x2
	.DB  0x22,0x2,0xFE,0x3,0xDC,0x1,0x0,0x0
	.DB  0xF8,0x0,0xFC,0x1,0x6,0x3,0x2,0x2
	.DB  0x2,0x2,0x8E,0x3,0x8C,0x1,0x0,0x0
	.DB  0x2,0x2,0xFE,0x3,0xFE,0x3,0x2,0x2
	.DB  0x6,0x3,0xFC,0x1,0xF8,0x0,0x0,0x0
	.DB  0x2,0x2,0xFE,0x3,0xFE,0x3,0x22,0x2
	.DB  0x22,0x2,0x72,0x2,0x6,0x3,0x0,0x0
	.DB  0x2,0x2,0xFE,0x3,0xFE,0x3,0x22,0x2
	.DB  0x22,0x0,0x76,0x0,0xE,0x0,0x0,0x0
	.DB  0xF8,0x0,0xFC,0x1,0x6,0x3,0x2,0x2
	.DB  0x42,0x2,0xCE,0x3,0xCC,0x3,0x0,0x0
	.DB  0xFE,0x3,0xFE,0x3,0x20,0x0,0x20,0x0
	.DB  0xFE,0x3,0xFE,0x3,0x0,0x0,0x0,0x0
	.DB  0x0,0x0,0x2,0x2,0xFE,0x3,0xFE,0x3
	.DB  0x2,0x2,0x0,0x0,0x0,0x0,0x0,0x0
	.DB  0xC0,0x1,0xC0,0x3,0x0,0x2,0x2,0x2
	.DB  0xFE,0x3,0xFE,0x1,0x2,0x0,0x0,0x0
	.DB  0x2,0x2,0xFE,0x3,0xFE,0x3,0x20,0x0
	.DB  0xF8,0x0,0xDE,0x3,0x6,0x3,0x0,0x0
	.DB  0x2,0x2,0xFE,0x3,0xFE,0x3,0x2,0x2
	.DB  0x0,0x2,0x80,0x3,0xC0,0x3,0x0,0x0
	.DB  0xFE,0x3,0xFE,0x3,0x1C,0x0,0x38,0x0
	.DB  0x1C,0x0,0xFE,0x3,0xFE,0x3,0x0,0x0
	.DB  0xFE,0x3,0xFE,0x3,0x38,0x0,0x70,0x0
	.DB  0xE0,0x0,0xFE,0x3,0xFE,0x3,0x0,0x0
	.DB  0xF8,0x0,0xFC,0x1,0x6,0x3,0x2,0x2
	.DB  0x6,0x3,0xFC,0x1,0xF8,0x0,0x0,0x0
	.DB  0x2,0x2,0xFE,0x3,0xFE,0x3,0x22,0x2
	.DB  0x22,0x0,0x3E,0x0,0x1C,0x0,0x0,0x0
	.DB  0xF8,0x0,0xFC,0x1,0x6,0x1,0x82,0x5
	.DB  0xC6,0x7,0xFC,0x7,0xF8,0x4,0x0,0x0
	.DB  0x2,0x2,0xFE,0x3,0xFE,0x3,0x22,0x0
	.DB  0x62,0x0,0xFE,0x3,0x9C,0x3,0x0,0x0
	.DB  0x9C,0x1,0xBE,0x3,0x22,0x2,0x62,0x2
	.DB  0xCE,0x3,0x8C,0x1,0x0,0x0,0x0,0x0
	.DB  0x6,0x0,0x2,0x2,0xFE,0x3,0xFE,0x3
	.DB  0x2,0x2,0x6,0x0,0x0,0x0,0x0,0x0
	.DB  0xFE,0x1,0xFE,0x3,0x0,0x2,0x0,0x2
	.DB  0xFE,0x3,0xFE,0x1,0x0,0x0,0x0,0x0
	.DB  0xFE,0x0,0xFE,0x1,0x0,0x3,0x0,0x3
	.DB  0xFE,0x1,0xFE,0x0,0x0,0x0,0x0,0x0
	.DB  0x7E,0x0,0xFE,0x3,0x80,0x3,0x60,0x0
	.DB  0x80,0x3,0xFE,0x3,0x7E,0x0,0x0,0x0
	.DB  0x8E,0x3,0xDE,0x3,0x70,0x0,0x70,0x0
	.DB  0xDE,0x3,0x8E,0x3,0x0,0x0,0x0,0x0
	.DB  0x1E,0x0,0x3E,0x2,0xE0,0x3,0xE0,0x3
	.DB  0x3E,0x2,0x1E,0x0,0x0,0x0,0x0,0x0
	.DB  0xE,0x3,0xC6,0x3,0xE2,0x2,0x3A,0x2
	.DB  0x1E,0x2,0x6,0x3,0x86,0x3,0x0,0x0
	.DB  0x0,0x0,0x0,0x0,0xFE,0x3,0xFE,0x3
	.DB  0x2,0x2,0x2,0x2,0x0,0x0,0x0,0x0
	.DB  0xC,0x0,0x18,0x0,0x30,0x0,0x60,0x0
	.DB  0xC0,0x0,0x80,0x1,0x0,0x3,0x0,0x0
	.DB  0x0,0x0,0x0,0x0,0x2,0x2,0x2,0x2
	.DB  0xFE,0x3,0xFE,0x3,0x0,0x0,0x0,0x0
	.DB  0x8,0x0,0xC,0x0,0x6,0x0,0x3,0x0
	.DB  0x6,0x0,0xC,0x0,0x8,0x0,0x0,0x0
	.DB  0x0,0x4,0x0,0x4,0x0,0x4,0x0,0x4
	.DB  0x0,0x4,0x0,0x4,0x0,0x4,0x0,0x4
	.DB  0x0,0x0,0x0,0x0,0x3,0x0,0x7,0x0
	.DB  0x4,0x0,0x0,0x0,0x0,0x0,0x0,0x0
	.DB  0x80,0x1,0xD0,0x3,0x50,0x2,0x50,0x2
	.DB  0xF0,0x1,0xE0,0x3,0x0,0x2,0x0,0x0
	.DB  0x2,0x2,0xFE,0x3,0xFE,0x1,0x10,0x2
	.DB  0x10,0x2,0xF0,0x3,0xE0,0x1,0x0,0x0
	.DB  0xE0,0x1,0xF0,0x3,0x10,0x2,0x10,0x2
	.DB  0x30,0x3,0x20,0x1,0x0,0x0,0x0,0x0
	.DB  0xE0,0x1,0xF0,0x3,0x10,0x2,0x12,0x2
	.DB  0xFE,0x1,0xFE,0x3,0x0,0x2,0x0,0x0
	.DB  0xE0,0x1,0xF0,0x3,0x50,0x2,0x50,0x2
	.DB  0x70,0x3,0x60,0x1,0x0,0x0,0x0,0x0
	.DB  0x20,0x2,0xFC,0x3,0xFE,0x3,0x22,0x2
	.DB  0x26,0x0,0x4,0x0,0x0,0x0,0x0,0x0
	.DB  0xE0,0x4,0xF0,0xD,0x10,0x9,0x10,0x9
	.DB  0xE0,0xF,0xF0,0x7,0x10,0x0,0x0,0x0
	.DB  0x2,0x2,0xFE,0x3,0xFE,0x3,0x20,0x0
	.DB  0x10,0x0,0xF0,0x3,0xE0,0x3,0x0,0x0
	.DB  0x0,0x0,0x10,0x2,0x10,0x2,0xF6,0x3
	.DB  0xF6,0x3,0x0,0x2,0x0,0x2,0x0,0x0
	.DB  0x0,0x6,0x0,0xE,0x10,0x8,0x10,0x8
	.DB  0xF6,0xF,0xF6,0x7,0x0,0x0,0x0,0x0
	.DB  0x2,0x2,0xFE,0x3,0xFE,0x3,0x40,0x0
	.DB  0xE0,0x0,0xB0,0x3,0x10,0x3,0x0,0x0
	.DB  0x0,0x0,0x2,0x2,0x2,0x2,0xFE,0x3
	.DB  0xFE,0x3,0x0,0x2,0x0,0x2,0x0,0x0
	.DB  0xF0,0x3,0xF0,0x3,0x10,0x0,0xF0,0x1
	.DB  0x10,0x0,0xF0,0x3,0xE0,0x3,0x0,0x0
	.DB  0xF0,0x3,0xF0,0x3,0x10,0x0,0x10,0x0
	.DB  0xF0,0x3,0xE0,0x3,0x0,0x0,0x0,0x0
	.DB  0xE0,0x1,0xF0,0x3,0x10,0x2,0x10,0x2
	.DB  0xF0,0x3,0xE0,0x1,0x0,0x0,0x0,0x0
	.DB  0x10,0x8,0xF0,0xF,0xE0,0xF,0x10,0xA
	.DB  0x10,0x2,0xF0,0x3,0xE0,0x1,0x0,0x0
	.DB  0xE0,0x1,0xF0,0x3,0x10,0x2,0x10,0xA
	.DB  0xE0,0xF,0xF0,0xF,0x10,0x8,0x0,0x0
	.DB  0x10,0x2,0xF0,0x3,0xF0,0x3,0x40,0x2
	.DB  0x30,0x0,0x70,0x0,0x60,0x0,0x0,0x0
	.DB  0x20,0x1,0x70,0x3,0x50,0x2,0x90,0x2
	.DB  0xB0,0x3,0x20,0x1,0x0,0x0,0x0,0x0
	.DB  0x10,0x0,0xF8,0x1,0xFC,0x3,0x10,0x2
	.DB  0x10,0x3,0x10,0x1,0x0,0x0,0x0,0x0
	.DB  0xF0,0x1,0xF0,0x3,0x0,0x2,0x0,0x2
	.DB  0xF0,0x1,0xF0,0x3,0x0,0x2,0x0,0x0
	.DB  0xF0,0x0,0xF0,0x1,0x0,0x3,0x0,0x3
	.DB  0xF0,0x1,0xF0,0x0,0x0,0x0,0x0,0x0
	.DB  0xF0,0x0,0xF0,0x3,0x0,0x3,0xC0,0x0
	.DB  0x0,0x3,0xF0,0x3,0xF0,0x0,0x0,0x0
	.DB  0x10,0x2,0x30,0x3,0xE0,0x1,0xC0,0x0
	.DB  0xE0,0x1,0x30,0x3,0x10,0x2,0x0,0x0
	.DB  0x0,0x8,0xF0,0x8,0xF0,0x9,0x0,0xD
	.DB  0x0,0x7,0xF0,0x3,0xF0,0x0,0x0,0x0
	.DB  0x30,0x3,0x90,0x3,0x90,0x2,0x50,0x2
	.DB  0x70,0x2,0x30,0x3,0x0,0x0,0x0,0x0
	.DB  0x20,0x0,0x70,0x0,0xDC,0x1,0x8E,0x3
	.DB  0x2,0x2,0x2,0x2,0x0,0x0,0x0,0x0
	.DB  0x0,0x0,0x0,0x0,0x0,0x0,0xDE,0x3
	.DB  0xDE,0x3,0x0,0x0,0x0,0x0,0x0,0x0
	.DB  0x2,0x2,0x2,0x2,0x8E,0x3,0xDC,0x1
	.DB  0x70,0x0,0x20,0x0,0x0,0x0,0x0,0x0
	.DB  0xC,0x0,0xE,0x0,0x2,0x0,0x6,0x0
	.DB  0xC,0x0,0x8,0x0,0xE,0x0,0x2,0x0
	.DB  0xC0,0x1,0xE0,0x1,0x30,0x1,0x18,0x1
	.DB  0x30,0x1,0xE0,0x1,0xC0,0x1,0x0,0x0
	.DB  0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0
	.DB  0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0
	.DB  0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0
	.DB  0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0
	.DB  0x0,0x0,0x10,0x0,0x1E,0x0,0xE,0x0
	.DB  0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0
	.DB  0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0
	.DB  0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0
	.DB  0x0,0x0,0xE,0x0,0x1E,0x0,0x0,0x0
	.DB  0x0,0x0,0x1E,0x0,0xE,0x0,0x0,0x0
	.DB  0x0,0x0,0x0,0x0,0x98,0x1,0x98,0x1
	.DB  0x98,0x1,0x0,0x0,0x0,0x0,0x0,0x0
	.DB  0x20,0x0,0x20,0x0,0x20,0x0,0xFF,0xF
	.DB  0xFF,0xF,0x20,0x0,0x20,0x0,0x20,0x0
	.DB  0x90,0x0,0x90,0x0,0x90,0x0,0x9F,0xF
	.DB  0x9F,0xF,0x90,0x0,0x90,0x0,0x90,0x0
	.DB  0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0
	.DB  0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0
	.DB  0x18,0x3,0x98,0x1,0xC0,0x0,0x60,0x0
	.DB  0x30,0x3,0x18,0x3,0x0,0x0,0x0,0x0
	.DB  0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0
	.DB  0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0
	.DB  0x20,0x0,0x70,0x0,0xD8,0x0,0x8C,0x1
	.DB  0x6,0x3,0x2,0x2,0x0,0x0,0x0,0x0
	.DB  0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0
	.DB  0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0
	.DB  0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0
	.DB  0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0
	.DB  0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0
	.DB  0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0
	.DB  0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0
	.DB  0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0
	.DB  0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0
	.DB  0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0
	.DB  0x0,0x0,0x10,0x0,0x1E,0x0,0xE,0x0
	.DB  0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0
	.DB  0x0,0x0,0x10,0x0,0x1E,0x0,0xE,0x0
	.DB  0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0
	.DB  0x0,0x0,0xE,0x0,0x1E,0x0,0x0,0x0
	.DB  0x0,0x0,0x1E,0x0,0xE,0x0,0x0,0x0
	.DB  0x0,0x0,0xE,0x0,0x1E,0x0,0x0,0x0
	.DB  0x0,0x0,0x1E,0x0,0xE,0x0,0x0,0x0
	.DB  0x0,0x0,0x60,0x0,0xF0,0x0,0xF0,0x0
	.DB  0xF0,0x0,0xF0,0x0,0x60,0x0,0x0,0x0
	.DB  0x20,0x0,0x20,0x0,0x20,0x0,0x20,0x0
	.DB  0x20,0x0,0x20,0x0,0x20,0x0,0x0,0x0
	.DB  0x20,0x0,0x20,0x0,0x20,0x0,0x20,0x0
	.DB  0x20,0x0,0x20,0x0,0x20,0x0,0x0,0x0
	.DB  0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0
	.DB  0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0
	.DB  0x6,0x0,0x2,0x2,0xFE,0x3,0xFE,0x3
	.DB  0x2,0x2,0x6,0x0,0x0,0x0,0x0,0x0
	.DB  0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0
	.DB  0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0
	.DB  0x0,0x0,0x2,0x2,0x6,0x3,0x8C,0x1
	.DB  0xD8,0x0,0x70,0x0,0x20,0x0,0x0,0x0
	.DB  0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0
	.DB  0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0
	.DB  0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0
	.DB  0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0
	.DB  0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0
	.DB  0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0
	.DB  0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0
	.DB  0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0
	.DB  0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0
	.DB  0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0
	.DB  0x0,0x0,0x3C,0x1,0x7C,0x3,0x41,0x2
	.DB  0x41,0x2,0xFC,0x3,0xFC,0x1,0x0,0x0
	.DB  0x0,0x8,0xF0,0x8,0xF0,0x9,0x4,0xD
	.DB  0x4,0x7,0xF0,0x3,0xF0,0x0,0x0,0x0
	.DB  0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0
	.DB  0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0
	.DB  0x0,0x0,0x44,0x0,0x7C,0x0,0x28,0x0
	.DB  0x28,0x0,0x7C,0x0,0x44,0x0,0x0,0x0
	.DB  0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0
	.DB  0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0
	.DB  0x0,0x0,0x0,0x0,0x0,0x0,0xFF,0xF
	.DB  0xFF,0xF,0x0,0x0,0x0,0x0,0x0,0x0
	.DB  0x0,0x2,0x66,0x6,0xFE,0x4,0x9A,0x4
	.DB  0x92,0x5,0xF2,0x7,0x66,0x6,0x4,0x0
	.DB  0x2,0x2,0xFF,0x3,0xFF,0x3,0x22,0x2
	.DB  0x23,0x2,0x73,0x2,0x6,0x3,0x0,0x0
	.DB  0xE0,0x1,0xF0,0x3,0x10,0x2,0x10,0x2
	.DB  0x30,0x3,0x20,0x1,0x0,0x0,0x0,0x0
	.DB  0xF8,0x0,0xFC,0x1,0x26,0x3,0x22,0x2
	.DB  0x2,0x2,0x8E,0x3,0x8C,0x1,0x0,0x0
	.DB  0x20,0x0,0x70,0x0,0xD8,0x0,0x8C,0x1
	.DB  0x6,0x3,0x2,0x2,0x0,0x0,0x0,0x0
	.DB  0x20,0x0,0x20,0x0,0x20,0x0,0xE0,0xF
	.DB  0xE0,0xF,0x0,0x0,0x0,0x0,0x0,0x0
	.DB  0x20,0x0,0x20,0x0,0x20,0x0,0x20,0x0
	.DB  0x20,0x0,0x20,0x0,0x20,0x0,0x0,0x0
	.DB  0x2,0x2,0xFE,0x3,0xFE,0x3,0x22,0x0
	.DB  0x62,0x0,0xFE,0x3,0x9C,0x3,0x0,0x0
	.DB  0x3,0x0,0x3,0x2,0xFC,0x3,0xFC,0x3
	.DB  0x3,0x2,0x3,0x0,0x0,0x0,0x0,0x0
	.DB  0x0,0x0,0x1C,0x0,0x3E,0x0,0x22,0x0
	.DB  0x22,0x0,0x3E,0x0,0x1C,0x0,0x0,0x0
	.DB  0x0,0x0,0x20,0x0,0x20,0x0,0xF8,0x0
	.DB  0xF8,0x0,0x20,0x0,0x20,0x0,0x0,0x0
	.DB  0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0
	.DB  0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0
	.DB  0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0
	.DB  0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0
	.DB  0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0
	.DB  0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0
	.DB  0x70,0x0,0xF0,0x0,0x80,0x0,0x80,0x0
	.DB  0xF0,0x3,0xF0,0x3,0x0,0x0,0x0,0x0
	.DB  0x1C,0x0,0x3E,0x0,0x22,0x0,0xFE,0x3
	.DB  0xFE,0x3,0x2,0x0,0xFE,0x3,0xFE,0x3
	.DB  0x0,0x0,0x0,0x0,0x0,0x0,0x20,0x0
	.DB  0x20,0x0,0x0,0x0,0x0,0x0,0x0,0x0
	.DB  0xE0,0x1,0xF6,0x3,0x50,0x2,0x50,0x2
	.DB  0x76,0x3,0x60,0x1,0x0,0x0,0x0,0x0
	.DB  0xFE,0x3,0xFE,0x3,0x30,0x0,0x60,0x0
	.DB  0xFE,0x3,0xFE,0x3,0x66,0x0,0x0,0x0
	.DB  0xE0,0x1,0xF0,0x3,0x50,0x2,0x50,0x2
	.DB  0x30,0x3,0x20,0x1,0x0,0x0,0x0,0x0
	.DB  0x0,0x0,0x2,0x2,0x6,0x3,0x8C,0x1
	.DB  0xD8,0x0,0x70,0x0,0x20,0x0,0x0,0x0
	.DB  0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0
	.DB  0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0
	.DB  0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0
	.DB  0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0
	.DB  0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0
	.DB  0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0
	.DB  0x0,0x0,0x6,0x0,0x6,0x2,0xF0,0x3
	.DB  0xF0,0x3,0x6,0x2,0x6,0x0,0x0,0x0
	.DB  0xF8,0x3,0xFC,0x3,0x46,0x0,0x46,0x0
	.DB  0xFC,0x3,0xF8,0x3,0x0,0x0,0x0,0x0
	.DB  0x2,0x2,0xFE,0x3,0xFE,0x3,0x12,0x2
	.DB  0x12,0x2,0xF2,0x3,0xE6,0x1,0x0,0x0
	.DB  0x2,0x2,0xFE,0x3,0xFE,0x3,0x22,0x2
	.DB  0x22,0x2,0xFE,0x3,0xDC,0x1,0x0,0x0
	.DB  0x2,0x2,0xFE,0x3,0xFE,0x3,0x2,0x2
	.DB  0x2,0x0,0x2,0x0,0xE,0x0,0x0,0x0
	.DB  0x0,0x6,0xFC,0x7,0xFE,0x3,0x2,0x2
	.DB  0x2,0x2,0xFE,0x3,0xFE,0x7,0x0,0x6
	.DB  0x2,0x2,0xFE,0x3,0xFE,0x3,0x22,0x2
	.DB  0x22,0x2,0x72,0x2,0x6,0x3,0x0,0x0
	.DB  0x6,0x3,0xDC,0x1,0x70,0x0,0xFE,0x3
	.DB  0xFE,0x3,0x70,0x0,0xDC,0x1,0x6,0x3
	.DB  0x0,0x0,0x8C,0x1,0x6,0x3,0x22,0x2
	.DB  0x22,0x2,0xFE,0x3,0xDC,0x1,0x0,0x0
	.DB  0xFE,0x3,0xFE,0x3,0xE0,0x0,0x70,0x0
	.DB  0x38,0x0,0xFE,0x3,0xFE,0x3,0x0,0x0
	.DB  0xFE,0x3,0xFE,0x3,0xE4,0x0,0x77,0x0
	.DB  0x39,0x0,0xFE,0x3,0xFE,0x3,0x0,0x0
	.DB  0x2,0x2,0xFE,0x3,0xFE,0x3,0x20,0x0
	.DB  0xF8,0x0,0xDE,0x3,0x6,0x3,0x0,0x0
	.DB  0x0,0x2,0xF8,0x3,0xFC,0x1,0x6,0x0
	.DB  0x6,0x0,0xFE,0x3,0xFE,0x3,0x0,0x0
	.DB  0xFE,0x3,0xFE,0x3,0x1C,0x0,0x38,0x0
	.DB  0x1C,0x0,0xFE,0x3,0xFE,0x3,0x0,0x0
	.DB  0xFE,0x3,0xFE,0x3,0x20,0x0,0x20,0x0
	.DB  0x20,0x0,0xFE,0x3,0xFE,0x3,0x0,0x0
	.DB  0xF8,0x0,0xFC,0x1,0x6,0x3,0x2,0x2
	.DB  0x6,0x3,0xFC,0x1,0xF8,0x0,0x0,0x0
	.DB  0xFE,0x3,0xFE,0x3,0x2,0x0,0x2,0x0
	.DB  0x2,0x0,0xFE,0x3,0xFE,0x3,0x0,0x0
	.DB  0x2,0x2,0xFE,0x3,0xFE,0x3,0x22,0x2
	.DB  0x22,0x0,0x3E,0x0,0x1C,0x0,0x0,0x0
	.DB  0xF8,0x0,0xFC,0x1,0x6,0x3,0x2,0x2
	.DB  0x2,0x2,0x8E,0x3,0x8C,0x1,0x0,0x0
	.DB  0x0,0x0,0x6,0x0,0x2,0x2,0xFE,0x3
	.DB  0xFE,0x3,0x2,0x2,0x6,0x0,0x0,0x0
	.DB  0x0,0x0,0x3E,0x1,0x7E,0x3,0x40,0x2
	.DB  0x40,0x2,0xFE,0x3,0xFE,0x1,0x0,0x0
	.DB  0x78,0x0,0xFC,0x0,0x84,0x0,0xFE,0x3
	.DB  0xFE,0x3,0x84,0x0,0xFC,0x0,0x78,0x0
	.DB  0x8E,0x3,0xDE,0x3,0x70,0x0,0x70,0x0
	.DB  0xDE,0x3,0x8E,0x3,0x0,0x0,0x0,0x0
	.DB  0xFE,0x3,0xFE,0x3,0x0,0x2,0x0,0x2
	.DB  0xFE,0x3,0xFE,0x7,0x0,0x6,0x0,0x0
	.DB  0x3E,0x0,0x7E,0x0,0x40,0x0,0x40,0x0
	.DB  0x40,0x0,0xFE,0x3,0xFE,0x3,0x0,0x0
	.DB  0xFE,0x3,0xFE,0x3,0x0,0x2,0xFE,0x3
	.DB  0x0,0x2,0xFE,0x3,0xFE,0x3,0x0,0x0
	.DB  0xFE,0x3,0xFE,0x3,0x0,0x2,0xFE,0x3
	.DB  0x0,0x2,0xFE,0x3,0xFE,0x7,0x0,0x6
	.DB  0x6,0x0,0xFE,0x3,0xFE,0x3,0x20,0x2
	.DB  0x20,0x2,0xE0,0x3,0xC0,0x1,0x0,0x0
	.DB  0xFE,0x3,0xFE,0x3,0x20,0x2,0xE0,0x3
	.DB  0xC0,0x1,0xFE,0x3,0xFE,0x3,0x0,0x0
	.DB  0xFC,0x3,0xFC,0x3,0x20,0x2,0x20,0x2
	.DB  0x20,0x2,0xE0,0x3,0xC0,0x1,0x0,0x0
	.DB  0x8C,0x1,0x8E,0x3,0x2,0x2,0x22,0x2
	.DB  0x26,0x3,0xFC,0x1,0xF8,0x0,0x0,0x0
	.DB  0xFE,0x3,0xFE,0x3,0x30,0x0,0xFC,0x1
	.DB  0xFE,0x3,0x2,0x2,0xFE,0x3,0xFC,0x1
	.DB  0x0,0x2,0x9C,0x3,0xFE,0x3,0x62,0x0
	.DB  0x22,0x0,0xFE,0x3,0xFE,0x3,0x2,0x2
	.DB  0x80,0x1,0xD0,0x3,0x50,0x2,0x50,0x2
	.DB  0xF0,0x1,0xE0,0x3,0x0,0x2,0x0,0x0
	.DB  0xE0,0x1,0xF0,0x3,0x50,0x2,0x50,0x2
	.DB  0xD0,0x3,0x98,0x1,0x0,0x0,0x0,0x0
	.DB  0xF0,0x3,0xF0,0x3,0x50,0x2,0x50,0x2
	.DB  0xF0,0x3,0xA0,0x1,0x0,0x0,0x0,0x0
	.DB  0xF0,0x3,0xF0,0x3,0x10,0x0,0x10,0x0
	.DB  0x10,0x0,0x10,0x0,0x0,0x0,0x0,0x0
	.DB  0x0,0x6,0xF0,0x7,0xF0,0x3,0x10,0x2
	.DB  0xF0,0x3,0xF0,0x7,0x0,0x6,0x0,0x0
	.DB  0xE0,0x1,0xF0,0x3,0x50,0x2,0x50,0x2
	.DB  0x70,0x3,0x60,0x1,0x0,0x0,0x0,0x0
	.DB  0x30,0x3,0xE0,0x1,0xC0,0x0,0xF0,0x3
	.DB  0xC0,0x0,0xE0,0x1,0x30,0x3,0x0,0x0
	.DB  0x20,0x1,0x10,0x2,0x50,0x2,0x50,0x2
	.DB  0xF0,0x3,0xA0,0x1,0x0,0x0,0x0,0x0
	.DB  0xF0,0x3,0xF0,0x3,0x80,0x1,0xC0,0x0
	.DB  0xF0,0x3,0xF0,0x3,0x0,0x0,0x0,0x0
	.DB  0xF0,0x3,0xF0,0x3,0x80,0x1,0xCC,0x0
	.DB  0xF6,0x3,0xF0,0x3,0x0,0x0,0x0,0x0
	.DB  0xF0,0x3,0xF0,0x3,0x40,0x0,0xE0,0x0
	.DB  0xB0,0x3,0x10,0x2,0x0,0x0,0x0,0x0
	.DB  0x0,0x2,0x80,0x3,0xE0,0x0,0x30,0x0
	.DB  0xF0,0x3,0xF0,0x3,0x0,0x0,0x0,0x0
	.DB  0xF0,0x3,0xF0,0x3,0x20,0x0,0xC0,0x0
	.DB  0x20,0x0,0xF0,0x3,0xF0,0x3,0x0,0x0
	.DB  0xF0,0x3,0xF0,0x3,0x40,0x0,0x40,0x0
	.DB  0xF0,0x3,0xF0,0x3,0x0,0x0,0x0,0x0
	.DB  0xE0,0x1,0xF0,0x3,0x10,0x2,0x10,0x2
	.DB  0xF0,0x3,0xE0,0x1,0x0,0x0,0x0,0x0
	.DB  0xF0,0x3,0xF0,0x3,0x10,0x0,0x10,0x0
	.DB  0xF0,0x3,0xF0,0x3,0x0,0x0,0x0,0x0
	.DB  0xF0,0xF,0xF0,0xF,0x10,0x2,0x10,0x2
	.DB  0xF0,0x3,0xE0,0x1,0x0,0x0,0x0,0x0
	.DB  0xE0,0x1,0xF0,0x3,0x10,0x2,0x10,0x2
	.DB  0x30,0x3,0x20,0x1,0x0,0x0,0x0,0x0
	.DB  0x10,0x0,0x10,0x0,0xF0,0x3,0xF0,0x3
	.DB  0x10,0x0,0x10,0x0,0x0,0x0,0x0,0x0
	.DB  0x0,0x0,0xF0,0x4,0xF0,0xD,0x0,0x9
	.DB  0x0,0x9,0xF0,0xF,0xF0,0x7,0x0,0x0
	.DB  0xE0,0x0,0xF0,0x1,0x10,0x1,0xF8,0x7
	.DB  0x10,0x1,0xF0,0x1,0xE0,0x0,0x0,0x0
	.DB  0x10,0x2,0x30,0x3,0xE0,0x1,0xC0,0x0
	.DB  0xE0,0x1,0x30,0x3,0x10,0x2,0x0,0x0
	.DB  0xF0,0x3,0xF0,0x3,0x0,0x2,0x0,0x2
	.DB  0xF0,0x3,0xF0,0x7,0x0,0x6,0x0,0x0
	.DB  0x70,0x0,0xF0,0x0,0x80,0x0,0x80,0x0
	.DB  0xF0,0x3,0xF0,0x3,0x0,0x0,0x0,0x0
	.DB  0xF0,0x3,0xF0,0x3,0x0,0x2,0xF0,0x3
	.DB  0x0,0x2,0xF0,0x3,0xF0,0x3,0x0,0x0
	.DB  0xF0,0x3,0xF0,0x3,0x0,0x2,0xF0,0x3
	.DB  0x0,0x2,0xF0,0x3,0xF0,0x7,0x0,0x6
	.DB  0x30,0x0,0xF0,0x3,0xF0,0x3,0x40,0x2
	.DB  0x40,0x2,0xC0,0x3,0x80,0x1,0x0,0x0
	.DB  0xF0,0x3,0xF0,0x3,0x40,0x2,0xC0,0x3
	.DB  0x80,0x1,0xF0,0x3,0xF0,0x3,0x0,0x0
	.DB  0xF0,0x3,0xF0,0x3,0x40,0x2,0x40,0x2
	.DB  0xC0,0x3,0x80,0x1,0x0,0x0,0x0,0x0
	.DB  0x20,0x1,0x30,0x3,0x50,0x2,0x50,0x2
	.DB  0xF0,0x3,0xE0,0x1,0x0,0x0,0x0,0x0
	.DB  0xF0,0x3,0xF0,0x3,0xE0,0x1,0xF0,0x3
	.DB  0x10,0x2,0xF0,0x3,0xE0,0x1,0x0,0x0
	.DB  0x60,0x2,0xF0,0x3,0x90,0x1,0x90,0x0
	.DB  0xF0,0x3,0xF0,0x3,0x0,0x0,0x0,0x0
_font12x16:
	.DB  0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0
	.DB  0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0
	.DB  0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0
	.DB  0x0,0x0,0xF0,0x3,0xC,0xC,0x2,0x10
	.DB  0x32,0x11,0x31,0x22,0x1,0x22,0x31,0x22
	.DB  0x32,0x11,0x2,0x10,0xC,0xC,0xF0,0x3
	.DB  0x0,0x0,0xF0,0x3,0xFC,0xF,0xFE,0x1F
	.DB  0xCE,0x1E,0xCF,0x3D,0xFF,0x3D,0xCF,0x3D
	.DB  0xCE,0x1E,0xFE,0x1F,0xFC,0xF,0xF0,0x3
	.DB  0x0,0x0,0x0,0x0,0xF0,0x0,0xF8,0x1
	.DB  0xF8,0x3,0xF0,0x7,0xE0,0xF,0xF0,0x7
	.DB  0xF8,0x3,0xF8,0x1,0xF0,0x0,0x0,0x0
	.DB  0x0,0x0,0x0,0x0,0x80,0x0,0xC0,0x1
	.DB  0xE0,0x3,0xF0,0x7,0xF8,0xF,0xF0,0x7
	.DB  0xE0,0x3,0xC0,0x1,0x80,0x0,0x0,0x0
	.DB  0x0,0x0,0x80,0x3,0xC0,0x7,0xC0,0x7
	.DB  0xB8,0x13,0xFC,0x1B,0xFC,0x1F,0xFC,0x1B
	.DB  0xB8,0x13,0xC0,0x7,0xC0,0x7,0x80,0x3
	.DB  0x0,0x0,0x0,0x0,0x80,0x3,0xC0,0x7
	.DB  0xE0,0x17,0xF0,0x1B,0xFC,0x1F,0xF0,0x1B
	.DB  0xE0,0x17,0xC0,0x7,0x80,0x3,0x0,0x0
	.DB  0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0
	.DB  0x80,0x1,0xC0,0x3,0xC0,0x3,0x80,0x1
	.DB  0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0
	.DB  0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF
	.DB  0x7F,0xFE,0x3F,0xFC,0x3F,0xFC,0x7F,0xFE
	.DB  0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF
	.DB  0x0,0x0,0x0,0x0,0x0,0x0,0xC0,0x3
	.DB  0x20,0x4,0x10,0x8,0x10,0x8,0x20,0x4
	.DB  0xC0,0x3,0x0,0x0,0x0,0x0,0x0,0x0
	.DB  0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x3F,0xFC
	.DB  0xDF,0xFB,0xEF,0xF7,0xEF,0xF7,0xDF,0xFB
	.DB  0x3F,0xFC,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF
	.DB  0x0,0x0,0x80,0x3,0xC0,0x7,0x60,0xC
	.DB  0x20,0x8,0x20,0x8,0x60,0xC,0xC8,0x7
	.DB  0xA8,0x3,0x18,0x0,0x78,0x0,0x0,0x0
	.DB  0x0,0x0,0x0,0x0,0x0,0x0,0x70,0x0
	.DB  0xF8,0x8,0x8C,0x9,0x4,0x3F,0x4,0x3F
	.DB  0x8C,0x9,0xF8,0x8,0x70,0x0,0x0,0x0
	.DB  0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xC
	.DB  0x0,0x1E,0x0,0x1E,0xFF,0xF,0xE,0x0
	.DB  0x7C,0x0,0x38,0x0,0x0,0x0,0x0,0x0
	.DB  0x0,0x0,0x0,0x6,0x0,0xF,0x0,0xF
	.DB  0xFF,0x7,0x33,0x0,0x66,0x30,0xCC,0x78
	.DB  0x98,0x79,0xF0,0x3F,0x0,0x0,0x0,0x0
	.DB  0x0,0x0,0x80,0x0,0xC8,0x9,0xF0,0x7
	.DB  0x30,0x6,0x18,0xC,0x1E,0x3C,0x18,0xC
	.DB  0x30,0x6,0xF0,0x7,0xC8,0x9,0x80,0x0
	.DB  0x0,0x0,0x0,0x0,0x0,0x0,0xFC,0x1F
	.DB  0xF8,0xF,0xF0,0x7,0xE0,0x3,0xC0,0x1
	.DB  0x80,0x0,0x0,0x0,0x0,0x0,0x0,0x0
	.DB  0x0,0x0,0x0,0x0,0x0,0x0,0x80,0x0
	.DB  0xC0,0x1,0xE0,0x3,0xF0,0x7,0xF8,0xF
	.DB  0xFC,0x1F,0x0,0x0,0x0,0x0,0x0,0x0
	.DB  0x0,0x0,0x0,0x0,0x0,0x0,0x10,0x4
	.DB  0x18,0xC,0x1C,0x1C,0xFE,0x3F,0x1C,0x1C
	.DB  0x18,0xC,0x10,0x4,0x0,0x0,0x0,0x0
	.DB  0x0,0x0,0x0,0x0,0x0,0x0,0xFE,0x37
	.DB  0xFE,0x37,0x0,0x0,0x0,0x0,0xFE,0x37
	.DB  0xFE,0x37,0x0,0x0,0x0,0x0,0x0,0x0
	.DB  0x0,0x0,0x38,0x0,0x7C,0x0,0xC6,0x0
	.DB  0x82,0x0,0xFE,0x3F,0xFE,0x3F,0x2,0x0
	.DB  0xFE,0x3F,0xFE,0x3F,0x2,0x0,0x0,0x0
	.DB  0x0,0x0,0x0,0x0,0xDC,0x8,0xFE,0x19
	.DB  0x22,0x11,0x22,0x11,0x22,0x11,0x22,0x11
	.DB  0xE6,0x1F,0xC4,0xE,0x0,0x0,0x0,0x0
	.DB  0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x38
	.DB  0x0,0x38,0x0,0x38,0x0,0x38,0x0,0x38
	.DB  0x0,0x38,0x0,0x38,0x0,0x38,0x0,0x0
	.DB  0x0,0x0,0x0,0x0,0x0,0x0,0x8,0x44
	.DB  0xC,0x4C,0xE,0x5C,0xFF,0x7F,0xE,0x5C
	.DB  0xC,0x4C,0x8,0x44,0x0,0x0,0x0,0x0
	.DB  0x0,0x0,0x0,0x0,0x0,0x0,0x10,0x0
	.DB  0x18,0x0,0x1C,0x0,0xFE,0x3F,0x1C,0x0
	.DB  0x18,0x0,0x10,0x0,0x0,0x0,0x0,0x0
	.DB  0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x4
	.DB  0x0,0xC,0x0,0x1C,0xFE,0x3F,0x0,0x1C
	.DB  0x0,0xC,0x0,0x4,0x0,0x0,0x0,0x0
	.DB  0x0,0x0,0x0,0x0,0x80,0x0,0x80,0x0
	.DB  0x80,0x0,0x80,0x0,0x80,0x0,0xF0,0x7
	.DB  0xE0,0x3,0xC0,0x1,0x80,0x0,0x0,0x0
	.DB  0x0,0x0,0x0,0x0,0x80,0x0,0xC0,0x1
	.DB  0xE0,0x3,0xF0,0x7,0x80,0x0,0x80,0x0
	.DB  0x80,0x0,0x80,0x0,0x80,0x0,0x0,0x0
	.DB  0x0,0x0,0x0,0x3F,0x0,0x20,0x0,0x20
	.DB  0x0,0x20,0x0,0x20,0x0,0x20,0x0,0x20
	.DB  0x0,0x20,0x0,0x20,0x0,0x20,0x0,0x0
	.DB  0x0,0x0,0x80,0x0,0xC0,0x1,0xE0,0x3
	.DB  0xF0,0x7,0x80,0x0,0x80,0x0,0x80,0x0
	.DB  0xF0,0x7,0xE0,0x3,0xC0,0x1,0x80,0x0
	.DB  0x0,0x0,0x0,0x4,0x0,0x6,0x0,0x7
	.DB  0x80,0x7,0xC0,0x7,0xE0,0x7,0xC0,0x7
	.DB  0x80,0x7,0x0,0x7,0x0,0x6,0x0,0x4
	.DB  0x0,0x0,0x20,0x0,0x60,0x0,0xE0,0x0
	.DB  0xE0,0x1,0xE0,0x3,0xE0,0x7,0xE0,0x3
	.DB  0xE0,0x1,0xE0,0x0,0x60,0x0,0x20,0x0
	.DB  0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0
	.DB  0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0
	.DB  0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0
	.DB  0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0
	.DB  0x7C,0x0,0xFF,0x33,0xFF,0x33,0x7C,0x0
	.DB  0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0
	.DB  0x0,0x0,0x0,0x0,0x0,0x0,0x3C,0x0
	.DB  0x3C,0x0,0x0,0x0,0x0,0x0,0x3C,0x0
	.DB  0x3C,0x0,0x0,0x0,0x0,0x0,0x0,0x0
	.DB  0x0,0x0,0x0,0x2,0x10,0x1E,0x90,0x1F
	.DB  0xF0,0x3,0x7E,0x2,0x1E,0x1E,0x90,0x1F
	.DB  0xF0,0x3,0x7E,0x2,0x1E,0x0,0x10,0x0
	.DB  0x0,0x0,0x0,0x0,0x78,0x4,0xFC,0xC
	.DB  0xCC,0xC,0xFF,0x3F,0xFF,0x3F,0xCC,0xC
	.DB  0xCC,0xF,0x88,0x7,0x0,0x0,0x0,0x0
	.DB  0x0,0x0,0x0,0x30,0x38,0x38,0x38,0x1C
	.DB  0x38,0xE,0x0,0x7,0x80,0x3,0xC0,0x1
	.DB  0xE0,0x38,0x70,0x38,0x38,0x38,0x1C,0x0
	.DB  0x0,0x0,0x0,0x0,0x0,0x1F,0xB8,0x3F
	.DB  0xFC,0x31,0xC6,0x21,0xE2,0x37,0x3E,0x1E
	.DB  0x1C,0x1C,0x0,0x36,0x0,0x22,0x0,0x0
	.DB  0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0
	.DB  0x27,0x0,0x3F,0x0,0x1F,0x0,0x0,0x0
	.DB  0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0
	.DB  0x0,0x0,0x0,0x0,0x0,0x0,0xF0,0x3
	.DB  0xFC,0xF,0xFE,0x1F,0x7,0x38,0x1,0x20
	.DB  0x1,0x20,0x0,0x0,0x0,0x0,0x0,0x0
	.DB  0x0,0x0,0x0,0x0,0x0,0x0,0x1,0x20
	.DB  0x1,0x20,0x7,0x38,0xFE,0x1F,0xFC,0xF
	.DB  0xF0,0x3,0x0,0x0,0x0,0x0,0x0,0x0
	.DB  0x0,0x0,0x0,0x0,0x98,0xC,0xB8,0xE
	.DB  0xE0,0x3,0xF8,0xF,0xF8,0xF,0xE0,0x3
	.DB  0xB8,0xE,0x98,0xC,0x0,0x0,0x0,0x0
	.DB  0x0,0x0,0x0,0x0,0x80,0x1,0x80,0x1
	.DB  0x80,0x1,0xF0,0xF,0xF0,0xF,0x80,0x1
	.DB  0x80,0x1,0x80,0x1,0x0,0x0,0x0,0x0
	.DB  0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0
	.DB  0x0,0xB8,0x0,0xF8,0x0,0x78,0x0,0x0
	.DB  0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0
	.DB  0x0,0x0,0x0,0x0,0x80,0x1,0x80,0x1
	.DB  0x80,0x1,0x80,0x1,0x80,0x1,0x80,0x1
	.DB  0x80,0x1,0x80,0x1,0x0,0x0,0x0,0x0
	.DB  0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0
	.DB  0x0,0x38,0x0,0x38,0x0,0x38,0x0,0x0
	.DB  0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0
	.DB  0x0,0x0,0x0,0x18,0x0,0x1C,0x0,0xE
	.DB  0x0,0x7,0x80,0x3,0xC0,0x1,0xE0,0x0
	.DB  0x70,0x0,0x38,0x0,0x1C,0x0,0xE,0x0
	.DB  0x0,0x0,0xF8,0x7,0xFE,0x1F,0x6,0x18
	.DB  0x3,0x30,0x3,0x30,0x3,0x30,0x3,0x30
	.DB  0x3,0x30,0x6,0x18,0xFE,0x1F,0xF8,0x7
	.DB  0x0,0x0,0x0,0x0,0x0,0x0,0xC,0x30
	.DB  0xC,0x30,0xE,0x30,0xFF,0x3F,0xFF,0x3F
	.DB  0x0,0x30,0x0,0x30,0x0,0x30,0x0,0x0
	.DB  0x0,0x0,0x1C,0x30,0x1E,0x38,0x7,0x3C
	.DB  0x3,0x3E,0x3,0x37,0x83,0x33,0xC3,0x31
	.DB  0xE3,0x30,0x77,0x30,0x3E,0x30,0x1C,0x30
	.DB  0x0,0x0,0xC,0xC,0xE,0x1C,0x7,0x38
	.DB  0xC3,0x30,0xC3,0x30,0xC3,0x30,0xC3,0x30
	.DB  0xC3,0x30,0xE7,0x39,0x7E,0x1F,0x3C,0xE
	.DB  0x0,0x0,0xC0,0x3,0xE0,0x3,0x70,0x3
	.DB  0x38,0x3,0x1C,0x3,0xE,0x3,0x7,0x3
	.DB  0xFF,0x3F,0xFF,0x3F,0x0,0x3,0x0,0x3
	.DB  0x0,0x0,0x3F,0xC,0x7F,0x1C,0x63,0x38
	.DB  0x63,0x30,0x63,0x30,0x63,0x30,0x63,0x30
	.DB  0x63,0x30,0xE3,0x38,0xC3,0x1F,0x83,0xF
	.DB  0x0,0x0,0xC0,0xF,0xF0,0x1F,0xF8,0x39
	.DB  0xDC,0x30,0xCE,0x30,0xC7,0x30,0xC3,0x30
	.DB  0xC3,0x30,0xC3,0x39,0x80,0x1F,0x0,0xF
	.DB  0x0,0x0,0x3,0x0,0x3,0x0,0x3,0x0
	.DB  0x3,0x30,0x3,0x3C,0x3,0xF,0xC3,0x3
	.DB  0xF3,0x0,0x3F,0x0,0xF,0x0,0x3,0x0
	.DB  0x0,0x0,0x0,0xF,0xBC,0x1F,0xFE,0x39
	.DB  0xE7,0x30,0xC3,0x30,0xC3,0x30,0xC3,0x30
	.DB  0xE7,0x30,0xFE,0x39,0xBC,0x1F,0x0,0xF
	.DB  0x0,0x0,0x3C,0x0,0x7E,0x0,0xE7,0x30
	.DB  0xC3,0x30,0xC3,0x30,0xC3,0x38,0xC3,0x1C
	.DB  0xC3,0xE,0xE7,0x7,0xFE,0x3,0xFC,0x0
	.DB  0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0
	.DB  0x70,0x1C,0x70,0x1C,0x70,0x1C,0x0,0x0
	.DB  0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0
	.DB  0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0
	.DB  0x70,0x9C,0x70,0xFC,0x70,0x7C,0x0,0x0
	.DB  0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0
	.DB  0x0,0x0,0x0,0x0,0xC0,0x0,0xE0,0x1
	.DB  0xF0,0x3,0x38,0x7,0x1C,0xE,0xE,0x1C
	.DB  0x7,0x38,0x3,0x30,0x0,0x0,0x0,0x0
	.DB  0x0,0x0,0x0,0x0,0x60,0x6,0x60,0x6
	.DB  0x60,0x6,0x60,0x6,0x60,0x6,0x60,0x6
	.DB  0x60,0x6,0x60,0x6,0x60,0x6,0x0,0x0
	.DB  0x0,0x0,0x0,0x0,0x3,0x30,0x7,0x38
	.DB  0xE,0x1C,0x1C,0xE,0x38,0x7,0xF0,0x3
	.DB  0xE0,0x1,0xC0,0x0,0x0,0x0,0x0,0x0
	.DB  0x0,0x0,0x1C,0x0,0x1E,0x0,0x7,0x0
	.DB  0x3,0x0,0x83,0x37,0xC3,0x37,0xE3,0x0
	.DB  0x77,0x0,0x3E,0x0,0x1C,0x0,0x0,0x0
	.DB  0x0,0x0,0xF8,0xF,0xFE,0x1F,0x7,0x18
	.DB  0xF3,0x33,0xFB,0x37,0x1B,0x36,0xFB,0x37
	.DB  0xFB,0x37,0x7,0x36,0xFE,0x3,0xF8,0x1
	.DB  0x0,0x0,0x0,0x38,0x0,0x3F,0xE0,0x7
	.DB  0xFC,0x6,0x1F,0x6,0x1F,0x6,0xFC,0x6
	.DB  0xE0,0x7,0x0,0x3F,0x0,0x38,0x0,0x0
	.DB  0x0,0x0,0xFF,0x3F,0xFF,0x3F,0xC3,0x30
	.DB  0xC3,0x30,0xC3,0x30,0xC3,0x30,0xE7,0x30
	.DB  0xFE,0x39,0xBC,0x1F,0x0,0xF,0x0,0x0
	.DB  0x0,0x0,0xF0,0x3,0xFC,0xF,0xE,0x1C
	.DB  0x7,0x38,0x3,0x30,0x3,0x30,0x3,0x30
	.DB  0x7,0x38,0xE,0x1C,0xC,0xC,0x0,0x0
	.DB  0x0,0x0,0xFF,0x3F,0xFF,0x3F,0x3,0x30
	.DB  0x3,0x30,0x3,0x30,0x3,0x30,0x7,0x38
	.DB  0xE,0x1C,0xFC,0xF,0xF0,0x3,0x0,0x0
	.DB  0x0,0x0,0xFF,0x3F,0xFF,0x3F,0xC3,0x30
	.DB  0xC3,0x30,0xC3,0x30,0xC3,0x30,0xC3,0x30
	.DB  0xC3,0x30,0x3,0x30,0x3,0x30,0x0,0x0
	.DB  0x0,0x0,0xFF,0x3F,0xFF,0x3F,0xC3,0x0
	.DB  0xC3,0x0,0xC3,0x0,0xC3,0x0,0xC3,0x0
	.DB  0xC3,0x0,0x3,0x0,0x3,0x0,0x0,0x0
	.DB  0x0,0x0,0xF0,0x3,0xFC,0xF,0xE,0x1C
	.DB  0x7,0x38,0x3,0x30,0xC3,0x30,0xC3,0x30
	.DB  0xC3,0x30,0xC7,0x3F,0xC6,0x3F,0x0,0x0
	.DB  0x0,0x0,0xFF,0x3F,0xFF,0x3F,0xC0,0x0
	.DB  0xC0,0x0,0xC0,0x0,0xC0,0x0,0xC0,0x0
	.DB  0xC0,0x0,0xFF,0x3F,0xFF,0x3F,0x0,0x0
	.DB  0x0,0x0,0x0,0x0,0x0,0x0,0x3,0x30
	.DB  0x3,0x30,0xFF,0x3F,0xFF,0x3F,0x3,0x30
	.DB  0x3,0x30,0x0,0x0,0x0,0x0,0x0,0x0
	.DB  0x0,0x0,0x0,0xE,0x0,0x1E,0x0,0x38
	.DB  0x0,0x30,0x0,0x30,0x0,0x30,0x0,0x30
	.DB  0x0,0x38,0xFF,0x1F,0xFF,0x7,0x0,0x0
	.DB  0x0,0x0,0xFF,0x3F,0xFF,0x3F,0xC0,0x0
	.DB  0xE0,0x1,0xF0,0x3,0x38,0x7,0x1C,0xE
	.DB  0xE,0x1C,0x7,0x38,0x3,0x30,0x0,0x0
	.DB  0x0,0x0,0xFF,0x3F,0xFF,0x3F,0x0,0x30
	.DB  0x0,0x30,0x0,0x30,0x0,0x30,0x0,0x30
	.DB  0x0,0x30,0x0,0x30,0x0,0x30,0x0,0x0
	.DB  0x0,0x0,0xFF,0x3F,0xFF,0x3F,0x1E,0x0
	.DB  0x78,0x0,0xE0,0x1,0xE0,0x1,0x78,0x0
	.DB  0x1E,0x0,0xFF,0x3F,0xFF,0x3F,0x0,0x0
	.DB  0x0,0x0,0xFF,0x3F,0xFF,0x3F,0xE,0x0
	.DB  0x38,0x0,0xF0,0x0,0xC0,0x3,0x0,0x7
	.DB  0x0,0x1C,0xFF,0x3F,0xFF,0x3F,0x0,0x0
	.DB  0x0,0x0,0xF0,0x3,0xFC,0xF,0xE,0x1C
	.DB  0x7,0x38,0x3,0x30,0x3,0x30,0x7,0x38
	.DB  0xE,0x1C,0xFC,0xF,0xF0,0x3,0x0,0x0
	.DB  0x0,0x0,0xFF,0x3F,0xFF,0x3F,0x83,0x1
	.DB  0x83,0x1,0x83,0x1,0x83,0x1,0x83,0x1
	.DB  0xC7,0x1,0xFE,0x0,0x7C,0x0,0x0,0x0
	.DB  0x0,0x0,0xF0,0x3,0xFC,0xF,0xE,0x1C
	.DB  0x7,0x38,0x3,0x30,0x3,0x36,0x7,0x3E
	.DB  0xE,0x1C,0xFC,0x3F,0xF0,0x33,0x0,0x0
	.DB  0x0,0x0,0xFF,0x3F,0xFF,0x3F,0x83,0x1
	.DB  0x83,0x1,0x83,0x3,0x83,0x7,0x83,0xF
	.DB  0xC7,0x1D,0xFE,0x38,0x7C,0x30,0x0,0x0
	.DB  0x0,0x0,0x3C,0xC,0x7E,0x1C,0xE7,0x38
	.DB  0xC3,0x30,0xC3,0x30,0xC3,0x30,0xC3,0x30
	.DB  0xC7,0x39,0x8E,0x1F,0xC,0xF,0x0,0x0
	.DB  0x0,0x0,0x0,0x0,0x3,0x0,0x3,0x0
	.DB  0x3,0x0,0xFF,0x3F,0xFF,0x3F,0x3,0x0
	.DB  0x3,0x0,0x3,0x0,0x0,0x0,0x0,0x0
	.DB  0x0,0x0,0xFF,0x7,0xFF,0x1F,0x0,0x38
	.DB  0x0,0x30,0x0,0x30,0x0,0x30,0x0,0x30
	.DB  0x0,0x38,0xFF,0x1F,0xFF,0x7,0x0,0x0
	.DB  0x0,0x0,0x7,0x0,0x3F,0x0,0xF8,0x1
	.DB  0xC0,0xF,0x0,0x3E,0x0,0x3E,0xC0,0xF
	.DB  0xF8,0x1,0x3F,0x0,0x7,0x0,0x0,0x0
	.DB  0x0,0x0,0xFF,0x3F,0xFF,0x3F,0x0,0x1C
	.DB  0x0,0x6,0x80,0x3,0x80,0x3,0x0,0x6
	.DB  0x0,0x1C,0xFF,0x3F,0xFF,0x3F,0x0,0x0
	.DB  0x0,0x0,0x3,0x30,0xF,0x3C,0x1C,0xE
	.DB  0x30,0x3,0xE0,0x1,0xE0,0x1,0x30,0x3
	.DB  0x1C,0xE,0xF,0x3C,0x3,0x30,0x0,0x0
	.DB  0x0,0x0,0x3,0x0,0xF,0x0,0x3C,0x0
	.DB  0xF0,0x0,0xC0,0x3F,0xC0,0x3F,0xF0,0x0
	.DB  0x3C,0x0,0xF,0x0,0x3,0x0,0x0,0x0
	.DB  0x0,0x0,0x3,0x30,0x3,0x3C,0x3,0x3E
	.DB  0x3,0x33,0xC3,0x31,0xE3,0x30,0x33,0x30
	.DB  0x1F,0x30,0xF,0x30,0x3,0x30,0x0,0x0
	.DB  0x0,0x0,0x0,0x0,0x0,0x0,0xFF,0x3F
	.DB  0xFF,0x3F,0x3,0x30,0x3,0x30,0x3,0x30
	.DB  0x3,0x30,0x0,0x0,0x0,0x0,0x0,0x0
	.DB  0x0,0x0,0xE,0x0,0x1C,0x0,0x38,0x0
	.DB  0x70,0x0,0xE0,0x0,0xC0,0x1,0x80,0x3
	.DB  0x0,0x7,0x0,0xE,0x0,0x1C,0x0,0x18
	.DB  0x0,0x0,0x0,0x0,0x0,0x0,0x3,0x30
	.DB  0x3,0x30,0x3,0x30,0x3,0x30,0xFF,0x3F
	.DB  0xFF,0x3F,0x0,0x0,0x0,0x0,0x0,0x0
	.DB  0x0,0x0,0x60,0x0,0x70,0x0,0x38,0x0
	.DB  0x1C,0x0,0xE,0x0,0x7,0x0,0xE,0x0
	.DB  0x1C,0x0,0x38,0x0,0x70,0x0,0x60,0x0
	.DB  0x0,0x0,0x0,0xC0,0x0,0xC0,0x0,0xC0
	.DB  0x0,0xC0,0x0,0xC0,0x0,0xC0,0x0,0xC0
	.DB  0x0,0xC0,0x0,0xC0,0x0,0xC0,0x0,0xC0
	.DB  0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0
	.DB  0x0,0x0,0x3E,0x0,0x7E,0x0,0x4E,0x0
	.DB  0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0
	.DB  0x0,0x0,0x0,0x1C,0x40,0x3E,0x60,0x33
	.DB  0x60,0x33,0x60,0x33,0x60,0x33,0x60,0x33
	.DB  0x60,0x33,0xE0,0x3F,0xC0,0x3F,0x0,0x0
	.DB  0x0,0x0,0xFF,0x3F,0xFF,0x3F,0xC0,0x30
	.DB  0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30
	.DB  0xE0,0x38,0xC0,0x1F,0x80,0xF,0x0,0x0
	.DB  0x0,0x0,0x80,0xF,0xC0,0x1F,0xE0,0x38
	.DB  0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30
	.DB  0x60,0x30,0xC0,0x18,0x80,0x8,0x0,0x0
	.DB  0x0,0x0,0x80,0xF,0xC0,0x1F,0xE0,0x38
	.DB  0x60,0x30,0x60,0x30,0x60,0x30,0xE0,0x30
	.DB  0xC0,0x30,0xFF,0x3F,0xFF,0x3F,0x0,0x0
	.DB  0x0,0x0,0x80,0xF,0xC0,0x1F,0xE0,0x3B
	.DB  0x60,0x33,0x60,0x33,0x60,0x33,0x60,0x33
	.DB  0x60,0x33,0xC0,0x13,0x80,0x1,0x0,0x0
	.DB  0x0,0x0,0xC0,0x0,0xC0,0x0,0xFC,0x3F
	.DB  0xFE,0x3F,0xC7,0x0,0xC3,0x0,0xC3,0x0
	.DB  0x3,0x0,0x0,0x0,0x0,0x0,0x0,0x0
	.DB  0x0,0x0,0x80,0x3,0xC0,0xC7,0xE0,0xCE
	.DB  0x60,0xCC,0x60,0xCC,0x60,0xCC,0x60,0xCC
	.DB  0x60,0xE6,0xE0,0x7F,0xE0,0x3F,0x0,0x0
	.DB  0x0,0x0,0xFF,0x3F,0xFF,0x3F,0xC0,0x0
	.DB  0x60,0x0,0x60,0x0,0x60,0x0,0xE0,0x0
	.DB  0xC0,0x3F,0x80,0x3F,0x0,0x0,0x0,0x0
	.DB  0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x30
	.DB  0x60,0x30,0xEC,0x3F,0xEC,0x3F,0x0,0x30
	.DB  0x0,0x30,0x0,0x0,0x0,0x0,0x0,0x0
	.DB  0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x60
	.DB  0x0,0xE0,0x0,0xC0,0x60,0xC0,0xEC,0xFF
	.DB  0xEC,0x7F,0x0,0x0,0x0,0x0,0x0,0x0
	.DB  0x0,0x0,0x0,0x0,0xFF,0x3F,0xFF,0x3F
	.DB  0x0,0x3,0x80,0x7,0xC0,0xF,0xE0,0x1C
	.DB  0x60,0x38,0x0,0x30,0x0,0x0,0x0,0x0
	.DB  0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x30
	.DB  0x3,0x30,0xFF,0x3F,0xFF,0x3F,0x0,0x30
	.DB  0x0,0x30,0x0,0x0,0x0,0x0,0x0,0x0
	.DB  0x0,0x0,0xE0,0x3F,0xC0,0x3F,0xE0,0x0
	.DB  0xE0,0x0,0xC0,0x3F,0xC0,0x3F,0xE0,0x0
	.DB  0xE0,0x0,0xC0,0x3F,0x80,0x3F,0x0,0x0
	.DB  0x0,0x0,0x0,0x0,0xE0,0x3F,0xE0,0x3F
	.DB  0x60,0x0,0x60,0x0,0x60,0x0,0x60,0x0
	.DB  0xE0,0x0,0xC0,0x3F,0x80,0x3F,0x0,0x0
	.DB  0x0,0x0,0x80,0xF,0xC0,0x1F,0xE0,0x38
	.DB  0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30
	.DB  0xE0,0x38,0xC0,0x1F,0x80,0xF,0x0,0x0
	.DB  0x0,0x0,0xE0,0xFF,0xE0,0xFF,0x60,0xC
	.DB  0x60,0x18,0x60,0x18,0x60,0x18,0x60,0x18
	.DB  0xE0,0x1C,0xC0,0xF,0x80,0x7,0x0,0x0
	.DB  0x0,0x0,0x80,0x7,0xC0,0xF,0xE0,0x1C
	.DB  0x60,0x18,0x60,0x18,0x60,0x18,0x60,0x18
	.DB  0x60,0xC,0xE0,0xFF,0xE0,0xFF,0x0,0x0
	.DB  0x0,0x0,0x0,0x0,0xE0,0x3F,0xE0,0x3F
	.DB  0xC0,0x0,0x60,0x0,0x60,0x0,0x60,0x0
	.DB  0x60,0x0,0xE0,0x0,0xC0,0x0,0x0,0x0
	.DB  0x0,0x0,0xC0,0x11,0xE0,0x33,0x60,0x33
	.DB  0x60,0x33,0x60,0x33,0x60,0x33,0x60,0x3F
	.DB  0x40,0x1E,0x0,0x0,0x0,0x0,0x0,0x0
	.DB  0x0,0x0,0x60,0x0,0x60,0x0,0xFE,0x1F
	.DB  0xFE,0x3F,0x60,0x30,0x60,0x30,0x60,0x30
	.DB  0x0,0x30,0x0,0x0,0x0,0x0,0x0,0x0
	.DB  0x0,0x0,0xE0,0xF,0xE0,0x1F,0x0,0x38
	.DB  0x0,0x30,0x0,0x30,0x0,0x30,0x0,0x30
	.DB  0x0,0x18,0xE0,0x3F,0xE0,0x3F,0x0,0x0
	.DB  0x0,0x0,0x60,0x0,0xE0,0x1,0x80,0x7
	.DB  0x0,0x1E,0x0,0x38,0x0,0x38,0x0,0x1E
	.DB  0x80,0x7,0xE0,0x1,0x60,0x0,0x0,0x0
	.DB  0x0,0x0,0xE0,0x7,0xE0,0x1F,0x0,0x38
	.DB  0x0,0x1C,0xE0,0xF,0xE0,0xF,0x0,0x1C
	.DB  0x0,0x38,0xE0,0x1F,0xE0,0x7,0x0,0x0
	.DB  0x0,0x0,0x60,0x30,0xE0,0x38,0xC0,0x1D
	.DB  0x80,0xF,0x0,0x7,0x80,0xF,0xC0,0x1D
	.DB  0xE0,0x38,0x60,0x30,0x0,0x0,0x0,0x0
	.DB  0x0,0x0,0x0,0x0,0x60,0x0,0xE0,0x81
	.DB  0x80,0xE7,0x0,0x7E,0x0,0x1E,0x80,0x7
	.DB  0xE0,0x1,0x60,0x0,0x0,0x0,0x0,0x0
	.DB  0x0,0x0,0x60,0x30,0x60,0x38,0x60,0x3C
	.DB  0x60,0x36,0x60,0x33,0xE0,0x31,0xE0,0x30
	.DB  0x60,0x30,0x20,0x30,0x0,0x0,0x0,0x0
	.DB  0x0,0x0,0x0,0x0,0x80,0x0,0xC0,0x1
	.DB  0xFC,0x1F,0x7E,0x3F,0x7,0x70,0x3,0x60
	.DB  0x3,0x60,0x3,0x60,0x0,0x0,0x0,0x0
	.DB  0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0
	.DB  0x0,0x0,0xFF,0x3F,0xFF,0x3F,0x0,0x0
	.DB  0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0
	.DB  0x0,0x0,0x0,0x0,0x3,0x60,0x3,0x60
	.DB  0x3,0x60,0x7,0x70,0x7E,0x3F,0xFC,0x1F
	.DB  0xC0,0x1,0x80,0x0,0x0,0x0,0x0,0x0
	.DB  0x0,0x0,0x10,0x0,0x18,0x0,0xC,0x0
	.DB  0x4,0x0,0xC,0x0,0x18,0x0,0x10,0x0
	.DB  0x18,0x0,0xC,0x0,0x4,0x0,0x0,0x0
	.DB  0x0,0x0,0x0,0xF,0x80,0xF,0xC0,0xC
	.DB  0x60,0xC,0x30,0xC,0x30,0xC,0x60,0xC
	.DB  0xC0,0xC,0x80,0xF,0x0,0xF,0x0,0x0
	.DB  0x55,0x55,0x0,0x0,0xAA,0xAA,0x0,0x0
	.DB  0x55,0x55,0x0,0x0,0xAA,0xAA,0x0,0x0
	.DB  0x55,0x55,0x0,0x0,0xAA,0xAA,0x0,0x0
	.DB  0xAA,0xAA,0x55,0x55,0xAA,0xAA,0x55,0x55
	.DB  0xAA,0xAA,0x55,0x55,0xAA,0xAA,0x55,0x55
	.DB  0xAA,0xAA,0x55,0x55,0xAA,0xAA,0x55,0x55
	.DB  0xAA,0xAA,0xFF,0xFF,0x55,0x55,0xFF,0xFF
	.DB  0xAA,0xAA,0xFF,0xFF,0x55,0x55,0xFF,0xFF
	.DB  0xAA,0xAA,0xFF,0xFF,0x55,0x55,0xFF,0xFF
	.DB  0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0
	.DB  0x0,0x0,0xFF,0xFF,0xFF,0xFF,0x0,0x0
	.DB  0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0
	.DB  0x80,0x1,0x80,0x1,0x80,0x1,0x80,0x1
	.DB  0x80,0x1,0xFF,0xFF,0xFF,0xFF,0x0,0x0
	.DB  0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0
	.DB  0xC0,0x6,0xC0,0x6,0xC0,0x6,0xC0,0x6
	.DB  0xC0,0x6,0xFF,0xFF,0xFF,0xFF,0x0,0x0
	.DB  0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0
	.DB  0x80,0x1,0x80,0x1,0xFF,0xFF,0xFF,0xFF
	.DB  0x0,0x0,0xFF,0xFF,0xFF,0xFF,0x0,0x0
	.DB  0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0
	.DB  0x80,0x1,0x80,0x1,0x80,0xFF,0x80,0xFF
	.DB  0x80,0x1,0x80,0xFF,0x80,0xFF,0x0,0x0
	.DB  0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0
	.DB  0xC0,0x6,0xC0,0x6,0xC0,0x6,0xC0,0x6
	.DB  0xC0,0x6,0xC0,0xFF,0xC0,0xFF,0x0,0x0
	.DB  0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0
	.DB  0xC0,0x6,0xC0,0x6,0xFF,0xFE,0xFF,0xFE
	.DB  0x0,0x0,0xFF,0xFF,0xFF,0xFF,0x0,0x0
	.DB  0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0
	.DB  0x0,0x0,0x0,0x0,0xFF,0xFF,0xFF,0xFF
	.DB  0x0,0x0,0xFF,0xFF,0xFF,0xFF,0x0,0x0
	.DB  0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0
	.DB  0xC0,0x6,0xC0,0x6,0xC0,0xFE,0xC0,0xFE
	.DB  0xC0,0x0,0xC0,0xFF,0xC0,0xFF,0x0,0x0
	.DB  0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0
	.DB  0xC0,0x6,0xC0,0x6,0xFF,0x6,0xFF,0x6
	.DB  0x0,0x6,0xFF,0x7,0xFF,0x7,0x0,0x0
	.DB  0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0
	.DB  0x80,0x1,0x80,0x1,0xFF,0x1,0xFF,0x1
	.DB  0x80,0x1,0xFF,0x1,0xFF,0x1,0x0,0x0
	.DB  0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0
	.DB  0xC0,0x6,0xC0,0x6,0xC0,0x6,0xC0,0x6
	.DB  0xC0,0x6,0xFF,0x7,0xFF,0x7,0x0,0x0
	.DB  0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0
	.DB  0x80,0x1,0x80,0x1,0x80,0x1,0x80,0x1
	.DB  0x80,0x1,0x80,0xFF,0x80,0xFF,0x0,0x0
	.DB  0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0
	.DB  0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0
	.DB  0x0,0x0,0xFF,0x1,0xFF,0x1,0x80,0x1
	.DB  0x80,0x1,0x80,0x1,0x80,0x1,0x80,0x1
	.DB  0x80,0x1,0x80,0x1,0x80,0x1,0x80,0x1
	.DB  0x80,0x1,0xFF,0x1,0xFF,0x1,0x80,0x1
	.DB  0x80,0x1,0x80,0x1,0x80,0x1,0x80,0x1
	.DB  0x80,0x1,0x80,0x1,0x80,0x1,0x80,0x1
	.DB  0x80,0x1,0x80,0xFF,0x80,0xFF,0x80,0x1
	.DB  0x80,0x1,0x80,0x1,0x80,0x1,0x80,0x1
	.DB  0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0
	.DB  0x0,0x0,0xFF,0xFF,0xFF,0xFF,0x80,0x1
	.DB  0x80,0x1,0x80,0x1,0x80,0x1,0x80,0x1
	.DB  0x80,0x1,0x80,0x1,0x80,0x1,0x80,0x1
	.DB  0x80,0x1,0x80,0x1,0x80,0x1,0x80,0x1
	.DB  0x80,0x1,0x80,0x1,0x80,0x1,0x80,0x1
	.DB  0x80,0x1,0x80,0x1,0x80,0x1,0x80,0x1
	.DB  0x80,0x1,0xFF,0xFF,0xFF,0xFF,0x80,0x1
	.DB  0x80,0x1,0x80,0x1,0x80,0x1,0x80,0x1
	.DB  0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0
	.DB  0x0,0x0,0xFF,0xFF,0xFF,0xFF,0xC0,0x6
	.DB  0xC0,0x6,0xC0,0x6,0xC0,0x6,0xC0,0x6
	.DB  0x0,0x0,0x0,0x0,0xFF,0xFF,0xFF,0xFF
	.DB  0x0,0x0,0xFF,0xFF,0xFF,0xFF,0x80,0x1
	.DB  0x80,0x1,0x80,0x1,0x80,0x1,0x80,0x1
	.DB  0x0,0x0,0x0,0x0,0xFF,0x7,0xFF,0x7
	.DB  0x0,0x6,0xFF,0x6,0xFF,0x6,0xC0,0x6
	.DB  0xC0,0x6,0xC0,0x6,0xC0,0x6,0xC0,0x6
	.DB  0x0,0x0,0x0,0x0,0xC0,0xFF,0xC0,0xFF
	.DB  0xC0,0x0,0xC0,0xFE,0xC0,0xFE,0xC0,0x6
	.DB  0xC0,0x6,0xC0,0x6,0xC0,0x6,0xC0,0x6
	.DB  0xC0,0x6,0xC0,0x6,0xFF,0x6,0xFF,0x6
	.DB  0x0,0x6,0xFF,0x6,0xFF,0x6,0xC0,0x6
	.DB  0xC0,0x6,0xC0,0x6,0xC0,0x6,0xC0,0x6
	.DB  0xC0,0x6,0xC0,0x6,0xC0,0xFE,0xC0,0xFE
	.DB  0xC0,0x0,0xC0,0xFE,0xC0,0xFE,0xC0,0x6
	.DB  0xC0,0x6,0xC0,0x6,0xC0,0x6,0xC0,0x6
	.DB  0x0,0x0,0x0,0x0,0xFF,0xFF,0xFF,0xFF
	.DB  0x0,0x0,0xFF,0xFE,0xFF,0xFE,0xC0,0x6
	.DB  0xC0,0x6,0xC0,0x6,0xC0,0x6,0xC0,0x6
	.DB  0xC0,0x6,0xC0,0x6,0xC0,0x6,0xC0,0x6
	.DB  0xC0,0x6,0xC0,0x6,0xC0,0x6,0xC0,0x6
	.DB  0xC0,0x6,0xC0,0x6,0xC0,0x6,0xC0,0x6
	.DB  0xC0,0x6,0xC0,0x6,0xFF,0xFE,0xFF,0xFE
	.DB  0x0,0x0,0xFF,0xFE,0xFF,0xFE,0xC0,0x6
	.DB  0xC0,0x6,0xC0,0x6,0xC0,0x6,0xC0,0x6
	.DB  0xC0,0x6,0xC0,0x6,0xC0,0x6,0xC0,0x6
	.DB  0xC0,0x6,0xFF,0x6,0xFF,0x6,0xC0,0x6
	.DB  0xC0,0x6,0xC0,0x6,0xC0,0x6,0xC0,0x6
	.DB  0x80,0x1,0x80,0x1,0xFF,0x1,0xFF,0x1
	.DB  0x80,0x1,0xFF,0x1,0xFF,0x1,0x80,0x1
	.DB  0x80,0x1,0x80,0x1,0x80,0x1,0x80,0x1
	.DB  0xC0,0x6,0xC0,0x6,0xC0,0x6,0xC0,0x6
	.DB  0xC0,0x6,0xC0,0xFE,0xC0,0xFE,0xC0,0x6
	.DB  0xC0,0x6,0xC0,0x6,0xC0,0x6,0xC0,0x6
	.DB  0x80,0x1,0x80,0x1,0x80,0xFF,0x80,0xFF
	.DB  0x80,0x1,0x80,0xFF,0x80,0xFF,0x80,0x1
	.DB  0x80,0x1,0x80,0x1,0x80,0x1,0x80,0x1
	.DB  0x0,0x0,0x0,0x0,0xFF,0x1,0xFF,0x1
	.DB  0x80,0x1,0xFF,0x1,0xFF,0x1,0x80,0x1
	.DB  0x80,0x1,0x80,0x1,0x80,0x1,0x80,0x1
	.DB  0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0
	.DB  0x0,0x0,0xFF,0x7,0xFF,0x7,0xC0,0x6
	.DB  0xC0,0x6,0xC0,0x6,0xC0,0x6,0xC0,0x6
	.DB  0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0
	.DB  0x0,0x0,0xC0,0xFF,0xC0,0xFF,0xC0,0x6
	.DB  0xC0,0x6,0xC0,0x6,0xC0,0x6,0xC0,0x6
	.DB  0x0,0x0,0x0,0x0,0x80,0xFF,0x80,0xFF
	.DB  0x80,0x1,0x80,0xFF,0x80,0xFF,0x80,0x1
	.DB  0x80,0x1,0x80,0x1,0x80,0x1,0x80,0x1
	.DB  0x80,0x1,0x80,0x1,0xFF,0xFF,0xFF,0xFF
	.DB  0x0,0x0,0xFF,0xFF,0xFF,0xFF,0x80,0x1
	.DB  0x80,0x1,0x80,0x1,0x80,0x1,0x80,0x1
	.DB  0x0,0x0,0xF8,0x3F,0xF8,0x3F,0x9B,0x31
	.DB  0x9B,0x31,0x98,0x31,0x98,0x31,0x9B,0x31
	.DB  0x9B,0x31,0x18,0x30,0x18,0x30,0x0,0x0
	.DB  0xC0,0x6,0xC0,0x6,0xC0,0x6,0xC0,0x6
	.DB  0xC0,0x6,0xFF,0xFE,0xFF,0xFE,0xC0,0x6
	.DB  0xC0,0x6,0xC0,0x6,0xC0,0x6,0xC0,0x6
	.DB  0x80,0x1,0x80,0x1,0x80,0x1,0x80,0x1
	.DB  0x80,0x1,0xFF,0x1,0xFF,0x1,0x0,0x0
	.DB  0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0
	.DB  0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0
	.DB  0x0,0x0,0x80,0xFF,0x80,0xFF,0x80,0x1
	.DB  0x80,0x1,0x80,0x1,0x80,0x1,0x80,0x1
	.DB  0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF
	.DB  0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF
	.DB  0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF
	.DB  0x0,0xFF,0x0,0xFF,0x0,0xFF,0x0,0xFF
	.DB  0x0,0xFF,0x0,0xFF,0x0,0xFF,0x0,0xFF
	.DB  0x0,0xFF,0x0,0xFF,0x0,0xFF,0x0,0xFF
	.DB  0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF
	.DB  0xFF,0xFF,0xFF,0xFF,0x0,0x0,0x0,0x0
	.DB  0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0
	.DB  0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0
	.DB  0x0,0x0,0x0,0x0,0xFF,0xFF,0xFF,0xFF
	.DB  0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF
	.DB  0xFF,0x0,0xFF,0x0,0xFF,0x0,0xFF,0x0
	.DB  0xFF,0x0,0xFF,0x0,0xFF,0x0,0xFF,0x0
	.DB  0xFF,0x0,0xFF,0x0,0xFF,0x0,0xFF,0x0
	.DB  0x0,0x0,0x0,0x0,0xF0,0x0,0x8,0x1
	.DB  0x8,0x2,0x10,0x4,0x20,0x8,0x10,0x4
	.DB  0x8,0x2,0x8,0x1,0xF0,0x0,0x0,0x0
	.DB  0x0,0x0,0xE0,0x1,0xF0,0x3,0xF0,0x7
	.DB  0xF0,0x7,0xE8,0x7,0xE4,0x7,0xE4,0x7
	.DB  0xE4,0x7,0xE4,0x7,0xE8,0x3,0xF0,0x1
	.DB  0x0,0x0,0xE0,0x1,0x30,0x2,0x30,0x4
	.DB  0x30,0x4,0x28,0x4,0x24,0x4,0x24,0x4
	.DB  0x24,0x4,0x24,0x4,0x28,0x2,0xF0,0x1
	.DB  0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0
	.DB  0x80,0x0,0x70,0x0,0x8,0x0,0xF8,0x0
	.DB  0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0
	.DB  0x0,0x0,0x80,0x0,0x80,0x0,0x80,0x0
	.DB  0xA0,0x6,0x9C,0x8,0x82,0x8,0xBE,0x3E
	.DB  0x80,0x0,0x80,0x0,0x80,0x0,0x0,0x0
	.DB  0x0,0x0,0x0,0x0,0x60,0x0,0xE8,0x81
	.DB  0x88,0xE7,0x10,0x7E,0x10,0x1E,0x88,0x7
	.DB  0xE8,0x1,0x60,0x0,0x0,0x0,0x0,0x0
	.DB  0x0,0x0,0x0,0x0,0x0,0x0,0x1E,0x0
	.DB  0x3F,0x0,0x33,0x0,0x33,0x0,0x3F,0x0
	.DB  0x1E,0x0,0x0,0x0,0x0,0x0,0x0,0x0
	.DB  0x0,0x0,0x80,0xF,0xC0,0x1F,0xEC,0x33
	.DB  0x6C,0x33,0x60,0x33,0x60,0x33,0x6C,0x33
	.DB  0x6C,0x33,0xC0,0x13,0x80,0x3,0x0,0x0
	.DB  0x0,0x0,0x0,0x0,0x0,0x0,0xC0,0x3
	.DB  0xE0,0x7,0xE0,0x7,0xE0,0x7,0xE0,0x7
	.DB  0xC0,0x3,0x0,0x0,0x0,0x0,0x0,0x0
	.DB  0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0
	.DB  0x0,0x0,0x80,0x1,0xC0,0x3,0x80,0x1
	.DB  0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0
	.DB  0x0,0x0,0x0,0x0,0x0,0x3,0x0,0x6
	.DB  0x0,0xC,0x0,0x18,0xFE,0x3F,0xFE,0x3F
	.DB  0x6,0x0,0x6,0x0,0x6,0x0,0x6,0x0
	.DB  0xFF,0x3F,0xFF,0x3F,0x1E,0x0,0xF0,0x0
	.DB  0x80,0x3,0x0,0x1E,0xFF,0x3F,0xFF,0x3F
	.DB  0x1C,0x3,0x36,0x3,0x36,0x3,0x1C,0x3
	.DB  0x0,0x0,0xF6,0x1B,0xFE,0x1F,0x18,0x6
	.DB  0xC,0xC,0xC,0xC,0xC,0xC,0xC,0xC
	.DB  0x18,0x6,0xFE,0x1F,0xF6,0x1B,0x0,0x0
	.DB  0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0
	.DB  0xF0,0x3,0xF0,0x3,0xF0,0x3,0xF0,0x3
	.DB  0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0
	.DB  0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0
	.DB  0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0
	.DB  0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0
	.DB  0x0,0x0,0xF0,0x3F,0xFC,0x3F,0xE,0x3
	.DB  0x7,0x3,0x3,0x3,0x3,0x3,0x3,0x3
	.DB  0x3,0x3,0xFF,0x3F,0xFF,0x3F,0x0,0x0
	.DB  0x0,0x0,0xFF,0x3F,0xFF,0x3F,0xC3,0x30
	.DB  0xC3,0x30,0xC3,0x30,0xC3,0x30,0xC3,0x30
	.DB  0xC3,0x39,0x83,0x1F,0x3,0xF,0x0,0x0
	.DB  0x0,0x0,0xFF,0x3F,0xFF,0x3F,0xC3,0x30
	.DB  0xC3,0x30,0xC3,0x30,0xC3,0x30,0xE7,0x30
	.DB  0xFE,0x39,0xBC,0x1F,0x0,0xF,0x0,0x0
	.DB  0x0,0x0,0xFF,0x3F,0xFF,0x3F,0x3,0x0
	.DB  0x3,0x0,0x3,0x0,0x3,0x0,0x3,0x0
	.DB  0x3,0x0,0x3,0x0,0x3,0x0,0x0,0x0
	.DB  0x0,0xF0,0xF0,0xFF,0xFC,0x3F,0xE,0x30
	.DB  0x7,0x30,0x3,0x30,0x3,0x30,0x3,0x30
	.DB  0x3,0x30,0xFF,0x3F,0xFF,0xFF,0x0,0xF0
	.DB  0x0,0x0,0xFF,0x3F,0xFF,0x3F,0xC3,0x30
	.DB  0xC3,0x30,0xC3,0x30,0xC3,0x30,0xC3,0x30
	.DB  0xC3,0x30,0x3,0x30,0x3,0x30,0x0,0x0
	.DB  0xF,0x3C,0x3E,0x1F,0xF8,0x7,0xE0,0x1
	.DB  0xC0,0x0,0xFF,0x3F,0xFF,0x3F,0xC0,0x0
	.DB  0xE0,0x1,0xF8,0x7,0x1E,0x1F,0x7,0x3C
	.DB  0x0,0x0,0xC,0xC,0xE,0x1C,0x7,0x38
	.DB  0xC3,0x30,0xC3,0x30,0xC3,0x30,0xC3,0x30
	.DB  0xC3,0x30,0xE7,0x39,0x7E,0x1F,0x3C,0xE
	.DB  0x0,0x0,0xFF,0x3F,0xFF,0x3F,0x0,0x1C
	.DB  0x0,0x7,0xC0,0x3,0xF0,0x0,0x38,0x0
	.DB  0xE,0x0,0xFF,0x3F,0xFF,0x3F,0x0,0x0
	.DB  0x0,0x0,0xFF,0x3F,0xFF,0x3F,0x0,0x1C
	.DB  0x0,0x7,0xC6,0x3,0xF3,0x0,0x38,0x0
	.DB  0xE,0x0,0xFF,0x3F,0xFF,0x3F,0x0,0x0
	.DB  0x0,0x0,0xFF,0x3F,0xFF,0x3F,0xC0,0x0
	.DB  0xE0,0x1,0xF0,0x3,0x38,0x7,0x1C,0xE
	.DB  0xE,0x1C,0x7,0x38,0x3,0x30,0x0,0x0
	.DB  0x0,0x0,0xF0,0x3F,0xFC,0x3F,0xE,0x0
	.DB  0x7,0x0,0x3,0x0,0x3,0x0,0x3,0x0
	.DB  0x3,0x0,0xFF,0x3F,0xFF,0x3F,0x0,0x0
	.DB  0x0,0x0,0xFF,0x3F,0xFF,0x3F,0x1E,0x0
	.DB  0x78,0x0,0xE0,0x1,0xE0,0x1,0x78,0x0
	.DB  0x1E,0x0,0xFF,0x3F,0xFF,0x3F,0x0,0x0
	.DB  0x0,0x0,0xFF,0x3F,0xFF,0x3F,0xC0,0x0
	.DB  0xC0,0x0,0xC0,0x0,0xC0,0x0,0xC0,0x0
	.DB  0xC0,0x0,0xFF,0x3F,0xFF,0x3F,0x0,0x0
	.DB  0x0,0x0,0xF0,0x3,0xFC,0xF,0xE,0x1C
	.DB  0x7,0x38,0x3,0x30,0x3,0x30,0x7,0x38
	.DB  0xE,0x1C,0xFC,0xF,0xF0,0x3,0x0,0x0
	.DB  0x0,0x0,0xFF,0x3F,0xFF,0x3F,0x3,0x0
	.DB  0x3,0x0,0x3,0x0,0x3,0x0,0x3,0x0
	.DB  0x3,0x0,0xFF,0x3F,0xFF,0x3F,0x0,0x0
	.DB  0x0,0x0,0xFF,0x3F,0xFF,0x3F,0x83,0x1
	.DB  0x83,0x1,0x83,0x1,0x83,0x1,0x83,0x1
	.DB  0xC7,0x1,0xFE,0x0,0x7C,0x0,0x0,0x0
	.DB  0x0,0x0,0xF0,0x3,0xFC,0xF,0xE,0x1C
	.DB  0x7,0x38,0x3,0x30,0x3,0x30,0x3,0x30
	.DB  0x7,0x38,0xE,0x1C,0xC,0xC,0x0,0x0
	.DB  0x0,0x0,0x0,0x0,0x3,0x0,0x3,0x0
	.DB  0x3,0x0,0xFF,0x3F,0xFF,0x3F,0x3,0x0
	.DB  0x3,0x0,0x3,0x0,0x0,0x0,0x0,0x0
	.DB  0x0,0x0,0x7F,0x18,0xFF,0x38,0xC0,0x30
	.DB  0xC0,0x30,0xC0,0x30,0xC0,0x30,0xC0,0x30
	.DB  0xC0,0x38,0xFF,0x1F,0xFF,0x7,0x0,0x0
	.DB  0x0,0x0,0xF8,0x3,0xFC,0x7,0xC,0x6
	.DB  0xC,0x6,0xFF,0x3F,0xFF,0x3F,0xC,0x6
	.DB  0xC,0x6,0xFC,0x7,0xF8,0x3,0x0,0x0
	.DB  0x0,0x0,0x3,0x30,0xF,0x3C,0x1C,0xE
	.DB  0x30,0x3,0xE0,0x1,0xE0,0x1,0x30,0x3
	.DB  0x1C,0xE,0xF,0x3C,0x3,0x30,0x0,0x0
	.DB  0x0,0x0,0xFF,0x3F,0xFF,0x3F,0x0,0x30
	.DB  0x0,0x30,0x0,0x30,0x0,0x30,0x0,0x30
	.DB  0xFF,0x3F,0xFF,0xFF,0x0,0xF0,0x0,0x0
	.DB  0x0,0x0,0x7F,0x0,0xFF,0x0,0xC0,0x0
	.DB  0xC0,0x0,0xC0,0x0,0xC0,0x0,0xC0,0x0
	.DB  0xC0,0x0,0xFF,0x3F,0xFF,0x3F,0x0,0x0
	.DB  0x0,0x0,0xFF,0x3F,0xFF,0x3F,0x0,0x30
	.DB  0x0,0x30,0xFF,0x3F,0xFF,0x3F,0x0,0x30
	.DB  0x0,0x30,0xFF,0x3F,0xFF,0x3F,0x0,0x0
	.DB  0x0,0x0,0xFF,0x3F,0xFF,0x3F,0x0,0x30
	.DB  0x0,0x30,0xFF,0x3F,0xFF,0x3F,0x0,0x30
	.DB  0x0,0x30,0xFF,0x3F,0xFF,0xFF,0x0,0xF0
	.DB  0xF,0x0,0xF,0x0,0x3,0x0,0xFF,0x3F
	.DB  0xFF,0x3F,0x60,0x30,0x60,0x30,0x60,0x30
	.DB  0xE0,0x38,0xC0,0x1F,0x80,0xF,0x0,0x0
	.DB  0x0,0x0,0xFF,0x3F,0xFF,0x3F,0x60,0x30
	.DB  0x60,0x30,0xE0,0x38,0xC0,0x1F,0x80,0xF
	.DB  0x0,0x0,0xFF,0x3F,0xFF,0x3F,0x0,0x0
	.DB  0x0,0x0,0xFF,0x3F,0xFF,0x3F,0x60,0x30
	.DB  0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30
	.DB  0xE0,0x38,0xC0,0x1F,0x80,0xF,0x0,0x0
	.DB  0x0,0x0,0xC,0xC,0xE,0x1C,0x7,0x38
	.DB  0xC3,0x30,0xC3,0x30,0xC3,0x30,0xC7,0x38
	.DB  0xCE,0x1C,0xFC,0xF,0xF0,0x3,0x0,0x0
	.DB  0xFF,0x3F,0xFF,0x3F,0xC0,0x0,0xF0,0x3
	.DB  0xFC,0xF,0xE,0x1C,0x7,0x38,0x3,0x30
	.DB  0x7,0x38,0xE,0x1C,0xFC,0xF,0xF0,0x3
	.DB  0x0,0x0,0x7C,0x30,0xFE,0x38,0xC7,0x1D
	.DB  0x83,0xF,0x83,0x7,0x83,0x3,0x83,0x1
	.DB  0x83,0x1,0xFF,0x3F,0xFF,0x3F,0x0,0x0
	.DB  0x0,0x0,0x0,0x1C,0x40,0x3E,0x60,0x33
	.DB  0x60,0x33,0x60,0x33,0x60,0x33,0x60,0x33
	.DB  0x60,0x33,0xE0,0x3F,0xC0,0x3F,0x0,0x0
	.DB  0x0,0x0,0xF0,0x1F,0xF8,0x3F,0x98,0x31
	.DB  0xD8,0x30,0xD8,0x30,0xD8,0x30,0xD8,0x30
	.DB  0xD8,0x39,0x8C,0x1F,0x0,0xF,0x0,0x0
	.DB  0x0,0x0,0x0,0x0,0xE0,0x3F,0xE0,0x3F
	.DB  0x60,0x32,0x60,0x32,0x60,0x32,0x60,0x32
	.DB  0xE0,0x3F,0xC0,0x1D,0x0,0x0,0x0,0x0
	.DB  0x0,0x0,0x0,0x0,0xE0,0x3F,0xE0,0x3F
	.DB  0x60,0x0,0x60,0x0,0x60,0x0,0x60,0x0
	.DB  0x60,0x0,0x60,0x0,0x0,0x0,0x0,0x0
	.DB  0x0,0x0,0x0,0xF0,0x80,0xFF,0xC0,0x3F
	.DB  0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30
	.DB  0xE0,0x3F,0xE0,0xFF,0x0,0xF0,0x0,0x0
	.DB  0x0,0x0,0x80,0xF,0xC0,0x1F,0xE0,0x3B
	.DB  0x60,0x33,0x60,0x33,0x60,0x33,0x60,0x33
	.DB  0x60,0x33,0xC0,0x13,0x80,0x1,0x0,0x0
	.DB  0x60,0x30,0xE0,0x38,0xC0,0x1F,0x80,0x7
	.DB  0x0,0x3,0xE0,0x3F,0xE0,0x3F,0x0,0x3
	.DB  0x80,0x7,0xC0,0x1F,0xE0,0x38,0x60,0x30
	.DB  0x0,0x0,0x0,0x0,0x80,0x8,0xC0,0x18
	.DB  0x60,0x30,0x60,0x32,0x60,0x32,0x60,0x32
	.DB  0xC0,0x1F,0x80,0xD,0x0,0x0,0x0,0x0
	.DB  0x0,0x0,0x0,0x0,0xE0,0x3F,0xE0,0x3F
	.DB  0x0,0x18,0x0,0xC,0x0,0x6,0x0,0x3
	.DB  0x80,0x1,0xE0,0x3F,0xE0,0x3F,0x0,0x0
	.DB  0x0,0x0,0x0,0x0,0xE0,0x3F,0xE0,0x3F
	.DB  0x0,0x18,0x0,0xC,0x18,0x6,0xC,0x3
	.DB  0x80,0x1,0xE0,0x3F,0xE0,0x3F,0x0,0x0
	.DB  0x0,0x0,0x0,0x0,0xE0,0x3F,0xE0,0x3F
	.DB  0x0,0x3,0x80,0x7,0xC0,0xF,0xE0,0x1C
	.DB  0x60,0x38,0x0,0x30,0x0,0x0,0x0,0x0
	.DB  0x0,0x0,0x0,0x0,0x80,0x3F,0xC0,0x3F
	.DB  0x60,0x0,0x60,0x0,0x60,0x0,0x60,0x0
	.DB  0xE0,0x3F,0xE0,0x3F,0x0,0x0,0x0,0x0
	.DB  0x0,0x0,0xE0,0x3F,0xE0,0x3F,0xE0,0x0
	.DB  0xC0,0x1,0x0,0x3,0x0,0x3,0xC0,0x1
	.DB  0xE0,0x0,0xE0,0x3F,0xE0,0x3F,0x0,0x0
	.DB  0x0,0x0,0x0,0x0,0xE0,0x3F,0xE0,0x3F
	.DB  0x0,0x6,0x0,0x6,0x0,0x6,0x0,0x6
	.DB  0x0,0x6,0xE0,0x3F,0xE0,0x3F,0x0,0x0
	.DB  0x0,0x0,0x80,0xF,0xC0,0x1F,0xE0,0x38
	.DB  0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30
	.DB  0xE0,0x38,0xC0,0x1F,0x80,0xF,0x0,0x0
	.DB  0x0,0x0,0x0,0x0,0xE0,0x3F,0xE0,0x3F
	.DB  0x60,0x0,0x60,0x0,0x60,0x0,0x60,0x0
	.DB  0x60,0x0,0xE0,0x3F,0xE0,0x3F,0x0,0x0
	.DB  0x0,0x0,0xE0,0xFF,0xE0,0xFF,0x60,0xC
	.DB  0x60,0x18,0x60,0x18,0x60,0x18,0x60,0x18
	.DB  0xE0,0x1C,0xC0,0xF,0x80,0x7,0x0,0x0
	.DB  0x0,0x0,0x80,0xF,0xC0,0x1F,0xE0,0x38
	.DB  0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30
	.DB  0x60,0x30,0xC0,0x18,0x80,0x8,0x0,0x0
	.DB  0x0,0x0,0x0,0x0,0x60,0x0,0x60,0x0
	.DB  0x60,0x0,0xE0,0x3F,0xE0,0x3F,0x60,0x0
	.DB  0x60,0x0,0x60,0x0,0x0,0x0,0x0,0x0
	.DB  0x0,0x0,0x0,0x0,0x60,0x0,0xE0,0x81
	.DB  0x80,0xE7,0x0,0x7E,0x0,0x1E,0x80,0x7
	.DB  0xE0,0x1,0x60,0x0,0x0,0x0,0x0,0x0
	.DB  0x0,0x0,0x80,0x1F,0xC0,0x3F,0xC0,0x30
	.DB  0xC0,0x30,0xE0,0xFF,0xE0,0xFF,0xC0,0x30
	.DB  0xC0,0x30,0xC0,0x3F,0x80,0x1F,0x0,0x0
	.DB  0x0,0x0,0x60,0x30,0xE0,0x38,0xC0,0x1D
	.DB  0x80,0xF,0x0,0x7,0x80,0xF,0xC0,0x1D
	.DB  0xE0,0x38,0x60,0x30,0x0,0x0,0x0,0x0
	.DB  0x0,0x0,0x0,0x0,0xE0,0x3F,0xE0,0x3F
	.DB  0x0,0x30,0x0,0x30,0x0,0x30,0x0,0x30
	.DB  0xE0,0x3F,0xE0,0xFF,0x0,0xF0,0x0,0x0
	.DB  0x0,0x0,0x0,0x0,0xE0,0x3,0xE0,0x7
	.DB  0x0,0x6,0x0,0x6,0x0,0x6,0x0,0x6
	.DB  0xE0,0x3F,0xE0,0x3F,0x0,0x0,0x0,0x0
	.DB  0x0,0x0,0xE0,0x3F,0xE0,0x3F,0x0,0x30
	.DB  0x0,0x30,0xE0,0x3F,0xE0,0x3F,0x0,0x30
	.DB  0x0,0x30,0xE0,0x3F,0xE0,0x3F,0x0,0x0
	.DB  0x0,0x0,0xE0,0x3F,0xE0,0x3F,0x0,0x30
	.DB  0x0,0x30,0xE0,0x3F,0xE0,0x3F,0x0,0x30
	.DB  0x0,0x30,0xE0,0x3F,0xE0,0xFF,0x0,0xF0
	.DB  0x0,0x0,0xE0,0x0,0xE0,0x0,0x60,0x0
	.DB  0xE0,0x3F,0xE0,0x3F,0x0,0x33,0x0,0x33
	.DB  0x0,0x33,0x0,0x3F,0x0,0x1E,0x0,0x0
	.DB  0x0,0x0,0xE0,0x3F,0xE0,0x3F,0x0,0x33
	.DB  0x0,0x33,0x0,0x33,0x0,0x3F,0x0,0x1E
	.DB  0x0,0x0,0xE0,0x3F,0xE0,0x3F,0x0,0x0
	.DB  0x0,0x0,0x0,0x0,0xE0,0x3F,0xE0,0x3F
	.DB  0x0,0x33,0x0,0x33,0x0,0x33,0x0,0x33
	.DB  0x0,0x3F,0x0,0x1E,0x0,0x0,0x0,0x0
	.DB  0x0,0x0,0x80,0x8,0xC0,0x18,0x60,0x30
	.DB  0x60,0x30,0x60,0x33,0x60,0x33,0x60,0x3B
	.DB  0xC0,0x1F,0x80,0xF,0x0,0x0,0x0,0x0
	.DB  0x0,0x0,0xE0,0x3F,0xE0,0x3F,0x0,0x3
	.DB  0x80,0xF,0xC0,0x1F,0xE0,0x38,0x60,0x30
	.DB  0xE0,0x38,0xC0,0x1F,0x80,0xF,0x0,0x0
	.DB  0x0,0x0,0x0,0x0,0xC0,0x31,0xE0,0x3B
	.DB  0x60,0x1E,0x60,0xE,0x60,0x6,0x60,0x2
	.DB  0xE0,0x3F,0xE0,0x3F,0x0,0x0,0x0,0x0
_Crc16Table:
	.DB  0x0,0x0,0x21,0x10,0x42,0x20,0x63,0x30
	.DB  0x84,0x40,0xA5,0x50,0xC6,0x60,0xE7,0x70
	.DB  0x8,0x81,0x29,0x91,0x4A,0xA1,0x6B,0xB1
	.DB  0x8C,0xC1,0xAD,0xD1,0xCE,0xE1,0xEF,0xF1
	.DB  0x31,0x12,0x10,0x2,0x73,0x32,0x52,0x22
	.DB  0xB5,0x52,0x94,0x42,0xF7,0x72,0xD6,0x62
	.DB  0x39,0x93,0x18,0x83,0x7B,0xB3,0x5A,0xA3
	.DB  0xBD,0xD3,0x9C,0xC3,0xFF,0xF3,0xDE,0xE3
	.DB  0x62,0x24,0x43,0x34,0x20,0x4,0x1,0x14
	.DB  0xE6,0x64,0xC7,0x74,0xA4,0x44,0x85,0x54
	.DB  0x6A,0xA5,0x4B,0xB5,0x28,0x85,0x9,0x95
	.DB  0xEE,0xE5,0xCF,0xF5,0xAC,0xC5,0x8D,0xD5
	.DB  0x53,0x36,0x72,0x26,0x11,0x16,0x30,0x6
	.DB  0xD7,0x76,0xF6,0x66,0x95,0x56,0xB4,0x46
	.DB  0x5B,0xB7,0x7A,0xA7,0x19,0x97,0x38,0x87
	.DB  0xDF,0xF7,0xFE,0xE7,0x9D,0xD7,0xBC,0xC7
	.DB  0xC4,0x48,0xE5,0x58,0x86,0x68,0xA7,0x78
	.DB  0x40,0x8,0x61,0x18,0x2,0x28,0x23,0x38
	.DB  0xCC,0xC9,0xED,0xD9,0x8E,0xE9,0xAF,0xF9
	.DB  0x48,0x89,0x69,0x99,0xA,0xA9,0x2B,0xB9
	.DB  0xF5,0x5A,0xD4,0x4A,0xB7,0x7A,0x96,0x6A
	.DB  0x71,0x1A,0x50,0xA,0x33,0x3A,0x12,0x2A
	.DB  0xFD,0xDB,0xDC,0xCB,0xBF,0xFB,0x9E,0xEB
	.DB  0x79,0x9B,0x58,0x8B,0x3B,0xBB,0x1A,0xAB
	.DB  0xA6,0x6C,0x87,0x7C,0xE4,0x4C,0xC5,0x5C
	.DB  0x22,0x2C,0x3,0x3C,0x60,0xC,0x41,0x1C
	.DB  0xAE,0xED,0x8F,0xFD,0xEC,0xCD,0xCD,0xDD
	.DB  0x2A,0xAD,0xB,0xBD,0x68,0x8D,0x49,0x9D
	.DB  0x97,0x7E,0xB6,0x6E,0xD5,0x5E,0xF4,0x4E
	.DB  0x13,0x3E,0x32,0x2E,0x51,0x1E,0x70,0xE
	.DB  0x9F,0xFF,0xBE,0xEF,0xDD,0xDF,0xFC,0xCF
	.DB  0x1B,0xBF,0x3A,0xAF,0x59,0x9F,0x78,0x8F
	.DB  0x88,0x91,0xA9,0x81,0xCA,0xB1,0xEB,0xA1
	.DB  0xC,0xD1,0x2D,0xC1,0x4E,0xF1,0x6F,0xE1
	.DB  0x80,0x10,0xA1,0x0,0xC2,0x30,0xE3,0x20
	.DB  0x4,0x50,0x25,0x40,0x46,0x70,0x67,0x60
	.DB  0xB9,0x83,0x98,0x93,0xFB,0xA3,0xDA,0xB3
	.DB  0x3D,0xC3,0x1C,0xD3,0x7F,0xE3,0x5E,0xF3
	.DB  0xB1,0x2,0x90,0x12,0xF3,0x22,0xD2,0x32
	.DB  0x35,0x42,0x14,0x52,0x77,0x62,0x56,0x72
	.DB  0xEA,0xB5,0xCB,0xA5,0xA8,0x95,0x89,0x85
	.DB  0x6E,0xF5,0x4F,0xE5,0x2C,0xD5,0xD,0xC5
	.DB  0xE2,0x34,0xC3,0x24,0xA0,0x14,0x81,0x4
	.DB  0x66,0x74,0x47,0x64,0x24,0x54,0x5,0x44
	.DB  0xDB,0xA7,0xFA,0xB7,0x99,0x87,0xB8,0x97
	.DB  0x5F,0xE7,0x7E,0xF7,0x1D,0xC7,0x3C,0xD7
	.DB  0xD3,0x26,0xF2,0x36,0x91,0x6,0xB0,0x16
	.DB  0x57,0x66,0x76,0x76,0x15,0x46,0x34,0x56
	.DB  0x4C,0xD9,0x6D,0xC9,0xE,0xF9,0x2F,0xE9
	.DB  0xC8,0x99,0xE9,0x89,0x8A,0xB9,0xAB,0xA9
	.DB  0x44,0x58,0x65,0x48,0x6,0x78,0x27,0x68
	.DB  0xC0,0x18,0xE1,0x8,0x82,0x38,0xA3,0x28
	.DB  0x7D,0xCB,0x5C,0xDB,0x3F,0xEB,0x1E,0xFB
	.DB  0xF9,0x8B,0xD8,0x9B,0xBB,0xAB,0x9A,0xBB
	.DB  0x75,0x4A,0x54,0x5A,0x37,0x6A,0x16,0x7A
	.DB  0xF1,0xA,0xD0,0x1A,0xB3,0x2A,0x92,0x3A
	.DB  0x2E,0xFD,0xF,0xED,0x6C,0xDD,0x4D,0xCD
	.DB  0xAA,0xBD,0x8B,0xAD,0xE8,0x9D,0xC9,0x8D
	.DB  0x26,0x7C,0x7,0x6C,0x64,0x5C,0x45,0x4C
	.DB  0xA2,0x3C,0x83,0x2C,0xE0,0x1C,0xC1,0xC
	.DB  0x1F,0xEF,0x3E,0xFF,0x5D,0xCF,0x7C,0xDF
	.DB  0x9B,0xAF,0xBA,0xBF,0xD9,0x8F,0xF8,0x9F
	.DB  0x17,0x6E,0x36,0x7E,0x55,0x4E,0x74,0x5E
	.DB  0x93,0x2E,0xB2,0x3E,0xD1,0xE,0xF0,0x1E
_DataTable:
	.DB  0x51,0xA,0x71,0xF,0xA1,0x14,0x81,0x18
	.DB  0x51,0xA,0x71,0xF,0xA1,0x14,0x81,0x18
	.DB  0x51,0xA,0x71,0xF,0xA1,0x14,0x81,0x18
	.DB  0x51,0xA,0x71,0xF,0xA1,0x14,0x81,0x18
	.DB  0x51,0xA,0x61,0x10,0xA1,0x14,0x81,0x1B
	.DB  0x51,0xA,0x61,0x10,0xA1,0x14,0x81,0x1B
	.DB  0x51,0xA,0x61,0x10,0xA1,0x14,0x81,0x1B
	.DB  0x51,0xA,0x61,0x10,0xA1,0x14,0x81,0x1B
	.DB  0x51,0xA,0xC1,0xD,0x61,0x12,0x21,0x17
	.DB  0x51,0xA,0xC1,0xD,0x61,0x12,0x21,0x17
	.DB  0x51,0xA,0xC1,0xD,0x61,0x12,0x21,0x17
	.DB  0x51,0xA,0xC1,0xD,0x61,0x12,0x21,0x17
	.DB  0x51,0xA,0x71,0xF,0xA1,0x14,0x81,0x18
	.DB  0x51,0xA,0x71,0xF,0xA1,0x14,0x81,0x18
	.DB  0x51,0xA,0x71,0xF,0xA1,0x14,0x81,0x18
	.DB  0x51,0xA,0x71,0xF,0xA1,0x14,0x81,0x18
	.DB  0x31,0x9,0x61,0x10,0x21,0x17,0x81,0x1B
	.DB  0x31,0x9,0x61,0x10,0x21,0x17,0x81,0x1B
	.DB  0x31,0x9,0x61,0x10,0x21,0x17,0x81,0x1B
	.DB  0x31,0x9,0x61,0x10,0x21,0x17,0x81,0x1B
	.DB  0x41,0xC,0x71,0xF,0x61,0x12,0xE1,0x1E
	.DB  0x41,0xC,0x71,0xF,0x61,0x12,0xE1,0x1E
	.DB  0x41,0xC,0x71,0xF,0x61,0x12,0xE1,0x1E
	.DB  0x41,0xC,0x71,0xF,0x61,0x12,0xE1,0x1E
	.DB  0x31,0x8,0x41,0xC,0xA1,0x14,0xE1,0x1E
	.DB  0x31,0x8,0x41,0xC,0xA1,0x14,0xE1,0x1E
	.DB  0x31,0x8,0x91,0xB,0xA1,0x14,0x81,0x1B
	.DB  0x31,0x8,0x91,0xB,0xA1,0x14,0x81,0x1B
	.DB  0xB1,0x7,0x41,0xC,0xA1,0x14,0xE1,0x1E
	.DB  0xB1,0x7,0x41,0xC,0xA1,0x14,0xE1,0x1E
	.DB  0xB1,0x7,0xC1,0xD,0x61,0x10,0x71,0x13
	.DB  0xB1,0x7,0xC1,0xD,0x71,0xF,0x71,0x13
	.DB  0x51,0xA,0x41,0xC,0x71,0xF,0xA1,0x14
	.DB  0x51,0xA,0x41,0xC,0x71,0xF,0xA1,0x14
	.DB  0x51,0xA,0x71,0xF,0xA1,0x14,0x81,0x18
	.DB  0x51,0xA,0x71,0xF,0xA1,0x14,0x81,0x18
	.DB  0x31,0x9,0x61,0x12,0x81,0x18,0x81,0x1B
	.DB  0x31,0x9,0x61,0x12,0x81,0x18,0x81,0x1B
	.DB  0x31,0x9,0x61,0x10,0x21,0x17,0x81,0x1B
	.DB  0x31,0x9,0x61,0x10,0x21,0x17,0x81,0x1B
	.DB  0x41,0xC,0x71,0xF,0x61,0x12,0x81,0x18
	.DB  0x41,0xC,0x71,0xF,0x61,0x12,0x81,0x18
	.DB  0x41,0xC,0x61,0x12,0x81,0x18,0xE1,0x1E
	.DB  0x41,0xC,0x61,0x12,0x81,0x18,0xE1,0x1E
	.DB  0x91,0xB,0x21,0x17,0xE1,0x1E,0xA1,0x22
	.DB  0x91,0xB,0x21,0x17,0xE1,0x1E,0xA1,0x22
	.DB  0x91,0xB,0xA1,0x14,0x21,0x1D,0xA1,0x22
	.DB  0x91,0xB,0xA1,0x14,0x21,0x1D,0xA1,0x22
	.DB  0x71,0xF,0x61,0x12,0x21,0x17,0xB1,0x24
	.DB  0x71,0xF,0x61,0x12,0x21,0x17,0xB1,0x24
	.DB  0xC1,0xD,0xE1,0x1E,0xB1,0x24,0x41,0x2E
	.DB  0xC1,0xD,0xE1,0x1E,0xB1,0x24,0x41,0x2E
	.DB  0x1,0xD,0xE1,0x1E,0xB1,0x24,0xC1,0x3D
	.DB  0x1,0xD,0xE1,0x1E,0xB1,0x24,0xC1,0x3D
	.DB  0x41,0xC,0x21,0x17,0xE1,0x1E,0xB1,0x24
	.DB  0x41,0xC,0xE1,0x15,0xE1,0x1E,0xB1,0x24
	.DB  0x91,0xB,0x21,0x17,0xE1,0x1E,0xA1,0x22
	.DB  0x91,0xB,0x21,0x17,0xE1,0x1E,0xA1,0x22
	.DB  0x91,0xB,0xE1,0x1E,0xA1,0x22,0x41,0x2E
	.DB  0x91,0xB,0xE1,0x1E,0xA1,0x22,0x41,0x2E
	.DB  0x91,0xB,0x21,0x17,0x21,0x1D,0xA1,0x22
	.DB  0x91,0xB,0x21,0x17,0x21,0x1D,0xA1,0x22
	.DB  0x91,0xB,0x21,0x1D,0xA1,0x22,0x41,0x2E
	.DB  0x91,0xB,0x21,0x1D,0xA1,0x22,0x41,0x2E
	.DB  0x71,0xF,0xC1,0x3D,0x41,0x2E,0xB1,0x24
	.DB  0xE1,0x1E,0x41,0x2E,0xB1,0x24,0xE1,0x1E
	.DB  0x21,0x17,0xC1,0x3D,0xE1,0x1E,0x21,0x17
	.DB  0x61,0x12,0x61,0x10,0x71,0xF,0xC1,0xD
	.DB  0x41,0xC,0xC1,0x3D,0x41,0x2E,0xB1,0x24
	.DB  0xE1,0x1E,0x41,0x2E,0xB1,0x24,0xE1,0x1E
	.DB  0x21,0x17,0xB1,0x24,0xE1,0x1E,0x21,0x17
	.DB  0x61,0x12,0x51,0x11,0x71,0xF,0x41,0xC
	.DB  0x91,0xB,0x41,0x2E,0xA1,0x22,0xE1,0x1E
	.DB  0x21,0x17,0xA1,0x22,0xE1,0x1E,0x21,0x17
	.DB  0xA1,0x14,0xE1,0x1E,0x21,0x1D,0x21,0x17
	.DB  0x51,0x11,0x71,0xF,0x91,0xE,0x91,0xB
	.DB  0x31,0x9,0x61,0x12,0x21,0x17,0x61,0x12
	.DB  0x71,0xF,0xE1,0x1E,0x21,0x17,0x71,0xF
	.DB  0xC1,0x9,0xE1,0x1E,0x21,0x17,0x71,0x13
	.DB  0x71,0xF,0x81,0x1B,0x21,0x17,0x71,0xF
	.DB  0xA1,0x14,0x61,0x52,0xC1,0x3D,0x1,0x31
	.DB  0x31,0x29,0xC1,0x3D,0x1,0x31,0x31,0x29
	.DB  0xE1,0x1E,0x1,0x31,0x31,0x29,0xE1,0x1E
	.DB  0x81,0x18,0x21,0x17,0xA1,0x14,0x61,0x12
	.DB  0x61,0x10,0x61,0x52,0xC1,0x3D,0x1,0x31
	.DB  0x31,0x29,0xC1,0x3D,0x1,0x31,0x31,0x29
	.DB  0xE1,0x1E,0x1,0x31,0x31,0x29,0xE1,0x1E
	.DB  0x81,0x18,0x21,0x17,0xA1,0x14,0x61,0x10
	.DB  0x71,0xF,0xC1,0x3D,0x41,0x2E,0x31,0x29
	.DB  0xE1,0x1E,0x41,0x2E,0x31,0x29,0xE1,0x1E
	.DB  0x81,0x1B,0x31,0x29,0xE1,0x26,0xE1,0x1E
	.DB  0x21,0x17,0xA1,0x14,0x71,0x13,0x71,0xF
	.DB  0xB1,0x7,0x71,0xF,0x71,0x13,0x21,0x17
	.DB  0xE1,0x1E,0xE1,0x26,0x41,0x2E,0xC1,0x3D
	.DB  0x1,0x31,0x31,0x29,0xE1,0x1E,0x81,0x18
	.DB  0x21,0x17,0x71,0x13,0x71,0xF,0xC1,0x9
	.DB  0x51,0xA,0x71,0xF,0xA1,0x14,0x81,0x18
	.DB  0x51,0xA,0x71,0xF,0xA1,0x14,0x81,0x18
	.DB  0x51,0xA,0x71,0xF,0xA1,0x14,0x81,0x18
	.DB  0x51,0xA,0x71,0xF,0xA1,0x14,0x81,0x18
	.DB  0x51,0xA,0x61,0x10,0xA1,0x14,0x81,0x1B
	.DB  0x51,0xA,0x61,0x10,0xA1,0x14,0x81,0x1B
	.DB  0x51,0xA,0x61,0x10,0xA1,0x14,0x81,0x1B
	.DB  0x51,0xA,0x61,0x10,0xA1,0x14,0x81,0x1B
	.DB  0x51,0xA,0xC1,0xD,0x61,0x12,0x21,0x17
	.DB  0x51,0xA,0xC1,0xD,0x61,0x12,0x21,0x17
	.DB  0x51,0xA,0xC1,0xD,0x61,0x12,0x21,0x17
	.DB  0x51,0xA,0xC1,0xD,0x61,0x12,0x21,0x17
	.DB  0x51,0xA,0x71,0xF,0xA1,0x14,0x81,0x18
	.DB  0x51,0xA,0x71,0xF,0xA1,0x14,0x81,0x18
	.DB  0x51,0xA,0x71,0xF,0xA1,0x14,0x81,0x18
	.DB  0x51,0xA,0x71,0xF,0xA1,0x14,0x81,0x18
	.DB  0x31,0x9,0x61,0x10,0x21,0x17,0x81,0x1B
	.DB  0x31,0x9,0x61,0x10,0x21,0x17,0x81,0x1B
	.DB  0x31,0x9,0x61,0x10,0x21,0x17,0x81,0x1B
	.DB  0x31,0x9,0x61,0x10,0x21,0x17,0x81,0x1B
	.DB  0x41,0xC,0x71,0xF,0x61,0x12,0xE1,0x1E
	.DB  0x41,0xC,0x71,0xF,0x61,0x12,0xE1,0x1E
	.DB  0x41,0xC,0x71,0xF,0x61,0x12,0xE1,0x1E
	.DB  0x41,0xC,0x71,0xF,0x61,0x12,0xE1,0x1E
	.DB  0x31,0x8,0x41,0xC,0xA1,0x14,0xE1,0x1E
	.DB  0x31,0x8,0x41,0xC,0xA1,0x14,0xE1,0x1E
	.DB  0x31,0x8,0x91,0xB,0xA1,0x14,0x81,0x1B
	.DB  0x31,0x8,0x91,0xB,0xA1,0x14,0x81,0x1B
	.DB  0x31,0x8,0x71,0xF,0xA1,0x14,0x81,0x18
	.DB  0x31,0x8,0x71,0xF,0xA1,0x14,0x81,0x18
	.DB  0x31,0x8,0xC1,0xD,0xA1,0x14,0x21,0x17
	.DB  0x31,0x8,0xC1,0xD,0xA1,0x14,0x21,0x17
	.DB  0x31,0x8,0x41,0xC,0xA1,0x14,0xE1,0x1E
	.DB  0x31,0x8,0x41,0xC,0xA1,0x14,0xE1,0x1E
	.DB  0x31,0x8,0x91,0xB,0xA1,0x14,0x81,0x1B
	.DB  0x31,0x8,0x91,0xB,0xA1,0x14,0x81,0x1B
	.DB  0xB1,0x7,0x71,0xF,0xA1,0x14,0x81,0x18
	.DB  0xB1,0x7,0x71,0xF,0xA1,0x14,0x81,0x18
	.DB  0xB1,0x7,0xC1,0xD,0x71,0x13,0x21,0x17
	.DB  0xB1,0x7,0xC1,0xD,0x71,0x13,0x21,0x17
	.DB  0x51,0xA,0x61,0x52,0xC1,0x3D,0x1,0x31
	.DB  0x31,0x29,0xE1,0x1E,0x81,0x18,0xA1,0x14
	.DB  0x71,0xF,0xC1,0x3D,0x1,0x31,0x31,0x29
	.DB  0xE1,0x1E,0x81,0x18,0xA1,0x14,0x71,0xF
	.DB  0x41,0xC,0x1,0x31,0x31,0x29,0x1,0x31
	.DB  0x41,0x2E,0xC1,0x3D,0xC1,0x4D,0x81,0x5C
	.DB  0xD1,0xA4,0xC1,0x3D,0x1,0x31,0x31,0x29
	.DB  0xE1,0x1E,0x81,0x18,0xA1,0x14,0x71,0xF
	.DB  0x5F,0xA,0xF,0x0
_ChronMenuButtons:
	.DB  LOW(_0xE0000*2+340),HIGH(_0xE0000*2+340),LOW(_Chron_AP),HIGH(_Chron_AP),0x0,0x0,0x0,LOW(_0xE0000*2+346)
	.DB  HIGH(_0xE0000*2+346),LOW(_ChronDirSet),HIGH(_ChronDirSet),LOW(_ChronDirGetStr),HIGH(_ChronDirGetStr),0x0
_EditStrDlgTable:
	.DB  0x20,0x5F,0x2D,0x30,0x31,0x32,0x33,0x34
	.DB  0x35,0x36,0x37,0x38,0x39,0x41,0x61,0x42
	.DB  0x62,0x43,0x63,0x44,0x64,0x45,0x65,0x46
	.DB  0x66,0x47,0x67,0x48,0x68,0x49,0x69,0x4A
	.DB  0x6A,0x4B,0x6B,0x4C,0x6C,0x4D,0x6D,0x4E
	.DB  0x6E,0x4F,0x6F,0x50,0x70,0x51,0x71,0x52
	.DB  0x72,0x53,0x73,0x54,0x74,0x55,0x75,0x56
	.DB  0x76,0x57,0x77,0x58,0x78,0x59,0x79,0x5A
	.DB  0x7A
_ModelMenuButtons:
	.DB  LOW(_0x180000*2+187),HIGH(_0x180000*2+187),LOW(_ModelNameSet),HIGH(_ModelNameSet),LOW(_ModelNameGetStr),HIGH(_ModelNameGetStr),0x0,LOW(_0x180000*2+192)
	.DB  HIGH(_0x180000*2+192),LOW(_ModeTypeSet),HIGH(_ModeTypeSet),LOW(_ModelTypeGetStr),HIGH(_ModelTypeGetStr),0x0,LOW(_0x180000*2+197),HIGH(_0x180000*2+197)
	.DB  LOW(_ModulationTypeSet),HIGH(_ModulationTypeSet),LOW(_ModulationTypeGetStr),HIGH(_ModulationTypeGetStr),0x0,LOW(_0x180000*2+145),HIGH(_0x180000*2+145),LOW(_ModelChannelsNumSet)
	.DB  HIGH(_ModelChannelsNumSet),LOW(_ModelChannelsNumGetStr),HIGH(_ModelChannelsNumGetStr),0x0,LOW(_0x180000*2+208),HIGH(_0x180000*2+208),LOW(_ModeNameSet),HIGH(_ModeNameSet)
	.DB  LOW(_ModeNameGetStr),HIGH(_ModeNameGetStr),0x0,LOW(_0x180000*2+57),HIGH(_0x180000*2+57),LOW(_ModelSave),HIGH(_ModelSave),0x0
	.DB  0x0,0x0,LOW(_0x180000*2+218),HIGH(_0x180000*2+218),LOW(_ModelSelect),HIGH(_ModelSelect),0x0,0x0
	.DB  0x0,LOW(_0x180000*2+225),HIGH(_0x180000*2+225),LOW(_ModelCopy),HIGH(_ModelCopy),0x0,0x0,0x0
	.DB  LOW(_0x180000*2+230),HIGH(_0x180000*2+230),LOW(_ModeCopy),HIGH(_ModeCopy),0x0,0x0,0x0,LOW(_0x180000*2+83)
	.DB  HIGH(_0x180000*2+83),LOW(_ModelReset),HIGH(_ModelReset),0x0,0x0,0x0
_ControlsMenuButtons:
	.DB  LOW(_0x180000*2+365),HIGH(_0x180000*2+365),LOW(_ControlsSettingsMenu),HIGH(_ControlsSettingsMenu),0x0,0x0,0x0,LOW(_0x180000*2+374)
	.DB  HIGH(_0x180000*2+374),LOW(_ControlsSettingsMenu),HIGH(_ControlsSettingsMenu),0x0,0x0,0x1,LOW(_0x180000*2+383),HIGH(_0x180000*2+383)
	.DB  LOW(_ControlsSettingsMenu),HIGH(_ControlsSettingsMenu),0x0,0x0,0x2,LOW(_0x180000*2+392),HIGH(_0x180000*2+392),LOW(_ControlsSettingsMenu)
	.DB  HIGH(_ControlsSettingsMenu),0x0,0x0,0x3,LOW(_0x180000*2+399),HIGH(_0x180000*2+399),LOW(_ControlsSettingsMenu),HIGH(_ControlsSettingsMenu)
	.DB  0x0,0x0,0x4,LOW(_0x180000*2+404),HIGH(_0x180000*2+404),LOW(_ControlsSettingsMenu),HIGH(_ControlsSettingsMenu),0x0
	.DB  0x0,0x5,LOW(_0x180000*2+409),HIGH(_0x180000*2+409),LOW(_ControlsSettingsMenu),HIGH(_ControlsSettingsMenu),0x0,0x0
	.DB  0x6,LOW(_0x180000*2+414),HIGH(_0x180000*2+414),LOW(_ControlsSettingsMenu),HIGH(_ControlsSettingsMenu),0x0,0x0,0x7
	.DB  LOW(_0x180000*2+420),HIGH(_0x180000*2+420),LOW(_ControlsSettingsMenu),HIGH(_ControlsSettingsMenu),0x0,0x0,0x8,LOW(_0x180000*2+430)
	.DB  HIGH(_0x180000*2+430),LOW(_ControlsSettingsMenu),HIGH(_ControlsSettingsMenu),0x0,0x0,0x9
_ControlsMainSettings:
	.DB  LOW(_0x180000*2+290),HIGH(_0x180000*2+290),LOW(_ControlsReverseSet),HIGH(_ControlsReverseSet),LOW(_ControlsReverseGetStr),HIGH(_ControlsReverseGetStr),0x0,LOW(_0x180000*2+298)
	.DB  HIGH(_0x180000*2+298),LOW(_ControlsRateSet),HIGH(_ControlsRateSet),LOW(_ControlsRateGetStr),HIGH(_ControlsRateGetStr),0x2,LOW(_0x180000*2+307),HIGH(_0x180000*2+307)
	.DB  LOW(_ControlsRateSet),HIGH(_ControlsRateSet),LOW(_ControlsRateGetStr),HIGH(_ControlsRateGetStr),0x1,LOW(_0x180000*2+316),HIGH(_0x180000*2+316),LOW(_ControlsRateSet)
	.DB  HIGH(_ControlsRateSet),LOW(_ControlsRateGetStr),HIGH(_ControlsRateGetStr),0x3,LOW(_0x180000*2+330),HIGH(_0x180000*2+330),LOW(_ControlsRateSet),HIGH(_ControlsRateSet)
	.DB  LOW(_ControlsRateGetStr),HIGH(_ControlsRateGetStr),0x4,LOW(_0x180000*2+284),HIGH(_0x180000*2+284),LOW(_ControlsCurveChange),HIGH(_ControlsCurveChange),0x0
	.DB  0x0,0x7
_ControlsThrottleSettings:
	.DB  LOW(_0x180000*2+290),HIGH(_0x180000*2+290),LOW(_ControlsReverseSet),HIGH(_ControlsReverseSet),LOW(_ControlsReverseGetStr),HIGH(_ControlsReverseGetStr),0x0,LOW(_0x180000*2+298)
	.DB  HIGH(_0x180000*2+298),LOW(_ControlsRateSet),HIGH(_ControlsRateSet),LOW(_ControlsRateGetStr),HIGH(_ControlsRateGetStr),0x2,LOW(_0x180000*2+307),HIGH(_0x180000*2+307)
	.DB  LOW(_ControlsRateSet),HIGH(_ControlsRateSet),LOW(_ControlsRateGetStr),HIGH(_ControlsRateGetStr),0x1,LOW(_0x180000*2+344),HIGH(_0x180000*2+344),LOW(_ControlsRateSet)
	.DB  HIGH(_ControlsRateSet),LOW(_ControlsRateGetStr),HIGH(_ControlsRateGetStr),0x5,LOW(_0x180000*2+284),HIGH(_0x180000*2+284),LOW(_ControlsCurveChange),HIGH(_ControlsCurveChange)
	.DB  0x0,0x0,0x7
_ControlsAuxSettings:
	.DB  LOW(_0x180000*2+290),HIGH(_0x180000*2+290),LOW(_ControlsReverseSet),HIGH(_ControlsReverseSet),LOW(_ControlsReverseGetStr),HIGH(_ControlsReverseGetStr),0x0,LOW(_0x180000*2+298)
	.DB  HIGH(_0x180000*2+298),LOW(_ControlsRateSet),HIGH(_ControlsRateSet),LOW(_ControlsRateGetStr),HIGH(_ControlsRateGetStr),0x2,LOW(_0x180000*2+307),HIGH(_0x180000*2+307)
	.DB  LOW(_ControlsRateSet),HIGH(_ControlsRateSet),LOW(_ControlsRateGetStr),HIGH(_ControlsRateGetStr),0x1,LOW(_0x180000*2+284),HIGH(_0x180000*2+284),LOW(_ControlsCurveChange)
	.DB  HIGH(_ControlsCurveChange),0x0,0x0,0x7
_ControlsSwSettings:
	.DB  LOW(_0x180000*2+290),HIGH(_0x180000*2+290),LOW(_ControlsReverseSet),HIGH(_ControlsReverseSet),LOW(_ControlsReverseGetStr),HIGH(_ControlsReverseGetStr),0x0,LOW(_0x180000*2+298)
	.DB  HIGH(_0x180000*2+298),LOW(_ControlsRateSet),HIGH(_ControlsRateSet),LOW(_ControlsRateGetStr),HIGH(_ControlsRateGetStr),0x2,LOW(_0x180000*2+307),HIGH(_0x180000*2+307)
	.DB  LOW(_ControlsRateSet),HIGH(_ControlsRateSet),LOW(_ControlsRateGetStr),HIGH(_ControlsRateGetStr),0x1
_ControlsVSettings:
	.DB  LOW(_0x180000*2+290),HIGH(_0x180000*2+290),LOW(_ControlsReverseSet),HIGH(_ControlsReverseSet),LOW(_ControlsReverseGetStr),HIGH(_ControlsReverseGetStr),0x0,LOW(_0x180000*2+298)
	.DB  HIGH(_0x180000*2+298),LOW(_ControlsRateSet),HIGH(_ControlsRateSet),LOW(_ControlsRateGetStr),HIGH(_ControlsRateGetStr),0x2,LOW(_0x180000*2+307),HIGH(_0x180000*2+307)
	.DB  LOW(_ControlsRateSet),HIGH(_ControlsRateSet),LOW(_ControlsRateGetStr),HIGH(_ControlsRateGetStr),0x1,LOW(_0x180000*2+284),HIGH(_0x180000*2+284),LOW(_ControlsCurveChange)
	.DB  HIGH(_ControlsCurveChange),0x0,0x0,0x7,LOW(_0x180000*2+351),HIGH(_0x180000*2+351),LOW(_ControlsVirtualSet),HIGH(_ControlsVirtualSet)
	.DB  LOW(_ControlsVirtualGetStr),HIGH(_ControlsVirtualGetStr),0x6
_MixerMenuButtons:
	.DB  LOW(_0x180000*2+365),HIGH(_0x180000*2+365),LOW(_MixerChangeSetting),HIGH(_MixerChangeSetting),LOW(_MixerGetStr),HIGH(_MixerGetStr),0x0,LOW(_0x180000*2+374)
	.DB  HIGH(_0x180000*2+374),LOW(_MixerChangeSetting),HIGH(_MixerChangeSetting),LOW(_MixerGetStr),HIGH(_MixerGetStr),0x1,LOW(_0x180000*2+383),HIGH(_0x180000*2+383)
	.DB  LOW(_MixerChangeSetting),HIGH(_MixerChangeSetting),LOW(_MixerGetStr),HIGH(_MixerGetStr),0x2,LOW(_0x180000*2+392),HIGH(_0x180000*2+392),LOW(_MixerChangeSetting)
	.DB  HIGH(_MixerChangeSetting),LOW(_MixerGetStr),HIGH(_MixerGetStr),0x3,LOW(_0x180000*2+399),HIGH(_0x180000*2+399),LOW(_MixerChangeSetting),HIGH(_MixerChangeSetting)
	.DB  LOW(_MixerGetStr),HIGH(_MixerGetStr),0x4,LOW(_0x180000*2+404),HIGH(_0x180000*2+404),LOW(_MixerChangeSetting),HIGH(_MixerChangeSetting),LOW(_MixerGetStr)
	.DB  HIGH(_MixerGetStr),0x5,LOW(_0x180000*2+409),HIGH(_0x180000*2+409),LOW(_MixerChangeSetting),HIGH(_MixerChangeSetting),LOW(_MixerGetStr),HIGH(_MixerGetStr)
	.DB  0x6,LOW(_0x180000*2+414),HIGH(_0x180000*2+414),LOW(_MixerChangeSetting),HIGH(_MixerChangeSetting),LOW(_MixerGetStr),HIGH(_MixerGetStr),0x7
	.DB  LOW(_0x180000*2+420),HIGH(_0x180000*2+420),LOW(_MixerChangeSetting),HIGH(_MixerChangeSetting),LOW(_MixerGetStr),HIGH(_MixerGetStr),0x8,LOW(_0x180000*2+430)
	.DB  HIGH(_0x180000*2+430),LOW(_MixerChangeSetting),HIGH(_MixerChangeSetting),LOW(_MixerGetStr),HIGH(_MixerGetStr),0x9,LOW(_0x180000*2+446),HIGH(_0x180000*2+446)
	.DB  LOW(_MixerChangeSetting),HIGH(_MixerChangeSetting),LOW(_MixerGetStr),HIGH(_MixerGetStr),0xA
_ChannelsMenuButtons:
	.DB  LOW(_0x180000*2+463),HIGH(_0x180000*2+463),LOW(_ChannelsMixerMenu),HIGH(_ChannelsMixerMenu),0x0,0x0,0x0,LOW(_0x180000*2+468)
	.DB  HIGH(_0x180000*2+468),LOW(_ChannelsMixerMenu),HIGH(_ChannelsMixerMenu),0x0,0x0,0x1,LOW(_0x180000*2+473),HIGH(_0x180000*2+473)
	.DB  LOW(_ChannelsMixerMenu),HIGH(_ChannelsMixerMenu),0x0,0x0,0x2,LOW(_0x180000*2+478),HIGH(_0x180000*2+478),LOW(_ChannelsMixerMenu)
	.DB  HIGH(_ChannelsMixerMenu),0x0,0x0,0x3,LOW(_0x180000*2+483),HIGH(_0x180000*2+483),LOW(_ChannelsMixerMenu),HIGH(_ChannelsMixerMenu)
	.DB  0x0,0x0,0x4,LOW(_0x180000*2+488),HIGH(_0x180000*2+488),LOW(_ChannelsMixerMenu),HIGH(_ChannelsMixerMenu),0x0
	.DB  0x0,0x5,LOW(_0x180000*2+493),HIGH(_0x180000*2+493),LOW(_ChannelsMixerMenu),HIGH(_ChannelsMixerMenu),0x0,0x0
	.DB  0x6,LOW(_0x180000*2+498),HIGH(_0x180000*2+498),LOW(_ChannelsMixerMenu),HIGH(_ChannelsMixerMenu),0x0,0x0,0x7
_TimerMenuButtons:
	.DB  LOW(_0x180000*2+536),HIGH(_0x180000*2+536),0x0,0x0,0x0,0x0,0x0,LOW(_0x180000*2+540)
	.DB  HIGH(_0x180000*2+540),LOW(_TimerModeSet),HIGH(_TimerModeSet),LOW(_TimerModeGetStr),HIGH(_TimerModeGetStr),0x0,LOW(_0x180000*2+545),HIGH(_0x180000*2+545)
	.DB  LOW(_TimerSoundSet),HIGH(_TimerSoundSet),LOW(_TimerSoundGetStr),HIGH(_TimerSoundGetStr),0x0
_OptionsMenuButtons:
	.DB  LOW(_0x180000*2+545),HIGH(_0x180000*2+545),LOW(_OptionsSoundSet),HIGH(_OptionsSoundSet),LOW(_OptionsSoundGetStr),HIGH(_OptionsSoundGetStr),0x0,LOW(_0x180000*2+568)
	.DB  HIGH(_0x180000*2+568),LOW(_OptionsBacklightSet),HIGH(_OptionsBacklightSet),LOW(_OptionsBacklightGetStr),HIGH(_OptionsBacklightGetStr),0x0,LOW(_0x180000*2+578),HIGH(_0x180000*2+578)
	.DB  LOW(_Calibration_AP),HIGH(_Calibration_AP),0x0,0x0,0x0
_TestMenuButtons:
	.DB  LOW(_0x180000*2+241),HIGH(_0x180000*2+241),LOW(_ModelMenu),HIGH(_ModelMenu),0x0,0x0,0x0,LOW(_0x180000*2+356)
	.DB  HIGH(_0x180000*2+356),LOW(_ControlsMenu),HIGH(_ControlsMenu),0x0,0x0,0x0,LOW(_0x180000*2+145),HIGH(_0x180000*2+145)
	.DB  LOW(_ChannelsMenu),HIGH(_ChannelsMenu),0x0,0x0,0x0,LOW(_0x180000*2+551),HIGH(_0x180000*2+551),LOW(_TimerMenu)
	.DB  HIGH(_TimerMenu),0x0,0x0,0x0,LOW(_0x180000*2+590),HIGH(_0x180000*2+590),LOW(_OptionsMenu),HIGH(_OptionsMenu)
	.DB  0x0,0x0,0x0,LOW(_0x180000*2+598),HIGH(_0x180000*2+598),LOW(_IO_Test_AP),HIGH(_IO_Test_AP),0x0
	.DB  0x0,0x0,LOW(_0x180000*2+606),HIGH(_0x180000*2+606),LOW(_Demo_AP),HIGH(_Demo_AP),0x0,0x0
	.DB  0x0,LOW(_0x180000*2+611),HIGH(_0x180000*2+611),LOW(_ChronMenu),HIGH(_ChronMenu),0x0,0x0,0x0
	.DB  LOW(_0x180000*2+617),HIGH(_0x180000*2+617),LOW(_MusicMenu),HIGH(_MusicMenu),0x0,0x0,0x0
_SuperMarioThemeTable:
	.DB  0x32,0x29,0x1,0x0,0x32,0x29,0x1,0x0
	.DB  0x2,0x0,0x1,0x0,0x32,0x29,0x1,0x0
	.DB  0x2,0x0,0x1,0x0,0xB2,0x20,0x1,0x0
	.DB  0x32,0x29,0x1,0x0,0x2,0x0,0x1,0x0
	.DB  0xF2,0x30,0x1,0x0,0x2,0x0,0x1,0x0
	.DB  0x4,0x0,0x1,0x0,0x72,0x18,0x1,0x0
	.DB  0x2,0x0,0x1,0x0,0x4,0x0,0x1,0x0
	.DB  0xB2,0x20,0x1,0x0,0x2,0x0,0x1,0x0
	.DB  0x2,0x0,0x1,0x0,0x72,0x18,0x1,0x0
	.DB  0x4,0x0,0x1,0x0,0x92,0x14,0x1,0x0
	.DB  0x2,0x0,0x1,0x0,0x2,0x0,0x1,0x0
	.DB  0x82,0x1B,0x1,0x0,0x2,0x0,0x1,0x0
	.DB  0xD2,0x1E,0x1,0x0,0x2,0x0,0x1,0x0
	.DB  0x22,0x1D,0x1,0x0,0x82,0x1B,0x1,0x0
	.DB  0x2,0x0,0x1,0x0,0x72,0x18,0x1,0x0
	.DB  0x32,0x29,0x1,0x0,0xF2,0x30,0x1,0x0
	.DB  0x2,0x37,0x1,0x0,0x2,0x0,0x1,0x0
	.DB  0xA2,0x2B,0x1,0x0,0xF2,0x30,0x1,0x0
	.DB  0x2,0x0,0x1,0x0,0x32,0x29,0x1,0x0
	.DB  0x2,0x0,0x1,0x0,0xB2,0x20,0x1,0x0
	.DB  0xB2,0x24,0x1,0x0,0xD2,0x1E,0x1,0x0
	.DB  0x4,0x0,0x1,0x0,0xB2,0x20,0x1,0x0
	.DB  0x2,0x0,0x1,0x0,0x2,0x0,0x1,0x0
	.DB  0x72,0x18,0x1,0x0,0x4,0x0,0x1,0x0
	.DB  0x92,0x14,0x1,0x0,0x2,0x0,0x1,0x0
	.DB  0x2,0x0,0x1,0x0,0x82,0x1B,0x1,0x0
	.DB  0x2,0x0,0x1,0x0,0xD2,0x1E,0x1,0x0
	.DB  0x2,0x0,0x1,0x0,0x22,0x1D,0x1,0x0
	.DB  0x82,0x1B,0x1,0x0,0x2,0x0,0x1,0x0
	.DB  0x72,0x18,0x1,0x0,0x32,0x29,0x1,0x0
	.DB  0xF2,0x30,0x1,0x0,0x2,0x37,0x1,0x0
	.DB  0x2,0x0,0x1,0x0,0xA2,0x2B,0x1,0x0
	.DB  0xF2,0x30,0x1,0x0,0x2,0x0,0x1,0x0
	.DB  0x32,0x29,0x1,0x0,0x2,0x0,0x1,0x0
	.DB  0xB2,0x20,0x1,0x0,0xB2,0x24,0x1,0x0
	.DB  0xD2,0x1E,0x1,0x0,0x4,0x0,0x1,0x0
	.DB  0x4,0x0,0x1,0x0,0xF2,0x30,0x1,0x0
	.DB  0x42,0x2E,0x1,0x0,0xA2,0x2B,0x1,0x0
	.DB  0xE2,0x26,0x1,0x0,0x2,0x0,0x1,0x0
	.DB  0x32,0x29,0x1,0x0,0x2,0x0,0x1,0x0
	.DB  0xF2,0x19,0x1,0x0,0x82,0x1B,0x1,0x0
	.DB  0xB2,0x20,0x1,0x0,0x2,0x0,0x1,0x0
	.DB  0x82,0x1B,0x1,0x0,0xB2,0x20,0x1,0x0
	.DB  0xB2,0x24,0x1,0x0,0x4,0x0,0x1,0x0
	.DB  0xF2,0x30,0x1,0x0,0x42,0x2E,0x1,0x0
	.DB  0xA2,0x2B,0x1,0x0,0xE2,0x26,0x1,0x0
	.DB  0x2,0x0,0x1,0x0,0x32,0x29,0x1,0x0
	.DB  0x2,0x0,0x1,0x0,0x62,0x41,0x1,0x0
	.DB  0x2,0x0,0x1,0x0,0x62,0x41,0x1,0x0
	.DB  0x62,0x41,0x1,0x0,0x2,0x0,0x1,0x0
	.DB  0x4,0x0,0x1,0x0,0x4,0x0,0x1,0x0
	.DB  0xF2,0x30,0x1,0x0,0x42,0x2E,0x1,0x0
	.DB  0xA2,0x2B,0x1,0x0,0xE2,0x26,0x1,0x0
	.DB  0x2,0x0,0x1,0x0,0x32,0x29,0x1,0x0
	.DB  0x2,0x0,0x1,0x0,0xF2,0x19,0x1,0x0
	.DB  0x82,0x1B,0x1,0x0,0xB2,0x20,0x1,0x0
	.DB  0x2,0x0,0x1,0x0,0x82,0x1B,0x1,0x0
	.DB  0xB2,0x20,0x1,0x0,0xB2,0x24,0x1,0x0
	.DB  0x4,0x0,0x1,0x0,0xE2,0x26,0x1,0x0
	.DB  0x2,0x0,0x1,0x0,0x2,0x0,0x1,0x0
	.DB  0xB2,0x24,0x1,0x0,0x4,0x0,0x1,0x0
	.DB  0xB2,0x20,0x1,0x0,0x2,0x0,0x1,0x0
	.DB  0x4,0x0,0x1,0x0,0x9,0x0,0x1,0x0
	.DB  0xB2,0x20,0x1,0x0,0xB2,0x20,0x1,0x0
	.DB  0x2,0x0,0x1,0x0,0xB2,0x20,0x1,0x0
	.DB  0x2,0x0,0x1,0x0,0xB2,0x20,0x1,0x0
	.DB  0xB2,0x24,0x1,0x0,0x2,0x0,0x1,0x0
	.DB  0x32,0x29,0x1,0x0,0xB2,0x20,0x1,0x0
	.DB  0x2,0x0,0x1,0x0,0x82,0x1B,0x1,0x0
	.DB  0x72,0x18,0x1,0x0,0x2,0x0,0x1,0x0
	.DB  0x4,0x0,0x1,0x0,0xB2,0x20,0x1,0x0
	.DB  0xB2,0x20,0x1,0x0,0x2,0x0,0x1,0x0
	.DB  0xB2,0x20,0x1,0x0,0x2,0x0,0x1,0x0
	.DB  0xB2,0x20,0x1,0x0,0xB2,0x24,0x1,0x0
	.DB  0x32,0x29,0x1,0x0,0x9,0x0,0x1,0x0
	.DB  0x9,0x0,0x1,0x0,0xB2,0x20,0x1,0x0
	.DB  0xB2,0x20,0x1,0x0,0x2,0x0,0x1,0x0
	.DB  0xB2,0x20,0x1,0x0,0x2,0x0,0x1,0x0
	.DB  0xB2,0x20,0x1,0x0,0xB2,0x24,0x1,0x0
	.DB  0x2,0x0,0x1,0x0,0x32,0x29,0x1,0x0
	.DB  0xB2,0x20,0x1,0x0,0x2,0x0,0x1,0x0
	.DB  0x82,0x1B,0x1,0x0,0x72,0x18,0x1,0x0
	.DB  0x2,0x0,0x1,0x0,0x4,0x0,0x1,0x0
	.DB  0x32,0x29,0x1,0x0,0x32,0x29,0x1,0x0
	.DB  0x2,0x0,0x1,0x0,0x32,0x29,0x1,0x0
	.DB  0x2,0x0,0x1,0x0,0xB2,0x20,0x1,0x0
	.DB  0x32,0x29,0x1,0x0,0x2,0x0,0x1,0x0
	.DB  0xF2,0x30,0x1,0x0,0x2,0x0,0x1,0x0
	.DB  0x4,0x0,0x1,0x0,0x72,0x18,0x1,0x0
	.DB  0x2,0x0,0x1,0x0,0x4,0x0,0x1,0x0
	.DB  0xB2,0x20,0x1,0x0,0x2,0x0,0x1,0x0
	.DB  0x2,0x0,0x1,0x0,0x72,0x18,0x1,0x0
	.DB  0x4,0x0,0x1,0x0,0x92,0x14,0x1,0x0
	.DB  0x2,0x0,0x1,0x0,0x2,0x0,0x1,0x0
	.DB  0x82,0x1B,0x1,0x0,0x2,0x0,0x1,0x0
	.DB  0xD2,0x1E,0x1,0x0,0x2,0x0,0x1,0x0
	.DB  0x22,0x1D,0x1,0x0,0x82,0x1B,0x1,0x0
	.DB  0x2,0x0,0x1,0x0,0x72,0x18,0x1,0x0
	.DB  0x32,0x29,0x1,0x0,0xF2,0x30,0x1,0x0
	.DB  0x2,0x37,0x1,0x0,0x2,0x0,0x1,0x0
	.DB  0xA2,0x2B,0x1,0x0,0xF2,0x30,0x1,0x0
	.DB  0x2,0x0,0x1,0x0,0x32,0x29,0x1,0x0
	.DB  0x2,0x0,0x1,0x0,0xB2,0x20,0x1,0x0
	.DB  0xB2,0x24,0x1,0x0,0xD2,0x1E,0x1,0x0
	.DB  0x4,0x0,0x1,0x0,0xB2,0x20,0x1,0x0
	.DB  0x2,0x0,0x1,0x0,0x2,0x0,0x1,0x0
	.DB  0x72,0x18,0x1,0x0,0x4,0x0,0x1,0x0
	.DB  0x92,0x14,0x1,0x0,0x2,0x0,0x1,0x0
	.DB  0x2,0x0,0x1,0x0,0x82,0x1B,0x1,0x0
	.DB  0x2,0x0,0x1,0x0,0xD2,0x1E,0x1,0x0
	.DB  0x2,0x0,0x1,0x0,0x22,0x1D,0x1,0x0
	.DB  0x82,0x1B,0x1,0x0,0x2,0x0,0x1,0x0
	.DB  0x72,0x18,0x1,0x0,0x32,0x29,0x1,0x0
	.DB  0xF2,0x30,0x1,0x0,0x2,0x37,0x1,0x0
	.DB  0x2,0x0,0x1,0x0,0xA2,0x2B,0x1,0x0
	.DB  0xF2,0x30,0x1,0x0,0x2,0x0,0x1,0x0
	.DB  0x32,0x29,0x1,0x0,0x2,0x0,0x1,0x0
	.DB  0xB2,0x20,0x1,0x0,0xB2,0x24,0x1,0x0
	.DB  0xD2,0x1E,0x1,0x0,0x4,0x0,0x1,0x0
	.DB  0x32,0x29,0x1,0x0,0xB2,0x20,0x1,0x0
	.DB  0x2,0x0,0x1,0x0,0x72,0x18,0x1,0x0
	.DB  0x4,0x0,0x1,0x0,0xF2,0x19,0x1,0x0
	.DB  0x2,0x0,0x1,0x0,0x82,0x1B,0x1,0x0
	.DB  0xA2,0x2B,0x1,0x0,0x2,0x0,0x1,0x0
	.DB  0xA2,0x2B,0x1,0x0,0x82,0x1B,0x1,0x0
	.DB  0x2,0x0,0x1,0x0,0x4,0x0,0x1,0x0
	.DB  0xD3,0x1E,0x1,0x0,0x3,0x37,0x1,0x0
	.DB  0x3,0x37,0x1,0x0,0x3,0x37,0x1,0x0
	.DB  0xF3,0x30,0x1,0x0,0xA3,0x2B,0x1,0x0
	.DB  0x32,0x29,0x1,0x0,0xB2,0x20,0x1,0x0
	.DB  0x2,0x0,0x1,0x0,0x82,0x1B,0x1,0x0
	.DB  0x72,0x18,0x1,0x0,0x2,0x0,0x1,0x0
	.DB  0x4,0x0,0x1,0x0,0x32,0x29,0x1,0x0
	.DB  0xB2,0x20,0x1,0x0,0x2,0x0,0x1,0x0
	.DB  0x72,0x18,0x1,0x0,0x4,0x0,0x1,0x0
	.DB  0xF2,0x19,0x1,0x0,0x2,0x0,0x1,0x0
	.DB  0x82,0x1B,0x1,0x0,0xA2,0x2B,0x1,0x0
	.DB  0x2,0x0,0x1,0x0,0xA2,0x2B,0x1,0x0
	.DB  0x82,0x1B,0x1,0x0,0x2,0x0,0x1,0x0
	.DB  0x4,0x0,0x1,0x0,0xD2,0x1E,0x1,0x0
	.DB  0xA2,0x2B,0x1,0x0,0x2,0x0,0x1,0x0
	.DB  0xA2,0x2B,0x1,0x0,0xA3,0x2B,0x1,0x0
	.DB  0x33,0x29,0x1,0x0,0xB3,0x24,0x1,0x0
	.DB  0xB2,0x20,0x1,0x0,0x92,0x14,0x1,0x0
	.DB  0x2,0x0,0x1,0x0,0x92,0x14,0x1,0x0
	.DB  0x52,0x10,0x1,0x0,0x2,0x0,0x1,0x0
	.DB  0x4,0x0,0x1,0x0,0x1,0x0
_UnderwolrdThemeTable:
	.DB  0x62,0x10,0x1,0x0,0xB2,0x20,0x1,0x0
	.DB  0xC2,0xD,0x1,0x0,0x82,0x1B,0x1,0x0
	.DB  0x92,0xE,0x1,0x0,0x22,0x1D,0x1,0x0
	.DB  0x4,0x0,0x1,0x0,0x8,0x0,0x1,0x0
	.DB  0x62,0x10,0x1,0x0,0xB2,0x20,0x1,0x0
	.DB  0xC2,0xD,0x1,0x0,0x82,0x1B,0x1,0x0
	.DB  0x92,0xE,0x1,0x0,0x22,0x1D,0x1,0x0
	.DB  0x4,0x0,0x1,0x0,0x8,0x0,0x1,0x0
	.DB  0xF2,0xA,0x1,0x0,0xD2,0x15,0x1,0x0
	.DB  0x32,0x9,0x1,0x0,0x62,0x12,0x1,0x0
	.DB  0xC2,0x9,0x1,0x0,0x72,0x13,0x1,0x0
	.DB  0x4,0x0,0x1,0x0,0x8,0x0,0x1,0x0
	.DB  0xF2,0xA,0x1,0x0,0xD2,0x15,0x1,0x0
	.DB  0x32,0x9,0x1,0x0,0x62,0x12,0x1,0x0
	.DB  0xC2,0x9,0x1,0x0,0x72,0x13,0x1,0x0
	.DB  0x4,0x0,0x1,0x0,0x4,0x0,0x1,0x0
	.DB  0x71,0x13,0x1,0x0,0x51,0x11,0x1,0x0
	.DB  0x61,0x12,0x1,0x0,0x54,0x11,0x1,0x0
	.DB  0x74,0x13,0x1,0x0,0x74,0x13,0x1,0x0
	.DB  0x4,0xD,0x1,0x0,0x44,0xC,0x1,0x0
	.DB  0x54,0x11,0x1,0x0,0x61,0x10,0x1,0x0
	.DB  0x21,0x17,0x1,0x0,0xD1,0x15,0x1,0x0
	.DB  0x51,0xA,0x1,0x0,0x21,0x1D,0x1,0x0
	.DB  0x81,0x1B,0x1,0x0,0xF2,0x19,0x1,0x0
	.DB  0x72,0x13,0x1,0x0,0x72,0xF,0x1,0x0
	.DB  0x92,0xE,0x1,0x0,0xC2,0xD,0x1,0x0
	.DB  0x2,0xD,0x1,0x0,0x8,0x0,0x1,0x0
	.DB  0x8,0x0,0x1,0x0,0x8,0x0,0x1,0x0
_MusicMenuButtons:
	.DB  LOW(_0x1C0000*2+35),HIGH(_0x1C0000*2+35),LOW(_PlayMusic),HIGH(_PlayMusic),0x0,0x0,0x0,LOW(_0x1C0000*2+53)
	.DB  HIGH(_0x1C0000*2+53),LOW(_PlayMusic),HIGH(_PlayMusic),0x0,0x0,0x1
_tbl10_G100:
	.DB  0x10,0x27,0xE8,0x3,0x64,0x0,0xA,0x0
	.DB  0x1,0x0
_tbl16_G100:
	.DB  0x0,0x10,0x0,0x1,0x10,0x0,0x1,0x0

;REGISTER BIT VARIABLES INITIALIZATION
__REG_BIT_VARS:
	.DW  0x0000

_0x0:
	.DB  0x53,0x74,0x61,0x72,0x74,0x69,0x6E,0x67
	.DB  0x2E,0x2E,0x2E,0x0,0x54,0x52,0x41,0x4E
	.DB  0x53,0x4D,0x49,0x54,0x54,0x45,0x52,0x0
	.DB  0x45,0x45,0x50,0x52,0x4F,0x4D,0x20,0x43
	.DB  0x52,0x43,0x20,0x45,0x52,0x52,0x4F,0x52
	.DB  0xA,0x52,0x65,0x73,0x65,0x74,0x20,0x74
	.DB  0x6F,0x20,0x66,0x61,0x63,0x74,0x6F,0x72
	.DB  0x79,0xA,0x64,0x65,0x66,0x61,0x75,0x6C
	.DB  0x74,0x73,0x20,0x3F,0x0,0x45,0x52,0x52
	.DB  0x4F,0x52,0x0
_0xE005A:
	.DB  LOW(_0xE0000*2+356),HIGH(_0xE0000*2+356),LOW(_Font_8x12),HIGH(_Font_8x12),LOW(_Font_6x8),HIGH(_Font_6x8),LOW(_ChronMenuButtons*2),HIGH(_ChronMenuButtons*2)
	.DB  0x2,0x0,0x0,0x0,0x0,0x0
_0xE0000:
	.DB  0x31,0x0,0x32,0x0,0x33,0x0,0xCF,0xEE
	.DB  0xE5,0xF5,0xE0,0xEB,0xE8,0x21,0x0,0x25
	.DB  0x32,0x69,0x2E,0x25,0x30,0x32,0x69,0x56
	.DB  0x0,0xDD,0xF2,0xEE,0x20,0xF8,0xF0,0xE8
	.DB  0xF4,0xF2,0x20,0x34,0x78,0x36,0x0,0xDD
	.DB  0xF2,0xEE,0x20,0xF8,0xF0,0xE8,0xF4,0xF2
	.DB  0x20,0x36,0x78,0x38,0x0,0xDD,0xF2,0xEE
	.DB  0x20,0xF8,0xF0,0xE8,0xF4,0xF2,0x20,0x38
	.DB  0x78,0x38,0x0,0xDD,0xF2,0xEE,0x20,0xF8
	.DB  0xF0,0xE8,0xF4,0xF2,0x20,0x38,0x78,0x31
	.DB  0x32,0x0,0xCF,0xEE,0xE4,0xF1,0xE2,0xE5
	.DB  0xF2,0xEA,0xE0,0x20,0xC2,0xEA,0xEB,0x20
	.DB  0x0,0xCF,0xEE,0xE4,0xF1,0xE2,0xE5,0xF2
	.DB  0xEA,0xE0,0x20,0xC2,0xFB,0xEA,0xEB,0x0
	.DB  0xCD,0xE5,0x20,0xE7,0xE0,0xE1,0xF3,0xE4
	.DB  0xF2,0xE5,0x0,0xE2,0xFB,0xEA,0xEB,0xFE
	.DB  0xF7,0xE8,0xF2,0xFC,0x0,0xF2,0xE5,0xEB
	.DB  0xE5,0xE2,0xE8,0xE7,0xEE,0xF0,0x0,0x54
	.DB  0x65,0x73,0x74,0x20,0x4D,0x6F,0x64,0x65
	.DB  0x0,0x41,0x44,0x25,0x64,0x3A,0x20,0x25
	.DB  0x34,0x64,0x0,0x44,0x3A,0x20,0x0,0x45
	.DB  0x3A,0x20,0x0,0x41,0x3A,0x20,0x0,0x42
	.DB  0x3A,0x20,0x0,0x47,0x3A,0x20,0x0,0x54
	.DB  0x31,0x53,0x3A,0x20,0x25,0x35,0x75,0x0
	.DB  0x54,0x31,0x45,0x3A,0x20,0x25,0x35,0x75
	.DB  0x0,0x54,0x32,0x53,0x3A,0x20,0x25,0x35
	.DB  0x75,0x0,0x54,0x32,0x45,0x3A,0x20,0x25
	.DB  0x35,0x75,0x0,0x53,0x70,0x65,0x65,0x64
	.DB  0x20,0x31,0x3A,0x20,0x25,0x33,0x75,0x20
	.DB  0x6D,0x2F,0x73,0x0,0x53,0x70,0x65,0x65
	.DB  0x64,0x20,0x32,0x3A,0x20,0x25,0x33,0x75
	.DB  0x20,0x6D,0x2F,0x73,0x0,0x4C,0x31,0x53
	.DB  0x31,0x3A,0x20,0x25,0x33,0x75,0x2E,0x25
	.DB  0x31,0x75,0x20,0x6D,0x6D,0x0,0x4C,0x31
	.DB  0x53,0x32,0x3A,0x20,0x25,0x33,0x75,0x2E
	.DB  0x25,0x31,0x75,0x20,0x6D,0x6D,0x0,0x4C
	.DB  0x32,0x53,0x31,0x3A,0x20,0x25,0x33,0x75
	.DB  0x2E,0x25,0x31,0x75,0x20,0x6D,0x6D,0x0
	.DB  0x4C,0x32,0x53,0x32,0x3A,0x20,0x25,0x33
	.DB  0x75,0x2E,0x25,0x31,0x75,0x20,0x6D,0x6D
	.DB  0x0,0x52,0x45,0x56,0x0,0x4E,0x4F,0x52
	.DB  0x0,0x44,0x69,0x72,0x65,0x63,0x74,0x69
	.DB  0x6F,0x6E,0x3A,0x0,0x53,0x74,0x61,0x72
	.DB  0x74,0x0,0x44,0x69,0x72,0x65,0x63,0x74
	.DB  0x69,0x6F,0x6E,0x0,0x43,0x68,0x72,0x6F
	.DB  0x6E,0x0
_0x140003:
	.DB  LOW(_0x140000*2),HIGH(_0x140000*2),LOW(_0x140000*2+7),HIGH(_0x140000*2+7),LOW(_0x140000*2+16),HIGH(_0x140000*2+16)
_0x140000:
	.DB  0x4E,0x6F,0x72,0x6D,0x61,0x6C,0x0,0x50
	.DB  0x69,0x6C,0x6F,0x74,0x61,0x67,0x65,0x0
	.DB  0x4C,0x61,0x6E,0x64,0x69,0x6E,0x67,0x0
	.DB  0x4D,0x6F,0x64,0x65,0x6C,0x20,0x25,0x64
	.DB  0x0,0x43,0x61,0x6C,0x69,0x62,0x72,0x61
	.DB  0x74,0x69,0x6E,0x67,0x0,0x43,0x65,0x6E
	.DB  0x74,0x65,0x72,0x20,0x61,0x6C,0x6C,0xA
	.DB  0x73,0x74,0x69,0x63,0x6B,0x73,0x20,0x61
	.DB  0x6E,0x64,0xA,0x70,0x72,0x65,0x73,0x73
	.DB  0x20,0x45,0x6E,0x74,0x65,0x72,0x0,0x43
	.DB  0x61,0x6C,0x69,0x62,0x72,0x61,0x74,0x69
	.DB  0x6F,0x6E,0x0,0x50,0x6C,0x65,0x61,0x73
	.DB  0x65,0x0,0x77,0x61,0x69,0x74,0x2E,0x2E
	.DB  0x2E,0x0
_0x160000:
	.DB  0x25,0x64,0x0,0x46,0x72,0x6F,0x6D,0x3A
	.DB  0x0,0x54,0x6F,0x3A,0x0,0x25,0x70,0x0
	.DB  0x25,0x73,0x0
_0x18001C:
	.DB  LOW(_0x180000*2+89),HIGH(_0x180000*2+89),LOW(_0x180000*2+95),HIGH(_0x180000*2+95)
_0x18001E:
	.DB  LOW(_0x180000*2+115),HIGH(_0x180000*2+115),LOW(_0x180000*2+119),HIGH(_0x180000*2+119),LOW(_0x180000*2+124),HIGH(_0x180000*2+124)
_0x180027:
	.DB  LOW(_0x180000*2+241),HIGH(_0x180000*2+241),LOW(_Font_8x12),HIGH(_Font_8x12),LOW(_Font_6x8),HIGH(_Font_6x8),LOW(_ModelMenuButtons*2),HIGH(_ModelMenuButtons*2)
	.DB  0xA,0x0,0x0,0x0,0x0,0x0
_0x180066:
	.DB  LOW(_0x180000*2+356),HIGH(_0x180000*2+356),LOW(_Font_8x12),HIGH(_Font_8x12),LOW(_Font_6x8),HIGH(_Font_6x8),0x0,0x0
	.DB  0x0,0x0,0x0,0x0,0x0,0x0
_0x18007A:
	.DB  LOW(_0x180000*2+356),HIGH(_0x180000*2+356),LOW(_Font_8x12),HIGH(_Font_8x12),LOW(_Font_6x8),HIGH(_Font_6x8),LOW(_ControlsMenuButtons*2),HIGH(_ControlsMenuButtons*2)
	.DB  0xA,0x0,0x0,0x0,0x0,0x0
_0x18007B:
	.DB  LOW(_0x180000*2+440),HIGH(_0x180000*2+440),LOW(_Font_8x12),HIGH(_Font_8x12),LOW(_Font_6x8),HIGH(_Font_6x8),LOW(_MixerMenuButtons*2),HIGH(_MixerMenuButtons*2)
	.DB  0xB,0x0,0x0,0x0,0x0,0x0
_0x18007C:
	.DB  LOW(_0x180000*2+145),HIGH(_0x180000*2+145),LOW(_Font_8x12),HIGH(_Font_8x12),LOW(_Font_6x8),HIGH(_Font_6x8),LOW(_ChannelsMenuButtons*2),HIGH(_ChannelsMenuButtons*2)
	.DB  0x8,0x0,0x0,0x0,0x0,0x0
_0x180090:
	.DB  LOW(_0x180000*2+551),HIGH(_0x180000*2+551),LOW(_Font_8x12),HIGH(_Font_8x12),LOW(_Font_6x8),HIGH(_Font_6x8),LOW(_TimerMenuButtons*2),HIGH(_TimerMenuButtons*2)
	.DB  0x3,0x0,0x0,0x0,0x0,0x0
_0x180099:
	.DB  LOW(_0x180000*2+590),HIGH(_0x180000*2+590),LOW(_Font_8x12),HIGH(_Font_8x12),LOW(_Font_6x8),HIGH(_Font_6x8),LOW(_OptionsMenuButtons*2),HIGH(_OptionsMenuButtons*2)
	.DB  0x3,0x0,0x0,0x0,0x0,0x0
_0x18009A:
	.DB  LOW(_0x180000*2+623),HIGH(_0x180000*2+623),LOW(_Font_8x12),HIGH(_Font_8x12),LOW(_Font_6x8),HIGH(_Font_6x8),LOW(_TestMenuButtons*2),HIGH(_TestMenuButtons*2)
	.DB  0x9,0x0,0x0,0x0,0x0,0x0
_0x180000:
	.DB  0x25,0x64,0x0,0x25,0x32,0x69,0x2E,0x25
	.DB  0x30,0x32,0x69,0x56,0x0,0x4D,0x6F,0x64
	.DB  0x65,0x6C,0x20,0x43,0x6F,0x70,0x79,0x3A
	.DB  0x0,0x4D,0x6F,0x64,0x65,0x20,0x43,0x6F
	.DB  0x70,0x79,0x3A,0x0,0x41,0x72,0x65,0x20
	.DB  0x79,0x6F,0x75,0xA,0x73,0x75,0x72,0x65
	.DB  0x20,0x3F,0x0,0x4D,0x6F,0x64,0x65,0x6C
	.DB  0x20,0x53,0x61,0x76,0x65,0x0,0x50,0x6C
	.DB  0x65,0x61,0x73,0x65,0xA,0x77,0x61,0x69
	.DB  0x74,0x2E,0x2E,0x2E,0x0,0x4D,0x6F,0x64
	.DB  0x65,0x6C,0x20,0x52,0x65,0x73,0x65,0x74
	.DB  0x0,0x50,0x6C,0x61,0x6E,0x65,0x0,0x48
	.DB  0x65,0x6C,0x69,0x0,0x25,0x70,0x0,0x4D
	.DB  0x6F,0x64,0x65,0x6C,0x20,0x54,0x79,0x70
	.DB  0x65,0x3A,0x0,0x50,0x50,0x4D,0x0,0x49
	.DB  0x50,0x50,0x4D,0x0,0x50,0x43,0x4D,0x0
	.DB  0x4D,0x6F,0x64,0x75,0x6C,0x61,0x74,0x69
	.DB  0x6F,0x6E,0x20,0x54,0x79,0x70,0x65,0x3A
	.DB  0x0,0x43,0x68,0x61,0x6E,0x6E,0x65,0x6C
	.DB  0x73,0x0,0x25,0x73,0x0,0x4D,0x6F,0x64
	.DB  0x65,0x6C,0x20,0x4E,0x61,0x6D,0x65,0x3A
	.DB  0x0,0x4D,0x6F,0x64,0x65,0x20,0x4E,0x61
	.DB  0x6D,0x65,0x3A,0x0,0x4D,0x6F,0x64,0x65
	.DB  0x6C,0x3A,0x0,0x4E,0x61,0x6D,0x65,0x0
	.DB  0x54,0x79,0x70,0x65,0x0,0x4D,0x6F,0x64
	.DB  0x75,0x6C,0x61,0x74,0x69,0x6F,0x6E,0x0
	.DB  0x4D,0x6F,0x64,0x65,0x20,0x4E,0x61,0x6D
	.DB  0x65,0x0,0x53,0x65,0x6C,0x65,0x63,0x74
	.DB  0x0,0x43,0x6F,0x70,0x79,0x0,0x4D,0x6F
	.DB  0x64,0x65,0x73,0x20,0x43,0x6F,0x70,0x79
	.DB  0x0,0x4D,0x6F,0x64,0x65,0x6C,0x0,0x46
	.DB  0x72,0x6F,0x6D,0x3A,0x0,0x4F,0x46,0x46
	.DB  0x0,0x4F,0x4E,0x0,0x45,0x52,0x52,0x4F
	.DB  0x52,0x0,0x52,0x65,0x76,0x65,0x72,0x73
	.DB  0x65,0x3A,0x0,0x43,0x6F,0x6E,0x74,0x72
	.DB  0x6F,0x6C,0x3A,0x0,0x43,0x75,0x72,0x76
	.DB  0x65,0x0,0x52,0x65,0x76,0x65,0x72,0x73
	.DB  0x65,0x0,0x4D,0x69,0x6E,0x20,0x52,0x61
	.DB  0x74,0x65,0x0,0x4D,0x61,0x78,0x20,0x52
	.DB  0x61,0x74,0x65,0x0,0x4D,0x69,0x6E,0x20
	.DB  0x44,0x75,0x61,0x6C,0x20,0x52,0x61,0x74
	.DB  0x65,0x0,0x4D,0x61,0x78,0x20,0x44,0x75
	.DB  0x61,0x6C,0x20,0x52,0x61,0x74,0x65,0x0
	.DB  0x54,0x2E,0x20,0x43,0x75,0x74,0x0,0x46
	.DB  0x72,0x6F,0x6D,0x0,0x43,0x6F,0x6E,0x74
	.DB  0x72,0x6F,0x6C,0x73,0x0,0x41,0x69,0x6C
	.DB  0x65,0x72,0x6F,0x6E,0x73,0x0,0x45,0x6C
	.DB  0x65,0x76,0x61,0x74,0x6F,0x72,0x0,0x54
	.DB  0x68,0x72,0x6F,0x74,0x74,0x6C,0x65,0x0
	.DB  0x52,0x75,0x64,0x64,0x65,0x72,0x0,0x53
	.DB  0x57,0x20,0x31,0x0,0x53,0x57,0x20,0x32
	.DB  0x0,0x53,0x57,0x20,0x33,0x0,0x41,0x75
	.DB  0x78,0x20,0x31,0x0,0x56,0x69,0x72,0x74
	.DB  0x75,0x61,0x6C,0x20,0x31,0x0,0x56,0x69
	.DB  0x72,0x74,0x75,0x61,0x6C,0x20,0x32,0x0
	.DB  0x4D,0x69,0x78,0x65,0x72,0x0,0x54,0x72
	.DB  0x69,0x6D,0x0,0x43,0x48,0x20,0x25,0x6E
	.DB  0x20,0x4D,0x69,0x78,0x65,0x72,0x0,0x43
	.DB  0x48,0x20,0x31,0x0,0x43,0x48,0x20,0x32
	.DB  0x0,0x43,0x48,0x20,0x33,0x0,0x43,0x48
	.DB  0x20,0x34,0x0,0x43,0x48,0x20,0x35,0x0
	.DB  0x43,0x48,0x20,0x36,0x0,0x43,0x48,0x20
	.DB  0x37,0x0,0x43,0x48,0x20,0x38,0x0,0x44
	.DB  0x4F,0x57,0x4E,0x0,0x55,0x50,0x0,0x54
	.DB  0x69,0x6D,0x65,0x72,0x20,0x4D,0x6F,0x64
	.DB  0x65,0x3A,0x0,0x54,0x69,0x6D,0x65,0x72
	.DB  0x20,0x53,0x6F,0x75,0x6E,0x64,0x3A,0x0
	.DB  0x53,0x65,0x74,0x0,0x4D,0x6F,0x64,0x65
	.DB  0x0,0x53,0x6F,0x75,0x6E,0x64,0x0,0x54
	.DB  0x69,0x6D,0x65,0x72,0x0,0x42,0x61,0x63
	.DB  0x6B,0x6C,0x69,0x67,0x68,0x74,0x3A,0x0
	.DB  0x42,0x61,0x63,0x6B,0x6C,0x69,0x67,0x68
	.DB  0x74,0x0,0x43,0x61,0x6C,0x69,0x62,0x72
	.DB  0x61,0x74,0x69,0x6F,0x6E,0x0,0x4F,0x70
	.DB  0x74,0x69,0x6F,0x6E,0x73,0x0,0x49,0x4F
	.DB  0x20,0x54,0x65,0x73,0x74,0x0,0x44,0x65
	.DB  0x6D,0x6F,0x0,0x43,0x68,0x72,0x6F,0x6E
	.DB  0x0,0x4D,0x75,0x73,0x69,0x63,0x0,0x4D
	.DB  0x61,0x69,0x6E,0x20,0x4D,0x65,0x6E,0x75
	.DB  0x0
_0x1C000B:
	.DB  LOW(_0x1C0000*2+76),HIGH(_0x1C0000*2+76),LOW(_Font_8x12),HIGH(_Font_8x12),LOW(_Font_6x8),HIGH(_Font_6x8),LOW(_MusicMenuButtons*2),HIGH(_MusicMenuButtons*2)
	.DB  0x2,0x0,0x0,0x0,0x0,0x0
_0x1C0000:
	.DB  0x53,0x75,0x70,0x65,0x72,0x20,0x4D,0x61
	.DB  0x72,0x69,0x6F,0x20,0x54,0x68,0x65,0x6D
	.DB  0x65,0x0,0x55,0x6E,0x64,0x65,0x72,0x77
	.DB  0x6F,0x6C,0x72,0x64,0x20,0x54,0x68,0x65
	.DB  0x6D,0x65,0x0,0x53,0x74,0x61,0x72,0x74
	.DB  0x20,0x4D,0x61,0x72,0x69,0x6F,0x20,0x54
	.DB  0x68,0x65,0x6D,0x65,0x0,0x53,0x74,0x61
	.DB  0x72,0x74,0x20,0x55,0x6E,0x64,0x65,0x72
	.DB  0x77,0x6F,0x72,0x6C,0x64,0x20,0x54,0x68
	.DB  0x65,0x6D,0x65,0x0,0x4D,0x75,0x73,0x69
	.DB  0x63,0x0

__GLOBAL_INI_TBL:
	.DW  0x01
	.DW  0x02
	.DW  __REG_BIT_VARS*2

	.DW  0x06
	.DW  _DefModeNames_G00A
	.DW  _0x140003*2

	.DW  0x04
	.DW  _ModelTypes
	.DW  _0x18001C*2

	.DW  0x06
	.DW  _ModulationTypes
	.DW  _0x18001E*2

_0xFFFFFFFF:
	.DW  0

__RESET:
	CLI
	CLR  R30
	OUT  EECR,R30

;INTERRUPT VECTORS ARE PLACED
;AT THE START OF FLASH
	LDI  R31,1
	OUT  MCUCR,R31
	OUT  MCUCR,R30
	STS  XMCRB,R30

;DISABLE WATCHDOG
	LDI  R31,0x18
	OUT  WDTCR,R31
	OUT  WDTCR,R30

;CLEAR R2-R14
	LDI  R24,(14-2)+1
	LDI  R26,2
	CLR  R27
__CLEAR_REG:
	ST   X+,R30
	DEC  R24
	BRNE __CLEAR_REG

;CLEAR SRAM
	LDI  R24,LOW(__CLEAR_SRAM_SIZE)
	LDI  R25,HIGH(__CLEAR_SRAM_SIZE)
	LDI  R26,LOW(__SRAM_START)
	LDI  R27,HIGH(__SRAM_START)
__CLEAR_SRAM:
	ST   X+,R30
	SBIW R24,1
	BRNE __CLEAR_SRAM

;GLOBAL VARIABLES INITIALIZATION
	LDI  R30,LOW(__GLOBAL_INI_TBL*2)
	LDI  R31,HIGH(__GLOBAL_INI_TBL*2)
__GLOBAL_INI_NEXT:
	LPM  R24,Z+
	LPM  R25,Z+
	SBIW R24,0
	BREQ __GLOBAL_INI_END
	LPM  R26,Z+
	LPM  R27,Z+
	LPM  R0,Z+
	LPM  R1,Z+
	MOVW R22,R30
	MOVW R30,R0
__GLOBAL_INI_LOOP:
	LPM  R0,Z+
	ST   X+,R0
	SBIW R24,1
	BRNE __GLOBAL_INI_LOOP
	MOVW R30,R22
	RJMP __GLOBAL_INI_NEXT
__GLOBAL_INI_END:

	OUT  RAMPZ,R24

;HARDWARE STACK POINTER INITIALIZATION
	LDI  R30,LOW(__SRAM_END-__HEAP_SIZE)
	OUT  SPL,R30
	LDI  R30,HIGH(__SRAM_END-__HEAP_SIZE)
	OUT  SPH,R30

;DATA STACK POINTER INITIALIZATION
	LDI  R28,LOW(__SRAM_START+__DSTACK_SIZE)
	LDI  R29,HIGH(__SRAM_START+__DSTACK_SIZE)

	JMP  _main

	.ESEG
	.ORG 0

	.DSEG
	.ORG 0x500

	.CSEG
;/*******************************************************************************
;*  Coder.c
;*
;*  :  
;*
;*       Copyright (c) 2007-2008 Nick Shl, focus
;*           All rights reserved.
;*
;*
;*  :
;*
;*  Apr 20, 2009  Nick_Shl  
;*  Apr 10, 2008  Nick_Shl  , .
;*  *** **, ****  focus      
;*
;*  Chip type           : ATmega128
;*  Program type        : Application
;*  Clock frequency     : 16,000000 MHz
;*  Memory model        : Small
;*  External SRAM size  : 0
;*  Data Stack size     : 1024
;*/// ***************************************************************************
;
;// *****************************************************************************
;// ***       ***************************************************
;// *****************************************************************************
;#include <mega128.h>
	#ifndef __SLEEP_DEFINED__
	#define __SLEEP_DEFINED__
	.EQU __se_bit=0x20
	.EQU __sm_mask=0x1C
	.EQU __sm_powerdown=0x10
	.EQU __sm_powersave=0x18
	.EQU __sm_standby=0x14
	.EQU __sm_ext_standby=0x1C
	.EQU __sm_adc_noise_red=0x08
	.SET power_ctrl_reg=mcucr
	#endif
;#include <delay.h>
;#include <stdio.h>
;
;// *****************************************************************************
;// ***     COM  -  CodeVisionAVR   *******************
;// *****************************************************************************
;#define RXB8 1
;#define TXB8 0
;#define UPE 2
;#define OVR 3
;#define FE 4
;#define UDRE 5
;#define RXC 7
;
;#define FRAMING_ERROR (1 << FE)
;#define PARITY_ERROR (1 << UPE)
;#define DATA_OVERRUN (1 << OVR)
;#define DATA_REGISTER_EMPTY (1 << UDRE)
;#define RX_COMPLETE (1 << RXC)
;
;// USART0 Receiver buffer
;#define RX_BUFFER_SIZE0 32
;char rx_buffer0[RX_BUFFER_SIZE0];
;
;#if RX_BUFFER_SIZE0 < 256
;    unsigned char rx_wr_index0, rx_rd_index0, rx_counter0;
;#else
;    unsigned int rx_wr_index0, rx_rd_index0, rx_counter0;
;#endif
;
;// This flag is set on USART0 Receiver buffer overflow
;bit rx_buffer_overflow0;
;
;// USART0 Receiver interrupt service routine
;interrupt [USART0_RXC] void usart0_rx_isr(void)
; 0000 003F {

	.CSEG
_usart0_rx_isr:
	ST   -Y,R30
	ST   -Y,R31
	IN   R30,SREG
	ST   -Y,R30
; 0000 0040     char status, data;
; 0000 0041     status = UCSR0A;
	ST   -Y,R17
	ST   -Y,R16
;	status -> R17
;	data -> R16
	IN   R17,11
; 0000 0042     data = UDR0;
	IN   R16,12
; 0000 0043     if((status & (FRAMING_ERROR | PARITY_ERROR | DATA_OVERRUN)) == 0)
	MOV  R30,R17
	ANDI R30,LOW(0x1C)
	BRNE _0x3
; 0000 0044     {
; 0000 0045         rx_buffer0[rx_wr_index0] = data;
	MOV  R30,R4
	LDI  R31,0
	SUBI R30,LOW(-_rx_buffer0)
	SBCI R31,HIGH(-_rx_buffer0)
	ST   Z,R16
; 0000 0046         if(++rx_wr_index0 == RX_BUFFER_SIZE0) rx_wr_index0 = 0;
	INC  R4
	LDI  R30,LOW(32)
	CP   R30,R4
	BRNE _0x4
	CLR  R4
; 0000 0047         if(++rx_counter0 == RX_BUFFER_SIZE0)
_0x4:
	INC  R6
	LDI  R30,LOW(32)
	CP   R30,R6
	BRNE _0x5
; 0000 0048         {
; 0000 0049             rx_counter0 = 0;
	CLR  R6
; 0000 004A             rx_buffer_overflow0 = 1;
	SET
	BLD  R2,0
; 0000 004B         };
_0x5:
; 0000 004C     };
_0x3:
; 0000 004D }
	LD   R16,Y+
	LD   R17,Y+
	LD   R30,Y+
	OUT  SREG,R30
	LD   R31,Y+
	LD   R30,Y+
	RETI
;
;#ifndef _DEBUG_TERMINAL_IO_
;// Get a character from the USART0 Receiver buffer
;#define _ALTERNATE_GETCHAR_
;#pragma used+
;char getchar(void)
; 0000 0054 {
; 0000 0055     char data;
; 0000 0056     while(rx_counter0 == 0);
;	data -> R17
; 0000 0057     data = rx_buffer0[rx_rd_index0];
; 0000 0058     if (++rx_rd_index0 == RX_BUFFER_SIZE0) rx_rd_index0 = 0;
; 0000 0059     #asm("cli")
; 0000 005A     --rx_counter0;
; 0000 005B     #asm("sei")
; 0000 005C     return data;
; 0000 005D }
;#pragma used-
;#endif
;
;// USART0 Transmitter buffer
;#define TX_BUFFER_SIZE0 32
;char tx_buffer0[TX_BUFFER_SIZE0];
;
;#if TX_BUFFER_SIZE0 < 256
;    unsigned char tx_wr_index0, tx_rd_index0, tx_counter0;
;#else
;    unsigned int tx_wr_index0, tx_rd_index0, tx_counter0;
;#endif
;
;// USART0 Transmitter interrupt service routine
;interrupt [USART0_TXC] void usart0_tx_isr(void)
; 0000 006D {
_usart0_tx_isr:
	ST   -Y,R30
	ST   -Y,R31
	IN   R30,SREG
	ST   -Y,R30
; 0000 006E     if(tx_counter0)
	TST  R7
	BREQ _0xA
; 0000 006F     {
; 0000 0070         --tx_counter0;
	DEC  R7
; 0000 0071         UDR0 = tx_buffer0[tx_rd_index0];
	MOV  R30,R8
	LDI  R31,0
	SUBI R30,LOW(-_tx_buffer0)
	SBCI R31,HIGH(-_tx_buffer0)
	LD   R30,Z
	OUT  0xC,R30
; 0000 0072         if(++tx_rd_index0 == TX_BUFFER_SIZE0) tx_rd_index0 = 0;
	INC  R8
	LDI  R30,LOW(32)
	CP   R30,R8
	BRNE _0xB
	CLR  R8
; 0000 0073     };
_0xB:
_0xA:
; 0000 0074 }
	LD   R30,Y+
	OUT  SREG,R30
	LD   R31,Y+
	LD   R30,Y+
	RETI
;
;#ifndef _DEBUG_TERMINAL_IO_
;// Write a character to the USART0 Transmitter buffer
;#define _ALTERNATE_PUTCHAR_
;#pragma used+
;void putchar(char c)
; 0000 007B {
; 0000 007C     while(tx_counter0 == TX_BUFFER_SIZE0);
;	c -> Y+0
; 0000 007D     #asm("cli")
; 0000 007E     if(tx_counter0 || ((UCSR0A & DATA_REGISTER_EMPTY) == 0))
; 0000 007F     {
; 0000 0080         tx_buffer0[tx_wr_index0] = c;
; 0000 0081         if(++tx_wr_index0 == TX_BUFFER_SIZE0) tx_wr_index0 = 0;
; 0000 0082         ++tx_counter0;
; 0000 0083     }
; 0000 0084     else UDR0 = c;
; 0000 0085     #asm("sei")
; 0000 0086 }
;#pragma used-
;#endif
;
;// *****************************************************************************
;// ***       COM    **************************************
;// *****************************************************************************
;
;// *****************************************************************************
;// ***       ********************************************
;// *****************************************************************************
;#include "Def.h"
;#include "Hardware.h"
;#include "Variables.h"
;#include "Graphic.h"
;#include "Sound.h"
;#include "Math.h"
;#include "System.h"
;#include "Crc.h"
;#include "Tasks.h"
;#include "UI_Engine.h"
;#include "User_Interface.h"
;
;// *****************************************************************************
;// ***       ***********************************************
;// *****************************************************************************
;static unsigned long TickCount = 0;
;flash unsigned int TxStartSound[] = {784<<4 + 2, 660<<4 + 1, 523<<4 + 1, 784<<4 + 2};
;
;// *****************************************************************************
;// ***       ***************************************************
;// *****************************************************************************
;
;// *****************************************************************************
;// ***      *********************************************************
;// *****************************************************************************
;
;// *****************************************************************************
;// ***            ************
;// *****************************************************************************
;inline unsigned long GetTickCount(void)
; 0000 00AF {
; 0000 00B0 #ifdef DEBUG
; 0000 00B1     return(TickCount / TASK_TICK_TIME);
; 0000 00B2 #else
; 0000 00B3     return(TickCount);
; 0000 00B4 #endif
; 0000 00B5 }
;
;// *****************************************************************************
;// ***            ***************
;// *****************************************************************************
;inline unsigned long GetRunningTime(void)
; 0000 00BB {
_GetRunningTime:
; 0000 00BC #ifdef DEBUG
; 0000 00BD     return(TickCount);
; 0000 00BE #else
; 0000 00BF     return(TickCount * TASK_TICK_TIME);
	LDS  R30,_TickCount_G000
	LDS  R31,_TickCount_G000+1
	LDS  R22,_TickCount_G000+2
	LDS  R23,_TickCount_G000+3
	__GETD2N 0x14
	CALL __MULD12U
	RET
; 0000 00C0 #endif
; 0000 00C1 }
;
;// *****************************************************************************
;// ***                                                      ***
;// ***           :)          ***
;// *****************************************************************************
;interrupt [TIM1_COMPA] void timer1_compa_isr(void)
; 0000 00C8 {
_timer1_compa_isr:
	ST   -Y,R0
	ST   -Y,R1
	ST   -Y,R15
	ST   -Y,R22
	ST   -Y,R23
	ST   -Y,R24
	ST   -Y,R25
	ST   -Y,R26
	ST   -Y,R27
	ST   -Y,R30
	ST   -Y,R31
	IN   R30,SREG
	ST   -Y,R30
; 0000 00C9     //   
; 0000 00CA     static unsigned char nb = 0;
; 0000 00CB     //     PPM 
; 0000 00CC     static unsigned int del = 0;
; 0000 00CD 
; 0000 00CE #ifdef DEBUG
; 0000 00CF     //  
; 0000 00D0     static unsigned char gauge = 0; //  
; 0000 00D1     static char dir = 1;            //  
; 0000 00D2 #endif
; 0000 00D3 
; 0000 00D4     if(nb < CurModel.num_ch)
	__GETB1MN _CurModel,20
	LDS  R26,_nb_S0000006000
	LDI  R27,0
	LDI  R31,0
	SBRC R30,7
	SER  R31
	CP   R26,R30
	CPC  R27,R31
	BRLT PC+3
	JMP _0x14
; 0000 00D5     {
; 0000 00D6         //    - 
; 0000 00D7         math_CalcChannel(nb);
	LDS  R30,_nb_S0000006000
	ST   -Y,R30
	CALL _math_CalcChannel
; 0000 00D8 
; 0000 00D9         ICR1H = output[nb] >> 8;         //    (Hi)
	LDS  R30,_nb_S0000006000
	LDI  R26,LOW(_output)
	LDI  R27,HIGH(_output)
	LDI  R31,0
	LSL  R30
	ROL  R31
	ADD  R26,R30
	ADC  R27,R31
	CALL __GETW1P
	CALL __ASRW8
	OUT  0x27,R30
; 0000 00DA         ICR1L = output[nb] & 0b11111111; //    (Lo)
	LDS  R30,_nb_S0000006000
	LDI  R26,LOW(_output)
	LDI  R27,HIGH(_output)
	LDI  R31,0
	LSL  R30
	ROL  R31
	ADD  R26,R30
	ADC  R27,R31
	LD   R30,X
	OUT  0x26,R30
; 0000 00DB 
; 0000 00DC         del += output[nb]; //        
	LDS  R30,_nb_S0000006000
	LDI  R26,LOW(_output)
	LDI  R27,HIGH(_output)
	LDI  R31,0
	LSL  R30
	ROL  R31
	ADD  R26,R30
	ADC  R27,R31
	CALL __GETW1P
	LDS  R26,_del_S0000006000
	LDS  R27,_del_S0000006000+1
	ADD  R30,R26
	ADC  R31,R27
	STS  _del_S0000006000,R30
	STS  _del_S0000006000+1,R31
; 0000 00DD 
; 0000 00DE         nb++; //   
	LDS  R30,_nb_S0000006000
	SUBI R30,-LOW(1)
	STS  _nb_S0000006000,R30
; 0000 00DF     }
; 0000 00E0     else
	RJMP _0x15
_0x14:
; 0000 00E1     {
; 0000 00E2         del = TimerClockPerSec(0.020) - del; //  :  
	LDS  R26,_del_S0000006000
	LDS  R27,_del_S0000006000+1
	LDI  R30,LOW(40000)
	LDI  R31,HIGH(40000)
	SUB  R30,R26
	SBC  R31,R27
	STS  _del_S0000006000,R30
	STS  _del_S0000006000+1,R31
; 0000 00E3                                              //  0.020 (20 ) -   
; 0000 00E4         ICR1H = del >> 8;                    //    (Hi)
	LDS  R30,_del_S0000006000+1
	ANDI R31,HIGH(0x0)
	OUT  0x27,R30
; 0000 00E5         ICR1L = del & 0b11111111;            //    (Lo)
	LDS  R30,_del_S0000006000
	OUT  0x26,R30
; 0000 00E6 
; 0000 00E7         del = 0; //     
	LDI  R30,LOW(0)
	STS  _del_S0000006000,R30
	STS  _del_S0000006000+1,R30
; 0000 00E8         nb = 0;  //   
	STS  _nb_S0000006000,R30
; 0000 00E9 
; 0000 00EA #ifdef DEBUG
; 0000 00EB         //     -    -.
; 0000 00EC         if(gauge == 0x00) dir = +1;
; 0000 00ED         if(gauge == 0xFF) dir = -1;
; 0000 00EE         GAUGE(gauge);
; 0000 00EF         gauge += dir;
; 0000 00F0 #endif
; 0000 00F1 
; 0000 00F2         //    
; 0000 00F3         math_CalcControls();
	CALL _math_CalcControls
; 0000 00F4 
; 0000 00F5         //      :
; 0000 00F6         // (    *  ) /    
; 0000 00F7         Aref = (123L * 1023L) / (long)read_adc(0x1E);
	LDI  R30,LOW(30)
	ST   -Y,R30
	CALL _read_adc
	CLR  R22
	CLR  R23
	__GETD2N 0x1EB85
	CALL __DIVD21
	STS  _Aref,R30
	STS  _Aref+1,R31
; 0000 00F8     }
_0x15:
; 0000 00F9 }
	LD   R30,Y+
	OUT  SREG,R30
	LD   R31,Y+
	LD   R30,Y+
	LD   R27,Y+
	LD   R26,Y+
	LD   R25,Y+
	LD   R24,Y+
	LD   R23,Y+
	LD   R22,Y+
	LD   R15,Y+
	LD   R1,Y+
	LD   R0,Y+
	RETI
;
;// *****************************************************************************
;// ***                                                      ***
;// ***         ,   ***
;// ***      ,       ..    ***
;// ***         .     ***
;// ***   FIX ME:                ***
;// ***   timer1_compa_isr   :                                 ***
;// ***   if(nb == 0) timer3_compa_isr();                                     ***
;// *****************************************************************************
;interrupt [TIM3_COMPA] void timer3_compa_isr(void)
; 0000 0105 {
_timer3_compa_isr:
	ST   -Y,R0
	ST   -Y,R1
	ST   -Y,R15
	ST   -Y,R22
	ST   -Y,R23
	ST   -Y,R24
	ST   -Y,R25
	ST   -Y,R26
	ST   -Y,R27
	ST   -Y,R30
	ST   -Y,R31
	IN   R30,SREG
	ST   -Y,R30
; 0000 0106     static unsigned char InterruptEnterFlag = 0;
; 0000 0107     static unsigned char MissedIntCount = 0;
; 0000 0108     unsigned char MissedInterruptsCount = 0;
; 0000 0109 
; 0000 010A     //      TASK_TICK_TIME   (DEBUG) 
; 0000 010B     TickCount++;
	ST   -Y,R17
;	MissedInterruptsCount -> R17
	LDI  R17,0
	LDI  R26,LOW(_TickCount_G000)
	LDI  R27,HIGH(_TickCount_G000)
	CALL __GETD1P_INC
	__SUBD1N -1
	CALL __PUTDP1_DEC
; 0000 010C 
; 0000 010D #ifdef DEBUG
; 0000 010E     if(TickCount % TASK_TICK_TIME) return;
; 0000 010F #endif
; 0000 0110 
; 0000 0111     //        -   
; 0000 0112     //    .
; 0000 0113     if(InterruptEnterFlag)
	LDS  R30,_InterruptEnterFlag_S0000007000
	CPI  R30,0
	BREQ _0x16
; 0000 0114     {
; 0000 0115         MissedIntCount++;
	LDS  R30,_MissedIntCount_S0000007000
	SUBI R30,-LOW(1)
	STS  _MissedIntCount_S0000007000,R30
; 0000 0116         return;
	RJMP _0x3D
; 0000 0117     }
; 0000 0118 
; 0000 0119     //   ,       
; 0000 011A     InterruptEnterFlag = 1;
_0x16:
	LDI  R30,LOW(1)
	STS  _InterruptEnterFlag_S0000007000,R30
; 0000 011B     //       ,
; 0000 011C     // ..        .
; 0000 011D     MissedInterruptsCount = MissedIntCount;
	LDS  R17,_MissedIntCount_S0000007000
; 0000 011E     //    .
; 0000 011F     MissedIntCount = 0;
	LDI  R30,LOW(0)
	STS  _MissedIntCount_S0000007000,R30
; 0000 0120 
; 0000 0121     //       -    
; 0000 0122     #asm("sei")
	sei
; 0000 0123 
; 0000 0124     //   
; 0000 0125     Keyboard_Driver_Task(MissedInterruptsCount);
	ST   -Y,R17
	CALL _Keyboard_Driver_Task
; 0000 0126 
; 0000 0127     //    
; 0000 0128     Timer_Task(MissedInterruptsCount);
	ST   -Y,R17
	CALL _Timer_Task
; 0000 0129 
; 0000 012A     //    
; 0000 012B     PlaySound_Task(MissedInterruptsCount);
	ST   -Y,R17
	CALL _PlaySound_Task
; 0000 012C 
; 0000 012D     //   
; 0000 012E     Battery_Driver_Task(MissedInterruptsCount);
	ST   -Y,R17
	CALL _Battery_Driver_Task
; 0000 012F 
; 0000 0130     //   
; 0000 0131     Trimmers_Save_Task(MissedInterruptsCount);
	ST   -Y,R17
	CALL _Trimmers_Save_Task
; 0000 0132 
; 0000 0133     //    
; 0000 0134 //    gfx_AutoRefreshTask(MissedInterruptsCount);
; 0000 0135 
; 0000 0136     //  
; 0000 0137     #asm("cli")
	cli
; 0000 0138     //  C ,        
; 0000 0139     InterruptEnterFlag = 0;
	LDI  R30,LOW(0)
	STS  _InterruptEnterFlag_S0000007000,R30
; 0000 013A 
; 0000 013B     return;
_0x3D:
	LD   R17,Y+
	LD   R30,Y+
	OUT  SREG,R30
	LD   R31,Y+
	LD   R30,Y+
	LD   R27,Y+
	LD   R26,Y+
	LD   R25,Y+
	LD   R24,Y+
	LD   R23,Y+
	LD   R22,Y+
	LD   R15,Y+
	LD   R1,Y+
	LD   R0,Y+
	RETI
; 0000 013C }
;
;// *****************************************************************************
;// ***       *****************************************************
;// *****************************************************************************
;void main(void)
; 0000 0142 {
_main:
; 0000 0143     //     
; 0000 0144     unsigned long LastRefreshTime = 0;
; 0000 0145     //     
; 0000 0146     unsigned char Kbd = 0;
; 0000 0147 
; 0000 0148 // ***     **************************************************
; 0000 0149     hwl_InitPorts(); // Ports initialization
	SBIW R28,4
	LDI  R30,LOW(0)
	ST   Y,R30
	STD  Y+1,R30
	STD  Y+2,R30
	STD  Y+3,R30
;	LastRefreshTime -> Y+0
;	Kbd -> R17
	LDI  R17,0
	CALL _hwl_InitPorts
; 0000 014A     hwl_InitTimers(); // Timers/Counters initialization
	CALL _hwl_InitTimers
; 0000 014B     hwl_InitUSART0(BAUD_RATE); // USART0 initialization
	__GETD1N 0x1C200
	CALL __PUTPARD1
	CALL _hwl_InitUSART0
; 0000 014C     hwl_InitMisc(); // All other hardware initialization
	CALL _hwl_InitMisc
; 0000 014D 
; 0000 014E     //   
; 0000 014F #ifdef DEBUG
; 0000 0150     printf("Started program...\r");
; 0000 0151     printf("CRC FLASH:  0x%04X\r", Crc16_flash((unsigned char flash *)0, 0x1000 - sizeof(unsigned short)));
; 0000 0152     printf("CRC EEPROM: 0x%04X ", Get_EEPROM_CRC());
; 0000 0153     if(Is_EEPROM_CRC_Correct() == TRUE) printf("CORRECT\r");
; 0000 0154     else printf("INCORRECT\r");
; 0000 0155     if(sizeof(EEPROM_MODEL_SETTINGS) != sizeof(MODEL_SETTINGS)) printf("WARNING!!! ");
; 0000 0156     printf("EEPROM_MODEL_SETTINGS(%d) == MODEL_SETTINGS(%d);\r", sizeof(EEPROM_MODEL_SETTINGS), sizeof(MODEL_SETTINGS));
; 0000 0157     delay_ms(1);
; 0000 0158 #endif
; 0000 0159 
; 0000 015A     //   
; 0000 015B     gfx_Init();
	RCALL _gfx_Init
; 0000 015C     //  
; 0000 015D     gfx_ClearBuf();
	RCALL _gfx_ClearBuf
; 0000 015E     //    
; 0000 015F     MsgBoxF("Starting...", NULL, "TRANSMITTER", NULL);
	__POINTW1FN _0x0,0
	ST   -Y,R31
	ST   -Y,R30
	LDI  R30,LOW(0)
	LDI  R31,HIGH(0)
	ST   -Y,R31
	ST   -Y,R30
	__POINTW1FN _0x0,12
	ST   -Y,R31
	ST   -Y,R30
	LDI  R30,LOW(0)
	LDI  R31,HIGH(0)
	ST   -Y,R31
	ST   -Y,R30
	CALL _MsgBoxF
; 0000 0160 
; 0000 0161     //   ,       
; 0000 0162     if((EEPROM_SETTINGS.FirstON != 1) || (HB_BACK && HB_ENTER)) TX_Reset();
	__POINTW2MN _EEPROM_SETTINGS,2
	CALL __EEPROMRDB
	CPI  R30,LOW(0x1)
	BRNE _0x18
	SBIC 0x10,4
	RJMP _0x19
	SBIS 0x10,5
	RJMP _0x18
_0x19:
	RJMP _0x17
_0x18:
	CALL _TX_Reset
; 0000 0163     //      EEPROM  
; 0000 0164     if(Is_EEPROM_CRC_Correct() == FALSE)
_0x17:
	CALL _Is_EEPROM_CRC_Correct
	CPI  R30,0
	BRNE _0x1C
; 0000 0165     {
; 0000 0166         //    
; 0000 0167         MsgBoxF("EEPROM CRC ERROR\nReset to factory\ndefaults ?", &Font_6x8, "ERROR", NULL);
	__POINTW1FN _0x0,24
	ST   -Y,R31
	ST   -Y,R30
	LDI  R30,LOW(_Font_6x8)
	LDI  R31,HIGH(_Font_6x8)
	ST   -Y,R31
	ST   -Y,R30
	__POINTW1FN _0x0,69
	ST   -Y,R31
	ST   -Y,R30
	LDI  R30,LOW(0)
	LDI  R31,HIGH(0)
	ST   -Y,R31
	ST   -Y,R30
	CALL _MsgBoxF
; 0000 0168 
; 0000 0169         //   ,   
; 0000 016A         while(HB_ENTER || HB_BACK);
_0x1D:
	SBIS 0x10,5
	RJMP _0x20
	SBIC 0x10,4
	RJMP _0x1F
_0x20:
	RJMP _0x1D
_0x1F:
; 0000 016B         //   
; 0000 016C         while(!HB_ENTER && !HB_BACK);
_0x22:
	SBIS 0x10,5
	RJMP _0x25
	SBIC 0x10,4
	RJMP _0x26
_0x25:
	RJMP _0x24
_0x26:
	RJMP _0x22
_0x24:
; 0000 016D         // E   - 
; 0000 016E         if(HB_ENTER) TX_Reset();
	SBIC 0x10,5
	RJMP _0x27
	CALL _TX_Reset
; 0000 016F     }
_0x27:
; 0000 0170 
; 0000 0171     #asm("cli")
_0x1C:
	cli
; 0000 0172         //   (   EEPROM)
; 0000 0173         TX_Init();
	CALL _TX_Init
; 0000 0174         //      
; 0000 0175         TIMSK = 0x10;
	LDI  R30,LOW(16)
	OUT  0x37,R30
; 0000 0176         //     
; 0000 0177         ETIMSK = 0x10;
	STS  125,R30
; 0000 0178         //     
; 0000 0179         math_CalcControls();
	CALL _math_CalcControls
; 0000 017A     #asm("sei")
	sei
; 0000 017B 
; 0000 017C     //      
; 0000 017D     delay_ms(50);
	LDI  R30,LOW(50)
	LDI  R31,HIGH(50)
	ST   -Y,R31
	ST   -Y,R30
	CALL _delay_ms
; 0000 017E 
; 0000 017F     //  
; 0000 0180     PlaySound(TxStartSound, NumberOf(TxStartSound));
	LDI  R30,LOW(_TxStartSound*2)
	LDI  R31,HIGH(_TxStartSound*2)
	ST   -Y,R31
	ST   -Y,R30
	LDI  R30,LOW(4)
	LDI  R31,HIGH(4)
	ST   -Y,R31
	ST   -Y,R30
	CALL _PlaySound
; 0000 0181 
; 0000 0182 #ifdef DEBUG
; 0000 0183 //    StartTime = GetRunningTime();
; 0000 0184 //    printf("Execute time = %d ms\r", GetRunningTime() - LastRefreshTime);
; 0000 0185 #endif
; 0000 0186 
; 0000 0187     while(1)
_0x28:
; 0000 0188     {
; 0000 0189         //    
; 0000 018A         Sleep();
	CALL _Sleep
; 0000 018B 
; 0000 018C         trim_sound();
	CALL _trim_sound
; 0000 018D 
; 0000 018E         //        .     ,
; 0000 018F         //      ,    .   ,  
; 0000 0190         //       .
; 0000 0191         do
_0x2C:
; 0000 0192         {
; 0000 0193             //   100     
; 0000 0194             if(LastRefreshTime + 100 <= GetRunningTime())
	CALL __GETD1S0
	__ADDD1N 100
	PUSH R23
	PUSH R22
	PUSH R31
	PUSH R30
	RCALL _GetRunningTime
	POP  R26
	POP  R27
	POP  R24
	POP  R25
	CALL __CPD12
	BRLO _0x2E
; 0000 0195             {
; 0000 0196                 //    
; 0000 0197                 LastRefreshTime = GetRunningTime();
	RCALL _GetRunningTime
	CALL __PUTD1S0
; 0000 0198                 //   
; 0000 0199                 MainScreen();
	CALL _MainScreen
; 0000 019A #ifdef DEBUG
; 0000 019B //printf("MainScreen() execute time = %d ms (%d Ticks)\r", (GetTickCount() - LastRefreshTime) * TICK_TIME, GetTickCount() - LastRefreshTime);
; 0000 019C #endif
; 0000 019D             }
; 0000 019E         }
_0x2E:
; 0000 019F         while(Kbd && AskButtons());
	CPI  R17,0
	BREQ _0x2F
	CALL _AskButtons
	CPI  R30,0
	BRNE _0x30
_0x2F:
	RJMP _0x2D
_0x30:
	RJMP _0x2C
_0x2D:
; 0000 01A0 
; 0000 01A1         //   
; 0000 01A2         Kbd = AskButtons();
	CALL _AskButtons
	MOV  R17,R30
; 0000 01A3 
; 0000 01A4         //       
; 0000 01A5         if(GetTimerSoundStatus() == On && Kbd)
	CALL _GetTimerSoundStatus
	CPI  R30,LOW(0x1)
	BRNE _0x32
	CPI  R17,0
	BRNE _0x33
_0x32:
	RJMP _0x31
_0x33:
; 0000 01A6         {
; 0000 01A7             //   
; 0000 01A8             TimerSoundOff();
	CALL _TimerSoundOff
; 0000 01A9             //    
; 0000 01AA             continue;
	RJMP _0x28
; 0000 01AB         }
; 0000 01AC 
; 0000 01AD         //       
; 0000 01AE         if(Kbd & B_LEFT) Timer_Init();
_0x31:
	SBRS R17,2
	RJMP _0x34
	CALL _Timer_Init
; 0000 01AF         //    
; 0000 01B0         if(Kbd & B_UP) Timer_Stop();
_0x34:
	SBRS R17,0
	RJMP _0x35
	CALL _Timer_Stop
; 0000 01B1         //    
; 0000 01B2         if(Kbd & B_DOWN) Timer_Start();
_0x35:
	SBRS R17,1
	RJMP _0x36
	CALL _Timer_Start
; 0000 01B3 
; 0000 01B4         //       BACK
; 0000 01B5         //   BACK  /
; 0000 01B6         //     SRAM
; 0000 01B7         if(Kbd == B_BACK)
_0x36:
	CPI  R17,16
	BRNE _0x37
; 0000 01B8         {
; 0000 01B9             if(Settings.BacklightFlag == On) gfx_BackLight(Off);
	__GETB2MN _Settings,4
	CPI  R26,LOW(0x1)
	BRNE _0x38
	LDI  R30,LOW(0)
	RJMP _0x3C
; 0000 01BA             else                             gfx_BackLight(On);
_0x38:
	LDI  R30,LOW(1)
_0x3C:
	ST   -Y,R30
	RCALL _gfx_BackLight
; 0000 01BB         }
; 0000 01BC 
; 0000 01BD         //    
; 0000 01BE         if(Kbd == B_ENTER) MainMenu();
_0x37:
	CPI  R17,32
	BRNE _0x3A
	CALL _MainMenu
; 0000 01BF     };
_0x3A:
	RJMP _0x28
; 0000 01C0 }
_0x3B:
	RJMP _0x3B
;/*******************************************************************************
;*  Graphic.c
;*
;*  :     
;*
;*       Copyright (c) 2007-2008 Nick Shl, focus
;*           All rights reserved.
;*
;*
;*  :
;*
;*  Apr 20, 2009  Nick_Shl  
;*  Apr 10, 2008  Nick_Shl  ,  
;*                             
;*  *** **, ****  focus      
;*
;*/// ***************************************************************************
;
;// *****************************************************************************
;// ***       ***************************************************
;// *****************************************************************************
;#include <stdio.h>
;#include <string.h>
;
;// *****************************************************************************
;// ***       ********************************************
;// *****************************************************************************
;#include "Def.h"
;#include "Graphic.h"
;#include "Fonts.h"
;#include "MT12864.h"
;#include "CRC.h"
;#include "Variables.h"
;
;// *****************************************************************************
;// ***       ***********************************************
;// *****************************************************************************
;FontProfile Font_4x6;
;FontProfile Font_6x8;
;FontProfile Font_8x8;
;FontProfile Font_8x12;
;FontProfile Font_12x16;
;
;// *****************************************************************************
;// ***       ***********************************************
;// *****************************************************************************
;inline void gfx_BackLight(unsigned char Cmd)
; 0001 0030 {

	.CSEG
_gfx_BackLight:
; 0001 0031     LCD_BackLight(Cmd);
;	Cmd -> Y+0
	LD   R30,Y
	ST   -Y,R30
	CALL _LCD_BackLight
; 0001 0032     Settings.BacklightFlag = Cmd;
	LD   R30,Y
	__PUTB1MN _Settings,4
; 0001 0033 }
	JMP  _0x2060026
;
;// *****************************************************************************
;// ***           ********************************
;// *****************************************************************************
;inline void gfx_Refresh(void)
; 0001 0039 {
_gfx_Refresh:
; 0001 003A 	LCD_Refresh();
	CALL _LCD_Refresh
; 0001 003B }
	RET
;
;// *****************************************************************************
;// ***         ****************************
;// *****************************************************************************
;void gfx_AutoRefreshTask(void)
; 0001 0041 {
; 0001 0042     //      CRC
; 0001 0043     //  -    
; 0001 0044     static unsigned int OldCRC;
; 0001 0045     //    CRC
; 0001 0046     unsigned int NewCRC;
; 0001 0047 
; 0001 0048     //  CRC  
; 0001 0049     NewCRC = Crc16_ram((unsigned char *)LCD_Buf, sizeof(LCD_Buf));
;	NewCRC -> R16,R17
; 0001 004A 
; 0001 004B     //  CRC 
; 0001 004C     if(NewCRC != OldCRC)
; 0001 004D     {
; 0001 004E         //  
; 0001 004F     	LCD_Refresh();
; 0001 0050         //   CRC
; 0001 0051         OldCRC = NewCRC;
; 0001 0052     }
; 0001 0053 }
;
;// *****************************************************************************
;// ***        ***********************************************
;// *****************************************************************************
;void gfx_ClearBuf(void)
; 0001 0059 {
_gfx_ClearBuf:
; 0001 005A     //   
; 0001 005B     memset(LCD_Buf, 0, sizeof(LCD_Buf));
	LDI  R30,LOW(_LCD_Buf)
	LDI  R31,HIGH(_LCD_Buf)
	ST   -Y,R31
	ST   -Y,R30
	LDI  R30,LOW(0)
	ST   -Y,R30
	LDI  R30,LOW(1024)
	LDI  R31,HIGH(1024)
	ST   -Y,R31
	ST   -Y,R30
	CALL _memset
; 0001 005C }
	RET
;
;// *****************************************************************************
;// ***    .      .   *********
;// ***     -  ...    .    *********
;// ***         ?                             *********
;// ***      -                *********
;// *****************************************************************************
;void gfx_PutPixel(unsigned char x, unsigned char y, unsigned char color)
; 0001 0065 {
_gfx_PutPixel:
; 0001 0066     unsigned char i;
; 0001 0067     unsigned char j;
; 0001 0068 
; 0001 0069 #ifdef DEBUG
; 0001 006A     x &= 0b01111111; // x must be 0 <= x <= 127 Only for this screen !!!
; 0001 006B     y &= 0b00111111; // y must be 0 <= y <=  63 Only for this screen !!!
; 0001 006C #else
; 0001 006D     if(x >=  WidthS) return; //  X    - 
	ST   -Y,R17
	ST   -Y,R16
;	x -> Y+4
;	y -> Y+3
;	color -> Y+2
;	i -> R17
;	j -> R16
	LDD  R26,Y+4
	CPI  R26,LOW(0x80)
	BRLO _0x20004
	LDD  R17,Y+1
	LDD  R16,Y+0
	RJMP _0x2060027
; 0001 006E     if(y >= HeightS) return; //  Y    - 
_0x20004:
	LDD  R26,Y+3
	CPI  R26,LOW(0x40)
	BRLO _0x20005
	LDD  R17,Y+1
	LDD  R16,Y+0
	RJMP _0x2060027
; 0001 006F #endif
; 0001 0070 
; 0001 0071     color &= 0x01;   // Color must have one last bit
_0x20005:
	LDD  R30,Y+2
	ANDI R30,LOW(0x1)
	STD  Y+2,R30
; 0001 0072 
; 0001 0073 #ifdef GFX_REVERSED
; 0001 0074     x = WidthS  - 1 - x; // Reverse X
	LDD  R26,Y+4
	LDI  R30,LOW(127)
	SUB  R30,R26
	STD  Y+4,R30
; 0001 0075     y = HeightS - 1 - y; // Reverse Y
	LDD  R26,Y+3
	LDI  R30,LOW(63)
	SUB  R30,R26
	STD  Y+3,R30
; 0001 0076 #endif
; 0001 0077 
; 0001 0078     i = y >> 3;          // y/8;
	LSR  R30
	LSR  R30
	LSR  R30
	MOV  R17,R30
; 0001 0079     j = y & 0b00000111;  // y%8;
	LDD  R30,Y+3
	ANDI R30,LOW(0x7)
	MOV  R16,R30
; 0001 007A 
; 0001 007B     LCD_Buf[i][x] = (LCD_Buf[i][x] & (~(1 << j))) | (color << j);
	MOV  R30,R17
	LDI  R31,0
	CALL __LSLW3
	CALL __LSLW4
	SUBI R30,LOW(-_LCD_Buf)
	SBCI R31,HIGH(-_LCD_Buf)
	MOVW R26,R30
	LDD  R30,Y+4
	LDI  R31,0
	ADD  R30,R26
	ADC  R31,R27
	MOVW R22,R30
	MOV  R30,R17
	LDI  R31,0
	CALL __LSLW3
	CALL __LSLW4
	SUBI R30,LOW(-_LCD_Buf)
	SBCI R31,HIGH(-_LCD_Buf)
	MOVW R26,R30
	LDD  R30,Y+4
	LDI  R31,0
	ADD  R26,R30
	ADC  R27,R31
	LD   R1,X
	MOV  R30,R16
	LDI  R26,LOW(1)
	CALL __LSLB12
	COM  R30
	AND  R1,R30
	MOV  R30,R16
	LDD  R26,Y+2
	CALL __LSLB12
	OR   R30,R1
	MOVW R26,R22
	ST   X,R30
; 0001 007C }
	LDD  R17,Y+1
	LDD  R16,Y+0
	RJMP _0x2060027
;
;// *****************************************************************************
;// ***       *************************************************
;// *****************************************************************************
;void gfx_InvertPixel(unsigned char x, unsigned char y)
; 0001 0082 {
; 0001 0083     unsigned char i;
; 0001 0084     unsigned char j;
; 0001 0085 
; 0001 0086 #ifdef DEBUG
; 0001 0087     x &= 0b01111111; // x must be 0 <= x <= 127 Only for this screen !!!
; 0001 0088     y &= 0b00111111; // y must be 0 <= y <=  63 Only for this screen !!!
; 0001 0089 #else
; 0001 008A     if(x >=  WidthS) return; //  X    - 
;	x -> Y+3
;	y -> Y+2
;	i -> R17
;	j -> R16
; 0001 008B     if(y >= HeightS) return; //  Y    - 
; 0001 008C #endif
; 0001 008D 
; 0001 008E #ifdef GFX_REVERSED
; 0001 008F     x = WidthS  - 1 - x; // Reverse X
; 0001 0090     y = HeightS - 1 - y; // Reverse Y
; 0001 0091 #endif
; 0001 0092 
; 0001 0093     i = y >> 3;          // y/8;
; 0001 0094     j = y & 0b00000111;  // y%8;
; 0001 0095 
; 0001 0096     LCD_Buf[i][x] = LCD_Buf[i][x] ^ (1 << j);
; 0001 0097 }
;
;// *****************************************************************************
;// ***       *********************************************************
;// *****************************************************************************
;void gfx_Line(int x1, int y1, int x2, int y2, unsigned char color)
; 0001 009D {
_gfx_Line:
; 0001 009E     char stepx, stepy;
; 0001 009F     int dx, dy, fraction;
; 0001 00A0 
; 0001 00A1     //  dx
; 0001 00A2     dx = (signed int)x2 - x1;
	SBIW R28,2
	CALL __SAVELOCR6
;	x1 -> Y+15
;	y1 -> Y+13
;	x2 -> Y+11
;	y2 -> Y+9
;	color -> Y+8
;	stepx -> R17
;	stepy -> R16
;	dx -> R18,R19
;	dy -> R20,R21
;	fraction -> Y+6
	LDD  R26,Y+15
	LDD  R27,Y+15+1
	LDD  R30,Y+11
	LDD  R31,Y+11+1
	SUB  R30,R26
	SBC  R31,R27
	MOVW R18,R30
; 0001 00A3     //  dx
; 0001 00A4     dy = (signed int)y2 - y1;
	LDD  R26,Y+13
	LDD  R27,Y+13+1
	LDD  R30,Y+9
	LDD  R31,Y+9+1
	SUB  R30,R26
	SBC  R31,R27
	MOVW R20,R30
; 0001 00A5 
; 0001 00A6     if(dx < 0)
	TST  R19
	BRPL _0x20008
; 0001 00A7     {
; 0001 00A8          dx    = -dx;
	MOVW R30,R18
	CALL __ANEGW1
	MOVW R18,R30
; 0001 00A9          stepx = -1;
	LDI  R17,LOW(255)
; 0001 00AA     }
; 0001 00AB     else stepx = 1;
	RJMP _0x20009
_0x20008:
	LDI  R17,LOW(1)
; 0001 00AC 
; 0001 00AD     if(dy < 0)
_0x20009:
	TST  R21
	BRPL _0x2000A
; 0001 00AE     {
; 0001 00AF          dy    = -dy;
	MOVW R30,R20
	CALL __ANEGW1
	MOVW R20,R30
; 0001 00B0          stepy = -1;
	LDI  R16,LOW(255)
; 0001 00B1     }
; 0001 00B2     else stepy = 1;
	RJMP _0x2000B
_0x2000A:
	LDI  R16,LOW(1)
; 0001 00B3 
; 0001 00B4     dx <<= 1;
_0x2000B:
	LSL  R18
	ROL  R19
; 0001 00B5     dy <<= 1;
	LSL  R20
	ROL  R21
; 0001 00B6     gfx_PutPixel(x1, y1, color);
	LDD  R30,Y+15
	ST   -Y,R30
	LDD  R30,Y+14
	ST   -Y,R30
	LDD  R30,Y+10
	ST   -Y,R30
	RCALL _gfx_PutPixel
; 0001 00B7     if(dx > dy)
	__CPWRR 20,21,18,19
	BRLT PC+3
	JMP _0x2000C
; 0001 00B8     {
; 0001 00B9         fraction = dy - (dx >> 1);
	MOVW R30,R18
	ASR  R31
	ROR  R30
	MOVW R26,R30
	MOVW R30,R20
	SUB  R30,R26
	SBC  R31,R27
	STD  Y+6,R30
	STD  Y+6+1,R31
; 0001 00BA         while(x1 != x2)
_0x2000D:
	LDD  R30,Y+11
	LDD  R31,Y+11+1
	LDD  R26,Y+15
	LDD  R27,Y+15+1
	CP   R30,R26
	CPC  R31,R27
	BRNE PC+3
	JMP _0x2000F
; 0001 00BB         {
; 0001 00BC             if(fraction >= 0) // ATENTION: Need use >=, but this make error in PROTEUS
	LDD  R26,Y+7
	TST  R26
	BRMI _0x20010
; 0001 00BD             {
; 0001 00BE                 y1 += stepy;
	MOV  R30,R16
	LDD  R26,Y+13
	LDD  R27,Y+13+1
	LDI  R31,0
	SBRC R30,7
	SER  R31
	ADD  R30,R26
	ADC  R31,R27
	STD  Y+13,R30
	STD  Y+13+1,R31
; 0001 00BF                 fraction -= dx;
	LDD  R30,Y+6
	LDD  R31,Y+6+1
	SUB  R30,R18
	SBC  R31,R19
	STD  Y+6,R30
	STD  Y+6+1,R31
; 0001 00C0             }
; 0001 00C1             x1 += stepx;
_0x20010:
	MOV  R30,R17
	LDD  R26,Y+15
	LDD  R27,Y+15+1
	LDI  R31,0
	SBRC R30,7
	SER  R31
	ADD  R30,R26
	ADC  R31,R27
	STD  Y+15,R30
	STD  Y+15+1,R31
; 0001 00C2             fraction += dy;
	MOVW R30,R20
	LDD  R26,Y+6
	LDD  R27,Y+6+1
	ADD  R30,R26
	ADC  R31,R27
	STD  Y+6,R30
	STD  Y+6+1,R31
; 0001 00C3             if((x1 < 0) || (x1 >= WidthS) || (y1 < 0) || (y1 >= HeightS)) continue;
	LDD  R26,Y+16
	TST  R26
	BRMI _0x20012
	LDD  R26,Y+15
	LDD  R27,Y+15+1
	CPI  R26,LOW(0x80)
	LDI  R30,HIGH(0x80)
	CPC  R27,R30
	BRGE _0x20012
	LDD  R26,Y+14
	TST  R26
	BRMI _0x20012
	LDD  R26,Y+13
	LDD  R27,Y+13+1
	CPI  R26,LOW(0x40)
	LDI  R30,HIGH(0x40)
	CPC  R27,R30
	BRLT _0x20011
_0x20012:
	RJMP _0x2000D
; 0001 00C4             gfx_PutPixel(x1, y1, color);
_0x20011:
	LDD  R30,Y+15
	ST   -Y,R30
	LDD  R30,Y+14
	ST   -Y,R30
	LDD  R30,Y+10
	ST   -Y,R30
	RCALL _gfx_PutPixel
; 0001 00C5         }
	RJMP _0x2000D
_0x2000F:
; 0001 00C6     }
; 0001 00C7     else
	RJMP _0x20014
_0x2000C:
; 0001 00C8     {
; 0001 00C9         fraction = dx - (dy >> 1);
	MOVW R30,R20
	ASR  R31
	ROR  R30
	MOVW R26,R30
	MOVW R30,R18
	SUB  R30,R26
	SBC  R31,R27
	STD  Y+6,R30
	STD  Y+6+1,R31
; 0001 00CA         while(y1 != y2)
_0x20015:
	LDD  R30,Y+9
	LDD  R31,Y+9+1
	LDD  R26,Y+13
	LDD  R27,Y+13+1
	CP   R30,R26
	CPC  R31,R27
	BRNE PC+3
	JMP _0x20017
; 0001 00CB         {
; 0001 00CC             if(fraction >= 0) // ATENTION: Need use >=, but this make error in PROTEUS
	LDD  R26,Y+7
	TST  R26
	BRMI _0x20018
; 0001 00CD             {
; 0001 00CE                 x1 += stepx;
	MOV  R30,R17
	LDD  R26,Y+15
	LDD  R27,Y+15+1
	LDI  R31,0
	SBRC R30,7
	SER  R31
	ADD  R30,R26
	ADC  R31,R27
	STD  Y+15,R30
	STD  Y+15+1,R31
; 0001 00CF                 fraction -= dy;
	LDD  R30,Y+6
	LDD  R31,Y+6+1
	SUB  R30,R20
	SBC  R31,R21
	STD  Y+6,R30
	STD  Y+6+1,R31
; 0001 00D0             }
; 0001 00D1             y1 += stepy;
_0x20018:
	MOV  R30,R16
	LDD  R26,Y+13
	LDD  R27,Y+13+1
	LDI  R31,0
	SBRC R30,7
	SER  R31
	ADD  R30,R26
	ADC  R31,R27
	STD  Y+13,R30
	STD  Y+13+1,R31
; 0001 00D2             fraction += dx;
	MOVW R30,R18
	LDD  R26,Y+6
	LDD  R27,Y+6+1
	ADD  R30,R26
	ADC  R31,R27
	STD  Y+6,R30
	STD  Y+6+1,R31
; 0001 00D3             if((x1 < 0) || (x1 >= WidthS) || (y1 < 0) || (y1 >= HeightS)) continue;
	LDD  R26,Y+16
	TST  R26
	BRMI _0x2001A
	LDD  R26,Y+15
	LDD  R27,Y+15+1
	CPI  R26,LOW(0x80)
	LDI  R30,HIGH(0x80)
	CPC  R27,R30
	BRGE _0x2001A
	LDD  R26,Y+14
	TST  R26
	BRMI _0x2001A
	LDD  R26,Y+13
	LDD  R27,Y+13+1
	CPI  R26,LOW(0x40)
	LDI  R30,HIGH(0x40)
	CPC  R27,R30
	BRLT _0x20019
_0x2001A:
	RJMP _0x20015
; 0001 00D4             gfx_PutPixel(x1, y1, color);
_0x20019:
	LDD  R30,Y+15
	ST   -Y,R30
	LDD  R30,Y+14
	ST   -Y,R30
	LDD  R30,Y+10
	ST   -Y,R30
	RCALL _gfx_PutPixel
; 0001 00D5         }
	RJMP _0x20015
_0x20017:
; 0001 00D6     }
_0x20014:
; 0001 00D7 }
	CALL __LOADLOCR6
	ADIW R28,17
	RET
;
;// *****************************************************************************
;// ***         ************************************************
;// *****************************************************************************
;void gfx_DashLine(int x1, int y1, int x2, int y2)
; 0001 00DD {
_gfx_DashLine:
; 0001 00DE     char stepx, stepy, mode;
; 0001 00DF     int dx, dy, fraction;
; 0001 00E0 
; 0001 00E1     dy = (signed int)y2 - y1;
	SBIW R28,4
	CALL __SAVELOCR6
;	x1 -> Y+16
;	y1 -> Y+14
;	x2 -> Y+12
;	y2 -> Y+10
;	stepx -> R17
;	stepy -> R16
;	mode -> R19
;	dx -> R20,R21
;	dy -> Y+8
;	fraction -> Y+6
	LDD  R26,Y+14
	LDD  R27,Y+14+1
	LDD  R30,Y+10
	LDD  R31,Y+10+1
	SUB  R30,R26
	SBC  R31,R27
	STD  Y+8,R30
	STD  Y+8+1,R31
; 0001 00E2     dx = (signed int)x2 - x1;
	LDD  R26,Y+16
	LDD  R27,Y+16+1
	LDD  R30,Y+12
	LDD  R31,Y+12+1
	SUB  R30,R26
	SBC  R31,R27
	MOVW R20,R30
; 0001 00E3     mode = 1;
	LDI  R19,LOW(1)
; 0001 00E4 
; 0001 00E5     if(dy < 0)
	LDD  R26,Y+9
	TST  R26
	BRPL _0x2001C
; 0001 00E6     {
; 0001 00E7         dy    = -dy;
	LDD  R30,Y+8
	LDD  R31,Y+8+1
	CALL __ANEGW1
	STD  Y+8,R30
	STD  Y+8+1,R31
; 0001 00E8         stepy = -1;
	LDI  R16,LOW(255)
; 0001 00E9     }
; 0001 00EA     else stepy = 1;
	RJMP _0x2001D
_0x2001C:
	LDI  R16,LOW(1)
; 0001 00EB 
; 0001 00EC     if(dx < 0)
_0x2001D:
	TST  R21
	BRPL _0x2001E
; 0001 00ED     {
; 0001 00EE         dx    = -dx;
	MOVW R30,R20
	CALL __ANEGW1
	MOVW R20,R30
; 0001 00EF         stepx = -1;
	LDI  R17,LOW(255)
; 0001 00F0     }
; 0001 00F1     else stepx = 1;
	RJMP _0x2001F
_0x2001E:
	LDI  R17,LOW(1)
; 0001 00F2 
; 0001 00F3     dx <<= 1;
_0x2001F:
	LSL  R20
	ROL  R21
; 0001 00F4     dy <<= 1;
	LDD  R30,Y+8
	LDD  R31,Y+8+1
	LSL  R30
	ROL  R31
	STD  Y+8,R30
	STD  Y+8+1,R31
; 0001 00F5     gfx_PutPixel(x1, y1, mode);
	LDD  R30,Y+16
	ST   -Y,R30
	LDD  R30,Y+15
	ST   -Y,R30
	ST   -Y,R19
	RCALL _gfx_PutPixel
; 0001 00F6     if(dx > dy)
	LDD  R30,Y+8
	LDD  R31,Y+8+1
	CP   R30,R20
	CPC  R31,R21
	BRLT PC+3
	JMP _0x20020
; 0001 00F7     {
; 0001 00F8         fraction = dy - (dx >> 1);
	MOVW R30,R20
	ASR  R31
	ROR  R30
	LDD  R26,Y+8
	LDD  R27,Y+8+1
	SUB  R26,R30
	SBC  R27,R31
	STD  Y+6,R26
	STD  Y+6+1,R27
; 0001 00F9         while(x1 != x2)
_0x20021:
	LDD  R30,Y+12
	LDD  R31,Y+12+1
	LDD  R26,Y+16
	LDD  R27,Y+16+1
	CP   R30,R26
	CPC  R31,R27
	BRNE PC+3
	JMP _0x20023
; 0001 00FA         {
; 0001 00FB             if(fraction >= 0)
	LDD  R26,Y+7
	TST  R26
	BRMI _0x20024
; 0001 00FC             {
; 0001 00FD                 y1 += stepy;
	MOV  R30,R16
	LDD  R26,Y+14
	LDD  R27,Y+14+1
	LDI  R31,0
	SBRC R30,7
	SER  R31
	ADD  R30,R26
	ADC  R31,R27
	STD  Y+14,R30
	STD  Y+14+1,R31
; 0001 00FE                 fraction -= dx;
	LDD  R30,Y+6
	LDD  R31,Y+6+1
	SUB  R30,R20
	SBC  R31,R21
	STD  Y+6,R30
	STD  Y+6+1,R31
; 0001 00FF             }
; 0001 0100             x1 += stepx;
_0x20024:
	MOV  R30,R17
	LDD  R26,Y+16
	LDD  R27,Y+16+1
	LDI  R31,0
	SBRC R30,7
	SER  R31
	ADD  R30,R26
	ADC  R31,R27
	STD  Y+16,R30
	STD  Y+16+1,R31
; 0001 0101             fraction += dy;
	LDD  R30,Y+8
	LDD  R31,Y+8+1
	LDD  R26,Y+6
	LDD  R27,Y+6+1
	ADD  R30,R26
	ADC  R31,R27
	STD  Y+6,R30
	STD  Y+6+1,R31
; 0001 0102 
; 0001 0103             if(mode) mode = 0;
	CPI  R19,0
	BREQ _0x20025
	LDI  R19,LOW(0)
; 0001 0104             else     mode = 1;
	RJMP _0x20026
_0x20025:
	LDI  R19,LOW(1)
; 0001 0105 
; 0001 0106             if((x1 < 0) || (x1 >= WidthS) || (y1 < 0) || (y1 >= HeightS)) continue;
_0x20026:
	LDD  R26,Y+17
	TST  R26
	BRMI _0x20028
	LDD  R26,Y+16
	LDD  R27,Y+16+1
	CPI  R26,LOW(0x80)
	LDI  R30,HIGH(0x80)
	CPC  R27,R30
	BRGE _0x20028
	LDD  R26,Y+15
	TST  R26
	BRMI _0x20028
	LDD  R26,Y+14
	LDD  R27,Y+14+1
	CPI  R26,LOW(0x40)
	LDI  R30,HIGH(0x40)
	CPC  R27,R30
	BRLT _0x20027
_0x20028:
	RJMP _0x20021
; 0001 0107             gfx_PutPixel(x1, y1, mode);
_0x20027:
	LDD  R30,Y+16
	ST   -Y,R30
	LDD  R30,Y+15
	ST   -Y,R30
	ST   -Y,R19
	RCALL _gfx_PutPixel
; 0001 0108         }
	RJMP _0x20021
_0x20023:
; 0001 0109     }
; 0001 010A     else
	RJMP _0x2002A
_0x20020:
; 0001 010B     {
; 0001 010C         fraction = dx - (dy >> 1);
	LDD  R30,Y+8
	LDD  R31,Y+8+1
	ASR  R31
	ROR  R30
	MOVW R26,R30
	MOVW R30,R20
	SUB  R30,R26
	SBC  R31,R27
	STD  Y+6,R30
	STD  Y+6+1,R31
; 0001 010D         while(y1 != y2)
_0x2002B:
	LDD  R30,Y+10
	LDD  R31,Y+10+1
	LDD  R26,Y+14
	LDD  R27,Y+14+1
	CP   R30,R26
	CPC  R31,R27
	BRNE PC+3
	JMP _0x2002D
; 0001 010E         {
; 0001 010F             if(fraction >= 0)
	LDD  R26,Y+7
	TST  R26
	BRMI _0x2002E
; 0001 0110             {
; 0001 0111                 x1 += stepx;
	MOV  R30,R17
	LDD  R26,Y+16
	LDD  R27,Y+16+1
	LDI  R31,0
	SBRC R30,7
	SER  R31
	ADD  R30,R26
	ADC  R31,R27
	STD  Y+16,R30
	STD  Y+16+1,R31
; 0001 0112                 fraction -= dy;
	LDD  R26,Y+8
	LDD  R27,Y+8+1
	LDD  R30,Y+6
	LDD  R31,Y+6+1
	SUB  R30,R26
	SBC  R31,R27
	STD  Y+6,R30
	STD  Y+6+1,R31
; 0001 0113             }
; 0001 0114             y1 += stepy;
_0x2002E:
	MOV  R30,R16
	LDD  R26,Y+14
	LDD  R27,Y+14+1
	LDI  R31,0
	SBRC R30,7
	SER  R31
	ADD  R30,R26
	ADC  R31,R27
	STD  Y+14,R30
	STD  Y+14+1,R31
; 0001 0115             fraction += dx;
	MOVW R30,R20
	LDD  R26,Y+6
	LDD  R27,Y+6+1
	ADD  R30,R26
	ADC  R31,R27
	STD  Y+6,R30
	STD  Y+6+1,R31
; 0001 0116 
; 0001 0117             if(mode) mode = 0;
	CPI  R19,0
	BREQ _0x2002F
	LDI  R19,LOW(0)
; 0001 0118             else     mode = 1;
	RJMP _0x20030
_0x2002F:
	LDI  R19,LOW(1)
; 0001 0119 
; 0001 011A             if((x1 < 0) || (x1 >= WidthS) || (y1 < 0) || (y1 >= HeightS)) continue;
_0x20030:
	LDD  R26,Y+17
	TST  R26
	BRMI _0x20032
	LDD  R26,Y+16
	LDD  R27,Y+16+1
	CPI  R26,LOW(0x80)
	LDI  R30,HIGH(0x80)
	CPC  R27,R30
	BRGE _0x20032
	LDD  R26,Y+15
	TST  R26
	BRMI _0x20032
	LDD  R26,Y+14
	LDD  R27,Y+14+1
	CPI  R26,LOW(0x40)
	LDI  R30,HIGH(0x40)
	CPC  R27,R30
	BRLT _0x20031
_0x20032:
	RJMP _0x2002B
; 0001 011B             gfx_PutPixel(x1, y1, mode);
_0x20031:
	LDD  R30,Y+16
	ST   -Y,R30
	LDD  R30,Y+15
	ST   -Y,R30
	ST   -Y,R19
	RCALL _gfx_PutPixel
; 0001 011C         }
	RJMP _0x2002B
_0x2002D:
; 0001 011D     }
_0x2002A:
; 0001 011E }
	CALL __LOADLOCR6
	ADIW R28,18
	RET
;
;// *****************************************************************************
;// ***        ***********************************************
;// *****************************************************************************
;void gfx_Rectangle(int x1, int y1, int x2, int y2, unsigned char color)
; 0001 0124 {
_gfx_Rectangle:
; 0001 0125     gfx_Line(x1, y1, x1, y2, color);
;	x1 -> Y+7
;	y1 -> Y+5
;	x2 -> Y+3
;	y2 -> Y+1
;	color -> Y+0
	LDD  R30,Y+7
	LDD  R31,Y+7+1
	ST   -Y,R31
	ST   -Y,R30
	LDD  R30,Y+7
	LDD  R31,Y+7+1
	ST   -Y,R31
	ST   -Y,R30
	LDD  R30,Y+11
	LDD  R31,Y+11+1
	ST   -Y,R31
	ST   -Y,R30
	LDD  R30,Y+7
	LDD  R31,Y+7+1
	ST   -Y,R31
	ST   -Y,R30
	LDD  R30,Y+8
	ST   -Y,R30
	RCALL _gfx_Line
; 0001 0126     gfx_Line(x1, y2, x2, y2, color);
	LDD  R30,Y+7
	LDD  R31,Y+7+1
	ST   -Y,R31
	ST   -Y,R30
	LDD  R30,Y+3
	LDD  R31,Y+3+1
	ST   -Y,R31
	ST   -Y,R30
	LDD  R30,Y+7
	LDD  R31,Y+7+1
	ST   -Y,R31
	ST   -Y,R30
	LDD  R30,Y+7
	LDD  R31,Y+7+1
	ST   -Y,R31
	ST   -Y,R30
	LDD  R30,Y+8
	ST   -Y,R30
	RCALL _gfx_Line
; 0001 0127     gfx_Line(x2, y1, x2, y2, color);
	LDD  R30,Y+3
	LDD  R31,Y+3+1
	ST   -Y,R31
	ST   -Y,R30
	LDD  R30,Y+7
	LDD  R31,Y+7+1
	ST   -Y,R31
	ST   -Y,R30
	LDD  R30,Y+7
	LDD  R31,Y+7+1
	ST   -Y,R31
	ST   -Y,R30
	LDD  R30,Y+7
	LDD  R31,Y+7+1
	ST   -Y,R31
	ST   -Y,R30
	LDD  R30,Y+8
	ST   -Y,R30
	RCALL _gfx_Line
; 0001 0128     gfx_Line(x1, y1, x2, y1, color);
	LDD  R30,Y+7
	LDD  R31,Y+7+1
	ST   -Y,R31
	ST   -Y,R30
	LDD  R30,Y+7
	LDD  R31,Y+7+1
	ST   -Y,R31
	ST   -Y,R30
	LDD  R30,Y+7
	LDD  R31,Y+7+1
	ST   -Y,R31
	ST   -Y,R30
	LDD  R30,Y+11
	LDD  R31,Y+11+1
	ST   -Y,R31
	ST   -Y,R30
	LDD  R30,Y+8
	ST   -Y,R30
	RCALL _gfx_Line
; 0001 0129 }
	ADIW R28,9
	RET
;
;// *****************************************************************************
;// ***        ***********************************
;// *****************************************************************************
;void gfx_FillRect(int x1, int y1, int x2, int y2, unsigned char color)
; 0001 012F {
_gfx_FillRect:
; 0001 0130     int swap;
; 0001 0131     unsigned char i, j;
; 0001 0132 
; 0001 0133     if(x1 > x2)
	CALL __SAVELOCR4
;	x1 -> Y+11
;	y1 -> Y+9
;	x2 -> Y+7
;	y2 -> Y+5
;	color -> Y+4
;	swap -> R16,R17
;	i -> R19
;	j -> R18
	LDD  R30,Y+7
	LDD  R31,Y+7+1
	LDD  R26,Y+11
	LDD  R27,Y+11+1
	CP   R30,R26
	CPC  R31,R27
	BRGE _0x20034
; 0001 0134     {
; 0001 0135         swap = x1;
	__GETWRS 16,17,11
; 0001 0136         x1 = x2;
	STD  Y+11,R30
	STD  Y+11+1,R31
; 0001 0137         x2 = swap;
	__PUTWSR 16,17,7
; 0001 0138     }
; 0001 0139 
; 0001 013A     if(y1 > y2)
_0x20034:
	LDD  R30,Y+5
	LDD  R31,Y+5+1
	LDD  R26,Y+9
	LDD  R27,Y+9+1
	CP   R30,R26
	CPC  R31,R27
	BRGE _0x20035
; 0001 013B     {
; 0001 013C         swap = y1;
	__GETWRS 16,17,9
; 0001 013D         y1 = y2;
	STD  Y+9,R30
	STD  Y+9+1,R31
; 0001 013E         y2 = swap;
	__PUTWSR 16,17,5
; 0001 013F     }
; 0001 0140 
; 0001 0141     if(x1 < 0) x1 = 0;
_0x20035:
	LDD  R26,Y+12
	TST  R26
	BRPL _0x20036
	LDI  R30,LOW(0)
	STD  Y+11,R30
	STD  Y+11+1,R30
; 0001 0142     if(y1 < 0) y1 = 0;
_0x20036:
	LDD  R26,Y+10
	TST  R26
	BRPL _0x20037
	LDI  R30,LOW(0)
	STD  Y+9,R30
	STD  Y+9+1,R30
; 0001 0143     if(x2 >  WidthS - 1) x2 = WidthS  - 1;
_0x20037:
	LDD  R26,Y+7
	LDD  R27,Y+7+1
	CPI  R26,LOW(0x80)
	LDI  R30,HIGH(0x80)
	CPC  R27,R30
	BRLT _0x20038
	LDI  R30,LOW(127)
	LDI  R31,HIGH(127)
	STD  Y+7,R30
	STD  Y+7+1,R31
; 0001 0144     if(y2 > HeightS - 1) y2 = HeightS - 1;
_0x20038:
	LDD  R26,Y+5
	LDD  R27,Y+5+1
	CPI  R26,LOW(0x40)
	LDI  R30,HIGH(0x40)
	CPC  R27,R30
	BRLT _0x20039
	LDI  R30,LOW(63)
	LDI  R31,HIGH(63)
	STD  Y+5,R30
	STD  Y+5+1,R31
; 0001 0145 
; 0001 0146     for(i = x1; i <= x2; i++)
_0x20039:
	LDD  R19,Y+11
_0x2003B:
	LDD  R30,Y+7
	LDD  R31,Y+7+1
	MOV  R26,R19
	LDI  R27,0
	CP   R30,R26
	CPC  R31,R27
	BRLT _0x2003C
; 0001 0147         for(j = y1; j <= y2; j++) gfx_PutPixel(i, j, color);
	LDD  R18,Y+9
_0x2003E:
	LDD  R30,Y+5
	LDD  R31,Y+5+1
	MOV  R26,R18
	LDI  R27,0
	CP   R30,R26
	CPC  R31,R27
	BRLT _0x2003F
	ST   -Y,R19
	ST   -Y,R18
	LDD  R30,Y+6
	ST   -Y,R30
	RCALL _gfx_PutPixel
	SUBI R18,-1
	RJMP _0x2003E
_0x2003F:
; 0001 0148 }
	SUBI R19,-1
	RJMP _0x2003B
_0x2003C:
	CALL __LOADLOCR4
	ADIW R28,13
	RET
;
;// *****************************************************************************
;// ***        ********************************
;// *****************************************************************************
;void gfx_InvertRect(int x1, int y1, int x2, int y2)
; 0001 014E {
; 0001 014F     unsigned char i, j, swap;
; 0001 0150 
; 0001 0151     if(x1 > x2)
;	x1 -> Y+10
;	y1 -> Y+8
;	x2 -> Y+6
;	y2 -> Y+4
;	i -> R17
;	j -> R16
;	swap -> R19
; 0001 0152     {
; 0001 0153         swap = x1;
; 0001 0154         x1 = x2;
; 0001 0155         x2 = swap;
; 0001 0156     }
; 0001 0157 
; 0001 0158     if(y1 > y2)
; 0001 0159     {
; 0001 015A         swap = y1;
; 0001 015B         y1 = y2;
; 0001 015C         y2 = swap;
; 0001 015D     }
; 0001 015E 
; 0001 015F     for(i = x1; i <= x2; i++)
; 0001 0160         for(j = y1; j <= y2; j++) gfx_InvertPixel(i, j);
; 0001 0161 }
;
;// *****************************************************************************
;// ***        *****************************************
;// *****************************************************************************
;void gfx_SetXY(unsigned char x, unsigned char y)
; 0001 0167 {
_gfx_SetXY:
; 0001 0168     //    X
; 0001 0169     LCD_Pos_X = x;
;	x -> Y+1
;	y -> Y+0
	LDD  R30,Y+1
	STS  _LCD_Pos_X,R30
; 0001 016A     //    Y
; 0001 016B     LCD_Pos_Y = y;
	LD   R30,Y
	STS  _LCD_Pos_Y,R30
; 0001 016C }
	RJMP _0x2060028
;
;// *****************************************************************************
;// ***        ******************************************
;// *****************************************************************************
;void gfx_ChangeXY(char dX, char dY)
; 0001 0172 {
_gfx_ChangeXY:
; 0001 0173     //    X
; 0001 0174     LCD_Pos_X += dX;
;	dX -> Y+1
;	dY -> Y+0
	LDD  R30,Y+1
	LDS  R26,_LCD_Pos_X
	ADD  R30,R26
	STS  _LCD_Pos_X,R30
; 0001 0175     //    Y
; 0001 0176     LCD_Pos_Y += dY;
	LD   R30,Y
	LDS  R26,_LCD_Pos_Y
	ADD  R30,R26
	STS  _LCD_Pos_Y,R30
; 0001 0177 }
	RJMP _0x2060028
;
;// *****************************************************************************
;// ***     4x6   ***************************************************
;// *****************************************************************************
;void gfx_Char_4x6(unsigned char c, unsigned char color)
; 0001 017D {
_gfx_Char_4x6:
; 0001 017E     char i, j;
; 0001 017F     unsigned char b;
; 0001 0180 
; 0001 0181     // c = address of character in the font array
; 0001 0182     for(i=0; i < 4; i++)
	CALL __SAVELOCR4
;	c -> Y+5
;	color -> Y+4
;	i -> R17
;	j -> R16
;	b -> R19
	LDI  R17,LOW(0)
_0x20049:
	CPI  R17,4
	BRGE _0x2004A
; 0001 0183     {
; 0001 0184         b = font4x6[c][i];
	LDD  R30,Y+5
	LDI  R26,LOW(_font4x6*2)
	LDI  R27,HIGH(_font4x6*2)
	LDI  R31,0
	CALL __LSLW2
	ADD  R26,R30
	ADC  R27,R31
	MOV  R30,R17
	LDI  R31,0
	ADD  R30,R26
	ADC  R31,R27
	LPM  R19,Z
; 0001 0185         for(j=0; j < 6; j++)
	LDI  R16,LOW(0)
_0x2004C:
	CPI  R16,6
	BRGE _0x2004D
; 0001 0186         {
; 0001 0187             gfx_PutPixel(LCD_Pos_X, LCD_Pos_Y+j, (~(b ^ color)) & 1);
	LDS  R30,_LCD_Pos_X
	ST   -Y,R30
	MOV  R30,R16
	LDS  R26,_LCD_Pos_Y
	ADD  R30,R26
	ST   -Y,R30
	LDD  R30,Y+6
	EOR  R30,R19
	COM  R30
	ANDI R30,LOW(0x1)
	ST   -Y,R30
	RCALL _gfx_PutPixel
; 0001 0188             b >>= 1;
	LSR  R19
; 0001 0189         }
	SUBI R16,-1
	RJMP _0x2004C
_0x2004D:
; 0001 018A         LCD_Pos_X++;
	LDS  R30,_LCD_Pos_X
	SUBI R30,-LOW(1)
	STS  _LCD_Pos_X,R30
; 0001 018B     }
	SUBI R17,-1
	RJMP _0x20049
_0x2004A:
; 0001 018C }
	RJMP _0x2060029
;
;// *****************************************************************************
;// ***     6x8   ***************************************************
;// *****************************************************************************
;void gfx_Char_6x8(unsigned char c, unsigned char color)
; 0001 0192 {
_gfx_Char_6x8:
; 0001 0193     char i, j;
; 0001 0194     unsigned char b;
; 0001 0195 
; 0001 0196     // c = address of character in the font array
; 0001 0197     for(i=0; i < 6; i++)
	CALL __SAVELOCR4
;	c -> Y+5
;	color -> Y+4
;	i -> R17
;	j -> R16
;	b -> R19
	LDI  R17,LOW(0)
_0x2004F:
	CPI  R17,6
	BRGE _0x20050
; 0001 0198     {
; 0001 0199         b = font6x8[c][i];
	LDD  R30,Y+5
	LDI  R31,0
	CALL __LSLW3
	SUBI R30,LOW(-_font6x8*2)
	SBCI R31,HIGH(-_font6x8*2)
	MOVW R26,R30
	MOV  R30,R17
	LDI  R31,0
	ADD  R30,R26
	ADC  R31,R27
	LPM  R19,Z
; 0001 019A         for(j=0; j < 8; j++)
	LDI  R16,LOW(0)
_0x20052:
	CPI  R16,8
	BRGE _0x20053
; 0001 019B         {
; 0001 019C             gfx_PutPixel(LCD_Pos_X, LCD_Pos_Y+j, (~(b ^ color)) & 1);
	LDS  R30,_LCD_Pos_X
	ST   -Y,R30
	MOV  R30,R16
	LDS  R26,_LCD_Pos_Y
	ADD  R30,R26
	ST   -Y,R30
	LDD  R30,Y+6
	EOR  R30,R19
	COM  R30
	ANDI R30,LOW(0x1)
	ST   -Y,R30
	RCALL _gfx_PutPixel
; 0001 019D             b >>= 1;
	LSR  R19
; 0001 019E         }
	SUBI R16,-1
	RJMP _0x20052
_0x20053:
; 0001 019F         LCD_Pos_X++;
	LDS  R30,_LCD_Pos_X
	SUBI R30,-LOW(1)
	STS  _LCD_Pos_X,R30
; 0001 01A0     }
	SUBI R17,-1
	RJMP _0x2004F
_0x20050:
; 0001 01A1 }
	RJMP _0x2060029
;
;// *****************************************************************************
;// ***     8x8   ***************************************************
;// *****************************************************************************
;void gfx_Char_8x8(unsigned char c, unsigned char color)
; 0001 01A7 {
_gfx_Char_8x8:
; 0001 01A8     char i, j;
; 0001 01A9     unsigned char b;
; 0001 01AA 
; 0001 01AB     // c = address of character in the font array
; 0001 01AC     for(i=0; i < 8; i++)
	CALL __SAVELOCR4
;	c -> Y+5
;	color -> Y+4
;	i -> R17
;	j -> R16
;	b -> R19
	LDI  R17,LOW(0)
_0x20055:
	CPI  R17,8
	BRGE _0x20056
; 0001 01AD     {
; 0001 01AE         b = font8x8[c][i];
	LDD  R30,Y+5
	LDI  R31,0
	CALL __LSLW3
	SUBI R30,LOW(-_font8x8*2)
	SBCI R31,HIGH(-_font8x8*2)
	MOVW R26,R30
	MOV  R30,R17
	LDI  R31,0
	ADD  R30,R26
	ADC  R31,R27
	LPM  R19,Z
; 0001 01AF         for(j=0; j < 8; j++)
	LDI  R16,LOW(0)
_0x20058:
	CPI  R16,8
	BRGE _0x20059
; 0001 01B0         {
; 0001 01B1             gfx_PutPixel(LCD_Pos_X, LCD_Pos_Y+j, (~(b ^ color)) & 1);
	LDS  R30,_LCD_Pos_X
	ST   -Y,R30
	MOV  R30,R16
	LDS  R26,_LCD_Pos_Y
	ADD  R30,R26
	ST   -Y,R30
	LDD  R30,Y+6
	EOR  R30,R19
	COM  R30
	ANDI R30,LOW(0x1)
	ST   -Y,R30
	RCALL _gfx_PutPixel
; 0001 01B2             b >>= 1;
	LSR  R19
; 0001 01B3         }
	SUBI R16,-1
	RJMP _0x20058
_0x20059:
; 0001 01B4         LCD_Pos_X++;
	LDS  R30,_LCD_Pos_X
	SUBI R30,-LOW(1)
	STS  _LCD_Pos_X,R30
; 0001 01B5     }
	SUBI R17,-1
	RJMP _0x20055
_0x20056:
; 0001 01B6 }
	RJMP _0x2060029
;
;// *****************************************************************************
;// ***     8x12   **************************************************
;// *****************************************************************************
;void gfx_Char_8x12(unsigned char c, unsigned char color)
; 0001 01BC {
_gfx_Char_8x12:
; 0001 01BD     char i, j;
; 0001 01BE     unsigned char b;
; 0001 01BF 
; 0001 01C0     // c = address of character in the font array
; 0001 01C1     for(i=0; i < 16; i++)
	CALL __SAVELOCR4
;	c -> Y+5
;	color -> Y+4
;	i -> R17
;	j -> R16
;	b -> R19
	LDI  R17,LOW(0)
_0x2005B:
	CPI  R17,16
	BRLT PC+3
	JMP _0x2005C
; 0001 01C2     {
; 0001 01C3         b = font8x12[c][i];
	LDD  R30,Y+5
	LDI  R31,0
	CALL __LSLW4
	SUBI R30,LOW(-_font8x12*2)
	SBCI R31,HIGH(-_font8x12*2)
	MOVW R26,R30
	MOV  R30,R17
	LDI  R31,0
	ADD  R30,R26
	ADC  R31,R27
	LPM  R19,Z
; 0001 01C4         for(j=0; j < 8; j++)
	LDI  R16,LOW(0)
_0x2005E:
	CPI  R16,8
	BRGE _0x2005F
; 0001 01C5         {
; 0001 01C6             gfx_PutPixel(LCD_Pos_X, LCD_Pos_Y+j, (~(b ^ color)) & 1);
	LDS  R30,_LCD_Pos_X
	ST   -Y,R30
	MOV  R30,R16
	LDS  R26,_LCD_Pos_Y
	ADD  R30,R26
	ST   -Y,R30
	LDD  R30,Y+6
	EOR  R30,R19
	COM  R30
	ANDI R30,LOW(0x1)
	ST   -Y,R30
	RCALL _gfx_PutPixel
; 0001 01C7             b >>= 1;
	LSR  R19
; 0001 01C8         }
	SUBI R16,-1
	RJMP _0x2005E
_0x2005F:
; 0001 01C9         i++;
	SUBI R17,-1
; 0001 01CA         b = font8x12[c][i];
	LDD  R30,Y+5
	LDI  R31,0
	CALL __LSLW4
	SUBI R30,LOW(-_font8x12*2)
	SBCI R31,HIGH(-_font8x12*2)
	MOVW R26,R30
	MOV  R30,R17
	LDI  R31,0
	ADD  R30,R26
	ADC  R31,R27
	LPM  R19,Z
; 0001 01CB         for(j=8; j < 12; j++)
	LDI  R16,LOW(8)
_0x20061:
	CPI  R16,12
	BRGE _0x20062
; 0001 01CC         {
; 0001 01CD             gfx_PutPixel(LCD_Pos_X, LCD_Pos_Y+j, (~(b ^ color)) & 1);
	LDS  R30,_LCD_Pos_X
	ST   -Y,R30
	MOV  R30,R16
	LDS  R26,_LCD_Pos_Y
	ADD  R30,R26
	ST   -Y,R30
	LDD  R30,Y+6
	EOR  R30,R19
	COM  R30
	ANDI R30,LOW(0x1)
	ST   -Y,R30
	RCALL _gfx_PutPixel
; 0001 01CE             b >>= 1;
	LSR  R19
; 0001 01CF         }
	SUBI R16,-1
	RJMP _0x20061
_0x20062:
; 0001 01D0         LCD_Pos_X++;
	LDS  R30,_LCD_Pos_X
	SUBI R30,-LOW(1)
	STS  _LCD_Pos_X,R30
; 0001 01D1     }
	SUBI R17,-1
	RJMP _0x2005B
_0x2005C:
; 0001 01D2 }
	RJMP _0x2060029
;
;// *****************************************************************************
;// ***       *******************************************************
;// *****************************************************************************
;void gfx_Char_12x16(unsigned char c, unsigned char color)
; 0001 01D8 {
_gfx_Char_12x16:
; 0001 01D9     char i, j;
; 0001 01DA     unsigned char b;
; 0001 01DB 
; 0001 01DC     // c = address of character in the font array
; 0001 01DD     for(i=0; i < 24; i++)
	CALL __SAVELOCR4
;	c -> Y+5
;	color -> Y+4
;	i -> R17
;	j -> R16
;	b -> R19
	LDI  R17,LOW(0)
_0x20064:
	CPI  R17,24
	BRLT PC+3
	JMP _0x20065
; 0001 01DE     {
; 0001 01DF         b = font12x16[c][i];
	LDD  R30,Y+5
	LDI  R26,LOW(24)
	MUL  R30,R26
	MOVW R30,R0
	SUBI R30,LOW(-_font12x16*2)
	SBCI R31,HIGH(-_font12x16*2)
	MOVW R26,R30
	MOV  R30,R17
	LDI  R31,0
	ADD  R30,R26
	ADC  R31,R27
	LPM  R19,Z
; 0001 01E0         for(j=0; j < 8; j++)
	LDI  R16,LOW(0)
_0x20067:
	CPI  R16,8
	BRGE _0x20068
; 0001 01E1         {
; 0001 01E2             gfx_PutPixel(LCD_Pos_X, LCD_Pos_Y+j, (~(b ^ color)) & 1);
	LDS  R30,_LCD_Pos_X
	ST   -Y,R30
	MOV  R30,R16
	LDS  R26,_LCD_Pos_Y
	ADD  R30,R26
	ST   -Y,R30
	LDD  R30,Y+6
	EOR  R30,R19
	COM  R30
	ANDI R30,LOW(0x1)
	ST   -Y,R30
	RCALL _gfx_PutPixel
; 0001 01E3             b >>= 1;
	LSR  R19
; 0001 01E4         }
	SUBI R16,-1
	RJMP _0x20067
_0x20068:
; 0001 01E5         i++;
	SUBI R17,-1
; 0001 01E6         b = font12x16[c][i];
	LDD  R30,Y+5
	LDI  R26,LOW(24)
	MUL  R30,R26
	MOVW R30,R0
	SUBI R30,LOW(-_font12x16*2)
	SBCI R31,HIGH(-_font12x16*2)
	MOVW R26,R30
	MOV  R30,R17
	LDI  R31,0
	ADD  R30,R26
	ADC  R31,R27
	LPM  R19,Z
; 0001 01E7         for(j=8; j < 16; j++)
	LDI  R16,LOW(8)
_0x2006A:
	CPI  R16,16
	BRGE _0x2006B
; 0001 01E8         {
; 0001 01E9             gfx_PutPixel(LCD_Pos_X, LCD_Pos_Y+j, (~(b ^ color)) & 1);
	LDS  R30,_LCD_Pos_X
	ST   -Y,R30
	MOV  R30,R16
	LDS  R26,_LCD_Pos_Y
	ADD  R30,R26
	ST   -Y,R30
	LDD  R30,Y+6
	EOR  R30,R19
	COM  R30
	ANDI R30,LOW(0x1)
	ST   -Y,R30
	RCALL _gfx_PutPixel
; 0001 01EA             b >>= 1;
	LSR  R19
; 0001 01EB         }
	SUBI R16,-1
	RJMP _0x2006A
_0x2006B:
; 0001 01EC         LCD_Pos_X++;
	LDS  R30,_LCD_Pos_X
	SUBI R30,-LOW(1)
	STS  _LCD_Pos_X,R30
; 0001 01ED     }
	SUBI R17,-1
	RJMP _0x20064
_0x20065:
; 0001 01EE }
_0x2060029:
	CALL __LOADLOCR4
	ADIW R28,6
	RET
;
;// *****************************************************************************
;// ***       *******************************************************
;// *****************************************************************************
;void gfx_Char(unsigned char c, unsigned char color, FontProfile * font)
; 0001 01F4 {
_gfx_Char:
; 0001 01F5     char i, j;
; 0001 01F6     unsigned char b, h, w;
; 0001 01F7 
; 0001 01F8     // c = address of character in the font array
; 0001 01F9     w = 0;
	CALL __SAVELOCR6
;	c -> Y+9
;	color -> Y+8
;	*font -> Y+6
;	i -> R17
;	j -> R16
;	b -> R19
;	h -> R18
;	w -> R21
	LDI  R21,LOW(0)
; 0001 01FA     for(i=0; i < font->BytesPerChar;)
	LDI  R17,LOW(0)
_0x2006D:
	LDD  R26,Y+6
	LDD  R27,Y+6+1
	ADIW R26,4
	LD   R30,X
	MOV  R26,R17
	LDI  R27,0
	SBRC R26,7
	SER  R27
	LDI  R31,0
	CP   R26,R30
	CPC  R27,R31
	BRLT PC+3
	JMP _0x2006E
; 0001 01FB     {
; 0001 01FC         h = 0;
	LDI  R18,LOW(0)
; 0001 01FD         while(h < font->H)
_0x2006F:
	LDD  R26,Y+6
	LDD  R27,Y+6+1
	ADIW R26,1
	LD   R30,X
	CP   R18,R30
	BRSH _0x20071
; 0001 01FE         {
; 0001 01FF             b = font->FontData[(int)c * font->BytesPerChar + i];
	LDD  R30,Y+6
	LDD  R31,Y+6+1
	__GETWRZ 22,23,2
	LDD  R0,Y+9
	CLR  R1
	LDD  R26,Y+6
	LDD  R27,Y+6+1
	ADIW R26,4
	LD   R30,X
	MOVW R26,R0
	LDI  R31,0
	CALL __MULW12
	MOVW R26,R30
	MOV  R30,R17
	LDI  R31,0
	SBRC R30,7
	SER  R31
	ADD  R30,R26
	ADC  R31,R27
	ADD  R30,R22
	ADC  R31,R23
	LPM  R19,Z
; 0001 0200             for(j=0; j < 8; j++)
	LDI  R16,LOW(0)
_0x20073:
	CPI  R16,8
	BRGE _0x20074
; 0001 0201             {
; 0001 0202                 gfx_PutPixel(LCD_Pos_X, LCD_Pos_Y + h, (~(b ^ color)) & 1);
	LDS  R30,_LCD_Pos_X
	ST   -Y,R30
	MOV  R30,R18
	LDS  R26,_LCD_Pos_Y
	ADD  R30,R26
	ST   -Y,R30
	LDD  R30,Y+10
	EOR  R30,R19
	COM  R30
	ANDI R30,LOW(0x1)
	ST   -Y,R30
	RCALL _gfx_PutPixel
; 0001 0203                 b >>= 1;
	LSR  R19
; 0001 0204                 h++;
	SUBI R18,-1
; 0001 0205                 if(h == font->H) break;
	LDD  R26,Y+6
	LDD  R27,Y+6+1
	ADIW R26,1
	LD   R30,X
	CP   R30,R18
	BREQ _0x20074
; 0001 0206             }
	SUBI R16,-1
	RJMP _0x20073
_0x20074:
; 0001 0207             i++;
	SUBI R17,-1
; 0001 0208         }
	RJMP _0x2006F
_0x20071:
; 0001 0209         LCD_Pos_X++;
	LDS  R30,_LCD_Pos_X
	SUBI R30,-LOW(1)
	STS  _LCD_Pos_X,R30
; 0001 020A         w++;
	SUBI R21,-1
; 0001 020B         if(w == font->W) break;
	LDD  R26,Y+6
	LDD  R27,Y+6+1
	LD   R30,X
	CP   R30,R21
	BREQ _0x2006E
; 0001 020C     }
	RJMP _0x2006D
_0x2006E:
; 0001 020D }
	CALL __LOADLOCR6
	ADIW R28,10
	RET
;
;// *****************************************************************************
;// ***       *******************************************************
;// *****************************************************************************
;// ***   .     gfx_Char()   ***********
;// *****************************************************************************
;void gfx_Deg_12x16(unsigned char c, unsigned char color)
; 0001 0215 {
_gfx_Deg_12x16:
; 0001 0216     gfx_Char(c+0x30, color, &Font_12x16);
;	c -> Y+1
;	color -> Y+0
	LDD  R30,Y+1
	SUBI R30,-LOW(48)
	ST   -Y,R30
	LDD  R30,Y+1
	ST   -Y,R30
	LDI  R30,LOW(_Font_12x16)
	LDI  R31,HIGH(_Font_12x16)
	ST   -Y,R31
	ST   -Y,R30
	RCALL _gfx_Char
; 0001 0217 }
_0x2060028:
	ADIW R28,2
	RET
;
;// *****************************************************************************
;// ***          ***************************************
;// *****************************************************************************
;void gfx_Pict(unsigned char flash * p_arr, unsigned char W, unsigned char H, unsigned char X, unsigned char Y, unsigned char color)
; 0001 021D {
; 0001 021E     unsigned int i, j, k;
; 0001 021F 
; 0001 0220     for(i=0; i < H; i++)
;	*p_arr -> Y+11
;	W -> Y+10
;	H -> Y+9
;	X -> Y+8
;	Y -> Y+7
;	color -> Y+6
;	i -> R16,R17
;	j -> R18,R19
;	k -> R20,R21
; 0001 0221         for(j=0; j < W; j++)
; 0001 0222             for(k=0; k < 8; k++) gfx_PutPixel(X + j, Y + i*8 + k, ~((p_arr[j + i*W] >> k) ^ color) & 1);
; 0001 0223 }
;
;// *****************************************************************************
;// ***            *************
;// *****************************************************************************
;void gfx_PutStr(unsigned char * str, unsigned char color, FontProfile * font)
; 0001 0229 {
_gfx_PutStr:
; 0001 022A     while(*str !='\0') gfx_Char(*str++, color, font); //font->PutChar(*str++, color);
;	*str -> Y+3
;	color -> Y+2
;	*font -> Y+0
_0x20080:
	LDD  R26,Y+3
	LDD  R27,Y+3+1
	LD   R30,X
	CPI  R30,0
	BREQ _0x20082
	LD   R30,X+
	STD  Y+3,R26
	STD  Y+3+1,R27
	ST   -Y,R30
	LDD  R30,Y+3
	ST   -Y,R30
	LDD  R30,Y+2
	LDD  R31,Y+2+1
	ST   -Y,R31
	ST   -Y,R30
	RCALL _gfx_Char
	RJMP _0x20080
_0x20082:
; 0001 022B }
	RJMP _0x2060027
;
;// *****************************************************************************
;// ***            ********************
;// *****************************************************************************
;void gfx_PutFlashStr(unsigned char flash * str, unsigned char color, FontProfile * font)
; 0001 0231 {
_gfx_PutFlashStr:
; 0001 0232     while(*str !='\0') gfx_Char(*str++, color, font); //font->PutChar(*str++, color);
;	*str -> Y+3
;	color -> Y+2
;	*font -> Y+0
_0x20083:
	LDD  R30,Y+3
	LDD  R31,Y+3+1
	LPM  R30,Z
	CPI  R30,0
	BREQ _0x20085
	LDD  R30,Y+3
	LDD  R31,Y+3+1
	ADIW R30,1
	STD  Y+3,R30
	STD  Y+3+1,R31
	SBIW R30,1
	LPM  R30,Z
	ST   -Y,R30
	LDD  R30,Y+3
	ST   -Y,R30
	LDD  R30,Y+2
	LDD  R31,Y+2+1
	ST   -Y,R31
	ST   -Y,R30
	RCALL _gfx_Char
	RJMP _0x20083
_0x20085:
; 0001 0233 }
_0x2060027:
	ADIW R28,5
	RET
;
;// *****************************************************************************
;// ***         *************************************
;// *****************************************************************************
;void gfx_Init(void)
; 0001 0239 {
_gfx_Init:
; 0001 023A     //   
; 0001 023B     LCD_Init();
	RCALL _LCD_Init
; 0001 023C 
; 0001 023D     //    4x6
; 0001 023E     Font_4x6.W = 4;
	LDI  R30,LOW(4)
	STS  _Font_4x6,R30
; 0001 023F     Font_4x6.H = 6;
	LDI  R30,LOW(6)
	__PUTB1MN _Font_4x6,1
; 0001 0240     Font_4x6.FontData = (flash unsigned char *)font4x6;
	LDI  R30,LOW(_font4x6*2)
	LDI  R31,HIGH(_font4x6*2)
	__PUTW1MN _Font_4x6,2
; 0001 0241     Font_4x6.BytesPerChar = 4;
	LDI  R30,LOW(4)
	__PUTB1MN _Font_4x6,4
; 0001 0242     Font_4x6.PutChar = &gfx_Char_4x6;
	LDI  R30,LOW(_gfx_Char_4x6)
	LDI  R31,HIGH(_gfx_Char_4x6)
	__PUTW1MN _Font_4x6,5
; 0001 0243 
; 0001 0244     //    6x8
; 0001 0245     Font_6x8.W = 6;
	LDI  R30,LOW(6)
	STS  _Font_6x8,R30
; 0001 0246     Font_6x8.H = 8;
	LDI  R30,LOW(8)
	__PUTB1MN _Font_6x8,1
; 0001 0247     Font_6x8.FontData = (flash unsigned char *)font6x8;
	LDI  R30,LOW(_font6x8*2)
	LDI  R31,HIGH(_font6x8*2)
	__PUTW1MN _Font_6x8,2
; 0001 0248     Font_6x8.BytesPerChar = 8;
	LDI  R30,LOW(8)
	__PUTB1MN _Font_6x8,4
; 0001 0249     Font_6x8.PutChar = &gfx_Char_6x8;
	LDI  R30,LOW(_gfx_Char_6x8)
	LDI  R31,HIGH(_gfx_Char_6x8)
	__PUTW1MN _Font_6x8,5
; 0001 024A 
; 0001 024B     //    8x8
; 0001 024C     Font_8x8.W = 8;
	LDI  R30,LOW(8)
	STS  _Font_8x8,R30
; 0001 024D     Font_8x8.H = 8;
	__PUTB1MN _Font_8x8,1
; 0001 024E     Font_8x8.FontData = (flash unsigned char *)font8x8;
	LDI  R30,LOW(_font8x8*2)
	LDI  R31,HIGH(_font8x8*2)
	__PUTW1MN _Font_8x8,2
; 0001 024F     Font_8x8.BytesPerChar = 8;
	LDI  R30,LOW(8)
	__PUTB1MN _Font_8x8,4
; 0001 0250     Font_8x8.PutChar = &gfx_Char_8x8;
	LDI  R30,LOW(_gfx_Char_8x8)
	LDI  R31,HIGH(_gfx_Char_8x8)
	__PUTW1MN _Font_8x8,5
; 0001 0251 
; 0001 0252     //    8x12
; 0001 0253     Font_8x12.W = 8;
	LDI  R30,LOW(8)
	STS  _Font_8x12,R30
; 0001 0254     Font_8x12.H = 12;
	LDI  R30,LOW(12)
	__PUTB1MN _Font_8x12,1
; 0001 0255     Font_8x12.FontData = (flash unsigned char *)font8x12;
	LDI  R30,LOW(_font8x12*2)
	LDI  R31,HIGH(_font8x12*2)
	__PUTW1MN _Font_8x12,2
; 0001 0256     Font_8x12.BytesPerChar = 16;
	LDI  R30,LOW(16)
	__PUTB1MN _Font_8x12,4
; 0001 0257     Font_8x12.PutChar = &gfx_Char_8x12;
	LDI  R30,LOW(_gfx_Char_8x12)
	LDI  R31,HIGH(_gfx_Char_8x12)
	__PUTW1MN _Font_8x12,5
; 0001 0258 
; 0001 0259     //    12x16
; 0001 025A     Font_12x16.W = 12;
	LDI  R30,LOW(12)
	STS  _Font_12x16,R30
; 0001 025B     Font_12x16.H = 16;
	LDI  R30,LOW(16)
	__PUTB1MN _Font_12x16,1
; 0001 025C     Font_12x16.FontData = (flash unsigned char *)font12x16;
	LDI  R30,LOW(_font12x16*2)
	LDI  R31,HIGH(_font12x16*2)
	__PUTW1MN _Font_12x16,2
; 0001 025D     Font_12x16.BytesPerChar = 24;
	LDI  R30,LOW(24)
	__PUTB1MN _Font_12x16,4
; 0001 025E     Font_12x16.PutChar = &gfx_Char_12x16;
	LDI  R30,LOW(_gfx_Char_12x16)
	LDI  R31,HIGH(_gfx_Char_12x16)
	__PUTW1MN _Font_12x16,5
; 0001 025F }
	RET
;/*******************************************************************************
;*  Fonts.c
;*
;*  : 
;*
;*       Copyright (c) 2007-2008 Nick Shl, focus
;*           All rights reserved.
;*
;*
;*  :
;*
;*  Apr 20, 2009  Nick_Shl  
;*  Apr 10, 2008  Nick_Shl  , 
;*  *** **, ****  focus      
;*
;*/// ***************************************************************************
;flash unsigned char font4x6[256][4] = {
;    {0x00, 0x00, 0x00, 0x00}, //0x00 - '
;    {0x00, 0x0E, 0x15, 0x0E}, //0x01 - ''
;    {0x00, 0x0E, 0x1B, 0x0E}, //0x02 - ''
;    {0x00, 0x0E, 0x1C, 0x0E}, //0x03 - ''
;    {0x00, 0x0C, 0x1E, 0x0C}, //0x04 - ''
;    {0x00, 0x16, 0x1F, 0x16}, //0x05 - ''
;    {0x00, 0x14, 0x1F, 0x14}, //0x06 - ''
;    {0x00, 0x00, 0x04, 0x00}, //0x07 - ''
;    {0x3F, 0x3F, 0x3B, 0x3F}, //0x08 - ''
;    {0x00, 0x00, 0x00, 0x00}, //0x09 - ' '
;    {0x00, 0x00, 0x00, 0x00}, //0x0A - ' '
;    {0x00, 0x18, 0x1A, 0x06}, //0x0B - ''
;    {0x00, 0x0A, 0x1D, 0x0A}, //0x0C - ''
;    {0x00, 0x00, 0x00, 0x00}, //0x0D - ' '
;    {0x00, 0x04, 0x13, 0x0E}, //0x0E - ''
;    {0x00, 0x0E, 0x1B, 0x0E}, //0x0F - ''
;    {0x00, 0x1F, 0x0E, 0x04}, //0x10 - ''
;    {0x00, 0x04, 0x0E, 0x1F}, //0x11 - ''
;    {0x00, 0x0A, 0x1F, 0x0A}, //0x12 - ''
;    {0x00, 0x17, 0x00, 0x17}, //0x13 - ''
;    {0x06, 0x1F, 0x01, 0x1F}, //0x14 - ''
;    {0x00, 0x16, 0x1B, 0x0D}, //0x15 - ''
;    {0x00, 0x0C, 0x0C, 0x00}, //0x16 - ''
;    {0x00, 0x2A, 0x3F, 0x2A}, //0x17 - ''
;    {0x00, 0x02, 0x1F, 0x02}, //0x18 - ''
;    {0x00, 0x08, 0x1F, 0x08}, //0x19 - ''
;    {0x04, 0x04, 0x0E, 0x04}, //0x1A - '
;    {0x04, 0x0E, 0x04, 0x04}, //0x1B - ''
;    {0x00, 0x0C, 0x08, 0x08}, //0x1C - ''
;    {0x00, 0x0E, 0x04, 0x0E}, //0x1D - ''
;    {0x00, 0x0C, 0x0E, 0x0C}, //0x1E - ''
;    {0x00, 0x06, 0x0E, 0x06}, //0x1F - ''
;    {0x00, 0x00, 0x00, 0x00}, //0x20 - ' '
;    {0x00, 0x00, 0x17, 0x00}, //0x21 - '!'
;    {0x00, 0x03, 0x00, 0x03}, //0x22 - '"'
;    {0x00, 0x1F, 0x0A, 0x1F}, //0x23 - '#'
;    {0x00, 0x14, 0x3F, 0x0A}, //0x24 - '$'
;    {0x00, 0x09, 0x04, 0x12}, //0x25 - '%'
;    {0x00, 0x1A, 0x15, 0x1E}, //0x26 - '&'
;    {0x00, 0x03, 0x01, 0x00}, //0x27 - '''
;    {0x00, 0x0E, 0x11, 0x00}, //0x28 - '('
;    {0x00, 0x11, 0x0E, 0x00}, //0x29 - ')'
;    {0x00, 0x15, 0x0E, 0x15}, //0x2A - '*'
;    {0x00, 0x04, 0x0E, 0x04}, //0x2B - '+'
;    {0x00, 0x30, 0x10, 0x00}, //0x2C - ','
;    {0x00, 0x04, 0x04, 0x04}, //0x2D - '-'
;    {0x00, 0x00, 0x10, 0x00}, //0x2E - '.'
;    {0x00, 0x18, 0x04, 0x03}, //0x2F - '/'
;    {0x00, 0x1E, 0x11, 0x0F}, //0x30 - '0'
;    {0x00, 0x12, 0x1F, 0x10}, //0x31 - '1'
;    {0x00, 0x19, 0x15, 0x12}, //0x32 - '2'
;    {0x00, 0x11, 0x15, 0x0A}, //0x33 - '3'
;    {0x00, 0x06, 0x04, 0x1F}, //0x34 - '4'
;    {0x00, 0x17, 0x15, 0x09}, //0x35 - '5'
;    {0x00, 0x0E, 0x15, 0x08}, //0x36 - '6'
;    {0x00, 0x01, 0x1D, 0x07}, //0x37 - '7'
;    {0x00, 0x0A, 0x15, 0x0A}, //0x38 - '8'
;    {0x00, 0x02, 0x15, 0x0E}, //0x39 - '9'
;    {0x00, 0x00, 0x14, 0x00}, //0x3A - ':'
;    {0x00, 0x30, 0x14, 0x00}, //0x3B - ';'
;    {0x00, 0x04, 0x0A, 0x11}, //0x3C - '<'
;    {0x00, 0x14, 0x14, 0x14}, //0x3D - '='
;    {0x00, 0x11, 0x0A, 0x04}, //0x3E - '>'
;    {0x00, 0x01, 0x15, 0x02}, //0x3F - '?'
;    {0x00, 0x1F, 0x11, 0x17}, //0x40 - '@'
;    {0x00, 0x1E, 0x05, 0x1E}, //0x41 - 'A'
;    {0x00, 0x1F, 0x15, 0x0A}, //0x42 - 'B'
;    {0x00, 0x0E, 0x11, 0x11}, //0x43 - 'C'
;    {0x00, 0x1F, 0x11, 0x0E}, //0x44 - 'D'
;    {0x00, 0x1F, 0x15, 0x11}, //0x45 - 'E'
;    {0x00, 0x1F, 0x05, 0x01}, //0x46 - 'F'
;    {0x00, 0x0E, 0x11, 0x1D}, //0x47 - 'G'
;    {0x00, 0x1F, 0x04, 0x1F}, //0x48 - 'H'
;    {0x00, 0x11, 0x1F, 0x11}, //0x49 - 'I'
;    {0x00, 0x08, 0x10, 0x0F}, //0x4A - 'J'
;    {0x00, 0x1F, 0x04, 0x1B}, //0x4B - 'K'
;    {0x00, 0x1F, 0x10, 0x10}, //0x4C - 'L'
;    {0x00, 0x1F, 0x06, 0x1F}, //0x4D - 'M'
;    {0x00, 0x1F, 0x02, 0x1F}, //0x4E - 'N'
;    {0x00, 0x0E, 0x11, 0x0E}, //0x4F - 'O'
;    {0x00, 0x1F, 0x05, 0x02}, //0x50 - 'P'
;    {0x00, 0x0E, 0x19, 0x1E}, //0x51 - 'Q'
;    {0x00, 0x1F, 0x05, 0x1A}, //0x52 - 'R'
;    {0x00, 0x16, 0x15, 0x0D}, //0x53 - 'S'
;    {0x00, 0x01, 0x1F, 0x01}, //0x54 - 'T'
;    {0x00, 0x1F, 0x10, 0x1F}, //0x55 - 'U'
;    {0x00, 0x0F, 0x10, 0x0F}, //0x56 - 'V'
;    {0x00, 0x1F, 0x0C, 0x1F}, //0x57 - 'W'
;    {0x00, 0x1B, 0x04, 0x1B}, //0x58 - 'X'
;    {0x00, 0x03, 0x1C, 0x03}, //0x59 - 'Y'
;    {0x00, 0x19, 0x15, 0x13}, //0x5A - 'Z'
;    {0x00, 0x1F, 0x11, 0x00}, //0x5B - '['
;    {0x00, 0x03, 0x04, 0x18}, //0x5C - '\'
;    {0x00, 0x11, 0x1F, 0x00}, //0x5D - ']'
;    {0x00, 0x02, 0x01, 0x02}, //0x5E - '^'
;    {0x20, 0x20, 0x20, 0x20}, //0x5F - '_'
;    {0x00, 0x01, 0x03, 0x00}, //0x60 - '`'
;    {0x00, 0x18, 0x14, 0x1C}, //0x61 - 'a'
;    {0x00, 0x1F, 0x14, 0x08}, //0x62 - 'b'
;    {0x00, 0x08, 0x14, 0x14}, //0x63 - 'c'
;    {0x00, 0x08, 0x14, 0x1F}, //0x64 - 'd'
;    {0x00, 0x0C, 0x1C, 0x14}, //0x65 - 'e'
;    {0x00, 0x04, 0x1E, 0x05}, //0x66 - 'f'
;    {0x00, 0x2C, 0x24, 0x3C}, //0x67 - 'g'
;    {0x00, 0x1F, 0x04, 0x18}, //0x68 - 'h'
;    {0x00, 0x00, 0x1D, 0x00}, //0x69 - 'i'
;    {0x00, 0x20, 0x3D, 0x00}, //0x6A - 'j'
;    {0x00, 0x1F, 0x08, 0x14}, //0x6B - 'k'
;    {0x00, 0x00, 0x1F, 0x00}, //0x6C - 'l'
;    {0x00, 0x1C, 0x0C, 0x1C}, //0x6D - 'm'
;    {0x00, 0x1C, 0x04, 0x18}, //0x6E - 'n'
;    {0x00, 0x08, 0x14, 0x08}, //0x6F - 'o'
;    {0x00, 0x3C, 0x14, 0x08}, //0x70 - 'p'
;    {0x00, 0x08, 0x14, 0x3C}, //0x71 - 'q'
;    {0x00, 0x1C, 0x04, 0x00}, //0x72 - 'r'
;    {0x00, 0x10, 0x1C, 0x04}, //0x73 - 's'
;    {0x00, 0x04, 0x1E, 0x14}, //0x74 - 't'
;    {0x00, 0x1C, 0x10, 0x1C}, //0x75 - 'u'
;    {0x00, 0x0C, 0x10, 0x0C}, //0x76 - 'v'
;    {0x00, 0x1C, 0x18, 0x1C}, //0x77 - 'w'
;    {0x00, 0x14, 0x08, 0x14}, //0x78 - 'x'
;    {0x00, 0x2C, 0x10, 0x0C}, //0x79 - 'y'
;    {0x00, 0x04, 0x1C, 0x10}, //0x7A - 'z'
;    {0x00, 0x04, 0x1F, 0x11}, //0x7B - '{'
;    {0x00, 0x00, 0x1F, 0x00}, //0x7C - '|'
;    {0x00, 0x11, 0x1F, 0x04}, //0x7D - '}'
;    {0x02, 0x01, 0x02, 0x01}, //0x7E - '~'
;    {0x00, 0x0C, 0x0A, 0x0C}, //0x7F - ''
;    {0x00, 0x00, 0x00, 0x00}, //0x80 - '_'
;    {0x00, 0x00, 0x00, 0x00}, //0x81 - '_'
;    {0x00, 0x03, 0x01, 0x00}, //0x82 - '''
;    {0x00, 0x00, 0x00, 0x00}, //0x83 - '_'
;    {0x00, 0x03, 0x00, 0x03}, //0x84 - '"'
;    {0x00, 0x00, 0x14, 0x00}, //0x85 - ':'
;    {0x04, 0x04, 0x3F, 0x04}, //0x86 - '+'
;    {0x0A, 0x0A, 0x3B, 0x0A}, //0x87 - '+'
;    {0x00, 0x00, 0x00, 0x00}, //0x88 - '_'
;    {0x00, 0x09, 0x04, 0x12}, //0x89 - '%'
;    {0x00, 0x00, 0x00, 0x00}, //0x8A - '_'
;    {0x00, 0x04, 0x0A, 0x11}, //0x8B - '<'
;    {0x00, 0x00, 0x00, 0x00}, //0x8C - '_'
;    {0x00, 0x00, 0x00, 0x00}, //0x8D - '_'
;    {0x00, 0x00, 0x00, 0x00}, //0x8E - '_'
;    {0x00, 0x00, 0x00, 0x00}, //0x8F - '_'
;    {0x00, 0x00, 0x00, 0x00}, //0x90 - '_'
;    {0x00, 0x03, 0x01, 0x00}, //0x91 - '''
;    {0x00, 0x03, 0x01, 0x00}, //0x92 - '''
;    {0x00, 0x03, 0x00, 0x03}, //0x93 - '"'
;    {0x00, 0x03, 0x00, 0x03}, //0x94 - '"'
;    {0x00, 0x00, 0x04, 0x00}, //0x95 - ''
;    {0x00, 0x04, 0x04, 0x04}, //0x96 - '-'
;    {0x00, 0x04, 0x04, 0x04}, //0x97 - '-'
;    {0x00, 0x00, 0x00, 0x00}, //0x98 - '_'
;    {0x00, 0x01, 0x1F, 0x01}, //0x99 - 'T'
;    {0x00, 0x00, 0x00, 0x00}, //0x9A - '_'
;    {0x00, 0x11, 0x0A, 0x04}, //0x9B - '>'
;    {0x00, 0x00, 0x00, 0x00}, //0x9C - '_'
;    {0x00, 0x00, 0x00, 0x00}, //0x9D - '_'
;    {0x00, 0x00, 0x00, 0x00}, //0x9E - '_'
;    {0x00, 0x00, 0x00, 0x00}, //0x9F - '_'
;    {0x00, 0x00, 0x00, 0x00}, //0xA0 - ''
;    {0x17, 0x15, 0x0F, 0x00}, //0xA1 - ''
;    {0x2C, 0x12, 0x0C, 0x00}, //0xA2 - ''
;    {0x00, 0x00, 0x00, 0x00}, //0xA3 - '_'
;    {0x1E, 0x12, 0x1E, 0x00}, //0xA4 - ''
;    {0x00, 0x00, 0x00, 0x00}, //0xA5 - '_'
;    {0x00, 0x00, 0x3F, 0x00}, //0xA6 - ''
;    {0x00, 0x16, 0x1B, 0x0D}, //0xA7 - ''
;    {0x1F, 0x15, 0x11, 0x00}, //0xA8 - ''
;    {0x00, 0x08, 0x14, 0x14}, //0xA9 - 'c'
;    {0x0E, 0x15, 0x15, 0x00}, //0xAA - ''
;    {0x00, 0x04, 0x0A, 0x11}, //0xAB - '<'
;    {0x04, 0x04, 0x3C, 0x00}, //0xAC - ''
;    {0x00, 0x04, 0x04, 0x04}, //0xAD - '-'
;    {0x00, 0x1F, 0x05, 0x1A}, //0xAE - 'R'
;    {0x01, 0x1E, 0x01, 0x00}, //0xAF - ''
;    {0x00, 0x02, 0x05, 0x02}, //0xB0 - ''
;    {0x00, 0x04, 0x0E, 0x04}, //0xB1 - '+'
;    {0x00, 0x00, 0x00, 0x00}, //0xB2 - '_'
;    {0x00, 0x00, 0x00, 0x00}, //0xB3 - '_'
;    {0x00, 0x00, 0x00, 0x00}, //0xB4 - '_'
;    {0x0C, 0x08, 0x1C, 0x00}, //0xB5 - ''
;    {0x06, 0x1F, 0x01, 0x1F}, //0xB6 - ''
;    {0x00, 0x00, 0x04, 0x00}, //0xB7 - ''
;    {0x0D, 0x1C, 0x15, 0x00}, //0xB8 - ''
;    {0x1F, 0x0E, 0x1F, 0x00}, //0xB9 - ''
;    {0x08, 0x1C, 0x14, 0x00}, //0xBA - ''
;    {0x00, 0x11, 0x0A, 0x04}, //0xBB - '>'
;    {0x00, 0x00, 0x00, 0x00}, //0xBC - '_'
;    {0x00, 0x00, 0x00, 0x00}, //0xBD - '_'
;    {0x00, 0x00, 0x00, 0x00}, //0xBE - '_'
;    {0x04, 0x18, 0x04, 0x00}, //0xBF - ''
;    {0x1E, 0x05, 0x1E, 0x00}, //0xC0 - ''
;    {0x1F, 0x15, 0x09, 0x00}, //0xC1 - ''
;    {0x1F, 0x15, 0x0A, 0x00}, //0xC2 - ''
;    {0x1F, 0x01, 0x01, 0x00}, //0xC3 - ''
;    {0x18, 0x0F, 0x18, 0x00}, //0xC4 - ''
;    {0x1F, 0x15, 0x11, 0x00}, //0xC5 - ''
;    {0x1B, 0x0E, 0x1B, 0x00}, //0xC6 - ''
;    {0x11, 0x15, 0x1F, 0x00}, //0xC7 - ''
;    {0x1F, 0x0C, 0x1F, 0x00}, //0xC8 - ''
;    {0x1F, 0x0D, 0x1F, 0x00}, //0xC9 - ''
;    {0x1F, 0x06, 0x19, 0x00}, //0xCA - ''
;    {0x1E, 0x01, 0x1F, 0x00}, //0xCB - ''
;    {0x1F, 0x02, 0x1F, 0x00}, //0xCC - ''
;    {0x1F, 0x04, 0x1F, 0x00}, //0xCD - ''
;    {0x0E, 0x11, 0x0E, 0x00}, //0xCE - ''
;    {0x1F, 0x01, 0x1F, 0x00}, //0xCF - ''
;    {0x1F, 0x05, 0x02, 0x00}, //0xD0 - ''
;    {0x0E, 0x11, 0x11, 0x00}, //0xD1 - ''
;    {0x01, 0x1F, 0x01, 0x00}, //0xD2 - ''
;    {0x17, 0x14, 0x0F, 0x00}, //0xD3 - ''
;    {0x0E, 0x1B, 0x0E, 0x00}, //0xD4 - ''
;    {0x1B, 0x04, 0x1B, 0x00}, //0xD5 - ''
;    {0x1F, 0x10, 0x1F, 0x30}, //0xD6 - ''
;    {0x07, 0x04, 0x1F, 0x00}, //0xD7 - ''
;    {0x1F, 0x1C, 0x1F, 0x00}, //0xD8 - ''
;    {0x1F, 0x1C, 0x1F, 0x30}, //0xD9 - ''
;    {0x01, 0x1F, 0x1C, 0x00}, //0xDA - ''
;    {0x1F, 0x14, 0x1F, 0x00}, //0xDB - ''
;    {0x1F, 0x14, 0x08, 0x00}, //0xDC - ''
;    {0x11, 0x15, 0x0E, 0x00}, //0xDD - ''
;    {0x1F, 0x0E, 0x1B, 0x0E}, //0xDE - ''
;    {0x1A, 0x05, 0x1F, 0x00}, //0xDF - ''
;    {0x08, 0x14, 0x1C, 0x00}, //0xE0 - ''
;    {0x1C, 0x1C, 0x14, 0x00}, //0xE1 - ''
;    {0x1C, 0x1C, 0x18, 0x00}, //0xE2 - ''
;    {0x1C, 0x04, 0x04, 0x00}, //0xE3 - ''
;    {0x18, 0x0C, 0x18, 0x00}, //0xE4 - ''
;    {0x0C, 0x1C, 0x14, 0x00}, //0xE5 - ''
;    {0x14, 0x1C, 0x14, 0x00}, //0xE6 - ''
;    {0x14, 0x1C, 0x1C, 0x00}, //0xE7 - ''
;    {0x1C, 0x08, 0x1C, 0x00}, //0xE8 - ''
;    {0x1C, 0x09, 0x1C, 0x00}, //0xE9 - ''
;    {0x1C, 0x08, 0x14, 0x00}, //0xEA - ''
;    {0x18, 0x04, 0x1C, 0x00}, //0xEB - ''
;    {0x1C, 0x18, 0x1C, 0x00}, //0xEC - ''
;    {0x1C, 0x08, 0x1C, 0x00}, //0xED - ''
;    {0x08, 0x14, 0x08, 0x00}, //0xEE - ''
;    {0x1C, 0x04, 0x1C, 0x00}, //0xEF - ''
;    {0x3C, 0x14, 0x08, 0x00}, //0xF0 - ''
;    {0x08, 0x14, 0x14, 0x00}, //0xF1 - ''
;    {0x04, 0x1C, 0x04, 0x00}, //0xF2 - ''
;    {0x2C, 0x10, 0x0C, 0x00}, //0xF3 - ''
;    {0x1C, 0x34, 0x1C, 0x00}, //0xF4 - ''
;    {0x14, 0x08, 0x14, 0x00}, //0xF5 - ''
;    {0x1C, 0x10, 0x1C, 0x30}, //0xF6 - ''
;    {0x0C, 0x08, 0x1C, 0x00}, //0xF7 - ''
;    {0x1C, 0x18, 0x1C, 0x00}, //0xF8 - ''
;    {0x1C, 0x18, 0x1C, 0x30}, //0xF9 - ''
;    {0x04, 0x1C, 0x18, 0x00}, //0xFA - ''
;    {0x1C, 0x18, 0x1C, 0x00}, //0xFB - ''
;    {0x1C, 0x18, 0x18, 0x00}, //0xFC - ''
;    {0x14, 0x1C, 0x08, 0x00}, //0xFD - ''
;    {0x1C, 0x08, 0x1C, 0x08}, //0xFE - ''
;    {0x14, 0x0C, 0x1C, 0x00}  //0xFF - ''
;};
;
;flash unsigned char font6x8[256][8] = {
;    {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}, //0x00 - '
;    {0x00, 0x3E, 0x45, 0x51, 0x45, 0x3E, 0x00, 0x00}, //0x01 - ''
;    {0x00, 0x3E, 0x6B, 0x6F, 0x6B, 0x3E, 0x00, 0x00}, //0x02 - ''
;    {0x00, 0x1C, 0x3E, 0x7C, 0x3E, 0x1C, 0x00, 0x00}, //0x03 - ''
;    {0x00, 0x18, 0x3C, 0x7E, 0x3C, 0x18, 0x00, 0x00}, //0x04 - ''
;    {0x00, 0x30, 0x36, 0x7F, 0x36, 0x30, 0x00, 0x00}, //0x05 - ''
;    {0x00, 0x18, 0x5C, 0x7E, 0x5C, 0x18, 0x00, 0x00}, //0x06 - ''
;    {0x00, 0x00, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00}, //0x07 - ''
;    {0xFF, 0xFF, 0xE7, 0xE7, 0xFF, 0xFF, 0x00, 0x00}, //0x08 - ''
;    {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}, //0x09 - ' '
;    {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}, //0x0A - ' '
;    {0x00, 0x30, 0x48, 0x4A, 0x36, 0x0E, 0x00, 0x00}, //0x0B - ''
;    {0x00, 0x06, 0x29, 0x79, 0x29, 0x06, 0x00, 0x00}, //0x0C - ''
;    {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}, //0x0D - ' '
;    {0x00, 0x60, 0x7E, 0x0A, 0x35, 0x3F, 0x00, 0x00}, //0x0E - ''
;    {0x00, 0x2A, 0x1C, 0x36, 0x1C, 0x2A, 0x00, 0x00}, //0x0F - ''
;    {0x00, 0x00, 0x7F, 0x3E, 0x1C, 0x08, 0x00, 0x00}, //0x10 - ''
;    {0x00, 0x08, 0x1C, 0x3E, 0x7F, 0x00, 0x00, 0x00}, //0x11 - ''
;    {0x00, 0x14, 0x36, 0x7F, 0x36, 0x14, 0x00, 0x00}, //0x12 - ''
;    {0x00, 0x00, 0x5F, 0x00, 0x5F, 0x00, 0x00, 0x00}, //0x13 - ''
;    {0x00, 0x06, 0x09, 0x7F, 0x01, 0x7F, 0x00, 0x00}, //0x14 - ''
;    {0x00, 0x22, 0x4D, 0x55, 0x59, 0x22, 0x00, 0x00}, //0x15 - ''
;    {0x00, 0x3C, 0x3C, 0x3C, 0x3C, 0x00, 0x00, 0x00}, //0x16 - ''
;    {0x00, 0x14, 0xB6, 0xFF, 0xB6, 0x14, 0x00, 0x00}, //0x17 - ''
;    {0x00, 0x04, 0x06, 0x7F, 0x06, 0x04, 0x00, 0x00}, //0x18 - ''
;    {0x00, 0x10, 0x30, 0x7F, 0x30, 0x10, 0x00, 0x00}, //0x19 - ''
;    {0x00, 0x08, 0x08, 0x3E, 0x1C, 0x08, 0x00, 0x00}, //0x1A - '
;    {0x00, 0x08, 0x1C, 0x3E, 0x08, 0x08, 0x00, 0x00}, //0x1B - ''
;    {0x00, 0x78, 0x40, 0x40, 0x40, 0x40, 0x00, 0x00}, //0x1C - ''
;    {0x00, 0x08, 0x3E, 0x08, 0x3E, 0x08, 0x00, 0x00}, //0x1D - ''
;    {0x00, 0x30, 0x3C, 0x3F, 0x3C, 0x30, 0x00, 0x00}, //0x1E - ''
;    {0x00, 0x03, 0x0F, 0x3F, 0x0F, 0x03, 0x00, 0x00}, //0x1F - ''
;    {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}, //0x20 - ' '
;    {0x00, 0x00, 0x06, 0x5F, 0x06, 0x00, 0x00, 0x00}, //0x21 - '!'
;    {0x00, 0x07, 0x03, 0x00, 0x07, 0x03, 0x00, 0x00}, //0x22 - '"'
;    {0x00, 0x24, 0x7E, 0x24, 0x7E, 0x24, 0x00, 0x00}, //0x23 - '#'
;    {0x00, 0x24, 0x2B, 0x6A, 0x12, 0x00, 0x00, 0x00}, //0x24 - '$'
;    {0x00, 0x63, 0x13, 0x08, 0x64, 0x63, 0x00, 0x00}, //0x25 - '%'
;    {0x00, 0x36, 0x49, 0x56, 0x20, 0x50, 0x00, 0x00}, //0x26 - '&'
;    {0x00, 0x00, 0x07, 0x03, 0x00, 0x00, 0x00, 0x00}, //0x27 - '''
;    {0x00, 0x00, 0x3E, 0x41, 0x00, 0x00, 0x00, 0x00}, //0x28 - '('
;    {0x00, 0x00, 0x41, 0x3E, 0x00, 0x00, 0x00, 0x00}, //0x29 - ')'
;    {0x00, 0x08, 0x3E, 0x1C, 0x3E, 0x08, 0x00, 0x00}, //0x2A - '*'
;    {0x00, 0x08, 0x08, 0x3E, 0x08, 0x08, 0x00, 0x00}, //0x2B - '+'
;    {0x00, 0x00, 0xE0, 0x60, 0x00, 0x00, 0x00, 0x00}, //0x2C - ','
;    {0x00, 0x08, 0x08, 0x08, 0x08, 0x08, 0x00, 0x00}, //0x2D - '-'
;    {0x00, 0x00, 0x60, 0x60, 0x00, 0x00, 0x00, 0x00}, //0x2E - '.'
;    {0x00, 0x20, 0x10, 0x08, 0x04, 0x02, 0x00, 0x00}, //0x2F - '/'
;    {0x00, 0x3E, 0x51, 0x49, 0x45, 0x3E, 0x00, 0x00}, //0x30 - '0'
;    {0x00, 0x00, 0x42, 0x7F, 0x40, 0x00, 0x00, 0x00}, //0x31 - '1'
;    {0x00, 0x62, 0x51, 0x49, 0x49, 0x46, 0x00, 0x00}, //0x32 - '2'
;    {0x00, 0x22, 0x49, 0x49, 0x49, 0x36, 0x00, 0x00}, //0x33 - '3'
;    {0x00, 0x18, 0x14, 0x12, 0x7F, 0x10, 0x00, 0x00}, //0x34 - '4'
;    {0x00, 0x2F, 0x49, 0x49, 0x49, 0x31, 0x00, 0x00}, //0x35 - '5'
;    {0x00, 0x3C, 0x4A, 0x49, 0x49, 0x30, 0x00, 0x00}, //0x36 - '6'
;    {0x00, 0x01, 0x71, 0x09, 0x05, 0x03, 0x00, 0x00}, //0x37 - '7'
;    {0x00, 0x36, 0x49, 0x49, 0x49, 0x36, 0x00, 0x00}, //0x38 - '8'
;    {0x00, 0x06, 0x49, 0x49, 0x29, 0x1E, 0x00, 0x00}, //0x39 - '9'
;    {0x00, 0x00, 0x6C, 0x6C, 0x00, 0x00, 0x00, 0x00}, //0x3A - ':'
;    {0x00, 0x00, 0xEC, 0x6C, 0x00, 0x00, 0x00, 0x00}, //0x3B - ';'
;    {0x00, 0x08, 0x14, 0x22, 0x41, 0x00, 0x00, 0x00}, //0x3C - '<'
;    {0x00, 0x24, 0x24, 0x24, 0x24, 0x24, 0x00, 0x00}, //0x3D - '='
;    {0x00, 0x00, 0x41, 0x22, 0x14, 0x08, 0x00, 0x00}, //0x3E - '>'
;    {0x00, 0x02, 0x01, 0x59, 0x09, 0x06, 0x00, 0x00}, //0x3F - '?'
;    {0x00, 0x3E, 0x41, 0x5D, 0x55, 0x1E, 0x00, 0x00}, //0x40 - '@'
;    {0x00, 0x7E, 0x11, 0x11, 0x11, 0x7E, 0x00, 0x00}, //0x41 - 'A'
;    {0x00, 0x7F, 0x49, 0x49, 0x49, 0x36, 0x00, 0x00}, //0x42 - 'B'
;    {0x00, 0x3E, 0x41, 0x41, 0x41, 0x22, 0x00, 0x00}, //0x43 - 'C'
;    {0x00, 0x7F, 0x41, 0x41, 0x41, 0x3E, 0x00, 0x00}, //0x44 - 'D'
;    {0x00, 0x7F, 0x49, 0x49, 0x49, 0x41, 0x00, 0x00}, //0x45 - 'E'
;    {0x00, 0x7F, 0x09, 0x09, 0x09, 0x01, 0x00, 0x00}, //0x46 - 'F'
;    {0x00, 0x3E, 0x41, 0x49, 0x49, 0x7A, 0x00, 0x00}, //0x47 - 'G'
;    {0x00, 0x7F, 0x08, 0x08, 0x08, 0x7F, 0x00, 0x00}, //0x48 - 'H'
;    {0x00, 0x00, 0x41, 0x7F, 0x41, 0x00, 0x00, 0x00}, //0x49 - 'I'
;    {0x00, 0x30, 0x40, 0x40, 0x40, 0x3F, 0x00, 0x00}, //0x4A - 'J'
;    {0x00, 0x7F, 0x08, 0x14, 0x22, 0x41, 0x00, 0x00}, //0x4B - 'K'
;    {0x00, 0x7F, 0x40, 0x40, 0x40, 0x40, 0x00, 0x00}, //0x4C - 'L'
;    {0x00, 0x7F, 0x02, 0x04, 0x02, 0x7F, 0x00, 0x00}, //0x4D - 'M'
;    {0x00, 0x7F, 0x02, 0x04, 0x08, 0x7F, 0x00, 0x00}, //0x4E - 'N'
;    {0x00, 0x3E, 0x41, 0x41, 0x41, 0x3E, 0x00, 0x00}, //0x4F - 'O'
;    {0x00, 0x7F, 0x09, 0x09, 0x09, 0x06, 0x00, 0x00}, //0x50 - 'P'
;    {0x00, 0x3E, 0x41, 0x51, 0x21, 0x5E, 0x00, 0x00}, //0x51 - 'Q'
;    {0x00, 0x7F, 0x09, 0x09, 0x19, 0x66, 0x00, 0x00}, //0x52 - 'R'
;    {0x00, 0x26, 0x49, 0x49, 0x49, 0x32, 0x00, 0x00}, //0x53 - 'S'
;    {0x00, 0x01, 0x01, 0x7F, 0x01, 0x01, 0x00, 0x00}, //0x54 - 'T'
;    {0x00, 0x3F, 0x40, 0x40, 0x40, 0x3F, 0x00, 0x00}, //0x55 - 'U'
;    {0x00, 0x1F, 0x20, 0x40, 0x20, 0x1F, 0x00, 0x00}, //0x56 - 'V'
;    {0x00, 0x3F, 0x40, 0x3C, 0x40, 0x3F, 0x00, 0x00}, //0x57 - 'W'
;    {0x00, 0x63, 0x14, 0x08, 0x14, 0x63, 0x00, 0x00}, //0x58 - 'X'
;    {0x00, 0x07, 0x08, 0x70, 0x08, 0x07, 0x00, 0x00}, //0x59 - 'Y'
;    {0x00, 0x71, 0x49, 0x45, 0x43, 0x00, 0x00, 0x00}, //0x5A - 'Z'
;    {0x00, 0x00, 0x7F, 0x41, 0x41, 0x00, 0x00, 0x00}, //0x5B - '['
;    {0x00, 0x02, 0x04, 0x08, 0x10, 0x20, 0x00, 0x00}, //0x5C - '\'
;    {0x00, 0x00, 0x41, 0x41, 0x7F, 0x00, 0x00, 0x00}, //0x5D - ']'
;    {0x00, 0x04, 0x02, 0x01, 0x02, 0x04, 0x00, 0x00}, //0x5E - '^'
;    {0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x00, 0x00}, //0x5F - '_'
;    {0x00, 0x00, 0x03, 0x07, 0x00, 0x00, 0x00, 0x00}, //0x60 - '`'
;    {0x00, 0x20, 0x54, 0x54, 0x54, 0x78, 0x00, 0x00}, //0x61 - 'a'
;    {0x00, 0x7F, 0x44, 0x44, 0x44, 0x38, 0x00, 0x00}, //0x62 - 'b'
;    {0x00, 0x38, 0x44, 0x44, 0x44, 0x28, 0x00, 0x00}, //0x63 - 'c'
;    {0x00, 0x38, 0x44, 0x44, 0x44, 0x7F, 0x00, 0x00}, //0x64 - 'd'
;    {0x00, 0x38, 0x54, 0x54, 0x54, 0x08, 0x00, 0x00}, //0x65 - 'e'
;    {0x00, 0x08, 0x7E, 0x09, 0x09, 0x00, 0x00, 0x00}, //0x66 - 'f'
;    {0x00, 0x18, 0xA4, 0xA4, 0xA4, 0x7C, 0x00, 0x00}, //0x67 - 'g'
;    {0x00, 0x7F, 0x04, 0x04, 0x78, 0x00, 0x00, 0x00}, //0x68 - 'h'
;    {0x00, 0x00, 0x00, 0x7D, 0x40, 0x00, 0x00, 0x00}, //0x69 - 'i'
;    {0x00, 0x40, 0x80, 0x84, 0x7D, 0x00, 0x00, 0x00}, //0x6A - 'j'
;    {0x00, 0x7F, 0x10, 0x28, 0x44, 0x00, 0x00, 0x00}, //0x6B - 'k'
;    {0x00, 0x00, 0x00, 0x7F, 0x40, 0x00, 0x00, 0x00}, //0x6C - 'l'
;    {0x00, 0x7C, 0x04, 0x18, 0x04, 0x78, 0x00, 0x00}, //0x6D - 'm'
;    {0x00, 0x7C, 0x04, 0x04, 0x78, 0x00, 0x00, 0x00}, //0x6E - 'n'
;    {0x00, 0x38, 0x44, 0x44, 0x44, 0x38, 0x00, 0x00}, //0x6F - 'o'
;    {0x00, 0xFC, 0x44, 0x44, 0x44, 0x38, 0x00, 0x00}, //0x70 - 'p'
;    {0x00, 0x38, 0x44, 0x44, 0x44, 0xFC, 0x00, 0x00}, //0x71 - 'q'
;    {0x00, 0x44, 0x78, 0x44, 0x04, 0x08, 0x00, 0x00}, //0x72 - 'r'
;    {0x00, 0x08, 0x54, 0x54, 0x54, 0x20, 0x00, 0x00}, //0x73 - 's'
;    {0x00, 0x04, 0x3E, 0x44, 0x24, 0x00, 0x00, 0x00}, //0x74 - 't'
;    {0x00, 0x3C, 0x40, 0x20, 0x7C, 0x00, 0x00, 0x00}, //0x75 - 'u'
;    {0x00, 0x1C, 0x20, 0x40, 0x20, 0x1C, 0x00, 0x00}, //0x76 - 'v'
;    {0x00, 0x3C, 0x60, 0x30, 0x60, 0x3C, 0x00, 0x00}, //0x77 - 'w'
;    {0x00, 0x6C, 0x10, 0x10, 0x6C, 0x00, 0x00, 0x00}, //0x78 - 'x'
;    {0x00, 0x9C, 0xA0, 0x60, 0x3C, 0x00, 0x00, 0x00}, //0x79 - 'y'
;    {0x00, 0x64, 0x54, 0x54, 0x4C, 0x00, 0x00, 0x00}, //0x7A - 'z'
;    {0x00, 0x08, 0x3E, 0x41, 0x41, 0x00, 0x00, 0x00}, //0x7B - '{'
;    {0x00, 0x00, 0x00, 0x77, 0x00, 0x00, 0x00, 0x00}, //0x7C - '|'
;    {0x00, 0x00, 0x41, 0x41, 0x3E, 0x08, 0x00, 0x00}, //0x7D - '}'
;    {0x00, 0x02, 0x01, 0x02, 0x01, 0x00, 0x00, 0x00}, //0x7E - '~'
;    {0x00, 0x3C, 0x26, 0x23, 0x26, 0x3C, 0x00, 0x00}, //0x7F - ''
;    {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}, //0x80 - '_'
;    {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}, //0x81 - '_'
;    {0x00, 0x00, 0x07, 0x03, 0x00, 0x00, 0x00, 0x00}, //0x82 - '''
;    {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}, //0x83 - '_'
;    {0x00, 0x07, 0x03, 0x00, 0x07, 0x03, 0x00, 0x00}, //0x84 - '"'
;    {0x00, 0x00, 0x6C, 0x6C, 0x00, 0x00, 0x00, 0x00}, //0x85 - ':'
;    {0x08, 0x08, 0x08, 0xFF, 0x08, 0x08, 0x00, 0x00}, //0x86 - '+'
;    {0x0A, 0x0A, 0x0A, 0xFF, 0x0A, 0x0A, 0x00, 0x00}, //0x87 - '+'
;    {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}, //0x88 - '_'
;    {0x00, 0x63, 0x13, 0x08, 0x64, 0x63, 0x00, 0x00}, //0x89 - '%'
;    {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}, //0x8A - '_'
;    {0x00, 0x08, 0x14, 0x22, 0x41, 0x00, 0x00, 0x00}, //0x8B - '<'
;    {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}, //0x8C - '_'
;    {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}, //0x8D - '_'
;    {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}, //0x8E - '_'
;    {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}, //0x8F - '_'
;    {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}, //0x90 - '_'
;    {0x00, 0x00, 0x07, 0x03, 0x00, 0x00, 0x00, 0x00}, //0x91 - '''
;    {0x00, 0x00, 0x07, 0x03, 0x00, 0x00, 0x00, 0x00}, //0x92 - '''
;    {0x00, 0x07, 0x03, 0x00, 0x07, 0x03, 0x00, 0x00}, //0x93 - '"'
;    {0x00, 0x07, 0x03, 0x00, 0x07, 0x03, 0x00, 0x00}, //0x94 - '"'
;    {0x00, 0x00, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00}, //0x95 - ''
;    {0x00, 0x08, 0x08, 0x08, 0x08, 0x08, 0x00, 0x00}, //0x96 - '-'
;    {0x00, 0x08, 0x08, 0x08, 0x08, 0x08, 0x00, 0x00}, //0x97 - '-'
;    {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}, //0x98 - '_'
;    {0x00, 0x01, 0x01, 0x7F, 0x01, 0x01, 0x00, 0x00}, //0x99 - 'T'
;    {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}, //0x9A - '_'
;    {0x00, 0x00, 0x41, 0x22, 0x14, 0x08, 0x00, 0x00}, //0x9B - '>'
;    {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}, //0x9C - '_'
;    {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}, //0x9D - '_'
;    {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}, //0x9E - '_'
;    {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}, //0x9F - '_'
;    {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}, //0xA0 - ''
;    {0x00, 0x27, 0x48, 0x4B, 0x48, 0x3F, 0x00, 0x00}, //0xA1 - ''
;    {0x00, 0x9C, 0xA1, 0x61, 0x3C, 0x00, 0x00, 0x00}, //0xA2 - ''
;    {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}, //0xA3 - '_'
;    {0x2A, 0x3E, 0x14, 0x14, 0x3E, 0x2A, 0x00, 0x00}, //0xA4 - ''
;    {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}, //0xA5 - '_'
;    {0x00, 0x00, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00}, //0xA6 - ''
;    {0x00, 0x22, 0x4D, 0x55, 0x59, 0x22, 0x00, 0x00}, //0xA7 - ''
;    {0x00, 0x7E, 0x4B, 0x4A, 0x4B, 0x42, 0x00, 0x00}, //0xA8 - ''
;    {0x00, 0x38, 0x44, 0x44, 0x44, 0x28, 0x00, 0x00}, //0xA9 - 'c'
;    {0x00, 0x3E, 0x49, 0x49, 0x41, 0x22, 0x00, 0x00}, //0xAA - ''
;    {0x00, 0x08, 0x14, 0x22, 0x41, 0x00, 0x00, 0x00}, //0xAB - '<'
;    {0x08, 0x08, 0x08, 0xF8, 0x00, 0x00, 0x00, 0x00}, //0xAC - ''
;    {0x00, 0x08, 0x08, 0x08, 0x08, 0x08, 0x00, 0x00}, //0xAD - '-'
;    {0x00, 0x7F, 0x09, 0x09, 0x19, 0x66, 0x00, 0x00}, //0xAE - 'R'
;    {0x00, 0x01, 0x40, 0x7E, 0x40, 0x01, 0x00, 0x00}, //0xAF - ''
;    {0x00, 0x06, 0x09, 0x09, 0x06, 0x00, 0x00, 0x00}, //0xB0 - ''
;    {0x00, 0x08, 0x08, 0x3E, 0x08, 0x08, 0x00, 0x00}, //0xB1 - '+'
;    {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}, //0xB2 - '_'
;    {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}, //0xB3 - '_'
;    {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}, //0xB4 - '_'
;    {0x00, 0x0C, 0x10, 0x10, 0x10, 0x7C, 0x00, 0x00}, //0xB5 - ''
;    {0x00, 0x06, 0x09, 0x7F, 0x01, 0x7F, 0x00, 0x00}, //0xB6 - ''
;    {0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00}, //0xB7 - ''
;    {0x00, 0x38, 0x55, 0x54, 0x55, 0x08, 0x00, 0x00}, //0xB8 - ''
;    {0x7F, 0x06, 0x18, 0x7F, 0x13, 0x13, 0x00, 0x00}, //0xB9 - ''
;    {0x00, 0x38, 0x54, 0x54, 0x44, 0x28, 0x00, 0x00}, //0xBA - ''
;    {0x00, 0x00, 0x41, 0x22, 0x14, 0x08, 0x00, 0x00}, //0xBB - '>'
;    {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}, //0xBC - '_'
;    {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}, //0xBD - '_'
;    {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}, //0xBE - '_'
;    {0x00, 0x00, 0x01, 0x7C, 0x41, 0x00, 0x00, 0x00}, //0xBF - ''
;    {0x00, 0x7E, 0x11, 0x11, 0x11, 0x7E, 0x00, 0x00}, //0xC0 - ''
;    {0x00, 0x7F, 0x49, 0x49, 0x49, 0x31, 0x00, 0x00}, //0xC1 - ''
;    {0x00, 0x7F, 0x49, 0x49, 0x49, 0x36, 0x00, 0x00}, //0xC2 - ''
;    {0x00, 0x7F, 0x01, 0x01, 0x01, 0x01, 0x00, 0x00}, //0xC3 - ''
;    {0x60, 0x3E, 0x21, 0x21, 0x3F, 0x60, 0x00, 0x00}, //0xC4 - ''
;    {0x00, 0x7F, 0x49, 0x49, 0x49, 0x41, 0x00, 0x00}, //0xC5 - ''
;    {0x00, 0x77, 0x08, 0x7F, 0x08, 0x77, 0x00, 0x00}, //0xC6 - ''
;    {0x22, 0x49, 0x49, 0x49, 0x36, 0x00, 0x00, 0x00}, //0xC7 - ''
;    {0x00, 0x7F, 0x20, 0x10, 0x08, 0x7F, 0x00, 0x00}, //0xC8 - ''
;    {0x00, 0x7F, 0x20, 0x13, 0x08, 0x7F, 0x00, 0x00}, //0xC9 - ''
;    {0x00, 0x7F, 0x08, 0x14, 0x22, 0x41, 0x00, 0x00}, //0xCA - ''
;    {0x00, 0x40, 0x7E, 0x01, 0x01, 0x7F, 0x00, 0x00}, //0xCB - ''
;    {0x00, 0x7F, 0x02, 0x04, 0x02, 0x7F, 0x00, 0x00}, //0xCC - ''
;    {0x00, 0x7F, 0x08, 0x08, 0x08, 0x7F, 0x00, 0x00}, //0xCD - ''
;    {0x00, 0x3E, 0x41, 0x41, 0x41, 0x3E, 0x00, 0x00}, //0xCE - ''
;    {0x00, 0x7F, 0x01, 0x01, 0x01, 0x7F, 0x00, 0x00}, //0xCF - ''
;    {0x00, 0x7F, 0x09, 0x09, 0x09, 0x06, 0x00, 0x00}, //0xD0 - ''
;    {0x00, 0x3E, 0x41, 0x41, 0x41, 0x22, 0x00, 0x00}, //0xD1 - ''
;    {0x00, 0x01, 0x01, 0x7F, 0x01, 0x01, 0x00, 0x00}, //0xD2 - ''
;    {0x00, 0x27, 0x48, 0x48, 0x48, 0x3F, 0x00, 0x00}, //0xD3 - ''
;    {0x00, 0x0E, 0x11, 0x7F, 0x11, 0x0E, 0x00, 0x00}, //0xD4 - ''
;    {0x00, 0x63, 0x14, 0x08, 0x14, 0x63, 0x00, 0x00}, //0xD5 - ''
;    {0x00, 0x7F, 0x40, 0x40, 0x7F, 0xC0, 0x00, 0x00}, //0xD6 - ''
;    {0x00, 0x07, 0x08, 0x08, 0x08, 0x7F, 0x00, 0x00}, //0xD7 - ''
;    {0x00, 0x7F, 0x40, 0x7F, 0x40, 0x7F, 0x00, 0x00}, //0xD8 - ''
;    {0x00, 0x7F, 0x40, 0x7F, 0x40, 0xFF, 0x00, 0x00}, //0xD9 - ''
;    {0x03, 0x01, 0x7F, 0x48, 0x48, 0x30, 0x00, 0x00}, //0xDA - ''
;    {0x00, 0x7F, 0x48, 0x48, 0x30, 0x7F, 0x00, 0x00}, //0xDB - ''
;    {0x00, 0x7F, 0x48, 0x48, 0x48, 0x30, 0x00, 0x00}, //0xDC - ''
;    {0x00, 0x22, 0x41, 0x49, 0x49, 0x3E, 0x00, 0x00}, //0xDD - ''
;    {0x00, 0x7F, 0x08, 0x3E, 0x41, 0x3E, 0x00, 0x00}, //0xDE - ''
;    {0x00, 0x66, 0x19, 0x09, 0x09, 0x7F, 0x00, 0x00}, //0xDF - ''
;    {0x00, 0x20, 0x54, 0x54, 0x54, 0x78, 0x00, 0x00}, //0xE0 - ''
;    {0x00, 0x3C, 0x4A, 0x4A, 0x4A, 0x31, 0x00, 0x00}, //0xE1 - ''
;    {0x00, 0x7C, 0x54, 0x54, 0x54, 0x28, 0x00, 0x00}, //0xE2 - ''
;    {0x00, 0x7C, 0x04, 0x04, 0x0C, 0x00, 0x00, 0x00}, //0xE3 - ''
;    {0x60, 0x38, 0x24, 0x24, 0x3C, 0x60, 0x00, 0x00}, //0xE4 - ''
;    {0x00, 0x38, 0x54, 0x54, 0x54, 0x08, 0x00, 0x00}, //0xE5 - ''
;    {0x00, 0x6C, 0x10, 0x7C, 0x10, 0x6C, 0x00, 0x00}, //0xE6 - ''
;    {0x00, 0x28, 0x44, 0x54, 0x54, 0x28, 0x00, 0x00}, //0xE7 - ''
;    {0x00, 0x7C, 0x20, 0x10, 0x08, 0x7C, 0x00, 0x00}, //0xE8 - ''
;    {0x00, 0x7C, 0x20, 0x12, 0x0A, 0x7C, 0x00, 0x00}, //0xE9 - ''
;    {0x00, 0x7C, 0x10, 0x28, 0x44, 0x00, 0x00, 0x00}, //0xEA - ''
;    {0x40, 0x38, 0x04, 0x04, 0x7C, 0x00, 0x00, 0x00}, //0xEB - ''
;    {0x00, 0x7C, 0x08, 0x10, 0x08, 0x7C, 0x00, 0x00}, //0xEC - ''
;    {0x00, 0x7C, 0x10, 0x10, 0x10, 0x7C, 0x00, 0x00}, //0xED - ''
;    {0x00, 0x38, 0x44, 0x44, 0x44, 0x38, 0x00, 0x00}, //0xEE - ''
;    {0x00, 0x7C, 0x04, 0x04, 0x04, 0x7C, 0x00, 0x00}, //0xEF - ''
;    {0x00, 0xFC, 0x44, 0x44, 0x44, 0x38, 0x00, 0x00}, //0xF0 - ''
;    {0x00, 0x38, 0x44, 0x44, 0x44, 0x28, 0x00, 0x00}, //0xF1 - ''
;    {0x00, 0x04, 0x04, 0x7C, 0x04, 0x04, 0x00, 0x00}, //0xF2 - ''
;    {0x00, 0x9C, 0xA0, 0x60, 0x3C, 0x00, 0x00, 0x00}, //0xF3 - ''
;    {0x00, 0x18, 0x24, 0x7C, 0x24, 0x18, 0x00, 0x00}, //0xF4 - ''
;    {0x00, 0x6C, 0x10, 0x10, 0x6C, 0x00, 0x00, 0x00}, //0xF5 - ''
;    {0x00, 0x7C, 0x40, 0x40, 0x7C, 0xC0, 0x00, 0x00}, //0xF6 - ''
;    {0x00, 0x0C, 0x10, 0x10, 0x10, 0x7C, 0x00, 0x00}, //0xF7 - ''
;    {0x00, 0x7C, 0x40, 0x7C, 0x40, 0x7C, 0x00, 0x00}, //0xF8 - ''
;    {0x00, 0x7C, 0x40, 0x7C, 0x40, 0xFC, 0x00, 0x00}, //0xF9 - ''
;    {0x0C, 0x04, 0x7C, 0x50, 0x50, 0x20, 0x00, 0x00}, //0xFA - ''
;    {0x00, 0x7C, 0x50, 0x50, 0x20, 0x7C, 0x00, 0x00}, //0xFB - ''
;    {0x00, 0x7C, 0x50, 0x50, 0x50, 0x20, 0x00, 0x00}, //0xFC - ''
;    {0x00, 0x28, 0x44, 0x54, 0x54, 0x38, 0x00, 0x00}, //0xFD - ''
;    {0x00, 0x7C, 0x10, 0x38, 0x44, 0x38, 0x00, 0x00}, //0xFE - ''
;    {0x00, 0x48, 0x34, 0x14, 0x14, 0x7C, 0x00, 0x00}  //0xFF - ''
;};
;
;flash unsigned char font8x8[256][8] = {
;    {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}, // 0x00 - '
;    {0x7E, 0x81, 0x95, 0xB1, 0xB1, 0x95, 0x81, 0x7E}, // 0x01 - ''
;    {0x7E, 0xFF, 0xEB, 0xCF, 0xCF, 0xEB, 0xFF, 0x7E}, // 0x02 - ''
;    {0x0E, 0x1F, 0x3F, 0x7E, 0x3F, 0x1F, 0x0E, 0x00}, // 0x03 - ''
;    {0x08, 0x1C, 0x3E, 0x7F, 0x3E, 0x1C, 0x08, 0x00}, // 0x04 - ''
;    {0x38, 0x3A, 0x9F, 0xFF, 0x9F, 0x3A, 0x38, 0x00}, // 0x05 - ''
;    {0x10, 0x38, 0xBC, 0xFF, 0xBC, 0x38, 0x10, 0x00}, // 0x06 - ''
;    {0x00, 0x00, 0x18, 0x3C, 0x3C, 0x18, 0x00, 0x00}, // 0x07 - ''
;    {0xFF, 0xFF, 0xE7, 0xC3, 0xC3, 0xE7, 0xFF, 0xFF}, // 0x08 - ''
;    {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}, // 0x09 - ' '
;    {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}, // 0x0A - ' '
;    {0x70, 0xF8, 0x88, 0x88, 0xFD, 0x7F, 0x07, 0x0F}, // 0x0B - ''
;    {0x00, 0x4E, 0x5F, 0xF1, 0xF1, 0x5F, 0x4E, 0x00}, // 0x0C - ''
;    {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}, // 0x0D - ' '
;    {0xC0, 0xFF, 0x7F, 0x05, 0x05, 0x65, 0x7F, 0x3F}, // 0x0E - ''
;    {0x99, 0x5A, 0x3C, 0xE7, 0xE7, 0x3C, 0x5A, 0x99}, // 0x0F - ''
;    {0x7F, 0x3E, 0x3E, 0x1C, 0x1C, 0x08, 0x08, 0x00}, // 0x10 - ''
;    {0x08, 0x08, 0x1C, 0x1C, 0x3E, 0x3E, 0x7F, 0x00}, // 0x11 - ''
;    {0x00, 0x24, 0x66, 0xFF, 0xFF, 0x66, 0x24, 0x00}, // 0x12 - ''
;    {0x00, 0x5F, 0x5F, 0x00, 0x00, 0x5F, 0x5F, 0x00}, // 0x13 - ''
;    {0x06, 0x0F, 0x09, 0x7F, 0x7F, 0x01, 0x7F, 0x7F}, // 0x14 - ''
;    {0xDA, 0xBF, 0xA5, 0xA5, 0xFD, 0x59, 0x03, 0x02}, // 0x15 - ''
;    {0x00, 0x00, 0x3C, 0x3C, 0x3C, 0x3C, 0x00, 0x00}, // 0x16 - ''
;    {0x80, 0x94, 0xB6, 0xFF, 0xFF, 0xB6, 0x94, 0x80}, // 0x17 - ''
;    {0x00, 0x04, 0x06, 0x7F, 0x7F, 0x06, 0x04, 0x00}, // 0x18 - ''
;    {0x00, 0x10, 0x30, 0x7F, 0x7F, 0x30, 0x10, 0x00}, // 0x19 - ''
;    {0x08, 0x08, 0x08, 0x2A, 0x3E, 0x1C, 0x08, 0x00}, // 0x1A - '
;    {0x08, 0x1C, 0x3E, 0x2A, 0x08, 0x08, 0x08, 0x00}, // 0x1B - ''
;    {0x3C, 0x3C, 0x20, 0x20, 0x20, 0x20, 0x20, 0x00}, // 0x1C - ''
;    {0x08, 0x1C, 0x3E, 0x08, 0x08, 0x3E, 0x1C, 0x08}, // 0x1D - ''
;    {0x30, 0x38, 0x3C, 0x3E, 0x3E, 0x3C, 0x38, 0x30}, // 0x1E - ''
;    {0x06, 0x0E, 0x1E, 0x3E, 0x3E, 0x1E, 0x0E, 0x06}, // 0x1F - ''
;    {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}, // 0x20 - ' '
;    {0x00, 0x06, 0x5F, 0x5F, 0x06, 0x00, 0x00, 0x00}, // 0x21 - '!'
;    {0x00, 0x07, 0x07, 0x00, 0x07, 0x07, 0x00, 0x00}, // 0x22 - '"'
;    {0x14, 0x7F, 0x7F, 0x14, 0x7F, 0x7F, 0x14, 0x00}, // 0x23 - '#'
;    {0x24, 0x2E, 0x6B, 0x6B, 0x3A, 0x12, 0x00, 0x00}, // 0x24 - '$'
;    {0x46, 0x66, 0x30, 0x18, 0x0C, 0x66, 0x62, 0x00}, // 0x25 - '%'
;    {0x30, 0x7A, 0x4F, 0x5D, 0x37, 0x7A, 0x48, 0x00}, // 0x26 - '&'
;    {0x04, 0x07, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00}, // 0x27 - '''
;    {0x00, 0x1C, 0x3E, 0x63, 0x41, 0x00, 0x00, 0x00}, // 0x28 - '('
;    {0x00, 0x41, 0x63, 0x3E, 0x1C, 0x00, 0x00, 0x00}, // 0x29 - ')'
;    {0x08, 0x2A, 0x3E, 0x1C, 0x1C, 0x3E, 0x2A, 0x08}, // 0x2A - '*'
;    {0x08, 0x08, 0x3E, 0x3E, 0x08, 0x08, 0x00, 0x00}, // 0x2B - '+'
;    {0x00, 0xA0, 0xE0, 0x60, 0x00, 0x00, 0x00, 0x00}, // 0x2C - ','
;    {0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x00, 0x00}, // 0x2D - '-'
;    {0x00, 0x00, 0x60, 0x60, 0x00, 0x00, 0x00, 0x00}, // 0x2E - '.'
;    {0x60, 0x30, 0x18, 0x0C, 0x06, 0x03, 0x01, 0x00}, // 0x2F - '/'
;    {0x3E, 0x7F, 0x59, 0x4D, 0x7F, 0x3E, 0x00, 0x00}, // 0x30 - '0'
;    {0x42, 0x42, 0x7F, 0x7F, 0x40, 0x40, 0x00, 0x00}, // 0x31 - '1'
;    {0x62, 0x73, 0x59, 0x49, 0x6F, 0x66, 0x00, 0x00}, // 0x32 - '2'
;    {0x22, 0x63, 0x49, 0x49, 0x7F, 0x36, 0x00, 0x00}, // 0x33 - '3'
;    {0x18, 0x1C, 0x16, 0x13, 0x7F, 0x7F, 0x10, 0x00}, // 0x34 - '4'
;    {0x27, 0x67, 0x45, 0x45, 0x7D, 0x39, 0x00, 0x00}, // 0x35 - '5'
;    {0x3C, 0x7E, 0x4B, 0x49, 0x79, 0x30, 0x00, 0x00}, // 0x36 - '6'
;    {0x03, 0x63, 0x71, 0x19, 0x0F, 0x07, 0x00, 0x00}, // 0x37 - '7'
;    {0x36, 0x7F, 0x49, 0x49, 0x7F, 0x36, 0x00, 0x00}, // 0x38 - '8'
;    {0x06, 0x4F, 0x49, 0x69, 0x3F, 0x1E, 0x00, 0x00}, // 0x39 - '9'
;    {0x00, 0x00, 0x6C, 0x6C, 0x00, 0x00, 0x00, 0x00}, // 0x3A - ':'
;    {0x00, 0xA0, 0xEC, 0x6C, 0x00, 0x00, 0x00, 0x00}, // 0x3B - ';'
;    {0x08, 0x1C, 0x36, 0x63, 0x41, 0x00, 0x00, 0x00}, // 0x3C - '<'
;    {0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x00, 0x00}, // 0x3D - '='
;    {0x00, 0x41, 0x63, 0x36, 0x1C, 0x08, 0x00, 0x00}, // 0x3E - '>'
;    {0x02, 0x03, 0x51, 0x59, 0x0F, 0x06, 0x00, 0x00}, // 0x3F - '?'
;    {0x3E, 0x7F, 0x41, 0x5D, 0x5D, 0x1F, 0x1E, 0x00}, // 0x40 - '@'
;    {0x7C, 0x7E, 0x13, 0x13, 0x7E, 0x7C, 0x00, 0x00}, // 0x41 - 'A'
;    {0x41, 0x7F, 0x7F, 0x49, 0x49, 0x7F, 0x36, 0x00}, // 0x42 - 'B'
;    {0x1C, 0x3E, 0x63, 0x41, 0x41, 0x63, 0x22, 0x00}, // 0x43 - 'C'
;    {0x41, 0x7F, 0x7F, 0x41, 0x63, 0x7F, 0x1C, 0x00}, // 0x44 - 'D'
;    {0x41, 0x7F, 0x7F, 0x49, 0x5D, 0x41, 0x63, 0x00}, // 0x45 - 'E'
;    {0x41, 0x7F, 0x7F, 0x49, 0x1D, 0x01, 0x03, 0x00}, // 0x46 - 'F'
;    {0x1C, 0x3E, 0x63, 0x41, 0x51, 0x73, 0x72, 0x00}, // 0x47 - 'G'
;    {0x7F, 0x7F, 0x08, 0x08, 0x7F, 0x7F, 0x00, 0x00}, // 0x48 - 'H'
;    {0x00, 0x41, 0x7F, 0x7F, 0x41, 0x00, 0x00, 0x00}, // 0x49 - 'I'
;    {0x30, 0x70, 0x40, 0x41, 0x7F, 0x3F, 0x01, 0x00}, // 0x4A - 'J'
;    {0x41, 0x7F, 0x7F, 0x08, 0x1C, 0x77, 0x63, 0x00}, // 0x4B - 'K'
;    {0x41, 0x7F, 0x7F, 0x41, 0x40, 0x60, 0x70, 0x00}, // 0x4C - 'L'
;    {0x7F, 0x7F, 0x06, 0x0C, 0x06, 0x7F, 0x7F, 0x00}, // 0x4D - 'M'
;    {0x7F, 0x7F, 0x06, 0x0C, 0x18, 0x7F, 0x7F, 0x00}, // 0x4E - 'N'
;    {0x1C, 0x3E, 0x63, 0x41, 0x63, 0x3E, 0x1C, 0x00}, // 0x4F - 'O'
;    {0x41, 0x7F, 0x7F, 0x49, 0x09, 0x0F, 0x06, 0x00}, // 0x50 - 'P'
;    {0x1E, 0x3F, 0x21, 0x71, 0x7F, 0x5E, 0x00, 0x00}, // 0x51 - 'Q'
;    {0x41, 0x7F, 0x7F, 0x19, 0x39, 0x6F, 0x46, 0x00}, // 0x52 - 'R'
;    {0x26, 0x67, 0x4D, 0x59, 0x7B, 0x32, 0x00, 0x00}, // 0x53 - 'S'
;    {0x03, 0x41, 0x7F, 0x7F, 0x41, 0x03, 0x00, 0x00}, // 0x54 - 'T'
;    {0x7F, 0x7F, 0x40, 0x40, 0x7F, 0x7F, 0x00, 0x00}, // 0x55 - 'U'
;    {0x1F, 0x3F, 0x60, 0x60, 0x3F, 0x1F, 0x00, 0x00}, // 0x56 - 'V'
;    {0x7F, 0x7F, 0x30, 0x18, 0x30, 0x7F, 0x7F, 0x00}, // 0x57 - 'W'
;    {0x63, 0x77, 0x1C, 0x08, 0x1C, 0x77, 0x63, 0x00}, // 0x58 - 'X'
;    {0x07, 0x4F, 0x78, 0x78, 0x4F, 0x07, 0x00, 0x00}, // 0x59 - 'Y'
;    {0x67, 0x73, 0x59, 0x4D, 0x47, 0x63, 0x71, 0x00}, // 0x5A - 'Z'
;    {0x00, 0x7F, 0x7F, 0x41, 0x41, 0x00, 0x00, 0x00}, // 0x5B - '['
;    {0x01, 0x03, 0x06, 0x0C, 0x18, 0x30, 0x60, 0x00}, // 0x5C - '\'
;    {0x00, 0x41, 0x41, 0x7F, 0x7F, 0x00, 0x00, 0x00}, // 0x5D - ']'
;    {0x08, 0x0C, 0x06, 0x03, 0x06, 0x0C, 0x08, 0x00}, // 0x5E - '^'
;    {0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40}, // 0x5F - '_'
;    {0x00, 0x00, 0x03, 0x07, 0x04, 0x00, 0x00, 0x00}, // 0x60 - '`'
;    {0x20, 0x74, 0x54, 0x54, 0x3C, 0x78, 0x40, 0x00}, // 0x61 - 'a'
;    {0x41, 0x3F, 0x7F, 0x44, 0x44, 0x7C, 0x38, 0x00}, // 0x62 - 'b'
;    {0x38, 0x7C, 0x44, 0x44, 0x6C, 0x28, 0x00, 0x00}, // 0x63 - 'c'
;    {0x30, 0x78, 0x48, 0x49, 0x3F, 0x7F, 0x40, 0x00}, // 0x64 - 'd'
;    {0x38, 0x7C, 0x54, 0x54, 0x5C, 0x18, 0x00, 0x00}, // 0x65 - 'e'
;    {0x48, 0x7E, 0x7F, 0x49, 0x03, 0x02, 0x00, 0x00}, // 0x66 - 'f'
;    {0x98, 0xBC, 0xA4, 0xA4, 0xF8, 0x7C, 0x04, 0x00}, // 0x67 - 'g'
;    {0x41, 0x7F, 0x7F, 0x08, 0x04, 0x7C, 0x78, 0x00}, // 0x68 - 'h'
;    {0x00, 0x44, 0x7D, 0x7D, 0x40, 0x00, 0x00, 0x00}, // 0x69 - 'i'
;    {0x40, 0xC4, 0x84, 0xFD, 0x7D, 0x00, 0x00, 0x00}, // 0x6A - 'j'
;    {0x41, 0x7F, 0x7F, 0x10, 0x38, 0x6C, 0x44, 0x00}, // 0x6B - 'k'
;    {0x00, 0x41, 0x7F, 0x7F, 0x40, 0x00, 0x00, 0x00}, // 0x6C - 'l'
;    {0x7C, 0x7C, 0x0C, 0x18, 0x0C, 0x7C, 0x78, 0x00}, // 0x6D - 'm'
;    {0x7C, 0x7C, 0x04, 0x04, 0x7C, 0x78, 0x00, 0x00}, // 0x6E - 'n'
;    {0x38, 0x7C, 0x44, 0x44, 0x7C, 0x38, 0x00, 0x00}, // 0x6F - 'o'
;    {0x84, 0xFC, 0xF8, 0xA4, 0x24, 0x3C, 0x18, 0x00}, // 0x70 - 'p'
;    {0x18, 0x3C, 0x24, 0xA4, 0xF8, 0xFC, 0x84, 0x00}, // 0x71 - 'q'
;    {0x44, 0x7C, 0x78, 0x44, 0x1C, 0x18, 0x00, 0x00}, // 0x72 - 'r'
;    {0x48, 0x5C, 0x54, 0x54, 0x74, 0x24, 0x00, 0x00}, // 0x73 - 's'
;    {0x00, 0x04, 0x3E, 0x7F, 0x44, 0x24, 0x00, 0x00}, // 0x74 - 't'
;    {0x3C, 0x7C, 0x40, 0x40, 0x3C, 0x7C, 0x40, 0x00}, // 0x75 - 'u'
;    {0x1C, 0x3C, 0x60, 0x60, 0x3C, 0x1C, 0x00, 0x00}, // 0x76 - 'v'
;    {0x3C, 0x7C, 0x60, 0x30, 0x60, 0x7C, 0x3C, 0x00}, // 0x77 - 'w'
;    {0x44, 0x6C, 0x38, 0x10, 0x38, 0x6C, 0x44, 0x00}, // 0x78 - 'x'
;    {0x9C, 0xBC, 0xA0, 0xA0, 0xFC, 0x7C, 0x00, 0x00}, // 0x79 - 'y'
;    {0x4C, 0x64, 0x74, 0x5C, 0x4C, 0x64, 0x00, 0x00}, // 0x7A - 'z'
;
;//    
;    {0xFF, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0xFF}, //              123
;    {0xFF, 0x81, 0xBD, 0xBD, 0xBD, 0xBD, 0x81, 0xFF}, //   124
;
;    {0x01, 0x31, 0x79, 0x79, 0x7D, 0x7F, 0x7D, 0x31}, //  1  125 ;
;    {0x11, 0x11, 0x11, 0x10, 0x10, 0x10, 0x38, 0x10}, //  2  126 ;
;
;    {0x3E, 0x08, 0x1C, 0x1C, 0x7C, 0x3E, 0x1E, 0x1E}, //  1  127 ;
;    {0x1E, 0x1C, 0x18, 0x18, 0x18, 0x1C, 0x0E, 0x0E}, //  2  128 ;
;
;    {0xF0, 0x08, 0x04, 0x02, 0x01, 0x51, 0xF1, 0xF1}, //  1  129 ;
;    {0xFD, 0xF1, 0xF1, 0x71, 0x1A, 0x0C, 0x08, 0xF0}, //  2  130 ;
;    {0x0F, 0x10, 0x24, 0x74, 0x9C, 0x8E, 0x9F, 0x9F}, //  3  131 ;
;    {0x9F, 0x9F, 0x9F, 0x9E, 0x40, 0x20, 0x10, 0x0F}, //  4  132 ;
;
;/* //  
;    {0x08, 0x08, 0x3E, 0x77, 0x41, 0x41, 0x00, 0x00}, // 0x7B - '{'
;    {0x00, 0x00, 0x00, 0x77, 0x77, 0x00, 0x00, 0x00}, // 0x7C - '|'
;    {0x41, 0x41, 0x77, 0x3E, 0x08, 0x08, 0x00, 0x00}, // 0x7D - '}'
;    {0x02, 0x03, 0x01, 0x03, 0x02, 0x03, 0x01, 0x00}, // 0x7E - '~'
;    {0x78, 0x7C, 0x46, 0x43, 0x46, 0x7C, 0x78, 0x00}, // 0x7F - ''
;    {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}, // 0x80 - '_'
;    {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}, // 0x81 - '_'
;    {0x04, 0x07, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00}, // 0x82 - '''
;    {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}, // 0x83 - '_'
;    {0x00, 0x07, 0x07, 0x00, 0x07, 0x07, 0x00, 0x00}, // 0x84 - '"'
;*/
;    {0x00, 0x00, 0x6C, 0x6C, 0x00, 0x00, 0x00, 0x00}, // 0x85 - ':'
;    {0x10, 0x10, 0x10, 0xFF, 0xFF, 0x10, 0x10, 0x10}, // 0x86 - '+'
;    {0x14, 0x14, 0x14, 0xFF, 0xFF, 0x14, 0x14, 0x14}, // 0x87 - '+'
;    {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}, // 0x88 - '_'
;    {0x46, 0x66, 0x30, 0x18, 0x0C, 0x66, 0x62, 0x00}, // 0x89 - '%'
;    {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}, // 0x8A - '_'
;    {0x08, 0x1C, 0x36, 0x63, 0x41, 0x00, 0x00, 0x00}, // 0x8B - '<'
;    {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}, // 0x8C - '_'
;    {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}, // 0x8D - '_'
;    {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}, // 0x8E - '_'
;    {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}, // 0x8F - '_'
;    {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}, // 0x90 - '_'
;    {0x04, 0x07, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00}, // 0x91 - '''
;    {0x04, 0x07, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00}, // 0x92 - '''
;    {0x00, 0x07, 0x07, 0x00, 0x07, 0x07, 0x00, 0x00}, // 0x93 - '"'
;    {0x00, 0x07, 0x07, 0x00, 0x07, 0x07, 0x00, 0x00}, // 0x94 - '"'
;    {0x00, 0x00, 0x18, 0x3C, 0x3C, 0x18, 0x00, 0x00}, // 0x95 - ''
;    {0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x00, 0x00}, // 0x96 - '-'
;    {0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x00, 0x00}, // 0x97 - '-'
;    {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}, // 0x98 - '_'
;    {0x03, 0x41, 0x7F, 0x7F, 0x41, 0x03, 0x00, 0x00}, // 0x99 - 'T'
;    {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}, // 0x9A - '_'
;    {0x00, 0x41, 0x63, 0x36, 0x1C, 0x08, 0x00, 0x00}, // 0x9B - '>'
;    {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}, // 0x9C - '_'
;    {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}, // 0x9D - '_'
;    {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}, // 0x9E - '_'
;    {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}, // 0x9F - '_'
;    {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}, // 0xA0 - ''
;    {0x26, 0x6E, 0x48, 0x49, 0x48, 0x7E, 0x3E, 0x00}, // 0xA1 - ''
;    {0x1F, 0xBF, 0xA0, 0xA3, 0xA0, 0xFF, 0x7F, 0x00}, // 0xA2 - ''
;    {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}, // 0xA3 - '_'
;    {0x5A, 0x7E, 0x24, 0x24, 0x24, 0x7E, 0x5A, 0x00}, // 0xA4 - ''
;    {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}, // 0xA5 - '_'
;    {0x00, 0x00, 0x00, 0xFF, 0xFF, 0x00, 0x00, 0x00}, // 0xA6 - ''
;    {0xDA, 0xBF, 0xA5, 0xA5, 0xFD, 0x59, 0x03, 0x02}, // 0xA7 - ''
;    {0x42, 0x7F, 0x7F, 0x4A, 0x4B, 0x43, 0x66, 0x00}, // 0xA8 - ''
;    {0x38, 0x7C, 0x44, 0x44, 0x6C, 0x28, 0x00, 0x00}, // 0xA9 - 'c'
;    {0x1C, 0x3E, 0x6B, 0x49, 0x49, 0x63, 0x22, 0x00}, // 0xAA - ''
;    {0x08, 0x1C, 0x36, 0x63, 0x41, 0x00, 0x00, 0x00}, // 0xAB - '<'
;    {0x10, 0x10, 0x10, 0xF0, 0xF0, 0x00, 0x00, 0x00}, // 0xAC - ''
;    {0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x00, 0x00}, // 0xAD - '-'
;    {0x41, 0x7F, 0x7F, 0x19, 0x39, 0x6F, 0x46, 0x00}, // 0xAE - 'R'
;    {0x01, 0x41, 0x7E, 0x7E, 0x41, 0x01, 0x00, 0x00}, // 0xAF - ''
;    {0x00, 0x06, 0x0F, 0x09, 0x0F, 0x06, 0x00, 0x00}, // 0xB0 - ''
;    {0x08, 0x08, 0x3E, 0x3E, 0x08, 0x08, 0x00, 0x00}, // 0xB1 - '+'
;    {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}, // 0xB2 - '_'
;    {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}, // 0xB3 - '_'
;    {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}, // 0xB4 - '_'
;    {0x0C, 0x1C, 0x10, 0x10, 0x10, 0x7C, 0x7C, 0x00}, // 0xB5 - ''
;    {0x06, 0x0F, 0x09, 0x7F, 0x7F, 0x01, 0x7F, 0x7F}, // 0xB6 - ''
;    {0x00, 0x00, 0x00, 0x10, 0x10, 0x00, 0x00, 0x00}, // 0xB7 - ''
;    {0x39, 0x7D, 0x54, 0x54, 0x5D, 0x19, 0x00, 0x00}, // 0xB8 - ''
;    {0x7F, 0x7E, 0x0C, 0x18, 0x7F, 0x7F, 0x09, 0x00}, // 0xB9 - ''
;    {0x38, 0x7C, 0x54, 0x54, 0x44, 0x6C, 0x28, 0x00}, // 0xBA - ''
;    {0x00, 0x41, 0x63, 0x36, 0x1C, 0x08, 0x00, 0x00}, // 0xBB - '>'
;    {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}, // 0xBC - '_'
;    {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}, // 0xBD - '_'
;    {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}, // 0xBE - '_'
;    {0x01, 0x45, 0x7C, 0x7C, 0x41, 0x01, 0x00, 0x00}, // 0xBF - ''
;    {0x7C, 0x7E, 0x13, 0x11, 0x11, 0x7F, 0x7F, 0x00}, // 0xC0 - ''
;    {0x41, 0x7F, 0x7F, 0x49, 0x49, 0x7B, 0x33, 0x00}, // 0xC1 - ''
;    {0x41, 0x7F, 0x7F, 0x49, 0x49, 0x7F, 0x36, 0x00}, // 0xC2 - ''
;    {0x41, 0x7F, 0x7F, 0x41, 0x01, 0x03, 0x03, 0x00}, // 0xC3 - ''
;    {0xC0, 0xFC, 0x7E, 0x43, 0x41, 0x7F, 0xFF, 0xC0}, // 0xC4 - ''
;    {0x41, 0x7F, 0x7F, 0x49, 0x5D, 0x41, 0x63, 0x00}, // 0xC5 - ''
;    {0x63, 0x77, 0x1C, 0x7F, 0x1C, 0x77, 0x63, 0x00}, // 0xC6 - ''
;    {0x22, 0x63, 0x49, 0x49, 0x7F, 0x36, 0x00, 0x00}, // 0xC7 - ''
;    {0x7F, 0x7F, 0x30, 0x18, 0x0C, 0x7F, 0x7F, 0x00}, // 0xC8 - ''
;    {0x7F, 0x7F, 0x30, 0x19, 0x0C, 0x7F, 0x7F, 0x00}, // 0xC9 - ''
;    {0x41, 0x7F, 0x7F, 0x08, 0x1C, 0x77, 0x63, 0x00}, // 0xCA - ''
;    {0x40, 0x7E, 0x3E, 0x03, 0x01, 0x7F, 0x7F, 0x00}, // 0xCB - ''
;    {0x7F, 0x7F, 0x06, 0x0C, 0x06, 0x7F, 0x7F, 0x00}, // 0xCC - ''
;    {0x7F, 0x7F, 0x08, 0x08, 0x08, 0x7F, 0x7F, 0x00}, // 0xCD - ''
;    {0x1C, 0x3E, 0x63, 0x41, 0x63, 0x3E, 0x1C, 0x00}, // 0xCE - ''
;    {0x7F, 0x7F, 0x01, 0x01, 0x01, 0x7F, 0x7F, 0x00}, // 0xCF - ''
;    {0x41, 0x7F, 0x7F, 0x49, 0x09, 0x0F, 0x06, 0x00}, // 0xD0 - ''
;    {0x1C, 0x3E, 0x63, 0x41, 0x41, 0x63, 0x22, 0x00}, // 0xD1 - ''
;    {0x03, 0x41, 0x7F, 0x7F, 0x41, 0x03, 0x00, 0x00}, // 0xD2 - ''
;    {0x27, 0x6F, 0x48, 0x48, 0x48, 0x7F, 0x3F, 0x00}, // 0xD3 - ''
;    {0x0E, 0x1F, 0x51, 0x7F, 0x51, 0x1F, 0x0E, 0x00}, // 0xD4 - ''
;    {0x63, 0x77, 0x1C, 0x08, 0x1C, 0x77, 0x63, 0x00}, // 0xD5 - ''
;    {0x7F, 0x7F, 0x40, 0x40, 0x7F, 0xFF, 0xC0, 0x00}, // 0xD6 - ''
;    {0x07, 0x0F, 0x08, 0x08, 0x08, 0x7F, 0x7F, 0x00}, // 0xD7 - ''
;    {0x7F, 0x7F, 0x40, 0x7F, 0x40, 0x7F, 0x7F, 0x00}, // 0xD8 - ''
;    {0x7F, 0x7F, 0x40, 0x7F, 0x40, 0x7F, 0xFF, 0xC0}, // 0xD9 - ''
;    {0x07, 0x03, 0x7F, 0x7F, 0x48, 0x78, 0x30, 0x00}, // 0xDA - ''
;    {0x7F, 0x7F, 0x48, 0x78, 0x30, 0x7F, 0x7F, 0x00}, // 0xDB - ''
;    {0x01, 0x7F, 0x7F, 0x49, 0x48, 0x78, 0x30, 0x00}, // 0xDC - ''
;    {0x22, 0x63, 0x49, 0x49, 0x6B, 0x3E, 0x1C, 0x00}, // 0xDD - ''
;    {0x7F, 0x7F, 0x08, 0x7F, 0x41, 0x7F, 0x3E, 0x00}, // 0xDE - ''
;    {0x46, 0x6F, 0x39, 0x19, 0x19, 0x7F, 0x7F, 0x00}, // 0xDF - ''
;    {0x20, 0x74, 0x54, 0x54, 0x3C, 0x78, 0x40, 0x00}, // 0xE0 - ''
;    {0x34, 0x7E, 0x4A, 0x4A, 0x4A, 0x7B, 0x31, 0x00}, // 0xE1 - ''
;    {0x44, 0x7C, 0x7C, 0x54, 0x54, 0x7C, 0x28, 0x00}, // 0xE2 - ''
;    {0x44, 0x7C, 0x7C, 0x44, 0x04, 0x0C, 0x0C, 0x00}, // 0xE3 - ''
;    {0xC0, 0xF8, 0x7C, 0x44, 0x7C, 0xFC, 0xC0, 0x00}, // 0xE4 - ''
;    {0x38, 0x7C, 0x54, 0x54, 0x5C, 0x18, 0x00, 0x00}, // 0xE5 - ''
;    {0x44, 0x6C, 0x38, 0x7C, 0x38, 0x6C, 0x44, 0x00}, // 0xE6 - ''
;    {0x28, 0x6C, 0x44, 0x54, 0x54, 0x7C, 0x28, 0x00}, // 0xE7 - ''
;    {0x7C, 0x7C, 0x60, 0x30, 0x18, 0x7C, 0x7C, 0x00}, // 0xE8 - ''
;    {0x7E, 0x7E, 0x60, 0x31, 0x18, 0x7E, 0x7E, 0x00}, // 0xE9 - ''
;    {0x44, 0x7C, 0x7C, 0x10, 0x38, 0x6C, 0x44, 0x00}, // 0xEA - ''
;    {0x40, 0x78, 0x7C, 0x04, 0x04, 0x7C, 0x7C, 0x00}, // 0xEB - ''
;    {0x7C, 0x7C, 0x18, 0x38, 0x18, 0x7C, 0x7C, 0x00}, // 0xEC - ''
;    {0x7C, 0x7C, 0x10, 0x10, 0x10, 0x7C, 0x7C, 0x00}, // 0xED - ''
;    {0x38, 0x7C, 0x44, 0x44, 0x7C, 0x38, 0x00, 0x00}, // 0xEE - ''
;    {0x7C, 0x7C, 0x04, 0x04, 0x04, 0x7C, 0x7C, 0x00}, // 0xEF - ''
;    {0x84, 0xFC, 0xFC, 0xA4, 0x24, 0x3C, 0x18, 0x00}, // 0xF0 - ''
;    {0x38, 0x7C, 0x44, 0x44, 0x6C, 0x28, 0x00, 0x00}, // 0xF1 - ''
;    {0x00, 0x0C, 0x44, 0x7C, 0x7C, 0x44, 0x0C, 0x00}, // 0xF2 - ''
;    {0x1C, 0xBC, 0xA0, 0xA0, 0xA0, 0xFC, 0x7C, 0x00}, // 0xF3 - ''
;    {0x18, 0x3C, 0xA4, 0xFC, 0xA4, 0x3C, 0x18, 0x00}, // 0xF4 - ''
;    {0x44, 0x6C, 0x38, 0x10, 0x38, 0x6C, 0x44, 0x00}, // 0xF5 - ''
;    {0x7C, 0x7C, 0x40, 0x40, 0x7C, 0xFC, 0xC0, 0x00}, // 0xF6 - ''
;    {0x0C, 0x1C, 0x10, 0x10, 0x10, 0x7C, 0x7C, 0x00}, // 0xF7 - ''
;    {0x7C, 0x7C, 0x40, 0x7C, 0x40, 0x7C, 0x7C, 0x00}, // 0xF8 - ''
;    {0x7C, 0x7C, 0x40, 0x7C, 0x40, 0x7C, 0xFC, 0xC0}, // 0xF9 - ''
;    {0x0C, 0x04, 0x7C, 0x7C, 0x50, 0x70, 0x20, 0x00}, // 0xFA - ''
;    {0x7C, 0x7C, 0x50, 0x70, 0x20, 0x7C, 0x7C, 0x00}, // 0xFB - ''
;    {0x04, 0x7C, 0x7C, 0x54, 0x50, 0x70, 0x20, 0x00}, // 0xFC - ''
;    {0x28, 0x6C, 0x44, 0x54, 0x54, 0x7C, 0x38, 0x00}, // 0xFD - ''
;    {0x7C, 0x7C, 0x10, 0x7C, 0x44, 0x7C, 0x38, 0x00}, // 0xFE - ''
;    {0x48, 0x7C, 0x34, 0x14, 0x14, 0x7C, 0x7C, 0x00}  // 0xFF - ''
;};
;
;flash unsigned char font8x12[256][16] = {
;    {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}, //0x00 - ' '
;    {0xFC, 0x01, 0x06, 0x03, 0x52, 0x02, 0xC2, 0x02, 0xC2, 0x02, 0x52, 0x02, 0x06, 0x03, 0xFC, 0x01}, //0x01 - ''
;    {0xFC, 0x01, 0xFE, 0x03, 0xAE, 0x03, 0x3E, 0x03, 0x3E, 0x03, 0xAE, 0x03, 0xFE, 0x03, 0xFC, 0x01}, //0x02 - ''
;    {0x78, 0x00, 0xFC, 0x00, 0xF8, 0x01, 0xF0, 0x03, 0xF8, 0x01, 0xFC, 0x00, 0x78, 0x00, 0x00, 0x00}, //0x03 - ''
;    {0x30, 0x00, 0x78, 0x00, 0xFC, 0x00, 0xFE, 0x01, 0xFC, 0x00, 0x78, 0x00, 0x30, 0x00, 0x00, 0x00}, //0x04 - ''
;    {0x70, 0x00, 0x70, 0x02, 0x7C, 0x02, 0x9E, 0x03, 0x9E, 0x03, 0x7C, 0x02, 0x70, 0x02, 0x70, 0x00}, //0x05 - ''
;    {0x30, 0x00, 0x78, 0x02, 0x7C, 0x02, 0xFE, 0x03, 0xFE, 0x03, 0x7C, 0x02, 0x78, 0x02, 0x30, 0x00}, //0x06 - ''
;    {0x00, 0x00, 0x60, 0x00, 0xF0, 0x00, 0xF0, 0x00, 0xF0, 0x00, 0xF0, 0x00, 0x60, 0x00, 0x00, 0x00}, //0x07 - ''
;    {0xFF, 0x0F, 0x9F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x9F, 0x0F, 0xFF, 0x0F}, //0x08 - ''
;    {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}, //0x09 - ' '
;    {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}, //0x0A - ' '
;    {0xE0, 0x01, 0xF0, 0x03, 0x3A, 0x02, 0x3A, 0x02, 0xEE, 0x03, 0xC6, 0x01, 0x1E, 0x00, 0x00, 0x00}, //0x0B - ''
;    {0x00, 0x00, 0x9C, 0x00, 0xBE, 0x00, 0xE2, 0x03, 0xE2, 0x03, 0xBE, 0x00, 0x9C, 0x00, 0x00, 0x00}, //0x0C - ''
;    {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}, //0x0D - ' '
;    {0x00, 0x07, 0xFE, 0x07, 0xFE, 0x03, 0x0A, 0x00, 0x0A, 0x00, 0x8A, 0x03, 0xFE, 0x03, 0xFE, 0x01}, //0x0E - ''
;    {0x68, 0x01, 0xF8, 0x01, 0xF0, 0x00, 0x9C, 0x03, 0x9C, 0x03, 0xF0, 0x00, 0xF8, 0x01, 0x68, 0x01}, //0x0F - ''
;    {0xFE, 0x03, 0xFC, 0x01, 0xF8, 0x00, 0x70, 0x00, 0x70, 0x00, 0x20, 0x00, 0x20, 0x00, 0x00, 0x00}, //0x10 - ''
;    {0x20, 0x00, 0x20, 0x00, 0x70, 0x00, 0x70, 0x00, 0xF8, 0x00, 0xFC, 0x01, 0xFE, 0x03, 0x00, 0x00}, //0x11 - ''
;    {0x00, 0x00, 0x88, 0x00, 0x8C, 0x01, 0xFE, 0x03, 0xFE, 0x03, 0x8C, 0x01, 0x88, 0x00, 0x00, 0x00}, //0x12 - ''
;    {0x00, 0x00, 0x3E, 0x03, 0x3E, 0x03, 0x00, 0x00, 0x00, 0x00, 0x3E, 0x03, 0x3E, 0x03, 0x00, 0x00}, //0x13 - ''
;    {0x1C, 0x00, 0x3E, 0x00, 0x22, 0x00, 0xFE, 0x03, 0xFE, 0x03, 0x02, 0x00, 0xFE, 0x03, 0xFE, 0x03}, //0x14 - ''
;    {0x00, 0x02, 0x66, 0x06, 0xFE, 0x04, 0x9A, 0x04, 0x92, 0x05, 0xF2, 0x07, 0x66, 0x06, 0x04, 0x00}, //0x15 - ''
;    {0x00, 0x00, 0x00, 0x00, 0xFC, 0x03, 0xFC, 0x03, 0xFC, 0x03, 0xFC, 0x03, 0x00, 0x00, 0x00, 0x00}, //0x16 - ''
;    {0x00, 0x00, 0x88, 0x04, 0x8C, 0x05, 0xFE, 0x07, 0xFE, 0x07, 0x8C, 0x05, 0x88, 0x04, 0x00, 0x00}, //0x17 - ''
;    {0x00, 0x00, 0x08, 0x00, 0x0C, 0x00, 0xFE, 0x03, 0xFE, 0x03, 0x0C, 0x00, 0x08, 0x00, 0x00, 0x00}, //0x18 - ''
;    {0x00, 0x00, 0x80, 0x00, 0x80, 0x01, 0xFE, 0x03, 0xFE, 0x03, 0x80, 0x01, 0x80, 0x00, 0x00, 0x00}, //0x19 - ''
;    {0x20, 0x00, 0x20, 0x00, 0x20, 0x00, 0xA8, 0x00, 0xF8, 0x00, 0x70, 0x00, 0x20, 0x00, 0x00, 0x00}, //0x1A - '
;    {0x20, 0x00, 0x70, 0x00, 0xF8, 0x00, 0xA8, 0x00, 0x20, 0x00, 0x20, 0x00, 0x20, 0x00, 0x00, 0x00}, //0x1B - ''
;    {0xF0, 0x00, 0xF0, 0x00, 0x80, 0x00, 0x80, 0x00, 0x80, 0x00, 0x80, 0x00, 0x80, 0x00, 0x00, 0x00}, //0x1C - ''
;    {0x20, 0x00, 0x70, 0x00, 0xF8, 0x00, 0x20, 0x00, 0x20, 0x00, 0xF8, 0x00, 0x70, 0x00, 0x20, 0x00}, //0x1D - ''
;    {0x00, 0x03, 0xC0, 0x03, 0xF0, 0x03, 0xFC, 0x03, 0xF0, 0x03, 0xC0, 0x03, 0x00, 0x03, 0x00, 0x00}, //0x1E - ''
;    {0x0C, 0x00, 0x3C, 0x00, 0xFC, 0x00, 0xFC, 0x03, 0xFC, 0x00, 0x3C, 0x00, 0x0C, 0x00, 0x00, 0x00}, //0x1F - ''
;    {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}, //0x20 - ' '
;    {0x00, 0x00, 0x1C, 0x00, 0x7E, 0x03, 0x7E, 0x03, 0x1C, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}, //0x21 - '!'
;    {0x00, 0x00, 0x0E, 0x00, 0x1E, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1E, 0x00, 0x0E, 0x00, 0x00, 0x00}, //0x22 - '"'
;    {0x88, 0x00, 0xFE, 0x03, 0xFE, 0x03, 0x88, 0x00, 0xFE, 0x03, 0xFE, 0x03, 0x88, 0x00, 0x00, 0x00}, //0x23 - '#'
;    {0x18, 0x01, 0x3C, 0x01, 0x27, 0x07, 0x27, 0x07, 0xE4, 0x01, 0xC4, 0x00, 0x00, 0x00, 0x00, 0x00}, //0x24 - '$'
;    {0x18, 0x03, 0x98, 0x01, 0xC0, 0x00, 0x60, 0x00, 0x30, 0x03, 0x18, 0x03, 0x00, 0x00, 0x00, 0x00}, //0x25 - '%'
;    {0xEC, 0x01, 0xFE, 0x03, 0x32, 0x02, 0x7E, 0x03, 0xEC, 0x01, 0xC0, 0x03, 0x60, 0x02, 0x00, 0x00}, //0x26 - '&'
;    {0x00, 0x00, 0x10, 0x00, 0x1E, 0x00, 0x0E, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}, //0x27 - '''
;    {0x00, 0x00, 0x70, 0x00, 0xF8, 0x00, 0x8C, 0x01, 0x06, 0x03, 0x02, 0x02, 0x00, 0x00, 0x00, 0x00}, //0x28 - '('
;    {0x00, 0x00, 0x02, 0x02, 0x06, 0x03, 0x8C, 0x01, 0xF8, 0x00, 0x70, 0x00, 0x00, 0x00, 0x00, 0x00}, //0x29 - ')'
;    {0x20, 0x00, 0xA8, 0x00, 0xF8, 0x00, 0x70, 0x00, 0x70, 0x00, 0xF8, 0x00, 0xA8, 0x00, 0x20, 0x00}, //0x2A - '*'
;    {0x00, 0x00, 0x20, 0x00, 0x20, 0x00, 0xF8, 0x00, 0xF8, 0x00, 0x20, 0x00, 0x20, 0x00, 0x00, 0x00}, //0x2B - '+'
;    {0x00, 0x00, 0x00, 0x04, 0x00, 0x07, 0x00, 0x03, 0x00, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}, //0x2C - ','
;    {0x20, 0x00, 0x20, 0x00, 0x20, 0x00, 0x20, 0x00, 0x20, 0x00, 0x20, 0x00, 0x20, 0x00, 0x00, 0x00}, //0x2D - '-'
;    {0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}, //0x2E - '.'
;    {0x00, 0x03, 0x80, 0x01, 0xC0, 0x00, 0x60, 0x00, 0x30, 0x00, 0x18, 0x00, 0x0C, 0x00, 0x00, 0x00}, //0x2F - '/'
;    {0xFC, 0x01, 0xFE, 0x03, 0x02, 0x02, 0xFA, 0x02, 0x02, 0x02, 0xFE, 0x03, 0xFC, 0x01, 0x00, 0x00}, //0x30 - '0'
;    {0x08, 0x02, 0x08, 0x02, 0xFC, 0x03, 0xFE, 0x03, 0x00, 0x02, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00}, //0x31 - '1'
;    {0x0C, 0x03, 0x8E, 0x03, 0xC2, 0x02, 0x62, 0x02, 0x3E, 0x03, 0x1C, 0x03, 0x00, 0x00, 0x00, 0x00}, //0x32 - '2'
;    {0x04, 0x01, 0x06, 0x03, 0x22, 0x02, 0x22, 0x02, 0xFE, 0x03, 0xDC, 0x01, 0x00, 0x00, 0x00, 0x00}, //0x33 - '3'
;    {0x60, 0x00, 0x70, 0x00, 0x58, 0x00, 0x4C, 0x02, 0xFE, 0x03, 0xFE, 0x03, 0x40, 0x02, 0x00, 0x00}, //0x34 - '4'
;    {0x3E, 0x01, 0x3E, 0x03, 0x22, 0x02, 0x22, 0x02, 0xE2, 0x03, 0xC2, 0x01, 0x00, 0x00, 0x00, 0x00}, //0x35 - '5'
;    {0xF8, 0x01, 0xFC, 0x03, 0x26, 0x02, 0x22, 0x02, 0xE2, 0x03, 0xC0, 0x01, 0x00, 0x00, 0x00, 0x00}, //0x36 - '6'
;    {0x0E, 0x00, 0x0E, 0x00, 0x82, 0x03, 0xC2, 0x03, 0x62, 0x00, 0x3E, 0x00, 0x1E, 0x00, 0x00, 0x00}, //0x37 - '7'
;    {0xDC, 0x01, 0xFE, 0x03, 0x32, 0x02, 0x62, 0x02, 0xFE, 0x03, 0xDC, 0x01, 0x00, 0x00, 0x00, 0x00}, //0x38 - '8'
;    {0x1C, 0x00, 0x3E, 0x02, 0x22, 0x03, 0xE2, 0x03, 0xFE, 0x00, 0x3C, 0x00, 0x00, 0x00, 0x00, 0x00}, //0x39 - '9'
;    {0x00, 0x00, 0x00, 0x00, 0x98, 0x01, 0x98, 0x01, 0x98, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}, //0x3A - ':'
;    {0x00, 0x00, 0x00, 0x00, 0x98, 0x05, 0x98, 0x07, 0x98, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}, //0x3B - ';'
;    {0x20, 0x00, 0x70, 0x00, 0xD8, 0x00, 0x8C, 0x01, 0x06, 0x03, 0x02, 0x02, 0x00, 0x00, 0x00, 0x00}, //0x3C - '<'
;    {0x00, 0x00, 0x50, 0x00, 0x50, 0x00, 0x50, 0x00, 0x50, 0x00, 0x50, 0x00, 0x50, 0x00, 0x00, 0x00}, //0x3D - '='
;    {0x00, 0x00, 0x02, 0x02, 0x06, 0x03, 0x8C, 0x01, 0xD8, 0x00, 0x70, 0x00, 0x20, 0x00, 0x00, 0x00}, //0x3E - '>'
;    {0x04, 0x00, 0x06, 0x00, 0x62, 0x03, 0x72, 0x03, 0x1E, 0x00, 0x0C, 0x00, 0x00, 0x00, 0x00, 0x00}, //0x3F - '?'
;    {0xFC, 0x01, 0xFE, 0x03, 0x02, 0x02, 0x72, 0x02, 0x72, 0x02, 0x7E, 0x02, 0x7C, 0x00, 0x00, 0x00}, //0x40 - '@'
;    {0xF8, 0x03, 0xFC, 0x03, 0x46, 0x00, 0x46, 0x00, 0xFC, 0x03, 0xF8, 0x03, 0x00, 0x00, 0x00, 0x00}, //0x41 - 'A'
;    {0x02, 0x02, 0xFE, 0x03, 0xFE, 0x03, 0x22, 0x02, 0x22, 0x02, 0xFE, 0x03, 0xDC, 0x01, 0x00, 0x00}, //0x42 - 'B'
;    {0xF8, 0x00, 0xFC, 0x01, 0x06, 0x03, 0x02, 0x02, 0x02, 0x02, 0x8E, 0x03, 0x8C, 0x01, 0x00, 0x00}, //0x43 - 'C'
;    {0x02, 0x02, 0xFE, 0x03, 0xFE, 0x03, 0x02, 0x02, 0x06, 0x03, 0xFC, 0x01, 0xF8, 0x00, 0x00, 0x00}, //0x44 - 'D'
;    {0x02, 0x02, 0xFE, 0x03, 0xFE, 0x03, 0x22, 0x02, 0x22, 0x02, 0x72, 0x02, 0x06, 0x03, 0x00, 0x00}, //0x45 - 'E'
;    {0x02, 0x02, 0xFE, 0x03, 0xFE, 0x03, 0x22, 0x02, 0x22, 0x00, 0x76, 0x00, 0x0E, 0x00, 0x00, 0x00}, //0x46 - 'F'
;    {0xF8, 0x00, 0xFC, 0x01, 0x06, 0x03, 0x02, 0x02, 0x42, 0x02, 0xCE, 0x03, 0xCC, 0x03, 0x00, 0x00}, //0x47 - 'G'
;    {0xFE, 0x03, 0xFE, 0x03, 0x20, 0x00, 0x20, 0x00, 0xFE, 0x03, 0xFE, 0x03, 0x00, 0x00, 0x00, 0x00}, //0x48 - 'H'
;    {0x00, 0x00, 0x02, 0x02, 0xFE, 0x03, 0xFE, 0x03, 0x02, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}, //0x49 - 'I'
;    {0xC0, 0x01, 0xC0, 0x03, 0x00, 0x02, 0x02, 0x02, 0xFE, 0x03, 0xFE, 0x01, 0x02, 0x00, 0x00, 0x00}, //0x4A - 'J'
;    {0x02, 0x02, 0xFE, 0x03, 0xFE, 0x03, 0x20, 0x00, 0xF8, 0x00, 0xDE, 0x03, 0x06, 0x03, 0x00, 0x00}, //0x4B - 'K'
;    {0x02, 0x02, 0xFE, 0x03, 0xFE, 0x03, 0x02, 0x02, 0x00, 0x02, 0x80, 0x03, 0xC0, 0x03, 0x00, 0x00}, //0x4C - 'L'
;    {0xFE, 0x03, 0xFE, 0x03, 0x1C, 0x00, 0x38, 0x00, 0x1C, 0x00, 0xFE, 0x03, 0xFE, 0x03, 0x00, 0x00}, //0x4D - 'M'
;    {0xFE, 0x03, 0xFE, 0x03, 0x38, 0x00, 0x70, 0x00, 0xE0, 0x00, 0xFE, 0x03, 0xFE, 0x03, 0x00, 0x00}, //0x4E - 'N'
;    {0xF8, 0x00, 0xFC, 0x01, 0x06, 0x03, 0x02, 0x02, 0x06, 0x03, 0xFC, 0x01, 0xF8, 0x00, 0x00, 0x00}, //0x4F - 'O'
;    {0x02, 0x02, 0xFE, 0x03, 0xFE, 0x03, 0x22, 0x02, 0x22, 0x00, 0x3E, 0x00, 0x1C, 0x00, 0x00, 0x00}, //0x50 - 'P'
;    {0xF8, 0x00, 0xFC, 0x01, 0x06, 0x01, 0x82, 0x05, 0xC6, 0x07, 0xFC, 0x07, 0xF8, 0x04, 0x00, 0x00}, //0x51 - 'Q'
;    {0x02, 0x02, 0xFE, 0x03, 0xFE, 0x03, 0x22, 0x00, 0x62, 0x00, 0xFE, 0x03, 0x9C, 0x03, 0x00, 0x00}, //0x52 - 'R'
;    {0x9C, 0x01, 0xBE, 0x03, 0x22, 0x02, 0x62, 0x02, 0xCE, 0x03, 0x8C, 0x01, 0x00, 0x00, 0x00, 0x00}, //0x53 - 'S'
;    {0x06, 0x00, 0x02, 0x02, 0xFE, 0x03, 0xFE, 0x03, 0x02, 0x02, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00}, //0x54 - 'T'
;    {0xFE, 0x01, 0xFE, 0x03, 0x00, 0x02, 0x00, 0x02, 0xFE, 0x03, 0xFE, 0x01, 0x00, 0x00, 0x00, 0x00}, //0x55 - 'U'
;    {0xFE, 0x00, 0xFE, 0x01, 0x00, 0x03, 0x00, 0x03, 0xFE, 0x01, 0xFE, 0x00, 0x00, 0x00, 0x00, 0x00}, //0x56 - 'V'
;    {0x7E, 0x00, 0xFE, 0x03, 0x80, 0x03, 0x60, 0x00, 0x80, 0x03, 0xFE, 0x03, 0x7E, 0x00, 0x00, 0x00}, //0x57 - 'W'
;    {0x8E, 0x03, 0xDE, 0x03, 0x70, 0x00, 0x70, 0x00, 0xDE, 0x03, 0x8E, 0x03, 0x00, 0x00, 0x00, 0x00}, //0x58 - 'X'
;    {0x1E, 0x00, 0x3E, 0x02, 0xE0, 0x03, 0xE0, 0x03, 0x3E, 0x02, 0x1E, 0x00, 0x00, 0x00, 0x00, 0x00}, //0x59 - 'Y'
;    {0x0E, 0x03, 0xC6, 0x03, 0xE2, 0x02, 0x3A, 0x02, 0x1E, 0x02, 0x06, 0x03, 0x86, 0x03, 0x00, 0x00}, //0x5A - 'Z'
;    {0x00, 0x00, 0x00, 0x00, 0xFE, 0x03, 0xFE, 0x03, 0x02, 0x02, 0x02, 0x02, 0x00, 0x00, 0x00, 0x00}, //0x5B - '['
;    {0x0C, 0x00, 0x18, 0x00, 0x30, 0x00, 0x60, 0x00, 0xC0, 0x00, 0x80, 0x01, 0x00, 0x03, 0x00, 0x00}, //0x5C - '\'
;    {0x00, 0x00, 0x00, 0x00, 0x02, 0x02, 0x02, 0x02, 0xFE, 0x03, 0xFE, 0x03, 0x00, 0x00, 0x00, 0x00}, //0x5D - ']'
;    {0x08, 0x00, 0x0C, 0x00, 0x06, 0x00, 0x03, 0x00, 0x06, 0x00, 0x0C, 0x00, 0x08, 0x00, 0x00, 0x00}, //0x5E - '^'
;    {0x00, 0x04, 0x00, 0x04, 0x00, 0x04, 0x00, 0x04, 0x00, 0x04, 0x00, 0x04, 0x00, 0x04, 0x00, 0x04}, //0x5F - '_'
;    {0x00, 0x00, 0x00, 0x00, 0x03, 0x00, 0x07, 0x00, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}, //0x60 - '`'
;    {0x80, 0x01, 0xD0, 0x03, 0x50, 0x02, 0x50, 0x02, 0xF0, 0x01, 0xE0, 0x03, 0x00, 0x02, 0x00, 0x00}, //0x61 - 'a'
;    {0x02, 0x02, 0xFE, 0x03, 0xFE, 0x01, 0x10, 0x02, 0x10, 0x02, 0xF0, 0x03, 0xE0, 0x01, 0x00, 0x00}, //0x62 - 'b'
;    {0xE0, 0x01, 0xF0, 0x03, 0x10, 0x02, 0x10, 0x02, 0x30, 0x03, 0x20, 0x01, 0x00, 0x00, 0x00, 0x00}, //0x63 - 'c'
;    {0xE0, 0x01, 0xF0, 0x03, 0x10, 0x02, 0x12, 0x02, 0xFE, 0x01, 0xFE, 0x03, 0x00, 0x02, 0x00, 0x00}, //0x64 - 'd'
;    {0xE0, 0x01, 0xF0, 0x03, 0x50, 0x02, 0x50, 0x02, 0x70, 0x03, 0x60, 0x01, 0x00, 0x00, 0x00, 0x00}, //0x65 - 'e'
;    {0x20, 0x02, 0xFC, 0x03, 0xFE, 0x03, 0x22, 0x02, 0x26, 0x00, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00}, //0x66 - 'f'
;    {0xE0, 0x04, 0xF0, 0x0D, 0x10, 0x09, 0x10, 0x09, 0xE0, 0x0F, 0xF0, 0x07, 0x10, 0x00, 0x00, 0x00}, //0x67 - 'g'
;    {0x02, 0x02, 0xFE, 0x03, 0xFE, 0x03, 0x20, 0x00, 0x10, 0x00, 0xF0, 0x03, 0xE0, 0x03, 0x00, 0x00}, //0x68 - 'h'
;    {0x00, 0x00, 0x10, 0x02, 0x10, 0x02, 0xF6, 0x03, 0xF6, 0x03, 0x00, 0x02, 0x00, 0x02, 0x00, 0x00}, //0x69 - 'i'
;    {0x00, 0x06, 0x00, 0x0E, 0x10, 0x08, 0x10, 0x08, 0xF6, 0x0F, 0xF6, 0x07, 0x00, 0x00, 0x00, 0x00}, //0x6A - 'j'
;    {0x02, 0x02, 0xFE, 0x03, 0xFE, 0x03, 0x40, 0x00, 0xE0, 0x00, 0xB0, 0x03, 0x10, 0x03, 0x00, 0x00}, //0x6B - 'k'
;    {0x00, 0x00, 0x02, 0x02, 0x02, 0x02, 0xFE, 0x03, 0xFE, 0x03, 0x00, 0x02, 0x00, 0x02, 0x00, 0x00}, //0x6C - 'l'
;    {0xF0, 0x03, 0xF0, 0x03, 0x10, 0x00, 0xF0, 0x01, 0x10, 0x00, 0xF0, 0x03, 0xE0, 0x03, 0x00, 0x00}, //0x6D - 'm'
;    {0xF0, 0x03, 0xF0, 0x03, 0x10, 0x00, 0x10, 0x00, 0xF0, 0x03, 0xE0, 0x03, 0x00, 0x00, 0x00, 0x00}, //0x6E - 'n'
;    {0xE0, 0x01, 0xF0, 0x03, 0x10, 0x02, 0x10, 0x02, 0xF0, 0x03, 0xE0, 0x01, 0x00, 0x00, 0x00, 0x00}, //0x6F - 'o'
;    {0x10, 0x08, 0xF0, 0x0F, 0xE0, 0x0F, 0x10, 0x0A, 0x10, 0x02, 0xF0, 0x03, 0xE0, 0x01, 0x00, 0x00}, //0x70 - 'p'
;    {0xE0, 0x01, 0xF0, 0x03, 0x10, 0x02, 0x10, 0x0A, 0xE0, 0x0F, 0xF0, 0x0F, 0x10, 0x08, 0x00, 0x00}, //0x71 - 'q'
;    {0x10, 0x02, 0xF0, 0x03, 0xF0, 0x03, 0x40, 0x02, 0x30, 0x00, 0x70, 0x00, 0x60, 0x00, 0x00, 0x00}, //0x72 - 'r'
;    {0x20, 0x01, 0x70, 0x03, 0x50, 0x02, 0x90, 0x02, 0xB0, 0x03, 0x20, 0x01, 0x00, 0x00, 0x00, 0x00}, //0x73 - 's'
;    {0x10, 0x00, 0xF8, 0x01, 0xFC, 0x03, 0x10, 0x02, 0x10, 0x03, 0x10, 0x01, 0x00, 0x00, 0x00, 0x00}, //0x74 - 't'
;    {0xF0, 0x01, 0xF0, 0x03, 0x00, 0x02, 0x00, 0x02, 0xF0, 0x01, 0xF0, 0x03, 0x00, 0x02, 0x00, 0x00}, //0x75 - 'u'
;    {0xF0, 0x00, 0xF0, 0x01, 0x00, 0x03, 0x00, 0x03, 0xF0, 0x01, 0xF0, 0x00, 0x00, 0x00, 0x00, 0x00}, //0x76 - 'v'
;    {0xF0, 0x00, 0xF0, 0x03, 0x00, 0x03, 0xC0, 0x00, 0x00, 0x03, 0xF0, 0x03, 0xF0, 0x00, 0x00, 0x00}, //0x77 - 'w'
;    {0x10, 0x02, 0x30, 0x03, 0xE0, 0x01, 0xC0, 0x00, 0xE0, 0x01, 0x30, 0x03, 0x10, 0x02, 0x00, 0x00}, //0x78 - 'x'
;    {0x00, 0x08, 0xF0, 0x08, 0xF0, 0x09, 0x00, 0x0D, 0x00, 0x07, 0xF0, 0x03, 0xF0, 0x00, 0x00, 0x00}, //0x79 - 'y'
;    {0x30, 0x03, 0x90, 0x03, 0x90, 0x02, 0x50, 0x02, 0x70, 0x02, 0x30, 0x03, 0x00, 0x00, 0x00, 0x00}, //0x7A - 'z'
;    {0x20, 0x00, 0x70, 0x00, 0xDC, 0x01, 0x8E, 0x03, 0x02, 0x02, 0x02, 0x02, 0x00, 0x00, 0x00, 0x00}, //0x7B - '{'
;    {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xDE, 0x03, 0xDE, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}, //0x7C - '|'
;    {0x02, 0x02, 0x02, 0x02, 0x8E, 0x03, 0xDC, 0x01, 0x70, 0x00, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00}, //0x7D - '}'
;    {0x0C, 0x00, 0x0E, 0x00, 0x02, 0x00, 0x06, 0x00, 0x0C, 0x00, 0x08, 0x00, 0x0E, 0x00, 0x02, 0x00}, //0x7E - '~'
;    {0xC0, 0x01, 0xE0, 0x01, 0x30, 0x01, 0x18, 0x01, 0x30, 0x01, 0xE0, 0x01, 0xC0, 0x01, 0x00, 0x00}, //0x7F - ''
;    {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}, //0x80 - '_'
;    {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}, //0x81 - '_'
;    {0x00, 0x00, 0x10, 0x00, 0x1E, 0x00, 0x0E, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}, //0x82 - '''
;    {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}, //0x83 - '_'
;    {0x00, 0x00, 0x0E, 0x00, 0x1E, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1E, 0x00, 0x0E, 0x00, 0x00, 0x00}, //0x84 - '"'
;    {0x00, 0x00, 0x00, 0x00, 0x98, 0x01, 0x98, 0x01, 0x98, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}, //0x85 - ':'
;    {0x20, 0x00, 0x20, 0x00, 0x20, 0x00, 0xFF, 0x0F, 0xFF, 0x0F, 0x20, 0x00, 0x20, 0x00, 0x20, 0x00}, //0x86 - '+'
;    {0x90, 0x00, 0x90, 0x00, 0x90, 0x00, 0x9F, 0x0F, 0x9F, 0x0F, 0x90, 0x00, 0x90, 0x00, 0x90, 0x00}, //0x87 - '+'
;    {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}, //0x88 - '_'
;    {0x18, 0x03, 0x98, 0x01, 0xC0, 0x00, 0x60, 0x00, 0x30, 0x03, 0x18, 0x03, 0x00, 0x00, 0x00, 0x00}, //0x89 - '%'
;    {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}, //0x8A - '_'
;    {0x20, 0x00, 0x70, 0x00, 0xD8, 0x00, 0x8C, 0x01, 0x06, 0x03, 0x02, 0x02, 0x00, 0x00, 0x00, 0x00}, //0x8B - '<'
;    {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}, //0x8C - '_'
;    {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}, //0x8D - '_'
;    {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}, //0x8E - '_'
;    {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}, //0x8F - '_'
;    {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}, //0x90 - '_'
;    {0x00, 0x00, 0x10, 0x00, 0x1E, 0x00, 0x0E, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}, //0x91 - '''
;    {0x00, 0x00, 0x10, 0x00, 0x1E, 0x00, 0x0E, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}, //0x92 - '''
;    {0x00, 0x00, 0x0E, 0x00, 0x1E, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1E, 0x00, 0x0E, 0x00, 0x00, 0x00}, //0x93 - '"'
;    {0x00, 0x00, 0x0E, 0x00, 0x1E, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1E, 0x00, 0x0E, 0x00, 0x00, 0x00}, //0x94 - '"'
;    {0x00, 0x00, 0x60, 0x00, 0xF0, 0x00, 0xF0, 0x00, 0xF0, 0x00, 0xF0, 0x00, 0x60, 0x00, 0x00, 0x00}, //0x95 - ''
;    {0x20, 0x00, 0x20, 0x00, 0x20, 0x00, 0x20, 0x00, 0x20, 0x00, 0x20, 0x00, 0x20, 0x00, 0x00, 0x00}, //0x96 - '-'
;    {0x20, 0x00, 0x20, 0x00, 0x20, 0x00, 0x20, 0x00, 0x20, 0x00, 0x20, 0x00, 0x20, 0x00, 0x00, 0x00}, //0x97 - '-'
;    {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}, //0x98 - '_'
;    {0x06, 0x00, 0x02, 0x02, 0xFE, 0x03, 0xFE, 0x03, 0x02, 0x02, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00}, //0x99 - 'T'
;    {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}, //0x9A - '_'
;    {0x00, 0x00, 0x02, 0x02, 0x06, 0x03, 0x8C, 0x01, 0xD8, 0x00, 0x70, 0x00, 0x20, 0x00, 0x00, 0x00}, //0x9B - '>'
;    {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}, //0x9C - '_'
;    {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}, //0x9D - '_'
;    {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}, //0x9E - '_'
;    {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}, //0x9F - '_'
;    {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}, //0xA0 - ''
;    {0x00, 0x00, 0x3C, 0x01, 0x7C, 0x03, 0x41, 0x02, 0x41, 0x02, 0xFC, 0x03, 0xFC, 0x01, 0x00, 0x00}, //0xA1 - ''
;    {0x00, 0x08, 0xF0, 0x08, 0xF0, 0x09, 0x04, 0x0D, 0x04, 0x07, 0xF0, 0x03, 0xF0, 0x00, 0x00, 0x00}, //0xA2 - ''
;    {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}, //0xA3 - '_'
;    {0x00, 0x00, 0x44, 0x00, 0x7C, 0x00, 0x28, 0x00, 0x28, 0x00, 0x7C, 0x00, 0x44, 0x00, 0x00, 0x00}, //0xA4 - ''
;    {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}, //0xA5 - '_'
;    {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x0F, 0xFF, 0x0F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}, //0xA6 - ''
;    {0x00, 0x02, 0x66, 0x06, 0xFE, 0x04, 0x9A, 0x04, 0x92, 0x05, 0xF2, 0x07, 0x66, 0x06, 0x04, 0x00}, //0xA7 - ''
;    {0x02, 0x02, 0xFF, 0x03, 0xFF, 0x03, 0x22, 0x02, 0x23, 0x02, 0x73, 0x02, 0x06, 0x03, 0x00, 0x00}, //0xA8 - ''
;    {0xE0, 0x01, 0xF0, 0x03, 0x10, 0x02, 0x10, 0x02, 0x30, 0x03, 0x20, 0x01, 0x00, 0x00, 0x00, 0x00}, //0xA9 - 'c'
;    {0xF8, 0x00, 0xFC, 0x01, 0x26, 0x03, 0x22, 0x02, 0x02, 0x02, 0x8E, 0x03, 0x8C, 0x01, 0x00, 0x00}, //0xAA - ''
;    {0x20, 0x00, 0x70, 0x00, 0xD8, 0x00, 0x8C, 0x01, 0x06, 0x03, 0x02, 0x02, 0x00, 0x00, 0x00, 0x00}, //0xAB - '<'
;    {0x20, 0x00, 0x20, 0x00, 0x20, 0x00, 0xE0, 0x0F, 0xE0, 0x0F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}, //0xAC - ''
;    {0x20, 0x00, 0x20, 0x00, 0x20, 0x00, 0x20, 0x00, 0x20, 0x00, 0x20, 0x00, 0x20, 0x00, 0x00, 0x00}, //0xAD - '-'
;    {0x02, 0x02, 0xFE, 0x03, 0xFE, 0x03, 0x22, 0x00, 0x62, 0x00, 0xFE, 0x03, 0x9C, 0x03, 0x00, 0x00}, //0xAE - 'R'
;    {0x03, 0x00, 0x03, 0x02, 0xFC, 0x03, 0xFC, 0x03, 0x03, 0x02, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00}, //0xAF - ''
;    {0x00, 0x00, 0x1C, 0x00, 0x3E, 0x00, 0x22, 0x00, 0x22, 0x00, 0x3E, 0x00, 0x1C, 0x00, 0x00, 0x00}, //0xB0 - ''
;    {0x00, 0x00, 0x20, 0x00, 0x20, 0x00, 0xF8, 0x00, 0xF8, 0x00, 0x20, 0x00, 0x20, 0x00, 0x00, 0x00}, //0xB1 - '+'
;    {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}, //0xB2 - '_'
;    {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}, //0xB3 - '_'
;    {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}, //0xB4 - '_'
;    {0x70, 0x00, 0xF0, 0x00, 0x80, 0x00, 0x80, 0x00, 0xF0, 0x03, 0xF0, 0x03, 0x00, 0x00, 0x00, 0x00}, //0xB5 - ''
;    {0x1C, 0x00, 0x3E, 0x00, 0x22, 0x00, 0xFE, 0x03, 0xFE, 0x03, 0x02, 0x00, 0xFE, 0x03, 0xFE, 0x03}, //0xB6 - ''
;    {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x00, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}, //0xB7 - ''
;    {0xE0, 0x01, 0xF6, 0x03, 0x50, 0x02, 0x50, 0x02, 0x76, 0x03, 0x60, 0x01, 0x00, 0x00, 0x00, 0x00}, //0xB8 - ''
;    {0xFE, 0x03, 0xFE, 0x03, 0x30, 0x00, 0x60, 0x00, 0xFE, 0x03, 0xFE, 0x03, 0x66, 0x00, 0x00, 0x00}, //0xB9 - ''
;    {0xE0, 0x01, 0xF0, 0x03, 0x50, 0x02, 0x50, 0x02, 0x30, 0x03, 0x20, 0x01, 0x00, 0x00, 0x00, 0x00}, //0xBA - ''
;    {0x00, 0x00, 0x02, 0x02, 0x06, 0x03, 0x8C, 0x01, 0xD8, 0x00, 0x70, 0x00, 0x20, 0x00, 0x00, 0x00}, //0xBB - '>'
;    {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}, //0xBC - '_'
;    {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}, //0xBD - '_'
;    {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}, //0xBE - '_'
;    {0x00, 0x00, 0x06, 0x00, 0x06, 0x02, 0xF0, 0x03, 0xF0, 0x03, 0x06, 0x02, 0x06, 0x00, 0x00, 0x00}, //0xBF - ''
;    {0xF8, 0x03, 0xFC, 0x03, 0x46, 0x00, 0x46, 0x00, 0xFC, 0x03, 0xF8, 0x03, 0x00, 0x00, 0x00, 0x00}, //0xC0 - ''
;    {0x02, 0x02, 0xFE, 0x03, 0xFE, 0x03, 0x12, 0x02, 0x12, 0x02, 0xF2, 0x03, 0xE6, 0x01, 0x00, 0x00}, //0xC1 - ''
;    {0x02, 0x02, 0xFE, 0x03, 0xFE, 0x03, 0x22, 0x02, 0x22, 0x02, 0xFE, 0x03, 0xDC, 0x01, 0x00, 0x00}, //0xC2 - ''
;    {0x02, 0x02, 0xFE, 0x03, 0xFE, 0x03, 0x02, 0x02, 0x02, 0x00, 0x02, 0x00, 0x0E, 0x00, 0x00, 0x00}, //0xC3 - ''
;    {0x00, 0x06, 0xFC, 0x07, 0xFE, 0x03, 0x02, 0x02, 0x02, 0x02, 0xFE, 0x03, 0xFE, 0x07, 0x00, 0x06}, //0xC4 - ''
;    {0x02, 0x02, 0xFE, 0x03, 0xFE, 0x03, 0x22, 0x02, 0x22, 0x02, 0x72, 0x02, 0x06, 0x03, 0x00, 0x00}, //0xC5 - ''
;    {0x06, 0x03, 0xDC, 0x01, 0x70, 0x00, 0xFE, 0x03, 0xFE, 0x03, 0x70, 0x00, 0xDC, 0x01, 0x06, 0x03}, //0xC6 - ''
;    {0x00, 0x00, 0x8C, 0x01, 0x06, 0x03, 0x22, 0x02, 0x22, 0x02, 0xFE, 0x03, 0xDC, 0x01, 0x00, 0x00}, //0xC7 - ''
;    {0xFE, 0x03, 0xFE, 0x03, 0xE0, 0x00, 0x70, 0x00, 0x38, 0x00, 0xFE, 0x03, 0xFE, 0x03, 0x00, 0x00}, //0xC8 - ''
;    {0xFE, 0x03, 0xFE, 0x03, 0xE4, 0x00, 0x77, 0x00, 0x39, 0x00, 0xFE, 0x03, 0xFE, 0x03, 0x00, 0x00}, //0xC9 - ''
;    {0x02, 0x02, 0xFE, 0x03, 0xFE, 0x03, 0x20, 0x00, 0xF8, 0x00, 0xDE, 0x03, 0x06, 0x03, 0x00, 0x00}, //0xCA - ''
;    {0x00, 0x02, 0xF8, 0x03, 0xFC, 0x01, 0x06, 0x00, 0x06, 0x00, 0xFE, 0x03, 0xFE, 0x03, 0x00, 0x00}, //0xCB - ''
;    {0xFE, 0x03, 0xFE, 0x03, 0x1C, 0x00, 0x38, 0x00, 0x1C, 0x00, 0xFE, 0x03, 0xFE, 0x03, 0x00, 0x00}, //0xCC - ''
;    {0xFE, 0x03, 0xFE, 0x03, 0x20, 0x00, 0x20, 0x00, 0x20, 0x00, 0xFE, 0x03, 0xFE, 0x03, 0x00, 0x00}, //0xCD - ''
;    {0xF8, 0x00, 0xFC, 0x01, 0x06, 0x03, 0x02, 0x02, 0x06, 0x03, 0xFC, 0x01, 0xF8, 0x00, 0x00, 0x00}, //0xCE - ''
;    {0xFE, 0x03, 0xFE, 0x03, 0x02, 0x00, 0x02, 0x00, 0x02, 0x00, 0xFE, 0x03, 0xFE, 0x03, 0x00, 0x00}, //0xCF - ''
;    {0x02, 0x02, 0xFE, 0x03, 0xFE, 0x03, 0x22, 0x02, 0x22, 0x00, 0x3E, 0x00, 0x1C, 0x00, 0x00, 0x00}, //0xD0 - ''
;    {0xF8, 0x00, 0xFC, 0x01, 0x06, 0x03, 0x02, 0x02, 0x02, 0x02, 0x8E, 0x03, 0x8C, 0x01, 0x00, 0x00}, //0xD1 - ''
;    {0x00, 0x00, 0x06, 0x00, 0x02, 0x02, 0xFE, 0x03, 0xFE, 0x03, 0x02, 0x02, 0x06, 0x00, 0x00, 0x00}, //0xD2 - ''
;    {0x00, 0x00, 0x3E, 0x01, 0x7E, 0x03, 0x40, 0x02, 0x40, 0x02, 0xFE, 0x03, 0xFE, 0x01, 0x00, 0x00}, //0xD3 - ''
;    {0x78, 0x00, 0xFC, 0x00, 0x84, 0x00, 0xFE, 0x03, 0xFE, 0x03, 0x84, 0x00, 0xFC, 0x00, 0x78, 0x00}, //0xD4 - ''
;    {0x8E, 0x03, 0xDE, 0x03, 0x70, 0x00, 0x70, 0x00, 0xDE, 0x03, 0x8E, 0x03, 0x00, 0x00, 0x00, 0x00}, //0xD5 - ''
;    {0xFE, 0x03, 0xFE, 0x03, 0x00, 0x02, 0x00, 0x02, 0xFE, 0x03, 0xFE, 0x07, 0x00, 0x06, 0x00, 0x00}, //0xD6 - ''
;    {0x3E, 0x00, 0x7E, 0x00, 0x40, 0x00, 0x40, 0x00, 0x40, 0x00, 0xFE, 0x03, 0xFE, 0x03, 0x00, 0x00}, //0xD7 - ''
;    {0xFE, 0x03, 0xFE, 0x03, 0x00, 0x02, 0xFE, 0x03, 0x00, 0x02, 0xFE, 0x03, 0xFE, 0x03, 0x00, 0x00}, //0xD8 - ''
;    {0xFE, 0x03, 0xFE, 0x03, 0x00, 0x02, 0xFE, 0x03, 0x00, 0x02, 0xFE, 0x03, 0xFE, 0x07, 0x00, 0x06}, //0xD9 - ''
;    {0x06, 0x00, 0xFE, 0x03, 0xFE, 0x03, 0x20, 0x02, 0x20, 0x02, 0xE0, 0x03, 0xC0, 0x01, 0x00, 0x00}, //0xDA - ''
;    {0xFE, 0x03, 0xFE, 0x03, 0x20, 0x02, 0xE0, 0x03, 0xC0, 0x01, 0xFE, 0x03, 0xFE, 0x03, 0x00, 0x00}, //0xDB - ''
;    {0xFC, 0x03, 0xFC, 0x03, 0x20, 0x02, 0x20, 0x02, 0x20, 0x02, 0xE0, 0x03, 0xC0, 0x01, 0x00, 0x00}, //0xDC - ''
;    {0x8C, 0x01, 0x8E, 0x03, 0x02, 0x02, 0x22, 0x02, 0x26, 0x03, 0xFC, 0x01, 0xF8, 0x00, 0x00, 0x00}, //0xDD - ''
;    {0xFE, 0x03, 0xFE, 0x03, 0x30, 0x00, 0xFC, 0x01, 0xFE, 0x03, 0x02, 0x02, 0xFE, 0x03, 0xFC, 0x01}, //0xDE - ''
;    {0x00, 0x02, 0x9C, 0x03, 0xFE, 0x03, 0x62, 0x00, 0x22, 0x00, 0xFE, 0x03, 0xFE, 0x03, 0x02, 0x02}, //0xDF - ''
;    {0x80, 0x01, 0xD0, 0x03, 0x50, 0x02, 0x50, 0x02, 0xF0, 0x01, 0xE0, 0x03, 0x00, 0x02, 0x00, 0x00}, //0xE0 - ''
;    {0xE0, 0x01, 0xF0, 0x03, 0x50, 0x02, 0x50, 0x02, 0xD0, 0x03, 0x98, 0x01, 0x00, 0x00, 0x00, 0x00}, //0xE1 - ''
;    {0xF0, 0x03, 0xF0, 0x03, 0x50, 0x02, 0x50, 0x02, 0xF0, 0x03, 0xA0, 0x01, 0x00, 0x00, 0x00, 0x00}, //0xE2 - ''
;    {0xF0, 0x03, 0xF0, 0x03, 0x10, 0x00, 0x10, 0x00, 0x10, 0x00, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00}, //0xE3 - ''
;    {0x00, 0x06, 0xF0, 0x07, 0xF0, 0x03, 0x10, 0x02, 0xF0, 0x03, 0xF0, 0x07, 0x00, 0x06, 0x00, 0x00}, //0xE4 - ''
;    {0xE0, 0x01, 0xF0, 0x03, 0x50, 0x02, 0x50, 0x02, 0x70, 0x03, 0x60, 0x01, 0x00, 0x00, 0x00, 0x00}, //0xE5 - ''
;    {0x30, 0x03, 0xE0, 0x01, 0xC0, 0x00, 0xF0, 0x03, 0xC0, 0x00, 0xE0, 0x01, 0x30, 0x03, 0x00, 0x00}, //0xE6 - ''
;    {0x20, 0x01, 0x10, 0x02, 0x50, 0x02, 0x50, 0x02, 0xF0, 0x03, 0xA0, 0x01, 0x00, 0x00, 0x00, 0x00}, //0xE7 - ''
;    {0xF0, 0x03, 0xF0, 0x03, 0x80, 0x01, 0xC0, 0x00, 0xF0, 0x03, 0xF0, 0x03, 0x00, 0x00, 0x00, 0x00}, //0xE8 - ''
;    {0xF0, 0x03, 0xF0, 0x03, 0x80, 0x01, 0xCC, 0x00, 0xF6, 0x03, 0xF0, 0x03, 0x00, 0x00, 0x00, 0x00}, //0xE9 - ''
;    {0xF0, 0x03, 0xF0, 0x03, 0x40, 0x00, 0xE0, 0x00, 0xB0, 0x03, 0x10, 0x02, 0x00, 0x00, 0x00, 0x00}, //0xEA - ''
;    {0x00, 0x02, 0x80, 0x03, 0xE0, 0x00, 0x30, 0x00, 0xF0, 0x03, 0xF0, 0x03, 0x00, 0x00, 0x00, 0x00}, //0xEB - ''
;    {0xF0, 0x03, 0xF0, 0x03, 0x20, 0x00, 0xC0, 0x00, 0x20, 0x00, 0xF0, 0x03, 0xF0, 0x03, 0x00, 0x00}, //0xEC - ''
;    {0xF0, 0x03, 0xF0, 0x03, 0x40, 0x00, 0x40, 0x00, 0xF0, 0x03, 0xF0, 0x03, 0x00, 0x00, 0x00, 0x00}, //0xED - ''
;    {0xE0, 0x01, 0xF0, 0x03, 0x10, 0x02, 0x10, 0x02, 0xF0, 0x03, 0xE0, 0x01, 0x00, 0x00, 0x00, 0x00}, //0xEE - ''
;    {0xF0, 0x03, 0xF0, 0x03, 0x10, 0x00, 0x10, 0x00, 0xF0, 0x03, 0xF0, 0x03, 0x00, 0x00, 0x00, 0x00}, //0xEF - ''
;    {0xF0, 0x0F, 0xF0, 0x0F, 0x10, 0x02, 0x10, 0x02, 0xF0, 0x03, 0xE0, 0x01, 0x00, 0x00, 0x00, 0x00}, //0xF0 - ''
;    {0xE0, 0x01, 0xF0, 0x03, 0x10, 0x02, 0x10, 0x02, 0x30, 0x03, 0x20, 0x01, 0x00, 0x00, 0x00, 0x00}, //0xF1 - ''
;    {0x10, 0x00, 0x10, 0x00, 0xF0, 0x03, 0xF0, 0x03, 0x10, 0x00, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00}, //0xF2 - ''
;    {0x00, 0x00, 0xF0, 0x04, 0xF0, 0x0D, 0x00, 0x09, 0x00, 0x09, 0xF0, 0x0F, 0xF0, 0x07, 0x00, 0x00}, //0xF3 - ''
;    {0xE0, 0x00, 0xF0, 0x01, 0x10, 0x01, 0xF8, 0x07, 0x10, 0x01, 0xF0, 0x01, 0xE0, 0x00, 0x00, 0x00}, //0xF4 - ''
;    {0x10, 0x02, 0x30, 0x03, 0xE0, 0x01, 0xC0, 0x00, 0xE0, 0x01, 0x30, 0x03, 0x10, 0x02, 0x00, 0x00}, //0xF5 - ''
;    {0xF0, 0x03, 0xF0, 0x03, 0x00, 0x02, 0x00, 0x02, 0xF0, 0x03, 0xF0, 0x07, 0x00, 0x06, 0x00, 0x00}, //0xF6 - ''
;    {0x70, 0x00, 0xF0, 0x00, 0x80, 0x00, 0x80, 0x00, 0xF0, 0x03, 0xF0, 0x03, 0x00, 0x00, 0x00, 0x00}, //0xF7 - ''
;    {0xF0, 0x03, 0xF0, 0x03, 0x00, 0x02, 0xF0, 0x03, 0x00, 0x02, 0xF0, 0x03, 0xF0, 0x03, 0x00, 0x00}, //0xF8 - ''
;    {0xF0, 0x03, 0xF0, 0x03, 0x00, 0x02, 0xF0, 0x03, 0x00, 0x02, 0xF0, 0x03, 0xF0, 0x07, 0x00, 0x06}, //0xF9 - ''
;    {0x30, 0x00, 0xF0, 0x03, 0xF0, 0x03, 0x40, 0x02, 0x40, 0x02, 0xC0, 0x03, 0x80, 0x01, 0x00, 0x00}, //0xFA - ''
;    {0xF0, 0x03, 0xF0, 0x03, 0x40, 0x02, 0xC0, 0x03, 0x80, 0x01, 0xF0, 0x03, 0xF0, 0x03, 0x00, 0x00}, //0xFB - ''
;    {0xF0, 0x03, 0xF0, 0x03, 0x40, 0x02, 0x40, 0x02, 0xC0, 0x03, 0x80, 0x01, 0x00, 0x00, 0x00, 0x00}, //0xFC - ''
;    {0x20, 0x01, 0x30, 0x03, 0x50, 0x02, 0x50, 0x02, 0xF0, 0x03, 0xE0, 0x01, 0x00, 0x00, 0x00, 0x00}, //0xFD - ''
;    {0xF0, 0x03, 0xF0, 0x03, 0xE0, 0x01, 0xF0, 0x03, 0x10, 0x02, 0xF0, 0x03, 0xE0, 0x01, 0x00, 0x00}, //0xFE - ''
;    {0x60, 0x02, 0xF0, 0x03, 0x90, 0x01, 0x90, 0x00, 0xF0, 0x03, 0xF0, 0x03, 0x00, 0x00, 0x00, 0x00}  //0xFF - ''
;};
;
;flash unsigned char font12x16[256][24] =
;{
;    // 0x00 -  .
;    {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
;     0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
;
;    // 0x01 -   .
;    {0x00, 0x00, 0xF0, 0x03, 0x0C, 0x0C, 0x02, 0x10, 0x32, 0x11, 0x31, 0x22,
;     0x01, 0x22, 0x31, 0x22, 0x32, 0x11, 0x02, 0x10, 0x0C, 0x0C, 0xF0, 0x03},
;
;    // 0x02 -    .
;    {0x00, 0x00, 0xF0, 0x03, 0xFC, 0x0F, 0xFE, 0x1F, 0xCE, 0x1E, 0xCF, 0x3D,
;     0xFF, 0x3D, 0xCF, 0x3D, 0xCE, 0x1E, 0xFE, 0x1F, 0xFC, 0x0F, 0xF0, 0x03},
;
;    // 0x03 -  ().
;    {0x00, 0x00, 0x00, 0x00, 0xF0, 0x00, 0xF8, 0x01, 0xF8, 0x03, 0xF0, 0x07,
;     0xE0, 0x0F, 0xF0, 0x07, 0xF8, 0x03, 0xF8, 0x01, 0xF0, 0x00, 0x00, 0x00},
;
;    // 0x04 - .
;    {0x00, 0x00, 0x00, 0x00, 0x80, 0x00, 0xC0, 0x01, 0xE0, 0x03, 0xF0, 0x07,
;     0xF8, 0x0F, 0xF0, 0x07, 0xE0, 0x03, 0xC0, 0x01, 0x80, 0x00, 0x00, 0x00},
;
;    // 0x05 - .
;    {0x00, 0x00, 0x80, 0x03, 0xC0, 0x07, 0xC0, 0x07, 0xB8, 0x13, 0xFC, 0x1B,
;     0xFC, 0x1F, 0xFC, 0x1B, 0xB8, 0x13, 0xC0, 0x07, 0xC0, 0x07, 0x80, 0x03},
;
;    // 0x06 - .
;    {0x00, 0x00, 0x00, 0x00, 0x80, 0x03, 0xC0, 0x07, 0xE0, 0x17, 0xF0, 0x1B,
;     0xFC, 0x1F, 0xF0, 0x1B, 0xE0, 0x17, 0xC0, 0x07, 0x80, 0x03, 0x00, 0x00},
;
;    // 0x07 -    .
;    {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x01, 0xC0, 0x03,
;     0xC0, 0x03, 0x80, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
;
;    // 0x08 -      .
;    {0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x7F, 0xFE, 0x3F, 0xFC,
;     0x3F, 0xFC, 0x7F, 0xFE, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF},
;
;    // 0x09 -    .
;    {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xC0, 0x03, 0x20, 0x04, 0x10, 0x08,
;     0x10, 0x08, 0x20, 0x04, 0xC0, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
;
;    // 0x0A -       ().
;    {0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x3F, 0xFC, 0xDF, 0xFB, 0xEF, 0xF7,
;     0xEF, 0xF7, 0xDF, 0xFB, 0x3F, 0xFC, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF},
;
;    // 0x0B -   (   ).
;    {0x00, 0x00, 0x80, 0x03, 0xC0, 0x07, 0x60, 0x0C, 0x20, 0x08, 0x20, 0x08,
;     0x60, 0x0C, 0xC8, 0x07, 0xA8, 0x03, 0x18, 0x00, 0x78, 0x00, 0x00, 0x00},
;
;    // 0x0C -   (   ).
;    {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x70, 0x00, 0xF8, 0x08, 0x8C, 0x09,
;     0x04, 0x3F, 0x04, 0x3F, 0x8C, 0x09, 0xF8, 0x08, 0x70, 0x00, 0x00, 0x00},
;
;    // 0x0D -  I.
;    {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0C, 0x00, 0x1E, 0x00, 0x1E,
;     0xFF, 0x0F, 0x0E, 0x00, 0x7C, 0x00, 0x38, 0x00, 0x00, 0x00, 0x00, 0x00},
;
;    // 0x0E -  II.
;    {0x00, 0x00, 0x00, 0x06, 0x00, 0x0F, 0x00, 0x0F, 0xFF, 0x07, 0x33, 0x00,
;     0x66, 0x30, 0xCC, 0x78, 0x98, 0x79, 0xF0, 0x3F, 0x00, 0x00, 0x00, 0x00},
;
;    // 0x0F -  (   ).
;    {0x00, 0x00, 0x80, 0x00, 0xC8, 0x09, 0xF0, 0x07, 0x30, 0x06, 0x18, 0x0C,
;     0x1E, 0x3C, 0x18, 0x0C, 0x30, 0x06, 0xF0, 0x07, 0xC8, 0x09, 0x80, 0x00},
;
;    // 0x10 -   .
;    {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFC, 0x1F, 0xF8, 0x0F, 0xF0, 0x07,
;     0xE0, 0x03, 0xC0, 0x01, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
;
;    // 0x11 -   .
;    {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x00, 0xC0, 0x01, 0xE0, 0x03,
;     0xF0, 0x07, 0xF8, 0x0F, 0xFC, 0x1F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
;
;    // 0x12 -   -.
;    {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x04, 0x18, 0x0C, 0x1C, 0x1C,
;     0xFE, 0x3F, 0x1C, 0x1C, 0x18, 0x0C, 0x10, 0x04, 0x00, 0x00, 0x00, 0x00},
;
;    // 0x13 -   .
;    {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFE, 0x37, 0xFE, 0x37, 0x00, 0x00,
;     0x00, 0x00, 0xFE, 0x37, 0xFE, 0x37, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
;
;    // 0x14 -  "".
;    {0x00, 0x00, 0x38, 0x00, 0x7C, 0x00, 0xC6, 0x00, 0x82, 0x00, 0xFE, 0x3F,
;     0xFE, 0x3F, 0x02, 0x00, 0xFE, 0x3F, 0xFE, 0x3F, 0x02, 0x00, 0x00, 0x00},
;
;    // 0x15 -  .
;    {0x00, 0x00, 0x00, 0x00, 0xDC, 0x08, 0xFE, 0x19, 0x22, 0x11, 0x22, 0x11,
;     0x22, 0x11, 0x22, 0x11, 0xE6, 0x1F, 0xC4, 0x0E, 0x00, 0x00, 0x00, 0x00},
;
;    // 0x16 -  .
;    {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x38, 0x00, 0x38, 0x00, 0x38,
;     0x00, 0x38, 0x00, 0x38, 0x00, 0x38, 0x00, 0x38, 0x00, 0x38, 0x00, 0x00},
;
;    // 0x17 -   -  .
;    {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x44, 0x0C, 0x4C, 0x0E, 0x5C,
;     0xFF, 0x7F, 0x0E, 0x5C, 0x0C, 0x4C, 0x08, 0x44, 0x00, 0x00, 0x00, 0x00},
;
;    // 0x18 -   .
;    {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x18, 0x00, 0x1C, 0x00,
;     0xFE, 0x3F, 0x1C, 0x00, 0x18, 0x00, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00},
;
;    // 0x19 -   .
;    {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x0C, 0x00, 0x1C,
;     0xFE, 0x3F, 0x00, 0x1C, 0x00, 0x0C, 0x00, 0x04, 0x00, 0x00, 0x00, 0x00},
;
;    // 0x1A -   .
;    {0x00, 0x00, 0x00, 0x00, 0x80, 0x00, 0x80, 0x00, 0x80, 0x00, 0x80, 0x00,
;     0x80, 0x00, 0xF0, 0x07, 0xE0, 0x03, 0xC0, 0x01, 0x80, 0x00, 0x00, 0x00},
;
;    // 0x1B -   .
;    {0x00, 0x00, 0x00, 0x00, 0x80, 0x00, 0xC0, 0x01, 0xE0, 0x03, 0xF0, 0x07,
;     0x80, 0x00, 0x80, 0x00, 0x80, 0x00, 0x80, 0x00, 0x80, 0x00, 0x00, 0x00},
;
;    // 0x1C -  .
;    {0x00, 0x00, 0x00, 0x3F, 0x00, 0x20, 0x00, 0x20, 0x00, 0x20, 0x00, 0x20,
;     0x00, 0x20, 0x00, 0x20, 0x00, 0x20, 0x00, 0x20, 0x00, 0x20, 0x00, 0x00},
;
;    // 0x1D -   -.
;    {0x00, 0x00, 0x80, 0x00, 0xC0, 0x01, 0xE0, 0x03, 0xF0, 0x07, 0x80, 0x00,
;     0x80, 0x00, 0x80, 0x00, 0xF0, 0x07, 0xE0, 0x03, 0xC0, 0x01, 0x80, 0x00},
;
;    // 0x1E -   .
;    {0x00, 0x00, 0x00, 0x04, 0x00, 0x06, 0x00, 0x07, 0x80, 0x07, 0xC0, 0x07,
;     0xE0, 0x07, 0xC0, 0x07, 0x80, 0x07, 0x00, 0x07, 0x00, 0x06, 0x00, 0x04},
;
;    // 0x1F -   .
;    {0x00, 0x00, 0x20, 0x00, 0x60, 0x00, 0xE0, 0x00, 0xE0, 0x01, 0xE0, 0x03,
;     0xE0, 0x07, 0xE0, 0x03, 0xE0, 0x01, 0xE0, 0x00, 0x60, 0x00, 0x20, 0x00},
;
;    // 0x20 -  ( ).
;    {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
;     0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
;
;    // 0x21 -  .
;    {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7C, 0x00, 0xFF, 0x33,
;     0xFF, 0x33, 0x7C, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
;
;    // 0x22 -  .
;    {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3C, 0x00, 0x3C, 0x00, 0x00, 0x00,
;     0x00, 0x00, 0x3C, 0x00, 0x3C, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
;
;    // 0x23 - .
;    {0x00, 0x00, 0x00, 0x02, 0x10, 0x1E, 0x90, 0x1F, 0xF0, 0x03, 0x7E, 0x02,
;     0x1E, 0x1E, 0x90, 0x1F, 0xF0, 0x03, 0x7E, 0x02, 0x1E, 0x00, 0x10, 0x00},
;
;    // 0x24 - .
;    {0x00, 0x00, 0x00, 0x00, 0x78, 0x04, 0xFC, 0x0C, 0xCC, 0x0C, 0xFF, 0x3F,
;     0xFF, 0x3F, 0xCC, 0x0C, 0xCC, 0x0F, 0x88, 0x07, 0x00, 0x00, 0x00, 0x00},
;
;    // 0x25 - .
;    {0x00, 0x00, 0x00, 0x30, 0x38, 0x38, 0x38, 0x1C, 0x38, 0x0E, 0x00, 0x07,
;     0x80, 0x03, 0xC0, 0x01, 0xE0, 0x38, 0x70, 0x38, 0x38, 0x38, 0x1C, 0x00},
;
;    // 0x26 - .
;    {0x00, 0x00, 0x00, 0x00, 0x00, 0x1F, 0xB8, 0x3F, 0xFC, 0x31, 0xC6, 0x21,
;     0xE2, 0x37, 0x3E, 0x1E, 0x1C, 0x1C, 0x00, 0x36, 0x00, 0x22, 0x00, 0x00},
;
;    // 0x27 - .
;    {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x27, 0x00, 0x3F, 0x00,
;     0x1F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
;
;    // 0x28 -  .
;    {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xF0, 0x03, 0xFC, 0x0F, 0xFE, 0x1F,
;     0x07, 0x38, 0x01, 0x20, 0x01, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
;
;    // 0x29 -  .
;    {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x20, 0x01, 0x20, 0x07, 0x38,
;     0xFE, 0x1F, 0xFC, 0x0F, 0xF0, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
;
;    // 0x2A -  ().
;    {0x00, 0x00, 0x00, 0x00, 0x98, 0x0C, 0xB8, 0x0E, 0xE0, 0x03, 0xF8, 0x0F,
;     0xF8, 0x0F, 0xE0, 0x03, 0xB8, 0x0E, 0x98, 0x0C, 0x00, 0x00, 0x00, 0x00},
;
;    // 0x2B - .
;    {0x00, 0x00, 0x00, 0x00, 0x80, 0x01, 0x80, 0x01, 0x80, 0x01, 0xF0, 0x0F,
;     0xF0, 0x0F, 0x80, 0x01, 0x80, 0x01, 0x80, 0x01, 0x00, 0x00, 0x00, 0x00},
;
;    // 0x2C - .
;    {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xB8, 0x00, 0xF8,
;     0x00, 0x78, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
;
;    // 0x2D - .
;    {0x00, 0x00, 0x00, 0x00, 0x80, 0x01, 0x80, 0x01, 0x80, 0x01, 0x80, 0x01,
;     0x80, 0x01, 0x80, 0x01, 0x80, 0x01, 0x80, 0x01, 0x00, 0x00, 0x00, 0x00},
;
;    // 0x2E - .
;    {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x38, 0x00, 0x38,
;     0x00, 0x38, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
;
;    // 0x2F -  - ('/').
;    {0x00, 0x00, 0x00, 0x18, 0x00, 0x1C, 0x00, 0x0E, 0x00, 0x07, 0x80, 0x03,
;     0xC0, 0x01, 0xE0, 0x00, 0x70, 0x00, 0x38, 0x00, 0x1C, 0x00, 0x0E, 0x00},
;
;    // 0x30 - '0'  .
;//  {0x00, 0x00, 0xF8, 0x07, 0xFE, 0x1F, 0x06, 0x1E, 0x03, 0x33, 0x83, 0x31,
;//   0xC3, 0x30, 0x63, 0x30, 0x33, 0x30, 0x1E, 0x18, 0xFE, 0x1F, 0xF8, 0x07},
;    // 0x30 - '0'  .
;    {0x00, 0x00, 0xF8, 0x07, 0xFE, 0x1F, 0x06, 0x18, 0x03, 0x30, 0x03, 0x30,
;     0x03, 0x30, 0x03, 0x30, 0x03, 0x30, 0x06, 0x18, 0xFE, 0x1F, 0xF8, 0x07},
;
;    // 0x31 - '1'.
;    {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0C, 0x30, 0x0C, 0x30, 0x0E, 0x30,
;     0xFF, 0x3F, 0xFF, 0x3F, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x00},
;
;    // 0x32 - '2'.
;    {0x00, 0x00, 0x1C, 0x30, 0x1E, 0x38, 0x07, 0x3C, 0x03, 0x3E, 0x03, 0x37,
;     0x83, 0x33, 0xC3, 0x31, 0xE3, 0x30, 0x77, 0x30, 0x3E, 0x30, 0x1C, 0x30},
;
;    // 0x33 - '3'.
;    {0x00, 0x00, 0x0C, 0x0C, 0x0E, 0x1C, 0x07, 0x38, 0xC3, 0x30, 0xC3, 0x30,
;     0xC3, 0x30, 0xC3, 0x30, 0xC3, 0x30, 0xE7, 0x39, 0x7E, 0x1F, 0x3C, 0x0E},
;
;    // 0x34 - '4'.
;    {0x00, 0x00, 0xC0, 0x03, 0xE0, 0x03, 0x70, 0x03, 0x38, 0x03, 0x1C, 0x03,
;     0x0E, 0x03, 0x07, 0x03, 0xFF, 0x3F, 0xFF, 0x3F, 0x00, 0x03, 0x00, 0x03},
;
;    // 0x35 - '5'.
;    {0x00, 0x00, 0x3F, 0x0C, 0x7F, 0x1C, 0x63, 0x38, 0x63, 0x30, 0x63, 0x30,
;     0x63, 0x30, 0x63, 0x30, 0x63, 0x30, 0xE3, 0x38, 0xC3, 0x1F, 0x83, 0x0F},
;
;    // 0x36 - '6'.
;    {0x00, 0x00, 0xC0, 0x0F, 0xF0, 0x1F, 0xF8, 0x39, 0xDC, 0x30, 0xCE, 0x30,
;     0xC7, 0x30, 0xC3, 0x30, 0xC3, 0x30, 0xC3, 0x39, 0x80, 0x1F, 0x00, 0x0F},
;
;    // 0x37 - '7'.
;    {0x00, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x30, 0x03, 0x3C,
;     0x03, 0x0F, 0xC3, 0x03, 0xF3, 0x00, 0x3F, 0x00, 0x0F, 0x00, 0x03, 0x00},
;
;    // 0x38 - '8'.
;    {0x00, 0x00, 0x00, 0x0F, 0xBC, 0x1F, 0xFE, 0x39, 0xE7, 0x30, 0xC3, 0x30,
;     0xC3, 0x30, 0xC3, 0x30, 0xE7, 0x30, 0xFE, 0x39, 0xBC, 0x1F, 0x00, 0x0F},
;
;    // 0x39 - '9'.
;    {0x00, 0x00, 0x3C, 0x00, 0x7E, 0x00, 0xE7, 0x30, 0xC3, 0x30, 0xC3, 0x30,
;     0xC3, 0x38, 0xC3, 0x1C, 0xC3, 0x0E, 0xE7, 0x07, 0xFE, 0x03, 0xFC, 0x00},
;
;    // 0x3A - .
;    {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x70, 0x1C, 0x70, 0x1C,
;     0x70, 0x1C, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
;
;    // 0x3B -   .
;    {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x70, 0x9C, 0x70, 0xFC,
;     0x70, 0x7C, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
;
;    // 0x3C - .
;    {0x00, 0x00, 0x00, 0x00, 0xC0, 0x00, 0xE0, 0x01, 0xF0, 0x03, 0x38, 0x07,
;     0x1C, 0x0E, 0x0E, 0x1C, 0x07, 0x38, 0x03, 0x30, 0x00, 0x00, 0x00, 0x00},
;
;    // 0x3D - .
;    {0x00, 0x00, 0x00, 0x00, 0x60, 0x06, 0x60, 0x06, 0x60, 0x06, 0x60, 0x06,
;     0x60, 0x06, 0x60, 0x06, 0x60, 0x06, 0x60, 0x06, 0x60, 0x06, 0x00, 0x00},
;
;    // 0x3E - .
;    {0x00, 0x00, 0x00, 0x00, 0x03, 0x30, 0x07, 0x38, 0x0E, 0x1C, 0x1C, 0x0E,
;     0x38, 0x07, 0xF0, 0x03, 0xE0, 0x01, 0xC0, 0x00, 0x00, 0x00, 0x00, 0x00},
;
;    // 0x3F -  .
;    {0x00, 0x00, 0x1C, 0x00, 0x1E, 0x00, 0x07, 0x00, 0x03, 0x00, 0x83, 0x37,
;     0xC3, 0x37, 0xE3, 0x00, 0x77, 0x00, 0x3E, 0x00, 0x1C, 0x00, 0x00, 0x00},
;
;    // 0x40 - "" ('@').
;    {0x00, 0x00, 0xF8, 0x0F, 0xFE, 0x1F, 0x07, 0x18, 0xF3, 0x33, 0xFB, 0x37,
;     0x1B, 0x36, 0xFB, 0x37, 0xFB, 0x37, 0x07, 0x36, 0xFE, 0x03, 0xF8, 0x01},
;
;    // 0x41 - 'A'.
;    {0x00, 0x00, 0x00, 0x38, 0x00, 0x3F, 0xE0, 0x07, 0xFC, 0x06, 0x1F, 0x06,
;     0x1F, 0x06, 0xFC, 0x06, 0xE0, 0x07, 0x00, 0x3F, 0x00, 0x38, 0x00, 0x00},
;
;    // 0x42 - 'B'.
;    {0x00, 0x00, 0xFF, 0x3F, 0xFF, 0x3F, 0xC3, 0x30, 0xC3, 0x30, 0xC3, 0x30,
;     0xC3, 0x30, 0xE7, 0x30, 0xFE, 0x39, 0xBC, 0x1F, 0x00, 0x0F, 0x00, 0x00},
;
;    // 0x43 - 'C'.
;    {0x00, 0x00, 0xF0, 0x03, 0xFC, 0x0F, 0x0E, 0x1C, 0x07, 0x38, 0x03, 0x30,
;     0x03, 0x30, 0x03, 0x30, 0x07, 0x38, 0x0E, 0x1C, 0x0C, 0x0C, 0x00, 0x00},
;
;    // 0x44 - 'D'.
;    {0x00, 0x00, 0xFF, 0x3F, 0xFF, 0x3F, 0x03, 0x30, 0x03, 0x30, 0x03, 0x30,
;     0x03, 0x30, 0x07, 0x38, 0x0E, 0x1C, 0xFC, 0x0F, 0xF0, 0x03, 0x00, 0x00},
;
;    // 0x45 - 'E'.
;    {0x00, 0x00, 0xFF, 0x3F, 0xFF, 0x3F, 0xC3, 0x30, 0xC3, 0x30, 0xC3, 0x30,
;     0xC3, 0x30, 0xC3, 0x30, 0xC3, 0x30, 0x03, 0x30, 0x03, 0x30, 0x00, 0x00},
;
;    // 0x46 - 'F'.
;    {0x00, 0x00, 0xFF, 0x3F, 0xFF, 0x3F, 0xC3, 0x00, 0xC3, 0x00, 0xC3, 0x00,
;     0xC3, 0x00, 0xC3, 0x00, 0xC3, 0x00, 0x03, 0x00, 0x03, 0x00, 0x00, 0x00},
;
;    // 0x47 - 'G'.
;    {0x00, 0x00, 0xF0, 0x03, 0xFC, 0x0F, 0x0E, 0x1C, 0x07, 0x38, 0x03, 0x30,
;     0xC3, 0x30, 0xC3, 0x30, 0xC3, 0x30, 0xC7, 0x3F, 0xC6, 0x3F, 0x00, 0x00},
;
;    // 0x48 - 'H'.
;    {0x00, 0x00, 0xFF, 0x3F, 0xFF, 0x3F, 0xC0, 0x00, 0xC0, 0x00, 0xC0, 0x00,
;     0xC0, 0x00, 0xC0, 0x00, 0xC0, 0x00, 0xFF, 0x3F, 0xFF, 0x3F, 0x00, 0x00},
;
;    // 0x49 - 'I'.
;    {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0x30, 0x03, 0x30, 0xFF, 0x3F,
;     0xFF, 0x3F, 0x03, 0x30, 0x03, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
;
;    // 0x4A - 'J'.
;    {0x00, 0x00, 0x00, 0x0E, 0x00, 0x1E, 0x00, 0x38, 0x00, 0x30, 0x00, 0x30,
;     0x00, 0x30, 0x00, 0x30, 0x00, 0x38, 0xFF, 0x1F, 0xFF, 0x07, 0x00, 0x00},
;
;    // 0x4B - 'K'.
;    {0x00, 0x00, 0xFF, 0x3F, 0xFF, 0x3F, 0xC0, 0x00, 0xE0, 0x01, 0xF0, 0x03,
;     0x38, 0x07, 0x1C, 0x0E, 0x0E, 0x1C, 0x07, 0x38, 0x03, 0x30, 0x00, 0x00},
;
;    // 0x4C - 'L'.
;    {0x00, 0x00, 0xFF, 0x3F, 0xFF, 0x3F, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30,
;     0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x00},
;
;    // 0x4D - 'M'.
;    {0x00, 0x00, 0xFF, 0x3F, 0xFF, 0x3F, 0x1E, 0x00, 0x78, 0x00, 0xE0, 0x01,
;     0xE0, 0x01, 0x78, 0x00, 0x1E, 0x00, 0xFF, 0x3F, 0xFF, 0x3F, 0x00, 0x00},
;
;    // 0x4E - 'N'.
;    {0x00, 0x00, 0xFF, 0x3F, 0xFF, 0x3F, 0x0E, 0x00, 0x38, 0x00, 0xF0, 0x00,
;     0xC0, 0x03, 0x00, 0x07, 0x00, 0x1C, 0xFF, 0x3F, 0xFF, 0x3F, 0x00, 0x00},
;
;    // 0x4F - 'O'.
;    {0x00, 0x00, 0xF0, 0x03, 0xFC, 0x0F, 0x0E, 0x1C, 0x07, 0x38, 0x03, 0x30,
;     0x03, 0x30, 0x07, 0x38, 0x0E, 0x1C, 0xFC, 0x0F, 0xF0, 0x03, 0x00, 0x00},
;
;    // 0x50 - 'P'.
;    {0x00, 0x00, 0xFF, 0x3F, 0xFF, 0x3F, 0x83, 0x01, 0x83, 0x01, 0x83, 0x01,
;     0x83, 0x01, 0x83, 0x01, 0xC7, 0x01, 0xFE, 0x00, 0x7C, 0x00, 0x00, 0x00},
;
;    // 0x51 - 'Q'.
;    {0x00, 0x00, 0xF0, 0x03, 0xFC, 0x0F, 0x0E, 0x1C, 0x07, 0x38, 0x03, 0x30,
;     0x03, 0x36, 0x07, 0x3E, 0x0E, 0x1C, 0xFC, 0x3F, 0xF0, 0x33, 0x00, 0x00},
;
;    // 0x52 - 'R'.
;    {0x00, 0x00, 0xFF, 0x3F, 0xFF, 0x3F, 0x83, 0x01, 0x83, 0x01, 0x83, 0x03,
;     0x83, 0x07, 0x83, 0x0F, 0xC7, 0x1D, 0xFE, 0x38, 0x7C, 0x30, 0x00, 0x00},
;
;    // 0x53 - 'S'.
;    {0x00, 0x00, 0x3C, 0x0C, 0x7E, 0x1C, 0xE7, 0x38, 0xC3, 0x30, 0xC3, 0x30,
;     0xC3, 0x30, 0xC3, 0x30, 0xC7, 0x39, 0x8E, 0x1F, 0x0C, 0x0F, 0x00, 0x00},
;
;    // 0x54 - 'T'.
;    {0x00, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0xFF, 0x3F,
;     0xFF, 0x3F, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00},
;
;    // 0x55 - 'U'.
;    {0x00, 0x00, 0xFF, 0x07, 0xFF, 0x1F, 0x00, 0x38, 0x00, 0x30, 0x00, 0x30,
;     0x00, 0x30, 0x00, 0x30, 0x00, 0x38, 0xFF, 0x1F, 0xFF, 0x07, 0x00, 0x00},
;
;    // 0x56 - 'V'.
;    {0x00, 0x00, 0x07, 0x00, 0x3F, 0x00, 0xF8, 0x01, 0xC0, 0x0F, 0x00, 0x3E,
;     0x00, 0x3E, 0xC0, 0x0F, 0xF8, 0x01, 0x3F, 0x00, 0x07, 0x00, 0x00, 0x00},
;
;    // 0x57 - 'W'.
;    {0x00, 0x00, 0xFF, 0x3F, 0xFF, 0x3F, 0x00, 0x1C, 0x00, 0x06, 0x80, 0x03,
;     0x80, 0x03, 0x00, 0x06, 0x00, 0x1C, 0xFF, 0x3F, 0xFF, 0x3F, 0x00, 0x00},
;
;    // 0x58 - 'X'.
;    {0x00, 0x00, 0x03, 0x30, 0x0F, 0x3C, 0x1C, 0x0E, 0x30, 0x03, 0xE0, 0x01,
;     0xE0, 0x01, 0x30, 0x03, 0x1C, 0x0E, 0x0F, 0x3C, 0x03, 0x30, 0x00, 0x00},
;
;    // 0x59 - 'Y'.
;    {0x00, 0x00, 0x03, 0x00, 0x0F, 0x00, 0x3C, 0x00, 0xF0, 0x00, 0xC0, 0x3F,
;     0xC0, 0x3F, 0xF0, 0x00, 0x3C, 0x00, 0x0F, 0x00, 0x03, 0x00, 0x00, 0x00},
;
;    // 0x5A - 'Z'.
;    {0x00, 0x00, 0x03, 0x30, 0x03, 0x3C, 0x03, 0x3E, 0x03, 0x33, 0xC3, 0x31,
;     0xE3, 0x30, 0x33, 0x30, 0x1F, 0x30, 0x0F, 0x30, 0x03, 0x30, 0x00, 0x00},
;
;    // 0x5B - '['.
;    {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x3F, 0xFF, 0x3F, 0x03, 0x30,
;     0x03, 0x30, 0x03, 0x30, 0x03, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
;
;    // 0x5C - '\'.
;    {0x00, 0x00, 0x0E, 0x00, 0x1C, 0x00, 0x38, 0x00, 0x70, 0x00, 0xE0, 0x00,
;     0xC0, 0x01, 0x80, 0x03, 0x00, 0x07, 0x00, 0x0E, 0x00, 0x1C, 0x00, 0x18},
;
;    // 0x5D - ']'.
;    {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0x30, 0x03, 0x30, 0x03, 0x30,
;     0x03, 0x30, 0xFF, 0x3F, 0xFF, 0x3F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
;
;    // 0x5E - '^'.
;    {0x00, 0x00, 0x60, 0x00, 0x70, 0x00, 0x38, 0x00, 0x1C, 0x00, 0x0E, 0x00,
;     0x07, 0x00, 0x0E, 0x00, 0x1C, 0x00, 0x38, 0x00, 0x70, 0x00, 0x60, 0x00},
;
;    // 0x5F - '_'.
;    {0x00, 0x00, 0x00, 0xC0, 0x00, 0xC0, 0x00, 0xC0, 0x00, 0xC0, 0x00, 0xC0,
;     0x00, 0xC0, 0x00, 0xC0, 0x00, 0xC0, 0x00, 0xC0, 0x00, 0xC0, 0x00, 0xC0},
;
;    // 0x60 -  .
;    {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3E, 0x00,
;     0x7E, 0x00, 0x4E, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
;
;    // 0x61 - 'a'.
;    {0x00, 0x00, 0x00, 0x1C, 0x40, 0x3E, 0x60, 0x33, 0x60, 0x33, 0x60, 0x33,
;     0x60, 0x33, 0x60, 0x33, 0x60, 0x33, 0xE0, 0x3F, 0xC0, 0x3F, 0x00, 0x00},
;
;    // 0x62 - 'b'.
;    {0x00, 0x00, 0xFF, 0x3F, 0xFF, 0x3F, 0xC0, 0x30, 0x60, 0x30, 0x60, 0x30,
;     0x60, 0x30, 0x60, 0x30, 0xE0, 0x38, 0xC0, 0x1F, 0x80, 0x0F, 0x00, 0x00},
;
;    // 0x63 - 'c'.
;    {0x00, 0x00, 0x80, 0x0F, 0xC0, 0x1F, 0xE0, 0x38, 0x60, 0x30, 0x60, 0x30,
;     0x60, 0x30, 0x60, 0x30, 0x60, 0x30, 0xC0, 0x18, 0x80, 0x08, 0x00, 0x00},
;
;    // 0x64 - 'd'.
;    {0x00, 0x00, 0x80, 0x0F, 0xC0, 0x1F, 0xE0, 0x38, 0x60, 0x30, 0x60, 0x30,
;     0x60, 0x30, 0xE0, 0x30, 0xC0, 0x30, 0xFF, 0x3F, 0xFF, 0x3F, 0x00, 0x00},
;
;    // 0x65 - 'e'.
;    {0x00, 0x00, 0x80, 0x0F, 0xC0, 0x1F, 0xE0, 0x3B, 0x60, 0x33, 0x60, 0x33,
;     0x60, 0x33, 0x60, 0x33, 0x60, 0x33, 0xC0, 0x13, 0x80, 0x01, 0x00, 0x00},
;
;    // 0x66 - 'f'.
;    {0x00, 0x00, 0xC0, 0x00, 0xC0, 0x00, 0xFC, 0x3F, 0xFE, 0x3F, 0xC7, 0x00,
;     0xC3, 0x00, 0xC3, 0x00, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
;
;    // 0x67 - 'g'.
;    {0x00, 0x00, 0x80, 0x03, 0xC0, 0xC7, 0xE0, 0xCE, 0x60, 0xCC, 0x60, 0xCC,
;     0x60, 0xCC, 0x60, 0xCC, 0x60, 0xE6, 0xE0, 0x7F, 0xE0, 0x3F, 0x00, 0x00},
;
;    // 0x68 - 'h'.
;    {0x00, 0x00, 0xFF, 0x3F, 0xFF, 0x3F, 0xC0, 0x00, 0x60, 0x00, 0x60, 0x00,
;     0x60, 0x00, 0xE0, 0x00, 0xC0, 0x3F, 0x80, 0x3F, 0x00, 0x00, 0x00, 0x00},
;
;    // 0x69 - 'i'.
;    {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x60, 0x30, 0xEC, 0x3F,
;     0xEC, 0x3F, 0x00, 0x30, 0x00, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
;
;    // 0x6A - 'j'.
;    {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x60, 0x00, 0xE0, 0x00, 0xC0,
;     0x60, 0xC0, 0xEC, 0xFF, 0xEC, 0x7F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
;
;    // 0x6B - 'k'.
;    {0x00, 0x00, 0x00, 0x00, 0xFF, 0x3F, 0xFF, 0x3F, 0x00, 0x03, 0x80, 0x07,
;     0xC0, 0x0F, 0xE0, 0x1C, 0x60, 0x38, 0x00, 0x30, 0x00, 0x00, 0x00, 0x00},
;
;    // 0x6C - 'l'.
;    {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x03, 0x30, 0xFF, 0x3F,
;     0xFF, 0x3F, 0x00, 0x30, 0x00, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
;
;    // 0x6D - 'm'.
;    {0x00, 0x00, 0xE0, 0x3F, 0xC0, 0x3F, 0xE0, 0x00, 0xE0, 0x00, 0xC0, 0x3F,
;     0xC0, 0x3F, 0xE0, 0x00, 0xE0, 0x00, 0xC0, 0x3F, 0x80, 0x3F, 0x00, 0x00},
;
;    // 0x6E - 'n'.
;    {0x00, 0x00, 0x00, 0x00, 0xE0, 0x3F, 0xE0, 0x3F, 0x60, 0x00, 0x60, 0x00,
;     0x60, 0x00, 0x60, 0x00, 0xE0, 0x00, 0xC0, 0x3F, 0x80, 0x3F, 0x00, 0x00},
;
;    // 0x6F - 'o'.
;    {0x00, 0x00, 0x80, 0x0F, 0xC0, 0x1F, 0xE0, 0x38, 0x60, 0x30, 0x60, 0x30,
;     0x60, 0x30, 0x60, 0x30, 0xE0, 0x38, 0xC0, 0x1F, 0x80, 0x0F, 0x00, 0x00},
;
;    // 0x70 - 'p'.
;    {0x00, 0x00, 0xE0, 0xFF, 0xE0, 0xFF, 0x60, 0x0C, 0x60, 0x18, 0x60, 0x18,
;     0x60, 0x18, 0x60, 0x18, 0xE0, 0x1C, 0xC0, 0x0F, 0x80, 0x07, 0x00, 0x00},
;
;    // 0x71 - 'q'.
;    {0x00, 0x00, 0x80, 0x07, 0xC0, 0x0F, 0xE0, 0x1C, 0x60, 0x18, 0x60, 0x18,
;     0x60, 0x18, 0x60, 0x18, 0x60, 0x0C, 0xE0, 0xFF, 0xE0, 0xFF, 0x00, 0x00},
;
;    // 0x72 - 'r'.
;    {0x00, 0x00, 0x00, 0x00, 0xE0, 0x3F, 0xE0, 0x3F, 0xC0, 0x00, 0x60, 0x00,
;     0x60, 0x00, 0x60, 0x00, 0x60, 0x00, 0xE0, 0x00, 0xC0, 0x00, 0x00, 0x00},
;
;    // 0x73 - 's'.
;    {0x00, 0x00, 0xC0, 0x11, 0xE0, 0x33, 0x60, 0x33, 0x60, 0x33, 0x60, 0x33,
;     0x60, 0x33, 0x60, 0x3F, 0x40, 0x1E, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
;
;    // 0x74 - 't'.
;    {0x00, 0x00, 0x60, 0x00, 0x60, 0x00, 0xFE, 0x1F, 0xFE, 0x3F, 0x60, 0x30,
;     0x60, 0x30, 0x60, 0x30, 0x00, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
;
;    // 0x75 - 'u'.
;    {0x00, 0x00, 0xE0, 0x0F, 0xE0, 0x1F, 0x00, 0x38, 0x00, 0x30, 0x00, 0x30,
;     0x00, 0x30, 0x00, 0x30, 0x00, 0x18, 0xE0, 0x3F, 0xE0, 0x3F, 0x00, 0x00},
;
;    // 0x76 - 'v'.
;    {0x00, 0x00, 0x60, 0x00, 0xE0, 0x01, 0x80, 0x07, 0x00, 0x1E, 0x00, 0x38,
;     0x00, 0x38, 0x00, 0x1E, 0x80, 0x07, 0xE0, 0x01, 0x60, 0x00, 0x00, 0x00},
;
;    // 0x77 - 'w'.
;    {0x00, 0x00, 0xE0, 0x07, 0xE0, 0x1F, 0x00, 0x38, 0x00, 0x1C, 0xE0, 0x0F,
;     0xE0, 0x0F, 0x00, 0x1C, 0x00, 0x38, 0xE0, 0x1F, 0xE0, 0x07, 0x00, 0x00},
;
;    // 0x78 - 'x'.
;    {0x00, 0x00, 0x60, 0x30, 0xE0, 0x38, 0xC0, 0x1D, 0x80, 0x0F, 0x00, 0x07,
;     0x80, 0x0F, 0xC0, 0x1D, 0xE0, 0x38, 0x60, 0x30, 0x00, 0x00, 0x00, 0x00},
;
;    // 0x79 - 'y'.
;    {0x00, 0x00, 0x00, 0x00, 0x60, 0x00, 0xE0, 0x81, 0x80, 0xE7, 0x00, 0x7E,
;     0x00, 0x1E, 0x80, 0x07, 0xE0, 0x01, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00},
;
;    // 0x7A - 'z'.
;    {0x00, 0x00, 0x60, 0x30, 0x60, 0x38, 0x60, 0x3C, 0x60, 0x36, 0x60, 0x33,
;     0xE0, 0x31, 0xE0, 0x30, 0x60, 0x30, 0x20, 0x30, 0x00, 0x00, 0x00, 0x00},
;
;    // 0x7B - '{'.
;    {0x00, 0x00, 0x00, 0x00, 0x80, 0x00, 0xC0, 0x01, 0xFC, 0x1F, 0x7E, 0x3F,
;     0x07, 0x70, 0x03, 0x60, 0x03, 0x60, 0x03, 0x60, 0x00, 0x00, 0x00, 0x00},
;
;    // 0x7C - '|'.
;    {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x3F,
;     0xFF, 0x3F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
;
;    // 0x7D - '}'.
;    {0x00, 0x00, 0x00, 0x00, 0x03, 0x60, 0x03, 0x60, 0x03, 0x60, 0x07, 0x70,
;     0x7E, 0x3F, 0xFC, 0x1F, 0xC0, 0x01, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00},
;
;    // 0x7E - '~'.
;    {0x00, 0x00, 0x10, 0x00, 0x18, 0x00, 0x0C, 0x00, 0x04, 0x00, 0x0C, 0x00,
;     0x18, 0x00, 0x10, 0x00, 0x18, 0x00, 0x0C, 0x00, 0x04, 0x00, 0x00, 0x00},
;
;    // 0x7F - "".
;    {0x00, 0x00, 0x00, 0x0F, 0x80, 0x0F, 0xC0, 0x0C, 0x60, 0x0C, 0x30, 0x0C,
;     0x30, 0x0C, 0x60, 0x0C, 0xC0, 0x0C, 0x80, 0x0F, 0x00, 0x0F, 0x00, 0x00},
;
;    // 0x80 -    .
;    {0x55, 0x55, 0x00, 0x00, 0xAA, 0xAA, 0x00, 0x00, 0x55, 0x55, 0x00, 0x00,
;     0xAA, 0xAA, 0x00, 0x00, 0x55, 0x55, 0x00, 0x00, 0xAA, 0xAA, 0x00, 0x00},
;
;    // 0x81 -    .
;    {0xAA, 0xAA, 0x55, 0x55, 0xAA, 0xAA, 0x55, 0x55, 0xAA, 0xAA, 0x55, 0x55,
;     0xAA, 0xAA, 0x55, 0x55, 0xAA, 0xAA, 0x55, 0x55, 0xAA, 0xAA, 0x55, 0x55},
;
;    // 0x82 -   .
;    {0xAA, 0xAA, 0xFF, 0xFF, 0x55, 0x55, 0xFF, 0xFF, 0xAA, 0xAA, 0xFF, 0xFF,
;     0x55, 0x55, 0xFF, 0xFF, 0xAA, 0xAA, 0xFF, 0xFF, 0x55, 0x55, 0xFF, 0xFF},
;
;    // 0x83 -  -  .
;    {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF,
;     0xFF, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
;
;    // 0x84 -  -       .
;    {0x80, 0x01, 0x80, 0x01, 0x80, 0x01, 0x80, 0x01, 0x80, 0x01, 0xFF, 0xFF,
;     0xFF, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
;
;    // 0x85 -  -        .
;    {0xC0, 0x06, 0xC0, 0x06, 0xC0, 0x06, 0xC0, 0x06, 0xC0, 0x06, 0xFF, 0xFF,
;     0xFF, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
;
;    // 0x86 -  -        .
;    {0x80, 0x01, 0x80, 0x01, 0xFF, 0xFF, 0xFF, 0xFF, 0x00, 0x00, 0xFF, 0xFF,
;     0xFF, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
;
;    // 0x87 -  -       .
;    {0x80, 0x01, 0x80, 0x01, 0x80, 0xFF, 0x80, 0xFF, 0x80, 0x01, 0x80, 0xFF,
;     0x80, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
;
;    // 0x88 -  -       .
;    {0xC0, 0x06, 0xC0, 0x06, 0xC0, 0x06, 0xC0, 0x06, 0xC0, 0x06, 0xC0, 0xFF,
;     0xC0, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
;
;    // 0x89 -  -         .
;    {0xC0, 0x06, 0xC0, 0x06, 0xFF, 0xFE, 0xFF, 0xFE, 0x00, 0x00, 0xFF, 0xFF,
;     0xFF, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
;
;    // 0x8A -  -   .
;    {0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0xFF, 0xFF, 0x00, 0x00, 0xFF, 0xFF,
;     0xFF, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
;
;    // 0x8B -  -    .
;    {0xC0, 0x06, 0xC0, 0x06, 0xC0, 0xFE, 0xC0, 0xFE, 0xC0, 0x00, 0xC0, 0xFF,
;     0xC0, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
;
;    // 0x8C -  -    .
;    {0xC0, 0x06, 0xC0, 0x06, 0xFF, 0x06, 0xFF, 0x06, 0x00, 0x06, 0xFF, 0x07,
;     0xFF, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
;
;    // 0x8D -  -       .
;    {0x80, 0x01, 0x80, 0x01, 0xFF, 0x01, 0xFF, 0x01, 0x80, 0x01, 0xFF, 0x01,
;     0xFF, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
;
;    // 0x8E -  -       .
;    {0xC0, 0x06, 0xC0, 0x06, 0xC0, 0x06, 0xC0, 0x06, 0xC0, 0x06, 0xFF, 0x07,
;     0xFF, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
;
;    // 0x8F -  -   .
;    {0x80, 0x01, 0x80, 0x01, 0x80, 0x01, 0x80, 0x01, 0x80, 0x01, 0x80, 0xFF,
;     0x80, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
;
;    // 0x90 -  -   .
;    {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x01,
;     0xFF, 0x01, 0x80, 0x01, 0x80, 0x01, 0x80, 0x01, 0x80, 0x01, 0x80, 0x01},
;
;    // 0x91 -  -       .
;    {0x80, 0x01, 0x80, 0x01, 0x80, 0x01, 0x80, 0x01, 0x80, 0x01, 0xFF, 0x01,
;     0xFF, 0x01, 0x80, 0x01, 0x80, 0x01, 0x80, 0x01, 0x80, 0x01, 0x80, 0x01},
;
;    // 0x92 -  -       .
;    {0x80, 0x01, 0x80, 0x01, 0x80, 0x01, 0x80, 0x01, 0x80, 0x01, 0x80, 0xFF,
;     0x80, 0xFF, 0x80, 0x01, 0x80, 0x01, 0x80, 0x01, 0x80, 0x01, 0x80, 0x01},
;
;    // 0x93 -  -       .
;    {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF,
;     0xFF, 0xFF, 0x80, 0x01, 0x80, 0x01, 0x80, 0x01, 0x80, 0x01, 0x80, 0x01},
;
;    // 0x94 -  -    .
;    {0x80, 0x01, 0x80, 0x01, 0x80, 0x01, 0x80, 0x01, 0x80, 0x01, 0x80, 0x01,
;     0x80, 0x01, 0x80, 0x01, 0x80, 0x01, 0x80, 0x01, 0x80, 0x01, 0x80, 0x01},
;
;    // 0x95 -  - .
;    {0x80, 0x01, 0x80, 0x01, 0x80, 0x01, 0x80, 0x01, 0x80, 0x01, 0xFF, 0xFF,
;     0xFF, 0xFF, 0x80, 0x01, 0x80, 0x01, 0x80, 0x01, 0x80, 0x01, 0x80, 0x01},
;
;    // 0x96 -  -        .
;    {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF,
;     0xFF, 0xFF, 0xC0, 0x06, 0xC0, 0x06, 0xC0, 0x06, 0xC0, 0x06, 0xC0, 0x06},
;
;    // 0x97 -  -        .
;    {0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0xFF, 0xFF, 0x00, 0x00, 0xFF, 0xFF,
;     0xFF, 0xFF, 0x80, 0x01, 0x80, 0x01, 0x80, 0x01, 0x80, 0x01, 0x80, 0x01},
;
;    // 0x98 -  -    .
;    {0x00, 0x00, 0x00, 0x00, 0xFF, 0x07, 0xFF, 0x07, 0x00, 0x06, 0xFF, 0x06,
;     0xFF, 0x06, 0xC0, 0x06, 0xC0, 0x06, 0xC0, 0x06, 0xC0, 0x06, 0xC0, 0x06},
;
;    // 0x99 -  -    .
;    {0x00, 0x00, 0x00, 0x00, 0xC0, 0xFF, 0xC0, 0xFF, 0xC0, 0x00, 0xC0, 0xFE,
;     0xC0, 0xFE, 0xC0, 0x06, 0xC0, 0x06, 0xC0, 0x06, 0xC0, 0x06, 0xC0, 0x06},
;
;    // 0x9A -  -         .
;    {0xC0, 0x06, 0xC0, 0x06, 0xFF, 0x06, 0xFF, 0x06, 0x00, 0x06, 0xFF, 0x06,
;     0xFF, 0x06, 0xC0, 0x06, 0xC0, 0x06, 0xC0, 0x06, 0xC0, 0x06, 0xC0, 0x06},
;
;    // 0x9B -  -         .
;    {0xC0, 0x06, 0xC0, 0x06, 0xC0, 0xFE, 0xC0, 0xFE, 0xC0, 0x00, 0xC0, 0xFE,
;     0xC0, 0xFE, 0xC0, 0x06, 0xC0, 0x06, 0xC0, 0x06, 0xC0, 0x06, 0xC0, 0x06},
;
;    // 0x9C -  -         .
;    {0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0xFF, 0xFF, 0x00, 0x00, 0xFF, 0xFE,
;     0xFF, 0xFE, 0xC0, 0x06, 0xC0, 0x06, 0xC0, 0x06, 0xC0, 0x06, 0xC0, 0x06},
;
;    // 0x9D -  -     .
;    {0xC0, 0x06, 0xC0, 0x06, 0xC0, 0x06, 0xC0, 0x06, 0xC0, 0x06, 0xC0, 0x06,
;     0xC0, 0x06, 0xC0, 0x06, 0xC0, 0x06, 0xC0, 0x06, 0xC0, 0x06, 0xC0, 0x06},
;
;    // 0x9E -  -  .
;    {0xC0, 0x06, 0xC0, 0x06, 0xFF, 0xFE, 0xFF, 0xFE, 0x00, 0x00, 0xFF, 0xFE,
;     0xFF, 0xFE, 0xC0, 0x06, 0xC0, 0x06, 0xC0, 0x06, 0xC0, 0x06, 0xC0, 0x06},
;
;    // 0x9F -  -        .
;    {0xC0, 0x06, 0xC0, 0x06, 0xC0, 0x06, 0xC0, 0x06, 0xC0, 0x06, 0xFF, 0x06,
;     0xFF, 0x06, 0xC0, 0x06, 0xC0, 0x06, 0xC0, 0x06, 0xC0, 0x06, 0xC0, 0x06},
;
;    // 0xA0 -  -        .
;    {0x80, 0x01, 0x80, 0x01, 0xFF, 0x01, 0xFF, 0x01, 0x80, 0x01, 0xFF, 0x01,
;     0xFF, 0x01, 0x80, 0x01, 0x80, 0x01, 0x80, 0x01, 0x80, 0x01, 0x80, 0x01},
;
;    // 0xA1 -  -        .
;    {0xC0, 0x06, 0xC0, 0x06, 0xC0, 0x06, 0xC0, 0x06, 0xC0, 0x06, 0xC0, 0xFE,
;     0xC0, 0xFE, 0xC0, 0x06, 0xC0, 0x06, 0xC0, 0x06, 0xC0, 0x06, 0xC0, 0x06},
;
;    // 0xA2 -  -        .
;    {0x80, 0x01, 0x80, 0x01, 0x80, 0xFF, 0x80, 0xFF, 0x80, 0x01, 0x80, 0xFF,
;     0x80, 0xFF, 0x80, 0x01, 0x80, 0x01, 0x80, 0x01, 0x80, 0x01, 0x80, 0x01},
;
;    // 0xA3 -  -   ,   .
;    {0x00, 0x00, 0x00, 0x00, 0xFF, 0x01, 0xFF, 0x01, 0x80, 0x01, 0xFF, 0x01,
;     0xFF, 0x01, 0x80, 0x01, 0x80, 0x01, 0x80, 0x01, 0x80, 0x01, 0x80, 0x01},
;
;    // 0xA4 -  -   ,   .
;    {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x07,
;     0xFF, 0x07, 0xC0, 0x06, 0xC0, 0x06, 0xC0, 0x06, 0xC0, 0x06, 0xC0, 0x06},
;
;    // 0xA5 -  -   ,   .
;    {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xC0, 0xFF,
;     0xC0, 0xFF, 0xC0, 0x06, 0xC0, 0x06, 0xC0, 0x06, 0xC0, 0x06, 0xC0, 0x06},
;
;    // 0xA6 -  -   ,   .
;    {0x00, 0x00, 0x00, 0x00, 0x80, 0xFF, 0x80, 0xFF, 0x80, 0x01, 0x80, 0xFF,
;     0x80, 0xFF, 0x80, 0x01, 0x80, 0x01, 0x80, 0x01, 0x80, 0x01, 0x80, 0x01},
;
;    // 0xA7 -  -          .
;    {0x80, 0x01, 0x80, 0x01, 0xFF, 0xFF, 0xFF, 0xFF, 0x00, 0x00, 0xFF, 0xFF,
;     0xFF, 0xFF, 0x80, 0x01, 0x80, 0x01, 0x80, 0x01, 0x80, 0x01, 0x80, 0x01},
;
;    // 0xA8 - ''.
;    {0x00, 0x00, 0xF8, 0x3F, 0xF8, 0x3F, 0x9B, 0x31, 0x9B, 0x31, 0x98, 0x31,
;     0x98, 0x31, 0x9B, 0x31, 0x9B, 0x31, 0x18, 0x30, 0x18, 0x30, 0x00, 0x00},
;
;    // 0xA9 -  -          .
;    {0xC0, 0x06, 0xC0, 0x06, 0xC0, 0x06, 0xC0, 0x06, 0xC0, 0x06, 0xFF, 0xFE,
;     0xFF, 0xFE, 0xC0, 0x06, 0xC0, 0x06, 0xC0, 0x06, 0xC0, 0x06, 0xC0, 0x06},
;
;    // 0xAA -  -   .
;    {0x80, 0x01, 0x80, 0x01, 0x80, 0x01, 0x80, 0x01, 0x80, 0x01, 0xFF, 0x01,
;     0xFF, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
;
;    // 0xAB -  -   .
;    {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0xFF,
;     0x80, 0xFF, 0x80, 0x01, 0x80, 0x01, 0x80, 0x01, 0x80, 0x01, 0x80, 0x01},
;
;    // 0xAC -  -  .
;    {0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
;     0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF},
;
;    // 0xAD -  -    .
;    {0x00, 0xFF, 0x00, 0xFF, 0x00, 0xFF, 0x00, 0xFF, 0x00, 0xFF, 0x00, 0xFF,
;     0x00, 0xFF, 0x00, 0xFF, 0x00, 0xFF, 0x00, 0xFF, 0x00, 0xFF, 0x00, 0xFF},
;
;    // 0xAE -  -    .
;    {0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
;     0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
;
;    // 0xAF -  -    .
;    {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
;     0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF},
;
;    // 0xB0 -  -    .
;    {0xFF, 0x00, 0xFF, 0x00, 0xFF, 0x00, 0xFF, 0x00, 0xFF, 0x00, 0xFF, 0x00,
;     0xFF, 0x00, 0xFF, 0x00, 0xFF, 0x00, 0xFF, 0x00, 0xFF, 0x00, 0xFF, 0x00},
;
;    // 0xB1 -  (,   ).
;    {0x00, 0x00, 0x00, 0x00, 0xF0, 0x00, 0x08, 0x01, 0x08, 0x02, 0x10, 0x04,
;     0x20, 0x08, 0x10, 0x04, 0x08, 0x02, 0x08, 0x01, 0xF0, 0x00, 0x00, 0x00},
;
;    // 0xB2 -  .
;    {0x00, 0x00, 0xE0, 0x01, 0xF0, 0x03, 0xF0, 0x07, 0xF0, 0x07, 0xE8, 0x07,
;     0xE4, 0x07, 0xE4, 0x07, 0xE4, 0x07, 0xE4, 0x07, 0xE8, 0x03, 0xF0, 0x01},
;
;    // 0xB3 -   .
;    {0x00, 0x00, 0xE0, 0x01, 0x30, 0x02, 0x30, 0x04, 0x30, 0x04, 0x28, 0x04,
;     0x24, 0x04, 0x24, 0x04, 0x24, 0x04, 0x24, 0x04, 0x28, 0x02, 0xF0, 0x01},
;
;    // 0xB4 -  : "".
;    {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x00, 0x70, 0x00,
;     0x08, 0x00, 0xF8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
;
;    // 0xB5 -  : "/".
;    {0x00, 0x00, 0x80, 0x00, 0x80, 0x00, 0x80, 0x00, 0xA0, 0x06, 0x9C, 0x08,
;     0x82, 0x08, 0xBE, 0x3E, 0x80, 0x00, 0x80, 0x00, 0x80, 0x00, 0x00, 0x00},
;
;    // 0xB6 - 'y'    ('~').
;    {0x00, 0x00, 0x00, 0x00, 0x60, 0x00, 0xE8, 0x81, 0x88, 0xE7, 0x10, 0x7E,
;     0x10, 0x1E, 0x88, 0x07, 0xE8, 0x01, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00},
;
;    // 0xB7 -   .
;    {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1E, 0x00, 0x3F, 0x00, 0x33, 0x00,
;     0x33, 0x00, 0x3F, 0x00, 0x1E, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
;
;    // 0xB8 - ''.
;    {0x00, 0x00, 0x80, 0x0F, 0xC0, 0x1F, 0xEC, 0x33, 0x6C, 0x33, 0x60, 0x33,
;     0x60, 0x33, 0x6C, 0x33, 0x6C, 0x33, 0xC0, 0x13, 0x80, 0x03, 0x00, 0x00},
;
;    // 0xB9 -     .
;    {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xC0, 0x03, 0xE0, 0x07, 0xE0, 0x07,
;     0xE0, 0x07, 0xE0, 0x07, 0xC0, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
;
;    // 0xBA -     .
;    {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x01,
;     0xC0, 0x03, 0x80, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
;
;    // 0xBB -   .
;    {0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0x00, 0x06, 0x00, 0x0C, 0x00, 0x18,
;     0xFE, 0x3F, 0xFE, 0x3F, 0x06, 0x00, 0x06, 0x00, 0x06, 0x00, 0x06, 0x00},
;
;    // 0xBC - ''.
;    {0xFF, 0x3F, 0xFF, 0x3F, 0x1E, 0x00, 0xF0, 0x00, 0x80, 0x03, 0x00, 0x1E,
;     0xFF, 0x3F, 0xFF, 0x3F, 0x1C, 0x03, 0x36, 0x03, 0x36, 0x03, 0x1C, 0x03},
;
;    // 0xBD - "".
;    {0x00, 0x00, 0xF6, 0x1B, 0xFE, 0x1F, 0x18, 0x06, 0x0C, 0x0C, 0x0C, 0x0C,
;     0x0C, 0x0C, 0x0C, 0x0C, 0x18, 0x06, 0xFE, 0x1F, 0xF6, 0x1B, 0x00, 0x00},
;
;    // 0xBE -    .
;    {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xF0, 0x03, 0xF0, 0x03,
;     0xF0, 0x03, 0xF0, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
;
;    // 0xBF -  .
;    {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
;     0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
;
;    // 0xC0 - ''.
;    {0x00, 0x00, 0xF0, 0x3F, 0xFC, 0x3F, 0x0E, 0x03, 0x07, 0x03, 0x03, 0x03,
;     0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0xFF, 0x3F, 0xFF, 0x3F, 0x00, 0x00},
;
;    // 0xC1 - ''.
;    {0x00, 0x00, 0xFF, 0x3F, 0xFF, 0x3F, 0xC3, 0x30, 0xC3, 0x30, 0xC3, 0x30,
;     0xC3, 0x30, 0xC3, 0x30, 0xC3, 0x39, 0x83, 0x1F, 0x03, 0x0F, 0x00, 0x00},
;
;    // 0xC2 - ''.
;    {0x00, 0x00, 0xFF, 0x3F, 0xFF, 0x3F, 0xC3, 0x30, 0xC3, 0x30, 0xC3, 0x30,
;     0xC3, 0x30, 0xE7, 0x30, 0xFE, 0x39, 0xBC, 0x1F, 0x00, 0x0F, 0x00, 0x00},
;
;    // 0xC3 - ''.
;    {0x00, 0x00, 0xFF, 0x3F, 0xFF, 0x3F, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00,
;     0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x00, 0x00},
;
;    // 0xC4 - ''.
;    {0x00, 0xF0, 0xF0, 0xFF, 0xFC, 0x3F, 0x0E, 0x30, 0x07, 0x30, 0x03, 0x30,
;     0x03, 0x30, 0x03, 0x30, 0x03, 0x30, 0xFF, 0x3F, 0xFF, 0xFF, 0x00, 0xF0},
;
;    // 0xC5 - ''.
;    {0x00, 0x00, 0xFF, 0x3F, 0xFF, 0x3F, 0xC3, 0x30, 0xC3, 0x30, 0xC3, 0x30,
;     0xC3, 0x30, 0xC3, 0x30, 0xC3, 0x30, 0x03, 0x30, 0x03, 0x30, 0x00, 0x00},
;
;    // 0xC6 - ''.
;    {0x0F, 0x3C, 0x3E, 0x1F, 0xF8, 0x07, 0xE0, 0x01, 0xC0, 0x00, 0xFF, 0x3F,
;     0xFF, 0x3F, 0xC0, 0x00, 0xE0, 0x01, 0xF8, 0x07, 0x1E, 0x1F, 0x07, 0x3C},
;
;    // 0xC7 - ''.
;    {0x00, 0x00, 0x0C, 0x0C, 0x0E, 0x1C, 0x07, 0x38, 0xC3, 0x30, 0xC3, 0x30,
;     0xC3, 0x30, 0xC3, 0x30, 0xC3, 0x30, 0xE7, 0x39, 0x7E, 0x1F, 0x3C, 0x0E},
;
;    // 0xC8 - ''.
;    {0x00, 0x00, 0xFF, 0x3F, 0xFF, 0x3F, 0x00, 0x1C, 0x00, 0x07, 0xC0, 0x03,
;     0xF0, 0x00, 0x38, 0x00, 0x0E, 0x00, 0xFF, 0x3F, 0xFF, 0x3F, 0x00, 0x00},
;
;    // 0xC9 - ''.
;    {0x00, 0x00, 0xFF, 0x3F, 0xFF, 0x3F, 0x00, 0x1C, 0x00, 0x07, 0xC6, 0x03,
;     0xF3, 0x00, 0x38, 0x00, 0x0E, 0x00, 0xFF, 0x3F, 0xFF, 0x3F, 0x00, 0x00},
;
;    // 0xCA - ''.
;    {0x00, 0x00, 0xFF, 0x3F, 0xFF, 0x3F, 0xC0, 0x00, 0xE0, 0x01, 0xF0, 0x03,
;     0x38, 0x07, 0x1C, 0x0E, 0x0E, 0x1C, 0x07, 0x38, 0x03, 0x30, 0x00, 0x00},
;
;    // 0xCB - ''.
;    {0x00, 0x00, 0xF0, 0x3F, 0xFC, 0x3F, 0x0E, 0x00, 0x07, 0x00, 0x03, 0x00,
;     0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0xFF, 0x3F, 0xFF, 0x3F, 0x00, 0x00},
;
;    // 0xCC - ''.
;    {0x00, 0x00, 0xFF, 0x3F, 0xFF, 0x3F, 0x1E, 0x00, 0x78, 0x00, 0xE0, 0x01,
;     0xE0, 0x01, 0x78, 0x00, 0x1E, 0x00, 0xFF, 0x3F, 0xFF, 0x3F, 0x00, 0x00},
;
;    // 0xCD - ''.
;    {0x00, 0x00, 0xFF, 0x3F, 0xFF, 0x3F, 0xC0, 0x00, 0xC0, 0x00, 0xC0, 0x00,
;     0xC0, 0x00, 0xC0, 0x00, 0xC0, 0x00, 0xFF, 0x3F, 0xFF, 0x3F, 0x00, 0x00},
;
;    // 0xCE - ''.
;    {0x00, 0x00, 0xF0, 0x03, 0xFC, 0x0F, 0x0E, 0x1C, 0x07, 0x38, 0x03, 0x30,
;     0x03, 0x30, 0x07, 0x38, 0x0E, 0x1C, 0xFC, 0x0F, 0xF0, 0x03, 0x00, 0x00},
;
;    // 0xCF - ''.
;    {0x00, 0x00, 0xFF, 0x3F, 0xFF, 0x3F, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00,
;     0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0xFF, 0x3F, 0xFF, 0x3F, 0x00, 0x00},
;
;    // 0xD0 - ''.
;    {0x00, 0x00, 0xFF, 0x3F, 0xFF, 0x3F, 0x83, 0x01, 0x83, 0x01, 0x83, 0x01,
;     0x83, 0x01, 0x83, 0x01, 0xC7, 0x01, 0xFE, 0x00, 0x7C, 0x00, 0x00, 0x00},
;
;    // 0xD1 - ''.
;    {0x00, 0x00, 0xF0, 0x03, 0xFC, 0x0F, 0x0E, 0x1C, 0x07, 0x38, 0x03, 0x30,
;     0x03, 0x30, 0x03, 0x30, 0x07, 0x38, 0x0E, 0x1C, 0x0C, 0x0C, 0x00, 0x00},
;
;    // 0xD2 - ''.
;    {0x00, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0xFF, 0x3F,
;     0xFF, 0x3F, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00},
;
;    // 0xD3 - ''.
;    {0x00, 0x00, 0x7F, 0x18, 0xFF, 0x38, 0xC0, 0x30, 0xC0, 0x30, 0xC0, 0x30,
;     0xC0, 0x30, 0xC0, 0x30, 0xC0, 0x38, 0xFF, 0x1F, 0xFF, 0x07, 0x00, 0x00},
;
;    // 0xD4 - ''.
;    {0x00, 0x00, 0xF8, 0x03, 0xFC, 0x07, 0x0C, 0x06, 0x0C, 0x06, 0xFF, 0x3F,
;     0xFF, 0x3F, 0x0C, 0x06, 0x0C, 0x06, 0xFC, 0x07, 0xF8, 0x03, 0x00, 0x00},
;
;    // 0xD5 - ''.
;    {0x00, 0x00, 0x03, 0x30, 0x0F, 0x3C, 0x1C, 0x0E, 0x30, 0x03, 0xE0, 0x01,
;     0xE0, 0x01, 0x30, 0x03, 0x1C, 0x0E, 0x0F, 0x3C, 0x03, 0x30, 0x00, 0x00},
;
;    // 0xD6 - ''.
;    {0x00, 0x00, 0xFF, 0x3F, 0xFF, 0x3F, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30,
;     0x00, 0x30, 0x00, 0x30, 0xFF, 0x3F, 0xFF, 0xFF, 0x00, 0xF0, 0x00, 0x00},
;
;    // 0xD7 - ''.
;    {0x00, 0x00, 0x7F, 0x00, 0xFF, 0x00, 0xC0, 0x00, 0xC0, 0x00, 0xC0, 0x00,
;     0xC0, 0x00, 0xC0, 0x00, 0xC0, 0x00, 0xFF, 0x3F, 0xFF, 0x3F, 0x00, 0x00},
;
;    // 0xD8 - ''.
;    {0x00, 0x00, 0xFF, 0x3F, 0xFF, 0x3F, 0x00, 0x30, 0x00, 0x30, 0xFF, 0x3F,
;     0xFF, 0x3F, 0x00, 0x30, 0x00, 0x30, 0xFF, 0x3F, 0xFF, 0x3F, 0x00, 0x00},
;
;    // 0xD9 - ''.
;    {0x00, 0x00, 0xFF, 0x3F, 0xFF, 0x3F, 0x00, 0x30, 0x00, 0x30, 0xFF, 0x3F,
;     0xFF, 0x3F, 0x00, 0x30, 0x00, 0x30, 0xFF, 0x3F, 0xFF, 0xFF, 0x00, 0xF0},
;
;    // 0xDA - ''.
;    {0x0F, 0x00, 0x0F, 0x00, 0x03, 0x00, 0xFF, 0x3F, 0xFF, 0x3F, 0x60, 0x30,
;     0x60, 0x30, 0x60, 0x30, 0xE0, 0x38, 0xC0, 0x1F, 0x80, 0x0F, 0x00, 0x00},
;
;    // 0xDB - ''.
;    {0x00, 0x00, 0xFF, 0x3F, 0xFF, 0x3F, 0x60, 0x30, 0x60, 0x30, 0xE0, 0x38,
;     0xC0, 0x1F, 0x80, 0x0F, 0x00, 0x00, 0xFF, 0x3F, 0xFF, 0x3F, 0x00, 0x00},
;
;    // 0xDC - ''.
;    {0x00, 0x00, 0xFF, 0x3F, 0xFF, 0x3F, 0x60, 0x30, 0x60, 0x30, 0x60, 0x30,
;     0x60, 0x30, 0x60, 0x30, 0xE0, 0x38, 0xC0, 0x1F, 0x80, 0x0F, 0x00, 0x00},
;
;    // 0xDD - ''.
;    {0x00, 0x00, 0x0C, 0x0C, 0x0E, 0x1C, 0x07, 0x38, 0xC3, 0x30, 0xC3, 0x30,
;     0xC3, 0x30, 0xC7, 0x38, 0xCE, 0x1C, 0xFC, 0x0F, 0xF0, 0x03, 0x00, 0x00},
;
;    // 0xDE - ''.
;    {0xFF, 0x3F, 0xFF, 0x3F, 0xC0, 0x00, 0xF0, 0x03, 0xFC, 0x0F, 0x0E, 0x1C,
;     0x07, 0x38, 0x03, 0x30, 0x07, 0x38, 0x0E, 0x1C, 0xFC, 0x0F, 0xF0, 0x03},
;
;    // 0xDF - ''.
;    {0x00, 0x00, 0x7C, 0x30, 0xFE, 0x38, 0xC7, 0x1D, 0x83, 0x0F, 0x83, 0x07,
;     0x83, 0x03, 0x83, 0x01, 0x83, 0x01, 0xFF, 0x3F, 0xFF, 0x3F, 0x00, 0x00},
;
;    // 0xE0 - ''.
;    {0x00, 0x00, 0x00, 0x1C, 0x40, 0x3E, 0x60, 0x33, 0x60, 0x33, 0x60, 0x33,
;     0x60, 0x33, 0x60, 0x33, 0x60, 0x33, 0xE0, 0x3F, 0xC0, 0x3F, 0x00, 0x00},
;
;    // 0xE1 - ''.
;    {0x00, 0x00, 0xF0, 0x1F, 0xF8, 0x3F, 0x98, 0x31, 0xD8, 0x30, 0xD8, 0x30,
;     0xD8, 0x30, 0xD8, 0x30, 0xD8, 0x39, 0x8C, 0x1F, 0x00, 0x0F, 0x00, 0x00},
;
;    // 0xE2 - ''.
;    {0x00, 0x00, 0x00, 0x00, 0xE0, 0x3F, 0xE0, 0x3F, 0x60, 0x32, 0x60, 0x32,
;     0x60, 0x32, 0x60, 0x32, 0xE0, 0x3F, 0xC0, 0x1D, 0x00, 0x00, 0x00, 0x00},
;
;    // 0xE3 - ''.
;    {0x00, 0x00, 0x00, 0x00, 0xE0, 0x3F, 0xE0, 0x3F, 0x60, 0x00, 0x60, 0x00,
;     0x60, 0x00, 0x60, 0x00, 0x60, 0x00, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00},
;
;    // 0xE4 - ''.
;    {0x00, 0x00, 0x00, 0xF0, 0x80, 0xFF, 0xC0, 0x3F, 0x60, 0x30, 0x60, 0x30,
;     0x60, 0x30, 0x60, 0x30, 0xE0, 0x3F, 0xE0, 0xFF, 0x00, 0xF0, 0x00, 0x00},
;
;    // 0xE5 - ''.
;    {0x00, 0x00, 0x80, 0x0F, 0xC0, 0x1F, 0xE0, 0x3B, 0x60, 0x33, 0x60, 0x33,
;     0x60, 0x33, 0x60, 0x33, 0x60, 0x33, 0xC0, 0x13, 0x80, 0x01, 0x00, 0x00},
;
;    // 0xE6 - ''.
;    {0x60, 0x30, 0xE0, 0x38, 0xC0, 0x1F, 0x80, 0x07, 0x00, 0x03, 0xE0, 0x3F,
;     0xE0, 0x3F, 0x00, 0x03, 0x80, 0x07, 0xC0, 0x1F, 0xE0, 0x38, 0x60, 0x30},
;
;    // 0xE7 - ''.
;    {0x00, 0x00, 0x00, 0x00, 0x80, 0x08, 0xC0, 0x18, 0x60, 0x30, 0x60, 0x32,
;     0x60, 0x32, 0x60, 0x32, 0xC0, 0x1F, 0x80, 0x0D, 0x00, 0x00, 0x00, 0x00},
;
;    // 0xE8 - ''.
;    {0x00, 0x00, 0x00, 0x00, 0xE0, 0x3F, 0xE0, 0x3F, 0x00, 0x18, 0x00, 0x0C,
;     0x00, 0x06, 0x00, 0x03, 0x80, 0x01, 0xE0, 0x3F, 0xE0, 0x3F, 0x00, 0x00},
;
;    // 0xE9 - ''.
;    {0x00, 0x00, 0x00, 0x00, 0xE0, 0x3F, 0xE0, 0x3F, 0x00, 0x18, 0x00, 0x0C,
;     0x18, 0x06, 0x0C, 0x03, 0x80, 0x01, 0xE0, 0x3F, 0xE0, 0x3F, 0x00, 0x00},
;
;    // 0xEA - ''.
;    {0x00, 0x00, 0x00, 0x00, 0xE0, 0x3F, 0xE0, 0x3F, 0x00, 0x03, 0x80, 0x07,
;     0xC0, 0x0F, 0xE0, 0x1C, 0x60, 0x38, 0x00, 0x30, 0x00, 0x00, 0x00, 0x00},
;
;    // 0xEB - ''.
;    {0x00, 0x00, 0x00, 0x00, 0x80, 0x3F, 0xC0, 0x3F, 0x60, 0x00, 0x60, 0x00,
;     0x60, 0x00, 0x60, 0x00, 0xE0, 0x3F, 0xE0, 0x3F, 0x00, 0x00, 0x00, 0x00},
;
;    // 0xEC - ''.
;    {0x00, 0x00, 0xE0, 0x3F, 0xE0, 0x3F, 0xE0, 0x00, 0xC0, 0x01, 0x00, 0x03,
;     0x00, 0x03, 0xC0, 0x01, 0xE0, 0x00, 0xE0, 0x3F, 0xE0, 0x3F, 0x00, 0x00},
;
;    // 0xED - ''.
;    {0x00, 0x00, 0x00, 0x00, 0xE0, 0x3F, 0xE0, 0x3F, 0x00, 0x06, 0x00, 0x06,
;     0x00, 0x06, 0x00, 0x06, 0x00, 0x06, 0xE0, 0x3F, 0xE0, 0x3F, 0x00, 0x00},
;
;    // 0xEE - ''.
;    {0x00, 0x00, 0x80, 0x0F, 0xC0, 0x1F, 0xE0, 0x38, 0x60, 0x30, 0x60, 0x30,
;     0x60, 0x30, 0x60, 0x30, 0xE0, 0x38, 0xC0, 0x1F, 0x80, 0x0F, 0x00, 0x00},
;
;    // 0xEF - ''.
;    {0x00, 0x00, 0x00, 0x00, 0xE0, 0x3F, 0xE0, 0x3F, 0x60, 0x00, 0x60, 0x00,
;     0x60, 0x00, 0x60, 0x00, 0x60, 0x00, 0xE0, 0x3F, 0xE0, 0x3F, 0x00, 0x00},
;
;    // 0xF0 - ''.
;    {0x00, 0x00, 0xE0, 0xFF, 0xE0, 0xFF, 0x60, 0x0C, 0x60, 0x18, 0x60, 0x18,
;     0x60, 0x18, 0x60, 0x18, 0xE0, 0x1C, 0xC0, 0x0F, 0x80, 0x07, 0x00, 0x00},
;
;    // 0xF1 - ''.
;    {0x00, 0x00, 0x80, 0x0F, 0xC0, 0x1F, 0xE0, 0x38, 0x60, 0x30, 0x60, 0x30,
;     0x60, 0x30, 0x60, 0x30, 0x60, 0x30, 0xC0, 0x18, 0x80, 0x08, 0x00, 0x00},
;
;    // 0xF2 - ''.
;    {0x00, 0x00, 0x00, 0x00, 0x60, 0x00, 0x60, 0x00, 0x60, 0x00, 0xE0, 0x3F,
;     0xE0, 0x3F, 0x60, 0x00, 0x60, 0x00, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00},
;
;    // 0xF3 - ''.
;    {0x00, 0x00, 0x00, 0x00, 0x60, 0x00, 0xE0, 0x81, 0x80, 0xE7, 0x00, 0x7E,
;     0x00, 0x1E, 0x80, 0x07, 0xE0, 0x01, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00},
;
;    // 0xF4 - ''.
;    {0x00, 0x00, 0x80, 0x1F, 0xC0, 0x3F, 0xC0, 0x30, 0xC0, 0x30, 0xE0, 0xFF,
;     0xE0, 0xFF, 0xC0, 0x30, 0xC0, 0x30, 0xC0, 0x3F, 0x80, 0x1F, 0x00, 0x00},
;
;    // 0xF5 - ''.
;    {0x00, 0x00, 0x60, 0x30, 0xE0, 0x38, 0xC0, 0x1D, 0x80, 0x0F, 0x00, 0x07,
;     0x80, 0x0F, 0xC0, 0x1D, 0xE0, 0x38, 0x60, 0x30, 0x00, 0x00, 0x00, 0x00},
;
;    // 0xF6 - ''.
;    {0x00, 0x00, 0x00, 0x00, 0xE0, 0x3F, 0xE0, 0x3F, 0x00, 0x30, 0x00, 0x30,
;     0x00, 0x30, 0x00, 0x30, 0xE0, 0x3F, 0xE0, 0xFF, 0x00, 0xF0, 0x00, 0x00},
;
;    // 0xF7 - ''.
;    {0x00, 0x00, 0x00, 0x00, 0xE0, 0x03, 0xE0, 0x07, 0x00, 0x06, 0x00, 0x06,
;     0x00, 0x06, 0x00, 0x06, 0xE0, 0x3F, 0xE0, 0x3F, 0x00, 0x00, 0x00, 0x00},
;
;    // 0xF8 - ''.
;    {0x00, 0x00, 0xE0, 0x3F, 0xE0, 0x3F, 0x00, 0x30, 0x00, 0x30, 0xE0, 0x3F,
;     0xE0, 0x3F, 0x00, 0x30, 0x00, 0x30, 0xE0, 0x3F, 0xE0, 0x3F, 0x00, 0x00},
;
;    // 0xF9 - ''.
;    {0x00, 0x00, 0xE0, 0x3F, 0xE0, 0x3F, 0x00, 0x30, 0x00, 0x30, 0xE0, 0x3F,
;     0xE0, 0x3F, 0x00, 0x30, 0x00, 0x30, 0xE0, 0x3F, 0xE0, 0xFF, 0x00, 0xF0},
;
;    // 0xFA - ''.
;    {0x00, 0x00, 0xE0, 0x00, 0xE0, 0x00, 0x60, 0x00, 0xE0, 0x3F, 0xE0, 0x3F,
;     0x00, 0x33, 0x00, 0x33, 0x00, 0x33, 0x00, 0x3F, 0x00, 0x1E, 0x00, 0x00},
;
;    // 0xFB - ''.
;    {0x00, 0x00, 0xE0, 0x3F, 0xE0, 0x3F, 0x00, 0x33, 0x00, 0x33, 0x00, 0x33,
;     0x00, 0x3F, 0x00, 0x1E, 0x00, 0x00, 0xE0, 0x3F, 0xE0, 0x3F, 0x00, 0x00},
;
;    // 0xFC - ''.
;    {0x00, 0x00, 0x00, 0x00, 0xE0, 0x3F, 0xE0, 0x3F, 0x00, 0x33, 0x00, 0x33,
;     0x00, 0x33, 0x00, 0x33, 0x00, 0x3F, 0x00, 0x1E, 0x00, 0x00, 0x00, 0x00},
;
;    // 0xFD - ''.
;    {0x00, 0x00, 0x80, 0x08, 0xC0, 0x18, 0x60, 0x30, 0x60, 0x30, 0x60, 0x33,
;     0x60, 0x33, 0x60, 0x3B, 0xC0, 0x1F, 0x80, 0x0F, 0x00, 0x00, 0x00, 0x00},
;
;    // 0xFE - ''.
;    {0x00, 0x00, 0xE0, 0x3F, 0xE0, 0x3F, 0x00, 0x03, 0x80, 0x0F, 0xC0, 0x1F,
;     0xE0, 0x38, 0x60, 0x30, 0xE0, 0x38, 0xC0, 0x1F, 0x80, 0x0F, 0x00, 0x00},
;
;    // 0xFF - ''.
;    {0x00, 0x00, 0x00, 0x00, 0xC0, 0x31, 0xE0, 0x3B, 0x60, 0x1E, 0x60, 0x0E,
;     0x60, 0x06, 0x60, 0x02, 0xE0, 0x3F, 0xE0, 0x3F, 0x00, 0x00, 0x00, 0x00}
;};
;/*******************************************************************************
;*  MT12864.c
;*
;*  :     
;*
;*       Copyright (c) 2007-2008 Nick Shl, focus
;*           All rights reserved.
;*
;*
;*  :
;*
;*  Apr 20, 2009  Nick_Shl  
;*  Apr 10, 2008  Nick_Shl  ,  
;*                             
;*  *** **, ****  focus      
;*
;*/// ***************************************************************************
;
;// *****************************************************************************
;// ***       ***************************************************
;// *****************************************************************************
;#include <mega128.h>
	#ifndef __SLEEP_DEFINED__
	#define __SLEEP_DEFINED__
	.EQU __se_bit=0x20
	.EQU __sm_mask=0x1C
	.EQU __sm_powerdown=0x10
	.EQU __sm_powersave=0x18
	.EQU __sm_standby=0x14
	.EQU __sm_ext_standby=0x1C
	.EQU __sm_adc_noise_red=0x08
	.SET power_ctrl_reg=mcucr
	#endif
;#include <delay.h>
;
;// *****************************************************************************
;// ***       ********************************************
;// *****************************************************************************
;#include "Def.h"
;#include "MT12864.h"
;
;// *****************************************************************************
;// ***      E  ()  us.                     ***
;// ***    1  ,  PROTEUS .   LCD_E            ***
;// ***    inline ,    1  .              ***
;// ***       .                          ***
;// *****************************************************************************
;#define E_Del 1
;//        8 
;#define Del 8
;
;// *****************************************************************************
;// ***    .                                                      ***
;// ***     - .                                         ***
;// *****************************************************************************
;#define LCD_BL(x) PORTA.0 = x
;
;// *****************************************************************************
;// ***    E  ().                                                ***
;// ***     - .                                         ***
;// *****************************************************************************
;#define LCD_E(x) PORTA.3 = x
;
;// *****************************************************************************
;// ***    A0  (/).                                      ***
;// ***   "1"  , "0"  .                          ***
;// *****************************************************************************
;#define LCD_A0(x) PORTA.4 = x
;
;// *****************************************************************************
;// ***    RW  (/).                                       ***
;// ***  "1" -  , "0" -  .                                ***
;// *****************************************************************************
;#define LCD_RW(x) PORTA.5 = x
;
;// *****************************************************************************
;// ***    CS  ().                                             ***
;// ***     -  ???                                       ***
;// *****************************************************************************
;#define LCD_C1(x) PORTG = (PORTG & (~(1 << 2))) | (x << 2) // PORTG.2
;#define LCD_C2(x) PORTA.7 = x
;//      . 0 - . 1 - ,  .. ( 2)
;//     -    x==0
;//#define LCD_CS(x) LCD_C1(x==0 ? High : Low); LCD_C2(x==1 ? High : Low)
;inline void LCD_CS(unsigned char x)
; 0003 004B {

	.CSEG
_LCD_CS:
; 0003 004C     if(x == 0) LCD_C1(High);
;	x -> Y+0
	LD   R30,Y
	CPI  R30,0
	BRNE _0x60003
	LDS  R30,101
	ORI  R30,4
	RJMP _0x6005A
; 0003 004D     else       LCD_C1(Low);
_0x60003:
	LDS  R30,101
	ANDI R30,0xFB
_0x6005A:
	STS  101,R30
; 0003 004E     if(x == 1) LCD_C2(High);
	LD   R26,Y
	CPI  R26,LOW(0x1)
	BRNE _0x60005
	SBI  0x1B,7
; 0003 004F     else       LCD_C2(Low);
	RJMP _0x60008
_0x60005:
	CBI  0x1B,7
; 0003 0050 }
_0x60008:
	RJMP _0x2060026
;// *****************************************************************************
;// ***    RES  ().                                              ***
;// ***     - 1- .  - .                        ***
;// *****************************************************************************
;#define LCD_RES(x) PORTA.6 = x
;
;// *****************************************************************************
;// ***    DATA  ().   *********************************************
;// *****************************************************************************
;#define LCD_DATA_PORT PORTC
;#define LCD_DATA_DDR  DDRC
;#define LCD_DATA_PIN  PINC
;
;// *****************************************************************************
;// ***           **************************************
;// *****************************************************************************
;unsigned char LCD_Buf[8][128];
;
;// *****************************************************************************
;// ***        ******************************************************
;// *****************************************************************************
;unsigned char LCD_Pos_X, LCD_Pos_Y;
;
;// *****************************************************************************
;// ***       ***********************************************
;// *****************************************************************************
;void LCD_BackLight(unsigned char Cmd)
; 0003 006C {
_LCD_BackLight:
; 0003 006D     LCD_BL(Cmd);
;	Cmd -> Y+0
	LD   R30,Y
	CPI  R30,0
	BRNE _0x6000B
	CBI  0x1B,0
	RJMP _0x6000C
_0x6000B:
	SBI  0x1B,0
_0x6000C:
; 0003 006E }
_0x2060026:
	ADIW R28,1
	RET
;
;// *****************************************************************************
;// ***       ,      **********
;// *****************************************************************************
;void LCD_Wait_Ready(void)
; 0003 0074 {
_LCD_Wait_Ready:
; 0003 0075 //    
; 0003 0076     LCD_DATA_PORT = 0x00;
	LDI  R30,LOW(0)
	OUT  0x15,R30
; 0003 0077     LCD_DATA_DDR = 0x00;
	OUT  0x14,R30
; 0003 0078 
; 0003 0079 //  1
; 0003 007A     LCD_RW(High);      //  
	SBI  0x1B,5
; 0003 007B 	LCD_A0(Low);       //   
	CBI  0x1B,4
; 0003 007C 	LCD_CS(0);         //      
	ST   -Y,R30
	RCALL _LCD_CS
; 0003 007D 	delay_us(E_Del);   //     (tAW) >140ns
	__DELAY_USB 5
; 0003 007E 	LCD_E(High);
	SBI  0x1B,3
; 0003 007F 	delay_us(E_Del);   //    E=1 (       ,     320) >450ns
	__DELAY_USB 5
; 0003 0080 	while(LCD_DATA_PIN & 0b10000000); //    
_0x60013:
	SBIC 0x13,7
	RJMP _0x60013
; 0003 0081 	LCD_E(Low);        //   E
	CBI  0x1B,3
; 0003 0082 	delay_us(E_Del);   //      E=1 > (1000ns-140ns-450ns)
	__DELAY_USB 5
; 0003 0083 
; 0003 0084 //  2
; 0003 0085 	LCD_RW(High);      //  
	SBI  0x1B,5
; 0003 0086 	LCD_A0(Low);       //   
	CBI  0x1B,4
; 0003 0087 	LCD_CS(1);         //      
	LDI  R30,LOW(1)
	ST   -Y,R30
	RCALL _LCD_CS
; 0003 0088 	delay_us(E_Del);   //     (tAW) >140ns
	__DELAY_USB 5
; 0003 0089 	LCD_E(High);
	SBI  0x1B,3
; 0003 008A 	delay_us(E_Del);   //    E=1 (       ,     320) >450ns
	__DELAY_USB 5
; 0003 008B 	while(LCD_DATA_PIN & 0b10000000); //    
_0x6001E:
	SBIC 0x13,7
	RJMP _0x6001E
; 0003 008C 	LCD_E(Low);        //   E
	CBI  0x1B,3
; 0003 008D 	delay_us(E_Del);   //      E=1 > (1000ns-140ns-450ns)
	__DELAY_USB 5
; 0003 008E 
; 0003 008F //  
; 0003 0090 	LCD_RW(Low);
	CBI  0x1B,5
; 0003 0091 
; 0003 0092 //  ,  Proteus  : Logic contension(s) detected on net A**.
; 0003 0093 	delay_us(Del);
	__DELAY_USB 43
; 0003 0094 
; 0003 0095 //    
; 0003 0096     LCD_DATA_DDR = 0xFF;
	LDI  R30,LOW(255)
	OUT  0x14,R30
; 0003 0097 }
	RET
;
;// *****************************************************************************
;// ***         *******************************************
;// *****************************************************************************
;void LCD_Cmd(unsigned char Chip, unsigned char Cmd)
; 0003 009D {
_LCD_Cmd:
; 0003 009E     LCD_CS(Chip);        //  
;	Chip -> Y+1
;	Cmd -> Y+0
	LDD  R30,Y+1
	ST   -Y,R30
	RCALL _LCD_CS
; 0003 009F     LCD_A0(Low);         //  
	CBI  0x1B,4
; 0003 00A0     LCD_DATA_PORT = Cmd; //    
	LD   R30,Y
	OUT  0x15,R30
; 0003 00A1     delay_us(E_Del);     // 
	__DELAY_USB 5
; 0003 00A2     LCD_E(High);         //   E
	SBI  0x1B,3
; 0003 00A3     delay_us(E_Del);     // 
	__DELAY_USB 5
; 0003 00A4     LCD_E(Low);          //   E
	CBI  0x1B,3
; 0003 00A5     LCD_Wait_Ready();    //   
	RCALL _LCD_Wait_Ready
; 0003 00A6 }
	JMP  _0x2060022
;
;// *****************************************************************************
;// ***         ********************************************
;// *****************************************************************************
;void LCD_Dat(unsigned char Chip, unsigned char Data)
; 0003 00AC {
_LCD_Dat:
; 0003 00AD     LCD_CS(Chip);         //  
;	Chip -> Y+1
;	Data -> Y+0
	LDD  R30,Y+1
	ST   -Y,R30
	RCALL _LCD_CS
; 0003 00AE     LCD_A0(High);         //  
	SBI  0x1B,4
; 0003 00AF     LCD_DATA_PORT = Data; //    
	LD   R30,Y
	OUT  0x15,R30
; 0003 00B0     delay_us(E_Del);      // 
	__DELAY_USB 5
; 0003 00B1     LCD_E(High);          //   E
	SBI  0x1B,3
; 0003 00B2     delay_us(E_Del);      // 
	__DELAY_USB 5
; 0003 00B3     LCD_E(Low);           //   E
	CBI  0x1B,3
; 0003 00B4     LCD_Wait_Ready();     //   
	RCALL _LCD_Wait_Ready
; 0003 00B5 }
	JMP  _0x2060022
;
;// *****************************************************************************
;// ***   /     **********************************
;// *****************************************************************************
;inline void LCD_On_Off(unsigned char Chip, unsigned char Data)
; 0003 00BB {
_LCD_On_Off:
; 0003 00BC     LCD_Cmd(Chip, 0b00111110 + (Data & 0x01));
;	Chip -> Y+1
;	Data -> Y+0
	LDD  R30,Y+1
	ST   -Y,R30
	LDD  R30,Y+1
	ANDI R30,LOW(0x1)
	SUBI R30,-LOW(62)
	ST   -Y,R30
	RCALL _LCD_Cmd
; 0003 00BD }
	JMP  _0x2060022
;
;// *****************************************************************************
;// ***          **********************************
;// *****************************************************************************
;inline void LCD_Set_First_Str(unsigned char Chip, unsigned char Data)
; 0003 00C3 {
_LCD_Set_First_Str:
; 0003 00C4     LCD_Cmd(Chip, 0b11000000 + (Data & 0x3F));
;	Chip -> Y+1
;	Data -> Y+0
	LDD  R30,Y+1
	ST   -Y,R30
	LDD  R30,Y+1
	ANDI R30,LOW(0x3F)
	SUBI R30,-LOW(192)
	ST   -Y,R30
	RCALL _LCD_Cmd
; 0003 00C5 }
	JMP  _0x2060022
;
;// *****************************************************************************
;// ***          ************************************
;// *****************************************************************************
;inline void LCD_Set_Page(unsigned char Chip, unsigned char Data)
; 0003 00CB {
_LCD_Set_Page:
; 0003 00CC     LCD_Cmd(Chip, 0b10111000 + (Data & 0x07));
;	Chip -> Y+1
;	Data -> Y+0
	LDD  R30,Y+1
	ST   -Y,R30
	LDD  R30,Y+1
	ANDI R30,LOW(0x7)
	SUBI R30,-LOW(184)
	ST   -Y,R30
	RCALL _LCD_Cmd
; 0003 00CD }
	JMP  _0x2060022
;
;// *****************************************************************************
;// ***           **********************
;// *****************************************************************************
;inline void LCD_Set_Col(unsigned char Chip, unsigned char Data)
; 0003 00D3 {
_LCD_Set_Col:
; 0003 00D4     LCD_Cmd(Chip, 0b01000000 + (Data & 0x3F));
;	Chip -> Y+1
;	Data -> Y+0
	LDD  R30,Y+1
	ST   -Y,R30
	LDD  R30,Y+1
	ANDI R30,LOW(0x3F)
	SUBI R30,-LOW(64)
	ST   -Y,R30
	RCALL _LCD_Cmd
; 0003 00D5 }
	JMP  _0x2060022
;
;// *****************************************************************************
;// ***        *****************************************
;// *****************************************************************************
;void LCD_Init(void)
; 0003 00DB {
_LCD_Init:
; 0003 00DC     LCD_RW(Low);    //     
	CBI  0x1B,5
; 0003 00DD     LCD_C1(High);   //   1
	LDS  R30,101
	ORI  R30,4
	STS  101,R30
; 0003 00DE     LCD_C2(High);   //   2
	SBI  0x1B,7
; 0003 00DF     LCD_RES(Low);   //   RESET 
	CBI  0x1B,6
; 0003 00E0     delay_us(100);  //   100 
	__DELAY_USW 400
; 0003 00E1     LCD_RES(High);  //   RESET  
	SBI  0x1B,6
; 0003 00E2     delay_us(1000); //   1000 
	__DELAY_USW 4000
; 0003 00E3     LCD_Set_First_Str(0, 0); //       0 ( 1)
	LDI  R30,LOW(0)
	ST   -Y,R30
	ST   -Y,R30
	RCALL _LCD_Set_First_Str
; 0003 00E4     LCD_Set_First_Str(1, 0); //       0 ( 2)
	LDI  R30,LOW(1)
	ST   -Y,R30
	LDI  R30,LOW(0)
	ST   -Y,R30
	RCALL _LCD_Set_First_Str
; 0003 00E5     LCD_Set_Page(0, 0); //       ( 1)
	LDI  R30,LOW(0)
	ST   -Y,R30
	ST   -Y,R30
	RCALL _LCD_Set_Page
; 0003 00E6     LCD_Set_Page(1, 0); //       ( 2)
	LDI  R30,LOW(1)
	ST   -Y,R30
	LDI  R30,LOW(0)
	ST   -Y,R30
	RCALL _LCD_Set_Page
; 0003 00E7     LCD_Set_Col(0, 0);  //        0 ( 1)
	LDI  R30,LOW(0)
	ST   -Y,R30
	ST   -Y,R30
	RCALL _LCD_Set_Col
; 0003 00E8     LCD_Set_Col(1, 0);  //        0 ( 2)
	LDI  R30,LOW(1)
	ST   -Y,R30
	LDI  R30,LOW(0)
	ST   -Y,R30
	RCALL _LCD_Set_Col
; 0003 00E9     LCD_On_Off(0, On);  //    ( 1)
	LDI  R30,LOW(0)
	ST   -Y,R30
	LDI  R30,LOW(1)
	ST   -Y,R30
	RCALL _LCD_On_Off
; 0003 00EA     LCD_On_Off(1, On);  //    ( 2)
	LDI  R30,LOW(1)
	ST   -Y,R30
	ST   -Y,R30
	RCALL _LCD_On_Off
; 0003 00EB 
; 0003 00EC     //     
; 0003 00ED     LCD_Clear();
	RCALL _LCD_Clear
; 0003 00EE }
	RET
;
;// *****************************************************************************
;// ***        ***********************************************
;// *****************************************************************************
;void LCD_Clear(void)
; 0003 00F4 {
_LCD_Clear:
; 0003 00F5     unsigned char i, j;
; 0003 00F6     for(j=0; j < 8; j++)
	ST   -Y,R17
	ST   -Y,R16
;	i -> R17
;	j -> R16
	LDI  R16,LOW(0)
_0x6003A:
	CPI  R16,8
	BRSH _0x6003B
; 0003 00F7     {
; 0003 00F8         LCD_Set_Page(0, j);
	LDI  R30,LOW(0)
	ST   -Y,R30
	ST   -Y,R16
	RCALL _LCD_Set_Page
; 0003 00F9         LCD_Set_Col(0, 0);
	LDI  R30,LOW(0)
	ST   -Y,R30
	ST   -Y,R30
	RCALL _LCD_Set_Col
; 0003 00FA         LCD_Set_Page(1, j);
	LDI  R30,LOW(1)
	ST   -Y,R30
	ST   -Y,R16
	RCALL _LCD_Set_Page
; 0003 00FB         LCD_Set_Col(1, 0);
	LDI  R30,LOW(1)
	ST   -Y,R30
	LDI  R30,LOW(0)
	ST   -Y,R30
	RCALL _LCD_Set_Col
; 0003 00FC 
; 0003 00FD         for(i=0; i < 64; i++) LCD_Dat(0, 0);
	LDI  R17,LOW(0)
_0x6003D:
	CPI  R17,64
	BRSH _0x6003E
	LDI  R30,LOW(0)
	ST   -Y,R30
	ST   -Y,R30
	RCALL _LCD_Dat
	SUBI R17,-1
	RJMP _0x6003D
_0x6003E:
; 0003 00FE for(i=0; i < 64; i++) LCD_Dat(1, 0);
	LDI  R17,LOW(0)
_0x60040:
	CPI  R17,64
	BRSH _0x60041
	LDI  R30,LOW(1)
	ST   -Y,R30
	LDI  R30,LOW(0)
	ST   -Y,R30
	RCALL _LCD_Dat
	SUBI R17,-1
	RJMP _0x60040
_0x60041:
; 0003 00FF }
	SUBI R16,-1
	RJMP _0x6003A
_0x6003B:
; 0003 0100 }
	RJMP _0x2060025
;
;// *****************************************************************************
;// ***    .        *******************
;// *****************************************************************************
;void LCD_Refresh(void)
; 0003 0106 {
_LCD_Refresh:
; 0003 0107     unsigned char i, j;
; 0003 0108 
; 0003 0109     LCD_Set_First_Str(0, 0);
	ST   -Y,R17
	ST   -Y,R16
;	i -> R17
;	j -> R16
	LDI  R30,LOW(0)
	ST   -Y,R30
	ST   -Y,R30
	RCALL _LCD_Set_First_Str
; 0003 010A 
; 0003 010B     for(i=0; i < 8; i++)
	LDI  R17,LOW(0)
_0x60043:
	CPI  R17,8
	BRSH _0x60044
; 0003 010C     {
; 0003 010D         LCD_Set_Page(0, i);
	LDI  R30,LOW(0)
	ST   -Y,R30
	ST   -Y,R17
	RCALL _LCD_Set_Page
; 0003 010E         LCD_Set_Col(0, 0);
	LDI  R30,LOW(0)
	ST   -Y,R30
	ST   -Y,R30
	RCALL _LCD_Set_Col
; 0003 010F         LCD_A0(High);
	SBI  0x1B,4
; 0003 0110         LCD_CS(0);
	LDI  R30,LOW(0)
	ST   -Y,R30
	RCALL _LCD_CS
; 0003 0111         for(j=0; j < 64; j++)
	LDI  R16,LOW(0)
_0x60048:
	CPI  R16,64
	BRSH _0x60049
; 0003 0112         {
; 0003 0113             LCD_DATA_PORT = LCD_Buf[i][j];
	MOV  R30,R17
	LDI  R31,0
	CALL __LSLW3
	CALL __LSLW4
	SUBI R30,LOW(-_LCD_Buf)
	SBCI R31,HIGH(-_LCD_Buf)
	MOVW R26,R30
	CLR  R30
	ADD  R26,R16
	ADC  R27,R30
	LD   R30,X
	OUT  0x15,R30
; 0003 0114             delay_us(E_Del);
	__DELAY_USB 5
; 0003 0115             LCD_E(High);
	SBI  0x1B,3
; 0003 0116             delay_us(E_Del);
	__DELAY_USB 5
; 0003 0117             LCD_E(Low);
	CBI  0x1B,3
; 0003 0118             //        8 
; 0003 0119 	        delay_us(Del);
	__DELAY_USB 43
; 0003 011A         }
	SUBI R16,-1
	RJMP _0x60048
_0x60049:
; 0003 011B     }
	SUBI R17,-1
	RJMP _0x60043
_0x60044:
; 0003 011C 
; 0003 011D     LCD_Set_First_Str(1, 0);
	LDI  R30,LOW(1)
	ST   -Y,R30
	LDI  R30,LOW(0)
	ST   -Y,R30
	RCALL _LCD_Set_First_Str
; 0003 011E 
; 0003 011F     for(i=0; i < 8; i++)
	LDI  R17,LOW(0)
_0x6004F:
	CPI  R17,8
	BRSH _0x60050
; 0003 0120     {
; 0003 0121         LCD_Set_Page(1, i);
	LDI  R30,LOW(1)
	ST   -Y,R30
	ST   -Y,R17
	RCALL _LCD_Set_Page
; 0003 0122         LCD_Set_Col(1, 0);
	LDI  R30,LOW(1)
	ST   -Y,R30
	LDI  R30,LOW(0)
	ST   -Y,R30
	RCALL _LCD_Set_Col
; 0003 0123         LCD_A0(High);
	SBI  0x1B,4
; 0003 0124         LCD_CS(1);
	LDI  R30,LOW(1)
	ST   -Y,R30
	RCALL _LCD_CS
; 0003 0125         for(j=64; j < 128; j++)
	LDI  R16,LOW(64)
_0x60054:
	CPI  R16,128
	BRSH _0x60055
; 0003 0126         {
; 0003 0127             LCD_DATA_PORT = LCD_Buf[i][j];
	MOV  R30,R17
	LDI  R31,0
	CALL __LSLW3
	CALL __LSLW4
	SUBI R30,LOW(-_LCD_Buf)
	SBCI R31,HIGH(-_LCD_Buf)
	MOVW R26,R30
	CLR  R30
	ADD  R26,R16
	ADC  R27,R30
	LD   R30,X
	OUT  0x15,R30
; 0003 0128             delay_us(E_Del);
	__DELAY_USB 5
; 0003 0129             LCD_E(High);
	SBI  0x1B,3
; 0003 012A             delay_us(E_Del);
	__DELAY_USB 5
; 0003 012B             LCD_E(Low);
	CBI  0x1B,3
; 0003 012C             //        8 
; 0003 012D 	        delay_us(Del);
	__DELAY_USB 43
; 0003 012E         }
	SUBI R16,-1
	RJMP _0x60054
_0x60055:
; 0003 012F     }
	SUBI R17,-1
	RJMP _0x6004F
_0x60050:
; 0003 0130 }
_0x2060025:
	LD   R16,Y+
	LD   R17,Y+
	RET
;/*******************************************************************************
;*  Math.c
;*
;*  : 
;*
;*       Copyright (c) 2007-2008 Nick Shl, focus
;*           All rights reserved.
;*
;*
;*  :
;*
;*  Apr 20, 2009  Nick_Shl  
;*  Apr 10, 2008  Nick_Shl  , 
;*  *** **, ****  focus      
;*
;*/// ***************************************************************************
;
;// *****************************************************************************
;// ***       ***************************************************
;// *****************************************************************************
;#include <mega128.h>
	#ifndef __SLEEP_DEFINED__
	#define __SLEEP_DEFINED__
	.EQU __se_bit=0x20
	.EQU __sm_mask=0x1C
	.EQU __sm_powerdown=0x10
	.EQU __sm_powersave=0x18
	.EQU __sm_standby=0x14
	.EQU __sm_ext_standby=0x1C
	.EQU __sm_adc_noise_red=0x08
	.SET power_ctrl_reg=mcucr
	#endif
;#include <string.h>
;
;// *****************************************************************************
;// ***       ********************************************
;// *****************************************************************************
;#include "Def.h"
;#include "Coder.h"
;#include "Sound.h"
;#include "Tasks.h"
;#include "Variables.h"
;
;// *****************************************************************************
;// ***         ()  ********
;// *****************************************************************************
;void math_CalcChannel(char CH)
; 0004 0025 {

	.CSEG
_math_CalcChannel:
; 0004 0026     char i;
; 0004 0027     signed long Factor;
; 0004 0028 
; 0004 0029     //      - 
; 0004 002A     if(CH < 0) return;
	SBIW R28,4
	ST   -Y,R17
;	CH -> Y+5
;	i -> R17
;	Factor -> Y+1
	LDD  R26,Y+5
	CPI  R26,0
	BRGE _0x80003
	LDD  R17,Y+0
	JMP  _0x206001E
; 0004 002B     //        - 
; 0004 002C     if(CH > MAX_CHANNELS) return;
_0x80003:
	LDD  R26,Y+5
	CPI  R26,LOW(0x9)
	BRLT _0x80004
	LDD  R17,Y+0
	JMP  _0x206001E
; 0004 002D 
; 0004 002E     //     
; 0004 002F     output[CH] = 0;
_0x80004:
	LDD  R30,Y+5
	LDI  R26,LOW(_output)
	LDI  R27,HIGH(_output)
	LDI  R31,0
	LSL  R30
	ROL  R31
	ADD  R26,R30
	ADC  R27,R31
	LDI  R30,LOW(0)
	LDI  R31,HIGH(0)
	ST   X+,R30
	ST   X,R31
; 0004 0030 
; 0004 0031     //   
; 0004 0032     for(i=0; i < MAX_CONTROLS; i++)
	LDI  R17,LOW(0)
_0x80006:
	CPI  R17,11
	BRLT PC+3
	JMP _0x80007
; 0004 0033     {
; 0004 0034         //     i   CH  -  
; 0004 0035         if(CurModel.Mode[FLY_MODE].Chanels[CH][i] != 0)
	__POINTW2MN _CurModel,21
	LDS  R30,_FLY_MODE
	LDI  R31,0
	MOVW R22,R26
	LDI  R26,LOW(246)
	LDI  R27,HIGH(246)
	CALL __MULW12U
	MOVW R26,R22
	ADD  R26,R30
	ADC  R27,R31
	SUBI R26,LOW(-154)
	SBCI R27,HIGH(-154)
	LDD  R30,Y+5
	LDI  R31,0
	MOVW R22,R26
	LDI  R26,LOW(11)
	LDI  R27,HIGH(11)
	CALL __MULW12U
	MOVW R26,R22
	ADD  R26,R30
	ADC  R27,R31
	CLR  R30
	ADD  R26,R17
	ADC  R27,R30
	LD   R30,X
	CPI  R30,0
	BRNE PC+3
	JMP _0x80008
; 0004 0036         {
; 0004 0037             //     i   CH
; 0004 0038             Factor = CurModel.Mode[FLY_MODE].Chanels[CH][i];
	__POINTW2MN _CurModel,21
	LDS  R30,_FLY_MODE
	LDI  R31,0
	MOVW R22,R26
	LDI  R26,LOW(246)
	LDI  R27,HIGH(246)
	CALL __MULW12U
	MOVW R26,R22
	ADD  R26,R30
	ADC  R27,R31
	SUBI R26,LOW(-154)
	SBCI R27,HIGH(-154)
	LDD  R30,Y+5
	LDI  R31,0
	MOVW R22,R26
	LDI  R26,LOW(11)
	LDI  R27,HIGH(11)
	CALL __MULW12U
	MOVW R26,R22
	ADD  R26,R30
	ADC  R27,R31
	CLR  R30
	ADD  R26,R17
	ADC  R27,R30
	LD   R30,X
	CALL __CBD1
	__PUTD1S 1
; 0004 0039             //    i   CH
; 0004 003A             output[CH] += out_cur[i] * Factor / 100;
	LDD  R30,Y+5
	LDI  R26,LOW(_output)
	LDI  R27,HIGH(_output)
	LDI  R31,0
	LSL  R30
	ROL  R31
	ADD  R30,R26
	ADC  R31,R27
	PUSH R31
	PUSH R30
	MOVW R26,R30
	CALL __GETW1P
	PUSH R31
	PUSH R30
	MOV  R30,R17
	LDI  R26,LOW(_out_cur)
	LDI  R27,HIGH(_out_cur)
	LDI  R31,0
	LSL  R30
	ROL  R31
	ADD  R26,R30
	ADC  R27,R31
	CALL __GETW1P
	MOVW R26,R30
	__GETD1S 1
	CALL __CWD2
	CALL __MULD12
	MOVW R26,R30
	MOVW R24,R22
	__GETD1N 0x64
	CALL __DIVD21
	POP  R26
	POP  R27
	ADD  R30,R26
	ADC  R31,R27
	POP  R26
	POP  R27
	ST   X+,R30
	ST   X,R31
; 0004 003B         }
; 0004 003C     }
_0x80008:
	SUBI R17,-1
	RJMP _0x80006
_0x80007:
; 0004 003D 
; 0004 003E     //  :
; 0004 003F     //  (+-0,5 ) +  (1,5 )
; 0004 0040     output[CH] += TimerClockPerSec(0.0015);
	LDD  R30,Y+5
	LDI  R26,LOW(_output)
	LDI  R27,HIGH(_output)
	LDI  R31,0
	LSL  R30
	ROL  R31
	ADD  R26,R30
	ADC  R27,R31
	LD   R30,X+
	LD   R31,X+
	SUBI R30,LOW(-3000)
	SBCI R31,HIGH(-3000)
	ST   -X,R31
	ST   -X,R30
; 0004 0041     //   int   :        int
; 0004 0042     //  : 1,5   1/666,6(6) ...
; 0004 0043 
; 0004 0044     //     0,0009  (0,9 ) - 
; 0004 0045     if(output[CH] < TimerClockPerSec(0.0009)) output[CH] = TimerClockPerSec(0.0009);
	LDD  R30,Y+5
	LDI  R26,LOW(_output)
	LDI  R27,HIGH(_output)
	LDI  R31,0
	LSL  R30
	ROL  R31
	ADD  R26,R30
	ADC  R27,R31
	CALL __GETW1P
	CPI  R30,LOW(0x708)
	LDI  R26,HIGH(0x708)
	CPC  R31,R26
	BRGE _0x80009
	LDD  R30,Y+5
	LDI  R26,LOW(_output)
	LDI  R27,HIGH(_output)
	LDI  R31,0
	LSL  R30
	ROL  R31
	ADD  R26,R30
	ADC  R27,R31
	LDI  R30,LOW(1800)
	LDI  R31,HIGH(1800)
	ST   X+,R30
	ST   X,R31
; 0004 0046 
; 0004 0047     //     0,0021  (2,1 ) - 
; 0004 0048     if(output[CH] > TimerClockPerSec(0.0021)) output[CH] = TimerClockPerSec(0.0021);
_0x80009:
	LDD  R30,Y+5
	LDI  R26,LOW(_output)
	LDI  R27,HIGH(_output)
	LDI  R31,0
	LSL  R30
	ROL  R31
	ADD  R26,R30
	ADC  R27,R31
	CALL __GETW1P
	CPI  R30,LOW(0x1069)
	LDI  R26,HIGH(0x1069)
	CPC  R31,R26
	BRLT _0x8000A
	LDD  R30,Y+5
	LDI  R26,LOW(_output)
	LDI  R27,HIGH(_output)
	LDI  R31,0
	LSL  R30
	ROL  R31
	ADD  R26,R30
	ADC  R27,R31
	LDI  R30,LOW(4200)
	LDI  R31,HIGH(4200)
	ST   X+,R30
	ST   X,R31
; 0004 0049 }
_0x8000A:
	LDD  R17,Y+0
	JMP  _0x206001E
;
;// *****************************************************************************
;// ***        ******************************************
;// *****************************************************************************
;signed int math_InterPolEx(signed int Val, signed int Max, signed int K, signed char * Nodes, signed char NodesCount)
; 0004 004F {
_math_InterPolEx:
; 0004 0050     unsigned char n;
; 0004 0051     signed int n1, n2, ln;
; 0004 0052     //  .   long,     
; 0004 0053     //    .
; 0004 0054     signed long InterPoolSize;
; 0004 0055 
; 0004 0056     //         -   
; 0004 0057     if(Nodes == NULL) return(Val);
	SBIW R28,6
	CALL __SAVELOCR6
;	Val -> Y+19
;	Max -> Y+17
;	K -> Y+15
;	*Nodes -> Y+13
;	NodesCount -> Y+12
;	n -> R17
;	n1 -> R18,R19
;	n2 -> R20,R21
;	ln -> Y+10
;	InterPoolSize -> Y+6
	LDD  R30,Y+13
	LDD  R31,Y+13+1
	SBIW R30,0
	BRNE _0x8000B
	LDD  R30,Y+19
	LDD  R31,Y+19+1
	RJMP _0x2060024
; 0004 0058     //       0   -   
; 0004 0059     if(NodesCount <= 0) return(Val);
_0x8000B:
	LDD  R26,Y+12
	CPI  R26,LOW(0x1)
	BRGE _0x8000C
	LDD  R30,Y+19
	LDD  R31,Y+19+1
	RJMP _0x2060024
; 0004 005A 
; 0004 005B     //      0 - 
; 0004 005C     if(Val < 0) Val = 0;
_0x8000C:
	LDD  R26,Y+20
	TST  R26
	BRPL _0x8000D
	LDI  R30,LOW(0)
	STD  Y+19,R30
	STD  Y+19+1,R30
; 0004 005D     //        Max
; 0004 005E     //     - 
; 0004 005F     if(Val >= Max) Val = Max - 1;
_0x8000D:
	LDD  R30,Y+17
	LDD  R31,Y+17+1
	LDD  R26,Y+19
	LDD  R27,Y+19+1
	CP   R26,R30
	CPC  R27,R31
	BRLT _0x8000E
	SBIW R30,1
	STD  Y+19,R30
	STD  Y+19+1,R31
; 0004 0060 
; 0004 0061     //    -   /   
; 0004 0062     InterPoolSize = Max / (NodesCount - 1);
_0x8000E:
	LDD  R30,Y+12
	SUBI R30,LOW(1)
	LDD  R26,Y+17
	LDD  R27,Y+17+1
	LDI  R31,0
	SBRC R30,7
	SER  R31
	CALL __DIVW21
	CALL __CWD1
	__PUTD1S 6
; 0004 0063 
; 0004 0064     //     :
; 0004 0065     //          
; 0004 0066     n  = (Val * (NodesCount - 1)) / Max;
	LDD  R30,Y+12
	SUBI R30,LOW(1)
	LDD  R26,Y+19
	LDD  R27,Y+19+1
	LDI  R31,0
	SBRC R30,7
	SER  R31
	CALL __MULW12
	MOVW R26,R30
	LDD  R30,Y+17
	LDD  R31,Y+17+1
	CALL __DIVW21
	MOV  R17,R30
; 0004 0067     //     
; 0004 0068     n1 = (*(Nodes + n)     * K) / 10;
	LDD  R26,Y+13
	LDD  R27,Y+13+1
	CLR  R30
	ADD  R26,R17
	ADC  R27,R30
	LD   R26,X
	LDD  R30,Y+15
	LDD  R31,Y+15+1
	LDI  R27,0
	SBRC R26,7
	SER  R27
	CALL __MULW12
	MOVW R26,R30
	LDI  R30,LOW(10)
	LDI  R31,HIGH(10)
	CALL __DIVW21
	MOVW R18,R30
; 0004 0069     //     
; 0004 006A     n2 = (*(Nodes + n + 1) * K) / 10;
	MOV  R30,R17
	LDD  R26,Y+13
	LDD  R27,Y+13+1
	LDI  R31,0
	ADD  R30,R26
	ADC  R31,R27
	LDD  R26,Z+1
	LDD  R30,Y+15
	LDD  R31,Y+15+1
	LDI  R27,0
	SBRC R26,7
	SER  R27
	CALL __MULW12
	MOVW R26,R30
	LDI  R30,LOW(10)
	LDI  R31,HIGH(10)
	CALL __DIVW21
	MOVW R20,R30
; 0004 006B     //  
; 0004 006C     //        (Y)
; 0004 006D     //     (X)
; 0004 006E     ln = (Val - n * InterPoolSize) * (n2 - n1) / InterPoolSize;
	__GETD1S 6
	MOV  R26,R17
	CLR  R27
	CLR  R24
	CLR  R25
	CALL __MULD12
	LDD  R26,Y+19
	LDD  R27,Y+19+1
	CALL __CWD2
	CALL __SUBD21
	MOVW R30,R20
	SUB  R30,R18
	SBC  R31,R19
	CALL __CWD1
	CALL __MULD12
	MOVW R26,R30
	MOVW R24,R22
	__GETD1S 6
	CALL __DIVD21
	STD  Y+10,R30
	STD  Y+10+1,R31
; 0004 006F 
; 0004 0070     return(n1 + ln);
	ADD  R30,R18
	ADC  R31,R19
_0x2060024:
	CALL __LOADLOCR6
	ADIW R28,21
	RET
; 0004 0071 }
;
;// *****************************************************************************
;// ***       ******************************************************
;// *****************************************************************************
;static inline signed int math_CurveInterPol(signed int Val, signed char * Nodes)
; 0004 0077 {
_math_CurveInterPol_G004:
; 0004 0078     //  0,5  -    
; 0004 0079     Val += TimerClockPerSec(0.0005);
;	Val -> Y+2
;	*Nodes -> Y+0
	LDD  R30,Y+2
	LDD  R31,Y+2+1
	SUBI R30,LOW(-1000)
	SBCI R31,HIGH(-1000)
	STD  Y+2,R30
	STD  Y+2+1,R31
; 0004 007A     //       
; 0004 007B     return(math_InterPolEx(Val, TimerClockPerSec(0.001), TimerClockPerSec(0.0005) / 10, Nodes, CURVE_NODES));
	ST   -Y,R31
	ST   -Y,R30
	LDI  R30,LOW(2000)
	LDI  R31,HIGH(2000)
	ST   -Y,R31
	ST   -Y,R30
	LDI  R30,LOW(100)
	LDI  R31,HIGH(100)
	ST   -Y,R31
	ST   -Y,R30
	LDD  R30,Y+6
	LDD  R31,Y+6+1
	ST   -Y,R31
	ST   -Y,R30
	LDI  R30,LOW(7)
	ST   -Y,R30
	RCALL _math_InterPolEx
	JMP  _0x2060020
; 0004 007C }
;
;// *****************************************************************************
;// ***        ************************************************
;// *****************************************************************************
;//        . 
;//         .
;//         .
;inline signed int math_InterPol(signed int Val, signed int Max, signed char * Nodes, signed char NodesCount)
; 0004 0085 {
; 0004 0086     //        
; 0004 0087     return(math_InterPolEx(Val, Max, 10, Nodes, NodesCount));
;	Val -> Y+5
;	Max -> Y+3
;	*Nodes -> Y+1
;	NodesCount -> Y+0
; 0004 0088 }
;
;// *****************************************************************************
;// ***       *************************************************
;// *****************************************************************************
;void math_ChangeTrimmer(signed char * trim, signed char dir)
; 0004 008E {
_math_ChangeTrimmer:
; 0004 008F     if(dir == 0) return;
;	*trim -> Y+1
;	dir -> Y+0
	LD   R30,Y
	CPI  R30,0
	BREQ _0x2060023
; 0004 0090     if((dir > 0) && (*trim + dir >  96)) return;
	LD   R26,Y
	CPI  R26,LOW(0x1)
	BRLT _0x80011
	LDD  R26,Y+1
	LDD  R27,Y+1+1
	LD   R30,X
	LD   R26,Y
	ADD  R26,R30
	CPI  R26,LOW(0x61)
	BRGE _0x80012
_0x80011:
	RJMP _0x80010
_0x80012:
	RJMP _0x2060023
; 0004 0091     if((dir < 0) && (*trim + dir < -96)) return;
_0x80010:
	LD   R26,Y
	CPI  R26,0
	BRGE _0x80014
	LDD  R26,Y+1
	LDD  R27,Y+1+1
	LD   R30,X
	LD   R26,Y
	ADD  R26,R30
	CPI  R26,LOW(0xA0)
	BRLT _0x80015
_0x80014:
	RJMP _0x80013
_0x80015:
	RJMP _0x2060023
; 0004 0092     *trim += dir;
_0x80013:
	LDD  R26,Y+1
	LDD  R27,Y+1+1
	MOV  R0,R26
	LD   R30,X
	LD   R26,Y
	ADD  R30,R26
	MOV  R26,R0
	ST   X,R30
; 0004 0093     Trimmers_Need_Save(15);
	LDI  R30,LOW(15)
	ST   -Y,R30
	CALL _Trimmers_Need_Save
; 0004 0094     trim_sound_en = 1;
	LDI  R30,LOW(1)
	STS  _trim_sound_en,R30
; 0004 0095 }
_0x2060023:
	ADIW R28,3
	RET
;
;// *****************************************************************************
;// ***            *************************
;// *****************************************************************************
;void math_CalcControls(void)
; 0004 009B {
_math_CalcControls:
; 0004 009C     char i, Dual[MAX_CONTROLS];
; 0004 009D     int TrimFactor;
; 0004 009E     signed long Factor;
; 0004 009F     unsigned char NewTrimMask = 0;
; 0004 00A0     static unsigned char TrimMask = 0;
; 0004 00A1 
; 0004 00A2     //  
; 0004 00A3     if(MODE_KEY2)                FLY_MODE = 1;
	SBIW R28,15
	CALL __SAVELOCR4
;	i -> R17
;	Dual -> Y+8
;	TrimFactor -> R18,R19
;	Factor -> Y+4
;	NewTrimMask -> R16
	LDI  R16,0
	SBIC 0x1,3
	RJMP _0x80016
	LDI  R30,LOW(1)
	STS  _FLY_MODE,R30
; 0004 00A4     if(!MODE_KEY1 && !MODE_KEY2) FLY_MODE = 0;
_0x80016:
	SBIS 0x1,2
	RJMP _0x80018
	SBIC 0x1,3
	RJMP _0x80019
_0x80018:
	RJMP _0x80017
_0x80019:
	LDI  R30,LOW(0)
	STS  _FLY_MODE,R30
; 0004 00A5     if(MODE_KEY1)                FLY_MODE = 2;
_0x80017:
	SBIC 0x1,2
	RJMP _0x8001A
	LDI  R30,LOW(2)
	STS  _FLY_MODE,R30
; 0004 00A6 
; 0004 00A7     //       
; 0004 00A8     if(trim_0up)   NewTrimMask |= 0x01;
_0x8001A:
	SBIS 0x1,7
	ORI  R16,LOW(1)
; 0004 00A9     if(trim_0down) NewTrimMask |= 0x02;
	SBIS 0x1,6
	ORI  R16,LOW(2)
; 0004 00AA     if(trim_1up)   NewTrimMask |= 0x04;
	SBIS 0x16,2
	ORI  R16,LOW(4)
; 0004 00AB     if(trim_1down) NewTrimMask |= 0x08;
	SBIS 0x16,3
	ORI  R16,LOW(8)
; 0004 00AC     if(trim_2up)   NewTrimMask |= 0x10;
; 0004 00AD     if(trim_2down) NewTrimMask |= 0x20;
; 0004 00AE     if(trim_3up)   NewTrimMask |= 0x40;
	SBIS 0x1,4
	ORI  R16,LOW(64)
; 0004 00AF     if(trim_3down) NewTrimMask |= 0x80;
	SBIS 0x1,5
	ORI  R16,LOW(128)
; 0004 00B0     //     -  
; 0004 00B1     if(NewTrimMask != TrimMask)
	LDS  R30,_TrimMask_S0040005000
	CP   R30,R16
	BREQ _0x80023
; 0004 00B2     {
; 0004 00B3         TrimMask = NewTrimMask;
	STS  _TrimMask_S0040005000,R16
; 0004 00B4     }
; 0004 00B5     //        - 
; 0004 00B6     else if(TrimMask != 0)
	RJMP _0x80024
_0x80023:
	LDS  R30,_TrimMask_S0040005000
	CPI  R30,0
	BRNE PC+3
	JMP _0x80025
; 0004 00B7     {
; 0004 00B8         // 8    8   
; 0004 00B9         for(i=0; i<8; i++)
	LDI  R17,LOW(0)
_0x80027:
	CPI  R17,8
	BRLT PC+3
	JMP _0x80028
; 0004 00BA         {
; 0004 00BB             //     i- 
; 0004 00BC             if(TrimMask & (1 << i))
	MOV  R30,R17
	LDI  R26,LOW(1)
	CALL __LSLB12
	LDS  R26,_TrimMask_S0040005000
	AND  R30,R26
	BRNE PC+3
	JMP _0x80029
; 0004 00BD                 //  i -     
; 0004 00BE                 if(i & 0x01) math_ChangeTrimmer(&CurModel.Mode[FLY_MODE].trimmers[i/2], -1);
	SBRS R17,0
	RJMP _0x8002A
	__POINTW2MN _CurModel,21
	LDS  R30,_FLY_MODE
	LDI  R31,0
	MOVW R22,R26
	LDI  R26,LOW(246)
	LDI  R27,HIGH(246)
	CALL __MULW12U
	ADD  R30,R22
	ADC  R31,R23
	SUBI R30,LOW(-242)
	SBCI R31,HIGH(-242)
	MOVW R22,R30
	MOV  R26,R17
	LDI  R30,LOW(2)
	CALL __DIVB21
	LDI  R31,0
	ADD  R30,R22
	ADC  R31,R23
	ST   -Y,R31
	ST   -Y,R30
	LDI  R30,LOW(255)
	RJMP _0x8004E
; 0004 00BF                 //     
; 0004 00C0                 else         math_ChangeTrimmer(&CurModel.Mode[FLY_MODE].trimmers[i/2],  1);
_0x8002A:
	__POINTW2MN _CurModel,21
	LDS  R30,_FLY_MODE
	LDI  R31,0
	MOVW R22,R26
	LDI  R26,LOW(246)
	LDI  R27,HIGH(246)
	CALL __MULW12U
	ADD  R30,R22
	ADC  R31,R23
	SUBI R30,LOW(-242)
	SBCI R31,HIGH(-242)
	MOVW R22,R30
	MOV  R26,R17
	LDI  R30,LOW(2)
	CALL __DIVB21
	LDI  R31,0
	ADD  R30,R22
	ADC  R31,R23
	ST   -Y,R31
	ST   -Y,R30
	LDI  R30,LOW(1)
_0x8004E:
	ST   -Y,R30
	RCALL _math_ChangeTrimmer
; 0004 00C1         }
_0x80029:
	SUBI R17,-1
	RJMP _0x80027
_0x80028:
; 0004 00C2     }
; 0004 00C3 
; 0004 00C4     //   
; 0004 00C5     if(Tcut_KEY) Cut_enable = 1;
_0x80025:
_0x80024:
	LDS  R30,99
	ANDI R30,LOW(0x1)
	BRNE _0x8002C
	LDI  R30,LOW(1)
	RJMP _0x8004F
; 0004 00C6     else         Cut_enable = 0;
_0x8002C:
	LDI  R30,LOW(0)
_0x8004F:
	STS  _Cut_enable,R30
; 0004 00C7 
; 0004 00C8     //      
; 0004 00C9     for(i=0; i < MAX_ADC; i++)
	LDI  R17,LOW(0)
_0x8002F:
	CPI  R17,8
	BRLT PC+3
	JMP _0x80030
; 0004 00CA     {
; 0004 00CB         AD[i] = read_adc(i);
	MOV  R30,R17
	LDI  R26,LOW(_AD)
	LDI  R27,HIGH(_AD)
	LDI  R31,0
	LSL  R30
	ROL  R31
	ADD  R30,R26
	ADC  R31,R27
	PUSH R31
	PUSH R30
	ST   -Y,R17
	CALL _read_adc
	POP  R26
	POP  R27
	ST   X+,R30
	ST   X,R31
; 0004 00CC         //  ADmid unsigned      
; 0004 00CD         // .     ...
; 0004 00CE         if(AD[i] > Settings.ADmid[i]) AD_NORM[i] = ((AD[i] - Settings.ADmid[i]) * Settings.Kmax[i]) / 10;
	MOV  R30,R17
	LDI  R26,LOW(_AD)
	LDI  R27,HIGH(_AD)
	LDI  R31,0
	LSL  R30
	ROL  R31
	ADD  R26,R30
	ADC  R27,R31
	LD   R0,X+
	LD   R1,X
	__POINTW2MN _Settings,6
	MOV  R30,R17
	LDI  R31,0
	LSL  R30
	ROL  R31
	ADD  R26,R30
	ADC  R27,R31
	CALL __GETW1P
	CP   R30,R0
	CPC  R31,R1
	BRGE _0x80031
	MOV  R30,R17
	LDI  R26,LOW(_AD_NORM)
	LDI  R27,HIGH(_AD_NORM)
	LDI  R31,0
	LSL  R30
	ROL  R31
	ADD  R30,R26
	ADC  R31,R27
	MOVW R22,R30
	MOV  R30,R17
	LDI  R26,LOW(_AD)
	LDI  R27,HIGH(_AD)
	LDI  R31,0
	LSL  R30
	ROL  R31
	ADD  R26,R30
	ADC  R27,R31
	LD   R0,X+
	LD   R1,X
	__POINTW2MN _Settings,6
	MOV  R30,R17
	LDI  R31,0
	LSL  R30
	ROL  R31
	ADD  R26,R30
	ADC  R27,R31
	CALL __GETW1P
	__SUBWRR 0,1,30,31
	__POINTW2MN _Settings,38
	RJMP _0x80050
; 0004 00CF         else                          AD_NORM[i] = ((AD[i] - Settings.ADmid[i]) * Settings.Kmin[i]) / 10;
_0x80031:
	MOV  R30,R17
	LDI  R26,LOW(_AD_NORM)
	LDI  R27,HIGH(_AD_NORM)
	LDI  R31,0
	LSL  R30
	ROL  R31
	ADD  R30,R26
	ADC  R31,R27
	MOVW R22,R30
	MOV  R30,R17
	LDI  R26,LOW(_AD)
	LDI  R27,HIGH(_AD)
	LDI  R31,0
	LSL  R30
	ROL  R31
	ADD  R26,R30
	ADC  R27,R31
	LD   R0,X+
	LD   R1,X
	__POINTW2MN _Settings,6
	MOV  R30,R17
	LDI  R31,0
	LSL  R30
	ROL  R31
	ADD  R26,R30
	ADC  R27,R31
	CALL __GETW1P
	__SUBWRR 0,1,30,31
	__POINTW2MN _Settings,22
_0x80050:
	MOV  R30,R17
	LDI  R31,0
	LSL  R30
	ROL  R31
	ADD  R26,R30
	ADC  R27,R31
	CALL __GETW1P
	MOVW R26,R0
	CALL __MULW12
	MOVW R26,R30
	LDI  R30,LOW(10)
	LDI  R31,HIGH(10)
	CALL __DIVW21
	MOVW R26,R22
	ST   X+,R30
	ST   X,R31
; 0004 00D0     }
	SUBI R17,-1
	RJMP _0x8002F
_0x80030:
; 0004 00D1 
; 0004 00D2     //        
; 0004 00D3     //   
; 0004 00D4     input[CTRL_AIL]  = AD_NORM[ADC_AIL];
	__GETW1MN _AD_NORM,6
	STS  _input,R30
	STS  _input+1,R31
; 0004 00D5     input[CTRL_ELE]  = AD_NORM[ADC_ELE];
	__GETW1MN _AD_NORM,8
	__PUTW1MN _input,2
; 0004 00D6     input[CTRL_THR]  = AD_NORM[ADC_THR];
	__GETW1MN _AD_NORM,10
	__PUTW1MN _input,4
; 0004 00D7     input[CTRL_RUD]  = AD_NORM[ADC_RUD];
	__GETW1MN _AD_NORM,12
	__PUTW1MN _input,6
; 0004 00D8     input[CTRL_AUX1] = AD_NORM[ADC_AUX1];
	__GETW1MN _AD_NORM,4
	__PUTW1MN _input,14
; 0004 00D9 
; 0004 00DA #ifdef SW1
; 0004 00DB     //      SW1 ()
; 0004 00DC     if(SW1) input[CTRL_SW1] =   TimerClockPerSec(0.0005); // +0,5 
; 0004 00DD     else    input[CTRL_SW1] = - TimerClockPerSec(0.0005); // -0,5 
; 0004 00DE #else
; 0004 00DF     //      SW1 ()
; 0004 00E0     if(SW1_1)            input[CTRL_SW1] =   TimerClockPerSec(0.0005); // +0,5 
	SBIC 0x19,1
	RJMP _0x80033
	__POINTW1MN _input,8
	LDI  R26,LOW(1000)
	LDI  R27,HIGH(1000)
	STD  Z+0,R26
	STD  Z+1,R27
; 0004 00E1     if(!SW1_1 && !SW1_2) input[CTRL_SW1] =   0;                     //  0   
_0x80033:
	SBIS 0x19,1
	RJMP _0x80035
	SBIC 0x19,2
	RJMP _0x80036
_0x80035:
	RJMP _0x80034
_0x80036:
	__POINTW1MN _input,8
	LDI  R26,LOW(0)
	LDI  R27,HIGH(0)
	STD  Z+0,R26
	STD  Z+1,R27
; 0004 00E2     if(SW1_2)            input[CTRL_SW1] = - TimerClockPerSec(0.0005); // -0,5 
_0x80034:
	SBIC 0x19,2
	RJMP _0x80037
	__POINTW1MN _input,8
	LDI  R26,LOW(64536)
	LDI  R27,HIGH(64536)
	STD  Z+0,R26
	STD  Z+1,R27
; 0004 00E3 #endif
; 0004 00E4 
; 0004 00E5     //      SW2 ()
; 0004 00E6     if(SW2) input[CTRL_SW2] =   TimerClockPerSec(0.0005); // +0,5 
_0x80037:
	LDS  R30,99
	ANDI R30,LOW(0x2)
	BRNE _0x80038
	__POINTW1MN _input,10
	LDI  R26,LOW(1000)
	LDI  R27,HIGH(1000)
	RJMP _0x80051
; 0004 00E7     else    input[CTRL_SW2] = - TimerClockPerSec(0.0005); // -0,5 
_0x80038:
	__POINTW1MN _input,10
	LDI  R26,LOW(64536)
	LDI  R27,HIGH(64536)
_0x80051:
	STD  Z+0,R26
	STD  Z+1,R27
; 0004 00E8 
; 0004 00E9     //      SW3 ()
; 0004 00EA     if(SW3) input[CTRL_SW3] =   TimerClockPerSec(0.0005); // +0,5 
; 0004 00EB     else    input[CTRL_SW3] = - TimerClockPerSec(0.0005); // -0,5 
	__POINTW1MN _input,12
	LDI  R26,LOW(64536)
	LDI  R27,HIGH(64536)
_0x80052:
	STD  Z+0,R26
	STD  Z+1,R27
; 0004 00EC 
; 0004 00ED     //     
; 0004 00EE     input[CTRL_V1] = input[CurModel.Mode[FLY_MODE].Control[CTRL_V1].from];
	__POINTW2MN _CurModel,21
	LDS  R30,_FLY_MODE
	LDI  R31,0
	MOVW R22,R26
	LDI  R26,LOW(246)
	LDI  R27,HIGH(246)
	CALL __MULW12U
	ADD  R30,R22
	ADC  R31,R23
	ADIW R30,11
	SUBI R30,LOW(-109)
	SBCI R31,HIGH(-109)
	LD   R30,Z
	LDI  R26,LOW(_input)
	LDI  R27,HIGH(_input)
	LDI  R31,0
	LSL  R30
	ROL  R31
	ADD  R26,R30
	ADC  R27,R31
	CALL __GETW1P
	__PUTW1MN _input,16
; 0004 00EF     input[CTRL_V2] = input[CurModel.Mode[FLY_MODE].Control[CTRL_V2].from];
	__POINTW2MN _CurModel,21
	LDS  R30,_FLY_MODE
	LDI  R31,0
	MOVW R22,R26
	LDI  R26,LOW(246)
	LDI  R27,HIGH(246)
	CALL __MULW12U
	ADD  R30,R22
	ADC  R31,R23
	ADIW R30,11
	SUBI R30,LOW(-122)
	SBCI R31,HIGH(-122)
	LD   R30,Z
	LDI  R26,LOW(_input)
	LDI  R27,HIGH(_input)
	LDI  R31,0
	LSL  R30
	ROL  R31
	ADD  R26,R30
	ADC  R27,R31
	CALL __GETW1P
	__PUTW1MN _input,18
; 0004 00F0 
; 0004 00F1     //      .   0,5 .
; 0004 00F2     //        .
; 0004 00F3     input[CTRL_TRIM] = TimerClockPerSec(0.0005);
	__POINTW1MN _input,20
	LDI  R26,LOW(1000)
	LDI  R27,HIGH(1000)
	STD  Z+0,R26
	STD  Z+1,R27
; 0004 00F4 
; 0004 00F5     //    
; 0004 00F6     memset(Dual, 0, sizeof(Dual));
	MOVW R30,R28
	ADIW R30,8
	ST   -Y,R31
	ST   -Y,R30
	LDI  R30,LOW(0)
	ST   -Y,R30
	LDI  R30,LOW(11)
	LDI  R31,HIGH(11)
	ST   -Y,R31
	ST   -Y,R30
	CALL _memset
; 0004 00F7     //   
; 0004 00F8     Dual[CTRL_AIL] = DUAL_AIL;
	LDI  R30,0
	SBIS 0x10,6
	LDI  R30,1
	STD  Y+8,R30
; 0004 00F9     Dual[CTRL_ELE] = DUAL_ELE;
	LDI  R30,0
	SBIS 0x10,7
	LDI  R30,1
	STD  Y+9,R30
; 0004 00FA     Dual[CTRL_RUD] = DUAL_RUD;
	LDI  R30,LOW(0)
	STD  Y+11,R30
; 0004 00FB 
; 0004 00FC     for(i=0; i < MAX_CONTROLS; i++)
	LDI  R17,LOW(0)
_0x8003D:
	CPI  R17,11
	BRLT PC+3
	JMP _0x8003E
; 0004 00FD     {
; 0004 00FE         //      -      .
; 0004 00FF         if((i == CTRL_SW1) ||
; 0004 0100            (i == CTRL_SW2) ||
; 0004 0101            (i == CTRL_SW3) ||
; 0004 0102            (i == CTRL_TRIM))
	CPI  R17,4
	BREQ _0x80040
	CPI  R17,5
	BREQ _0x80040
	CPI  R17,6
	BREQ _0x80040
	CPI  R17,10
	BRNE _0x8003F
_0x80040:
; 0004 0103         {
; 0004 0104             out_cur[i] = input[i];
	MOV  R30,R17
	LDI  R26,LOW(_out_cur)
	LDI  R27,HIGH(_out_cur)
	LDI  R31,0
	LSL  R30
	ROL  R31
	ADD  R30,R26
	ADC  R31,R27
	MOVW R0,R30
	MOV  R30,R17
	LDI  R26,LOW(_input)
	LDI  R27,HIGH(_input)
	LDI  R31,0
	LSL  R30
	ROL  R31
	ADD  R26,R30
	ADC  R27,R31
	CALL __GETW1P
	MOVW R26,R0
	RJMP _0x80053
; 0004 0105         }
; 0004 0106         else
_0x8003F:
; 0004 0107         {
; 0004 0108             //     
; 0004 0109             out_cur[i] = math_CurveInterPol(input[i], CurModel.Mode[FLY_MODE].Control[i].nodes);
	MOV  R30,R17
	LDI  R26,LOW(_out_cur)
	LDI  R27,HIGH(_out_cur)
	LDI  R31,0
	LSL  R30
	ROL  R31
	ADD  R30,R26
	ADC  R31,R27
	PUSH R31
	PUSH R30
	MOV  R30,R17
	LDI  R26,LOW(_input)
	LDI  R27,HIGH(_input)
	LDI  R31,0
	LSL  R30
	ROL  R31
	ADD  R26,R30
	ADC  R27,R31
	CALL __GETW1P
	ST   -Y,R31
	ST   -Y,R30
	__POINTW2MN _CurModel,21
	LDS  R30,_FLY_MODE
	LDI  R31,0
	MOVW R22,R26
	LDI  R26,LOW(246)
	LDI  R27,HIGH(246)
	CALL __MULW12U
	MOVW R26,R22
	ADD  R26,R30
	ADC  R27,R31
	ADIW R26,11
	MOV  R30,R17
	LDI  R31,0
	MOVW R22,R26
	LDI  R26,LOW(13)
	LDI  R27,HIGH(13)
	CALL __MULW12U
	ADD  R30,R22
	ADC  R31,R23
	ADIW R30,6
	ST   -Y,R31
	ST   -Y,R30
	RCALL _math_CurveInterPol_G004
	POP  R26
	POP  R27
_0x80053:
	ST   X+,R30
	ST   X,R31
; 0004 010A         }
; 0004 010B 
; 0004 010C         // 
; 0004 010D         if(Dual[i])
	MOV  R30,R17
	LDI  R31,0
	MOVW R26,R28
	ADIW R26,8
	ADD  R26,R30
	ADC  R27,R31
	LD   R30,X
	CPI  R30,0
	BRNE PC+3
	JMP _0x80043
; 0004 010E         {
; 0004 010F             if(input[i] < 0) Factor = CurModel.Mode[FLY_MODE].Control[i].minDRates;
	MOV  R30,R17
	LDI  R26,LOW(_input)
	LDI  R27,HIGH(_input)
	LDI  R31,0
	LSL  R30
	ROL  R31
	ADD  R26,R30
	ADC  R27,R31
	CALL __GETW1P
	TST  R31
	BRPL _0x80044
	__POINTW2MN _CurModel,21
	LDS  R30,_FLY_MODE
	LDI  R31,0
	MOVW R22,R26
	LDI  R26,LOW(246)
	LDI  R27,HIGH(246)
	CALL __MULW12U
	MOVW R26,R22
	ADD  R26,R30
	ADC  R27,R31
	ADIW R26,11
	MOV  R30,R17
	LDI  R31,0
	MOVW R22,R26
	LDI  R26,LOW(13)
	LDI  R27,HIGH(13)
	CALL __MULW12U
	MOVW R26,R22
	ADD  R26,R30
	ADC  R27,R31
	ADIW R26,4
	RJMP _0x80054
; 0004 0110             else             Factor = CurModel.Mode[FLY_MODE].Control[i].maxDRates;
_0x80044:
	__POINTW2MN _CurModel,21
	LDS  R30,_FLY_MODE
	LDI  R31,0
	MOVW R22,R26
	LDI  R26,LOW(246)
	LDI  R27,HIGH(246)
	CALL __MULW12U
	MOVW R26,R22
	ADD  R26,R30
	ADC  R27,R31
	ADIW R26,11
	MOV  R30,R17
	LDI  R31,0
	MOVW R22,R26
	LDI  R26,LOW(13)
	LDI  R27,HIGH(13)
	CALL __MULW12U
	MOVW R26,R22
	ADD  R26,R30
	ADC  R27,R31
	ADIW R26,3
_0x80054:
	LD   R30,X
	CLR  R31
	CLR  R22
	CLR  R23
	__PUTD1S 4
; 0004 0111         }
; 0004 0112         else
	RJMP _0x80046
_0x80043:
; 0004 0113         {
; 0004 0114             if(input[i] < 0) Factor = CurModel.Mode[FLY_MODE].Control[i].minRates;
	MOV  R30,R17
	LDI  R26,LOW(_input)
	LDI  R27,HIGH(_input)
	LDI  R31,0
	LSL  R30
	ROL  R31
	ADD  R26,R30
	ADC  R27,R31
	CALL __GETW1P
	TST  R31
	BRPL _0x80047
	__POINTW2MN _CurModel,21
	LDS  R30,_FLY_MODE
	LDI  R31,0
	MOVW R22,R26
	LDI  R26,LOW(246)
	LDI  R27,HIGH(246)
	CALL __MULW12U
	MOVW R26,R22
	ADD  R26,R30
	ADC  R27,R31
	ADIW R26,11
	MOV  R30,R17
	LDI  R31,0
	MOVW R22,R26
	LDI  R26,LOW(13)
	LDI  R27,HIGH(13)
	CALL __MULW12U
	MOVW R26,R22
	ADD  R26,R30
	ADC  R27,R31
	ADIW R26,2
	RJMP _0x80055
; 0004 0115             else             Factor = CurModel.Mode[FLY_MODE].Control[i].maxRates;
_0x80047:
	__POINTW2MN _CurModel,21
	LDS  R30,_FLY_MODE
	LDI  R31,0
	MOVW R22,R26
	LDI  R26,LOW(246)
	LDI  R27,HIGH(246)
	CALL __MULW12U
	MOVW R26,R22
	ADD  R26,R30
	ADC  R27,R31
	ADIW R26,11
	MOV  R30,R17
	LDI  R31,0
	MOVW R22,R26
	LDI  R26,LOW(13)
	LDI  R27,HIGH(13)
	CALL __MULW12U
	MOVW R26,R22
	ADD  R26,R30
	ADC  R27,R31
	ADIW R26,1
_0x80055:
	LD   R30,X
	CLR  R31
	CLR  R22
	CLR  R23
	__PUTD1S 4
; 0004 0116         }
_0x80046:
; 0004 0117         if(Factor != 100) out_cur[i] = out_cur[i] * Factor / 100;
	__GETD2S 4
	__CPD2N 0x64
	BREQ _0x80049
	MOV  R30,R17
	LDI  R26,LOW(_out_cur)
	LDI  R27,HIGH(_out_cur)
	LDI  R31,0
	LSL  R30
	ROL  R31
	ADD  R30,R26
	ADC  R31,R27
	PUSH R31
	PUSH R30
	MOV  R30,R17
	LDI  R26,LOW(_out_cur)
	LDI  R27,HIGH(_out_cur)
	LDI  R31,0
	LSL  R30
	ROL  R31
	ADD  R26,R30
	ADC  R27,R31
	CALL __GETW1P
	MOVW R26,R30
	__GETD1S 4
	CALL __CWD2
	CALL __MULD12
	MOVW R26,R30
	MOVW R24,R22
	__GETD1N 0x64
	CALL __DIVD21
	POP  R26
	POP  R27
	ST   X+,R30
	ST   X,R31
; 0004 0118 
; 0004 0119         //   T.Cut
; 0004 011A         if((i == CTRL_THR) && Cut_enable)
_0x80049:
	CPI  R17,2
	BRNE _0x8004B
	LDS  R30,_Cut_enable
	CPI  R30,0
	BRNE _0x8004C
_0x8004B:
	RJMP _0x8004A
_0x8004C:
; 0004 011B         {
; 0004 011C             Factor = CurModel.Mode[FLY_MODE].Control[i].minDRates; // minDRates    -   T.Cut
	__POINTW2MN _CurModel,21
	LDS  R30,_FLY_MODE
	LDI  R31,0
	MOVW R22,R26
	LDI  R26,LOW(246)
	LDI  R27,HIGH(246)
	CALL __MULW12U
	MOVW R26,R22
	ADD  R26,R30
	ADC  R27,R31
	ADIW R26,11
	MOV  R30,R17
	LDI  R31,0
	MOVW R22,R26
	LDI  R26,LOW(13)
	LDI  R27,HIGH(13)
	CALL __MULW12U
	MOVW R26,R22
	ADD  R26,R30
	ADC  R27,R31
	ADIW R26,4
	LD   R30,X
	CLR  R31
	CLR  R22
	CLR  R23
	__PUTD1S 4
; 0004 011D             out_cur[i] = (- TimerClockPerSec(0.0005)) * Factor / 100;
	MOV  R30,R17
	LDI  R26,LOW(_out_cur)
	LDI  R27,HIGH(_out_cur)
	LDI  R31,0
	LSL  R30
	ROL  R31
	ADD  R30,R26
	ADC  R31,R27
	PUSH R31
	PUSH R30
	__GETD1S 4
	__GETD2N 0xFFFFFC18
	CALL __MULD12
	MOVW R26,R30
	MOVW R24,R22
	__GETD1N 0x64
	CALL __DIVD21
	POP  R26
	POP  R27
	ST   X+,R30
	ST   X,R31
; 0004 011E         }
; 0004 011F 
; 0004 0120         //      
; 0004 0121         // FIX ME:    enum
; 0004 0122         if(i < MAX_TRIMMERS)
_0x8004A:
	CPI  R17,4
	BRGE _0x8004D
; 0004 0123         {
; 0004 0124             TrimFactor = CurModel.Mode[FLY_MODE].trimmers[i];
	__POINTW2MN _CurModel,21
	LDS  R30,_FLY_MODE
	LDI  R31,0
	MOVW R22,R26
	LDI  R26,LOW(246)
	LDI  R27,HIGH(246)
	CALL __MULW12U
	MOVW R26,R22
	ADD  R26,R30
	ADC  R27,R31
	SUBI R26,LOW(-242)
	SBCI R27,HIGH(-242)
	CLR  R30
	ADD  R26,R17
	ADC  R27,R30
	LD   R30,X
	LDI  R31,0
	SBRC R30,7
	SER  R31
	MOVW R18,R30
; 0004 0125             out_cur[i] += TrimFactor * 2; // FIX ME:   ,   
	MOV  R30,R17
	LDI  R26,LOW(_out_cur)
	LDI  R27,HIGH(_out_cur)
	LDI  R31,0
	LSL  R30
	ROL  R31
	ADD  R30,R26
	ADC  R31,R27
	MOVW R0,R30
	MOVW R26,R30
	CALL __GETW1P
	MOVW R26,R30
	MOVW R30,R18
	LSL  R30
	ROL  R31
	ADD  R30,R26
	ADC  R31,R27
	MOVW R26,R0
	ST   X+,R30
	ST   X,R31
; 0004 0126         }
; 0004 0127 
; 0004 0128         //   
; 0004 0129         out_cur[i] *= CurModel.Mode[FLY_MODE].Control[i].reverse;
_0x8004D:
	MOV  R30,R17
	LDI  R26,LOW(_out_cur)
	LDI  R27,HIGH(_out_cur)
	LDI  R31,0
	LSL  R30
	ROL  R31
	ADD  R30,R26
	ADC  R31,R27
	PUSH R31
	PUSH R30
	MOVW R26,R30
	CALL __GETW1P
	PUSH R31
	PUSH R30
	__POINTW2MN _CurModel,21
	LDS  R30,_FLY_MODE
	LDI  R31,0
	MOVW R22,R26
	LDI  R26,LOW(246)
	LDI  R27,HIGH(246)
	CALL __MULW12U
	MOVW R26,R22
	ADD  R26,R30
	ADC  R27,R31
	ADIW R26,11
	MOV  R30,R17
	LDI  R31,0
	MOVW R22,R26
	LDI  R26,LOW(13)
	LDI  R27,HIGH(13)
	CALL __MULW12U
	MOVW R26,R22
	ADD  R26,R30
	ADC  R27,R31
	LD   R30,X
	POP  R26
	POP  R27
	LDI  R31,0
	SBRC R30,7
	SER  R31
	CALL __MULW12
	POP  R26
	POP  R27
	ST   X+,R30
	ST   X,R31
; 0004 012A     }
	SUBI R17,-1
	RJMP _0x8003D
_0x8003E:
; 0004 012B }
	CALL __LOADLOCR4
	ADIW R28,19
	RET
;/*******************************************************************************
;*  Sound.c
;*
;*  :   
;*
;*       Copyright (c) 2008 Nick Shl
;*           All rights reserved.
;*
;*
;*  :
;*
;*  May 07, 2008  Nick_Shl   
;*
;*/// ***************************************************************************
;
;// *****************************************************************************
;// ***       ***************************************************
;// *****************************************************************************
;#include <mega128.h>
	#ifndef __SLEEP_DEFINED__
	#define __SLEEP_DEFINED__
	.EQU __se_bit=0x20
	.EQU __sm_mask=0x1C
	.EQU __sm_powerdown=0x10
	.EQU __sm_powersave=0x18
	.EQU __sm_standby=0x14
	.EQU __sm_ext_standby=0x1C
	.EQU __sm_adc_noise_red=0x08
	.SET power_ctrl_reg=mcucr
	#endif
;#include <delay.h>
;#include <stdio.h>
;
;// *****************************************************************************
;// ***       ********************************************
;// *****************************************************************************
;#include "Def.h"
;#include "Variables.h"
;#include "Sound.h"
;
;// *****************************************************************************
;// ***       ***********************************************
;// *****************************************************************************
;static flash unsigned int * SoundTable;
;static unsigned int SoundTableSize;
;static unsigned int SoundTablePosition;
;
;// *****************************************************************************
;// ***    Buzzer'   Freq   **********************************
;// *****************************************************************************
;void Tone(unsigned int Freq)
; 0005 0029 {

	.CSEG
_Tone:
; 0005 002A     //    :
; 0005 002B     // Clock source: System Clock
; 0005 002C     // Mode: CTC top = OCR2
; 0005 002D     // OC2 output: Toggle on compare match
; 0005 002E     //       ,  :
; 0005 002F     //   64     ~750
; 0005 0030     //   256   > ~1500   
; 0005 0031     //   4   ,   AVR_Clock_Freq/x   word
; 0005 0032     //     ,    
; 0005 0033     //    -       
; 0005 0034     if((Settings.SoundFlag == ON) && (Freq > 1000))
;	Freq -> Y+0
	__GETB2MN _Settings,3
	CPI  R26,LOW(0x1)
	BRNE _0xA0004
	LD   R26,Y
	LDD  R27,Y+1
	CPI  R26,LOW(0x3E9)
	LDI  R30,HIGH(0x3E9)
	CPC  R27,R30
	BRSH _0xA0005
_0xA0004:
	RJMP _0xA0003
_0xA0005:
; 0005 0035     {
; 0005 0036         //    
; 0005 0037         OCR2 = (((AVR_Clock_Freq/64) >> 2) / (Freq >> 2)) >> 1;
	LD   R30,Y
	LDD  R31,Y+1
	CALL __LSRW2
	LDI  R26,LOW(62500)
	LDI  R27,HIGH(62500)
	CALL __DIVW21U
	LSR  R31
	ROR  R30
	OUT  0x23,R30
; 0005 0038         //  (Clock divisor: 64):
; 0005 0039         TCCR2 = 0b00011011;
	LDI  R30,LOW(27)
	OUT  0x25,R30
; 0005 003A     }
; 0005 003B     else if((Settings.SoundFlag == ON) && Freq)
	RJMP _0xA0006
_0xA0003:
	__GETB2MN _Settings,3
	CPI  R26,LOW(0x1)
	BRNE _0xA0008
	LD   R30,Y
	LDD  R31,Y+1
	SBIW R30,0
	BRNE _0xA0009
_0xA0008:
	RJMP _0xA0007
_0xA0009:
; 0005 003C     {
; 0005 003D         //    
; 0005 003E         OCR2 = ((AVR_Clock_Freq/256) / Freq) >> 1;
	LD   R30,Y
	LDD  R31,Y+1
	LDI  R26,LOW(62500)
	LDI  R27,HIGH(62500)
	CALL __DIVW21U
	LSR  R31
	ROR  R30
	OUT  0x23,R30
; 0005 003F         //  (Clock divisor: 256):
; 0005 0040         TCCR2 = 0b00011100;
	LDI  R30,LOW(28)
	OUT  0x25,R30
; 0005 0041     }
; 0005 0042     else
	RJMP _0xA000A
_0xA0007:
; 0005 0043     {
; 0005 0044         //  
; 0005 0045         TCCR2 = 0b00000000;
	LDI  R30,LOW(0)
	OUT  0x25,R30
; 0005 0046         //    , ..       
; 0005 0047         PORTB.7 = 0;
	CBI  0x18,7
; 0005 0048     }
_0xA000A:
_0xA0006:
; 0005 0049 }
_0x2060022:
	ADIW R28,2
	RET
;
;// *****************************************************************************
;// ***    Buzzer'  Del ,   Freq   ***************
;// *****************************************************************************
;void Beep(unsigned int Freq, unsigned int Del, unsigned char PauseAfterPlay)
; 0005 004F {
_Beep:
; 0005 0050     //    - 
; 0005 0051     if(Settings.SoundFlag == OFF) return;
;	Freq -> Y+3
;	Del -> Y+1
;	PauseAfterPlay -> Y+0
	__GETB1MN _Settings,3
	CPI  R30,0
	BREQ _0x2060021
; 0005 0052 
; 0005 0053     Tone(Freq);
	LDD  R30,Y+3
	LDD  R31,Y+3+1
	ST   -Y,R31
	ST   -Y,R30
	RCALL _Tone
; 0005 0054     delay_ms(Del); // 
	LDD  R30,Y+1
	LDD  R31,Y+1+1
	ST   -Y,R31
	ST   -Y,R30
	CALL _delay_ms
; 0005 0055     Tone(0);
	LDI  R30,LOW(0)
	LDI  R31,HIGH(0)
	ST   -Y,R31
	ST   -Y,R30
	RCALL _Tone
; 0005 0056 
; 0005 0057     //    -       
; 0005 0058     if(PauseAfterPlay) delay_ms(Del);
	LD   R30,Y
	CPI  R30,0
	BREQ _0xA000E
	LDD  R30,Y+1
	LDD  R31,Y+1+1
	ST   -Y,R31
	ST   -Y,R30
	CALL _delay_ms
; 0005 0059 }
_0xA000E:
_0x2060021:
	ADIW R28,5
	RET
;
;// *****************************************************************************
;// ***          *******************************
;// *****************************************************************************
;void PlaySound(flash unsigned int * Melody, unsigned int N)
; 0005 005F {
_PlaySound:
; 0005 0060     //    -       .
; 0005 0061     //    0x***#,  *** , # -   40 
; 0005 0062     // 
; 0005 0063 
; 0005 0064     //      - 
; 0005 0065     if(Melody == NULL) return;
;	*Melody -> Y+2
;	N -> Y+0
	LDD  R30,Y+2
	LDD  R31,Y+2+1
	SBIW R30,0
	BREQ _0x2060020
; 0005 0066 
; 0005 0067     //    ,    - 
; 0005 0068     if(IsSoundPlayed() == TRUE) StopSound();
	RCALL _IsSoundPlayed
	CPI  R30,LOW(0x1)
	BRNE _0xA0010
	RCALL _StopSound
; 0005 0069 
; 0005 006A     //   
; 0005 006B     SoundTablePosition = 0;
_0xA0010:
	LDI  R30,LOW(0)
	STS  _SoundTablePosition_G005,R30
	STS  _SoundTablePosition_G005+1,R30
; 0005 006C     //   
; 0005 006D     SoundTableSize = N;
	LD   R30,Y
	LDD  R31,Y+1
	STS  _SoundTableSize_G005,R30
	STS  _SoundTableSize_G005+1,R31
; 0005 006E     //     -   , ..
; 0005 006F     //      
; 0005 0070     SoundTable = Melody;
	LDD  R30,Y+2
	LDD  R31,Y+2+1
	STS  _SoundTable_G005,R30
	STS  _SoundTable_G005+1,R31
; 0005 0071 }
_0x2060020:
	ADIW R28,4
	RET
;
;// *****************************************************************************
;// ***           ***********************
;// *****************************************************************************
;void StopSound(void)
; 0005 0077 {
_StopSound:
; 0005 0078     //     -   , .. 
; 0005 0079     //     
; 0005 007A     SoundTable = (flash unsigned int *)NULL;
	LDI  R30,LOW(0)
	STS  _SoundTable_G005,R30
	STS  _SoundTable_G005+1,R30
; 0005 007B     //   
; 0005 007C     SoundTableSize = 0;
	STS  _SoundTableSize_G005,R30
	STS  _SoundTableSize_G005+1,R30
; 0005 007D     //   
; 0005 007E     SoundTablePosition = 0;
	STS  _SoundTablePosition_G005,R30
	STS  _SoundTablePosition_G005+1,R30
; 0005 007F     //   
; 0005 0080     Tone(0);
	LDI  R30,LOW(0)
	LDI  R31,HIGH(0)
	ST   -Y,R31
	ST   -Y,R30
	RCALL _Tone
; 0005 0081 }
	RET
;
;// *****************************************************************************
;// ***      -  TRUE,  - FALSE   *********
;// *****************************************************************************
;inline char IsSoundPlayed(void)
; 0005 0087 {
_IsSoundPlayed:
; 0005 0088     //       -  
; 0005 0089     if(SoundTable != NULL) return(TRUE);
	LDS  R30,_SoundTable_G005
	LDS  R31,_SoundTable_G005+1
	SBIW R30,0
	BREQ _0xA0011
	LDI  R30,LOW(1)
	RET
; 0005 008A     //  -  
; 0005 008B     return(FALSE);
_0xA0011:
	LDI  R30,LOW(0)
	RET
; 0005 008C }
;
;// *****************************************************************************
;// ***          *******************************
;// *****************************************************************************
;void PlaySound_Task(unsigned char MissedInterruptsCount)
; 0005 0092 {
_PlaySound_Task:
; 0005 0093     static char Delay;
; 0005 0094 
; 0005 0095     //      - 
; 0005 0096     if(SoundTable == NULL) return;
;	MissedInterruptsCount -> Y+0
	LDS  R30,_SoundTable_G005
	LDS  R31,_SoundTable_G005+1
	SBIW R30,0
	BRNE _0xA0012
	RJMP _0x206001F
; 0005 0097     //      - 
; 0005 0098     if(SoundTableSize == 0) return;
_0xA0012:
	LDS  R30,_SoundTableSize_G005
	LDS  R31,_SoundTableSize_G005+1
	SBIW R30,0
	BRNE _0xA0013
	RJMP _0x206001F
; 0005 0099 
; 0005 009A     //   :     TASK_TICK_TIME  + 
; 0005 009B     Delay -= (MissedInterruptsCount + 1);
_0xA0013:
	LD   R30,Y
	SUBI R30,-LOW(1)
	LDS  R26,_Delay_S0050005000
	SUB  R26,R30
	STS  _Delay_S0050005000,R26
; 0005 009C     //      -    .
; 0005 009D     if(Delay > 0) return;
	CPI  R26,LOW(0x1)
	BRLT _0xA0014
	RJMP _0x206001F
; 0005 009E 
; 0005 009F     //    18  -  .  - .
; 0005 00A0     if((SoundTable[SoundTablePosition] >> 4) > 0x12) Tone(SoundTable[SoundTablePosition] >> 4);
_0xA0014:
	LDS  R30,_SoundTablePosition_G005
	LDS  R31,_SoundTablePosition_G005+1
	LDS  R26,_SoundTable_G005
	LDS  R27,_SoundTable_G005+1
	LSL  R30
	ROL  R31
	ADD  R30,R26
	ADC  R31,R27
	CALL __GETW1PF
	CALL __LSRW4
	SBIW R30,19
	BRLO _0xA0015
	LDS  R30,_SoundTablePosition_G005
	LDS  R31,_SoundTablePosition_G005+1
	LSL  R30
	ROL  R31
	ADD  R30,R26
	ADC  R31,R27
	CALL __GETW1PF
	CALL __LSRW4
	RJMP _0xA001B
; 0005 00A1     else                                             Tone(0);
_0xA0015:
	LDI  R30,LOW(0)
	LDI  R31,HIGH(0)
_0xA001B:
	ST   -Y,R31
	ST   -Y,R30
	RCALL _Tone
; 0005 00A2 
; 0005 00A3     //     TASK_TICK_TIME*3  
; 0005 00A4     // FIX ME:    TASK_TICK_TIME*3
; 0005 00A5     Delay = ((SoundTable[SoundTablePosition] & 0x0F) + 1) * 3;
	LDS  R30,_SoundTablePosition_G005
	LDS  R31,_SoundTablePosition_G005+1
	LDS  R26,_SoundTable_G005
	LDS  R27,_SoundTable_G005+1
	LSL  R30
	ROL  R31
	ADD  R30,R26
	ADC  R31,R27
	LPM  R30,Z
	ANDI R30,LOW(0xF)
	SUBI R30,-LOW(1)
	LDI  R26,LOW(3)
	MUL  R30,R26
	MOVW R30,R0
	STS  _Delay_S0050005000,R30
; 0005 00A6 
; 0005 00A7     //    
; 0005 00A8     SoundTablePosition++;
	LDI  R26,LOW(_SoundTablePosition_G005)
	LDI  R27,HIGH(_SoundTablePosition_G005)
	LD   R30,X+
	LD   R31,X+
	ADIW R30,1
	ST   -X,R31
	ST   -X,R30
; 0005 00A9     //      - 
; 0005 00AA     if(SoundTablePosition > SoundTableSize) StopSound();
	LDS  R30,_SoundTableSize_G005
	LDS  R31,_SoundTableSize_G005+1
	LDS  R26,_SoundTablePosition_G005
	LDS  R27,_SoundTablePosition_G005+1
	CP   R30,R26
	CPC  R31,R27
	BRSH _0xA0017
	RCALL _StopSound
; 0005 00AB }
_0xA0017:
_0x206001F:
	ADIW R28,1
	RET
;
;// *****************************************************************************
;// ***    Buzzer'      **************************
;// *****************************************************************************
;void trim_sound(void)
; 0005 00B1 {
_trim_sound:
; 0005 00B2     if(trim_sound_en && (Settings.SoundFlag == ON))
	LDS  R30,_trim_sound_en
	CPI  R30,0
	BREQ _0xA0019
	__GETB2MN _Settings,3
	CPI  R26,LOW(0x1)
	BREQ _0xA001A
_0xA0019:
	RJMP _0xA0018
_0xA001A:
; 0005 00B3     {
; 0005 00B4         trim_sound_en=0;
	LDI  R30,LOW(0)
	STS  _trim_sound_en,R30
; 0005 00B5         Tone(1000);     //    1kHz
	LDI  R30,LOW(1000)
	LDI  R31,HIGH(1000)
	ST   -Y,R31
	ST   -Y,R30
	RCALL _Tone
; 0005 00B6         delay_ms(30);   // 
	LDI  R30,LOW(30)
	LDI  R31,HIGH(30)
	ST   -Y,R31
	ST   -Y,R30
	CALL _delay_ms
; 0005 00B7         Tone(0);        //  
	LDI  R30,LOW(0)
	LDI  R31,HIGH(0)
	ST   -Y,R31
	ST   -Y,R30
	RCALL _Tone
; 0005 00B8         delay_ms(30);   // 
	LDI  R30,LOW(30)
	LDI  R31,HIGH(30)
	ST   -Y,R31
	ST   -Y,R30
	CALL _delay_ms
; 0005 00B9     }
; 0005 00BA }
_0xA0018:
	RET
;/*******************************************************************************
;*  Crc.h
;*
;*  :  CRC
;*
;*       Copyright (c) 2008 Nick Shl
;*           All rights reserved.
;*
;*
;*  :
;*
;*  Feb 24, 2009  Nick_Shl   
;*
;*/// ***************************************************************************
;
;/*
;  Name  : CRC-16 CCITT
;  Poly  : 0x11021	x^16 + x^12 + x^5 + 1
;  Init  : 0xFFFF
;  Revert: false
;  XorOut: 0x0000
;  Check : 0x29B1 ("123456789")
;  MaxLen: 4095  (32767 ) - 
;    , ,     
;*/
;const unsigned short Crc16Table[256] = {
;    0x0000, 0x1021, 0x2042, 0x3063, 0x4084, 0x50A5, 0x60C6, 0x70E7,
;    0x8108, 0x9129, 0xA14A, 0xB16B, 0xC18C, 0xD1AD, 0xE1CE, 0xF1EF,
;    0x1231, 0x0210, 0x3273, 0x2252, 0x52B5, 0x4294, 0x72F7, 0x62D6,
;    0x9339, 0x8318, 0xB37B, 0xA35A, 0xD3BD, 0xC39C, 0xF3FF, 0xE3DE,
;    0x2462, 0x3443, 0x0420, 0x1401, 0x64E6, 0x74C7, 0x44A4, 0x5485,
;    0xA56A, 0xB54B, 0x8528, 0x9509, 0xE5EE, 0xF5CF, 0xC5AC, 0xD58D,
;    0x3653, 0x2672, 0x1611, 0x0630, 0x76D7, 0x66F6, 0x5695, 0x46B4,
;    0xB75B, 0xA77A, 0x9719, 0x8738, 0xF7DF, 0xE7FE, 0xD79D, 0xC7BC,
;    0x48C4, 0x58E5, 0x6886, 0x78A7, 0x0840, 0x1861, 0x2802, 0x3823,
;    0xC9CC, 0xD9ED, 0xE98E, 0xF9AF, 0x8948, 0x9969, 0xA90A, 0xB92B,
;    0x5AF5, 0x4AD4, 0x7AB7, 0x6A96, 0x1A71, 0x0A50, 0x3A33, 0x2A12,
;    0xDBFD, 0xCBDC, 0xFBBF, 0xEB9E, 0x9B79, 0x8B58, 0xBB3B, 0xAB1A,
;    0x6CA6, 0x7C87, 0x4CE4, 0x5CC5, 0x2C22, 0x3C03, 0x0C60, 0x1C41,
;    0xEDAE, 0xFD8F, 0xCDEC, 0xDDCD, 0xAD2A, 0xBD0B, 0x8D68, 0x9D49,
;    0x7E97, 0x6EB6, 0x5ED5, 0x4EF4, 0x3E13, 0x2E32, 0x1E51, 0x0E70,
;    0xFF9F, 0xEFBE, 0xDFDD, 0xCFFC, 0xBF1B, 0xAF3A, 0x9F59, 0x8F78,
;    0x9188, 0x81A9, 0xB1CA, 0xA1EB, 0xD10C, 0xC12D, 0xF14E, 0xE16F,
;    0x1080, 0x00A1, 0x30C2, 0x20E3, 0x5004, 0x4025, 0x7046, 0x6067,
;    0x83B9, 0x9398, 0xA3FB, 0xB3DA, 0xC33D, 0xD31C, 0xE37F, 0xF35E,
;    0x02B1, 0x1290, 0x22F3, 0x32D2, 0x4235, 0x5214, 0x6277, 0x7256,
;    0xB5EA, 0xA5CB, 0x95A8, 0x8589, 0xF56E, 0xE54F, 0xD52C, 0xC50D,
;    0x34E2, 0x24C3, 0x14A0, 0x0481, 0x7466, 0x6447, 0x5424, 0x4405,
;    0xA7DB, 0xB7FA, 0x8799, 0x97B8, 0xE75F, 0xF77E, 0xC71D, 0xD73C,
;    0x26D3, 0x36F2, 0x0691, 0x16B0, 0x6657, 0x7676, 0x4615, 0x5634,
;    0xD94C, 0xC96D, 0xF90E, 0xE92F, 0x99C8, 0x89E9, 0xB98A, 0xA9AB,
;    0x5844, 0x4865, 0x7806, 0x6827, 0x18C0, 0x08E1, 0x3882, 0x28A3,
;    0xCB7D, 0xDB5C, 0xEB3F, 0xFB1E, 0x8BF9, 0x9BD8, 0xABBB, 0xBB9A,
;    0x4A75, 0x5A54, 0x6A37, 0x7A16, 0x0AF1, 0x1AD0, 0x2AB3, 0x3A92,
;    0xFD2E, 0xED0F, 0xDD6C, 0xCD4D, 0xBDAA, 0xAD8B, 0x9DE8, 0x8DC9,
;    0x7C26, 0x6C07, 0x5C64, 0x4C45, 0x3CA2, 0x2C83, 0x1CE0, 0x0CC1,
;    0xEF1F, 0xFF3E, 0xCF5D, 0xDF7C, 0xAF9B, 0xBFBA, 0x8FD9, 0x9FF8,
;    0x6E17, 0x7E36, 0x4E55, 0x5E74, 0x2E93, 0x3EB2, 0x0ED1, 0x1EF0
;};
;
;// *****************************************************************************
;// ***    CRC    Flash   *****************************
;// *****************************************************************************
;unsigned short Crc16_flash(unsigned char flash * pcBlock, unsigned short len)
; 0006 0041 {

	.CSEG
; 0006 0042     unsigned short crc = 0xFFFF;
; 0006 0043     while (len--) crc = (crc << 8) ^ Crc16Table[(crc >> 8) ^ *pcBlock++];
;	*pcBlock -> Y+4
;	len -> Y+2
;	crc -> R16,R17
; 0006 0044 return crc;
; 0006 0045 }
;
;// *****************************************************************************
;// ***    CRC    EEPROM   *****************************
;// *****************************************************************************
;unsigned short Crc16_eeprom(unsigned char eeprom * pcBlock, unsigned short len)
; 0006 004B {
_Crc16_eeprom:
; 0006 004C     unsigned short crc = 0xFFFF;
; 0006 004D     while (len--) crc = (crc << 8) ^ Crc16Table[(crc >> 8) ^ *pcBlock++];
	ST   -Y,R17
	ST   -Y,R16
;	*pcBlock -> Y+4
;	len -> Y+2
;	crc -> R16,R17
	__GETWRN 16,17,-1
_0xC0006:
	LDD  R30,Y+2
	LDD  R31,Y+2+1
	SBIW R30,1
	STD  Y+2,R30
	STD  Y+2+1,R31
	ADIW R30,1
	BREQ _0xC0008
	MOV  R31,R16
	LDI  R30,LOW(0)
	MOVW R22,R30
	MOV  R30,R17
	ANDI R31,HIGH(0x0)
	MOVW R0,R30
	LDD  R26,Y+4
	LDD  R27,Y+4+1
	ADIW R26,1
	STD  Y+4,R26
	STD  Y+4+1,R27
	SBIW R26,1
	CALL __EEPROMRDB
	LDI  R31,0
	EOR  R30,R0
	EOR  R31,R1
	LDI  R26,LOW(_Crc16Table*2)
	LDI  R27,HIGH(_Crc16Table*2)
	LSL  R30
	ROL  R31
	ADD  R30,R26
	ADC  R31,R27
	CALL __GETW1PF
	EOR  R30,R22
	EOR  R31,R23
	MOVW R16,R30
	RJMP _0xC0006
_0xC0008:
; 0006 004E return crc;
	MOVW R30,R16
	LDD  R17,Y+1
	LDD  R16,Y+0
_0x206001E:
	ADIW R28,6
	RET
; 0006 004F }
;
;// *****************************************************************************
;// ***    CRC    RAM   ********************************
;// *****************************************************************************
;unsigned short Crc16_ram(unsigned char * pcBlock, unsigned short len)
; 0006 0055 {
; 0006 0056     unsigned short crc = 0xFFFF;
; 0006 0057     while (len--) crc = (crc << 8) ^ Crc16Table[(crc >> 8) ^ *pcBlock++];
;	*pcBlock -> Y+4
;	len -> Y+2
;	crc -> R16,R17
; 0006 0058 return crc;
; 0006 0059 }
;/*******************************************************************************
;*  Demo.c
;*
;*  : 
;*
;*       Copyright (c) 2007-2009 Nick Shl, focus
;*           All rights reserved.
;*
;*
;*  :
;*
;*  Mar 23, 2009  Nick_Shl   
;*
;*/// ***************************************************************************
;
;// *****************************************************************************
;// ***       ***************************************************
;// *****************************************************************************
;#include <mega128.h>
	#ifndef __SLEEP_DEFINED__
	#define __SLEEP_DEFINED__
	.EQU __se_bit=0x20
	.EQU __sm_mask=0x1C
	.EQU __sm_powerdown=0x10
	.EQU __sm_powersave=0x18
	.EQU __sm_standby=0x14
	.EQU __sm_ext_standby=0x1C
	.EQU __sm_adc_noise_red=0x08
	.SET power_ctrl_reg=mcucr
	#endif
;#include <delay.h>
;#include <stdio.h>
;
;// *****************************************************************************
;// ***       ********************************************
;// *****************************************************************************
;#include "Def.h"
;#include "Hardware.h"
;#include "Coder.h"
;#include "Graphic.h"
;#include "Sound.h"
;#include "Variables.h"
;#include "UI_Engine.h"
;
;// *****************************************************************************
;// ***       ***********************************************
;// *****************************************************************************
;flash unsigned int DataTable[]={
;0x0A51, 0x0F71, 0x14A1, 0x1881, 0x0A51, 0x0F71, 0x14A1, 0x1881, 0x0A51, 0x0F71, 0x14A1, 0x1881, 0x0A51, 0x0F71, 0x14A1,
;0x1881, 0x0A51, 0x1061, 0x14A1, 0x1B81, 0x0A51, 0x1061, 0x14A1, 0x1B81, 0x0A51, 0x1061, 0x14A1, 0x1B81, 0x0A51, 0x1061,
;0x14A1, 0x1B81, 0x0A51, 0x0DC1, 0x1261, 0x1721, 0x0A51, 0x0DC1, 0x1261, 0x1721, 0x0A51, 0x0DC1, 0x1261, 0x1721, 0x0A51,
;0x0DC1, 0x1261, 0x1721, 0x0A51, 0x0F71, 0x14A1, 0x1881, 0x0A51, 0x0F71, 0x14A1, 0x1881, 0x0A51, 0x0F71, 0x14A1, 0x1881,
;0x0A51, 0x0F71, 0x14A1, 0x1881, 0x0931, 0x1061, 0x1721, 0x1B81, 0x0931, 0x1061, 0x1721, 0x1B81, 0x0931, 0x1061, 0x1721,
;0x1B81, 0x0931, 0x1061, 0x1721, 0x1B81, 0x0C41, 0x0F71, 0x1261, 0x1EE1, 0x0C41, 0x0F71, 0x1261, 0x1EE1, 0x0C41, 0x0F71,
;0x1261, 0x1EE1, 0x0C41, 0x0F71, 0x1261, 0x1EE1, 0x0831, 0x0C41, 0x14A1, 0x1EE1, 0x0831, 0x0C41, 0x14A1, 0x1EE1, 0x0831,
;0x0B91, 0x14A1, 0x1B81, 0x0831, 0x0B91, 0x14A1, 0x1B81, 0x07B1, 0x0C41, 0x14A1, 0x1EE1, 0x07B1, 0x0C41, 0x14A1, 0x1EE1,
;0x07B1, 0x0DC1, 0x1061, 0x1371, 0x07B1, 0x0DC1, 0x0F71, 0x1371, 0x0A51, 0x0C41, 0x0F71, 0x14A1, 0x0A51, 0x0C41, 0x0F71,
;0x14A1, 0x0A51, 0x0F71, 0x14A1, 0x1881, 0x0A51, 0x0F71, 0x14A1, 0x1881, 0x0931, 0x1261, 0x1881, 0x1B81, 0x0931, 0x1261,
;0x1881, 0x1B81, 0x0931, 0x1061, 0x1721, 0x1B81, 0x0931, 0x1061, 0x1721, 0x1B81, 0x0C41, 0x0F71, 0x1261, 0x1881, 0x0C41,
;0x0F71, 0x1261, 0x1881, 0x0C41, 0x1261, 0x1881, 0x1EE1, 0x0C41, 0x1261, 0x1881, 0x1EE1, 0x0B91, 0x1721, 0x1EE1, 0x22A1,
;0x0B91, 0x1721, 0x1EE1, 0x22A1, 0x0B91, 0x14A1, 0x1D21, 0x22A1, 0x0B91, 0x14A1, 0x1D21, 0x22A1, 0x0F71, 0x1261, 0x1721,
;0x24B1, 0x0F71, 0x1261, 0x1721, 0x24B1, 0x0DC1, 0x1EE1, 0x24B1, 0x2E41, 0x0DC1, 0x1EE1, 0x24B1, 0x2E41, 0x0D01, 0x1EE1,
;0x24B1, 0x3DC1, 0x0D01, 0x1EE1, 0x24B1, 0x3DC1, 0x0C41, 0x1721, 0x1EE1, 0x24B1, 0x0C41, 0x15E1, 0x1EE1, 0x24B1, 0x0B91,
;0x1721, 0x1EE1, 0x22A1, 0x0B91, 0x1721, 0x1EE1, 0x22A1, 0x0B91, 0x1EE1, 0x22A1, 0x2E41, 0x0B91, 0x1EE1, 0x22A1, 0x2E41,
;0x0B91, 0x1721, 0x1D21, 0x22A1, 0x0B91, 0x1721, 0x1D21, 0x22A1, 0x0B91, 0x1D21, 0x22A1, 0x2E41, 0x0B91, 0x1D21, 0x22A1,
;0x2E41, 0x0F71, 0x3DC1, 0x2E41, 0x24B1, 0x1EE1, 0x2E41, 0x24B1, 0x1EE1, 0x1721, 0x3DC1, 0x1EE1, 0x1721, 0x1261, 0x1061,
;0x0F71, 0x0DC1, 0x0C41, 0x3DC1, 0x2E41, 0x24B1, 0x1EE1, 0x2E41, 0x24B1, 0x1EE1, 0x1721, 0x24B1, 0x1EE1, 0x1721, 0x1261,
;0x1151, 0x0F71, 0x0C41, 0x0B91, 0x2E41, 0x22A1, 0x1EE1, 0x1721, 0x22A1, 0x1EE1, 0x1721, 0x14A1, 0x1EE1, 0x1D21, 0x1721,
;0x1151, 0x0F71, 0x0E91, 0x0B91, 0x0931, 0x1261, 0x1721, 0x1261, 0x0F71, 0x1EE1, 0x1721, 0x0F71, 0x09C1, 0x1EE1, 0x1721,
;0x1371, 0x0F71, 0x1B81, 0x1721, 0x0F71, 0x14A1, 0x5261, 0x3DC1, 0x3101, 0x2931, 0x3DC1, 0x3101, 0x2931, 0x1EE1, 0x3101,
;0x2931, 0x1EE1, 0x1881, 0x1721, 0x14A1, 0x1261, 0x1061, 0x5261, 0x3DC1, 0x3101, 0x2931, 0x3DC1, 0x3101, 0x2931, 0x1EE1,
;0x3101, 0x2931, 0x1EE1, 0x1881, 0x1721, 0x14A1, 0x1061, 0x0F71, 0x3DC1, 0x2E41, 0x2931, 0x1EE1, 0x2E41, 0x2931, 0x1EE1,
;0x1B81, 0x2931, 0x26E1, 0x1EE1, 0x1721, 0x14A1, 0x1371, 0x0F71, 0x07B1, 0x0F71, 0x1371, 0x1721, 0x1EE1, 0x26E1, 0x2E41,
;0x3DC1, 0x3101, 0x2931, 0x1EE1, 0x1881, 0x1721, 0x1371, 0x0F71, 0x09C1, 0x0A51, 0x0F71, 0x14A1, 0x1881, 0x0A51, 0x0F71,
;0x14A1, 0x1881, 0x0A51, 0x0F71, 0x14A1, 0x1881, 0x0A51, 0x0F71, 0x14A1, 0x1881, 0x0A51, 0x1061, 0x14A1, 0x1B81, 0x0A51,
;0x1061, 0x14A1, 0x1B81, 0x0A51, 0x1061, 0x14A1, 0x1B81, 0x0A51, 0x1061, 0x14A1, 0x1B81, 0x0A51, 0x0DC1, 0x1261, 0x1721,
;0x0A51, 0x0DC1, 0x1261, 0x1721, 0x0A51, 0x0DC1, 0x1261, 0x1721, 0x0A51, 0x0DC1, 0x1261, 0x1721, 0x0A51, 0x0F71, 0x14A1,
;0x1881, 0x0A51, 0x0F71, 0x14A1, 0x1881, 0x0A51, 0x0F71, 0x14A1, 0x1881, 0x0A51, 0x0F71, 0x14A1, 0x1881, 0x0931, 0x1061,
;0x1721, 0x1B81, 0x0931, 0x1061, 0x1721, 0x1B81, 0x0931, 0x1061, 0x1721, 0x1B81, 0x0931, 0x1061, 0x1721, 0x1B81, 0x0C41,
;0x0F71, 0x1261, 0x1EE1, 0x0C41, 0x0F71, 0x1261, 0x1EE1, 0x0C41, 0x0F71, 0x1261, 0x1EE1, 0x0C41, 0x0F71, 0x1261, 0x1EE1,
;0x0831, 0x0C41, 0x14A1, 0x1EE1, 0x0831, 0x0C41, 0x14A1, 0x1EE1, 0x0831, 0x0B91, 0x14A1, 0x1B81, 0x0831, 0x0B91, 0x14A1,
;0x1B81, 0x0831, 0x0F71, 0x14A1, 0x1881, 0x0831, 0x0F71, 0x14A1, 0x1881, 0x0831, 0x0DC1, 0x14A1, 0x1721, 0x0831, 0x0DC1,
;0x14A1, 0x1721, 0x0831, 0x0C41, 0x14A1, 0x1EE1, 0x0831, 0x0C41, 0x14A1, 0x1EE1, 0x0831, 0x0B91, 0x14A1, 0x1B81, 0x0831,
;0x0B91, 0x14A1, 0x1B81, 0x07B1, 0x0F71, 0x14A1, 0x1881, 0x07B1, 0x0F71, 0x14A1, 0x1881, 0x07B1, 0x0DC1, 0x1371, 0x1721,
;0x07B1, 0x0DC1, 0x1371, 0x1721, 0x0A51, 0x5261, 0x3DC1, 0x3101, 0x2931, 0x1EE1, 0x1881, 0x14A1, 0x0F71, 0x3DC1, 0x3101,
;0x2931, 0x1EE1, 0x1881, 0x14A1, 0x0F71, 0x0C41, 0x3101, 0x2931, 0x3101, 0x2E41, 0x3DC1, 0x4DC1, 0x5C81, 0xA4D1, 0x3DC1,
;0x3101, 0x2931, 0x1EE1, 0x1881, 0x14A1, 0x0F71, 0x0A5F, 0x000F};
;
;// *****************************************************************************
;// ***      ****************************************************************
;// *****************************************************************************
;void Demo(void)
; 0007 0052 {

	.CSEG
_Demo:
; 0007 0053     signed int U_bat;
; 0007 0054 
; 0007 0055     Settings.SoundFlag = ON;
	ST   -Y,R17
	ST   -Y,R16
;	U_bat -> R16,R17
	LDI  R30,LOW(1)
	__PUTB1MN _Settings,3
; 0007 0056 
; 0007 0057     gfx_ClearBuf();
	CALL _gfx_ClearBuf
; 0007 0058 
; 0007 0059     gfx_SetXY((WidthS - Font_4x6.W) >> 1, (HeightS - Font_4x6.H) >> 1);
	LDS  R26,_Font_4x6
	LDI  R30,LOW(128)
	SUB  R30,R26
	LSR  R30
	ST   -Y,R30
	__GETB1MN _Font_4x6,1
	LDI  R26,LOW(64)
	SUB  R26,R30
	MOV  R30,R26
	LSR  R30
	ST   -Y,R30
	CALL _gfx_SetXY
; 0007 005A     gfx_PutFlashStr("1", 0xFF, &Font_4x6);
	__POINTW1FN _0xE0000,0
	ST   -Y,R31
	ST   -Y,R30
	LDI  R30,LOW(255)
	ST   -Y,R30
	LDI  R30,LOW(_Font_4x6)
	LDI  R31,HIGH(_Font_4x6)
	ST   -Y,R31
	ST   -Y,R30
	CALL _gfx_PutFlashStr
; 0007 005B     gfx_Refresh();
	CALL _gfx_Refresh
; 0007 005C     delay_ms(500);
	LDI  R30,LOW(500)
	LDI  R31,HIGH(500)
	ST   -Y,R31
	ST   -Y,R30
	CALL _delay_ms
; 0007 005D 
; 0007 005E     gfx_SetXY((WidthS - Font_6x8.W) >> 1, (HeightS - Font_6x8.H) >> 1);
	LDS  R26,_Font_6x8
	LDI  R30,LOW(128)
	SUB  R30,R26
	LSR  R30
	ST   -Y,R30
	__GETB1MN _Font_6x8,1
	LDI  R26,LOW(64)
	SUB  R26,R30
	MOV  R30,R26
	LSR  R30
	ST   -Y,R30
	CALL _gfx_SetXY
; 0007 005F     gfx_PutFlashStr("2", 0xFF, &Font_6x8);
	__POINTW1FN _0xE0000,2
	ST   -Y,R31
	ST   -Y,R30
	LDI  R30,LOW(255)
	ST   -Y,R30
	LDI  R30,LOW(_Font_6x8)
	LDI  R31,HIGH(_Font_6x8)
	ST   -Y,R31
	ST   -Y,R30
	CALL _gfx_PutFlashStr
; 0007 0060     gfx_Refresh();
	CALL _gfx_Refresh
; 0007 0061     delay_ms(500);
	LDI  R30,LOW(500)
	LDI  R31,HIGH(500)
	ST   -Y,R31
	ST   -Y,R30
	CALL _delay_ms
; 0007 0062 
; 0007 0063     gfx_SetXY((WidthS - Font_8x8.W) >> 1, (HeightS - Font_8x8.H) >> 1);
	LDS  R26,_Font_8x8
	LDI  R30,LOW(128)
	SUB  R30,R26
	LSR  R30
	ST   -Y,R30
	__GETB1MN _Font_8x8,1
	LDI  R26,LOW(64)
	SUB  R26,R30
	MOV  R30,R26
	LSR  R30
	ST   -Y,R30
	CALL _gfx_SetXY
; 0007 0064     gfx_PutFlashStr("3", 0xFF, &Font_8x8);
	__POINTW1FN _0xE0000,4
	ST   -Y,R31
	ST   -Y,R30
	LDI  R30,LOW(255)
	ST   -Y,R30
	LDI  R30,LOW(_Font_8x8)
	LDI  R31,HIGH(_Font_8x8)
	ST   -Y,R31
	ST   -Y,R30
	CALL _gfx_PutFlashStr
; 0007 0065     gfx_Refresh();
	CALL _gfx_Refresh
; 0007 0066     delay_ms(500);
	LDI  R30,LOW(500)
	LDI  R31,HIGH(500)
	ST   -Y,R31
	ST   -Y,R30
	CALL _delay_ms
; 0007 0067 
; 0007 0068     gfx_SetXY((WidthS - Font_8x12.W*8) >> 1, (HeightS - Font_8x12.H) >> 1);
	LDS  R30,_Font_8x12
	LSL  R30
	LSL  R30
	LSL  R30
	LDI  R26,LOW(128)
	SUB  R26,R30
	MOV  R30,R26
	LSR  R30
	ST   -Y,R30
	__GETB1MN _Font_8x12,1
	LDI  R26,LOW(64)
	SUB  R26,R30
	MOV  R30,R26
	LSR  R30
	ST   -Y,R30
	CALL _gfx_SetXY
; 0007 0069     gfx_PutFlashStr("!", 0xFF, &Font_8x12);
	__POINTW1FN _0xE0000,6
	ST   -Y,R31
	ST   -Y,R30
	LDI  R30,LOW(255)
	ST   -Y,R30
	LDI  R30,LOW(_Font_8x12)
	LDI  R31,HIGH(_Font_8x12)
	ST   -Y,R31
	ST   -Y,R30
	CALL _gfx_PutFlashStr
; 0007 006A 
; 0007 006B     U_bat = read_adc(ADC_BAT);
	LDI  R30,LOW(7)
	ST   -Y,R30
	CALL _read_adc
	MOVW R16,R30
; 0007 006C     U_bat = U_bat*2;
	LSL  R16
	ROL  R17
; 0007 006D     sprintf(tmpBuf, "%2i.%02iV", U_bat/100, U_bat%100);
	LDI  R30,LOW(_tmpBuf)
	LDI  R31,HIGH(_tmpBuf)
	ST   -Y,R31
	ST   -Y,R30
	__POINTW1FN _0xE0000,15
	ST   -Y,R31
	ST   -Y,R30
	MOVW R26,R16
	LDI  R30,LOW(100)
	LDI  R31,HIGH(100)
	CALL __DIVW21
	CALL __CWD1
	CALL __PUTPARD1
	MOVW R26,R16
	LDI  R30,LOW(100)
	LDI  R31,HIGH(100)
	CALL __MODW21
	CALL __CWD1
	CALL __PUTPARD1
	LDI  R24,8
	CALL _sprintf
	ADIW R28,12
; 0007 006E     gfx_SetXY(0, HeightS - Font_8x12.H);
	LDI  R30,LOW(0)
	ST   -Y,R30
	__GETB1MN _Font_8x12,1
	LDI  R26,LOW(64)
	SUB  R26,R30
	ST   -Y,R26
	CALL _gfx_SetXY
; 0007 006F     gfx_PutStr(tmpBuf, 0xFF, &Font_8x12);
	LDI  R30,LOW(_tmpBuf)
	LDI  R31,HIGH(_tmpBuf)
	ST   -Y,R31
	ST   -Y,R30
	LDI  R30,LOW(255)
	ST   -Y,R30
	LDI  R30,LOW(_Font_8x12)
	LDI  R31,HIGH(_Font_8x12)
	ST   -Y,R31
	ST   -Y,R30
	CALL _gfx_PutStr
; 0007 0070 
; 0007 0071     gfx_Refresh();
	CALL _gfx_Refresh
; 0007 0072 
; 0007 0073     PlaySound(DataTable, NumberOf(DataTable));
	LDI  R30,LOW(_DataTable*2)
	LDI  R31,HIGH(_DataTable*2)
	ST   -Y,R31
	ST   -Y,R30
	LDI  R30,LOW(578)
	LDI  R31,HIGH(578)
	ST   -Y,R31
	ST   -Y,R30
	RCALL _PlaySound
; 0007 0074 
; 0007 0075     while(IsSoundPlayed() == TRUE)
_0xE0003:
	RCALL _IsSoundPlayed
	CPI  R30,LOW(0x1)
	BREQ PC+3
	JMP _0xE0005
; 0007 0076     {
; 0007 0077         gfx_SetXY(0, 0);
	LDI  R30,LOW(0)
	ST   -Y,R30
	ST   -Y,R30
	CALL _gfx_SetXY
; 0007 0078         gfx_PutFlashStr("  4x6", 0xFF, &Font_4x6);
	__POINTW1FN _0xE0000,25
	ST   -Y,R31
	ST   -Y,R30
	LDI  R30,LOW(255)
	ST   -Y,R30
	LDI  R30,LOW(_Font_4x6)
	LDI  R31,HIGH(_Font_4x6)
	ST   -Y,R31
	ST   -Y,R30
	CALL _gfx_PutFlashStr
; 0007 0079         gfx_SetXY(0, 8);
	LDI  R30,LOW(0)
	ST   -Y,R30
	LDI  R30,LOW(8)
	ST   -Y,R30
	CALL _gfx_SetXY
; 0007 007A         gfx_PutFlashStr("  6x8", 0xFF, &Font_6x8);
	__POINTW1FN _0xE0000,39
	ST   -Y,R31
	ST   -Y,R30
	LDI  R30,LOW(255)
	ST   -Y,R30
	LDI  R30,LOW(_Font_6x8)
	LDI  R31,HIGH(_Font_6x8)
	ST   -Y,R31
	ST   -Y,R30
	CALL _gfx_PutFlashStr
; 0007 007B         gfx_SetXY(0, 16);
	LDI  R30,LOW(0)
	ST   -Y,R30
	LDI  R30,LOW(16)
	ST   -Y,R30
	CALL _gfx_SetXY
; 0007 007C         gfx_PutFlashStr("  8x8", 0xFF, &Font_8x8);
	__POINTW1FN _0xE0000,53
	ST   -Y,R31
	ST   -Y,R30
	LDI  R30,LOW(255)
	ST   -Y,R30
	LDI  R30,LOW(_Font_8x8)
	LDI  R31,HIGH(_Font_8x8)
	ST   -Y,R31
	ST   -Y,R30
	CALL _gfx_PutFlashStr
; 0007 007D         gfx_SetXY(0, 24);
	LDI  R30,LOW(0)
	ST   -Y,R30
	LDI  R30,LOW(24)
	ST   -Y,R30
	CALL _gfx_SetXY
; 0007 007E         gfx_PutFlashStr("  8x12", 0xFF, &Font_8x12);
	__POINTW1FN _0xE0000,67
	ST   -Y,R31
	ST   -Y,R30
	LDI  R30,LOW(255)
	ST   -Y,R30
	LDI  R30,LOW(_Font_8x12)
	LDI  R31,HIGH(_Font_8x12)
	ST   -Y,R31
	ST   -Y,R30
	CALL _gfx_PutFlashStr
; 0007 007F 
; 0007 0080         if(Settings.BacklightFlag == ON)
	__GETB2MN _Settings,4
	CPI  R26,LOW(0x1)
	BRNE _0xE0006
; 0007 0081         {
; 0007 0082             gfx_SetXY(0, 36);
	LDI  R30,LOW(0)
	ST   -Y,R30
	LDI  R30,LOW(36)
	ST   -Y,R30
	CALL _gfx_SetXY
; 0007 0083             gfx_PutFlashStr("  ", 0xFF, &Font_8x12);
	__POINTW1FN _0xE0000,82
	RJMP _0xE005B
; 0007 0084         }
; 0007 0085         else
_0xE0006:
; 0007 0086         {
; 0007 0087             gfx_SetXY(0, 36);
	LDI  R30,LOW(0)
	ST   -Y,R30
	LDI  R30,LOW(36)
	ST   -Y,R30
	CALL _gfx_SetXY
; 0007 0088             gfx_PutFlashStr(" ", 0xFF, &Font_8x12);
	__POINTW1FN _0xE0000,97
_0xE005B:
	ST   -Y,R31
	ST   -Y,R30
	LDI  R30,LOW(255)
	ST   -Y,R30
	LDI  R30,LOW(_Font_8x12)
	LDI  R31,HIGH(_Font_8x12)
	ST   -Y,R31
	ST   -Y,R30
	CALL _gfx_PutFlashStr
; 0007 0089         }
; 0007 008A 
; 0007 008B         U_bat = read_adc(ADC_BAT);
	LDI  R30,LOW(7)
	ST   -Y,R30
	CALL _read_adc
	MOVW R16,R30
; 0007 008C         U_bat = U_bat*2;
	LSL  R16
	ROL  R17
; 0007 008D         sprintf(tmpBuf, "%2i.%02iV", U_bat/100, U_bat%100);
	LDI  R30,LOW(_tmpBuf)
	LDI  R31,HIGH(_tmpBuf)
	ST   -Y,R31
	ST   -Y,R30
	__POINTW1FN _0xE0000,15
	ST   -Y,R31
	ST   -Y,R30
	MOVW R26,R16
	LDI  R30,LOW(100)
	LDI  R31,HIGH(100)
	CALL __DIVW21
	CALL __CWD1
	CALL __PUTPARD1
	MOVW R26,R16
	LDI  R30,LOW(100)
	LDI  R31,HIGH(100)
	CALL __MODW21
	CALL __CWD1
	CALL __PUTPARD1
	LDI  R24,8
	CALL _sprintf
	ADIW R28,12
; 0007 008E         gfx_SetXY(0, HeightS - Font_8x12.H);
	LDI  R30,LOW(0)
	ST   -Y,R30
	__GETB1MN _Font_8x12,1
	LDI  R26,LOW(64)
	SUB  R26,R30
	ST   -Y,R26
	CALL _gfx_SetXY
; 0007 008F         gfx_PutStr(tmpBuf, 0xFF, &Font_8x12);
	LDI  R30,LOW(_tmpBuf)
	LDI  R31,HIGH(_tmpBuf)
	ST   -Y,R31
	ST   -Y,R30
	LDI  R30,LOW(255)
	ST   -Y,R30
	LDI  R30,LOW(_Font_8x12)
	LDI  R31,HIGH(_Font_8x12)
	ST   -Y,R31
	ST   -Y,R30
	CALL _gfx_PutStr
; 0007 0090 
; 0007 0091         gfx_Refresh();
	CALL _gfx_Refresh
; 0007 0092 
; 0007 0093         if(HB_UP || HB_DOWN || HB_LEFT || HB_RIGHT || HB_ENTER) break;
	SBIS 0x10,3
	RJMP _0xE0009
	SBIS 0x10,1
	RJMP _0xE0009
	SBIS 0x10,2
	RJMP _0xE0009
	SBIS 0x10,0
	RJMP _0xE0009
	SBIC 0x10,5
	RJMP _0xE0008
_0xE0009:
	RJMP _0xE0005
; 0007 0094     }
_0xE0008:
	RJMP _0xE0003
_0xE0005:
; 0007 0095 
; 0007 0096     StopSound();
	RCALL _StopSound
; 0007 0097 
; 0007 0098     gfx_ClearBuf();
	CALL _gfx_ClearBuf
; 0007 0099     gfx_SetXY((WidthS - Font_8x12.W*10) >> 1, ((HeightS - Font_8x12.H) >> 1) - Font_8x12.H);
	LDS  R30,_Font_8x12
	LDI  R26,LOW(10)
	MUL  R30,R26
	MOVW R30,R0
	LDI  R26,LOW(128)
	SUB  R26,R30
	MOV  R30,R26
	LSR  R30
	ST   -Y,R30
	__GETB1MN _Font_8x12,1
	LDI  R26,LOW(64)
	SUB  R26,R30
	MOV  R30,R26
	LSR  R30
	MOV  R26,R30
	__GETB1MN _Font_8x12,1
	SUB  R26,R30
	ST   -Y,R26
	CALL _gfx_SetXY
; 0007 009A     gfx_PutFlashStr(" ", 0xFF, &Font_8x12);
	__POINTW1FN _0xE0000,112
	ST   -Y,R31
	ST   -Y,R30
	LDI  R30,LOW(255)
	ST   -Y,R30
	LDI  R30,LOW(_Font_8x12)
	LDI  R31,HIGH(_Font_8x12)
	ST   -Y,R31
	ST   -Y,R30
	CALL _gfx_PutFlashStr
; 0007 009B     gfx_SetXY((WidthS - Font_8x12.W*9) >> 1, (HeightS - Font_8x12.H) >> 1);
	LDS  R30,_Font_8x12
	LDI  R26,LOW(9)
	MUL  R30,R26
	MOVW R30,R0
	LDI  R26,LOW(128)
	SUB  R26,R30
	MOV  R30,R26
	LSR  R30
	ST   -Y,R30
	__GETB1MN _Font_8x12,1
	LDI  R26,LOW(64)
	SUB  R26,R30
	MOV  R30,R26
	LSR  R30
	ST   -Y,R30
	CALL _gfx_SetXY
; 0007 009C     gfx_PutFlashStr("", 0xFF, &Font_8x12);
	__POINTW1FN _0xE0000,123
	ST   -Y,R31
	ST   -Y,R30
	LDI  R30,LOW(255)
	ST   -Y,R30
	LDI  R30,LOW(_Font_8x12)
	LDI  R31,HIGH(_Font_8x12)
	ST   -Y,R31
	ST   -Y,R30
	CALL _gfx_PutFlashStr
; 0007 009D     gfx_SetXY((WidthS - Font_8x12.W*9) >> 1, ((HeightS - Font_8x12.H) >> 1) + Font_8x12.H);
	LDS  R30,_Font_8x12
	LDI  R26,LOW(9)
	MUL  R30,R26
	MOVW R30,R0
	LDI  R26,LOW(128)
	SUB  R26,R30
	MOV  R30,R26
	LSR  R30
	ST   -Y,R30
	__GETB1MN _Font_8x12,1
	LDI  R26,LOW(64)
	SUB  R26,R30
	MOV  R30,R26
	LSR  R30
	MOV  R26,R30
	__GETB1MN _Font_8x12,1
	ADD  R30,R26
	ST   -Y,R30
	CALL _gfx_SetXY
; 0007 009E     gfx_PutFlashStr("", 0xFF, &Font_8x12);
	__POINTW1FN _0xE0000,133
	ST   -Y,R31
	ST   -Y,R30
	LDI  R30,LOW(255)
	ST   -Y,R30
	LDI  R30,LOW(_Font_8x12)
	LDI  R31,HIGH(_Font_8x12)
	ST   -Y,R31
	ST   -Y,R30
	CALL _gfx_PutFlashStr
; 0007 009F     gfx_Refresh();
	CALL _gfx_Refresh
; 0007 00A0 
; 0007 00A1     Tone(1000);
	LDI  R30,LOW(1000)
	LDI  R31,HIGH(1000)
	ST   -Y,R31
	ST   -Y,R30
	RCALL _Tone
; 0007 00A2     delay_ms(1000);
	LDI  R30,LOW(1000)
	LDI  R31,HIGH(1000)
	ST   -Y,R31
	ST   -Y,R30
	CALL _delay_ms
; 0007 00A3     Tone(0);
	LDI  R30,LOW(0)
	LDI  R31,HIGH(0)
	ST   -Y,R31
	ST   -Y,R30
	RCALL _Tone
; 0007 00A4 }
	LD   R16,Y+
	LD   R17,Y+
	RET
;
;// *****************************************************************************
;// ***          *****************************************
;// *****************************************************************************
;void IO_Test(void)
; 0007 00AA {
_IO_Test:
; 0007 00AB     char i;
; 0007 00AC     char buf[32];
; 0007 00AD 
; 0007 00AE     #asm("cli")
	SBIW R28,32
	ST   -Y,R17
;	i -> R17
;	buf -> Y+1
	cli
; 0007 00AF 
; 0007 00B0     gfx_ClearBuf();
	CALL _gfx_ClearBuf
; 0007 00B1     gfx_SetXY((WidthS - 9*Font_8x12.W) >> 1, (HeightS - 1*Font_8x12.H) >> 1);
	LDS  R30,_Font_8x12
	LDI  R26,LOW(9)
	MUL  R30,R26
	MOVW R30,R0
	LDI  R26,LOW(128)
	SUB  R26,R30
	MOV  R30,R26
	LSR  R30
	ST   -Y,R30
	__GETB1MN _Font_8x12,1
	LDI  R26,LOW(64)
	SUB  R26,R30
	MOV  R30,R26
	LSR  R30
	ST   -Y,R30
	CALL _gfx_SetXY
; 0007 00B2     gfx_PutFlashStr("Test Mode", 0xFF, &Font_8x12);
	__POINTW1FN _0xE0000,143
	ST   -Y,R31
	ST   -Y,R30
	LDI  R30,LOW(255)
	ST   -Y,R30
	LDI  R30,LOW(_Font_8x12)
	LDI  R31,HIGH(_Font_8x12)
	ST   -Y,R31
	ST   -Y,R30
	CALL _gfx_PutFlashStr
; 0007 00B3     gfx_Refresh();
	CALL _gfx_Refresh
; 0007 00B4     delay_ms(500);
	LDI  R30,LOW(500)
	LDI  R31,HIGH(500)
	ST   -Y,R31
	ST   -Y,R30
	CALL _delay_ms
; 0007 00B5 
; 0007 00B6     while(!HB_ENTER)
_0xE000B:
	SBIS 0x10,5
	RJMP _0xE000D
; 0007 00B7     {
; 0007 00B8         gfx_ClearBuf();
	CALL _gfx_ClearBuf
; 0007 00B9 
; 0007 00BA         for(i=0; i < MAX_ADC; i++)
	LDI  R17,LOW(0)
_0xE000F:
	CPI  R17,8
	BRGE _0xE0010
; 0007 00BB         {
; 0007 00BC             sprintf(buf, "AD%d: %4d", i, read_adc(i));
	MOVW R30,R28
	ADIW R30,1
	ST   -Y,R31
	ST   -Y,R30
	__POINTW1FN _0xE0000,153
	ST   -Y,R31
	ST   -Y,R30
	MOV  R30,R17
	CALL __CBD1
	CALL __PUTPARD1
	ST   -Y,R17
	CALL _read_adc
	CLR  R22
	CLR  R23
	CALL __PUTPARD1
	LDI  R24,8
	CALL _sprintf
	ADIW R28,12
; 0007 00BD             if(i < 4) gfx_SetXY(0, Font_6x8.H * (i%4));
	CPI  R17,4
	BRGE _0xE0011
	LDI  R30,LOW(0)
	RJMP _0xE005C
; 0007 00BE             else gfx_SetXY(WidthS/2, Font_6x8.H * (i%4));
_0xE0011:
	LDI  R30,LOW(64)
_0xE005C:
	ST   -Y,R30
	MOV  R26,R17
	LDI  R30,LOW(4)
	CALL __MODB21
	__GETB2MN _Font_6x8,1
	MUL  R30,R26
	ST   -Y,R0
	CALL _gfx_SetXY
; 0007 00BF             gfx_PutStr(buf, 0xFF, &Font_6x8);
	MOVW R30,R28
	ADIW R30,1
	ST   -Y,R31
	ST   -Y,R30
	LDI  R30,LOW(255)
	ST   -Y,R30
	LDI  R30,LOW(_Font_6x8)
	LDI  R31,HIGH(_Font_6x8)
	ST   -Y,R31
	ST   -Y,R30
	CALL _gfx_PutStr
; 0007 00C0         }
	SUBI R17,-1
	RJMP _0xE000F
_0xE0010:
; 0007 00C1 
; 0007 00C2         gfx_SetXY(0, Font_6x8.H * 6);
	LDI  R30,LOW(0)
	ST   -Y,R30
	__GETB2MN _Font_6x8,1
	LDI  R30,LOW(6)
	MUL  R30,R26
	ST   -Y,R0
	CALL _gfx_SetXY
; 0007 00C3         gfx_PutFlashStr("D: ", 0xFF, &Font_6x8);
	__POINTW1FN _0xE0000,163
	ST   -Y,R31
	ST   -Y,R30
	LDI  R30,LOW(255)
	ST   -Y,R30
	LDI  R30,LOW(_Font_6x8)
	LDI  R31,HIGH(_Font_6x8)
	ST   -Y,R31
	ST   -Y,R30
	CALL _gfx_PutFlashStr
; 0007 00C4         for(i=7; i >= 0; i--)
	LDI  R17,LOW(7)
_0xE0014:
	CPI  R17,0
	BRLT _0xE0015
; 0007 00C5         {
; 0007 00C6             gfx_Char('0' + i, (PIND & (1 << i)) ? 0xFF : 0, &Font_6x8);
	MOV  R30,R17
	SUBI R30,-LOW(48)
	ST   -Y,R30
	IN   R1,16
	MOV  R30,R17
	LDI  R26,LOW(1)
	CALL __LSLB12
	AND  R30,R1
	BREQ _0xE0016
	LDI  R30,LOW(255)
	RJMP _0xE0017
_0xE0016:
	LDI  R30,LOW(0)
_0xE0017:
	ST   -Y,R30
	LDI  R30,LOW(_Font_6x8)
	LDI  R31,HIGH(_Font_6x8)
	ST   -Y,R31
	ST   -Y,R30
	CALL _gfx_Char
; 0007 00C7         }
	SUBI R17,1
	RJMP _0xE0014
_0xE0015:
; 0007 00C8 
; 0007 00C9         gfx_SetXY(0, Font_6x8.H * 7);
	LDI  R30,LOW(0)
	ST   -Y,R30
	__GETB2MN _Font_6x8,1
	LDI  R30,LOW(7)
	MUL  R30,R26
	ST   -Y,R0
	CALL _gfx_SetXY
; 0007 00CA         gfx_PutFlashStr("E: ", 0xFF, &Font_6x8);
	__POINTW1FN _0xE0000,167
	ST   -Y,R31
	ST   -Y,R30
	LDI  R30,LOW(255)
	ST   -Y,R30
	LDI  R30,LOW(_Font_6x8)
	LDI  R31,HIGH(_Font_6x8)
	ST   -Y,R31
	ST   -Y,R30
	CALL _gfx_PutFlashStr
; 0007 00CB         for(i=7; i >= 0; i--)
	LDI  R17,LOW(7)
_0xE001A:
	CPI  R17,0
	BRLT _0xE001B
; 0007 00CC         {
; 0007 00CD             gfx_Char('0' + i, (PINE & (1 << i)) ? 0xFF : 0, &Font_6x8);
	MOV  R30,R17
	SUBI R30,-LOW(48)
	ST   -Y,R30
	IN   R1,1
	MOV  R30,R17
	LDI  R26,LOW(1)
	CALL __LSLB12
	AND  R30,R1
	BREQ _0xE001C
	LDI  R30,LOW(255)
	RJMP _0xE001D
_0xE001C:
	LDI  R30,LOW(0)
_0xE001D:
	ST   -Y,R30
	LDI  R30,LOW(_Font_6x8)
	LDI  R31,HIGH(_Font_6x8)
	ST   -Y,R31
	ST   -Y,R30
	CALL _gfx_Char
; 0007 00CE         }
	SUBI R17,1
	RJMP _0xE001A
_0xE001B:
; 0007 00CF 
; 0007 00D0         gfx_SetXY(0, Font_6x8.H * 5);
	LDI  R30,LOW(0)
	ST   -Y,R30
	__GETB2MN _Font_6x8,1
	LDI  R30,LOW(5)
	MUL  R30,R26
	ST   -Y,R0
	CALL _gfx_SetXY
; 0007 00D1         gfx_PutFlashStr("A: ", 0xFF, &Font_6x8);
	__POINTW1FN _0xE0000,171
	ST   -Y,R31
	ST   -Y,R30
	LDI  R30,LOW(255)
	ST   -Y,R30
	LDI  R30,LOW(_Font_6x8)
	LDI  R31,HIGH(_Font_6x8)
	ST   -Y,R31
	ST   -Y,R30
	CALL _gfx_PutFlashStr
; 0007 00D2         gfx_Char('2', PINA.2 ? 0xFF : 0, &Font_6x8);
	LDI  R30,LOW(50)
	ST   -Y,R30
	SBIS 0x19,2
	RJMP _0xE001F
	LDI  R30,LOW(255)
	RJMP _0xE0020
_0xE001F:
	LDI  R30,LOW(0)
_0xE0020:
	ST   -Y,R30
	LDI  R30,LOW(_Font_6x8)
	LDI  R31,HIGH(_Font_6x8)
	ST   -Y,R31
	ST   -Y,R30
	CALL _gfx_Char
; 0007 00D3         gfx_Char('1', PINA.1 ? 0xFF : 0, &Font_6x8);
	LDI  R30,LOW(49)
	ST   -Y,R30
	SBIS 0x19,1
	RJMP _0xE0022
	LDI  R30,LOW(255)
	RJMP _0xE0023
_0xE0022:
	LDI  R30,LOW(0)
_0xE0023:
	ST   -Y,R30
	LDI  R30,LOW(_Font_6x8)
	LDI  R31,HIGH(_Font_6x8)
	ST   -Y,R31
	ST   -Y,R30
	CALL _gfx_Char
; 0007 00D4 
; 0007 00D5         gfx_SetXY(Font_6x8.W*6, Font_6x8.H * 5);
	LDS  R30,_Font_6x8
	LDI  R26,LOW(6)
	MUL  R30,R26
	ST   -Y,R0
	__GETB2MN _Font_6x8,1
	LDI  R30,LOW(5)
	MUL  R30,R26
	ST   -Y,R0
	CALL _gfx_SetXY
; 0007 00D6         gfx_PutFlashStr("B: ", 0xFF, &Font_6x8);
	__POINTW1FN _0xE0000,175
	ST   -Y,R31
	ST   -Y,R30
	LDI  R30,LOW(255)
	ST   -Y,R30
	LDI  R30,LOW(_Font_6x8)
	LDI  R31,HIGH(_Font_6x8)
	ST   -Y,R31
	ST   -Y,R30
	CALL _gfx_PutFlashStr
; 0007 00D7         for(i=3; i >= 0; i--)
	LDI  R17,LOW(3)
_0xE0026:
	CPI  R17,0
	BRLT _0xE0027
; 0007 00D8         {
; 0007 00D9             gfx_Char('0' + i, (PINB & (1 << i)) ? 0xFF : 0, &Font_6x8);
	MOV  R30,R17
	SUBI R30,-LOW(48)
	ST   -Y,R30
	IN   R1,22
	MOV  R30,R17
	LDI  R26,LOW(1)
	CALL __LSLB12
	AND  R30,R1
	BREQ _0xE0028
	LDI  R30,LOW(255)
	RJMP _0xE0029
_0xE0028:
	LDI  R30,LOW(0)
_0xE0029:
	ST   -Y,R30
	LDI  R30,LOW(_Font_6x8)
	LDI  R31,HIGH(_Font_6x8)
	ST   -Y,R31
	ST   -Y,R30
	CALL _gfx_Char
; 0007 00DA         }
	SUBI R17,1
	RJMP _0xE0026
_0xE0027:
; 0007 00DB 
; 0007 00DC         gfx_SetXY(Font_6x8.W*13, Font_6x8.H * 5);
	LDS  R30,_Font_6x8
	LDI  R26,LOW(13)
	MUL  R30,R26
	ST   -Y,R0
	__GETB2MN _Font_6x8,1
	LDI  R30,LOW(5)
	MUL  R30,R26
	ST   -Y,R0
	CALL _gfx_SetXY
; 0007 00DD         gfx_PutFlashStr("G: ", 0xFF, &Font_6x8);
	__POINTW1FN _0xE0000,179
	ST   -Y,R31
	ST   -Y,R30
	LDI  R30,LOW(255)
	ST   -Y,R30
	LDI  R30,LOW(_Font_6x8)
	LDI  R31,HIGH(_Font_6x8)
	ST   -Y,R31
	ST   -Y,R30
	CALL _gfx_PutFlashStr
; 0007 00DE         gfx_Char('1', PING&2 ? 0xFF : 0, &Font_6x8);
	LDI  R30,LOW(49)
	ST   -Y,R30
	LDS  R30,99
	ANDI R30,LOW(0x2)
	BREQ _0xE002B
	LDI  R30,LOW(255)
	RJMP _0xE002C
_0xE002B:
	LDI  R30,LOW(0)
_0xE002C:
	ST   -Y,R30
	LDI  R30,LOW(_Font_6x8)
	LDI  R31,HIGH(_Font_6x8)
	ST   -Y,R31
	ST   -Y,R30
	CALL _gfx_Char
; 0007 00DF         gfx_Char('0', PING&1 ? 0xFF : 0, &Font_6x8);
	LDI  R30,LOW(48)
	ST   -Y,R30
	LDS  R30,99
	ANDI R30,LOW(0x1)
	BREQ _0xE002E
	LDI  R30,LOW(255)
	RJMP _0xE002F
_0xE002E:
	LDI  R30,LOW(0)
_0xE002F:
	ST   -Y,R30
	LDI  R30,LOW(_Font_6x8)
	LDI  R31,HIGH(_Font_6x8)
	ST   -Y,R31
	ST   -Y,R30
	CALL _gfx_Char
; 0007 00E0 
; 0007 00E1         gfx_Refresh();
	CALL _gfx_Refresh
; 0007 00E2     }
	RJMP _0xE000B
_0xE000D:
; 0007 00E3 
; 0007 00E4     while(!HB_ENTER);
_0xE0031:
	SBIC 0x10,5
	RJMP _0xE0031
; 0007 00E5     delay_ms(100);
	LDI  R30,LOW(100)
	LDI  R31,HIGH(100)
	ST   -Y,R31
	ST   -Y,R30
	CALL _delay_ms
; 0007 00E6     while(HB_ENTER);
_0xE0034:
	SBIS 0x10,5
	RJMP _0xE0034
; 0007 00E7 
; 0007 00E8     #asm("sei")
	sei
; 0007 00E9 }
	LDD  R17,Y+0
	ADIW R28,33
	RET
;
;
;// *****************************************************************************
;// ***   Chron   ***************************************************************
;// *****************************************************************************
;
;volatile unsigned char ovf;
;volatile unsigned char dir;
;volatile unsigned char ovf;
;// ***   Chron   ***************************************************************
;// Timer 1 overflow interrupt service routine
;interrupt [TIM1_OVF] void timer1_ovf_isr(void)
; 0007 00F6 {
_timer1_ovf_isr:
	ST   -Y,R30
; 0007 00F7     ovf = 1;
	LDI  R30,LOW(1)
	STS  _ovf,R30
; 0007 00F8 }
	LD   R30,Y+
	RETI
;
;// ***   Chron   ***************************************************************
;void Chron(void)
; 0007 00FC {
_Chron:
; 0007 00FD     char flag = 1, refresh = 1;
; 0007 00FE     unsigned int t1[2]={0,0}, t2[2]={0,0};
; 0007 00FF     unsigned long l;
; 0007 0100     char buf[32];
; 0007 0101 
; 0007 0102     #asm("cli")
	SBIW R28,44
	LDI  R30,LOW(0)
	STD  Y+36,R30
	STD  Y+37,R30
	STD  Y+38,R30
	STD  Y+39,R30
	STD  Y+40,R30
	STD  Y+41,R30
	STD  Y+42,R30
	STD  Y+43,R30
	ST   -Y,R17
	ST   -Y,R16
;	flag -> R17
;	refresh -> R16
;	t1 -> Y+42
;	t2 -> Y+38
;	l -> Y+34
;	buf -> Y+2
	LDI  R17,1
	LDI  R16,1
	cli
; 0007 0103 
; 0007 0104     //  
; 0007 0105 // Timer/Counter 1 initialization
; 0007 0106 // Clock source: System Clock
; 0007 0107 // Clock value: 2000,000 kHz
; 0007 0108 // Mode: Normal top=FFFFh
; 0007 0109 // OC1A output: Discon.
; 0007 010A // OC1B output: Discon.
; 0007 010B // OC1C output: Discon.
; 0007 010C // Noise Canceler: Off
; 0007 010D // Input Capture on Falling Edge
; 0007 010E // Timer 1 Overflow Interrupt: On
; 0007 010F // Input Capture Interrupt: Off
; 0007 0110 // Compare A Match Interrupt: Off
; 0007 0111 // Compare B Match Interrupt: Off
; 0007 0112 // Compare C Match Interrupt: Off
; 0007 0113     TCCR1A = 0x00;
	LDI  R30,LOW(0)
	OUT  0x2F,R30
; 0007 0114     TCCR1B = 0x02;
	LDI  R30,LOW(2)
	OUT  0x2E,R30
; 0007 0115     TCNT1H = 0x00;
	LDI  R30,LOW(0)
	OUT  0x2D,R30
; 0007 0116     TCNT1L = 0x00;
	OUT  0x2C,R30
; 0007 0117     ICR1H  = 0x00;
	OUT  0x27,R30
; 0007 0118     ICR1L  = 0x00;
	OUT  0x26,R30
; 0007 0119     OCR1AH = 0x00;
	OUT  0x2B,R30
; 0007 011A     OCR1AL = 0x00;
	OUT  0x2A,R30
; 0007 011B     OCR1BH = 0x00;
	OUT  0x29,R30
; 0007 011C     OCR1BL = 0x00;
	OUT  0x28,R30
; 0007 011D     OCR1CH = 0x00;
	STS  121,R30
; 0007 011E     OCR1CL = 0x00;
	STS  120,R30
; 0007 011F     //  USART0
; 0007 0120     UCSR0A = 0x00;
	OUT  0xB,R30
; 0007 0121     UCSR0B = 0x00;
	OUT  0xA,R30
; 0007 0122     UCSR0C = 0x00;
	STS  149,R30
; 0007 0123     UBRR0H = 0x00;
	STS  144,R30
; 0007 0124     UBRR0L = 0x00;
	OUT  0x9,R30
; 0007 0125 
; 0007 0126     // Timer(s)/Counter(s) Interrupt(s) initialization
; 0007 0127     TIMSK = 0x04;
	LDI  R30,LOW(4)
	OUT  0x37,R30
; 0007 0128     ETIMSK = 0x00;
	LDI  R30,LOW(0)
	STS  125,R30
; 0007 0129 
; 0007 012A     #asm("sei")
	sei
; 0007 012B 
; 0007 012C     while(!HB_BACK)
_0xE0037:
	SBIS 0x10,4
	RJMP _0xE0039
; 0007 012D     {
; 0007 012E         if(HB_ENTER)
	SBIC 0x10,5
	RJMP _0xE003A
; 0007 012F         {
; 0007 0130             flag = 1;
	LDI  R17,LOW(1)
; 0007 0131             t1[0] = 0;
	LDI  R30,LOW(0)
	STD  Y+42,R30
	STD  Y+42+1,R30
; 0007 0132             t1[1] = 0;
	STD  Y+44,R30
	STD  Y+44+1,R30
; 0007 0133             t2[0] = 0;
	STD  Y+38,R30
	STD  Y+38+1,R30
; 0007 0134             t2[1] = 0;
	STD  Y+40,R30
	STD  Y+40+1,R30
; 0007 0135             refresh = 1;
	LDI  R16,LOW(1)
; 0007 0136         }
; 0007 0137 
; 0007 0138         switch(flag)
_0xE003A:
	MOV  R30,R17
; 0007 0139         {
; 0007 013A             case(1):
	CPI  R30,LOW(0x1)
	BRNE _0xE003E
; 0007 013B                 if(dir ? !PINE.1 : !PINE.0)
	LDS  R30,_dir
	CPI  R30,0
	BREQ _0xE0040
	LDI  R30,0
	SBIS 0x1,1
	LDI  R30,1
	RJMP _0xE0041
_0xE0040:
	LDI  R30,0
	SBIS 0x1,0
	LDI  R30,1
_0xE0041:
	CPI  R30,0
	BREQ _0xE003F
; 0007 013C                 {
; 0007 013D                     t1[0] = 0;
	LDI  R30,LOW(0)
	STD  Y+42,R30
	STD  Y+42+1,R30
; 0007 013E                     TCNT1 = 0;
	LDI  R30,LOW(0)
	LDI  R31,HIGH(0)
	OUT  0x2C+1,R31
	OUT  0x2C,R30
; 0007 013F                     ovf = 0;
	STS  _ovf,R30
; 0007 0140                     flag = 2;
	LDI  R17,LOW(2)
; 0007 0141                 }
; 0007 0142                 break;
_0xE003F:
	RJMP _0xE003D
; 0007 0143 
; 0007 0144             case(2):
_0xE003E:
	CPI  R30,LOW(0x2)
	BRNE _0xE0043
; 0007 0145                 if(dir ? PINE.1 : PINE.0)
	LDS  R30,_dir
	CPI  R30,0
	BREQ _0xE0045
	LDI  R30,0
	SBIC 0x1,1
	LDI  R30,1
	RJMP _0xE0046
_0xE0045:
	LDI  R30,0
	SBIC 0x1,0
	LDI  R30,1
_0xE0046:
	CPI  R30,0
	BREQ _0xE0044
; 0007 0146                 {
; 0007 0147                     t1[1] = TCNT1;
	IN   R30,0x2C
	IN   R31,0x2C+1
	STD  Y+44,R30
	STD  Y+44+1,R31
; 0007 0148                     flag = 3;
	LDI  R17,LOW(3)
; 0007 0149                 }
; 0007 014A                 break;
_0xE0044:
	RJMP _0xE003D
; 0007 014B 
; 0007 014C             case(3):
_0xE0043:
	CPI  R30,LOW(0x3)
	BRNE _0xE0048
; 0007 014D //                if(dir ? !PINE.1 : !PINE.0) flag = 2; // TEST for checking speed
; 0007 014E                 if(dir ? !PINE.0 : !PINE.1)
	LDS  R30,_dir
	CPI  R30,0
	BREQ _0xE004A
	LDI  R30,0
	SBIS 0x1,0
	LDI  R30,1
	RJMP _0xE004B
_0xE004A:
	LDI  R30,0
	SBIS 0x1,1
	LDI  R30,1
_0xE004B:
	CPI  R30,0
	BREQ _0xE0049
; 0007 014F                 {
; 0007 0150                     t2[0] = TCNT1;
	IN   R30,0x2C
	IN   R31,0x2C+1
	STD  Y+38,R30
	STD  Y+38+1,R31
; 0007 0151                     flag = 4;
	LDI  R17,LOW(4)
; 0007 0152                 }
; 0007 0153                 break;
_0xE0049:
	RJMP _0xE003D
; 0007 0154 
; 0007 0155             case(4):
_0xE0048:
	CPI  R30,LOW(0x4)
	BRNE _0xE004D
; 0007 0156                 if(dir ? PINE.0 : PINE.1)
	LDS  R30,_dir
	CPI  R30,0
	BREQ _0xE004F
	LDI  R30,0
	SBIC 0x1,0
	LDI  R30,1
	RJMP _0xE0050
_0xE004F:
	LDI  R30,0
	SBIC 0x1,1
	LDI  R30,1
_0xE0050:
	CPI  R30,0
	BREQ _0xE004E
; 0007 0157                 {
; 0007 0158                     t2[1] = TCNT1;
	IN   R30,0x2C
	IN   R31,0x2C+1
	STD  Y+40,R30
	STD  Y+40+1,R31
; 0007 0159                     flag = 5;
	LDI  R17,LOW(5)
; 0007 015A //                    refresh = 1;
; 0007 015B                 }
; 0007 015C                 break;
_0xE004E:
	RJMP _0xE003D
; 0007 015D 
; 0007 015E             case(5):
_0xE004D:
	CPI  R30,LOW(0x5)
	BRNE _0xE0054
; 0007 015F //                if(dir ? !PINE.0 : !PINE.1) flag = 4; // TEST for checking speed
; 0007 0160                 if(ovf)
	LDS  R30,_ovf
	CPI  R30,0
	BREQ _0xE0053
; 0007 0161                 {
; 0007 0162                     flag = 0;
	LDI  R17,LOW(0)
; 0007 0163                     refresh = 1;
	LDI  R16,LOW(1)
; 0007 0164                 }
; 0007 0165                 break;
_0xE0053:
; 0007 0166 
; 0007 0167             default:
_0xE0054:
; 0007 0168 
; 0007 0169                 break;
; 0007 016A         }
_0xE003D:
; 0007 016B /*
; 0007 016C         if(ovf && (flag > 1))
; 0007 016D         {
; 0007 016E             gfx_ClearBuf();
; 0007 016F             sprintf(buf, "ERROR - TIMER OVERFLOW");
; 0007 0170             gfx_Refresh();
; 0007 0171             flag = 0;
; 0007 0172         }
; 0007 0173 */
; 0007 0174         if(refresh)
	CPI  R16,0
	BRNE PC+3
	JMP _0xE0055
; 0007 0175         {
; 0007 0176             gfx_ClearBuf();
	CALL _gfx_ClearBuf
; 0007 0177 
; 0007 0178             gfx_SetXY(0, Font_6x8.H * 0);
	LDI  R30,LOW(0)
	ST   -Y,R30
	ST   -Y,R30
	CALL _gfx_SetXY
; 0007 0179             sprintf(buf, "T1S: %5u", t1[0]);
	MOVW R30,R28
	ADIW R30,2
	ST   -Y,R31
	ST   -Y,R30
	__POINTW1FN _0xE0000,183
	ST   -Y,R31
	ST   -Y,R30
	LDD  R30,Y+46
	LDD  R31,Y+46+1
	CLR  R22
	CLR  R23
	CALL __PUTPARD1
	LDI  R24,4
	CALL _sprintf
	ADIW R28,8
; 0007 017A             gfx_PutStr(buf, 0xFF, &Font_6x8);
	MOVW R30,R28
	ADIW R30,2
	ST   -Y,R31
	ST   -Y,R30
	LDI  R30,LOW(255)
	ST   -Y,R30
	LDI  R30,LOW(_Font_6x8)
	LDI  R31,HIGH(_Font_6x8)
	ST   -Y,R31
	ST   -Y,R30
	CALL _gfx_PutStr
; 0007 017B 
; 0007 017C             gfx_SetXY(WidthS/2, Font_6x8.H * 0);
	LDI  R30,LOW(64)
	ST   -Y,R30
	LDI  R30,LOW(0)
	ST   -Y,R30
	CALL _gfx_SetXY
; 0007 017D             sprintf(buf, "T1E: %5u", t1[1]);
	MOVW R30,R28
	ADIW R30,2
	ST   -Y,R31
	ST   -Y,R30
	__POINTW1FN _0xE0000,192
	ST   -Y,R31
	ST   -Y,R30
	LDD  R30,Y+48
	LDD  R31,Y+48+1
	CLR  R22
	CLR  R23
	CALL __PUTPARD1
	LDI  R24,4
	CALL _sprintf
	ADIW R28,8
; 0007 017E             gfx_PutStr(buf, 0xFF, &Font_6x8);
	MOVW R30,R28
	ADIW R30,2
	ST   -Y,R31
	ST   -Y,R30
	LDI  R30,LOW(255)
	ST   -Y,R30
	LDI  R30,LOW(_Font_6x8)
	LDI  R31,HIGH(_Font_6x8)
	ST   -Y,R31
	ST   -Y,R30
	CALL _gfx_PutStr
; 0007 017F 
; 0007 0180             gfx_SetXY(0, Font_6x8.H * 1);
	LDI  R30,LOW(0)
	ST   -Y,R30
	__GETB1MN _Font_6x8,1
	ST   -Y,R30
	CALL _gfx_SetXY
; 0007 0181             sprintf(buf, "T2S: %5u", t2[0]);
	MOVW R30,R28
	ADIW R30,2
	ST   -Y,R31
	ST   -Y,R30
	__POINTW1FN _0xE0000,201
	ST   -Y,R31
	ST   -Y,R30
	LDD  R30,Y+42
	LDD  R31,Y+42+1
	CLR  R22
	CLR  R23
	CALL __PUTPARD1
	LDI  R24,4
	CALL _sprintf
	ADIW R28,8
; 0007 0182             gfx_PutStr(buf, 0xFF, &Font_6x8);
	MOVW R30,R28
	ADIW R30,2
	ST   -Y,R31
	ST   -Y,R30
	LDI  R30,LOW(255)
	ST   -Y,R30
	LDI  R30,LOW(_Font_6x8)
	LDI  R31,HIGH(_Font_6x8)
	ST   -Y,R31
	ST   -Y,R30
	CALL _gfx_PutStr
; 0007 0183 
; 0007 0184             gfx_SetXY(WidthS/2, Font_6x8.H * 1);
	LDI  R30,LOW(64)
	ST   -Y,R30
	__GETB1MN _Font_6x8,1
	ST   -Y,R30
	CALL _gfx_SetXY
; 0007 0185             sprintf(buf, "T2E: %5u", t2[1]);
	MOVW R30,R28
	ADIW R30,2
	ST   -Y,R31
	ST   -Y,R30
	__POINTW1FN _0xE0000,210
	ST   -Y,R31
	ST   -Y,R30
	LDD  R30,Y+44
	LDD  R31,Y+44+1
	CLR  R22
	CLR  R23
	CALL __PUTPARD1
	LDI  R24,4
	CALL _sprintf
	ADIW R28,8
; 0007 0186             gfx_PutStr(buf, 0xFF, &Font_6x8);
	MOVW R30,R28
	ADIW R30,2
	ST   -Y,R31
	ST   -Y,R30
	LDI  R30,LOW(255)
	ST   -Y,R30
	LDI  R30,LOW(_Font_6x8)
	LDI  R31,HIGH(_Font_6x8)
	ST   -Y,R31
	ST   -Y,R30
	CALL _gfx_PutStr
; 0007 0187 
; 0007 0188             gfx_SetXY(0, Font_6x8.H * 2);
	LDI  R30,LOW(0)
	ST   -Y,R30
	__GETB1MN _Font_6x8,1
	LSL  R30
	ST   -Y,R30
	CALL _gfx_SetXY
; 0007 0189             sprintf(buf, "Speed 1: %3u m/s", 140000l / t2[0]);
	MOVW R30,R28
	ADIW R30,2
	ST   -Y,R31
	ST   -Y,R30
	__POINTW1FN _0xE0000,219
	ST   -Y,R31
	ST   -Y,R30
	LDD  R30,Y+42
	LDD  R31,Y+42+1
	CLR  R22
	CLR  R23
	__GETD2N 0x222E0
	CALL __DIVD21
	CALL __PUTPARD1
	LDI  R24,4
	CALL _sprintf
	ADIW R28,8
; 0007 018A             gfx_PutStr(buf, 0xFF, &Font_6x8);
	MOVW R30,R28
	ADIW R30,2
	ST   -Y,R31
	ST   -Y,R30
	LDI  R30,LOW(255)
	ST   -Y,R30
	LDI  R30,LOW(_Font_6x8)
	LDI  R31,HIGH(_Font_6x8)
	ST   -Y,R31
	ST   -Y,R30
	CALL _gfx_PutStr
; 0007 018B 
; 0007 018C             gfx_SetXY(0, Font_6x8.H * 3);
	LDI  R30,LOW(0)
	ST   -Y,R30
	__GETB2MN _Font_6x8,1
	LDI  R30,LOW(3)
	MUL  R30,R26
	ST   -Y,R0
	CALL _gfx_SetXY
; 0007 018D             sprintf(buf, "Speed 2: %3u m/s", 140000l / (t2[1] - t1[1]));
	MOVW R30,R28
	ADIW R30,2
	ST   -Y,R31
	ST   -Y,R30
	__POINTW1FN _0xE0000,236
	ST   -Y,R31
	ST   -Y,R30
	LDD  R26,Y+48
	LDD  R27,Y+48+1
	LDD  R30,Y+44
	LDD  R31,Y+44+1
	SUB  R30,R26
	SBC  R31,R27
	CLR  R22
	CLR  R23
	__GETD2N 0x222E0
	CALL __DIVD21
	CALL __PUTPARD1
	LDI  R24,4
	CALL _sprintf
	ADIW R28,8
; 0007 018E             gfx_PutStr(buf, 0xFF, &Font_6x8);
	MOVW R30,R28
	ADIW R30,2
	ST   -Y,R31
	ST   -Y,R30
	LDI  R30,LOW(255)
	ST   -Y,R30
	LDI  R30,LOW(_Font_6x8)
	LDI  R31,HIGH(_Font_6x8)
	ST   -Y,R31
	ST   -Y,R30
	CALL _gfx_PutStr
; 0007 018F 
; 0007 0190             l = ((140000l * t1[1]) / t2[0]) / 200;
	LDD  R30,Y+44
	LDD  R31,Y+44+1
	CLR  R22
	CLR  R23
	__GETD2N 0x222E0
	CALL __MULD12
	MOVW R26,R30
	MOVW R24,R22
	LDD  R30,Y+38
	LDD  R31,Y+38+1
	CLR  R22
	CLR  R23
	CALL __DIVD21
	MOVW R26,R30
	MOVW R24,R22
	__GETD1N 0xC8
	CALL __DIVD21
	__PUTD1S 34
; 0007 0191             gfx_SetXY(0, Font_6x8.H * 4);
	LDI  R30,LOW(0)
	ST   -Y,R30
	__GETB1MN _Font_6x8,1
	LSL  R30
	LSL  R30
	ST   -Y,R30
	CALL _gfx_SetXY
; 0007 0192             sprintf(buf, "L1S1: %3u.%1u mm", l/10, l%10);
	MOVW R30,R28
	ADIW R30,2
	ST   -Y,R31
	ST   -Y,R30
	__POINTW1FN _0xE0000,253
	ST   -Y,R31
	ST   -Y,R30
	__GETD2S 38
	__GETD1N 0xA
	CALL __DIVD21U
	CALL __PUTPARD1
	__GETD2S 42
	__GETD1N 0xA
	CALL __MODD21U
	CALL __PUTPARD1
	LDI  R24,8
	CALL _sprintf
	ADIW R28,12
; 0007 0193             gfx_PutStr(buf, 0xFF, &Font_6x8);
	MOVW R30,R28
	ADIW R30,2
	ST   -Y,R31
	ST   -Y,R30
	LDI  R30,LOW(255)
	ST   -Y,R30
	LDI  R30,LOW(_Font_6x8)
	LDI  R31,HIGH(_Font_6x8)
	ST   -Y,R31
	ST   -Y,R30
	CALL _gfx_PutStr
; 0007 0194 
; 0007 0195             l = ((140000l * t1[1]) / (t2[1] - t1[1])) / 200;
	LDD  R30,Y+44
	LDD  R31,Y+44+1
	CLR  R22
	CLR  R23
	__GETD2N 0x222E0
	CALL __MULD12
	PUSH R23
	PUSH R22
	PUSH R31
	PUSH R30
	LDD  R26,Y+44
	LDD  R27,Y+44+1
	LDD  R30,Y+40
	LDD  R31,Y+40+1
	SUB  R30,R26
	SBC  R31,R27
	POP  R26
	POP  R27
	POP  R24
	POP  R25
	CLR  R22
	CLR  R23
	CALL __DIVD21
	MOVW R26,R30
	MOVW R24,R22
	__GETD1N 0xC8
	CALL __DIVD21
	__PUTD1S 34
; 0007 0196             gfx_SetXY(WidthS/2, Font_6x8.H * 4);
	LDI  R30,LOW(64)
	ST   -Y,R30
	__GETB1MN _Font_6x8,1
	LSL  R30
	LSL  R30
	ST   -Y,R30
	CALL _gfx_SetXY
; 0007 0197             sprintf(buf, "L1S2: %3u.%1u mm", l/10, l%10);
	MOVW R30,R28
	ADIW R30,2
	ST   -Y,R31
	ST   -Y,R30
	__POINTW1FN _0xE0000,270
	ST   -Y,R31
	ST   -Y,R30
	__GETD2S 38
	__GETD1N 0xA
	CALL __DIVD21U
	CALL __PUTPARD1
	__GETD2S 42
	__GETD1N 0xA
	CALL __MODD21U
	CALL __PUTPARD1
	LDI  R24,8
	CALL _sprintf
	ADIW R28,12
; 0007 0198             gfx_PutStr(buf, 0xFF, &Font_6x8);
	MOVW R30,R28
	ADIW R30,2
	ST   -Y,R31
	ST   -Y,R30
	LDI  R30,LOW(255)
	ST   -Y,R30
	LDI  R30,LOW(_Font_6x8)
	LDI  R31,HIGH(_Font_6x8)
	ST   -Y,R31
	ST   -Y,R30
	CALL _gfx_PutStr
; 0007 0199 
; 0007 019A             l = ((140000l * (t2[1] - t2[0])) / t2[0]) / 200;
	LDD  R26,Y+38
	LDD  R27,Y+38+1
	LDD  R30,Y+40
	LDD  R31,Y+40+1
	SUB  R30,R26
	SBC  R31,R27
	CLR  R22
	CLR  R23
	__GETD2N 0x222E0
	CALL __MULD12
	MOVW R26,R30
	MOVW R24,R22
	LDD  R30,Y+38
	LDD  R31,Y+38+1
	CLR  R22
	CLR  R23
	CALL __DIVD21
	MOVW R26,R30
	MOVW R24,R22
	__GETD1N 0xC8
	CALL __DIVD21
	__PUTD1S 34
; 0007 019B             gfx_SetXY(0, Font_6x8.H * 5);
	LDI  R30,LOW(0)
	ST   -Y,R30
	__GETB2MN _Font_6x8,1
	LDI  R30,LOW(5)
	MUL  R30,R26
	ST   -Y,R0
	CALL _gfx_SetXY
; 0007 019C             sprintf(buf, "L2S1: %3u.%1u mm", l/10, l%10);
	MOVW R30,R28
	ADIW R30,2
	ST   -Y,R31
	ST   -Y,R30
	__POINTW1FN _0xE0000,287
	ST   -Y,R31
	ST   -Y,R30
	__GETD2S 38
	__GETD1N 0xA
	CALL __DIVD21U
	CALL __PUTPARD1
	__GETD2S 42
	__GETD1N 0xA
	CALL __MODD21U
	CALL __PUTPARD1
	LDI  R24,8
	CALL _sprintf
	ADIW R28,12
; 0007 019D             gfx_PutStr(buf, 0xFF, &Font_6x8);
	MOVW R30,R28
	ADIW R30,2
	ST   -Y,R31
	ST   -Y,R30
	LDI  R30,LOW(255)
	ST   -Y,R30
	LDI  R30,LOW(_Font_6x8)
	LDI  R31,HIGH(_Font_6x8)
	ST   -Y,R31
	ST   -Y,R30
	CALL _gfx_PutStr
; 0007 019E 
; 0007 019F             l = ((140000l * (t2[1] - t2[0])) / (t2[1] - t1[1])) / 200;
	LDD  R26,Y+38
	LDD  R27,Y+38+1
	LDD  R30,Y+40
	LDD  R31,Y+40+1
	SUB  R30,R26
	SBC  R31,R27
	CLR  R22
	CLR  R23
	__GETD2N 0x222E0
	CALL __MULD12
	PUSH R23
	PUSH R22
	PUSH R31
	PUSH R30
	LDD  R26,Y+44
	LDD  R27,Y+44+1
	LDD  R30,Y+40
	LDD  R31,Y+40+1
	SUB  R30,R26
	SBC  R31,R27
	POP  R26
	POP  R27
	POP  R24
	POP  R25
	CLR  R22
	CLR  R23
	CALL __DIVD21
	MOVW R26,R30
	MOVW R24,R22
	__GETD1N 0xC8
	CALL __DIVD21
	__PUTD1S 34
; 0007 01A0             gfx_SetXY(WidthS/2, Font_6x8.H * 5);
	LDI  R30,LOW(64)
	ST   -Y,R30
	__GETB2MN _Font_6x8,1
	LDI  R30,LOW(5)
	MUL  R30,R26
	ST   -Y,R0
	CALL _gfx_SetXY
; 0007 01A1             sprintf(buf, "L2S2: %3u.%1u mm", l/10, l%10);
	MOVW R30,R28
	ADIW R30,2
	ST   -Y,R31
	ST   -Y,R30
	__POINTW1FN _0xE0000,304
	ST   -Y,R31
	ST   -Y,R30
	__GETD2S 38
	__GETD1N 0xA
	CALL __DIVD21U
	CALL __PUTPARD1
	__GETD2S 42
	__GETD1N 0xA
	CALL __MODD21U
	CALL __PUTPARD1
	LDI  R24,8
	CALL _sprintf
	ADIW R28,12
; 0007 01A2             gfx_PutStr(buf, 0xFF, &Font_6x8);
	MOVW R30,R28
	ADIW R30,2
	ST   -Y,R31
	ST   -Y,R30
	LDI  R30,LOW(255)
	ST   -Y,R30
	LDI  R30,LOW(_Font_6x8)
	LDI  R31,HIGH(_Font_6x8)
	ST   -Y,R31
	ST   -Y,R30
	CALL _gfx_PutStr
; 0007 01A3 
; 0007 01A4             gfx_Refresh();
	CALL _gfx_Refresh
; 0007 01A5             refresh = 0;
	LDI  R16,LOW(0)
; 0007 01A6         }
; 0007 01A7     }
_0xE0055:
	RJMP _0xE0037
_0xE0039:
; 0007 01A8 
; 0007 01A9     //  
; 0007 01AA     hwl_InitUSART0(BAUD_RATE); // USART0 initialization
	__GETD1N 0x1C200
	CALL __PUTPARD1
	CALL _hwl_InitUSART0
; 0007 01AB     hwl_InitTimers(); // Timers/Counters initialization
	CALL _hwl_InitTimers
; 0007 01AC     TIMSK = 0x10; //      
	LDI  R30,LOW(16)
	OUT  0x37,R30
; 0007 01AD     ETIMSK = 0x10; //     
	STS  125,R30
; 0007 01AE }
	LDD  R17,Y+1
	LDD  R16,Y+0
	ADIW R28,46
	RET
;
;// *****************************************************************************
;// ***    ""   ********************************************************
;// *****************************************************************************
;
;// ***        **************************************
;char * ChronDirGetStr(char * Buf, char AddParam)
; 0007 01B6 {
_ChronDirGetStr:
; 0007 01B7     //     
; 0007 01B8     sprintf(Buf, dir ? "REV" : "NOR");
;	*Buf -> Y+1
;	AddParam -> Y+0
	LDD  R30,Y+1
	LDD  R31,Y+1+1
	ST   -Y,R31
	ST   -Y,R30
	LDS  R30,_dir
	CPI  R30,0
	BREQ _0xE0056
	__POINTW1FN _0xE0000,321
	RJMP _0xE0057
_0xE0056:
	__POINTW1FN _0xE0000,325
_0xE0057:
	ST   -Y,R31
	ST   -Y,R30
	LDI  R24,0
	CALL _sprintf
	ADIW R28,4
; 0007 01B9     //     
; 0007 01BA     return(Buf);
	LDD  R30,Y+1
	LDD  R31,Y+1+1
	ADIW R28,3
	RET
; 0007 01BB }
;// ***       *****************************************************
;void ChronDirSet(char AddParam)
; 0007 01BE {
_ChronDirSet:
; 0007 01BF     //    
; 0007 01C0     char result;
; 0007 01C1     //    
; 0007 01C2     flash char * Strings[2] = {"NOR", "REV"};
; 0007 01C3 
; 0007 01C4     //    
; 0007 01C5     result = SelectBoxF((flash char **)Strings, 2, dir, NULL, "Direction:", NULL);
	SBIW R28,4
	LDI  R30,LOW(_0xE0000*2+325)
	LDI  R31,HIGH(_0xE0000*2+325)
	ST   Y,R30
	STD  Y+1,R31
	LDI  R30,LOW(_0xE0000*2+321)
	LDI  R31,HIGH(_0xE0000*2+321)
	STD  Y+2,R30
	STD  Y+2+1,R31
	ST   -Y,R17
;	AddParam -> Y+5
;	result -> R17
;	Strings -> Y+1
	MOVW R30,R28
	ADIW R30,1
	ST   -Y,R31
	ST   -Y,R30
	LDI  R30,LOW(2)
	ST   -Y,R30
	LDS  R30,_dir
	ST   -Y,R30
	LDI  R30,LOW(0)
	LDI  R31,HIGH(0)
	ST   -Y,R31
	ST   -Y,R30
	__POINTW1FN _0xE0000,329
	ST   -Y,R31
	ST   -Y,R30
	LDI  R30,LOW(0)
	LDI  R31,HIGH(0)
	ST   -Y,R31
	ST   -Y,R30
	CALL _SelectBoxF
	MOV  R17,R30
; 0007 01C6 
; 0007 01C7     //    ( )
; 0007 01C8     if(result != -1) dir = result;  //   
	CPI  R17,255
	BREQ _0xE0059
	STS  _dir,R17
; 0007 01C9 }
_0xE0059:
	LDD  R17,Y+0
	JMP  _0x206001B
;
;// ***          *************************
;void Chron_AP(char AddParam) {Chron();}
; 0007 01CC void Chron_AP(char AddParam) {Chron();}
_Chron_AP:
;	AddParam -> Y+0
	RCALL _Chron
	JMP  _0x2060019
;
;// ***       *********************************************************
;flash MenuButton ChronMenuButtons[] =
;{{"Start",       Chron_AP, NULL},
; {"Direction",   ChronDirSet,   ChronDirGetStr}};
;
;// ***       ********************************************************
;void ChronMenu(char AddParam)
; 0007 01D5 {
_ChronMenu:
; 0007 01D6     //   
; 0007 01D7     MenuPad Pad = {"Chron", &Font_8x12, &Font_6x8, ChronMenuButtons, NumberOf(ChronMenuButtons), 0, NULL, NULL};
; 0007 01D8     //   
; 0007 01D9     MenuCycle(&Pad);
	SBIW R28,14
	LDI  R24,14
	LDI  R26,LOW(0)
	LDI  R27,HIGH(0)
	LDI  R30,LOW(_0xE005A*2)
	LDI  R31,HIGH(_0xE005A*2)
	CALL __INITLOCB
;	AddParam -> Y+14
;	Pad -> Y+0
	MOVW R30,R28
	ST   -Y,R31
	ST   -Y,R30
	CALL _MenuCycle
; 0007 01DA }
	ADIW R28,15
	RET
;/*******************************************************************************
;*  Variables.c
;*
;*  :  
;*
;*       Copyright (c) 2007-2009 Nick Shl, focus
;*           All rights reserved.
;*
;*
;*  :
;*
;*  Apr 20, 2009  Nick_Shl  
;*  Apr 21, 2009  Nick_Shl  , 
;*  *** **, ****  focus      
;*
;*/// ***************************************************************************
;
;// *****************************************************************************
;// ***       ********************************************
;// *****************************************************************************
;#include "def.h"
;#include "variables.h"
;
;//     -   SRAM
;TRANSMITTER_SETTINGS Settings;
;//     -   EEPROM
;eeprom EEPROM_TRANSMITTER_SETTINGS EEPROM_SETTINGS;
;
;//      -   SRAM
;MODEL_SETTINGS CurModel;
;//      -   EEPROM
;eeprom EEPROM_MODEL_SETTINGS EEPROM_MODEL[MAX_MODELS];
;
;// *****************************************************************************
;// ***        *****************************************
;// *****************************************************************************
;//       
;//        
;char tmpStr[64];
;char tmpBuf[32];
;
;// *****************************************************************************
;// ***      **************************************************************
;// *****************************************************************************
;
;//   
;signed int Aref;
;
;//    
;signed int AD[MAX_ADC];
;//    
;signed int AD_NORM[MAX_ADC];
;//   
;signed int input[MAX_CONTROLS];
;//    ( , ,   ..)
;signed int out_cur[MAX_CONTROLS];
;//    
;signed int output[MAX_CHANNELS];
;
;//   :
;signed int ADmin[MAX_ADC]; //   \       .
;signed int ADmax[MAX_ADC]; //   /    .
;
;//   
;char FLY_MODE;
;//    .   ,
;//   . .
;unsigned char trim_sound_en;
;//   -       
;//   minDRates
;char Cut_enable;
;/*******************************************************************************
;*  Tasks.c
;*
;*  :   
;*
;*       Copyright (c) 2009 Nick Shl
;*           All rights reserved.
;*
;*
;*  :
;*
;*  Mar 25, 2009  Nick_Shl   
;*
;*/// ***************************************************************************
;#include <mega128.h>
	#ifndef __SLEEP_DEFINED__
	#define __SLEEP_DEFINED__
	.EQU __se_bit=0x20
	.EQU __sm_mask=0x1C
	.EQU __sm_powerdown=0x10
	.EQU __sm_powersave=0x18
	.EQU __sm_standby=0x14
	.EQU __sm_ext_standby=0x1C
	.EQU __sm_adc_noise_red=0x08
	.SET power_ctrl_reg=mcucr
	#endif
;#include <delay.h>
;#include <stdio.h>
;
;#include "Def.h"
;#include "Tasks.h"
;#include "Coder.h"
;#include "Sound.h"
;#include "System.h"
;#include "Variables.h"
;
;// *****************************************************************************
;// *****************************************************************************
;// ***       ************************************************
;// *****************************************************************************
;// *****************************************************************************
;
;static unsigned char NeedSaveTrimmers = FALSE;
;static unsigned long TimeToTrimmersSave;
;
;// *****************************************************************************
;// ***          ***************
;// *****************************************************************************
;// Time -   100  ,     
;inline void Trimmers_Need_Save(unsigned char Time)
; 0009 0028 {

	.CSEG
_Trimmers_Need_Save:
; 0009 0029     NeedSaveTrimmers = TRUE;
;	Time -> Y+0
	LDI  R30,LOW(1)
	STS  _NeedSaveTrimmers_G009,R30
; 0009 002A     TimeToTrimmersSave = GetRunningTime() + (unsigned long)Time * 100;
	CALL _GetRunningTime
	PUSH R23
	PUSH R22
	PUSH R31
	PUSH R30
	LD   R26,Y
	CLR  R27
	CLR  R24
	CLR  R25
	__GETD1N 0x64
	CALL __MULD12U
	POP  R26
	POP  R27
	POP  R24
	POP  R25
	CALL __ADDD12
	STS  _TimeToTrimmersSave_G009,R30
	STS  _TimeToTrimmersSave_G009+1,R31
	STS  _TimeToTrimmersSave_G009+2,R22
	STS  _TimeToTrimmersSave_G009+3,R23
; 0009 002B }
	JMP  _0x2060019
;
;// *****************************************************************************
;// ***        *****************************************
;// *****************************************************************************
;void Trimmers_Save_Task(unsigned char MissedInterruptsCount)
; 0009 0031 {
_Trimmers_Save_Task:
; 0009 0032     //        - 
; 0009 0033     if(NeedSaveTrimmers == FALSE) return;
;	MissedInterruptsCount -> Y+0
	LDS  R30,_NeedSaveTrimmers_G009
	CPI  R30,0
	BRNE _0x120003
	JMP  _0x2060019
; 0009 0034     //        - 
; 0009 0035     if(TimeToTrimmersSave > GetRunningTime()) return;
_0x120003:
	CALL _GetRunningTime
	LDS  R26,_TimeToTrimmersSave_G009
	LDS  R27,_TimeToTrimmersSave_G009+1
	LDS  R24,_TimeToTrimmersSave_G009+2
	LDS  R25,_TimeToTrimmersSave_G009+3
	CALL __CPD12
	BRSH _0x120004
	JMP  _0x2060019
; 0009 0036 
; 0009 0037     //     
; 0009 0038     NeedSaveTrimmers = FALSE;
_0x120004:
	LDI  R30,LOW(0)
	STS  _NeedSaveTrimmers_G009,R30
; 0009 0039     //   
; 0009 003A     MODEL_Save_Trimmers();
	CALL _MODEL_Save_Trimmers
; 0009 003B 
; 0009 003C #ifdef DEBUG
; 0009 003D         printf("Trimmers_Save_Task(): Trimmers saved, MissedInterruptsCount = %d\r", MissedInterruptsCount);
; 0009 003E         delay_ms(1);
; 0009 003F #endif
; 0009 0040 /*
; 0009 0041     //   
; 0009 0042     char i, j;
; 0009 0043     //      CRC
; 0009 0044     //  -    
; 0009 0045     static unsigned int OldTrimsCRC;
; 0009 0046     //    CRC
; 0009 0047     unsigned int NewTrimsCRC = 0;
; 0009 0048     //    CRC
; 0009 0049     unsigned long LastTrimsChangeTime = 0;
; 0009 004A     static char Fly_Mode = 0, Model_Num = 0;
; 0009 004B 
; 0009 004C     //  CRC  
; 0009 004D     for(i=0; i < FLY_MODES; i++)
; 0009 004E     {
; 0009 004F         NewTrimsCRC += Crc16_ram((unsigned char *)CurModel.Mode[i].trimmers, sizeof(CurModel.Mode[i].trimmers));
; 0009 0050     }
; 0009 0051 
; 0009 0052     //  CRC 
; 0009 0053     if(OldTrimsCRC != NewTrimsCRC)
; 0009 0054     {
; 0009 0055         //   CRC
; 0009 0056         OldTrimsCRC = NewTrimsCRC;
; 0009 0057         LastTrimsChangeTime = GetRunningTime();
; 0009 0058         return;
; 0009 0059     }
; 0009 005A 
; 0009 005B     if(LastTrimsChangeTime + 5000 > GetRunningTime()) return;
; 0009 005C 
; 0009 005D     for(i=0; i < FLY_MODES; i++)
; 0009 005E     {
; 0009 005F         NewTrimsCRC += Crc16_ram((unsigned char *)CurModel.Mode[i].trimmers, sizeof(CurModel.Mode[i].trimmers));
; 0009 0060     }
; 0009 0061 
; 0009 0062     for(i=0; i < FLY_MODES; i++)
; 0009 0063     {
; 0009 0064         for(j=0; j < MAX_TRIMMERS; j++)
; 0009 0065         {
; 0009 0066             EEPROM_MODEL[Settings.ModelNum].Mode[i].trimmers[j] = CurModel.Mode[i].trimmers[j];
; 0009 0067         }
; 0009 0068     }
; 0009 0069 */
; 0009 006A }
	RJMP _0x2060019
;
;// *****************************************************************************
;// *****************************************************************************
;// ***      **********************************************************
;// *****************************************************************************
;// *****************************************************************************
;
;// *****************************************************************************
;// ***     -  !                 *********
;// ***    AskButtons()    !   *********
;// *****************************************************************************
;static unsigned char KbdStat = 0;
;
;// *****************************************************************************
;// ***       **************************************************
;// *****************************************************************************
;void Keyboard_Driver_Task(unsigned char MissedInterruptsCount)
; 0009 007C {
_Keyboard_Driver_Task:
; 0009 007D     unsigned char NewKbdStat = 0;
; 0009 007E     static unsigned char OldKbdStat = 0;
; 0009 007F 
; 0009 0080     //       
; 0009 0081     if(HB_UP)    NewKbdStat |= B_UP;
	ST   -Y,R17
;	MissedInterruptsCount -> Y+1
;	NewKbdStat -> R17
	LDI  R17,0
	SBIS 0x10,3
	ORI  R17,LOW(1)
; 0009 0082     if(HB_DOWN)  NewKbdStat |= B_DOWN;
	SBIS 0x10,1
	ORI  R17,LOW(2)
; 0009 0083     if(HB_LEFT)  NewKbdStat |= B_LEFT;
	SBIS 0x10,2
	ORI  R17,LOW(4)
; 0009 0084     if(HB_RIGHT) NewKbdStat |= B_RIGHT;
	SBIS 0x10,0
	ORI  R17,LOW(8)
; 0009 0085     if(HB_BACK)  NewKbdStat |= B_BACK;
	SBIS 0x10,4
	ORI  R17,LOW(16)
; 0009 0086     if(HB_ENTER) NewKbdStat |= B_ENTER;
	SBIS 0x10,5
	ORI  R17,LOW(32)
; 0009 0087 
; 0009 0088     //     -  
; 0009 0089     if(NewKbdStat != OldKbdStat)
	LDS  R30,_OldKbdStat_S0090002000
	CP   R30,R17
	BREQ _0x12000B
; 0009 008A     {
; 0009 008B         OldKbdStat = NewKbdStat;
	STS  _OldKbdStat_S0090002000,R17
; 0009 008C     }
; 0009 008D     //   ,     -   .
; 0009 008E     else if(NewKbdStat != KbdStat)
	RJMP _0x12000C
_0x12000B:
	LDS  R30,_KbdStat_G009
	CP   R30,R17
	BREQ _0x12000D
; 0009 008F     {
; 0009 0090         KbdStat = NewKbdStat;
	STS  _KbdStat_G009,R17
; 0009 0091 #ifdef DEBUG
; 0009 0092         printf("Keyboard_Driver_Task(): New Status: KbdStat = 0x%02X, MissedInterruptsCount = %d\r", KbdStat, MissedInterruptsCount);
; 0009 0093         delay_ms(1);
; 0009 0094 #endif
; 0009 0095     }
; 0009 0096 }
_0x12000D:
_0x12000C:
	LDD  R17,Y+0
	ADIW R28,2
	RET
;
;// *****************************************************************************
;// ***         *************************************
;// *****************************************************************************
;// Delay  10  
;void WaitEmptyButtons(unsigned char Delay)
; 0009 009D {
_WaitEmptyButtons:
; 0009 009E #ifdef DEBUG
; 0009 009F     printf("WaitEmptyButtons(%d);\r", Delay);
; 0009 00A0     delay_ms(1);
; 0009 00A1 #endif
; 0009 00A2     //   0 -     
; 0009 00A3     if(Delay == 0) {while(KbdStat) {};}
;	Delay -> Y+0
	LD   R30,Y
	CPI  R30,0
	BRNE _0x12000E
_0x12000F:
	LDS  R30,_KbdStat_G009
	CPI  R30,0
	BRNE _0x12000F
; 0009 00A4     //      ,  
; 0009 00A5     else
	RJMP _0x120012
_0x12000E:
; 0009 00A6     {
; 0009 00A7         while(KbdStat)
_0x120013:
	LDS  R30,_KbdStat_G009
	CPI  R30,0
	BREQ _0x120015
; 0009 00A8         {
; 0009 00A9             delay_ms(10);
	LDI  R30,LOW(10)
	LDI  R31,HIGH(10)
	ST   -Y,R31
	ST   -Y,R30
	CALL _delay_ms
; 0009 00AA             Delay--;
	LD   R30,Y
	SUBI R30,LOW(1)
	ST   Y,R30
; 0009 00AB             if(Delay == 0) break;
	CPI  R30,0
	BRNE _0x120013
; 0009 00AC         };
_0x120015:
; 0009 00AD     }
_0x120012:
; 0009 00AE 
; 0009 00AF }
	RJMP _0x2060019
;
;// *****************************************************************************
;// ***        *********************************************
;// *****************************************************************************
;unsigned char WaitButtonPress(unsigned char mask)
; 0009 00B5 {
_WaitButtonPress:
; 0009 00B6     static char PREV_FLY_MODE = 0;
; 0009 00B7 
; 0009 00B8 #ifdef DEBUG
; 0009 00B9     printf("WaitButtonPress(0x%02X);\r", mask);
; 0009 00BA     delay_ms(1);
; 0009 00BB #endif
; 0009 00BC 
; 0009 00BD     //   
; 0009 00BE     if(mask)
;	mask -> Y+0
	LD   R30,Y
	CPI  R30,0
	BREQ _0x120017
; 0009 00BF     {
; 0009 00C0         //        
; 0009 00C1         while(!(KbdStat & mask));
_0x120018:
	LD   R30,Y
	LDS  R26,_KbdStat_G009
	AND  R30,R26
	BREQ _0x120018
; 0009 00C2     }
; 0009 00C3     // 
; 0009 00C4     else
	RJMP _0x12001B
_0x120017:
; 0009 00C5     {
; 0009 00C6         //     
; 0009 00C7         while(!(KbdStat))
_0x12001C:
	LDS  R30,_KbdStat_G009
	CPI  R30,0
	BRNE _0x12001E
; 0009 00C8         {
; 0009 00C9             //        
; 0009 00CA             if(PREV_FLY_MODE != FLY_MODE)
	LDS  R30,_FLY_MODE
	LDS  R26,_PREV_FLY_MODE_S0090004000
	CP   R30,R26
	BREQ _0x12001F
; 0009 00CB             {
; 0009 00CC                 PREV_FLY_MODE = FLY_MODE;
	STS  _PREV_FLY_MODE_S0090004000,R30
; 0009 00CD                 break;
	RJMP _0x12001E
; 0009 00CE             }
; 0009 00CF         };
_0x12001F:
	RJMP _0x12001C
_0x12001E:
; 0009 00D0     }
_0x12001B:
; 0009 00D1     return(KbdStat);
	LDS  R30,_KbdStat_G009
	RJMP _0x2060019
; 0009 00D2 }
;
;// *****************************************************************************
;// ***         *****************************
;// *****************************************************************************
;inline unsigned char AskButtons(void)
; 0009 00D8 {
_AskButtons:
; 0009 00D9 #ifdef DEBUG
; 0009 00DA //        -   
; 0009 00DB //    printf("AskButtons(): KbdStat = 0x%02X\r", KbdStat);
; 0009 00DC //    delay_ms(1);
; 0009 00DD #endif
; 0009 00DE     return(KbdStat);
	LDS  R30,_KbdStat_G009
	RET
; 0009 00DF }
;
;
;
;// *****************************************************************************
;// *****************************************************************************
;// ***      **************************************************************
;// *****************************************************************************
;// *****************************************************************************
;
;//   
;static int TimerValue;
;//   (    -  20 )
;static int TimerSubValue;
;//  
;static unsigned char CountingFlag;
;//   
;static unsigned char TimerSound;
;
;// *****************************************************************************
;// ***        *********************************************
;// *****************************************************************************
;void Timer_Task(unsigned char MissedInterruptsCount)
; 0009 00F6 {
_Timer_Task:
; 0009 00F7     //       
; 0009 00F8     static unsigned char counter;
; 0009 00F9     static unsigned char precounter;
; 0009 00FA 
; 0009 00FB     //   
; 0009 00FC     if(CountingFlag == ON)
;	MissedInterruptsCount -> Y+0
	LDS  R26,_CountingFlag_G009
	CPI  R26,LOW(0x1)
	BREQ PC+3
	JMP _0x120020
; 0009 00FD     {
; 0009 00FE         //   :    + 
; 0009 00FF         TimerSubValue += (int)MissedInterruptsCount + 1;
	LD   R30,Y
	LDI  R31,0
	ADIW R30,1
	LDS  R26,_TimerSubValue_G009
	LDS  R27,_TimerSubValue_G009+1
	ADD  R30,R26
	ADC  R31,R27
	STS  _TimerSubValue_G009,R30
	STS  _TimerSubValue_G009+1,R31
; 0009 0100 
; 0009 0101         //     50(   ) -  1 
; 0009 0102         if(TimerSubValue >= 50)
	LDS  R26,_TimerSubValue_G009
	LDS  R27,_TimerSubValue_G009+1
	SBIW R26,50
	BRLT _0x120021
; 0009 0103         {
; 0009 0104             //  50(   ) - 1 
; 0009 0105             TimerSubValue -= 50;
	SBIW R30,50
	STS  _TimerSubValue_G009,R30
	STS  _TimerSubValue_G009+1,R31
; 0009 0106             //   ,     
; 0009 0107             if(CurModel.timer_mode & 0x02) TimerValue--; // Timer Mode DOWN
	__GETB1MN _CurModel,19
	ANDI R30,LOW(0x2)
	BREQ _0x120022
	LDI  R26,LOW(_TimerValue_G009)
	LDI  R27,HIGH(_TimerValue_G009)
	LD   R30,X+
	LD   R31,X+
	SBIW R30,1
	RJMP _0x120033
; 0009 0108             else                           TimerValue++; // Timer Mode UP
_0x120022:
	LDI  R26,LOW(_TimerValue_G009)
	LDI  R27,HIGH(_TimerValue_G009)
	LD   R30,X+
	LD   R31,X+
	ADIW R30,1
_0x120033:
	ST   -X,R31
	ST   -X,R30
; 0009 0109 #ifdef DEBUG
; 0009 010A             printf("Timer_Task(): New Time: time = %d, MissedInterruptsCount = %d\r", TimerValue, MissedInterruptsCount);
; 0009 010B             delay_ms(1);
; 0009 010C #endif
; 0009 010D         }
; 0009 010E 
; 0009 010F         //    ,    ,        0
; 0009 0110         if((CurModel.timer_mode & 0x01) && (TimerValue == CurModel.timer) && (CountingFlag == ON) && (TimerValue != 0))
_0x120021:
	__GETB1MN _CurModel,19
	ANDI R30,LOW(0x1)
	BREQ _0x120025
	__GETW1MN _CurModel,17
	LDS  R26,_TimerValue_G009
	LDS  R27,_TimerValue_G009+1
	CP   R30,R26
	CPC  R31,R27
	BRNE _0x120025
	LDS  R26,_CountingFlag_G009
	CPI  R26,LOW(0x1)
	BRNE _0x120025
	LDS  R26,_TimerValue_G009
	LDS  R27,_TimerValue_G009+1
	SBIW R26,0
	BRNE _0x120026
_0x120025:
	RJMP _0x120024
_0x120026:
; 0009 0111         {
; 0009 0112             //   
; 0009 0113             TimerSound = ON;
	LDI  R30,LOW(1)
	STS  _TimerSound_G009,R30
; 0009 0114 
; 0009 0115             //      
; 0009 0116             counter = 0;
	LDI  R30,LOW(0)
	STS  _counter_S0090006000,R30
; 0009 0117             precounter = 0;
	STS  _precounter_S0090006000,R30
; 0009 0118         }
; 0009 0119 
; 0009 011A         //    ,    0   
; 0009 011B         if((CurModel.timer_mode & 0x02) && (TimerValue == 0) && (CountingFlag == ON))
_0x120024:
	__GETB1MN _CurModel,19
	ANDI R30,LOW(0x2)
	BREQ _0x120028
	LDS  R26,_TimerValue_G009
	LDS  R27,_TimerValue_G009+1
	SBIW R26,0
	BRNE _0x120028
	LDS  R26,_CountingFlag_G009
	CPI  R26,LOW(0x1)
	BREQ _0x120029
_0x120028:
	RJMP _0x120027
_0x120029:
; 0009 011C         {
; 0009 011D             //   
; 0009 011E             CountingFlag = OFF;
	LDI  R30,LOW(0)
	STS  _CountingFlag_G009,R30
; 0009 011F             //     
; 0009 0120             TimerValue = CurModel.timer;
	__GETW1MN _CurModel,17
	STS  _TimerValue_G009,R30
	STS  _TimerValue_G009+1,R31
; 0009 0121             TimerSubValue = 0;
	LDI  R30,LOW(0)
	STS  _TimerSubValue_G009,R30
	STS  _TimerSubValue_G009+1,R30
; 0009 0122 
; 0009 0123             //   
; 0009 0124             TimerSound = ON;
	LDI  R30,LOW(1)
	STS  _TimerSound_G009,R30
; 0009 0125 
; 0009 0126             //      
; 0009 0127             counter = 0;
	LDI  R30,LOW(0)
	STS  _counter_S0090006000,R30
; 0009 0128             precounter = 0;
	STS  _precounter_S0090006000,R30
; 0009 0129         }
; 0009 012A     }
_0x120027:
; 0009 012B 
; 0009 012C     //  
; 0009 012D     if(TimerSound == ON)
_0x120020:
	LDS  R26,_TimerSound_G009
	CPI  R26,LOW(0x1)
	BRNE _0x12002A
; 0009 012E     {
; 0009 012F         if(precounter == 20 || precounter == 0)
	LDS  R26,_precounter_S0090006000
	CPI  R26,LOW(0x14)
	BREQ _0x12002C
	CPI  R26,LOW(0x0)
	BRNE _0x12002B
_0x12002C:
; 0009 0130         {
; 0009 0131             precounter = 0;
	LDI  R30,LOW(0)
	STS  _precounter_S0090006000,R30
; 0009 0132             counter++;
	LDS  R30,_counter_S0090006000
	SUBI R30,-LOW(1)
	STS  _counter_S0090006000,R30
; 0009 0133             if(counter%2 == 0) Tone(1000); //  
	ANDI R30,LOW(0x1)
	BRNE _0x12002E
	LDI  R30,LOW(1000)
	LDI  R31,HIGH(1000)
	RJMP _0x120034
; 0009 0134             else               Tone(0);    //  
_0x12002E:
	LDI  R30,LOW(0)
	LDI  R31,HIGH(0)
_0x120034:
	ST   -Y,R31
	ST   -Y,R30
	CALL _Tone
; 0009 0135         }
; 0009 0136         if(counter == 25) TimerSound = OFF;
_0x12002B:
	LDS  R26,_counter_S0090006000
	CPI  R26,LOW(0x19)
	BRNE _0x120030
	LDI  R30,LOW(0)
	STS  _TimerSound_G009,R30
; 0009 0137         precounter++;
_0x120030:
	LDS  R30,_precounter_S0090006000
	SUBI R30,-LOW(1)
	STS  _precounter_S0090006000,R30
; 0009 0138     }
; 0009 0139 }
_0x12002A:
	RJMP _0x2060019
;
;// *****************************************************************************
;// ***           **********************
;// *****************************************************************************
;inline int GetTimerValue(void)
; 0009 013F {
_GetTimerValue:
; 0009 0140     return(TimerValue);
	LDS  R30,_TimerValue_G009
	LDS  R31,_TimerValue_G009+1
	RET
; 0009 0141 }
;inline int GetTimerSubValue(void)
; 0009 0143 {
_GetTimerSubValue:
; 0009 0144     return(TimerSubValue * TASK_TICK_TIME);
	LDS  R30,_TimerSubValue_G009
	LDS  R31,_TimerSubValue_G009+1
	LDI  R26,LOW(20)
	LDI  R27,HIGH(20)
	CALL __MULW12
	RET
; 0009 0145 }
;
;// *****************************************************************************
;// ***      ************************************************
;// *****************************************************************************
;void Timer_Init(void)
; 0009 014B {
_Timer_Init:
; 0009 014C     //        
; 0009 014D     if(CurModel.timer_mode & 0x02) TimerValue = CurModel.timer; // Timer Mode DOWN
	__GETB1MN _CurModel,19
	ANDI R30,LOW(0x2)
	BREQ _0x120031
	__GETW1MN _CurModel,17
	STS  _TimerValue_G009,R30
	STS  _TimerValue_G009+1,R31
; 0009 014E     else                           TimerValue = 0;              // Timer Mode UP
	RJMP _0x120032
_0x120031:
	LDI  R30,LOW(0)
	STS  _TimerValue_G009,R30
	STS  _TimerValue_G009+1,R30
; 0009 014F     TimerSubValue = 0;
_0x120032:
	LDI  R30,LOW(0)
	STS  _TimerSubValue_G009,R30
	STS  _TimerSubValue_G009+1,R30
; 0009 0150 
; 0009 0151     CountingFlag = Off;
	STS  _CountingFlag_G009,R30
; 0009 0152     TimerSound = Off;
	RJMP _0x206001C
; 0009 0153 }
;
;// *****************************************************************************
;// ***      *******************************************************
;// *****************************************************************************
;inline void Timer_Start(void)
; 0009 0159 {
_Timer_Start:
; 0009 015A     CountingFlag = On;
	LDI  R30,LOW(1)
	RJMP _0x206001D
; 0009 015B }
;
;// *****************************************************************************
;// ***      ******************************************************
;// *****************************************************************************
;inline void Timer_Stop(void)
; 0009 0161 {
_Timer_Stop:
; 0009 0162     CountingFlag = Off;
	LDI  R30,LOW(0)
_0x206001D:
	STS  _CountingFlag_G009,R30
; 0009 0163 }
	RET
;
;// *****************************************************************************
;// ***       (/)   ****************
;// *****************************************************************************
;inline unsigned char GetTimerSoundStatus(void)
; 0009 0169 {
_GetTimerSoundStatus:
; 0009 016A     return(TimerSound);
	LDS  R30,_TimerSound_G009
	RET
; 0009 016B }
;
;// *****************************************************************************
;// ***        **********************************************
;// *****************************************************************************
;inline void TimerSoundOff(void)
; 0009 0171 {
_TimerSoundOff:
; 0009 0172     TimerSound = Off;
_0x206001C:
	LDI  R30,LOW(0)
	STS  _TimerSound_G009,R30
; 0009 0173 }
	RET
;
;
;
;// *****************************************************************************
;// *****************************************************************************
;// ***      *************************************************************
;// *****************************************************************************
;// *****************************************************************************
;
;// *****************************************************************************
;// ***      -  !                   ******
;// ***    GetBattaryStatus()    !   ******
;// *****************************************************************************
;static signed int U_Bat = 0;
;
;// *****************************************************************************
;// ***       *****************************************************
;// *****************************************************************************
;void Battery_Driver_Task(unsigned char MissedInterruptsCount)
; 0009 0187 {
_Battery_Driver_Task:
; 0009 0188     //       
; 0009 0189     U_Bat = AD[ADC_BAT] * 2;
;	MissedInterruptsCount -> Y+0
	__GETW1MN _AD,14
	LSL  R30
	ROL  R31
	STS  _U_Bat_G009,R30
	STS  _U_Bat_G009+1,R31
; 0009 018A }
	RJMP _0x2060019
;
;// *****************************************************************************
;// ***         ************************************
;// *****************************************************************************
;inline signed int GetBatteryStatus(void)
; 0009 0190 {
_GetBatteryStatus:
; 0009 0191     return(U_Bat);
	LDS  R30,_U_Bat_G009
	LDS  R31,_U_Bat_G009+1
	RET
; 0009 0192 }
;/*******************************************************************************
;*  System.c
;*
;*  :  
;*
;*       Copyright (c) 2009 Nick Shl
;*           All rights reserved.
;*
;*
;*  :
;*
;*  Mar 25, 2009  Nick_Shl   
;*
;*/// ***************************************************************************
;
;#include <mega128.h>
	#ifndef __SLEEP_DEFINED__
	#define __SLEEP_DEFINED__
	.EQU __se_bit=0x20
	.EQU __sm_mask=0x1C
	.EQU __sm_powerdown=0x10
	.EQU __sm_powersave=0x18
	.EQU __sm_standby=0x14
	.EQU __sm_ext_standby=0x1C
	.EQU __sm_adc_noise_red=0x08
	.SET power_ctrl_reg=mcucr
	#endif
;#include <delay.h>
;#include <stdio.h>
;#include <string.h>
;
;#include "Def.h"
;#include "Variables.h"
;#include "Graphic.h"
;#include "Sound.h"
;#include "Tasks.h"
;#include "UI_Engine.h"
;#include "Coder.h"
;#include "CRC.h"
;#include "System.h"
;
;// *****************************************************************************
;// ***        ( )   **********
;// *****************************************************************************
;static flash char * DefModeNames[MAX_MODES] =
;{
;    "Normal",
;    "Pilotage",
;    "Landing"
;};

	.DSEG
;
;// *****************************************************************************
;// ***     -       ***********
;// *****************************************************************************
;static eeprom unsigned char EEPROM_TRASH @(0x0000);
;
;// *****************************************************************************
;// ***      CRC,    EEPROM   ***************
;// *****************************************************************************
;static eeprom unsigned short EEPROM_CRC @(0x1000 - sizeof(unsigned short));
;
;// *****************************************************************************
;// ***        ********************************************
;// *****************************************************************************
;//    EEPROM     CRC
;//    EEPROM(0) +   
;#define EEPROM_CRC_START ((unsigned char eeprom *)(0x0000 + sizeof(EEPROM_TRASH)))
;//   EEPROM     CRC
;//   EEPROM -    -    CRC
;#define EEPROM_CRC_SIZE (0x1000 - sizeof(EEPROM_TRASH) - sizeof(EEPROM_CRC))
;
;// *****************************************************************************
;// ***    CRC EEPROM      ************************************
;// *****************************************************************************
;static inline void Recalc_EEPROM_CRC(void)
; 000A 0041 {

	.CSEG
_Recalc_EEPROM_CRC_G00A:
; 000A 0042     //   EEPROM CRC     EEPROM
; 000A 0043     EEPROM_CRC = Crc16_eeprom(EEPROM_CRC_START, EEPROM_CRC_SIZE);
	LDI  R30,LOW(1)
	LDI  R31,HIGH(1)
	ST   -Y,R31
	ST   -Y,R30
	LDI  R30,LOW(4093)
	LDI  R31,HIGH(4093)
	ST   -Y,R31
	ST   -Y,R30
	CALL _Crc16_eeprom
	LDI  R26,LOW(_EEPROM_CRC_G00A)
	LDI  R27,HIGH(_EEPROM_CRC_G00A)
	CALL __EEPROMWRW
; 000A 0044 }
	RET
;
;// *****************************************************************************
;// ***    CRC EEPROM   **************************************************
;// *****************************************************************************
;inline unsigned short Get_EEPROM_CRC(void)
; 000A 004A {
; 000A 004B     //  EEPROM CRC
; 000A 004C     return(Crc16_eeprom(EEPROM_CRC_START, EEPROM_CRC_SIZE));
; 000A 004D }
;
;// *****************************************************************************
;// ***     CRC EEPROM   ************************************
;// *****************************************************************************
;inline unsigned char Is_EEPROM_CRC_Correct(void)
; 000A 0053 {
_Is_EEPROM_CRC_Correct:
; 000A 0054     //  EEPROM CRC    
; 000A 0055     //   -  
; 000A 0056     if(EEPROM_CRC == Crc16_eeprom(EEPROM_CRC_START, EEPROM_CRC_SIZE)) return(TRUE);
	LDI  R26,LOW(_EEPROM_CRC_G00A)
	LDI  R27,HIGH(_EEPROM_CRC_G00A)
	CALL __EEPROMRDW
	PUSH R31
	PUSH R30
	LDI  R30,LOW(1)
	LDI  R31,HIGH(1)
	ST   -Y,R31
	ST   -Y,R30
	LDI  R30,LOW(4093)
	LDI  R31,HIGH(4093)
	ST   -Y,R31
	ST   -Y,R30
	CALL _Crc16_eeprom
	POP  R26
	POP  R27
	CP   R30,R26
	CPC  R31,R27
	BRNE _0x140004
	LDI  R30,LOW(1)
	RET
; 000A 0057     //  - 
; 000A 0058     else return(FALSE);
_0x140004:
	LDI  R30,LOW(0)
	RET
; 000A 0059 }
	RET
;
;// *****************************************************************************
;// ***      EEPROM       ********
;// *****************************************************************************
;void TX_Init(void)
; 000A 005F {
_TX_Init:
; 000A 0060     //   
; 000A 0061     unsigned char i;
; 000A 0062     //  
; 000A 0063     unsigned char eeprom * p_from;
; 000A 0064     //  
; 000A 0065     unsigned char        * p_to;
; 000A 0066 
; 000A 0067     //     
; 000A 0068     #asm("cli")
	CALL __SAVELOCR6
;	i -> R17
;	*p_from -> R18,R19
;	*p_to -> R20,R21
	cli
; 000A 0069 
; 000A 006A     //       EEPROM
; 000A 006B     p_from = (unsigned char eeprom *)&EEPROM_SETTINGS;
	__POINTWRM 18,19,_EEPROM_SETTINGS
; 000A 006C     //       SRAM
; 000A 006D     p_to   = (unsigned char *)&Settings;
	__POINTWRM 20,21,_Settings
; 000A 006E 
; 000A 006F     //     EEPROM
; 000A 0070     for(i=0; i < sizeof(TRANSMITTER_SETTINGS); i++)
	LDI  R17,LOW(0)
_0x140007:
	CPI  R17,54
	BRSH _0x140008
; 000A 0071     {
; 000A 0072         *(p_to++) = *(p_from++);
	PUSH R21
	PUSH R20
	__ADDWRN 20,21,1
	MOVW R26,R18
	__ADDWRN 18,19,1
	CALL __EEPROMRDB
	POP  R26
	POP  R27
	ST   X,R30
; 000A 0073     }
	SUBI R17,-1
	RJMP _0x140007
_0x140008:
; 000A 0074 
; 000A 0075     // /     
; 000A 0076     gfx_BackLight(Settings.BacklightFlag);
	__GETB1MN _Settings,4
	ST   -Y,R30
	CALL _gfx_BackLight
; 000A 0077 
; 000A 0078     //  
; 000A 0079     MODEL_Init(Settings.ModelNum);
	__GETB1MN _Settings,5
	ST   -Y,R30
	RCALL _MODEL_Init
; 000A 007A 
; 000A 007B     //    
; 000A 007C     #asm("sei")
	sei
	RJMP _0x206001A
; 000A 007D }
;
;// *****************************************************************************
;// ***       EEPROM   ****************************
;// *****************************************************************************
;void TX_SaveSettings(void)
; 000A 0083 {
_TX_SaveSettings:
; 000A 0084     //   
; 000A 0085     unsigned char i;
; 000A 0086     //  
; 000A 0087     unsigned char        * p_from;
; 000A 0088     //  
; 000A 0089     unsigned char eeprom * p_to;
; 000A 008A 
; 000A 008B #ifdef DEBUG
; 000A 008C     printf("TX_SaveSettings();\r");
; 000A 008D     delay_ms(1);
; 000A 008E #endif
; 000A 008F 
; 000A 0090     //     
; 000A 0091     #asm("cli")
	CALL __SAVELOCR6
;	i -> R17
;	*p_from -> R18,R19
;	*p_to -> R20,R21
	cli
; 000A 0092 
; 000A 0093     //       SRAM
; 000A 0094     p_from = (unsigned char *)&Settings;
	__POINTWRM 18,19,_Settings
; 000A 0095     //       EEPROM
; 000A 0096     p_to   = (unsigned char eeprom *)&EEPROM_SETTINGS;
	__POINTWRM 20,21,_EEPROM_SETTINGS
; 000A 0097 
; 000A 0098     //     EEPROM
; 000A 0099     for(i=0; i < sizeof(TRANSMITTER_SETTINGS); i++)
	LDI  R17,LOW(0)
_0x14000A:
	CPI  R17,54
	BRSH _0x14000B
; 000A 009A     {
; 000A 009B         *(p_to++) = *(p_from++);
	PUSH R21
	PUSH R20
	__ADDWRN 20,21,1
	MOVW R26,R18
	__ADDWRN 18,19,1
	LD   R30,X
	POP  R26
	POP  R27
	CALL __EEPROMWRB
; 000A 009C     }
	SUBI R17,-1
	RJMP _0x14000A
_0x14000B:
; 000A 009D 
; 000A 009E     //   CRC EEPROM   
; 000A 009F     Recalc_EEPROM_CRC();
	RCALL _Recalc_EEPROM_CRC_G00A
; 000A 00A0 
; 000A 00A1     //    
; 000A 00A2     #asm("sei")
	sei
_0x206001A:
; 000A 00A3 }
	CALL __LOADLOCR6
_0x206001B:
	ADIW R28,6
	RET
;
;// *****************************************************************************
;// ***       *************************************************
;// *****************************************************************************
;void TX_SetModulation(char Modulation)
; 000A 00A9 {
_TX_SetModulation:
; 000A 00AA     //         
; 000A 00AB     if(Modulation == MODUL_PPM)  TCCR1A=0x82;
;	Modulation -> Y+0
	LD   R30,Y
	CPI  R30,0
	BRNE _0x14000C
	LDI  R30,LOW(130)
	OUT  0x2F,R30
; 000A 00AC     if(Modulation == MODUL_IPPM) TCCR1A=0xC2;
_0x14000C:
	LD   R26,Y
	CPI  R26,LOW(0x1)
	BRNE _0x14000D
	LDI  R30,LOW(194)
	OUT  0x2F,R30
; 000A 00AD }
_0x14000D:
_0x2060019:
	ADIW R28,1
	RET
;
;// *****************************************************************************
;// ***      EEPROM   *******************************************
;// *****************************************************************************
;void MODEL_Init(char ModelNum)
; 000A 00B3 {
_MODEL_Init:
; 000A 00B4     //   
; 000A 00B5     int i;
; 000A 00B6     //  
; 000A 00B7     unsigned char eeprom * p_from;
; 000A 00B8     //  
; 000A 00B9     unsigned char        * p_to;
; 000A 00BA 
; 000A 00BB #ifdef DEBUG
; 000A 00BC     printf("MODEL_Init(%d);\r", ModelNum);
; 000A 00BD     delay_ms(1);
; 000A 00BE #endif
; 000A 00BF 
; 000A 00C0     //     
; 000A 00C1     #asm("cli")
	CALL __SAVELOCR6
;	ModelNum -> Y+6
;	i -> R16,R17
;	*p_from -> R18,R19
;	*p_to -> R20,R21
	cli
; 000A 00C2 
; 000A 00C3     //       EERPOM
; 000A 00C4     p_from = (unsigned char eeprom *)&EEPROM_MODEL[ModelNum];
	LDD  R30,Y+6
	LDI  R31,0
	LDI  R26,LOW(759)
	LDI  R27,HIGH(759)
	CALL __MULW12U
	SUBI R30,LOW(-_EEPROM_MODEL)
	SBCI R31,HIGH(-_EEPROM_MODEL)
	MOVW R18,R30
; 000A 00C5     //       SRAM
; 000A 00C6     p_to   = (unsigned char *)&CurModel;
	__POINTWRM 20,21,_CurModel
; 000A 00C7 
; 000A 00C8     //     EEPROM  SRAM
; 000A 00C9     for(i=0; i < sizeof(MODEL_SETTINGS); i++)
	__GETWRN 16,17,0
_0x14000F:
	__CPWRN 16,17,759
	BRGE _0x140010
; 000A 00CA     {
; 000A 00CB         *(p_to++) = *(p_from++);
	PUSH R21
	PUSH R20
	__ADDWRN 20,21,1
	MOVW R26,R18
	__ADDWRN 18,19,1
	CALL __EEPROMRDB
	POP  R26
	POP  R27
	ST   X,R30
; 000A 00CC     }
	__ADDWRN 16,17,1
	RJMP _0x14000F
_0x140010:
; 000A 00CD 
; 000A 00CE     //     
; 000A 00CF     TX_SetModulation(CurModel.modulation);
	__GETB1MN _CurModel,16
	ST   -Y,R30
	RCALL _TX_SetModulation
; 000A 00D0 
; 000A 00D1     //  
; 000A 00D2     Timer_Init();
	RCALL _Timer_Init
; 000A 00D3 
; 000A 00D4     //    
; 000A 00D5     #asm("sei")
	sei
	RJMP _0x2060018
; 000A 00D6 }
;
;// *****************************************************************************
;// ***        EEPROM   ************************
;// *****************************************************************************
;void MODEL_Save_Trimmers(void)
; 000A 00DC {
_MODEL_Save_Trimmers:
; 000A 00DD     //   
; 000A 00DE     int i, j;
; 000A 00DF 
; 000A 00E0 #ifdef DEBUG
; 000A 00E1     printf("MODEL_Save_Trimmers();\r");
; 000A 00E2     delay_ms(1);
; 000A 00E3 #endif
; 000A 00E4 
; 000A 00E5     for(i=0; i < MAX_MODES; i++)
	CALL __SAVELOCR4
;	i -> R16,R17
;	j -> R18,R19
	__GETWRN 16,17,0
_0x140012:
	__CPWRN 16,17,3
	BRGE _0x140013
; 000A 00E6     {
; 000A 00E7         for(j=0; j < MAX_TRIMMERS; j++)
	__GETWRN 18,19,0
_0x140015:
	__CPWRN 18,19,4
	BRGE _0x140016
; 000A 00E8         {
; 000A 00E9             EEPROM_MODEL[Settings.ModelNum].Mode[i].trimmers[j] = CurModel.Mode[i].trimmers[j];
	__GETB1MN _Settings,5
	LDI  R31,0
	LDI  R26,LOW(759)
	LDI  R27,HIGH(759)
	CALL __MULW12U
	__ADDW1MN _EEPROM_MODEL,21
	MOVW R26,R30
	MOVW R30,R16
	MOVW R22,R26
	LDI  R26,LOW(246)
	LDI  R27,HIGH(246)
	CALL __MULW12U
	ADD  R30,R22
	ADC  R31,R23
	SUBI R30,LOW(-242)
	SBCI R31,HIGH(-242)
	ADD  R30,R18
	ADC  R31,R19
	PUSH R31
	PUSH R30
	__POINTW2MN _CurModel,21
	MOVW R30,R16
	MOVW R22,R26
	LDI  R26,LOW(246)
	LDI  R27,HIGH(246)
	CALL __MULW12U
	ADD  R30,R22
	ADC  R31,R23
	SUBI R30,LOW(-242)
	SBCI R31,HIGH(-242)
	ADD  R30,R18
	ADC  R31,R19
	LD   R30,Z
	POP  R26
	POP  R27
	CALL __EEPROMWRB
; 000A 00EA         }
	__ADDWRN 18,19,1
	RJMP _0x140015
_0x140016:
; 000A 00EB     }
	__ADDWRN 16,17,1
	RJMP _0x140012
_0x140013:
; 000A 00EC 
; 000A 00ED     //   CRC EEPROM   
; 000A 00EE     Recalc_EEPROM_CRC();
	RCALL _Recalc_EEPROM_CRC_G00A
; 000A 00EF }
	CALL __LOADLOCR4
	ADIW R28,4
	RET
;
;
;// *****************************************************************************
;// ***      EEPROM   ******************************************
;// *****************************************************************************
;void MODEL_Save(char To)
; 000A 00F6 {
_MODEL_Save:
; 000A 00F7     //   
; 000A 00F8     int i;
; 000A 00F9     //  
; 000A 00FA     unsigned char        * p_from;
; 000A 00FB     //  
; 000A 00FC     unsigned char eeprom * p_to;
; 000A 00FD 
; 000A 00FE #ifdef DEBUG
; 000A 00FF     printf("MODEL_Save(%d);\r", To);
; 000A 0100     delay_ms(1);
; 000A 0101 #endif
; 000A 0102 
; 000A 0103     //      
; 000A 0104     #asm("cli")
	CALL __SAVELOCR6
;	To -> Y+6
;	i -> R16,R17
;	*p_from -> R18,R19
;	*p_to -> R20,R21
	cli
; 000A 0105 
; 000A 0106     //        SRAM
; 000A 0107     p_from = (unsigned char *)&CurModel;
	__POINTWRM 18,19,_CurModel
; 000A 0108     //       EEPROM
; 000A 0109     p_to   = (unsigned char eeprom *)&EEPROM_MODEL[To];
	LDD  R30,Y+6
	LDI  R31,0
	LDI  R26,LOW(759)
	LDI  R27,HIGH(759)
	CALL __MULW12U
	SUBI R30,LOW(-_EEPROM_MODEL)
	SBCI R31,HIGH(-_EEPROM_MODEL)
	MOVW R20,R30
; 000A 010A 
; 000A 010B     //     SRAM  EEPROM
; 000A 010C     for(i=0; i < sizeof(MODEL_SETTINGS); i++)
	__GETWRN 16,17,0
_0x140018:
	__CPWRN 16,17,759
	BRGE _0x140019
; 000A 010D     {
; 000A 010E         *(p_to++) = *(p_from++);
	PUSH R21
	PUSH R20
	__ADDWRN 20,21,1
	MOVW R26,R18
	__ADDWRN 18,19,1
	LD   R30,X
	POP  R26
	POP  R27
	CALL __EEPROMWRB
; 000A 010F     }
	__ADDWRN 16,17,1
	RJMP _0x140018
_0x140019:
; 000A 0110 
; 000A 0111     //   CRC EEPROM   
; 000A 0112     Recalc_EEPROM_CRC();
	RCALL _Recalc_EEPROM_CRC_G00A
; 000A 0113 
; 000A 0114     //    
; 000A 0115     #asm("sei")
	sei
	RJMP _0x2060018
; 000A 0116 }
;
;// *****************************************************************************
;// ***       **************************************************
;// *****************************************************************************
;void MODEL_Copy(char From, char To)
; 000A 011C {
_MODEL_Copy:
; 000A 011D     //   
; 000A 011E     int i;
; 000A 011F     //    
; 000A 0120     unsigned char eeprom * p_from, * p_to;
; 000A 0121 
; 000A 0122 #ifdef DEBUG
; 000A 0123     printf("MODEL_Copy(%d, %d);\r", From, To);
; 000A 0124     delay_ms(1);
; 000A 0125 #endif
; 000A 0126 
; 000A 0127     //      
; 000A 0128     #asm("cli")
	CALL __SAVELOCR6
;	From -> Y+7
;	To -> Y+6
;	i -> R16,R17
;	*p_from -> R18,R19
;	*p_to -> R20,R21
	cli
; 000A 0129 
; 000A 012A     //       EEPROM
; 000A 012B     p_from = (unsigned char eeprom *)&EEPROM_MODEL[From];
	LDD  R30,Y+7
	LDI  R31,0
	LDI  R26,LOW(759)
	LDI  R27,HIGH(759)
	CALL __MULW12U
	SUBI R30,LOW(-_EEPROM_MODEL)
	SBCI R31,HIGH(-_EEPROM_MODEL)
	MOVW R18,R30
; 000A 012C     //       EEPROM
; 000A 012D     p_to   = (unsigned char eeprom *)&EEPROM_MODEL[To];
	LDD  R30,Y+6
	LDI  R31,0
	LDI  R26,LOW(759)
	LDI  R27,HIGH(759)
	CALL __MULW12U
	SUBI R30,LOW(-_EEPROM_MODEL)
	SBCI R31,HIGH(-_EEPROM_MODEL)
	MOVW R20,R30
; 000A 012E 
; 000A 012F     //   
; 000A 0130     for(i=0; i < sizeof(MODEL_SETTINGS); i++)
	__GETWRN 16,17,0
_0x14001B:
	__CPWRN 16,17,759
	BRGE _0x14001C
; 000A 0131     {
; 000A 0132         *(p_to++) = *(p_from++);
	PUSH R21
	PUSH R20
	__ADDWRN 20,21,1
	MOVW R26,R18
	__ADDWRN 18,19,1
	CALL __EEPROMRDB
	POP  R26
	POP  R27
	CALL __EEPROMWRB
; 000A 0133     }
	__ADDWRN 16,17,1
	RJMP _0x14001B
_0x14001C:
; 000A 0134 
; 000A 0135     //   CRC EEPROM   
; 000A 0136     Recalc_EEPROM_CRC();
	RCALL _Recalc_EEPROM_CRC_G00A
; 000A 0137 
; 000A 0138     //    
; 000A 0139     #asm("sei")
	sei
; 000A 013A }
	CALL __LOADLOCR6
	ADIW R28,8
	RET
;
;// *****************************************************************************
;// ***        ****************************************
;// *****************************************************************************
;void MODE_Copy(char From, char To)
; 000A 0140 {
_MODE_Copy:
; 000A 0141     //   
; 000A 0142     int i;
; 000A 0143     //    ( 12  + -)
; 000A 0144     char Name[MODE_NAME_LEN];
; 000A 0145     //    
; 000A 0146     unsigned char eeprom * p_from, * p_to;
; 000A 0147 
; 000A 0148 #ifdef DEBUG
; 000A 0149     printf("MODE_copy(%d, %d);\r", From, To);
; 000A 014A     delay_ms(1);
; 000A 014B #endif
; 000A 014C 
; 000A 014D     //       
; 000A 014E     #asm("cli")
	SBIW R28,11
	CALL __SAVELOCR6
;	From -> Y+18
;	To -> Y+17
;	i -> R16,R17
;	Name -> Y+6
;	*p_from -> R18,R19
;	*p_to -> R20,R21
	cli
; 000A 014F 
; 000A 0150     //      
; 000A 0151     for(i=0; i < MODE_NAME_LEN; i++)
	__GETWRN 16,17,0
_0x14001E:
	__CPWRN 16,17,11
	BRGE _0x14001F
; 000A 0152     {
; 000A 0153         Name[i] = EEPROM_MODEL[Settings.ModelNum].Mode[To].name[i];
	MOVW R30,R16
	MOVW R26,R28
	ADIW R26,6
	ADD  R30,R26
	ADC  R31,R27
	PUSH R31
	PUSH R30
	__GETB1MN _Settings,5
	LDI  R31,0
	LDI  R26,LOW(759)
	LDI  R27,HIGH(759)
	CALL __MULW12U
	__ADDW1MN _EEPROM_MODEL,21
	MOVW R26,R30
	LDD  R30,Y+17
	LDI  R31,0
	MOVW R22,R26
	LDI  R26,LOW(246)
	LDI  R27,HIGH(246)
	CALL __MULW12U
	ADD  R30,R22
	ADC  R31,R23
	ADD  R30,R16
	ADC  R31,R17
	MOVW R26,R30
	CALL __EEPROMRDB
	POP  R26
	POP  R27
	ST   X,R30
; 000A 0154     }
	__ADDWRN 16,17,1
	RJMP _0x14001E
_0x14001F:
; 000A 0155 
; 000A 0156     //        EEPROM
; 000A 0157     p_from = (unsigned char eeprom *)&EEPROM_MODEL[Settings.ModelNum].Mode[From];
	__GETB1MN _Settings,5
	LDI  R31,0
	LDI  R26,LOW(759)
	LDI  R27,HIGH(759)
	CALL __MULW12U
	__ADDW1MN _EEPROM_MODEL,21
	MOVW R26,R30
	LDD  R30,Y+18
	LDI  R31,0
	MOVW R22,R26
	LDI  R26,LOW(246)
	LDI  R27,HIGH(246)
	CALL __MULW12U
	ADD  R30,R22
	ADC  R31,R23
	MOVW R18,R30
; 000A 0158     //        EEPROM
; 000A 0159     p_to   = (unsigned char eeprom *)&EEPROM_MODEL[Settings.ModelNum].Mode[To];
	__GETB1MN _Settings,5
	LDI  R31,0
	LDI  R26,LOW(759)
	LDI  R27,HIGH(759)
	CALL __MULW12U
	__ADDW1MN _EEPROM_MODEL,21
	MOVW R26,R30
	LDD  R30,Y+17
	LDI  R31,0
	MOVW R22,R26
	LDI  R26,LOW(246)
	LDI  R27,HIGH(246)
	CALL __MULW12U
	ADD  R30,R22
	ADC  R31,R23
	MOVW R20,R30
; 000A 015A 
; 000A 015B     //    
; 000A 015C     for(i=0; i < sizeof(DEF_MODE); i++)
	__GETWRN 16,17,0
_0x140021:
	__CPWRN 16,17,246
	BRGE _0x140022
; 000A 015D     {
; 000A 015E         *(p_to++) = *(p_from++);
	PUSH R21
	PUSH R20
	__ADDWRN 20,21,1
	MOVW R26,R18
	__ADDWRN 18,19,1
	CALL __EEPROMRDB
	POP  R26
	POP  R27
	CALL __EEPROMWRB
; 000A 015F     }
	__ADDWRN 16,17,1
	RJMP _0x140021
_0x140022:
; 000A 0160 
; 000A 0161     //      
; 000A 0162     for(i=0; i < MODE_NAME_LEN; i++)
	__GETWRN 16,17,0
_0x140024:
	__CPWRN 16,17,11
	BRGE _0x140025
; 000A 0163     {
; 000A 0164         EEPROM_MODEL[Settings.ModelNum].Mode[To].name[i] = Name[i];
	__GETB1MN _Settings,5
	LDI  R31,0
	LDI  R26,LOW(759)
	LDI  R27,HIGH(759)
	CALL __MULW12U
	__ADDW1MN _EEPROM_MODEL,21
	MOVW R26,R30
	LDD  R30,Y+17
	LDI  R31,0
	MOVW R22,R26
	LDI  R26,LOW(246)
	LDI  R27,HIGH(246)
	CALL __MULW12U
	ADD  R30,R22
	ADC  R31,R23
	ADD  R30,R16
	ADC  R31,R17
	MOVW R0,R30
	MOVW R26,R28
	ADIW R26,6
	ADD  R26,R16
	ADC  R27,R17
	LD   R30,X
	MOVW R26,R0
	CALL __EEPROMWRB
; 000A 0165     }
	__ADDWRN 16,17,1
	RJMP _0x140024
_0x140025:
; 000A 0166 
; 000A 0167     //   CRC EEPROM   
; 000A 0168     Recalc_EEPROM_CRC();
	RCALL _Recalc_EEPROM_CRC_G00A
; 000A 0169 
; 000A 016A     //    
; 000A 016B     #asm("sei")
	sei
; 000A 016C }
	CALL __LOADLOCR6
	ADIW R28,19
	RET
;
;// *****************************************************************************
;// ***          *********************************
;// *****************************************************************************
;void MODEL_Reset(char ModelNum)
; 000A 0172 {
_MODEL_Reset:
; 000A 0173     //   
; 000A 0174     unsigned char i;
; 000A 0175     unsigned char len;
; 000A 0176     unsigned char MOD, CH, CTRL;
; 000A 0177 
; 000A 0178 #ifdef DEBUG
; 000A 0179     printf("MODEL_Reset(%d);\r", ModelNum);
; 000A 017A     delay_ms(1);
; 000A 017B #endif
; 000A 017C 
; 000A 017D     //      
; 000A 017E     #asm("cli")
	CALL __SAVELOCR6
;	ModelNum -> Y+6
;	i -> R17
;	len -> R16
;	MOD -> R19
;	CH -> R18
;	CTRL -> R21
	cli
; 000A 017F 
; 000A 0180         for(MOD=0; MOD < MAX_MODES; MOD++)
	LDI  R19,LOW(0)
_0x140027:
	CPI  R19,3
	BRLO PC+3
	JMP _0x140028
; 000A 0181         {
; 000A 0182             for(CTRL=0; CTRL < MAX_CONTROLS; CTRL++)
	LDI  R21,LOW(0)
_0x14002A:
	CPI  R21,11
	BRLO PC+3
	JMP _0x14002B
; 000A 0183                 {
; 000A 0184                     //  1 -  
; 000A 0185                     EEPROM_MODEL[ModelNum].Mode[MOD].Control[CTRL].reverse = 1;
	LDD  R30,Y+6
	LDI  R31,0
	LDI  R26,LOW(759)
	LDI  R27,HIGH(759)
	CALL __MULW12U
	__ADDW1MN _EEPROM_MODEL,21
	MOVW R26,R30
	MOV  R30,R19
	LDI  R31,0
	MOVW R22,R26
	LDI  R26,LOW(246)
	LDI  R27,HIGH(246)
	CALL __MULW12U
	MOVW R26,R22
	ADD  R26,R30
	ADC  R27,R31
	ADIW R26,11
	MOV  R30,R21
	LDI  R31,0
	MOVW R22,R26
	LDI  R26,LOW(13)
	LDI  R27,HIGH(13)
	CALL __MULW12U
	MOVW R26,R22
	ADD  R26,R30
	ADC  R27,R31
	LDI  R30,LOW(1)
	CALL __EEPROMWRB
; 000A 0186 
; 000A 0187                     //  
; 000A 0188                     EEPROM_MODEL[ModelNum].Mode[MOD].Control[CTRL].maxRates = 100;
	LDD  R30,Y+6
	LDI  R31,0
	LDI  R26,LOW(759)
	LDI  R27,HIGH(759)
	CALL __MULW12U
	__ADDW1MN _EEPROM_MODEL,21
	MOVW R26,R30
	MOV  R30,R19
	LDI  R31,0
	MOVW R22,R26
	LDI  R26,LOW(246)
	LDI  R27,HIGH(246)
	CALL __MULW12U
	MOVW R26,R22
	ADD  R26,R30
	ADC  R27,R31
	ADIW R26,11
	MOV  R30,R21
	LDI  R31,0
	MOVW R22,R26
	LDI  R26,LOW(13)
	LDI  R27,HIGH(13)
	CALL __MULW12U
	MOVW R26,R22
	ADD  R26,R30
	ADC  R27,R31
	ADIW R26,1
	LDI  R30,LOW(100)
	CALL __EEPROMWRB
; 000A 0189                     EEPROM_MODEL[ModelNum].Mode[MOD].Control[CTRL].minRates = 100;  // EPA val in 2% unit
	LDD  R30,Y+6
	LDI  R31,0
	LDI  R26,LOW(759)
	LDI  R27,HIGH(759)
	CALL __MULW12U
	__ADDW1MN _EEPROM_MODEL,21
	MOVW R26,R30
	MOV  R30,R19
	LDI  R31,0
	MOVW R22,R26
	LDI  R26,LOW(246)
	LDI  R27,HIGH(246)
	CALL __MULW12U
	MOVW R26,R22
	ADD  R26,R30
	ADC  R27,R31
	ADIW R26,11
	MOV  R30,R21
	LDI  R31,0
	MOVW R22,R26
	LDI  R26,LOW(13)
	LDI  R27,HIGH(13)
	CALL __MULW12U
	MOVW R26,R22
	ADD  R26,R30
	ADC  R27,R31
	ADIW R26,2
	LDI  R30,LOW(100)
	CALL __EEPROMWRB
; 000A 018A 
; 000A 018B                     //   
; 000A 018C                     EEPROM_MODEL[ModelNum].Mode[MOD].Control[CTRL].maxDRates = 100; // EPA val in 2% unit
	LDD  R30,Y+6
	LDI  R31,0
	LDI  R26,LOW(759)
	LDI  R27,HIGH(759)
	CALL __MULW12U
	__ADDW1MN _EEPROM_MODEL,21
	MOVW R26,R30
	MOV  R30,R19
	LDI  R31,0
	MOVW R22,R26
	LDI  R26,LOW(246)
	LDI  R27,HIGH(246)
	CALL __MULW12U
	MOVW R26,R22
	ADD  R26,R30
	ADC  R27,R31
	ADIW R26,11
	MOV  R30,R21
	LDI  R31,0
	MOVW R22,R26
	LDI  R26,LOW(13)
	LDI  R27,HIGH(13)
	CALL __MULW12U
	MOVW R26,R22
	ADD  R26,R30
	ADC  R27,R31
	ADIW R26,3
	LDI  R30,LOW(100)
	CALL __EEPROMWRB
; 000A 018D                     EEPROM_MODEL[ModelNum].Mode[MOD].Control[CTRL].minDRates = 100;
	LDD  R30,Y+6
	LDI  R31,0
	LDI  R26,LOW(759)
	LDI  R27,HIGH(759)
	CALL __MULW12U
	__ADDW1MN _EEPROM_MODEL,21
	MOVW R26,R30
	MOV  R30,R19
	LDI  R31,0
	MOVW R22,R26
	LDI  R26,LOW(246)
	LDI  R27,HIGH(246)
	CALL __MULW12U
	MOVW R26,R22
	ADD  R26,R30
	ADC  R27,R31
	ADIW R26,11
	MOV  R30,R21
	LDI  R31,0
	MOVW R22,R26
	LDI  R26,LOW(13)
	LDI  R27,HIGH(13)
	CALL __MULW12U
	MOVW R26,R22
	ADD  R26,R30
	ADC  R27,R31
	ADIW R26,4
	LDI  R30,LOW(100)
	CALL __EEPROMWRB
; 000A 018E 
; 000A 018F                     //  
; 000A 0190                     for(i=0; i < CURVE_NODES; i++)
	LDI  R17,LOW(0)
_0x14002D:
	CPI  R17,7
	BRSH _0x14002E
; 000A 0191                     {
; 000A 0192                         EEPROM_MODEL[ModelNum].Mode[MOD].Control[CTRL].nodes[i] = (200 * (int)i) / (CURVE_NODES - 1) - 100;
	LDD  R30,Y+6
	LDI  R31,0
	LDI  R26,LOW(759)
	LDI  R27,HIGH(759)
	CALL __MULW12U
	__ADDW1MN _EEPROM_MODEL,21
	MOVW R26,R30
	MOV  R30,R19
	LDI  R31,0
	MOVW R22,R26
	LDI  R26,LOW(246)
	LDI  R27,HIGH(246)
	CALL __MULW12U
	MOVW R26,R22
	ADD  R26,R30
	ADC  R27,R31
	ADIW R26,11
	MOV  R30,R21
	LDI  R31,0
	MOVW R22,R26
	LDI  R26,LOW(13)
	LDI  R27,HIGH(13)
	CALL __MULW12U
	MOVW R26,R22
	ADD  R26,R30
	ADC  R27,R31
	ADIW R26,6
	MOV  R30,R17
	LDI  R31,0
	ADD  R30,R26
	ADC  R31,R27
	MOVW R22,R30
	LDI  R26,LOW(200)
	MUL  R17,R26
	MOVW R30,R0
	MOVW R26,R30
	LDI  R30,LOW(6)
	LDI  R31,HIGH(6)
	CALL __DIVW21
	SUBI R30,LOW(100)
	SBCI R31,HIGH(100)
	MOVW R26,R22
	CALL __EEPROMWRB
; 000A 0193                     }
	SUBI R17,-1
	RJMP _0x14002D
_0x14002E:
; 000A 0194 
; 000A 0195                     //   ( )
; 000A 0196                     EEPROM_MODEL[ModelNum].Mode[MOD].Control[CTRL].from = CTRL;
	LDD  R30,Y+6
	LDI  R31,0
	LDI  R26,LOW(759)
	LDI  R27,HIGH(759)
	CALL __MULW12U
	__ADDW1MN _EEPROM_MODEL,21
	MOVW R26,R30
	MOV  R30,R19
	LDI  R31,0
	MOVW R22,R26
	LDI  R26,LOW(246)
	LDI  R27,HIGH(246)
	CALL __MULW12U
	MOVW R26,R22
	ADD  R26,R30
	ADC  R27,R31
	ADIW R26,11
	MOV  R30,R21
	LDI  R31,0
	MOVW R22,R26
	LDI  R26,LOW(13)
	LDI  R27,HIGH(13)
	CALL __MULW12U
	MOVW R26,R22
	ADD  R26,R30
	ADC  R27,R31
	ADIW R26,5
	MOV  R30,R21
	CALL __EEPROMWRB
; 000A 0197                 }
	SUBI R21,-1
	RJMP _0x14002A
_0x14002B:
; 000A 0198 
; 000A 0199             //  
; 000A 019A             for(CH=0; CH < MAX_CHANNELS; CH++)
	LDI  R18,LOW(0)
_0x140030:
	CPI  R18,8
	BRSH _0x140031
; 000A 019B                 for(CTRL=0; CTRL < MAX_CONTROLS; CTRL++)
	LDI  R21,LOW(0)
_0x140033:
	CPI  R21,11
	BRSH _0x140034
; 000A 019C                     EEPROM_MODEL[ModelNum].Mode[MOD].Chanels[CH][CTRL] = 0;
	LDD  R30,Y+6
	LDI  R31,0
	LDI  R26,LOW(759)
	LDI  R27,HIGH(759)
	CALL __MULW12U
	__ADDW1MN _EEPROM_MODEL,21
	MOVW R26,R30
	MOV  R30,R19
	LDI  R31,0
	MOVW R22,R26
	LDI  R26,LOW(246)
	LDI  R27,HIGH(246)
	CALL __MULW12U
	MOVW R26,R22
	ADD  R26,R30
	ADC  R27,R31
	SUBI R26,LOW(-154)
	SBCI R27,HIGH(-154)
	MOV  R30,R18
	LDI  R31,0
	MOVW R22,R26
	LDI  R26,LOW(11)
	LDI  R27,HIGH(11)
	CALL __MULW12U
	MOVW R26,R22
	ADD  R26,R30
	ADC  R27,R31
	CLR  R30
	ADD  R26,R21
	ADC  R27,R30
	CALL __EEPROMWRB
	SUBI R21,-1
	RJMP _0x140033
_0x140034:
; 000A 019F for(CH=0; CH < MAX_CHANNELS; CH++) EEPROM_MODEL[ModelNum].Mode[MOD].Chanels[CH][CH] = 100;
	SUBI R18,-1
	RJMP _0x140030
_0x140031:
	LDI  R18,LOW(0)
_0x140036:
	CPI  R18,8
	BRSH _0x140037
	LDD  R30,Y+6
	LDI  R31,0
	LDI  R26,LOW(759)
	LDI  R27,HIGH(759)
	CALL __MULW12U
	__ADDW1MN _EEPROM_MODEL,21
	MOVW R26,R30
	MOV  R30,R19
	LDI  R31,0
	MOVW R22,R26
	LDI  R26,LOW(246)
	LDI  R27,HIGH(246)
	CALL __MULW12U
	MOVW R26,R22
	ADD  R26,R30
	ADC  R27,R31
	SUBI R26,LOW(-154)
	SBCI R27,HIGH(-154)
	MOV  R30,R18
	LDI  R31,0
	MOVW R22,R26
	LDI  R26,LOW(11)
	LDI  R27,HIGH(11)
	CALL __MULW12U
	MOVW R26,R22
	ADD  R26,R30
	ADC  R27,R31
	CLR  R30
	ADD  R26,R18
	ADC  R27,R30
	LDI  R30,LOW(100)
	CALL __EEPROMWRB
	SUBI R18,-1
	RJMP _0x140036
_0x140037:
; 000A 01A2 for(i=0; i < 4; i++) EEPROM_MODEL[ModelNum].Mode[MOD].trimmers[i] = 0;
	LDI  R17,LOW(0)
_0x140039:
	CPI  R17,4
	BRSH _0x14003A
	LDD  R30,Y+6
	LDI  R31,0
	LDI  R26,LOW(759)
	LDI  R27,HIGH(759)
	CALL __MULW12U
	__ADDW1MN _EEPROM_MODEL,21
	MOVW R26,R30
	MOV  R30,R19
	LDI  R31,0
	MOVW R22,R26
	LDI  R26,LOW(246)
	LDI  R27,HIGH(246)
	CALL __MULW12U
	MOVW R26,R22
	ADD  R26,R30
	ADC  R27,R31
	SUBI R26,LOW(-242)
	SBCI R27,HIGH(-242)
	CLR  R30
	ADD  R26,R17
	ADC  R27,R30
	CALL __EEPROMWRB
	SUBI R17,-1
	RJMP _0x140039
_0x14003A:
; 000A 01A5 for(i=0; i < (10 + 1); i++)
	LDI  R17,LOW(0)
_0x14003C:
	CPI  R17,11
	BRLO PC+3
	JMP _0x14003D
; 000A 01A6             {
; 000A 01A7                 EEPROM_MODEL[ModelNum].Mode[MOD].name[i] = DefModeNames[MOD][i];
	LDD  R30,Y+6
	LDI  R31,0
	LDI  R26,LOW(759)
	LDI  R27,HIGH(759)
	CALL __MULW12U
	__ADDW1MN _EEPROM_MODEL,21
	MOVW R26,R30
	MOV  R30,R19
	LDI  R31,0
	MOVW R22,R26
	LDI  R26,LOW(246)
	LDI  R27,HIGH(246)
	CALL __MULW12U
	MOVW R26,R22
	ADD  R26,R30
	ADC  R27,R31
	MOV  R30,R17
	LDI  R31,0
	ADD  R30,R26
	ADC  R31,R27
	MOVW R0,R30
	MOV  R30,R19
	LDI  R26,LOW(_DefModeNames_G00A)
	LDI  R27,HIGH(_DefModeNames_G00A)
	LDI  R31,0
	LSL  R30
	ROL  R31
	ADD  R26,R30
	ADC  R27,R31
	CALL __GETW1P
	MOVW R26,R30
	MOV  R30,R17
	LDI  R31,0
	ADD  R30,R26
	ADC  R31,R27
	LPM  R30,Z
	MOVW R26,R0
	CALL __EEPROMWRB
; 000A 01A8                 if(DefModeNames[MOD][i] == 0x00) break;
	MOV  R30,R19
	LDI  R26,LOW(_DefModeNames_G00A)
	LDI  R27,HIGH(_DefModeNames_G00A)
	LDI  R31,0
	LSL  R30
	ROL  R31
	ADD  R26,R30
	ADC  R27,R31
	CALL __GETW1P
	MOVW R26,R30
	MOV  R30,R17
	LDI  R31,0
	ADD  R30,R26
	ADC  R31,R27
	LPM  R30,Z
	CPI  R30,0
	BREQ _0x14003D
; 000A 01A9             }
	SUBI R17,-1
	RJMP _0x14003C
_0x14003D:
; 000A 01AA             //       
; 000A 01AB             for(; i < MODE_NAME_LEN; i++) EEPROM_MODEL[ModelNum].Mode[MOD].name[i] = 0x00;
_0x140040:
	CPI  R17,11
	BRSH _0x140041
	LDD  R30,Y+6
	LDI  R31,0
	LDI  R26,LOW(759)
	LDI  R27,HIGH(759)
	CALL __MULW12U
	__ADDW1MN _EEPROM_MODEL,21
	MOVW R26,R30
	MOV  R30,R19
	LDI  R31,0
	MOVW R22,R26
	LDI  R26,LOW(246)
	LDI  R27,HIGH(246)
	CALL __MULW12U
	MOVW R26,R22
	ADD  R26,R30
	ADC  R27,R31
	CLR  R30
	ADD  R26,R17
	ADC  R27,R30
	CALL __EEPROMWRB
	SUBI R17,-1
	RJMP _0x140040
_0x140041:
; 000A 01AC }
	SUBI R19,-1
	RJMP _0x140027
_0x140028:
; 000A 01AD 
; 000A 01AE         //  
; 000A 01AF         sprintf(tmpBuf, "Model %d", ModelNum + 1);
	LDI  R30,LOW(_tmpBuf)
	LDI  R31,HIGH(_tmpBuf)
	ST   -Y,R31
	ST   -Y,R30
	__POINTW1FN _0x140000,24
	ST   -Y,R31
	ST   -Y,R30
	LDD  R30,Y+10
	SUBI R30,-LOW(1)
	CALL __CBD1
	CALL __PUTPARD1
	LDI  R24,4
	CALL _sprintf
	ADIW R28,8
; 000A 01B0         len = (unsigned char)strlen(tmpBuf);
	LDI  R30,LOW(_tmpBuf)
	LDI  R31,HIGH(_tmpBuf)
	ST   -Y,R31
	ST   -Y,R30
	CALL _strlen
	MOV  R16,R30
; 000A 01B1         if(len > NumberOf(EEPROM_MODEL[ModelNum].name) - 1) len = NumberOf(EEPROM_MODEL[ModelNum].name) - 1;
	CPI  R16,13
	BRLO _0x140042
	LDI  R16,LOW(12)
; 000A 01B2         for(i=0; i < len; i++) EEPROM_MODEL[ModelNum].name[i] = tmpBuf[i];
_0x140042:
	LDI  R17,LOW(0)
_0x140044:
	CP   R17,R16
	BRSH _0x140045
	LDD  R30,Y+6
	LDI  R31,0
	LDI  R26,LOW(759)
	LDI  R27,HIGH(759)
	CALL __MULW12U
	__ADDW1MN _EEPROM_MODEL,2
	MOVW R26,R30
	CLR  R30
	ADD  R26,R17
	ADC  R27,R30
	MOV  R30,R17
	LDI  R31,0
	SUBI R30,LOW(-_tmpBuf)
	SBCI R31,HIGH(-_tmpBuf)
	LD   R30,Z
	CALL __EEPROMWRB
	SUBI R17,-1
	RJMP _0x140044
_0x140045:
; 000A 01B3 for(; i < (sizeof(EEPROM_MODEL[ModelNum].name)/sizeof(EEPROM_MODEL[ModelNum].name[0])); i++) EEPROM_MODEL[ModelNum].name[i] = 0;
_0x140047:
	CPI  R17,13
	BRSH _0x140048
	LDD  R30,Y+6
	LDI  R31,0
	LDI  R26,LOW(759)
	LDI  R27,HIGH(759)
	CALL __MULW12U
	__ADDW1MN _EEPROM_MODEL,2
	MOVW R26,R30
	CLR  R30
	ADD  R26,R17
	ADC  R27,R30
	CALL __EEPROMWRB
	SUBI R17,-1
	RJMP _0x140047
_0x140048:
; 000A 01B6 EEPROM_MODEL[ModelNum].modulation = MODUL_PPM;
	LDD  R30,Y+6
	LDI  R31,0
	LDI  R26,LOW(759)
	LDI  R27,HIGH(759)
	CALL __MULW12U
	__ADDW1MN _EEPROM_MODEL,16
	MOVW R26,R30
	LDI  R30,LOW(0)
	CALL __EEPROMWRB
; 000A 01B7 
; 000A 01B8         //   
; 000A 01B9         EEPROM_MODEL[ModelNum].type = TYPE_PLANE;
	LDD  R30,Y+6
	LDI  R31,0
	LDI  R26,LOW(759)
	LDI  R27,HIGH(759)
	CALL __MULW12U
	__ADDW1MN _EEPROM_MODEL,15
	MOVW R26,R30
	LDI  R30,LOW(0)
	CALL __EEPROMWRB
; 000A 01BA 
; 000A 01BB         //   
; 000A 01BC         EEPROM_MODEL[ModelNum].timer = 0;
	LDD  R30,Y+6
	LDI  R31,0
	LDI  R26,LOW(759)
	LDI  R27,HIGH(759)
	CALL __MULW12U
	__ADDW1MN _EEPROM_MODEL,17
	MOVW R26,R30
	LDI  R30,LOW(0)
	LDI  R31,HIGH(0)
	CALL __EEPROMWRW
; 000A 01BD         EEPROM_MODEL[ModelNum].timer_mode = 0;
	LDD  R30,Y+6
	LDI  R31,0
	LDI  R26,LOW(759)
	LDI  R27,HIGH(759)
	CALL __MULW12U
	__ADDW1MN _EEPROM_MODEL,19
	MOVW R26,R30
	LDI  R30,LOW(0)
	CALL __EEPROMWRB
; 000A 01BE 
; 000A 01BF         //   
; 000A 01C0         EEPROM_MODEL[ModelNum].num_ch = 6;
	LDD  R30,Y+6
	LDI  R31,0
	LDI  R26,LOW(759)
	LDI  R27,HIGH(759)
	CALL __MULW12U
	__ADDW1MN _EEPROM_MODEL,20
	MOVW R26,R30
	LDI  R30,LOW(6)
	CALL __EEPROMWRB
; 000A 01C1 
; 000A 01C2         //   
; 000A 01C3         EEPROM_MODEL[ModelNum].size = sizeof(EEPROM_MODEL[ModelNum]);
	LDD  R30,Y+6
	LDI  R31,0
	LDI  R26,LOW(759)
	LDI  R27,HIGH(759)
	CALL __MULW12U
	SUBI R30,LOW(-_EEPROM_MODEL)
	SBCI R31,HIGH(-_EEPROM_MODEL)
	MOVW R26,R30
	LDI  R30,LOW(759)
	LDI  R31,HIGH(759)
	CALL __EEPROMWRW
; 000A 01C4 
; 000A 01C5         //   CRC EEPROM   
; 000A 01C6         Recalc_EEPROM_CRC();
	CALL _Recalc_EEPROM_CRC_G00A
; 000A 01C7 
; 000A 01C8     //    
; 000A 01C9     #asm("sei")
	sei
_0x2060018:
; 000A 01CA }
	CALL __LOADLOCR6
	ADIW R28,7
	RET
;
;// *****************************************************************************
;// ***      **********************************************************
;// *****************************************************************************
;void Calibration(void)
; 000A 01D0 {
_Calibration:
; 000A 01D1     unsigned char i, x, y;
; 000A 01D2 
; 000A 01D3 #ifdef DEBUG
; 000A 01D4     printf("Calibration();\r");
; 000A 01D5     delay_ms(1);
; 000A 01D6 #endif
; 000A 01D7 
; 000A 01D8     //     
; 000A 01D9     #asm("cli")
	CALL __SAVELOCR4
;	i -> R17
;	x -> R16
;	y -> R19
	cli
; 000A 01DA 
; 000A 01DB     for(i=0; i < MAX_ADC; i++)
	LDI  R17,LOW(0)
_0x14004A:
	CPI  R17,8
	BRLO PC+3
	JMP _0x14004B
; 000A 01DC     {
; 000A 01DD         AD[i]    = read_adc(i);
	MOV  R30,R17
	LDI  R26,LOW(_AD)
	LDI  R27,HIGH(_AD)
	LDI  R31,0
	LSL  R30
	ROL  R31
	ADD  R30,R26
	ADC  R31,R27
	PUSH R31
	PUSH R30
	ST   -Y,R17
	CALL _read_adc
	POP  R26
	POP  R27
	ST   X+,R30
	ST   X,R31
; 000A 01DE         ADmin[i] = AD[i];
	MOV  R30,R17
	LDI  R26,LOW(_ADmin)
	LDI  R27,HIGH(_ADmin)
	LDI  R31,0
	LSL  R30
	ROL  R31
	ADD  R30,R26
	ADC  R31,R27
	MOVW R0,R30
	MOV  R30,R17
	LDI  R26,LOW(_AD)
	LDI  R27,HIGH(_AD)
	LDI  R31,0
	LSL  R30
	ROL  R31
	ADD  R26,R30
	ADC  R27,R31
	CALL __GETW1P
	MOVW R26,R0
	ST   X+,R30
	ST   X,R31
; 000A 01DF         ADmax[i] = AD[i];
	MOV  R30,R17
	LDI  R26,LOW(_ADmax)
	LDI  R27,HIGH(_ADmax)
	LDI  R31,0
	LSL  R30
	ROL  R31
	ADD  R30,R26
	ADC  R31,R27
	MOVW R0,R30
	MOV  R30,R17
	LDI  R26,LOW(_AD)
	LDI  R27,HIGH(_AD)
	LDI  R31,0
	LSL  R30
	ROL  R31
	ADD  R26,R30
	ADC  R27,R31
	CALL __GETW1P
	MOVW R26,R0
	ST   X+,R30
	ST   X,R31
; 000A 01E0     }
	SUBI R17,-1
	RJMP _0x14004A
_0x14004B:
; 000A 01E1 
; 000A 01E2     gfx_ClearBuf();
	CALL _gfx_ClearBuf
; 000A 01E3     gfx_SetXY((WidthS - 11*Font_8x12.W) >> 1, (HeightS - 1*Font_8x12.H) >> 1);
	LDS  R30,_Font_8x12
	LDI  R26,LOW(11)
	MUL  R30,R26
	MOVW R30,R0
	LDI  R26,LOW(128)
	SUB  R26,R30
	MOV  R30,R26
	LSR  R30
	ST   -Y,R30
	__GETB1MN _Font_8x12,1
	LDI  R26,LOW(64)
	SUB  R26,R30
	MOV  R30,R26
	LSR  R30
	ST   -Y,R30
	CALL _gfx_SetXY
; 000A 01E4     gfx_PutFlashStr("Calibrating", 0xFF, &Font_8x12);
	__POINTW1FN _0x140000,33
	ST   -Y,R31
	ST   -Y,R30
	LDI  R30,LOW(255)
	ST   -Y,R30
	LDI  R30,LOW(_Font_8x12)
	LDI  R31,HIGH(_Font_8x12)
	ST   -Y,R31
	ST   -Y,R30
	CALL _gfx_PutFlashStr
; 000A 01E5     gfx_Refresh();
	CALL _gfx_Refresh
; 000A 01E6     delay_ms(1000);
	LDI  R30,LOW(1000)
	LDI  R31,HIGH(1000)
	ST   -Y,R31
	ST   -Y,R30
	CALL _delay_ms
; 000A 01E7 
; 000A 01E8     while(!HB_ENTER)
_0x14004C:
	SBIS 0x10,5
	RJMP _0x14004E
; 000A 01E9     {
; 000A 01EA         gfx_ClearBuf();
	CALL _gfx_ClearBuf
; 000A 01EB 
; 000A 01EC         for (i=0; i < MAX_ADC; i++)
	LDI  R17,LOW(0)
_0x140050:
	CPI  R17,8
	BRLO PC+3
	JMP _0x140051
; 000A 01ED         {
; 000A 01EE             AD[i] = read_adc(i);
	MOV  R30,R17
	LDI  R26,LOW(_AD)
	LDI  R27,HIGH(_AD)
	LDI  R31,0
	LSL  R30
	ROL  R31
	ADD  R30,R26
	ADC  R31,R27
	PUSH R31
	PUSH R30
	ST   -Y,R17
	CALL _read_adc
	POP  R26
	POP  R27
	ST   X+,R30
	ST   X,R31
; 000A 01EF             if(ADmin[i] > AD[i]) ADmin[i] = AD[i];
	MOV  R30,R17
	LDI  R26,LOW(_ADmin)
	LDI  R27,HIGH(_ADmin)
	LDI  R31,0
	LSL  R30
	ROL  R31
	ADD  R26,R30
	ADC  R27,R31
	LD   R0,X+
	LD   R1,X
	MOV  R30,R17
	LDI  R26,LOW(_AD)
	LDI  R27,HIGH(_AD)
	LDI  R31,0
	LSL  R30
	ROL  R31
	ADD  R26,R30
	ADC  R27,R31
	CALL __GETW1P
	CP   R30,R0
	CPC  R31,R1
	BRGE _0x140052
	MOV  R30,R17
	LDI  R26,LOW(_ADmin)
	LDI  R27,HIGH(_ADmin)
	LDI  R31,0
	LSL  R30
	ROL  R31
	ADD  R30,R26
	ADC  R31,R27
	MOVW R0,R30
	MOV  R30,R17
	LDI  R26,LOW(_AD)
	LDI  R27,HIGH(_AD)
	LDI  R31,0
	LSL  R30
	ROL  R31
	ADD  R26,R30
	ADC  R27,R31
	CALL __GETW1P
	MOVW R26,R0
	ST   X+,R30
	ST   X,R31
; 000A 01F0             if(ADmax[i] < AD[i]) ADmax[i] = AD[i];
_0x140052:
	MOV  R30,R17
	LDI  R26,LOW(_ADmax)
	LDI  R27,HIGH(_ADmax)
	LDI  R31,0
	LSL  R30
	ROL  R31
	ADD  R26,R30
	ADC  R27,R31
	LD   R0,X+
	LD   R1,X
	MOV  R30,R17
	LDI  R26,LOW(_AD)
	LDI  R27,HIGH(_AD)
	LDI  R31,0
	LSL  R30
	ROL  R31
	ADD  R26,R30
	ADC  R27,R31
	CALL __GETW1P
	CP   R0,R30
	CPC  R1,R31
	BRGE _0x140053
	MOV  R30,R17
	LDI  R26,LOW(_ADmax)
	LDI  R27,HIGH(_ADmax)
	LDI  R31,0
	LSL  R30
	ROL  R31
	ADD  R30,R26
	ADC  R31,R27
	MOVW R0,R30
	MOV  R30,R17
	LDI  R26,LOW(_AD)
	LDI  R27,HIGH(_AD)
	LDI  R31,0
	LSL  R30
	ROL  R31
	ADD  R26,R30
	ADC  R27,R31
	CALL __GETW1P
	MOVW R26,R0
	ST   X+,R30
	ST   X,R31
; 000A 01F1         }
_0x140053:
	SUBI R17,-1
	RJMP _0x140050
_0x140051:
; 000A 01F2 
; 000A 01F3         gfx_Rectangle(0, 4, 55, 59, 1);
	LDI  R30,LOW(0)
	LDI  R31,HIGH(0)
	ST   -Y,R31
	ST   -Y,R30
	LDI  R30,LOW(4)
	LDI  R31,HIGH(4)
	ST   -Y,R31
	ST   -Y,R30
	LDI  R30,LOW(55)
	LDI  R31,HIGH(55)
	ST   -Y,R31
	ST   -Y,R30
	LDI  R30,LOW(59)
	LDI  R31,HIGH(59)
	ST   -Y,R31
	ST   -Y,R30
	LDI  R30,LOW(1)
	ST   -Y,R30
	CALL _gfx_Rectangle
; 000A 01F4         gfx_Rectangle(1, 5, 54, 58, 1);
	LDI  R30,LOW(1)
	LDI  R31,HIGH(1)
	ST   -Y,R31
	ST   -Y,R30
	LDI  R30,LOW(5)
	LDI  R31,HIGH(5)
	ST   -Y,R31
	ST   -Y,R30
	LDI  R30,LOW(54)
	LDI  R31,HIGH(54)
	ST   -Y,R31
	ST   -Y,R30
	LDI  R30,LOW(58)
	LDI  R31,HIGH(58)
	ST   -Y,R31
	ST   -Y,R30
	LDI  R30,LOW(1)
	ST   -Y,R30
	CALL _gfx_Rectangle
; 000A 01F5 
; 000A 01F6         gfx_Rectangle(72, 4, 127, 59, 1);
	LDI  R30,LOW(72)
	LDI  R31,HIGH(72)
	ST   -Y,R31
	ST   -Y,R30
	LDI  R30,LOW(4)
	LDI  R31,HIGH(4)
	ST   -Y,R31
	ST   -Y,R30
	LDI  R30,LOW(127)
	LDI  R31,HIGH(127)
	ST   -Y,R31
	ST   -Y,R30
	LDI  R30,LOW(59)
	LDI  R31,HIGH(59)
	ST   -Y,R31
	ST   -Y,R30
	LDI  R30,LOW(1)
	ST   -Y,R30
	CALL _gfx_Rectangle
; 000A 01F7         gfx_Rectangle(73, 5, 126, 58, 1);
	LDI  R30,LOW(73)
	LDI  R31,HIGH(73)
	ST   -Y,R31
	ST   -Y,R30
	LDI  R30,LOW(5)
	LDI  R31,HIGH(5)
	ST   -Y,R31
	ST   -Y,R30
	LDI  R30,LOW(126)
	LDI  R31,HIGH(126)
	ST   -Y,R31
	ST   -Y,R30
	LDI  R30,LOW(58)
	LDI  R31,HIGH(58)
	ST   -Y,R31
	ST   -Y,R30
	LDI  R30,LOW(1)
	ST   -Y,R30
	CALL _gfx_Rectangle
; 000A 01F8 
; 000A 01F9         x = (unsigned char)(     (unsigned int)(AD[ADC_RUD] - ADmin[ADC_RUD]) * 52 / (ADmax[ADC_RUD] - ADmin[ADC_RUD] + 1) + 2);
	__GETW2MN _AD,12
	__GETW1MN _ADmin,12
	SUB  R26,R30
	SBC  R27,R31
	LDI  R30,LOW(52)
	LDI  R31,HIGH(52)
	CALL __MULW12U
	MOVW R0,R30
	__GETW1MN _ADmax,12
	__GETW2MN _ADmin,12
	SUB  R30,R26
	SBC  R31,R27
	ADIW R30,1
	MOVW R26,R0
	CALL __DIVW21U
	SUBI R30,-LOW(2)
	MOV  R16,R30
; 000A 01FA         y = (unsigned char)(52 - (unsigned int)(AD[ADC_THR] - ADmin[ADC_THR]) * 52 / (ADmax[ADC_THR] - ADmin[ADC_THR] + 1) + 5);
	__GETW2MN _AD,10
	__GETW1MN _ADmin,10
	SUB  R26,R30
	SBC  R27,R31
	LDI  R30,LOW(52)
	LDI  R31,HIGH(52)
	CALL __MULW12U
	MOVW R0,R30
	__GETW1MN _ADmax,10
	__GETW2MN _ADmin,10
	SUB  R30,R26
	SBC  R31,R27
	ADIW R30,1
	MOVW R26,R0
	CALL __DIVW21U
	LDI  R26,LOW(52)
	LDI  R27,HIGH(52)
	CALL __SWAPW12
	SUB  R30,R26
	SBC  R31,R27
	SUBI R30,-LOW(5)
	MOV  R19,R30
; 000A 01FB 
; 000A 01FC         gfx_PutPixel(x, y - 2, 1);
	ST   -Y,R16
	MOV  R30,R19
	SUBI R30,LOW(2)
	ST   -Y,R30
	LDI  R30,LOW(1)
	ST   -Y,R30
	CALL _gfx_PutPixel
; 000A 01FD         gfx_PutPixel(x, y + 2, 1);
	ST   -Y,R16
	MOV  R30,R19
	SUBI R30,-LOW(2)
	ST   -Y,R30
	LDI  R30,LOW(1)
	ST   -Y,R30
	CALL _gfx_PutPixel
; 000A 01FE         gfx_Line(x - 1, y - 1, x + 1, y - 1, 1);
	MOV  R30,R16
	SUBI R30,LOW(1)
	LDI  R31,0
	ST   -Y,R31
	ST   -Y,R30
	MOV  R30,R19
	SUBI R30,LOW(1)
	LDI  R31,0
	ST   -Y,R31
	ST   -Y,R30
	MOV  R30,R16
	SUBI R30,-LOW(1)
	LDI  R31,0
	ST   -Y,R31
	ST   -Y,R30
	MOV  R30,R19
	SUBI R30,LOW(1)
	LDI  R31,0
	ST   -Y,R31
	ST   -Y,R30
	LDI  R30,LOW(1)
	ST   -Y,R30
	CALL _gfx_Line
; 000A 01FF         gfx_Line(x - 2, y,     x + 2, y,     1);
	MOV  R30,R16
	SUBI R30,LOW(2)
	LDI  R31,0
	ST   -Y,R31
	ST   -Y,R30
	MOV  R30,R19
	LDI  R31,0
	ST   -Y,R31
	ST   -Y,R30
	MOV  R30,R16
	SUBI R30,-LOW(2)
	LDI  R31,0
	ST   -Y,R31
	ST   -Y,R30
	MOV  R30,R19
	LDI  R31,0
	ST   -Y,R31
	ST   -Y,R30
	LDI  R30,LOW(1)
	ST   -Y,R30
	CALL _gfx_Line
; 000A 0200         gfx_Line(x - 1, y + 1, x + 1, y + 1, 1);
	MOV  R30,R16
	SUBI R30,LOW(1)
	LDI  R31,0
	ST   -Y,R31
	ST   -Y,R30
	MOV  R30,R19
	SUBI R30,-LOW(1)
	LDI  R31,0
	ST   -Y,R31
	ST   -Y,R30
	MOV  R30,R16
	SUBI R30,-LOW(1)
	LDI  R31,0
	ST   -Y,R31
	ST   -Y,R30
	MOV  R30,R19
	SUBI R30,-LOW(1)
	LDI  R31,0
	ST   -Y,R31
	ST   -Y,R30
	LDI  R30,LOW(1)
	ST   -Y,R30
	CALL _gfx_Line
; 000A 0201 
; 000A 0202         x = (unsigned char)(     (unsigned int)(AD[ADC_AIL] - ADmin[ADC_AIL]) * 52 / (ADmax[ADC_AIL] - ADmin[ADC_AIL] + 1) + 74);
	__GETW2MN _AD,6
	__GETW1MN _ADmin,6
	SUB  R26,R30
	SBC  R27,R31
	LDI  R30,LOW(52)
	LDI  R31,HIGH(52)
	CALL __MULW12U
	MOVW R0,R30
	__GETW1MN _ADmax,6
	__GETW2MN _ADmin,6
	SUB  R30,R26
	SBC  R31,R27
	ADIW R30,1
	MOVW R26,R0
	CALL __DIVW21U
	SUBI R30,-LOW(74)
	MOV  R16,R30
; 000A 0203         y = (unsigned char)(52 - (unsigned int)(AD[ADC_ELE] - ADmin[ADC_ELE]) * 52 / (ADmax[ADC_ELE] - ADmin[ADC_ELE] + 1) +  5);
	__GETW2MN _AD,8
	__GETW1MN _ADmin,8
	SUB  R26,R30
	SBC  R27,R31
	LDI  R30,LOW(52)
	LDI  R31,HIGH(52)
	CALL __MULW12U
	MOVW R0,R30
	__GETW1MN _ADmax,8
	__GETW2MN _ADmin,8
	SUB  R30,R26
	SBC  R31,R27
	ADIW R30,1
	MOVW R26,R0
	CALL __DIVW21U
	LDI  R26,LOW(52)
	LDI  R27,HIGH(52)
	CALL __SWAPW12
	SUB  R30,R26
	SBC  R31,R27
	SUBI R30,-LOW(5)
	MOV  R19,R30
; 000A 0204 
; 000A 0205         gfx_PutPixel(x, y - 2, 1);
	ST   -Y,R16
	MOV  R30,R19
	SUBI R30,LOW(2)
	ST   -Y,R30
	LDI  R30,LOW(1)
	ST   -Y,R30
	CALL _gfx_PutPixel
; 000A 0206         gfx_PutPixel(x, y + 2, 1);
	ST   -Y,R16
	MOV  R30,R19
	SUBI R30,-LOW(2)
	ST   -Y,R30
	LDI  R30,LOW(1)
	ST   -Y,R30
	CALL _gfx_PutPixel
; 000A 0207         gfx_Line(x - 1, y - 1, x + 1, y - 1, 1);
	MOV  R30,R16
	SUBI R30,LOW(1)
	LDI  R31,0
	ST   -Y,R31
	ST   -Y,R30
	MOV  R30,R19
	SUBI R30,LOW(1)
	LDI  R31,0
	ST   -Y,R31
	ST   -Y,R30
	MOV  R30,R16
	SUBI R30,-LOW(1)
	LDI  R31,0
	ST   -Y,R31
	ST   -Y,R30
	MOV  R30,R19
	SUBI R30,LOW(1)
	LDI  R31,0
	ST   -Y,R31
	ST   -Y,R30
	LDI  R30,LOW(1)
	ST   -Y,R30
	CALL _gfx_Line
; 000A 0208         gfx_Line(x - 2, y    , x + 2, y    , 1);
	MOV  R30,R16
	SUBI R30,LOW(2)
	LDI  R31,0
	ST   -Y,R31
	ST   -Y,R30
	MOV  R30,R19
	LDI  R31,0
	ST   -Y,R31
	ST   -Y,R30
	MOV  R30,R16
	SUBI R30,-LOW(2)
	LDI  R31,0
	ST   -Y,R31
	ST   -Y,R30
	MOV  R30,R19
	LDI  R31,0
	ST   -Y,R31
	ST   -Y,R30
	LDI  R30,LOW(1)
	ST   -Y,R30
	CALL _gfx_Line
; 000A 0209         gfx_Line(x - 1, y + 1, x + 1, y + 1, 1);
	MOV  R30,R16
	SUBI R30,LOW(1)
	LDI  R31,0
	ST   -Y,R31
	ST   -Y,R30
	MOV  R30,R19
	SUBI R30,-LOW(1)
	LDI  R31,0
	ST   -Y,R31
	ST   -Y,R30
	MOV  R30,R16
	SUBI R30,-LOW(1)
	LDI  R31,0
	ST   -Y,R31
	ST   -Y,R30
	MOV  R30,R19
	SUBI R30,-LOW(1)
	LDI  R31,0
	ST   -Y,R31
	ST   -Y,R30
	LDI  R30,LOW(1)
	ST   -Y,R30
	CALL _gfx_Line
; 000A 020A 
; 000A 020B         y = 1 + (unsigned char)((unsigned int)(AD[ADC_AUX1] - ADmin[ADC_AUX1]) * 61 / (ADmax[ADC_AUX1] - ADmin[ADC_AUX1] + 1));
	__GETW2MN _AD,4
	__GETW1MN _ADmin,4
	SUB  R26,R30
	SBC  R27,R31
	LDI  R30,LOW(61)
	LDI  R31,HIGH(61)
	CALL __MULW12U
	MOVW R0,R30
	__GETW1MN _ADmax,4
	__GETW2MN _ADmin,4
	SUB  R30,R26
	SBC  R31,R27
	ADIW R30,1
	MOVW R26,R0
	CALL __DIVW21U
	LDI  R31,0
	SUBI R30,-LOW(1)
	MOV  R19,R30
; 000A 020C 
; 000A 020D         gfx_Rectangle(59, 0, 61, 63, 1);
	LDI  R30,LOW(59)
	LDI  R31,HIGH(59)
	ST   -Y,R31
	ST   -Y,R30
	LDI  R30,LOW(0)
	LDI  R31,HIGH(0)
	ST   -Y,R31
	ST   -Y,R30
	LDI  R30,LOW(61)
	LDI  R31,HIGH(61)
	ST   -Y,R31
	ST   -Y,R30
	LDI  R30,LOW(63)
	LDI  R31,HIGH(63)
	ST   -Y,R31
	ST   -Y,R30
	LDI  R30,LOW(1)
	ST   -Y,R30
	CALL _gfx_Rectangle
; 000A 020E         gfx_FillRect(58, y, 62, y + 1, 1);
	LDI  R30,LOW(58)
	LDI  R31,HIGH(58)
	ST   -Y,R31
	ST   -Y,R30
	MOV  R30,R19
	LDI  R31,0
	ST   -Y,R31
	ST   -Y,R30
	LDI  R30,LOW(62)
	LDI  R31,HIGH(62)
	ST   -Y,R31
	ST   -Y,R30
	MOV  R30,R19
	SUBI R30,-LOW(1)
	LDI  R31,0
	ST   -Y,R31
	ST   -Y,R30
	LDI  R30,LOW(1)
	ST   -Y,R30
	CALL _gfx_FillRect
; 000A 020F 
; 000A 0210         y = 1 + (unsigned char)((unsigned int)(AD[ADC_AUX2] - ADmin[ADC_AUX2]) * 61 / (ADmax[ADC_AUX2] - ADmin[ADC_AUX2] + 1));
	LDS  R26,_ADmin
	LDS  R27,_ADmin+1
	LDS  R30,_AD
	LDS  R31,_AD+1
	SUB  R30,R26
	SBC  R31,R27
	LDI  R26,LOW(61)
	LDI  R27,HIGH(61)
	CALL __MULW12U
	MOVW R0,R30
	LDS  R26,_ADmin
	LDS  R27,_ADmin+1
	LDS  R30,_ADmax
	LDS  R31,_ADmax+1
	SUB  R30,R26
	SBC  R31,R27
	ADIW R30,1
	MOVW R26,R0
	CALL __DIVW21U
	LDI  R31,0
	SUBI R30,-LOW(1)
	MOV  R19,R30
; 000A 0211 
; 000A 0212         gfx_Rectangle(66, 0, 68, 63, 1);
	LDI  R30,LOW(66)
	LDI  R31,HIGH(66)
	ST   -Y,R31
	ST   -Y,R30
	LDI  R30,LOW(0)
	LDI  R31,HIGH(0)
	ST   -Y,R31
	ST   -Y,R30
	LDI  R30,LOW(68)
	LDI  R31,HIGH(68)
	ST   -Y,R31
	ST   -Y,R30
	LDI  R30,LOW(63)
	LDI  R31,HIGH(63)
	ST   -Y,R31
	ST   -Y,R30
	LDI  R30,LOW(1)
	ST   -Y,R30
	CALL _gfx_Rectangle
; 000A 0213         gfx_FillRect(65, y, 69, y + 1, 1);
	LDI  R30,LOW(65)
	LDI  R31,HIGH(65)
	ST   -Y,R31
	ST   -Y,R30
	MOV  R30,R19
	LDI  R31,0
	ST   -Y,R31
	ST   -Y,R30
	LDI  R30,LOW(69)
	LDI  R31,HIGH(69)
	ST   -Y,R31
	ST   -Y,R30
	MOV  R30,R19
	SUBI R30,-LOW(1)
	LDI  R31,0
	ST   -Y,R31
	ST   -Y,R30
	LDI  R30,LOW(1)
	ST   -Y,R30
	CALL _gfx_FillRect
; 000A 0214 
; 000A 0215         gfx_Refresh();
	CALL _gfx_Refresh
; 000A 0216     }
	RJMP _0x14004C
_0x14004E:
; 000A 0217 
; 000A 0218     //  
; 000A 0219     gfx_ClearBuf();
	CALL _gfx_ClearBuf
; 000A 021A     //  
; 000A 021B     MsgBoxF("Center all\nsticks and\npress Enter", NULL, "Calibration", NULL);
	__POINTW1FN _0x140000,45
	ST   -Y,R31
	ST   -Y,R30
	LDI  R30,LOW(0)
	LDI  R31,HIGH(0)
	ST   -Y,R31
	ST   -Y,R30
	__POINTW1FN _0x140000,79
	ST   -Y,R31
	ST   -Y,R30
	LDI  R30,LOW(0)
	LDI  R31,HIGH(0)
	ST   -Y,R31
	ST   -Y,R30
	CALL _MsgBoxF
; 000A 021C     //           //  \
; 000A 021D     while(HB_ENTER);                 //   |      ,  
_0x140054:
	SBIS 0x10,5
	RJMP _0x140054
; 000A 021E     //         //   |      .
; 000A 021F     while(!HB_ENTER);                //  /
_0x140057:
	SBIC 0x10,5
	RJMP _0x140057
; 000A 0220 
; 000A 0221     for(i=0; i < MAX_ADC; i++)
	LDI  R17,LOW(0)
_0x14005B:
	CPI  R17,8
	BRLO PC+3
	JMP _0x14005C
; 000A 0222     {
; 000A 0223         //       
; 000A 0224         Settings.ADmid[i] = read_adc(i);
	__POINTW2MN _Settings,6
	MOV  R30,R17
	LDI  R31,0
	LSL  R30
	ROL  R31
	ADD  R30,R26
	ADC  R31,R27
	PUSH R31
	PUSH R30
	ST   -Y,R17
	CALL _read_adc
	POP  R26
	POP  R27
	ST   X+,R30
	ST   X,R31
; 000A 0225         EEPROM_SETTINGS.ADmid[i] = Settings.ADmid[i];
	__POINTW2MN _EEPROM_SETTINGS,6
	MOV  R30,R17
	LDI  R31,0
	LSL  R30
	ROL  R31
	ADD  R30,R26
	ADC  R31,R27
	MOVW R0,R30
	__POINTW2MN _Settings,6
	MOV  R30,R17
	LDI  R31,0
	LSL  R30
	ROL  R31
	ADD  R26,R30
	ADC  R27,R31
	CALL __GETW1P
	MOVW R26,R0
	CALL __EEPROMWRW
; 000A 0226         //     10,     .
; 000A 0227         //        10.
; 000A 0228         //       
; 000A 0229         //       
; 000A 022A         Settings.Kmax[i] = (TimerClockPerSec(0.0005) * 10) / (ADmax[i] - Settings.ADmid[i]); // \
	__POINTW2MN _Settings,38
	MOV  R30,R17
	LDI  R31,0
	LSL  R30
	ROL  R31
	ADD  R30,R26
	ADC  R31,R27
	MOVW R22,R30
	MOV  R30,R17
	LDI  R26,LOW(_ADmax)
	LDI  R27,HIGH(_ADmax)
	LDI  R31,0
	LSL  R30
	ROL  R31
	ADD  R26,R30
	ADC  R27,R31
	LD   R0,X+
	LD   R1,X
	__POINTW2MN _Settings,6
	MOV  R30,R17
	LDI  R31,0
	LSL  R30
	ROL  R31
	ADD  R26,R30
	ADC  R27,R31
	CALL __GETW1P
	MOVW R26,R30
	MOVW R30,R0
	SUB  R30,R26
	SBC  R31,R27
	LDI  R26,LOW(10000)
	LDI  R27,HIGH(10000)
	CALL __DIVW21
	MOVW R26,R22
	ST   X+,R30
	ST   X,R31
; 000A 022B         EEPROM_SETTINGS.Kmax[i] = Settings.Kmax[i];                                          //  |
	__POINTW2MN _EEPROM_SETTINGS,38
	MOV  R30,R17
	LDI  R31,0
	LSL  R30
	ROL  R31
	ADD  R30,R26
	ADC  R31,R27
	MOVW R0,R30
	__POINTW2MN _Settings,38
	MOV  R30,R17
	LDI  R31,0
	LSL  R30
	ROL  R31
	ADD  R26,R30
	ADC  R27,R31
	CALL __GETW1P
	MOVW R26,R0
	CALL __EEPROMWRW
; 000A 022C         //                              //  | FIX ME:    
; 000A 022D         //                              //  |         ?
; 000A 022E         Settings.Kmin[i] = (TimerClockPerSec(0.0005) * 10) / (Settings.ADmid[i] - ADmin[i]); //  |
	__POINTW2MN _Settings,22
	MOV  R30,R17
	LDI  R31,0
	LSL  R30
	ROL  R31
	ADD  R30,R26
	ADC  R31,R27
	MOVW R22,R30
	__POINTW2MN _Settings,6
	MOV  R30,R17
	LDI  R31,0
	LSL  R30
	ROL  R31
	ADD  R26,R30
	ADC  R27,R31
	LD   R0,X+
	LD   R1,X
	MOV  R30,R17
	LDI  R26,LOW(_ADmin)
	LDI  R27,HIGH(_ADmin)
	LDI  R31,0
	LSL  R30
	ROL  R31
	ADD  R26,R30
	ADC  R27,R31
	CALL __GETW1P
	MOVW R26,R30
	MOVW R30,R0
	SUB  R30,R26
	SBC  R31,R27
	LDI  R26,LOW(10000)
	LDI  R27,HIGH(10000)
	CALL __DIVW21
	MOVW R26,R22
	ST   X+,R30
	ST   X,R31
; 000A 022F         EEPROM_SETTINGS.Kmin[i] = Settings.Kmin[i];                                          // /
	__POINTW2MN _EEPROM_SETTINGS,22
	MOV  R30,R17
	LDI  R31,0
	LSL  R30
	ROL  R31
	ADD  R30,R26
	ADC  R31,R27
	MOVW R0,R30
	__POINTW2MN _Settings,22
	MOV  R30,R17
	LDI  R31,0
	LSL  R30
	ROL  R31
	ADD  R26,R30
	ADC  R27,R31
	CALL __GETW1P
	MOVW R26,R0
	CALL __EEPROMWRW
; 000A 0230     }
	SUBI R17,-1
	RJMP _0x14005B
_0x14005C:
; 000A 0231 
; 000A 0232     //   CRC EEPROM   
; 000A 0233     Recalc_EEPROM_CRC();
	CALL _Recalc_EEPROM_CRC_G00A
; 000A 0234 
; 000A 0235     //    
; 000A 0236     #asm("sei")
	sei
	RJMP _0x2060017
; 000A 0237 }
;
;// *****************************************************************************
;// ***           *******************************
;// *****************************************************************************
;void TX_Reset(void)
; 000A 023D {
_TX_Reset:
; 000A 023E     //   
; 000A 023F     int i;
; 000A 0240     int StartPos = (HeightS - Font_8x12.H)/2 - Font_8x12.H;
; 000A 0241 
; 000A 0242 #ifdef DEBUG
; 000A 0243     printf("TX_Reset();\r");
; 000A 0244     delay_ms(1);
; 000A 0245 #endif
; 000A 0246 
; 000A 0247     //         
; 000A 0248     #asm("cli")
	CALL __SAVELOCR4
;	i -> R16,R17
;	StartPos -> R18,R19
	__GETB1MN _Font_8x12,1
	LDI  R26,LOW(64)
	SUB  R26,R30
	MOV  R30,R26
	LSR  R30
	__GETB2MN _Font_8x12,1
	SUB  R30,R26
	LDI  R31,0
	MOVW R18,R30
	cli
; 000A 0249         Settings.SoundFlag = ON;
	LDI  R30,LOW(1)
	__PUTB1MN _Settings,3
; 000A 024A 
; 000A 024B         //  
; 000A 024C         gfx_ClearBuf();
	CALL _gfx_ClearBuf
; 000A 024D 
; 000A 024E         gfx_SetXY((WidthS - Font_8x12.W*10)/2, StartPos);
	LDS  R30,_Font_8x12
	LDI  R26,LOW(10)
	MUL  R30,R26
	MOVW R30,R0
	LDI  R26,LOW(128)
	SUB  R26,R30
	MOV  R30,R26
	LSR  R30
	ST   -Y,R30
	ST   -Y,R18
	CALL _gfx_SetXY
; 000A 024F         gfx_PutFlashStr("Please", 0xFF, &Font_8x12);
	__POINTW1FN _0x140000,91
	ST   -Y,R31
	ST   -Y,R30
	LDI  R30,LOW(255)
	ST   -Y,R30
	LDI  R30,LOW(_Font_8x12)
	LDI  R31,HIGH(_Font_8x12)
	ST   -Y,R31
	ST   -Y,R30
	CALL _gfx_PutFlashStr
; 000A 0250         gfx_SetXY((WidthS - Font_8x12.W*5)/2, StartPos + Font_8x12.H);
	LDS  R30,_Font_8x12
	LDI  R26,LOW(5)
	MUL  R30,R26
	MOVW R30,R0
	LDI  R26,LOW(128)
	SUB  R26,R30
	MOV  R30,R26
	LSR  R30
	ST   -Y,R30
	__GETB1MN _Font_8x12,1
	ADD  R30,R18
	ST   -Y,R30
	CALL _gfx_SetXY
; 000A 0251         gfx_PutFlashStr("wait...", 0xFF, &Font_8x12);
	__POINTW1FN _0x140000,98
	ST   -Y,R31
	ST   -Y,R30
	LDI  R30,LOW(255)
	ST   -Y,R30
	LDI  R30,LOW(_Font_8x12)
	LDI  R31,HIGH(_Font_8x12)
	ST   -Y,R31
	ST   -Y,R30
	CALL _gfx_PutFlashStr
; 000A 0252         gfx_Rectangle(0, StartPos + Font_8x12.H*2, WidthS - 1, StartPos + Font_8x12.H*3, 0xFF);
	LDI  R30,LOW(0)
	LDI  R31,HIGH(0)
	ST   -Y,R31
	ST   -Y,R30
	__GETB1MN _Font_8x12,1
	LSL  R30
	LDI  R31,0
	ADD  R30,R18
	ADC  R31,R19
	ST   -Y,R31
	ST   -Y,R30
	LDI  R30,LOW(127)
	LDI  R31,HIGH(127)
	ST   -Y,R31
	ST   -Y,R30
	__GETB2MN _Font_8x12,1
	LDI  R30,LOW(3)
	MUL  R30,R26
	MOVW R30,R0
	LDI  R31,0
	ADD  R30,R18
	ADC  R31,R19
	ST   -Y,R31
	ST   -Y,R30
	LDI  R30,LOW(255)
	ST   -Y,R30
	CALL _gfx_Rectangle
; 000A 0253         gfx_Refresh();
	CALL _gfx_Refresh
; 000A 0254 
; 000A 0255         for(i=0; i < MAX_MODELS; i++)
	__GETWRN 16,17,0
_0x14005E:
	__CPWRN 16,17,5
	BRGE _0x14005F
; 000A 0256         {
; 000A 0257             Settings.ModelNum = i;
	__PUTBMRN _Settings,5,16
; 000A 0258             MODEL_Reset(Settings.ModelNum);
	__GETB1MN _Settings,5
	ST   -Y,R30
	CALL _MODEL_Reset
; 000A 0259             gfx_FillRect(0, StartPos + Font_8x12.H*2, (WidthS * (i + 1) - 1) / MAX_MODELS, StartPos + Font_8x12.H*3, 0xFF);
	LDI  R30,LOW(0)
	LDI  R31,HIGH(0)
	ST   -Y,R31
	ST   -Y,R30
	__GETB1MN _Font_8x12,1
	LSL  R30
	LDI  R31,0
	ADD  R30,R18
	ADC  R31,R19
	ST   -Y,R31
	ST   -Y,R30
	MOVW R30,R16
	ADIW R30,1
	CALL __LSLW3
	CALL __LSLW4
	SBIW R30,1
	MOVW R26,R30
	LDI  R30,LOW(5)
	LDI  R31,HIGH(5)
	CALL __DIVW21
	ST   -Y,R31
	ST   -Y,R30
	__GETB2MN _Font_8x12,1
	LDI  R30,LOW(3)
	MUL  R30,R26
	MOVW R30,R0
	LDI  R31,0
	ADD  R30,R18
	ADC  R31,R19
	ST   -Y,R31
	ST   -Y,R30
	LDI  R30,LOW(255)
	ST   -Y,R30
	CALL _gfx_FillRect
; 000A 025A             gfx_Refresh();
	CALL _gfx_Refresh
; 000A 025B         }
	__ADDWRN 16,17,1
	RJMP _0x14005E
_0x14005F:
; 000A 025C 
; 000A 025D         delay_ms(500);
	LDI  R30,LOW(500)
	LDI  R31,HIGH(500)
	ST   -Y,R31
	ST   -Y,R30
	CALL _delay_ms
; 000A 025E 
; 000A 025F         EEPROM_SETTINGS.size = sizeof(EEPROM_SETTINGS);
	LDI  R26,LOW(_EEPROM_SETTINGS)
	LDI  R27,HIGH(_EEPROM_SETTINGS)
	LDI  R30,LOW(54)
	LDI  R31,HIGH(54)
	CALL __EEPROMWRW
; 000A 0260         EEPROM_SETTINGS.ModelNum = 0;
	__POINTW2MN _EEPROM_SETTINGS,5
	LDI  R30,LOW(0)
	CALL __EEPROMWRB
; 000A 0261         EEPROM_SETTINGS.SoundFlag = ON;
	__POINTW2MN _EEPROM_SETTINGS,3
	LDI  R30,LOW(1)
	CALL __EEPROMWRB
; 000A 0262         EEPROM_SETTINGS.BacklightFlag = OFF;
	__POINTW2MN _EEPROM_SETTINGS,4
	LDI  R30,LOW(0)
	CALL __EEPROMWRB
; 000A 0263         Calibration();
	RCALL _Calibration
; 000A 0264 
; 000A 0265         EEPROM_SETTINGS.FirstON = 1;
	__POINTW2MN _EEPROM_SETTINGS,2
	LDI  R30,LOW(1)
	CALL __EEPROMWRB
; 000A 0266 
; 000A 0267         //   CRC EEPROM   
; 000A 0268         Recalc_EEPROM_CRC();
	CALL _Recalc_EEPROM_CRC_G00A
; 000A 0269 
; 000A 026A     //    
; 000A 026B     #asm("sei")
	sei
_0x2060017:
; 000A 026C }
	CALL __LOADLOCR4
	ADIW R28,4
	RET
;/*******************************************************************************
;*  UI_Engine.c
;*
;*  :   
;*
;*       Copyright (c) 2009 Nick Shl
;*           All rights reserved.
;*
;*
;*  :
;*
;*  Mar 25, 2009  Nick_Shl   
;*
;*/// ***************************************************************************
;#include <mega128.h>
	#ifndef __SLEEP_DEFINED__
	#define __SLEEP_DEFINED__
	.EQU __se_bit=0x20
	.EQU __sm_mask=0x1C
	.EQU __sm_powerdown=0x10
	.EQU __sm_powersave=0x18
	.EQU __sm_standby=0x14
	.EQU __sm_ext_standby=0x1C
	.EQU __sm_adc_noise_red=0x08
	.SET power_ctrl_reg=mcucr
	#endif
;#include <delay.h>
;#include <stdio.h>
;#include <string.h>
;
;#include "Def.h"
;#include "Coder.h"
;#include "Graphic.h"
;#include "Variables.h"
;#include "Tasks.h"
;#include "System.h"
;#include "UI_Engine.h"
;
;// *****************************************************************************
;// ***        ***************************************************
;// *****************************************************************************
;void MenuCycle(MenuPad * Menu)
; 000B 0020 {

	.CSEG
_MenuCycle:
; 000B 0021     int i;
; 000B 0022     unsigned char Color;
; 000B 0023     unsigned char MenuHeaderH = 0;
; 000B 0024     unsigned char StartPos = 0;
; 000B 0025     unsigned char MenuCount = 0;
; 000B 0026     unsigned char Kbd = 0;
; 000B 0027     unsigned char ScrollHeight = 0;
; 000B 0028     unsigned char ScrollBarHeight = 0;
; 000B 0029     unsigned char ScrollBarWidth = 0;
; 000B 002A     unsigned char ScrollBarStart = 0;
; 000B 002B     unsigned char strLen;
; 000B 002C     unsigned char bufLen;
; 000B 002D     FontProfile * CaptionFont = Menu->CaptionFont;
; 000B 002E     FontProfile * MenuFont = Menu->MenuFont;
; 000B 002F 
; 000B 0030 #ifdef DEBUG
; 000B 0031     printf("MenuCycle();\r");
; 000B 0032     delay_ms(1);
; 000B 0033 #endif
; 000B 0034 
; 000B 0035     // 
; 000B 0036     if(Menu == NULL) return;          //      - 
	SBIW R28,11
	LDI  R30,LOW(0)
	STD  Y+6,R30
	STD  Y+7,R30
	STD  Y+8,R30
	STD  Y+9,R30
	STD  Y+10,R30
	CALL __SAVELOCR6
;	*Menu -> Y+17
;	i -> R16,R17
;	Color -> R19
;	MenuHeaderH -> R18
;	StartPos -> R21
;	MenuCount -> R20
;	Kbd -> Y+16
;	ScrollHeight -> Y+15
;	ScrollBarHeight -> Y+14
;	ScrollBarWidth -> Y+13
;	ScrollBarStart -> Y+12
;	strLen -> Y+11
;	bufLen -> Y+10
;	*CaptionFont -> Y+8
;	*MenuFont -> Y+6
	LDI  R18,0
	LDI  R21,0
	LDI  R20,0
	LDD  R26,Y+17
	LDD  R27,Y+17+1
	ADIW R26,2
	CALL __GETW1P
	STD  Y+8,R30
	STD  Y+8+1,R31
	LDD  R26,Y+17
	LDD  R27,Y+17+1
	ADIW R26,4
	CALL __GETW1P
	STD  Y+6,R30
	STD  Y+6+1,R31
	LDD  R30,Y+17
	LDD  R31,Y+17+1
	SBIW R30,0
	BRNE _0x160003
	RJMP _0x2060016
; 000B 0037     if(Menu->Buttons == NULL) return; //      - 
_0x160003:
	LDD  R26,Y+17
	LDD  R27,Y+17+1
	ADIW R26,6
	CALL __GETW1P
	SBIW R30,0
	BRNE _0x160004
	RJMP _0x2060016
; 000B 0038     if(Menu->ButtonsNum == 0) return; //      0 - 
_0x160004:
	LDD  R26,Y+17
	LDD  R27,Y+17+1
	ADIW R26,8
	LD   R30,X
	CPI  R30,0
	BRNE _0x160005
	RJMP _0x2060016
; 000B 0039     if(CaptionFont == NULL) CaptionFont = &Font_8x12; //      -   
_0x160005:
	LDD  R30,Y+8
	LDD  R31,Y+8+1
	SBIW R30,0
	BRNE _0x160006
	LDI  R30,LOW(_Font_8x12)
	LDI  R31,HIGH(_Font_8x12)
	STD  Y+8,R30
	STD  Y+8+1,R31
; 000B 003A     if(MenuFont == NULL) MenuFont = &Font_6x8;        //      -   
_0x160006:
	LDD  R30,Y+6
	LDD  R31,Y+6+1
	SBIW R30,0
	BRNE _0x160007
	LDI  R30,LOW(_Font_6x8)
	LDI  R31,HIGH(_Font_6x8)
	STD  Y+6,R30
	STD  Y+6+1,R31
; 000B 003B 
; 000B 003C     MenuHeaderH = Font_8x8.H + CaptionFont->H;
_0x160007:
	LDD  R26,Y+8
	LDD  R27,Y+8+1
	ADIW R26,1
	LD   R30,X
	__GETB2MN _Font_8x8,1
	ADD  R30,R26
	MOV  R18,R30
; 000B 003D 
; 000B 003E     //    ,   
; 000B 003F     MenuCount = (HeightS - MenuHeaderH - 3) / MenuFont->H;
	LDI  R30,LOW(64)
	SUB  R30,R18
	SUBI R30,LOW(3)
	MOV  R0,R30
	LDD  R26,Y+6
	LDD  R27,Y+6+1
	ADIW R26,1
	LD   R30,X
	MOV  R26,R0
	CALL __DIVB21U
	MOV  R20,R30
; 000B 0040     //          - 
; 000B 0041     if(MenuCount > Menu->ButtonsNum) MenuCount = Menu->ButtonsNum;
	LDD  R26,Y+17
	LDD  R27,Y+17+1
	ADIW R26,8
	LD   R30,X
	MOV  R26,R20
	LDI  R27,0
	LDI  R31,0
	SBRC R30,7
	SER  R31
	CP   R30,R26
	CPC  R31,R27
	BRGE _0x160008
	LDD  R26,Y+17
	LDD  R27,Y+17+1
	ADIW R26,8
	LD   R20,X
; 000B 0042 
; 000B 0043     //   :   -   
; 000B 0044     ScrollHeight = HeightS - (MenuHeaderH + 2 + 2);
_0x160008:
	MOV  R30,R18
	SUBI R30,-LOW(4)
	LDI  R26,LOW(64)
	SUB  R26,R30
	STD  Y+15,R26
; 000B 0045 
; 000B 0046     //    :
; 000B 0047     // (    *   ) /   
; 000B 0048     ScrollBarHeight = ((unsigned int)MenuCount * ScrollHeight) / Menu->ButtonsNum;
	MOV  R26,R20
	CLR  R27
	LDD  R30,Y+15
	LDI  R31,0
	CALL __MULW12U
	MOVW R0,R30
	LDD  R26,Y+17
	LDD  R27,Y+17+1
	ADIW R26,8
	LD   R30,X
	MOVW R26,R0
	LDI  R31,0
	SBRC R30,7
	SER  R31
	CALL __DIVW21U
	STD  Y+14,R30
; 000B 0049     //        -   
; 000B 004A     if(ScrollBarHeight > ScrollHeight/2)
	LDD  R30,Y+15
	LSR  R30
	LDD  R26,Y+14
	CP   R30,R26
	BRSH _0x160009
; 000B 004B     {
; 000B 004C          ScrollBarHeight = ScrollHeight/2;
	LDD  R30,Y+15
	LSR  R30
	STD  Y+14,R30
; 000B 004D     }
; 000B 004E 
; 000B 004F     //    :
; 000B 0050     ScrollBarWidth = 4;//MenuFont->W - 2;
_0x160009:
	LDI  R30,LOW(4)
	STD  Y+13,R30
; 000B 0051 
; 000B 0052     do{
_0x16000B:
; 000B 0053         //  
; 000B 0054         gfx_ClearBuf();
	CALL _gfx_ClearBuf
; 000B 0055 
; 000B 0056         //   
; 000B 0057         gfx_SetXY(0, Font_8x8.H);
	LDI  R30,LOW(0)
	ST   -Y,R30
	__GETB1MN _Font_8x8,1
	ST   -Y,R30
	CALL _gfx_SetXY
; 000B 0058         gfx_PutFlashStr(Menu->CaptionStr, 0xFF, CaptionFont);
	LDD  R26,Y+17
	LDD  R27,Y+17+1
	CALL __GETW1P
	ST   -Y,R31
	ST   -Y,R30
	LDI  R30,LOW(255)
	ST   -Y,R30
	LDD  R30,Y+11
	LDD  R31,Y+11+1
	ST   -Y,R31
	ST   -Y,R30
	CALL _gfx_PutFlashStr
; 000B 0059         gfx_DashLine(0, MenuHeaderH, WidthS, MenuHeaderH);
	LDI  R30,LOW(0)
	LDI  R31,HIGH(0)
	ST   -Y,R31
	ST   -Y,R30
	MOV  R30,R18
	LDI  R31,0
	ST   -Y,R31
	ST   -Y,R30
	LDI  R30,LOW(128)
	LDI  R31,HIGH(128)
	ST   -Y,R31
	ST   -Y,R30
	MOV  R30,R18
	LDI  R31,0
	ST   -Y,R31
	ST   -Y,R30
	CALL _gfx_DashLine
; 000B 005A 
; 000B 005B         //       -  - 
; 000B 005C         if(Menu->Before != NULL) Menu->Before();
	LDD  R26,Y+17
	LDD  R27,Y+17+1
	ADIW R26,10
	CALL __GETW1P
	SBIW R30,0
	BREQ _0x16000D
	LDD  R30,Y+17
	LDD  R31,Y+17+1
	__GETWRZ 0,1,10
	MOVW R30,R0
	ICALL
; 000B 005D 
; 000B 005E         do
_0x16000D:
_0x16000F:
; 000B 005F         {
; 000B 0060             //       ,   
; 000B 0061             gfx_FillRect(0, 0, WidthS - 1, Font_8x8.H, 0x00);
	LDI  R30,LOW(0)
	LDI  R31,HIGH(0)
	ST   -Y,R31
	ST   -Y,R30
	ST   -Y,R31
	ST   -Y,R30
	LDI  R30,LOW(127)
	LDI  R31,HIGH(127)
	ST   -Y,R31
	ST   -Y,R30
	__GETB1MN _Font_8x8,1
	LDI  R31,0
	ST   -Y,R31
	ST   -Y,R30
	LDI  R30,LOW(0)
	ST   -Y,R30
	CALL _gfx_FillRect
; 000B 0062 
; 000B 0063             gfx_SetXY(0, 0);
	LDI  R30,LOW(0)
	ST   -Y,R30
	ST   -Y,R30
	CALL _gfx_SetXY
; 000B 0064             //  
; 000B 0065             sprintf(tmpBuf, "%d", Settings.ModelNum + 1);
	LDI  R30,LOW(_tmpBuf)
	LDI  R31,HIGH(_tmpBuf)
	ST   -Y,R31
	ST   -Y,R30
	__POINTW1FN _0x160000,0
	ST   -Y,R31
	ST   -Y,R30
	__GETB1MN _Settings,5
	SUBI R30,-LOW(1)
	CALL __CBD1
	CALL __PUTPARD1
	LDI  R24,4
	CALL _sprintf
	ADIW R28,8
; 000B 0066             gfx_PutStr(tmpBuf, 0xFF, &Font_8x8);
	LDI  R30,LOW(_tmpBuf)
	LDI  R31,HIGH(_tmpBuf)
	ST   -Y,R31
	ST   -Y,R30
	LDI  R30,LOW(255)
	ST   -Y,R30
	LDI  R30,LOW(_Font_8x8)
	LDI  R31,HIGH(_Font_8x8)
	ST   -Y,R31
	ST   -Y,R30
	CALL _gfx_PutStr
; 000B 0067             //     4 
; 000B 0068             gfx_ChangeXY(3, 0);
	LDI  R30,LOW(3)
	ST   -Y,R30
	LDI  R30,LOW(0)
	ST   -Y,R30
	CALL _gfx_ChangeXY
; 000B 0069             //  
; 000B 006A             if(CurModel.type == TYPE_HELI)
	__GETB2MN _CurModel,15
	CPI  R26,LOW(0x1)
	BRNE _0x160011
; 000B 006B             {
; 000B 006C                 gfx_Char(125, 0xFF, &Font_8x8);
	LDI  R30,LOW(125)
	ST   -Y,R30
	LDI  R30,LOW(255)
	ST   -Y,R30
	LDI  R30,LOW(_Font_8x8)
	LDI  R31,HIGH(_Font_8x8)
	ST   -Y,R31
	ST   -Y,R30
	CALL _gfx_Char
; 000B 006D                 gfx_Char(126, 0xFF, &Font_8x8);
	LDI  R30,LOW(126)
	ST   -Y,R30
	LDI  R30,LOW(255)
	ST   -Y,R30
	LDI  R30,LOW(_Font_8x8)
	LDI  R31,HIGH(_Font_8x8)
	ST   -Y,R31
	ST   -Y,R30
	CALL _gfx_Char
; 000B 006E             }
; 000B 006F             //  
; 000B 0070             if(CurModel.type == TYPE_PLANE)
_0x160011:
	__GETB1MN _CurModel,15
	CPI  R30,0
	BRNE _0x160012
; 000B 0071             {
; 000B 0072                 gfx_Char(127, 0xFF, &Font_8x8);
	LDI  R30,LOW(127)
	ST   -Y,R30
	LDI  R30,LOW(255)
	ST   -Y,R30
	LDI  R30,LOW(_Font_8x8)
	LDI  R31,HIGH(_Font_8x8)
	ST   -Y,R31
	ST   -Y,R30
	CALL _gfx_Char
; 000B 0073                 gfx_Char(128, 0xFF, &Font_8x8);
	LDI  R30,LOW(128)
	ST   -Y,R30
	LDI  R30,LOW(255)
	ST   -Y,R30
	LDI  R30,LOW(_Font_8x8)
	LDI  R31,HIGH(_Font_8x8)
	ST   -Y,R31
	ST   -Y,R30
	CALL _gfx_Char
; 000B 0074             }
; 000B 0075             //     4 
; 000B 0076             gfx_ChangeXY(3, 0);
_0x160012:
	LDI  R30,LOW(3)
	ST   -Y,R30
	LDI  R30,LOW(0)
	ST   -Y,R30
	CALL _gfx_ChangeXY
; 000B 0077             //  
; 000B 0078             gfx_PutStr(CurModel.Mode[FLY_MODE].name, 0xFF, &Font_6x8);
	__POINTW2MN _CurModel,21
	LDS  R30,_FLY_MODE
	LDI  R31,0
	MOVW R22,R26
	LDI  R26,LOW(246)
	LDI  R27,HIGH(246)
	CALL __MULW12U
	ADD  R30,R22
	ADC  R31,R23
	ST   -Y,R31
	ST   -Y,R30
	LDI  R30,LOW(255)
	ST   -Y,R30
	LDI  R30,LOW(_Font_6x8)
	LDI  R31,HIGH(_Font_6x8)
	ST   -Y,R31
	ST   -Y,R30
	CALL _gfx_PutStr
; 000B 0079 
; 000B 007A             //     :
; 000B 007B             //    + (    *     ) /   
; 000B 007C             ScrollBarStart = MenuHeaderH + 2 + 1 + (Menu->CurrentPos * (unsigned int)(ScrollHeight - ScrollBarHeight)) / (Menu->ButtonsNum - 1);
	LDD  R30,Y+17
	LDD  R31,Y+17+1
	LDD  R0,Z+9
	LDD  R26,Y+14
	LDD  R30,Y+15
	SUB  R30,R26
	LDI  R31,0
	MOV  R26,R0
	LDI  R27,0
	SBRC R26,7
	SER  R27
	CALL __MULW12U
	MOVW R22,R30
	LDD  R30,Y+17
	LDD  R31,Y+17+1
	LDD  R26,Z+8
	LDI  R30,LOW(1)
	CALL __SWAPB12
	SUB  R30,R26
	MOVW R26,R22
	LDI  R31,0
	SBRC R30,7
	SER  R31
	CALL __DIVW21U
	MOV  R26,R18
	SUBI R26,-LOW(3)
	ADD  R30,R26
	STD  Y+12,R30
; 000B 007D             //          ,
; 000B 007E             // ..        
; 000B 007F             if(Menu->CurrentPos == Menu->ButtonsNum - 1)
	LDD  R30,Y+17
	LDD  R31,Y+17+1
	LDD  R0,Z+9
	LDD  R26,Z+8
	LDI  R30,LOW(1)
	CALL __SWAPB12
	SUB  R30,R26
	CP   R30,R0
	BRNE _0x160013
; 000B 0080             {
; 000B 0081                 ScrollBarStart = ScrollHeight - ScrollBarHeight + MenuHeaderH + 2 + 1;
	LDD  R26,Y+14
	LDD  R30,Y+15
	SUB  R30,R26
	ADD  R30,R18
	SUBI R30,-LOW(3)
	STD  Y+12,R30
; 000B 0082             }
; 000B 0083 
; 000B 0084             //     
; 000B 0085             gfx_FillRect(0, MenuHeaderH + 2, ScrollBarWidth - 1, HeightS - 1, 0x00);
_0x160013:
	LDI  R30,LOW(0)
	LDI  R31,HIGH(0)
	ST   -Y,R31
	ST   -Y,R30
	MOV  R30,R18
	SUBI R30,-LOW(2)
	LDI  R31,0
	ST   -Y,R31
	ST   -Y,R30
	LDD  R30,Y+17
	SUBI R30,LOW(1)
	LDI  R31,0
	ST   -Y,R31
	ST   -Y,R30
	LDI  R30,LOW(63)
	LDI  R31,HIGH(63)
	ST   -Y,R31
	ST   -Y,R30
	LDI  R30,LOW(0)
	ST   -Y,R30
	CALL _gfx_FillRect
; 000B 0086             //   
; 000B 0087             gfx_Rectangle(0, MenuHeaderH + 2, ScrollBarWidth - 1, HeightS - 1, 0xFF);
	LDI  R30,LOW(0)
	LDI  R31,HIGH(0)
	ST   -Y,R31
	ST   -Y,R30
	MOV  R30,R18
	SUBI R30,-LOW(2)
	LDI  R31,0
	ST   -Y,R31
	ST   -Y,R30
	LDD  R30,Y+17
	SUBI R30,LOW(1)
	LDI  R31,0
	ST   -Y,R31
	ST   -Y,R30
	LDI  R30,LOW(63)
	LDI  R31,HIGH(63)
	ST   -Y,R31
	ST   -Y,R30
	LDI  R30,LOW(255)
	ST   -Y,R30
	CALL _gfx_Rectangle
; 000B 0088             //    
; 000B 0089             gfx_FillRect(0, ScrollBarStart, ScrollBarWidth - 1, ScrollBarStart + ScrollBarHeight, 0xFF);
	LDI  R30,LOW(0)
	LDI  R31,HIGH(0)
	ST   -Y,R31
	ST   -Y,R30
	LDD  R30,Y+14
	LDI  R31,0
	ST   -Y,R31
	ST   -Y,R30
	LDD  R30,Y+17
	SUBI R30,LOW(1)
	LDI  R31,0
	ST   -Y,R31
	ST   -Y,R30
	LDD  R30,Y+20
	LDD  R26,Y+18
	ADD  R30,R26
	LDI  R31,0
	ST   -Y,R31
	ST   -Y,R30
	LDI  R30,LOW(255)
	ST   -Y,R30
	CALL _gfx_FillRect
; 000B 008A 
; 000B 008B             //   
; 000B 008C             for(i = StartPos; i < StartPos + MenuCount; i++)
	MOV  R16,R21
	CLR  R17
_0x160015:
	MOV  R30,R20
	ADD  R30,R21
	MOVW R26,R16
	LDI  R31,0
	CP   R26,R30
	CPC  R27,R31
	BRLT PC+3
	JMP _0x160016
; 000B 008D             {
; 000B 008E                 //     
; 000B 008F                 strLen = (WidthS - (ScrollBarWidth + 2)) / MenuFont->W;
	LDD  R30,Y+13
	SUBI R30,-LOW(2)
	LDI  R26,LOW(128)
	SUB  R26,R30
	MOV  R0,R26
	LDD  R26,Y+6
	LDD  R27,Y+6+1
	LD   R30,X
	MOV  R26,R0
	CALL __DIVB21U
	STD  Y+11,R30
; 000B 0090 
; 000B 0091                 //    
; 000B 0092                 memset(tmpStr, ' ', sizeof(tmpStr));
	LDI  R30,LOW(_tmpStr)
	LDI  R31,HIGH(_tmpStr)
	ST   -Y,R31
	ST   -Y,R30
	LDI  R30,LOW(32)
	ST   -Y,R30
	LDI  R30,LOW(64)
	LDI  R31,HIGH(64)
	ST   -Y,R31
	ST   -Y,R30
	CALL _memset
; 000B 0093 
; 000B 0094                 //     . 
; 000B 0095                 if(Menu->Buttons[i].GetStr != NULL)
	LDD  R30,Y+17
	LDD  R31,Y+17+1
	LDD  R26,Z+6
	LDD  R27,Z+7
	MOVW R30,R16
	MOVW R22,R26
	LDI  R26,LOW(7)
	LDI  R27,HIGH(7)
	CALL __MULW12U
	ADD  R30,R22
	ADC  R31,R23
	ADIW R30,4
	CALL __GETW1PF
	SBIW R30,0
	BRNE PC+3
	JMP _0x160017
; 000B 0096                 {
; 000B 0097                     //  .   
; 000B 0098                     Menu->Buttons[i].GetStr(tmpBuf, Menu->Buttons[i].AddParam);
	LDD  R30,Y+17
	LDD  R31,Y+17+1
	LDD  R26,Z+6
	LDD  R27,Z+7
	MOVW R30,R16
	MOVW R22,R26
	LDI  R26,LOW(7)
	LDI  R27,HIGH(7)
	CALL __MULW12U
	ADD  R30,R22
	ADC  R31,R23
	ADIW R30,4
	CALL __GETW1PF
	PUSH R31
	PUSH R30
	LDI  R30,LOW(_tmpBuf)
	LDI  R31,HIGH(_tmpBuf)
	ST   -Y,R31
	ST   -Y,R30
	LDD  R30,Y+19
	LDD  R31,Y+19+1
	LDD  R26,Z+6
	LDD  R27,Z+7
	MOVW R30,R16
	MOVW R22,R26
	LDI  R26,LOW(7)
	LDI  R27,HIGH(7)
	CALL __MULW12U
	ADD  R30,R22
	ADC  R31,R23
	ADIW R30,6
	LPM  R30,Z
	ST   -Y,R30
	POP  R30
	POP  R31
	ICALL
; 000B 0099                     //   
; 000B 009A                     bufLen = strlen(tmpBuf);
	LDI  R30,LOW(_tmpBuf)
	LDI  R31,HIGH(_tmpBuf)
	ST   -Y,R31
	ST   -Y,R30
	CALL _strlen
	STD  Y+10,R30
; 000B 009B                     //          - 
; 000B 009C                     if(bufLen > strLen) bufLen = strLen;
	LDD  R30,Y+11
	LDD  R26,Y+10
	CP   R30,R26
	BRSH _0x160018
	STD  Y+10,R30
; 000B 009D                     //  .    ,     
; 000B 009E                     strcpy(tmpStr + (strLen - bufLen), tmpBuf);
_0x160018:
	LDD  R26,Y+10
	LDD  R30,Y+11
	SUB  R30,R26
	LDI  R31,0
	SUBI R30,LOW(-_tmpStr)
	SBCI R31,HIGH(-_tmpStr)
	ST   -Y,R31
	ST   -Y,R30
	LDI  R30,LOW(_tmpBuf)
	LDI  R31,HIGH(_tmpBuf)
	ST   -Y,R31
	ST   -Y,R30
	CALL _strcpy
; 000B 009F                 }
; 000B 00A0 
; 000B 00A1                 //         
; 000B 00A2                 strcpyf(tmpStr, Menu->Buttons[i].str);
_0x160017:
	LDI  R30,LOW(_tmpStr)
	LDI  R31,HIGH(_tmpStr)
	ST   -Y,R31
	ST   -Y,R30
	LDD  R30,Y+19
	LDD  R31,Y+19+1
	LDD  R26,Z+6
	LDD  R27,Z+7
	MOVW R30,R16
	MOVW R22,R26
	LDI  R26,LOW(7)
	LDI  R27,HIGH(7)
	CALL __MULW12U
	ADD  R30,R22
	ADC  R31,R23
	CALL __GETW1PF
	ST   -Y,R31
	ST   -Y,R30
	CALL _strcpyf
; 000B 00A3                 //          -    
; 000B 00A4                 if(strlen(tmpStr) < strLen) tmpStr[strlen(tmpStr)] = ' ';
	LDI  R30,LOW(_tmpStr)
	LDI  R31,HIGH(_tmpStr)
	ST   -Y,R31
	ST   -Y,R30
	CALL _strlen
	MOVW R26,R30
	LDD  R30,Y+11
	LDI  R31,0
	CP   R26,R30
	CPC  R27,R31
	BRSH _0x160019
	LDI  R30,LOW(_tmpStr)
	LDI  R31,HIGH(_tmpStr)
	ST   -Y,R31
	ST   -Y,R30
	CALL _strlen
	SUBI R30,LOW(-_tmpStr)
	SBCI R31,HIGH(-_tmpStr)
	LDI  R26,LOW(32)
	STD  Z+0,R26
; 000B 00A5                 //     (         )
; 000B 00A6                 tmpStr[strLen] = '\0';
_0x160019:
	LDD  R30,Y+11
	LDI  R31,0
	SUBI R30,LOW(-_tmpStr)
	SBCI R31,HIGH(-_tmpStr)
	LDI  R26,LOW(0)
	STD  Z+0,R26
; 000B 00A7 
; 000B 00A8                 //   
; 000B 00A9                 gfx_SetXY(ScrollBarWidth + 2, MenuFont->H * (i - StartPos) + MenuHeaderH + 2);
	LDD  R30,Y+13
	SUBI R30,-LOW(2)
	ST   -Y,R30
	LDD  R30,Y+7
	LDD  R31,Y+7+1
	LDD  R0,Z+1
	MOV  R30,R21
	MOVW R26,R16
	LDI  R31,0
	CALL __SWAPW12
	SUB  R30,R26
	SBC  R31,R27
	MOV  R26,R0
	MULS R30,R26
	MOVW R30,R0
	ADD  R30,R18
	SUBI R30,-LOW(2)
	ST   -Y,R30
	CALL _gfx_SetXY
; 000B 00AA                 //   -    
; 000B 00AB                 if(Menu->CurrentPos == i) Color = 0x00;
	LDD  R30,Y+17
	LDD  R31,Y+17+1
	LDD  R26,Z+9
	MOVW R30,R16
	LDI  R27,0
	SBRC R26,7
	SER  R27
	CP   R30,R26
	CPC  R31,R27
	BRNE _0x16001A
	LDI  R19,LOW(0)
; 000B 00AC                 else                      Color = 0xFF;
	RJMP _0x16001B
_0x16001A:
	LDI  R19,LOW(255)
; 000B 00AD                 //  
; 000B 00AE                 gfx_PutStr(tmpStr, Color, MenuFont);
_0x16001B:
	LDI  R30,LOW(_tmpStr)
	LDI  R31,HIGH(_tmpStr)
	ST   -Y,R31
	ST   -Y,R30
	ST   -Y,R19
	LDD  R30,Y+9
	LDD  R31,Y+9+1
	ST   -Y,R31
	ST   -Y,R30
	CALL _gfx_PutStr
; 000B 00AF             }
	__ADDWRN 16,17,1
	RJMP _0x160015
_0x160016:
; 000B 00B0             //  
; 000B 00B1             gfx_Refresh();
	CALL _gfx_Refresh
; 000B 00B2 
; 000B 00B3             //   
; 000B 00B4             WaitEmptyButtons(0);
	LDI  R30,LOW(0)
	ST   -Y,R30
	CALL _WaitEmptyButtons
; 000B 00B5             //   
; 000B 00B6             Kbd = WaitButtonPress(0);
	LDI  R30,LOW(0)
	ST   -Y,R30
	CALL _WaitButtonPress
	STD  Y+16,R30
; 000B 00B7 
; 000B 00B8             //   ,     
; 000B 00B9             if((Kbd & B_UP)   && (Menu->CurrentPos > 0))                    Menu->CurrentPos--;
	ANDI R30,LOW(0x1)
	BREQ _0x16001D
	LDD  R30,Y+17
	LDD  R31,Y+17+1
	LDD  R26,Z+9
	CPI  R26,LOW(0x1)
	BRGE _0x16001E
_0x16001D:
	RJMP _0x16001C
_0x16001E:
	LDD  R26,Y+17
	LDD  R27,Y+17+1
	ADIW R26,9
	LD   R30,X
	SUBI R30,LOW(1)
	ST   X,R30
; 000B 00BA             if((Kbd & B_DOWN) && (Menu->CurrentPos < Menu->ButtonsNum - 1)) Menu->CurrentPos++;
_0x16001C:
	LDD  R30,Y+16
	ANDI R30,LOW(0x2)
	BREQ _0x160020
	LDD  R30,Y+17
	LDD  R31,Y+17+1
	LDD  R0,Z+9
	LDD  R26,Z+8
	LDI  R30,LOW(1)
	CALL __SWAPB12
	SUB  R30,R26
	CP   R0,R30
	BRLT _0x160021
_0x160020:
	RJMP _0x16001F
_0x160021:
	LDD  R26,Y+17
	LDD  R27,Y+17+1
	ADIW R26,9
	LD   R30,X
	SUBI R30,-LOW(1)
	ST   X,R30
; 000B 00BB 
; 000B 00BC             //       -     
; 000B 00BD             if(Menu->CurrentPos < StartPos)                 StartPos--;
_0x16001F:
	LDD  R30,Y+17
	LDD  R31,Y+17+1
	LDD  R26,Z+9
	MOV  R30,R21
	LDI  R27,0
	SBRC R26,7
	SER  R27
	LDI  R31,0
	CP   R26,R30
	CPC  R27,R31
	BRGE _0x160022
	SUBI R21,1
; 000B 00BE             if(Menu->CurrentPos > StartPos + MenuCount - 1) StartPos++;
_0x160022:
	LDD  R30,Y+17
	LDD  R31,Y+17+1
	LDD  R26,Z+9
	MOV  R30,R20
	ADD  R30,R21
	SUBI R30,LOW(1)
	LDI  R27,0
	SBRC R26,7
	SER  R27
	LDI  R31,0
	CP   R30,R26
	CPC  R31,R27
	BRGE _0x160023
	SUBI R21,-1
; 000B 00BF         }
_0x160023:
; 000B 00C0         while(!(Kbd & (B_BACK | B_ENTER)));
	LDD  R30,Y+16
	ANDI R30,LOW(0x30)
	BRNE _0x160010
	RJMP _0x16000F
_0x160010:
; 000B 00C1 
; 000B 00C2         //       -  - 
; 000B 00C3         if(Menu->After != NULL) Menu->After();
	LDD  R26,Y+17
	LDD  R27,Y+17+1
	ADIW R26,12
	CALL __GETW1P
	SBIW R30,0
	BREQ _0x160024
	LDD  R30,Y+17
	LDD  R31,Y+17+1
	__GETWRZ 0,1,12
	MOVW R30,R0
	ICALL
; 000B 00C4 
; 000B 00C5         //         
; 000B 00C6         if((Kbd & B_ENTER) && (Menu->Buttons[Menu->CurrentPos].fun != NULL))
_0x160024:
	LDD  R30,Y+16
	ANDI R30,LOW(0x20)
	BREQ _0x160026
	LDD  R30,Y+17
	LDD  R31,Y+17+1
	__GETWRZ 0,1,6
	LDD  R26,Y+17
	LDD  R27,Y+17+1
	ADIW R26,9
	LD   R30,X
	LDI  R31,0
	MOVW R22,R0
	LDI  R26,LOW(7)
	LDI  R27,HIGH(7)
	CALL __MULW12U
	ADD  R30,R22
	ADC  R31,R23
	ADIW R30,2
	CALL __GETW2PF
	SBIW R26,0
	BRNE _0x160027
_0x160026:
	RJMP _0x160025
_0x160027:
; 000B 00C7         {
; 000B 00C8             //   
; 000B 00C9             WaitEmptyButtons(0);
	LDI  R30,LOW(0)
	ST   -Y,R30
	CALL _WaitEmptyButtons
; 000B 00CA             //   
; 000B 00CB             Menu->Buttons[Menu->CurrentPos].fun(Menu->Buttons[Menu->CurrentPos].AddParam);
	LDD  R30,Y+17
	LDD  R31,Y+17+1
	__GETWRZ 0,1,6
	LDD  R26,Y+17
	LDD  R27,Y+17+1
	ADIW R26,9
	LD   R30,X
	LDI  R31,0
	MOVW R22,R0
	LDI  R26,LOW(7)
	LDI  R27,HIGH(7)
	CALL __MULW12U
	ADD  R30,R22
	ADC  R31,R23
	MOVW R26,R30
	ADIW R30,2
	CALL __GETW1PF
	PUSH R31
	PUSH R30
	MOVW R30,R26
	ADIW R30,6
	LPM  R30,Z
	ST   -Y,R30
	POP  R30
	POP  R31
	ICALL
; 000B 00CC         }
; 000B 00CD     }
_0x160025:
; 000B 00CE     while(!(Kbd & B_BACK));
	LDD  R30,Y+16
	ANDI R30,LOW(0x10)
	BRNE _0x16000C
	RJMP _0x16000B
_0x16000C:
; 000B 00CF 
; 000B 00D0     //   
; 000B 00D1     WaitEmptyButtons(0);
	LDI  R30,LOW(0)
	ST   -Y,R30
	CALL _WaitEmptyButtons
; 000B 00D2 }
_0x2060016:
	CALL __LOADLOCR6
	ADIW R28,19
	RET
;
;// *****************************************************************************
;// ***        ********************************************
;// *****************************************************************************
;// FIX ME:     
;void MsgBoxStrEx(StringType * Strings, unsigned char N,
; 000B 00D9                  char flash * Header, FontProfile * HeaderFont,
; 000B 00DA                  unsigned char CenterX, unsigned char CenterY,
; 000B 00DB                  unsigned char Width, unsigned char Color)  // Width in chars
; 000B 00DC {
_MsgBoxStrEx:
; 000B 00DD     //   
; 000B 00DE 	unsigned char i;
; 000B 00DF     //     
; 000B 00E0     unsigned char X, Y, W = 0, H = 0, y, StrW, StrCount;
; 000B 00E1     //     
; 000B 00E2     unsigned char FontH = 0, FontW = 0;
; 000B 00E3     //  
; 000B 00E4 	char * p;
; 000B 00E5     //   
; 000B 00E6 	unsigned char count = 0;
; 000B 00E7 
; 000B 00E8 #ifdef DEBUG
; 000B 00E9     printf("MsgBoxStrEx(%d);\r", N);
; 000B 00EA     delay_ms(1);
; 000B 00EB #endif
; 000B 00EC 
; 000B 00ED     // 
; 000B 00EE     if(Strings == NULL) return;                       //      - 
	SBIW R28,7
	LDI  R30,LOW(0)
	ST   Y,R30
	STD  Y+1,R30
	STD  Y+2,R30
	STD  Y+3,R30
	STD  Y+4,R30
	CALL __SAVELOCR6
;	*Strings -> Y+22
;	N -> Y+21
;	*Header -> Y+19
;	*HeaderFont -> Y+17
;	CenterX -> Y+16
;	CenterY -> Y+15
;	Width -> Y+14
;	Color -> Y+13
;	i -> R17
;	X -> R16
;	Y -> R19
;	W -> R18
;	H -> R21
;	y -> R20
;	StrW -> Y+12
;	StrCount -> Y+11
;	FontH -> Y+10
;	FontW -> Y+9
;	*p -> Y+7
;	count -> Y+6
	LDI  R18,0
	LDI  R21,0
	LDD  R30,Y+22
	LDD  R31,Y+22+1
	SBIW R30,0
	BRNE _0x160028
	RJMP _0x2060015
; 000B 00EF     if(HeaderFont == NULL) HeaderFont = &Font_4x6; //     -   
_0x160028:
	LDD  R30,Y+17
	LDD  R31,Y+17+1
	SBIW R30,0
	BRNE _0x160029
	LDI  R30,LOW(_Font_4x6)
	LDI  R31,HIGH(_Font_4x6)
	STD  Y+17,R30
	STD  Y+17+1,R31
; 000B 00F0 
; 000B 00F1     //       
; 000B 00F2 	for(i = 0; i < N; i++)
_0x160029:
	LDI  R17,LOW(0)
_0x16002B:
	LDD  R30,Y+21
	CP   R17,R30
	BRLO PC+3
	JMP _0x16002C
; 000B 00F3 	{
; 000B 00F4         if(Strings[i].Str != NULL)
	MOV  R30,R17
	LDI  R31,0
	LDD  R26,Y+22
	LDD  R27,Y+22+1
	CALL __LSLW3
	ADD  R26,R30
	ADC  R27,R31
	CALL __GETW1P
	SBIW R30,0
	BRNE PC+3
	JMP _0x16002D
; 000B 00F5         {
; 000B 00F6             //      strlen
; 000B 00F7                  if(Strings[i].StrPtrType == PTR_FLASH) Strings[i].Len = strlenf((char flash *)Strings[i].Str);
	MOV  R30,R17
	LDI  R31,0
	LDD  R26,Y+22
	LDD  R27,Y+22+1
	CALL __LSLW3
	ADD  R26,R30
	ADC  R27,R31
	ADIW R26,2
	LD   R30,X
	CPI  R30,0
	BRNE _0x16002E
	MOV  R30,R17
	LDI  R31,0
	LDD  R26,Y+22
	LDD  R27,Y+22+1
	CALL __LSLW3
	ADD  R30,R26
	ADC  R31,R27
	ADIW R30,3
	PUSH R31
	PUSH R30
	MOV  R30,R17
	LDI  R31,0
	CALL __LSLW3
	ADD  R26,R30
	ADC  R27,R31
	CALL __GETW1P
	ST   -Y,R31
	ST   -Y,R30
	CALL _strlenf
	POP  R26
	POP  R27
	RJMP _0x1600F3
; 000B 00F8             else if(Strings[i].StrPtrType == PTR_SRAM ) Strings[i].Len = strlen((char *)Strings[i].Str);
_0x16002E:
	MOV  R30,R17
	LDI  R31,0
	LDD  R26,Y+22
	LDD  R27,Y+22+1
	CALL __LSLW3
	ADD  R26,R30
	ADC  R27,R31
	ADIW R26,2
	LD   R26,X
	CPI  R26,LOW(0x1)
	BRNE _0x160030
	MOV  R30,R17
	LDI  R31,0
	LDD  R26,Y+22
	LDD  R27,Y+22+1
	CALL __LSLW3
	ADD  R30,R26
	ADC  R31,R27
	ADIW R30,3
	PUSH R31
	PUSH R30
	MOV  R30,R17
	LDI  R31,0
	CALL __LSLW3
	ADD  R26,R30
	ADC  R27,R31
	CALL __GETW1P
	ST   -Y,R31
	ST   -Y,R30
	CALL _strlen
	POP  R26
	POP  R27
_0x1600F3:
	ST   X,R30
; 000B 00F9         }
_0x160030:
; 000B 00FA         else
	RJMP _0x160031
_0x16002D:
; 000B 00FB         {
; 000B 00FC             Strings[i].Len = 0;
	MOV  R30,R17
	LDI  R31,0
	LDD  R26,Y+22
	LDD  R27,Y+22+1
	CALL __LSLW3
	ADD  R26,R30
	ADC  R27,R31
	ADIW R26,3
	LDI  R30,LOW(0)
	ST   X,R30
; 000B 00FD         }
_0x160031:
; 000B 00FE 
; 000B 00FF         //       -   
; 000B 0100         if(Strings[i].StrFont == NULL) Strings[i].StrFont = &Font_8x12;
	MOV  R30,R17
	LDI  R31,0
	LDD  R26,Y+22
	LDD  R27,Y+22+1
	CALL __LSLW3
	ADD  R26,R30
	ADC  R27,R31
	ADIW R26,4
	CALL __GETW1P
	SBIW R30,0
	BRNE _0x160032
	MOV  R30,R17
	LDI  R31,0
	LDD  R26,Y+22
	LDD  R27,Y+22+1
	CALL __LSLW3
	ADD  R26,R30
	ADC  R27,R31
	ADIW R26,4
	LDI  R30,LOW(_Font_8x12)
	LDI  R31,HIGH(_Font_8x12)
	ST   X+,R30
	ST   X,R31
; 000B 0101 
; 000B 0102         //     
; 000B 0103         StrW = Strings[i].StrFont->W * Strings[i].Len;
_0x160032:
	MOV  R30,R17
	LDI  R31,0
	LDD  R26,Y+22
	LDD  R27,Y+22+1
	CALL __LSLW3
	ADD  R26,R30
	ADC  R27,R31
	ADIW R26,4
	CALL __GETW1P
	LD   R0,Z
	MOV  R30,R17
	LDI  R31,0
	LDD  R26,Y+22
	LDD  R27,Y+22+1
	CALL __LSLW3
	ADD  R26,R30
	ADC  R27,R31
	ADIW R26,3
	LD   R30,X
	MUL  R30,R0
	MOVW R30,R0
	STD  Y+12,R30
; 000B 0104         //       -  
; 000B 0105 		if(W < StrW) W = StrW;
	CP   R18,R30
	BRSH _0x160033
	LDD  R18,Y+12
; 000B 0106         //   
; 000B 0107         H += Strings[i].StrFont->H + Strings[i].VSpace;
_0x160033:
	MOV  R30,R17
	LDI  R31,0
	LDD  R26,Y+22
	LDD  R27,Y+22+1
	CALL __LSLW3
	ADD  R26,R30
	ADC  R27,R31
	ADIW R26,4
	CALL __GETW1P
	LDD  R0,Z+1
	MOV  R30,R17
	LDI  R31,0
	LDD  R26,Y+22
	LDD  R27,Y+22+1
	CALL __LSLW3
	ADD  R26,R30
	ADC  R27,R31
	ADIW R26,7
	LD   R30,X
	ADD  R30,R0
	ADD  R21,R30
; 000B 0108 
; 000B 0109         if(FontH < Strings[i].StrFont->H) FontH = Strings[i].StrFont->H;
	MOV  R30,R17
	LDI  R31,0
	LDD  R26,Y+22
	LDD  R27,Y+22+1
	CALL __LSLW3
	ADD  R26,R30
	ADC  R27,R31
	ADIW R26,4
	CALL __GETW1P
	LDD  R30,Z+1
	LDD  R26,Y+10
	CP   R26,R30
	BRSH _0x160034
	MOV  R30,R17
	LDI  R31,0
	LDD  R26,Y+22
	LDD  R27,Y+22+1
	CALL __LSLW3
	ADD  R26,R30
	ADC  R27,R31
	ADIW R26,4
	CALL __GETW1P
	LDD  R30,Z+1
	STD  Y+10,R30
; 000B 010A         if(FontW < Strings[i].StrFont->W) FontW = Strings[i].StrFont->W;
_0x160034:
	MOV  R30,R17
	LDI  R31,0
	LDD  R26,Y+22
	LDD  R27,Y+22+1
	CALL __LSLW3
	ADD  R26,R30
	ADC  R27,R31
	ADIW R26,4
	CALL __GETW1P
	LD   R30,Z
	LDD  R26,Y+9
	CP   R26,R30
	BRSH _0x160035
	MOV  R30,R17
	LDI  R31,0
	LDD  R26,Y+22
	LDD  R27,Y+22+1
	CALL __LSLW3
	ADD  R26,R30
	ADC  R27,R31
	ADIW R26,4
	CALL __GETW1P
	LD   R30,Z
	STD  Y+9,R30
; 000B 010B 	}
_0x160035:
	SUBI R17,-1
	RJMP _0x16002B
_0x16002C:
; 000B 010C 
; 000B 010D     if(Header != NULL)
	LDD  R30,Y+19
	LDD  R31,Y+19+1
	SBIW R30,0
	BREQ _0x160036
; 000B 010E     {
; 000B 010F         //     
; 000B 0110         StrW = HeaderFont->W * strlenf(Header);
	LDD  R26,Y+17
	LDD  R27,Y+17+1
	LD   R30,X
	PUSH R30
	LDD  R30,Y+19
	LDD  R31,Y+19+1
	ST   -Y,R31
	ST   -Y,R30
	CALL _strlenf
	POP  R26
	MUL  R30,R26
	MOVW R30,R0
	STD  Y+12,R30
; 000B 0111         //        -  
; 000B 0112 		if(W < StrW) W = StrW;
	CP   R18,R30
	BRSH _0x160037
	LDD  R18,Y+12
; 000B 0113     }
_0x160037:
; 000B 0114 
; 000B 0115     //      -  
; 000B 0116     if(W < FontW * Width) W = FontW * Width;
_0x160036:
	LDD  R30,Y+14
	LDD  R26,Y+9
	MUL  R30,R26
	MOVW R30,R0
	CP   R18,R30
	BRSH _0x160038
	LDD  R30,Y+14
	MUL  R30,R26
	MOV  R18,R0
; 000B 0117 
; 000B 0118     //    (           0.5 )
; 000B 0119 	H += FontH;
_0x160038:
	LDD  R30,Y+10
	ADD  R21,R30
; 000B 011A     //            1 
; 000B 011B 	W += FontW * 2;
	LDD  R30,Y+9
	LSL  R30
	ADD  R18,R30
; 000B 011C 
; 000B 011D     //      
; 000B 011E 	X = CenterX - W / 2;
	MOV  R30,R18
	LSR  R30
	LDD  R26,Y+16
	SUB  R26,R30
	MOV  R16,R26
; 000B 011F     //      
; 000B 0120     Y = CenterY - H / 2;
	MOV  R30,R21
	LSR  R30
	LDD  R26,Y+15
	SUB  R26,R30
	MOV  R19,R26
; 000B 0121 
; 000B 0122     // ,  
; 000B 0123     if(Header != NULL)
	LDD  R30,Y+19
	LDD  R31,Y+19+1
	SBIW R30,0
	BRNE PC+3
	JMP _0x160039
; 000B 0124     {
; 000B 0125         //       
; 000B 0126         Y += HeaderFont->H / 2;
	LDD  R30,Y+17
	LDD  R31,Y+17+1
	LDD  R30,Z+1
	LSR  R30
	ADD  R19,R30
; 000B 0127         //    
; 000B 0128         gfx_Rectangle(X - 1, Y - HeaderFont->H - 2, X + W + 1, Y + 1, 0x00);
	MOV  R30,R16
	SUBI R30,LOW(1)
	LDI  R31,0
	ST   -Y,R31
	ST   -Y,R30
	LDD  R26,Y+19
	LDD  R27,Y+19+1
	ADIW R26,1
	LD   R26,X
	MOV  R30,R19
	SUB  R30,R26
	SUBI R30,LOW(2)
	LDI  R31,0
	ST   -Y,R31
	ST   -Y,R30
	MOV  R30,R18
	ADD  R30,R16
	SUBI R30,-LOW(1)
	LDI  R31,0
	ST   -Y,R31
	ST   -Y,R30
	MOV  R30,R19
	SUBI R30,-LOW(1)
	LDI  R31,0
	ST   -Y,R31
	ST   -Y,R30
	LDI  R30,LOW(0)
	ST   -Y,R30
	CALL _gfx_Rectangle
; 000B 0129         //    
; 000B 012A     	gfx_FillRect(X, Y - HeaderFont->H - 1, X + W, Y, 0xFF);
	MOV  R30,R16
	LDI  R31,0
	ST   -Y,R31
	ST   -Y,R30
	LDD  R26,Y+19
	LDD  R27,Y+19+1
	ADIW R26,1
	LD   R26,X
	MOV  R30,R19
	SUB  R30,R26
	SUBI R30,LOW(1)
	LDI  R31,0
	ST   -Y,R31
	ST   -Y,R30
	MOV  R30,R18
	ADD  R30,R16
	LDI  R31,0
	ST   -Y,R31
	ST   -Y,R30
	MOV  R30,R19
	LDI  R31,0
	ST   -Y,R31
	ST   -Y,R30
	LDI  R30,LOW(255)
	ST   -Y,R30
	CALL _gfx_FillRect
; 000B 012B         //    
; 000B 012C         gfx_SetXY(X + 1, Y - HeaderFont->H);
	MOV  R30,R16
	SUBI R30,-LOW(1)
	ST   -Y,R30
	LDD  R26,Y+18
	LDD  R27,Y+18+1
	ADIW R26,1
	LD   R26,X
	MOV  R30,R19
	SUB  R30,R26
	ST   -Y,R30
	CALL _gfx_SetXY
; 000B 012D         //  
; 000B 012E         gfx_PutFlashStr(Header, 0x00, HeaderFont);
	LDD  R30,Y+19
	LDD  R31,Y+19+1
	ST   -Y,R31
	ST   -Y,R30
	LDI  R30,LOW(0)
	ST   -Y,R30
	LDD  R30,Y+20
	LDD  R31,Y+20+1
	ST   -Y,R31
	ST   -Y,R30
	CALL _gfx_PutFlashStr
; 000B 012F     }
; 000B 0130 
; 000B 0131     //     .    
; 000B 0132     //  1 ,        
; 000B 0133 	gfx_FillRect(X - 1, Y, X + W + 1, Y + H + 1, 0x00);
_0x160039:
	MOV  R30,R16
	SUBI R30,LOW(1)
	LDI  R31,0
	ST   -Y,R31
	ST   -Y,R30
	MOV  R30,R19
	LDI  R31,0
	ST   -Y,R31
	ST   -Y,R30
	MOV  R30,R18
	ADD  R30,R16
	SUBI R30,-LOW(1)
	LDI  R31,0
	ST   -Y,R31
	ST   -Y,R30
	MOV  R30,R21
	ADD  R30,R19
	SUBI R30,-LOW(1)
	LDI  R31,0
	ST   -Y,R31
	ST   -Y,R30
	LDI  R30,LOW(0)
	ST   -Y,R30
	CALL _gfx_FillRect
; 000B 0134     //     
; 000B 0135 	gfx_Rectangle(X, Y, X + W, Y + H, 0xFF);
	MOV  R30,R16
	LDI  R31,0
	ST   -Y,R31
	ST   -Y,R30
	MOV  R30,R19
	LDI  R31,0
	ST   -Y,R31
	ST   -Y,R30
	MOV  R30,R18
	ADD  R30,R16
	LDI  R31,0
	ST   -Y,R31
	ST   -Y,R30
	MOV  R30,R21
	ADD  R30,R19
	LDI  R31,0
	ST   -Y,R31
	ST   -Y,R30
	LDI  R30,LOW(255)
	ST   -Y,R30
	CALL _gfx_Rectangle
; 000B 0136 
; 000B 0137     //    y, ..      
; 000B 0138     y = Y + FontH/2;
	LDD  R30,Y+10
	LSR  R30
	ADD  R30,R19
	MOV  R20,R30
; 000B 0139     //        
; 000B 013A 	for(i=0; i < N; i++)
	LDI  R17,LOW(0)
_0x16003B:
	LDD  R30,Y+21
	CP   R17,R30
	BRLO PC+3
	JMP _0x16003C
; 000B 013B 	{
; 000B 013C         //     X   
; 000B 013D         X = CenterX - (Strings[i].StrFont->W * Strings[i].Len) / 2;
	MOV  R30,R17
	LDI  R31,0
	LDD  R26,Y+22
	LDD  R27,Y+22+1
	CALL __LSLW3
	ADD  R26,R30
	ADC  R27,R31
	ADIW R26,4
	CALL __GETW1P
	LD   R0,Z
	MOV  R30,R17
	LDI  R31,0
	LDD  R26,Y+22
	LDD  R27,Y+22+1
	CALL __LSLW3
	ADD  R26,R30
	ADC  R27,R31
	ADIW R26,3
	LD   R30,X
	MUL  R30,R0
	MOVW R30,R0
	LSR  R30
	LDD  R26,Y+16
	SUB  R26,R30
	MOV  R16,R26
; 000B 013E         //    
; 000B 013F         gfx_SetXY(X, y);
	ST   -Y,R16
	ST   -Y,R20
	CALL _gfx_SetXY
; 000B 0140 
; 000B 0141         if(Strings[i].Str != NULL)
	MOV  R30,R17
	LDI  R31,0
	LDD  R26,Y+22
	LDD  R27,Y+22+1
	CALL __LSLW3
	ADD  R26,R30
	ADC  R27,R31
	CALL __GETW1P
	SBIW R30,0
	BRNE PC+3
	JMP _0x16003D
; 000B 0142         {
; 000B 0143              //  
; 000B 0144              if(Strings[i].StrPtrType == PTR_FLASH) gfx_PutFlashStr((flash char *)Strings[i].Str, Strings[i].Color, Strings[i].StrFont);
	MOV  R30,R17
	LDI  R31,0
	LDD  R26,Y+22
	LDD  R27,Y+22+1
	CALL __LSLW3
	ADD  R26,R30
	ADC  R27,R31
	ADIW R26,2
	LD   R30,X
	CPI  R30,0
	BRNE _0x16003E
	MOV  R30,R17
	LDI  R31,0
	MOVW R22,R30
	MOVW R0,R30
	LDD  R26,Y+22
	LDD  R27,Y+22+1
	CALL __LSLW3
	ADD  R26,R30
	ADC  R27,R31
	CALL __GETW1P
	ST   -Y,R31
	ST   -Y,R30
	MOVW R30,R0
	LDD  R26,Y+24
	LDD  R27,Y+24+1
	CALL __LSLW3
	ADD  R26,R30
	ADC  R27,R31
	ADIW R26,6
	LD   R30,X
	ST   -Y,R30
	MOVW R30,R22
	LDD  R26,Y+25
	LDD  R27,Y+25+1
	CALL __LSLW3
	ADD  R26,R30
	ADC  R27,R31
	ADIW R26,4
	CALL __GETW1P
	ST   -Y,R31
	ST   -Y,R30
	CALL _gfx_PutFlashStr
; 000B 0145         else if(Strings[i].StrPtrType == PTR_SRAM ) gfx_PutStr((char *)Strings[i].Str, Strings[i].Color, Strings[i].StrFont);
	RJMP _0x16003F
_0x16003E:
	MOV  R30,R17
	LDI  R31,0
	LDD  R26,Y+22
	LDD  R27,Y+22+1
	CALL __LSLW3
	ADD  R26,R30
	ADC  R27,R31
	ADIW R26,2
	LD   R26,X
	CPI  R26,LOW(0x1)
	BRNE _0x160040
	MOV  R30,R17
	LDI  R31,0
	MOVW R22,R30
	MOVW R0,R30
	LDD  R26,Y+22
	LDD  R27,Y+22+1
	CALL __LSLW3
	ADD  R26,R30
	ADC  R27,R31
	CALL __GETW1P
	ST   -Y,R31
	ST   -Y,R30
	MOVW R30,R0
	LDD  R26,Y+24
	LDD  R27,Y+24+1
	CALL __LSLW3
	ADD  R26,R30
	ADC  R27,R31
	ADIW R26,6
	LD   R30,X
	ST   -Y,R30
	MOVW R30,R22
	LDD  R26,Y+25
	LDD  R27,Y+25+1
	CALL __LSLW3
	ADD  R26,R30
	ADC  R27,R31
	ADIW R26,4
	CALL __GETW1P
	ST   -Y,R31
	ST   -Y,R30
	CALL _gfx_PutStr
; 000B 0146         }
_0x160040:
_0x16003F:
; 000B 0147 
; 000B 0148         //   y   
; 000B 0149         y += Strings[i].StrFont->H + Strings[i].VSpace;
_0x16003D:
	MOV  R30,R17
	LDI  R31,0
	LDD  R26,Y+22
	LDD  R27,Y+22+1
	CALL __LSLW3
	ADD  R26,R30
	ADC  R27,R31
	ADIW R26,4
	CALL __GETW1P
	LDD  R0,Z+1
	MOV  R30,R17
	LDI  R31,0
	LDD  R26,Y+22
	LDD  R27,Y+22+1
	CALL __LSLW3
	ADD  R26,R30
	ADC  R27,R31
	ADIW R26,7
	LD   R30,X
	ADD  R30,R0
	ADD  R20,R30
; 000B 014A 	}
	SUBI R17,-1
	RJMP _0x16003B
_0x16003C:
; 000B 014B 
; 000B 014C     //    
; 000B 014D     gfx_Refresh();
	CALL _gfx_Refresh
; 000B 014E }
_0x2060015:
	CALL __LOADLOCR6
	ADIW R28,24
	RET
;
;// *****************************************************************************
;// ***        ********************************************
;// *****************************************************************************
;#define MsgBox__MaxLines 5
;void MsgBoxEx(void * Body, char BodyPtrType, FontProfile * BodyFont,
; 000B 0155               char flash * Header, FontProfile * HeaderFont,
; 000B 0156               unsigned char CenterX, unsigned char CenterY,
; 000B 0157               unsigned char Width, unsigned char Color)  // Width in chars
; 000B 0158 {
_MsgBoxEx:
; 000B 0159     //   
; 000B 015A 	unsigned char i;
; 000B 015B     //     
; 000B 015C     unsigned char X, Y, W, H, StrW;
; 000B 015D     //  
; 000B 015E 	char * p;
; 000B 015F     //    
; 000B 0160 	char * line[MsgBox__MaxLines];
; 000B 0161     //   
; 000B 0162 	unsigned char length[MsgBox__MaxLines];
; 000B 0163     //   
; 000B 0164 	unsigned char count = 0;
; 000B 0165 
; 000B 0166 #ifdef DEBUG
; 000B 0167     printf("MsgBoxEx();\r");
; 000B 0168     delay_ms(1);
; 000B 0169 #endif
; 000B 016A 
; 000B 016B     // 
; 000B 016C     if(Body == NULL) return;                       //      - 
	SBIW R28,18
	LDI  R30,LOW(0)
	ST   Y,R30
	CALL __SAVELOCR6
;	*Body -> Y+35
;	BodyPtrType -> Y+34
;	*BodyFont -> Y+32
;	*Header -> Y+30
;	*HeaderFont -> Y+28
;	CenterX -> Y+27
;	CenterY -> Y+26
;	Width -> Y+25
;	Color -> Y+24
;	i -> R17
;	X -> R16
;	Y -> R19
;	W -> R18
;	H -> R21
;	StrW -> R20
;	*p -> Y+22
;	line -> Y+12
;	length -> Y+7
;	count -> Y+6
	LDD  R30,Y+35
	LDD  R31,Y+35+1
	SBIW R30,0
	BRNE _0x160041
	RJMP _0x2060014
; 000B 016D     if(BodyFont == NULL) BodyFont = &Font_8x12;    //     -   
_0x160041:
	LDD  R30,Y+32
	LDD  R31,Y+32+1
	SBIW R30,0
	BRNE _0x160042
	LDI  R30,LOW(_Font_8x12)
	LDI  R31,HIGH(_Font_8x12)
	STD  Y+32,R30
	STD  Y+32+1,R31
; 000B 016E     if(HeaderFont == NULL) HeaderFont = &Font_4x6; //     -   
_0x160042:
	LDD  R30,Y+28
	LDD  R31,Y+28+1
	SBIW R30,0
	BRNE _0x160043
	LDI  R30,LOW(_Font_4x6)
	LDI  R31,HIGH(_Font_4x6)
	STD  Y+28,R30
	STD  Y+28+1,R31
; 000B 016F 
; 000B 0170     //    ,     
; 000B 0171          if(BodyPtrType == PTR_FLASH) strcpyf(tmpStr, (char flash *)Body);
_0x160043:
	LDD  R30,Y+34
	CPI  R30,0
	BRNE _0x160044
	LDI  R30,LOW(_tmpStr)
	LDI  R31,HIGH(_tmpStr)
	ST   -Y,R31
	ST   -Y,R30
	LDD  R30,Y+37
	LDD  R31,Y+37+1
	ST   -Y,R31
	ST   -Y,R30
	CALL _strcpyf
; 000B 0172     else if(BodyPtrType == PTR_SRAM ) strcpy( tmpStr,       (char *)Body);
	RJMP _0x160045
_0x160044:
	LDD  R26,Y+34
	CPI  R26,LOW(0x1)
	BRNE _0x160046
	LDI  R30,LOW(_tmpStr)
	LDI  R31,HIGH(_tmpStr)
	ST   -Y,R31
	ST   -Y,R30
	LDD  R30,Y+37
	LDD  R31,Y+37+1
	ST   -Y,R31
	ST   -Y,R30
	CALL _strcpy
; 000B 0173 
; 000B 0174     //      
; 000B 0175 	line[count] = tmpStr;
_0x160046:
_0x160045:
	LDD  R30,Y+6
	LDI  R31,0
	MOVW R26,R28
	ADIW R26,12
	LSL  R30
	ROL  R31
	ADD  R26,R30
	ADC  R27,R31
	LDI  R30,LOW(_tmpStr)
	LDI  R31,HIGH(_tmpStr)
	ST   X+,R30
	ST   X,R31
; 000B 0176 
; 000B 0177     //   
; 000B 0178     H = 0;
	LDI  R21,LOW(0)
; 000B 0179     //   
; 000B 017A     W = BodyFont->W * Width;
	LDD  R26,Y+32
	LDD  R27,Y+32+1
	LD   R30,X
	LDD  R26,Y+25
	MUL  R30,R26
	MOV  R18,R0
; 000B 017B 
; 000B 017C     //       
; 000B 017D 	for(;count < MsgBox__MaxLines;)
_0x160048:
	LDD  R26,Y+6
	CPI  R26,LOW(0x5)
	BRLO PC+3
	JMP _0x160049
; 000B 017E 	{
; 000B 017F         //   p         '\n'
; 000B 0180         p = strchr(line[count], '\n');
	LDD  R30,Y+6
	LDI  R31,0
	MOVW R26,R28
	ADIW R26,12
	LSL  R30
	ROL  R31
	ADD  R26,R30
	ADC  R27,R31
	CALL __GETW1P
	ST   -Y,R31
	ST   -Y,R30
	LDI  R30,LOW(10)
	ST   -Y,R30
	CALL _strchr
	STD  Y+22,R30
	STD  Y+22+1,R31
; 000B 0181 
; 000B 0182         //       
; 000B 0183         if(p == NULL)
	SBIW R30,0
	BRNE _0x16004A
; 000B 0184         {
; 000B 0185             //      strlen
; 000B 0186         	length[count] = strlen(line[count]);
	LDD  R30,Y+6
	LDI  R31,0
	MOVW R0,R30
	MOVW R26,R28
	ADIW R26,7
	ADD  R30,R26
	ADC  R31,R27
	PUSH R31
	PUSH R30
	MOVW R30,R0
	MOVW R26,R28
	ADIW R26,12
	LSL  R30
	ROL  R31
	ADD  R26,R30
	ADC  R27,R31
	CALL __GETW1P
	ST   -Y,R31
	ST   -Y,R30
	CALL _strlen
	POP  R26
	POP  R27
	RJMP _0x1600F4
; 000B 0187         }
; 000B 0188         else // 
_0x16004A:
; 000B 0189         {
; 000B 018A             //      
; 000B 018B     		length[count] = p - line[count];
	LDD  R30,Y+6
	LDI  R31,0
	MOVW R0,R30
	MOVW R26,R28
	ADIW R26,7
	ADD  R30,R26
	ADC  R31,R27
	MOVW R22,R30
	MOVW R30,R0
	MOVW R26,R28
	ADIW R26,12
	LSL  R30
	ROL  R31
	ADD  R26,R30
	ADC  R27,R31
	CALL __GETW1P
	LDD  R26,Y+22
	LDD  R27,Y+22+1
	CALL __SWAPW12
	SUB  R30,R26
	SBC  R31,R27
	MOVW R26,R22
	ST   X,R30
; 000B 018C             //    '\n'  '\0',    
; 000B 018D 	    	*p = '\0';
	LDD  R26,Y+22
	LDD  R27,Y+22+1
	LDI  R30,LOW(0)
_0x1600F4:
	ST   X,R30
; 000B 018E         }
; 000B 018F 
; 000B 0190         //     
; 000B 0191         StrW = BodyFont->W * length[count];
	LDD  R26,Y+32
	LDD  R27,Y+32+1
	LD   R0,X
	LDD  R30,Y+6
	LDI  R31,0
	MOVW R26,R28
	ADIW R26,7
	ADD  R26,R30
	ADC  R27,R31
	LD   R30,X
	MOV  R26,R0
	MUL  R30,R26
	MOV  R20,R0
; 000B 0192         //       -  
; 000B 0193 		if(W < StrW) W = StrW;
	CP   R18,R20
	BRSH _0x16004C
	MOV  R18,R20
; 000B 0194         //   
; 000B 0195 		H += BodyFont->H;
_0x16004C:
	LDD  R26,Y+32
	LDD  R27,Y+32+1
	ADIW R26,1
	LD   R30,X
	ADD  R21,R30
; 000B 0196 
; 000B 0197         //   '\n'    -    -   
; 000B 0198         if(p == NULL) break;
	LDD  R30,Y+22
	LDD  R31,Y+22+1
	SBIW R30,0
	BREQ _0x160049
; 000B 0199 
; 000B 019A         //   
; 000B 019B         count++;
	LDD  R30,Y+6
	SUBI R30,-LOW(1)
	STD  Y+6,R30
; 000B 019C         //      
; 000B 019D         line[count] = p + 1;
	LDI  R31,0
	MOVW R26,R28
	ADIW R26,12
	LSL  R30
	ROL  R31
	ADD  R26,R30
	ADC  R27,R31
	LDD  R30,Y+22
	LDD  R31,Y+22+1
	ADIW R30,1
	ST   X+,R30
	ST   X,R31
; 000B 019E 	}
	RJMP _0x160048
_0x160049:
; 000B 019F 
; 000B 01A0     if(Header != NULL)
	LDD  R30,Y+30
	LDD  R31,Y+30+1
	SBIW R30,0
	BREQ _0x16004E
; 000B 01A1     {
; 000B 01A2         //     
; 000B 01A3         StrW = HeaderFont->W * strlenf(Header);
	LDD  R26,Y+28
	LDD  R27,Y+28+1
	LD   R30,X
	PUSH R30
	LDD  R30,Y+30
	LDD  R31,Y+30+1
	ST   -Y,R31
	ST   -Y,R30
	CALL _strlenf
	POP  R26
	MUL  R30,R26
	MOV  R20,R0
; 000B 01A4         //        -  
; 000B 01A5 		if(W < StrW) W = StrW;
	CP   R18,R20
	BRSH _0x16004F
	MOV  R18,R20
; 000B 01A6     }
_0x16004F:
; 000B 01A7 
; 000B 01A8     //            1 
; 000B 01A9 	W += BodyFont->W * 2;
_0x16004E:
	LDD  R26,Y+32
	LDD  R27,Y+32+1
	LD   R30,X
	LSL  R30
	ADD  R18,R30
; 000B 01AA     //            0.5 
; 000B 01AB 	H += BodyFont->H;
	ADIW R26,1
	LD   R30,X
	ADD  R21,R30
; 000B 01AC 
; 000B 01AD     //      
; 000B 01AE 	X = CenterX - W / 2;
	MOV  R30,R18
	LSR  R30
	LDD  R26,Y+27
	SUB  R26,R30
	MOV  R16,R26
; 000B 01AF     //      
; 000B 01B0     Y = CenterY - H / 2;
	MOV  R30,R21
	LSR  R30
	LDD  R26,Y+26
	SUB  R26,R30
	MOV  R19,R26
; 000B 01B1 
; 000B 01B2     // ,  
; 000B 01B3     if(Header != NULL)
	LDD  R30,Y+30
	LDD  R31,Y+30+1
	SBIW R30,0
	BRNE PC+3
	JMP _0x160050
; 000B 01B4     {
; 000B 01B5         //       
; 000B 01B6         Y += HeaderFont->H / 2;
	LDD  R30,Y+28
	LDD  R31,Y+28+1
	LDD  R30,Z+1
	LSR  R30
	ADD  R19,R30
; 000B 01B7         //    
; 000B 01B8         gfx_Rectangle(X - 1, Y - HeaderFont->H - 2, X + W + 1, Y + 1, 0x00);
	MOV  R30,R16
	SUBI R30,LOW(1)
	LDI  R31,0
	ST   -Y,R31
	ST   -Y,R30
	LDD  R26,Y+30
	LDD  R27,Y+30+1
	ADIW R26,1
	LD   R26,X
	MOV  R30,R19
	SUB  R30,R26
	SUBI R30,LOW(2)
	LDI  R31,0
	ST   -Y,R31
	ST   -Y,R30
	MOV  R30,R18
	ADD  R30,R16
	SUBI R30,-LOW(1)
	LDI  R31,0
	ST   -Y,R31
	ST   -Y,R30
	MOV  R30,R19
	SUBI R30,-LOW(1)
	LDI  R31,0
	ST   -Y,R31
	ST   -Y,R30
	LDI  R30,LOW(0)
	ST   -Y,R30
	CALL _gfx_Rectangle
; 000B 01B9         //    
; 000B 01BA     	gfx_FillRect(X, Y - HeaderFont->H - 1, X + W, Y, 0xFF);
	MOV  R30,R16
	LDI  R31,0
	ST   -Y,R31
	ST   -Y,R30
	LDD  R26,Y+30
	LDD  R27,Y+30+1
	ADIW R26,1
	LD   R26,X
	MOV  R30,R19
	SUB  R30,R26
	SUBI R30,LOW(1)
	LDI  R31,0
	ST   -Y,R31
	ST   -Y,R30
	MOV  R30,R18
	ADD  R30,R16
	LDI  R31,0
	ST   -Y,R31
	ST   -Y,R30
	MOV  R30,R19
	LDI  R31,0
	ST   -Y,R31
	ST   -Y,R30
	LDI  R30,LOW(255)
	ST   -Y,R30
	CALL _gfx_FillRect
; 000B 01BB         //    
; 000B 01BC         gfx_SetXY(X + 1, Y - HeaderFont->H);
	MOV  R30,R16
	SUBI R30,-LOW(1)
	ST   -Y,R30
	LDD  R26,Y+29
	LDD  R27,Y+29+1
	ADIW R26,1
	LD   R26,X
	MOV  R30,R19
	SUB  R30,R26
	ST   -Y,R30
	CALL _gfx_SetXY
; 000B 01BD         //  
; 000B 01BE         gfx_PutFlashStr(Header, 0x00, HeaderFont);
	LDD  R30,Y+30
	LDD  R31,Y+30+1
	ST   -Y,R31
	ST   -Y,R30
	LDI  R30,LOW(0)
	ST   -Y,R30
	LDD  R30,Y+31
	LDD  R31,Y+31+1
	ST   -Y,R31
	ST   -Y,R30
	CALL _gfx_PutFlashStr
; 000B 01BF     }
; 000B 01C0 
; 000B 01C1     //     .    
; 000B 01C2     //  1 ,        
; 000B 01C3 	gfx_FillRect(X - 1, Y, X + W + 1, Y + H + 1, 0x00);
_0x160050:
	MOV  R30,R16
	SUBI R30,LOW(1)
	LDI  R31,0
	ST   -Y,R31
	ST   -Y,R30
	MOV  R30,R19
	LDI  R31,0
	ST   -Y,R31
	ST   -Y,R30
	MOV  R30,R18
	ADD  R30,R16
	SUBI R30,-LOW(1)
	LDI  R31,0
	ST   -Y,R31
	ST   -Y,R30
	MOV  R30,R21
	ADD  R30,R19
	SUBI R30,-LOW(1)
	LDI  R31,0
	ST   -Y,R31
	ST   -Y,R30
	LDI  R30,LOW(0)
	ST   -Y,R30
	CALL _gfx_FillRect
; 000B 01C4     //     
; 000B 01C5 	gfx_Rectangle(X, Y, X + W, Y + H, 0xFF);
	MOV  R30,R16
	LDI  R31,0
	ST   -Y,R31
	ST   -Y,R30
	MOV  R30,R19
	LDI  R31,0
	ST   -Y,R31
	ST   -Y,R30
	MOV  R30,R18
	ADD  R30,R16
	LDI  R31,0
	ST   -Y,R31
	ST   -Y,R30
	MOV  R30,R21
	ADD  R30,R19
	LDI  R31,0
	ST   -Y,R31
	ST   -Y,R30
	LDI  R30,LOW(255)
	ST   -Y,R30
	CALL _gfx_Rectangle
; 000B 01C6 
; 000B 01C7     //        
; 000B 01C8 	for(i=0; i < count + 1; i++)
	LDI  R17,LOW(0)
_0x160052:
	LDD  R30,Y+6
	SUBI R30,-LOW(1)
	CP   R17,R30
	BRLO PC+3
	JMP _0x160053
; 000B 01C9 	{
; 000B 01CA         //     0 -   
; 000B 01CB 		if(length[i] != 0)
	MOV  R30,R17
	LDI  R31,0
	MOVW R26,R28
	ADIW R26,7
	ADD  R26,R30
	ADC  R27,R31
	LD   R30,X
	CPI  R30,0
	BREQ _0x160054
; 000B 01CC 		{
; 000B 01CD             //     X   
; 000B 01CE             X = CenterX - (BodyFont->W * length[i]) / 2;
	LDD  R26,Y+32
	LDD  R27,Y+32+1
	LD   R0,X
	MOV  R30,R17
	LDI  R31,0
	MOVW R26,R28
	ADIW R26,7
	ADD  R26,R30
	ADC  R27,R31
	LD   R30,X
	MUL  R30,R0
	MOVW R30,R0
	LSR  R30
	LDD  R26,Y+27
	SUB  R26,R30
	MOV  R16,R26
; 000B 01CF             //    
; 000B 01D0             gfx_SetXY(X, Y + BodyFont->H/2 + i * BodyFont->H);
	ST   -Y,R16
	LDD  R30,Y+33
	LDD  R31,Y+33+1
	LDD  R30,Z+1
	LSR  R30
	ADD  R30,R19
	MOV  R22,R30
	LDD  R26,Y+33
	LDD  R27,Y+33+1
	ADIW R26,1
	LD   R30,X
	MUL  R30,R17
	MOVW R30,R0
	ADD  R30,R22
	ST   -Y,R30
	CALL _gfx_SetXY
; 000B 01D1             //  
; 000B 01D2 			gfx_PutStr(line[i], Color, BodyFont);
	MOV  R30,R17
	LDI  R31,0
	MOVW R26,R28
	ADIW R26,12
	LSL  R30
	ROL  R31
	ADD  R26,R30
	ADC  R27,R31
	CALL __GETW1P
	ST   -Y,R31
	ST   -Y,R30
	LDD  R30,Y+26
	ST   -Y,R30
	LDD  R30,Y+35
	LDD  R31,Y+35+1
	ST   -Y,R31
	ST   -Y,R30
	CALL _gfx_PutStr
; 000B 01D3 		}
; 000B 01D4 	}
_0x160054:
	SUBI R17,-1
	RJMP _0x160052
_0x160053:
; 000B 01D5 
; 000B 01D6     //    
; 000B 01D7     gfx_Refresh();
	CALL _gfx_Refresh
; 000B 01D8 }
_0x2060014:
	CALL __LOADLOCR6
	ADIW R28,37
	RET
;
;// *****************************************************************************
;// ***         (  FLASH)   *********
;// *****************************************************************************
;inline void MsgBoxF(char flash * Body, FontProfile * BodyFont, char flash * Header, FontProfile * HeaderFont)
; 000B 01DE {
_MsgBoxF:
; 000B 01DF     MsgBoxEx((void *)Body, PTR_FLASH, BodyFont, Header, HeaderFont, WidthS/2, HeightS/2, 0, 0xFF);
;	*Body -> Y+6
;	*BodyFont -> Y+4
;	*Header -> Y+2
;	*HeaderFont -> Y+0
	LDD  R30,Y+6
	LDD  R31,Y+6+1
	ST   -Y,R31
	ST   -Y,R30
	LDI  R30,LOW(0)
	ST   -Y,R30
	LDD  R30,Y+7
	LDD  R31,Y+7+1
	ST   -Y,R31
	ST   -Y,R30
	LDD  R30,Y+7
	LDD  R31,Y+7+1
	ST   -Y,R31
	ST   -Y,R30
	LDD  R30,Y+7
	LDD  R31,Y+7+1
	ST   -Y,R31
	ST   -Y,R30
	LDI  R30,LOW(64)
	ST   -Y,R30
	LDI  R30,LOW(32)
	ST   -Y,R30
	LDI  R30,LOW(0)
	ST   -Y,R30
	LDI  R30,LOW(255)
	ST   -Y,R30
	RCALL _MsgBoxEx
; 000B 01E0 }
	ADIW R28,8
	RET
;
;// *****************************************************************************
;// ***         (  SRAM)  ************
;// *****************************************************************************
;inline void MsgBox(char * Body, FontProfile * BodyFont, char flash * Header, FontProfile * HeaderFont)
; 000B 01E6 {
; 000B 01E7     MsgBoxEx((void *)Body, PTR_SRAM, BodyFont, Header, HeaderFont, WidthS/2, HeightS/2, 0, 0xFF);
;	*Body -> Y+6
;	*BodyFont -> Y+4
;	*Header -> Y+2
;	*HeaderFont -> Y+0
; 000B 01E8 }
;
;// *****************************************************************************
;// ***         ***********************************************
;// *****************************************************************************
;char SelectBoxEx(void ** Body, unsigned char BodyPtrType, unsigned char N, unsigned char Selected, FontProfile * BodyFont,
; 000B 01EE                  char flash * Header, FontProfile * HeaderFont,
; 000B 01EF                  unsigned char CenterX, unsigned char CenterY)
; 000B 01F0 {
_SelectBoxEx:
; 000B 01F1     //   
; 000B 01F2 	unsigned char i;
; 000B 01F3     //     
; 000B 01F4     unsigned char Color;
; 000B 01F5 
; 000B 01F6     unsigned char Pos = 0;
; 000B 01F7     unsigned char StrCount = 0;
; 000B 01F8     //     
; 000B 01F9     unsigned char X, Y, W, H, x, strLen, StrW;
; 000B 01FA     //     
; 000B 01FB     unsigned char Kbd = 0;
; 000B 01FC 
; 000B 01FD #ifdef DEBUG
; 000B 01FE     printf("SelectBoxEx();\r");
; 000B 01FF     delay_ms(1);
; 000B 0200 #endif
; 000B 0201 
; 000B 0202     // 
; 000B 0203     if(Body == NULL) return;                       //      - 
	SBIW R28,6
	LDI  R30,LOW(0)
	ST   Y,R30
	CALL __SAVELOCR6
;	*Body -> Y+23
;	BodyPtrType -> Y+22
;	N -> Y+21
;	Selected -> Y+20
;	*BodyFont -> Y+18
;	*Header -> Y+16
;	*HeaderFont -> Y+14
;	CenterX -> Y+13
;	CenterY -> Y+12
;	i -> R17
;	Color -> R16
;	Pos -> R19
;	StrCount -> R18
;	X -> R21
;	Y -> R20
;	W -> Y+11
;	H -> Y+10
;	x -> Y+9
;	strLen -> Y+8
;	StrW -> Y+7
;	Kbd -> Y+6
	LDI  R19,0
	LDI  R18,0
	LDD  R30,Y+23
	LDD  R31,Y+23+1
	SBIW R30,0
	BRNE _0x160055
	LDI  R30,LOW(0)
	RJMP _0x2060013
; 000B 0204     if(BodyFont == NULL) BodyFont = &Font_8x12;    //     -   
_0x160055:
	LDD  R30,Y+18
	LDD  R31,Y+18+1
	SBIW R30,0
	BRNE _0x160056
	LDI  R30,LOW(_Font_8x12)
	LDI  R31,HIGH(_Font_8x12)
	STD  Y+18,R30
	STD  Y+18+1,R31
; 000B 0205     if(HeaderFont == NULL) HeaderFont = &Font_4x6; //     -   
_0x160056:
	LDD  R30,Y+14
	LDD  R31,Y+14+1
	SBIW R30,0
	BRNE _0x160057
	LDI  R30,LOW(_Font_4x6)
	LDI  R31,HIGH(_Font_4x6)
	STD  Y+14,R30
	STD  Y+14+1,R31
; 000B 0206 
; 000B 0207     //     
; 000B 0208     W = 0;
_0x160057:
	LDI  R30,LOW(0)
	STD  Y+11,R30
; 000B 0209     H = 0;
	STD  Y+10,R30
; 000B 020A 
; 000B 020B     StrCount = (HeightS - HeaderFont->H - BodyFont->H / 2) / BodyFont->H;
	LDD  R26,Y+14
	LDD  R27,Y+14+1
	ADIW R26,1
	LD   R26,X
	LDI  R30,LOW(64)
	SUB  R30,R26
	MOV  R26,R30
	LDD  R30,Y+18
	LDD  R31,Y+18+1
	LDD  R30,Z+1
	LSR  R30
	SUB  R26,R30
	MOV  R0,R26
	LDD  R26,Y+18
	LDD  R27,Y+18+1
	ADIW R26,1
	LD   R30,X
	MOV  R26,R0
	CALL __DIVB21U
	MOV  R18,R30
; 000B 020C 
; 000B 020D     //       
; 000B 020E 	for(i = 0; i < N; i++)
	LDI  R17,LOW(0)
_0x160059:
	LDD  R30,Y+21
	CP   R17,R30
	BRLO PC+3
	JMP _0x16005A
; 000B 020F 	{
; 000B 0210         //      strlen
; 000B 0211              if(BodyPtrType == PTR_FLASH) strLen = strlenf(((char flash **)Body)[i]);
	LDD  R30,Y+22
	CPI  R30,0
	BRNE _0x16005B
	MOV  R30,R17
	LDD  R26,Y+23
	LDD  R27,Y+23+1
	LDI  R31,0
	LSL  R30
	ROL  R31
	ADD  R26,R30
	ADC  R27,R31
	CALL __GETW1P
	ST   -Y,R31
	ST   -Y,R30
	CALL _strlenf
	RJMP _0x1600F5
; 000B 0212         else if(BodyPtrType == PTR_SRAM ) strLen = strlen(((char **)Body)[i]);
_0x16005B:
	LDD  R26,Y+22
	CPI  R26,LOW(0x1)
	BRNE _0x16005D
	MOV  R30,R17
	LDD  R26,Y+23
	LDD  R27,Y+23+1
	LDI  R31,0
	LSL  R30
	ROL  R31
	ADD  R26,R30
	ADC  R27,R31
	CALL __GETW1P
	ST   -Y,R31
	ST   -Y,R30
	CALL _strlen
_0x1600F5:
	STD  Y+8,R30
; 000B 0213 
; 000B 0214         //     
; 000B 0215         StrW = BodyFont->W * strLen;
_0x16005D:
	LDD  R26,Y+18
	LDD  R27,Y+18+1
	LD   R30,X
	LDD  R26,Y+8
	MUL  R30,R26
	MOVW R30,R0
	STD  Y+7,R30
; 000B 0216         //       -  
; 000B 0217 		if(W < StrW) W = StrW;
	LDD  R26,Y+11
	CP   R26,R30
	BRSH _0x16005E
	STD  Y+11,R30
; 000B 0218         //   
; 000B 0219 		if(i < StrCount) H += BodyFont->H;
_0x16005E:
	CP   R17,R18
	BRSH _0x16005F
	LDD  R26,Y+18
	LDD  R27,Y+18+1
	ADIW R26,1
	LD   R30,X
	LDD  R26,Y+10
	ADD  R30,R26
	STD  Y+10,R30
; 000B 021A 	}
_0x16005F:
	SUBI R17,-1
	RJMP _0x160059
_0x16005A:
; 000B 021B 
; 000B 021C     if(StrCount > N) StrCount = N;
	LDD  R30,Y+21
	CP   R30,R18
	BRSH _0x160060
	LDD  R18,Y+21
; 000B 021D 
; 000B 021E     if(Header != NULL)
_0x160060:
	LDD  R30,Y+16
	LDD  R31,Y+16+1
	SBIW R30,0
	BREQ _0x160061
; 000B 021F     {
; 000B 0220         //     
; 000B 0221         StrW = HeaderFont->W * strlenf(Header);
	LDD  R26,Y+14
	LDD  R27,Y+14+1
	LD   R30,X
	PUSH R30
	LDD  R30,Y+16
	LDD  R31,Y+16+1
	ST   -Y,R31
	ST   -Y,R30
	CALL _strlenf
	POP  R26
	MUL  R30,R26
	MOVW R30,R0
	STD  Y+7,R30
; 000B 0222         //        -  
; 000B 0223 		if(W < StrW) W = StrW;
	LDD  R26,Y+11
	CP   R26,R30
	BRSH _0x160062
	STD  Y+11,R30
; 000B 0224     }
_0x160062:
; 000B 0225 
; 000B 0226     //            1 
; 000B 0227 	W += BodyFont->W * 2;
_0x160061:
	LDD  R26,Y+18
	LDD  R27,Y+18+1
	LD   R30,X
	LSL  R30
	LDD  R26,Y+11
	ADD  R30,R26
	STD  Y+11,R30
; 000B 0228     //            0.25 
; 000B 0229 	H += BodyFont->H / 2;
	LDD  R30,Y+18
	LDD  R31,Y+18+1
	LDD  R30,Z+1
	LSR  R30
	LDD  R26,Y+10
	ADD  R30,R26
	STD  Y+10,R30
; 000B 022A 
; 000B 022B     //      
; 000B 022C 	X = CenterX - W / 2;
	LDD  R30,Y+11
	LSR  R30
	LDD  R26,Y+13
	SUB  R26,R30
	MOV  R21,R26
; 000B 022D     //      
; 000B 022E     Y = CenterY - H / 2;
	LDD  R30,Y+10
	LSR  R30
	LDD  R26,Y+12
	SUB  R26,R30
	MOV  R20,R26
; 000B 022F 
; 000B 0230     // ,  
; 000B 0231     if(Header != NULL)
	LDD  R30,Y+16
	LDD  R31,Y+16+1
	SBIW R30,0
	BRNE PC+3
	JMP _0x160063
; 000B 0232     {
; 000B 0233         //       
; 000B 0234         Y += HeaderFont->H / 2;
	LDD  R30,Y+14
	LDD  R31,Y+14+1
	LDD  R30,Z+1
	LSR  R30
	ADD  R20,R30
; 000B 0235         //    
; 000B 0236         gfx_Rectangle(X - 1, Y - HeaderFont->H - 2, X + W + 1, Y + 1, 0x00);
	MOV  R30,R21
	SUBI R30,LOW(1)
	LDI  R31,0
	ST   -Y,R31
	ST   -Y,R30
	LDD  R26,Y+16
	LDD  R27,Y+16+1
	ADIW R26,1
	LD   R26,X
	MOV  R30,R20
	SUB  R30,R26
	SUBI R30,LOW(2)
	LDI  R31,0
	ST   -Y,R31
	ST   -Y,R30
	LDD  R30,Y+15
	ADD  R30,R21
	SUBI R30,-LOW(1)
	LDI  R31,0
	ST   -Y,R31
	ST   -Y,R30
	MOV  R30,R20
	SUBI R30,-LOW(1)
	LDI  R31,0
	ST   -Y,R31
	ST   -Y,R30
	LDI  R30,LOW(0)
	ST   -Y,R30
	CALL _gfx_Rectangle
; 000B 0237         //    
; 000B 0238     	gfx_FillRect(X, Y - HeaderFont->H - 1, X + W, Y, 0xFF);
	MOV  R30,R21
	LDI  R31,0
	ST   -Y,R31
	ST   -Y,R30
	LDD  R26,Y+16
	LDD  R27,Y+16+1
	ADIW R26,1
	LD   R26,X
	MOV  R30,R20
	SUB  R30,R26
	SUBI R30,LOW(1)
	LDI  R31,0
	ST   -Y,R31
	ST   -Y,R30
	LDD  R30,Y+15
	ADD  R30,R21
	LDI  R31,0
	ST   -Y,R31
	ST   -Y,R30
	MOV  R30,R20
	LDI  R31,0
	ST   -Y,R31
	ST   -Y,R30
	LDI  R30,LOW(255)
	ST   -Y,R30
	CALL _gfx_FillRect
; 000B 0239         //    
; 000B 023A         gfx_SetXY(X + 1, Y - HeaderFont->H);
	MOV  R30,R21
	SUBI R30,-LOW(1)
	ST   -Y,R30
	LDD  R26,Y+15
	LDD  R27,Y+15+1
	ADIW R26,1
	LD   R26,X
	MOV  R30,R20
	SUB  R30,R26
	ST   -Y,R30
	CALL _gfx_SetXY
; 000B 023B         //  
; 000B 023C         gfx_PutFlashStr(Header, 0x00, HeaderFont);
	LDD  R30,Y+16
	LDD  R31,Y+16+1
	ST   -Y,R31
	ST   -Y,R30
	LDI  R30,LOW(0)
	ST   -Y,R30
	LDD  R30,Y+17
	LDD  R31,Y+17+1
	ST   -Y,R31
	ST   -Y,R30
	CALL _gfx_PutFlashStr
; 000B 023D     }
; 000B 023E 
; 000B 023F     if(Selected > Pos + StrCount - 1) Pos = Selected + 1 - StrCount;
_0x160063:
	MOV  R30,R18
	ADD  R30,R19
	SUBI R30,LOW(1)
	LDD  R26,Y+20
	CP   R30,R26
	BRSH _0x160064
	LDD  R30,Y+20
	SUBI R30,-LOW(1)
	SUB  R30,R18
	MOV  R19,R30
; 000B 0240 
; 000B 0241     do
_0x160064:
_0x160066:
; 000B 0242     {
; 000B 0243         //     
; 000B 0244 	    gfx_FillRect(X - 1, Y, X + W + 1, Y + H + 1, 0x00);
	MOV  R30,R21
	SUBI R30,LOW(1)
	LDI  R31,0
	ST   -Y,R31
	ST   -Y,R30
	MOV  R30,R20
	LDI  R31,0
	ST   -Y,R31
	ST   -Y,R30
	LDD  R30,Y+15
	ADD  R30,R21
	SUBI R30,-LOW(1)
	LDI  R31,0
	ST   -Y,R31
	ST   -Y,R30
	LDD  R30,Y+16
	ADD  R30,R20
	SUBI R30,-LOW(1)
	LDI  R31,0
	ST   -Y,R31
	ST   -Y,R30
	LDI  R30,LOW(0)
	ST   -Y,R30
	CALL _gfx_FillRect
; 000B 0245         //     
; 000B 0246 	    gfx_Rectangle(X, Y, X + W, Y + H, 0xFF);
	MOV  R30,R21
	LDI  R31,0
	ST   -Y,R31
	ST   -Y,R30
	MOV  R30,R20
	LDI  R31,0
	ST   -Y,R31
	ST   -Y,R30
	LDD  R30,Y+15
	ADD  R30,R21
	LDI  R31,0
	ST   -Y,R31
	ST   -Y,R30
	LDD  R30,Y+16
	ADD  R30,R20
	LDI  R31,0
	ST   -Y,R31
	ST   -Y,R30
	LDI  R30,LOW(255)
	ST   -Y,R30
	CALL _gfx_Rectangle
; 000B 0247 
; 000B 0248         //        
; 000B 0249 	    for(i=Pos; i < Pos + StrCount; i++)
	MOV  R17,R19
_0x160069:
	MOV  R30,R18
	ADD  R30,R19
	CP   R17,R30
	BRLO PC+3
	JMP _0x16006A
; 000B 024A 	    {
; 000B 024B             //   -    
; 000B 024C             if(i == Selected) Color = 0x00;
	LDD  R30,Y+20
	CP   R30,R17
	BRNE _0x16006B
	LDI  R16,LOW(0)
; 000B 024D             else              Color = 0xFF;
	RJMP _0x16006C
_0x16006B:
	LDI  R16,LOW(255)
; 000B 024E             //      strlen
; 000B 024F                  if(BodyPtrType == PTR_FLASH) strLen = strlenf(((char flash **)Body)[i]);
_0x16006C:
	LDD  R30,Y+22
	CPI  R30,0
	BRNE _0x16006D
	MOV  R30,R17
	LDD  R26,Y+23
	LDD  R27,Y+23+1
	LDI  R31,0
	LSL  R30
	ROL  R31
	ADD  R26,R30
	ADC  R27,R31
	CALL __GETW1P
	ST   -Y,R31
	ST   -Y,R30
	CALL _strlenf
	RJMP _0x1600F6
; 000B 0250             else if(BodyPtrType == PTR_SRAM ) strLen = strlen(((char **)Body)[i]);
_0x16006D:
	LDD  R26,Y+22
	CPI  R26,LOW(0x1)
	BRNE _0x16006F
	MOV  R30,R17
	LDD  R26,Y+23
	LDD  R27,Y+23+1
	LDI  R31,0
	LSL  R30
	ROL  R31
	ADD  R26,R30
	ADC  R27,R31
	CALL __GETW1P
	ST   -Y,R31
	ST   -Y,R30
	CALL _strlen
_0x1600F6:
	STD  Y+8,R30
; 000B 0251             //     X   
; 000B 0252             x = CenterX - (BodyFont->W * strLen) / 2;
_0x16006F:
	LDD  R26,Y+18
	LDD  R27,Y+18+1
	LD   R30,X
	LDD  R26,Y+8
	MUL  R30,R26
	MOVW R30,R0
	LSR  R30
	LDD  R26,Y+13
	SUB  R26,R30
	STD  Y+9,R26
; 000B 0253             //    
; 000B 0254             gfx_SetXY(x, Y + BodyFont->H/4 + (i - Pos) * BodyFont->H);
	LDD  R30,Y+9
	ST   -Y,R30
	LDD  R30,Y+19
	LDD  R31,Y+19+1
	LDD  R30,Z+1
	LSR  R30
	LSR  R30
	ADD  R30,R20
	MOV  R22,R30
	MOV  R30,R17
	SUB  R30,R19
	MOV  R0,R30
	LDD  R26,Y+19
	LDD  R27,Y+19+1
	ADIW R26,1
	LD   R30,X
	MUL  R30,R0
	MOVW R30,R0
	ADD  R30,R22
	ST   -Y,R30
	CALL _gfx_SetXY
; 000B 0255             //  
; 000B 0256                  if(BodyPtrType == PTR_FLASH) gfx_PutFlashStr(((char flash **)Body)[i], Color, BodyFont);
	LDD  R30,Y+22
	CPI  R30,0
	BRNE _0x160070
	MOV  R30,R17
	LDD  R26,Y+23
	LDD  R27,Y+23+1
	LDI  R31,0
	LSL  R30
	ROL  R31
	ADD  R26,R30
	ADC  R27,R31
	CALL __GETW1P
	ST   -Y,R31
	ST   -Y,R30
	ST   -Y,R16
	LDD  R30,Y+21
	LDD  R31,Y+21+1
	ST   -Y,R31
	ST   -Y,R30
	CALL _gfx_PutFlashStr
; 000B 0257             else if(BodyPtrType == PTR_SRAM ) gfx_PutStr(     ((char **)Body)[i], Color, BodyFont);
	RJMP _0x160071
_0x160070:
	LDD  R26,Y+22
	CPI  R26,LOW(0x1)
	BRNE _0x160072
	MOV  R30,R17
	LDD  R26,Y+23
	LDD  R27,Y+23+1
	LDI  R31,0
	LSL  R30
	ROL  R31
	ADD  R26,R30
	ADC  R27,R31
	CALL __GETW1P
	ST   -Y,R31
	ST   -Y,R30
	ST   -Y,R16
	LDD  R30,Y+21
	LDD  R31,Y+21+1
	ST   -Y,R31
	ST   -Y,R30
	CALL _gfx_PutStr
; 000B 0258 	    }
_0x160072:
_0x160071:
	SUBI R17,-1
	RJMP _0x160069
_0x16006A:
; 000B 0259         //    
; 000B 025A         gfx_Refresh();
	CALL _gfx_Refresh
; 000B 025B 
; 000B 025C         //   
; 000B 025D         WaitEmptyButtons(10);
	LDI  R30,LOW(10)
	ST   -Y,R30
	CALL _WaitEmptyButtons
; 000B 025E         //   
; 000B 025F         Kbd = WaitButtonPress(0);
	LDI  R30,LOW(0)
	ST   -Y,R30
	CALL _WaitButtonPress
	STD  Y+6,R30
; 000B 0260 
; 000B 0261         //   ,     
; 000B 0262         if((Kbd & B_UP)   && (Selected > 0))     Selected--;
	ANDI R30,LOW(0x1)
	BREQ _0x160074
	LDD  R26,Y+20
	CPI  R26,LOW(0x1)
	BRSH _0x160075
_0x160074:
	RJMP _0x160073
_0x160075:
	LDD  R30,Y+20
	SUBI R30,LOW(1)
	STD  Y+20,R30
; 000B 0263         if((Kbd & B_DOWN) && (Selected < N - 1)) Selected++;
_0x160073:
	LDD  R30,Y+6
	ANDI R30,LOW(0x2)
	BREQ _0x160077
	LDD  R30,Y+21
	SUBI R30,LOW(1)
	LDD  R26,Y+20
	CP   R26,R30
	BRLO _0x160078
_0x160077:
	RJMP _0x160076
_0x160078:
	LDD  R30,Y+20
	SUBI R30,-LOW(1)
	STD  Y+20,R30
; 000B 0264 
; 000B 0265         if(Selected > Pos + StrCount - 1) Pos++;
_0x160076:
	MOV  R30,R18
	ADD  R30,R19
	SUBI R30,LOW(1)
	LDD  R26,Y+20
	CP   R30,R26
	BRSH _0x160079
	SUBI R19,-1
; 000B 0266         if(Selected < Pos) Pos--;
_0x160079:
	LDD  R26,Y+20
	CP   R26,R19
	BRSH _0x16007A
	SUBI R19,1
; 000B 0267     }
_0x16007A:
; 000B 0268     while(!(Kbd & (B_BACK | B_ENTER)));
	LDD  R30,Y+6
	ANDI R30,LOW(0x30)
	BRNE _0x160067
	RJMP _0x160066
_0x160067:
; 000B 0269 
; 000B 026A     //   ENTER   
; 000B 026B     if(Kbd & B_ENTER) return(Selected);
	LDD  R30,Y+6
	ANDI R30,LOW(0x20)
	BREQ _0x16007B
	LDD  R30,Y+20
	RJMP _0x2060013
; 000B 026C     //   -1
; 000B 026D     return(-1);
_0x16007B:
	LDI  R30,LOW(255)
_0x2060013:
	CALL __LOADLOCR6
	ADIW R28,25
	RET
; 000B 026E }
;
;// *****************************************************************************
;// ***         ***********************************************
;// *****************************************************************************
;inline char SelectBoxF(flash char ** Body, unsigned char N,  unsigned char Selected, FontProfile * BodyFont,
; 000B 0274                        char flash * Header, FontProfile * HeaderFont)
; 000B 0275 {
_SelectBoxF:
; 000B 0276     return(SelectBoxEx((void **)Body, PTR_FLASH, N, Selected, BodyFont, Header, HeaderFont, WidthS/2, HeightS/2));
;	*Body -> Y+8
;	N -> Y+7
;	Selected -> Y+6
;	*BodyFont -> Y+4
;	*Header -> Y+2
;	*HeaderFont -> Y+0
	LDD  R30,Y+8
	LDD  R31,Y+8+1
	ST   -Y,R31
	ST   -Y,R30
	LDI  R30,LOW(0)
	RJMP _0x2060012
; 000B 0277 }
;
;// *****************************************************************************
;// ***         ***********************************************
;// *****************************************************************************
;inline char SelectBox(char ** Body, unsigned char N,  unsigned char Selected, FontProfile * BodyFont,
; 000B 027D                       char flash * Header, FontProfile * HeaderFont)
; 000B 027E {
_SelectBox:
; 000B 027F     return(SelectBoxEx((void **)Body, PTR_SRAM, N, Selected, BodyFont, Header, HeaderFont, WidthS/2, HeightS/2));
;	*Body -> Y+8
;	N -> Y+7
;	Selected -> Y+6
;	*BodyFont -> Y+4
;	*Header -> Y+2
;	*HeaderFont -> Y+0
	LDD  R30,Y+8
	LDD  R31,Y+8+1
	ST   -Y,R31
	ST   -Y,R30
	LDI  R30,LOW(1)
_0x2060012:
	ST   -Y,R30
	LDD  R30,Y+10
	ST   -Y,R30
	LDD  R30,Y+10
	ST   -Y,R30
	LDD  R30,Y+9
	LDD  R31,Y+9+1
	ST   -Y,R31
	ST   -Y,R30
	LDD  R30,Y+9
	LDD  R31,Y+9+1
	ST   -Y,R31
	ST   -Y,R30
	LDD  R30,Y+9
	LDD  R31,Y+9+1
	ST   -Y,R31
	ST   -Y,R30
	LDI  R30,LOW(64)
	ST   -Y,R30
	LDI  R30,LOW(32)
	ST   -Y,R30
	RCALL _SelectBoxEx
	ADIW R28,10
	RET
; 000B 0280 }
;
;// *****************************************************************************
;// ***           *****************
;// *****************************************************************************
;char EditNumDlg(void * Val, char PtrType, int Min, int Max, char N, char flash * Header)
; 000B 0286 {
_EditNumDlg:
; 000B 0287     //        
; 000B 0288     int BackUp;
; 000B 0289     //     switch'
; 000B 028A     int tmp;
; 000B 028B     //    
; 000B 028C     unsigned char Kbd = 0;
; 000B 028D 
; 000B 028E #ifdef DEBUG
; 000B 028F     printf("EditNumDlg();\r");
; 000B 0290     delay_ms(1);
; 000B 0291 #endif
; 000B 0292 
; 000B 0293     // 
; 000B 0294     if(Val == NULL) return;
	CALL __SAVELOCR6
;	*Val -> Y+14
;	PtrType -> Y+13
;	Min -> Y+11
;	Max -> Y+9
;	N -> Y+8
;	*Header -> Y+6
;	BackUp -> R16,R17
;	tmp -> R18,R19
;	Kbd -> R21
	LDI  R21,0
	LDD  R30,Y+14
	LDD  R31,Y+14+1
	SBIW R30,0
	BRNE _0x16007C
	LDI  R30,LOW(0)
	RJMP _0x2060011
; 000B 0295 
; 000B 0296     //        
; 000B 0297     switch(PtrType)
_0x16007C:
	LDD  R30,Y+13
; 000B 0298     {
; 000B 0299         case (PTR_CHAR):
	CPI  R30,LOW(0x3)
	BRNE _0x160080
; 000B 029A             BackUp = (int)*((char *)Val);
	LDD  R26,Y+14
	LDD  R27,Y+14+1
	LD   R30,X
	LDI  R31,0
	SBRC R30,7
	SER  R31
	MOVW R16,R30
; 000B 029B             break;
	RJMP _0x16007F
; 000B 029C 
; 000B 029D         case (PTR_UCHAR):
_0x160080:
	CPI  R30,LOW(0x4)
	BRNE _0x160081
; 000B 029E             BackUp = (int)*((unsigned char *)Val);
	LDD  R26,Y+14
	LDD  R27,Y+14+1
	LD   R16,X
	CLR  R17
; 000B 029F             break;
	RJMP _0x16007F
; 000B 02A0 
; 000B 02A1         case (PTR_INT):
_0x160081:
	CPI  R30,LOW(0x5)
	BRNE _0x160083
; 000B 02A2             BackUp = *((int *)Val);
	LDD  R26,Y+14
	LDD  R27,Y+14+1
	LD   R16,X+
	LD   R17,X
; 000B 02A3             break;
	RJMP _0x16007F
; 000B 02A4 
; 000B 02A5         default:
_0x160083:
; 000B 02A6             //      
; 000B 02A7 #ifdef DEBUG
; 000B 02A8             printf("EditNumDlg(): unknown PtrType(%d)\r", PtrType);
; 000B 02A9             delay_ms(1);
; 000B 02AA #endif
; 000B 02AB             return;
	LDI  R30,LOW(0)
	RJMP _0x2060011
; 000B 02AC     }
_0x16007F:
; 000B 02AD 
; 000B 02AE     tmp = BackUp;
	MOVW R18,R16
; 000B 02AF 
; 000B 02B0     do
_0x160085:
; 000B 02B1     {
; 000B 02B2         //     
; 000B 02B3         sprintf(tmpBuf, "%d", tmp);
	LDI  R30,LOW(_tmpBuf)
	LDI  R31,HIGH(_tmpBuf)
	ST   -Y,R31
	ST   -Y,R30
	__POINTW1FN _0x160000,0
	ST   -Y,R31
	ST   -Y,R30
	MOVW R30,R18
	CALL __CWD1
	CALL __PUTPARD1
	LDI  R24,4
	CALL _sprintf
	ADIW R28,8
; 000B 02B4         //    
; 000B 02B5         MsgBoxEx(tmpBuf, 1, &Font_12x16, Header, NULL, WidthS / 2, HeightS / 2, N, 0xFF);
	LDI  R30,LOW(_tmpBuf)
	LDI  R31,HIGH(_tmpBuf)
	ST   -Y,R31
	ST   -Y,R30
	LDI  R30,LOW(1)
	ST   -Y,R30
	LDI  R30,LOW(_Font_12x16)
	LDI  R31,HIGH(_Font_12x16)
	ST   -Y,R31
	ST   -Y,R30
	LDD  R30,Y+11
	LDD  R31,Y+11+1
	ST   -Y,R31
	ST   -Y,R30
	LDI  R30,LOW(0)
	LDI  R31,HIGH(0)
	ST   -Y,R31
	ST   -Y,R30
	LDI  R30,LOW(64)
	ST   -Y,R30
	LDI  R30,LOW(32)
	ST   -Y,R30
	LDD  R30,Y+19
	ST   -Y,R30
	LDI  R30,LOW(255)
	ST   -Y,R30
	RCALL _MsgBoxEx
; 000B 02B6         //   
; 000B 02B7         Kbd = WaitButtonPress(0);
	LDI  R30,LOW(0)
	ST   -Y,R30
	CALL _WaitButtonPress
	MOV  R21,R30
; 000B 02B8         //        Min -    1
; 000B 02B9         if((Kbd == B_DOWN) && (tmp > Min)) tmp--;
	CPI  R21,2
	BRNE _0x160088
	LDD  R30,Y+11
	LDD  R31,Y+11+1
	CP   R30,R18
	CPC  R31,R19
	BRLT _0x160089
_0x160088:
	RJMP _0x160087
_0x160089:
	__SUBWRN 18,19,1
; 000B 02BA         //       Max -    1
; 000B 02BB         if((Kbd == B_UP)   && (tmp < Max)) tmp++;
_0x160087:
	CPI  R21,1
	BRNE _0x16008B
	LDD  R30,Y+9
	LDD  R31,Y+9+1
	CP   R18,R30
	CPC  R19,R31
	BRLT _0x16008C
_0x16008B:
	RJMP _0x16008A
_0x16008C:
	__ADDWRN 18,19,1
; 000B 02BC         //    -  
; 000B 02BD         if(Kbd == B_LEFT)
_0x16008A:
	CPI  R21,4
	BRNE _0x16008D
; 000B 02BE         {
; 000B 02BF             if(tmp - 10 > Min) tmp -= 10;  //     10 - 
	MOVW R26,R18
	SBIW R26,10
	LDD  R30,Y+11
	LDD  R31,Y+11+1
	CP   R30,R26
	CPC  R31,R27
	BRGE _0x16008E
	__SUBWRN 18,19,10
; 000B 02C0             else               tmp  = Min; //    
	RJMP _0x16008F
_0x16008E:
	__GETWRS 18,19,11
; 000B 02C1         }
_0x16008F:
; 000B 02C2         //    -  
; 000B 02C3         if(Kbd == B_RIGHT)
_0x16008D:
	CPI  R21,8
	BRNE _0x160090
; 000B 02C4         {
; 000B 02C5             if(tmp + 10 < Max) tmp += 10;  //     10 - 
	MOVW R26,R18
	ADIW R26,10
	LDD  R30,Y+9
	LDD  R31,Y+9+1
	CP   R26,R30
	CPC  R27,R31
	BRGE _0x160091
	__ADDWRN 18,19,10
; 000B 02C6             else               tmp  = Max; //    
	RJMP _0x160092
_0x160091:
	__GETWRS 18,19,9
; 000B 02C7         }
_0x160092:
; 000B 02C8 
; 000B 02C9         //     ,     - .
; 000B 02CA         //         
; 000B 02CB         //      .
; 000B 02CC         switch(PtrType)
_0x160090:
	LDD  R30,Y+13
; 000B 02CD         {
; 000B 02CE             case (PTR_CHAR):
	CPI  R30,LOW(0x3)
	BRNE _0x160096
; 000B 02CF                 *((char *)Val) = (char)tmp;
	LDD  R26,Y+14
	LDD  R27,Y+14+1
	ST   X,R18
; 000B 02D0                 break;
	RJMP _0x160095
; 000B 02D1 
; 000B 02D2             case (PTR_UCHAR):
_0x160096:
	CPI  R30,LOW(0x4)
	BRNE _0x160097
; 000B 02D3                 *((unsigned char *)Val) = (unsigned char)tmp;
	LDD  R26,Y+14
	LDD  R27,Y+14+1
	ST   X,R18
; 000B 02D4                 break;
	RJMP _0x160095
; 000B 02D5 
; 000B 02D6             case (PTR_INT):
_0x160097:
	CPI  R30,LOW(0x5)
	BRNE _0x160095
; 000B 02D7                 *((int *)Val) = tmp;
	LDD  R26,Y+14
	LDD  R27,Y+14+1
	ST   X+,R18
	ST   X,R19
; 000B 02D8                 break;
; 000B 02D9         }
_0x160095:
; 000B 02DA     }
; 000B 02DB     while((Kbd != B_ENTER) && (Kbd != B_BACK)); //      - 
	CPI  R21,32
	BREQ _0x160099
	CPI  R21,16
	BRNE _0x16009A
_0x160099:
	RJMP _0x160086
_0x16009A:
	RJMP _0x160085
_0x160086:
; 000B 02DC 
; 000B 02DD     //    - 
; 000B 02DE     if(Kbd == B_ENTER)
	CPI  R21,32
	BRNE _0x16009B
; 000B 02DF     {
; 000B 02E0         //     
; 000B 02E1         if(BackUp != tmp) return(TRUE);
	__CPWRR 18,19,16,17
	BREQ _0x16009C
	LDI  R30,LOW(1)
	RJMP _0x2060011
; 000B 02E2         //  - 
; 000B 02E3         else return(FALSE);
_0x16009C:
	LDI  R30,LOW(0)
	RJMP _0x2060011
; 000B 02E4     }
; 000B 02E5     // 
; 000B 02E6     else
_0x16009B:
; 000B 02E7     {
; 000B 02E8         //   
; 000B 02E9         switch(PtrType)
	LDD  R30,Y+13
; 000B 02EA         {
; 000B 02EB             case (PTR_CHAR):
	CPI  R30,LOW(0x3)
	BRNE _0x1600A2
; 000B 02EC                 *((char *)Val) = (char)BackUp;
	LDD  R26,Y+14
	LDD  R27,Y+14+1
	ST   X,R16
; 000B 02ED                 break;
	RJMP _0x1600A1
; 000B 02EE 
; 000B 02EF             case (PTR_UCHAR):
_0x1600A2:
	CPI  R30,LOW(0x4)
	BRNE _0x1600A3
; 000B 02F0                 *((unsigned char *)Val) = (unsigned char)BackUp;
	LDD  R26,Y+14
	LDD  R27,Y+14+1
	ST   X,R16
; 000B 02F1                 break;
	RJMP _0x1600A1
; 000B 02F2 
; 000B 02F3             case (PTR_INT):
_0x1600A3:
	CPI  R30,LOW(0x5)
	BRNE _0x1600A1
; 000B 02F4                 *((int *)Val) = BackUp;
	LDD  R26,Y+14
	LDD  R27,Y+14+1
	ST   X+,R16
	ST   X,R17
; 000B 02F5                 break;
; 000B 02F6         }
_0x1600A1:
; 000B 02F7 
; 000B 02F8         //    -  
; 000B 02F9         return(FALSE);
	LDI  R30,LOW(0)
; 000B 02FA     }
; 000B 02FB }
_0x2060011:
	CALL __LOADLOCR6
	ADIW R28,16
	RET
;
;flash char EditStrDlgTable[] = {
;' ','_','-','0','1','2','3','4','5','6','7','8','9','A','a','B','b','C','c','D',
;'d','E','e','F','f','G','g','H','h','I','i','J','j','K','k','L','l','M','m','N',
;'n','O','o','P','p','Q','q','R','r','S','s','T','t','U','u','V','v','W','w','X',
;'x','Y','y','Z','z'};
;
;// *****************************************************************************
;// ***         ***********************************************
;// *****************************************************************************
;char * EditStrDlg(char * Str, char StrLen, FontProfile * StrFont,
; 000B 0307                   char flash * Header, FontProfile * HeaderFont)
; 000B 0308 {
_EditStrDlg:
; 000B 0309     //   
; 000B 030A 	unsigned char i, j;
; 000B 030B     //    
; 000B 030C     char str[16];
; 000B 030D     //   
; 000B 030E     unsigned char Selected = 0;
; 000B 030F     //     
; 000B 0310     unsigned char X, Y, W, H, StrW, x;
; 000B 0311     //     
; 000B 0312     unsigned char Kbd = 0;
; 000B 0313 
; 000B 0314 #ifdef DEBUG
; 000B 0315     printf("EditStrDlg();\r");
; 000B 0316     delay_ms(1);
; 000B 0317 #endif
; 000B 0318 
; 000B 0319     // 
; 000B 031A     if(Str == NULL) return;                        //      - 
	SBIW R28,20
	LDI  R30,LOW(0)
	ST   Y,R30
	CALL __SAVELOCR6
;	*Str -> Y+33
;	StrLen -> Y+32
;	*StrFont -> Y+30
;	*Header -> Y+28
;	*HeaderFont -> Y+26
;	i -> R17
;	j -> R16
;	str -> Y+10
;	Selected -> R19
;	X -> R18
;	Y -> R21
;	W -> R20
;	H -> Y+9
;	StrW -> Y+8
;	x -> Y+7
;	Kbd -> Y+6
	LDI  R19,0
	LDD  R30,Y+33
	LDD  R31,Y+33+1
	SBIW R30,0
	BRNE _0x1600A5
	RJMP _0x2060010
; 000B 031B     if(StrFont == NULL) StrFont = &Font_8x12;      //     -   
_0x1600A5:
	LDD  R30,Y+30
	LDD  R31,Y+30+1
	SBIW R30,0
	BRNE _0x1600A6
	LDI  R30,LOW(_Font_8x12)
	LDI  R31,HIGH(_Font_8x12)
	STD  Y+30,R30
	STD  Y+30+1,R31
; 000B 031C     if(HeaderFont == NULL) HeaderFont = &Font_4x6; //     -   
_0x1600A6:
	LDD  R30,Y+26
	LDD  R31,Y+26+1
	SBIW R30,0
	BRNE _0x1600A7
	LDI  R30,LOW(_Font_4x6)
	LDI  R31,HIGH(_Font_4x6)
	STD  Y+26,R30
	STD  Y+26+1,R31
; 000B 031D     if(StrLen > NumberOf(str) - 1) StrLen = NumberOf(str) - 1; //         - 
_0x1600A7:
	LDD  R26,Y+32
	CPI  R26,LOW(0x10)
	BRLT _0x1600A8
	LDI  R30,LOW(15)
	STD  Y+32,R30
; 000B 031E 
; 000B 031F     //    0
; 000B 0320     memset(str, 0, NumberOf(str));
_0x1600A8:
	MOVW R30,R28
	ADIW R30,10
	ST   -Y,R31
	ST   -Y,R30
	LDI  R30,LOW(0)
	ST   -Y,R30
	LDI  R30,LOW(16)
	LDI  R31,HIGH(16)
	ST   -Y,R31
	ST   -Y,R30
	CALL _memset
; 000B 0321 
; 000B 0322     //        
; 000B 0323     for(i=0; i < StrLen; i++)
	LDI  R17,LOW(0)
_0x1600AA:
	LDD  R30,Y+32
	MOV  R26,R17
	LDI  R27,0
	LDI  R31,0
	SBRC R30,7
	SER  R31
	CP   R26,R30
	CPC  R27,R31
	BRGE _0x1600AB
; 000B 0324     {
; 000B 0325         for(j=0; j < NumberOf(EditStrDlgTable); j++)
	LDI  R16,LOW(0)
_0x1600AD:
	CPI  R16,65
	BRSH _0x1600AE
; 000B 0326         {
; 000B 0327             if(Str[i] == EditStrDlgTable[j])
	LDD  R26,Y+33
	LDD  R27,Y+33+1
	CLR  R30
	ADD  R26,R17
	ADC  R27,R30
	LD   R26,X
	MOV  R30,R16
	LDI  R31,0
	SUBI R30,LOW(-_EditStrDlgTable*2)
	SBCI R31,HIGH(-_EditStrDlgTable*2)
	LPM  R30,Z
	CP   R30,R26
	BRNE _0x1600AF
; 000B 0328             {
; 000B 0329                 //    - 
; 000B 032A                 str[i] = j;
	MOV  R30,R17
	LDI  R31,0
	MOVW R26,R28
	ADIW R26,10
	ADD  R30,R26
	ADC  R31,R27
	ST   Z,R16
; 000B 032B                 break;
	RJMP _0x1600AE
; 000B 032C             }
; 000B 032D         }
_0x1600AF:
	SUBI R16,-1
	RJMP _0x1600AD
_0x1600AE:
; 000B 032E     }
	SUBI R17,-1
	RJMP _0x1600AA
_0x1600AB:
; 000B 032F 
; 000B 0330     //     
; 000B 0331     W = (StrFont->W + 1) * StrLen;
	LDD  R26,Y+30
	LDD  R27,Y+30+1
	LD   R30,X
	SUBI R30,-LOW(1)
	LDD  R26,Y+32
	MUL  R30,R26
	MOV  R20,R0
; 000B 0332     H = StrFont->H;
	LDD  R26,Y+30
	LDD  R27,Y+30+1
	ADIW R26,1
	LD   R30,X
	STD  Y+9,R30
; 000B 0333 
; 000B 0334     if(Header != NULL)
	LDD  R30,Y+28
	LDD  R31,Y+28+1
	SBIW R30,0
	BREQ _0x1600B0
; 000B 0335     {
; 000B 0336         //     
; 000B 0337         StrW = HeaderFont->W * strlenf(Header);
	LDD  R26,Y+26
	LDD  R27,Y+26+1
	LD   R30,X
	PUSH R30
	LDD  R30,Y+28
	LDD  R31,Y+28+1
	ST   -Y,R31
	ST   -Y,R30
	CALL _strlenf
	POP  R26
	MUL  R30,R26
	MOVW R30,R0
	STD  Y+8,R30
; 000B 0338         //        -  
; 000B 0339 		if(W < StrW) W = StrW;
	CP   R20,R30
	BRSH _0x1600B1
	LDD  R20,Y+8
; 000B 033A     }
_0x1600B1:
; 000B 033B 
; 000B 033C     //            1 
; 000B 033D 	W += StrFont->W * 2;
_0x1600B0:
	LDD  R26,Y+30
	LDD  R27,Y+30+1
	LD   R30,X
	LSL  R30
	ADD  R20,R30
; 000B 033E     //            0.5 
; 000B 033F 	H += StrFont->H;
	ADIW R26,1
	LD   R30,X
	LDD  R26,Y+9
	ADD  R30,R26
	STD  Y+9,R30
; 000B 0340 
; 000B 0341     //   
; 000B 0342 	X = (WidthS - W) / 2;
	LDI  R30,LOW(128)
	SUB  R30,R20
	LSR  R30
	MOV  R18,R30
; 000B 0343     //   
; 000B 0344     Y = (HeightS - H) / 2;
	LDD  R26,Y+9
	LDI  R30,LOW(64)
	SUB  R30,R26
	LSR  R30
	MOV  R21,R30
; 000B 0345 
; 000B 0346     // ,  
; 000B 0347     if(Header != NULL)
	LDD  R30,Y+28
	LDD  R31,Y+28+1
	SBIW R30,0
	BRNE PC+3
	JMP _0x1600B2
; 000B 0348     {
; 000B 0349         //       
; 000B 034A         Y += HeaderFont->H / 2;
	LDD  R30,Y+26
	LDD  R31,Y+26+1
	LDD  R30,Z+1
	LSR  R30
	ADD  R21,R30
; 000B 034B         //    
; 000B 034C         gfx_Rectangle(X - 1, Y - HeaderFont->H - 2, X + W + 1, Y + 1, 0x00);
	MOV  R30,R18
	SUBI R30,LOW(1)
	LDI  R31,0
	ST   -Y,R31
	ST   -Y,R30
	LDD  R26,Y+28
	LDD  R27,Y+28+1
	ADIW R26,1
	LD   R26,X
	MOV  R30,R21
	SUB  R30,R26
	SUBI R30,LOW(2)
	LDI  R31,0
	ST   -Y,R31
	ST   -Y,R30
	MOV  R30,R20
	ADD  R30,R18
	SUBI R30,-LOW(1)
	LDI  R31,0
	ST   -Y,R31
	ST   -Y,R30
	MOV  R30,R21
	SUBI R30,-LOW(1)
	LDI  R31,0
	ST   -Y,R31
	ST   -Y,R30
	LDI  R30,LOW(0)
	ST   -Y,R30
	CALL _gfx_Rectangle
; 000B 034D         //    
; 000B 034E     	gfx_FillRect(X, Y - HeaderFont->H - 1, X + W, Y, 0xFF);
	MOV  R30,R18
	LDI  R31,0
	ST   -Y,R31
	ST   -Y,R30
	LDD  R26,Y+28
	LDD  R27,Y+28+1
	ADIW R26,1
	LD   R26,X
	MOV  R30,R21
	SUB  R30,R26
	SUBI R30,LOW(1)
	LDI  R31,0
	ST   -Y,R31
	ST   -Y,R30
	MOV  R30,R20
	ADD  R30,R18
	LDI  R31,0
	ST   -Y,R31
	ST   -Y,R30
	MOV  R30,R21
	LDI  R31,0
	ST   -Y,R31
	ST   -Y,R30
	LDI  R30,LOW(255)
	ST   -Y,R30
	CALL _gfx_FillRect
; 000B 034F         //    
; 000B 0350         gfx_SetXY(X + 1, Y - HeaderFont->H);
	MOV  R30,R18
	SUBI R30,-LOW(1)
	ST   -Y,R30
	LDD  R26,Y+27
	LDD  R27,Y+27+1
	ADIW R26,1
	LD   R26,X
	MOV  R30,R21
	SUB  R30,R26
	ST   -Y,R30
	CALL _gfx_SetXY
; 000B 0351         //  
; 000B 0352         gfx_PutFlashStr(Header, 0x00, HeaderFont);
	LDD  R30,Y+28
	LDD  R31,Y+28+1
	ST   -Y,R31
	ST   -Y,R30
	LDI  R30,LOW(0)
	ST   -Y,R30
	LDD  R30,Y+29
	LDD  R31,Y+29+1
	ST   -Y,R31
	ST   -Y,R30
	CALL _gfx_PutFlashStr
; 000B 0353     }
; 000B 0354 
; 000B 0355     do
_0x1600B2:
_0x1600B4:
; 000B 0356     {
; 000B 0357         //     
; 000B 0358 	    gfx_FillRect(X - 1, Y, X + W + 1, Y + H + 1, 0x00);
	MOV  R30,R18
	SUBI R30,LOW(1)
	LDI  R31,0
	ST   -Y,R31
	ST   -Y,R30
	MOV  R30,R21
	LDI  R31,0
	ST   -Y,R31
	ST   -Y,R30
	MOV  R30,R20
	ADD  R30,R18
	SUBI R30,-LOW(1)
	LDI  R31,0
	ST   -Y,R31
	ST   -Y,R30
	LDD  R30,Y+15
	ADD  R30,R21
	SUBI R30,-LOW(1)
	LDI  R31,0
	ST   -Y,R31
	ST   -Y,R30
	LDI  R30,LOW(0)
	ST   -Y,R30
	CALL _gfx_FillRect
; 000B 0359         //     
; 000B 035A 	    gfx_Rectangle(X, Y, X + W, Y + H, 0xFF);
	MOV  R30,R18
	LDI  R31,0
	ST   -Y,R31
	ST   -Y,R30
	MOV  R30,R21
	LDI  R31,0
	ST   -Y,R31
	ST   -Y,R30
	MOV  R30,R20
	ADD  R30,R18
	LDI  R31,0
	ST   -Y,R31
	ST   -Y,R30
	LDD  R30,Y+15
	ADD  R30,R21
	LDI  R31,0
	ST   -Y,R31
	ST   -Y,R30
	LDI  R30,LOW(255)
	ST   -Y,R30
	CALL _gfx_Rectangle
; 000B 035B 
; 000B 035C         //     X   
; 000B 035D         x = (WidthS - (StrFont->W + 1) * StrLen) / 2;
	LDD  R26,Y+30
	LDD  R27,Y+30+1
	LD   R30,X
	SUBI R30,-LOW(1)
	LDD  R26,Y+32
	MUL  R30,R26
	MOVW R30,R0
	LDI  R26,LOW(128)
	SUB  R26,R30
	MOV  R30,R26
	LSR  R30
	STD  Y+7,R30
; 000B 035E 
; 000B 035F         //        
; 000B 0360 	    for(i = 0; i < StrLen; i++)
	LDI  R17,LOW(0)
_0x1600B7:
	LDD  R30,Y+32
	MOV  R26,R17
	LDI  R27,0
	LDI  R31,0
	SBRC R30,7
	SER  R31
	CP   R26,R30
	CPC  R27,R31
	BRGE _0x1600B8
; 000B 0361 	    {
; 000B 0362             //    
; 000B 0363             gfx_SetXY(x + i * (StrFont->W + 1), Y + StrFont->H/2);
	LDD  R26,Y+30
	LDD  R27,Y+30+1
	LD   R30,X
	SUBI R30,-LOW(1)
	MUL  R30,R17
	MOVW R30,R0
	LDD  R26,Y+7
	ADD  R30,R26
	ST   -Y,R30
	LDD  R30,Y+31
	LDD  R31,Y+31+1
	LDD  R30,Z+1
	LSR  R30
	ADD  R30,R21
	ST   -Y,R30
	CALL _gfx_SetXY
; 000B 0364             //  
; 000B 0365             StrFont->PutChar(EditStrDlgTable[str[i]], 0xFF);
	LDD  R30,Y+30
	LDD  R31,Y+30+1
	__GETWRZ 0,1,5
	MOV  R30,R17
	LDI  R31,0
	MOVW R26,R28
	ADIW R26,10
	ADD  R26,R30
	ADC  R27,R31
	LD   R30,X
	LDI  R31,0
	SUBI R30,LOW(-_EditStrDlgTable*2)
	SBCI R31,HIGH(-_EditStrDlgTable*2)
	LPM  R30,Z
	ST   -Y,R30
	LDI  R30,LOW(255)
	ST   -Y,R30
	MOVW R30,R0
	ICALL
; 000B 0366 	    }
	SUBI R17,-1
	RJMP _0x1600B7
_0x1600B8:
; 000B 0367 
; 000B 0368         //     
; 000B 0369   	    gfx_Rectangle(x + Selected * (StrFont->W + 1) - 2,          Y + StrFont->H/2 - 1,
; 000B 036A                       x + Selected * (StrFont->W + 1) + StrFont->W, Y + StrFont->H/2 + StrFont->H, 0xFF);
	LDD  R26,Y+30
	LDD  R27,Y+30+1
	LD   R30,X
	SUBI R30,-LOW(1)
	MUL  R30,R19
	MOVW R30,R0
	LDD  R26,Y+7
	ADD  R26,R30
	LDI  R30,LOW(2)
	CALL __SWAPB12
	SUB  R30,R26
	LDI  R31,0
	ST   -Y,R31
	ST   -Y,R30
	LDD  R30,Y+32
	LDD  R31,Y+32+1
	LDD  R30,Z+1
	LSR  R30
	ADD  R30,R21
	SUBI R30,LOW(1)
	LDI  R31,0
	ST   -Y,R31
	ST   -Y,R30
	LDD  R26,Y+34
	LDD  R27,Y+34+1
	LD   R30,X
	SUBI R30,-LOW(1)
	MUL  R30,R19
	MOVW R30,R0
	LDD  R26,Y+11
	ADD  R30,R26
	MOV  R0,R30
	LDD  R26,Y+34
	LDD  R27,Y+34+1
	LD   R30,X
	ADD  R30,R0
	LDI  R31,0
	ST   -Y,R31
	ST   -Y,R30
	LDD  R30,Y+36
	LDD  R31,Y+36+1
	LDD  R30,Z+1
	LSR  R30
	ADD  R30,R21
	MOV  R0,R30
	ADIW R26,1
	LD   R30,X
	ADD  R30,R0
	LDI  R31,0
	ST   -Y,R31
	ST   -Y,R30
	LDI  R30,LOW(255)
	ST   -Y,R30
	CALL _gfx_Rectangle
; 000B 036B 
; 000B 036C         //    
; 000B 036D         gfx_Refresh();
	CALL _gfx_Refresh
; 000B 036E 
; 000B 036F         //   
; 000B 0370         Kbd = WaitButtonPress(0);
	LDI  R30,LOW(0)
	ST   -Y,R30
	CALL _WaitButtonPress
	STD  Y+6,R30
; 000B 0371 
; 000B 0372         //   ,     
; 000B 0373         if((Kbd == B_LEFT)  && (Selected >          0)) Selected--;
	LDD  R26,Y+6
	CPI  R26,LOW(0x4)
	BRNE _0x1600BA
	CPI  R19,1
	BRSH _0x1600BB
_0x1600BA:
	RJMP _0x1600B9
_0x1600BB:
	SUBI R19,1
; 000B 0374         if((Kbd == B_RIGHT) && (Selected < StrLen - 1)) Selected++;
_0x1600B9:
	LDD  R26,Y+6
	CPI  R26,LOW(0x8)
	BRNE _0x1600BD
	LDD  R30,Y+32
	SUBI R30,LOW(1)
	MOV  R26,R19
	LDI  R27,0
	LDI  R31,0
	SBRC R30,7
	SER  R31
	CP   R26,R30
	CPC  R27,R31
	BRLT _0x1600BE
_0x1600BD:
	RJMP _0x1600BC
_0x1600BE:
	SUBI R19,-1
; 000B 0375 
; 000B 0376         //        
; 000B 0377         if((Kbd == B_LEFT) || (Kbd == B_RIGHT)) WaitEmptyButtons(10);
_0x1600BC:
	LDD  R26,Y+6
	CPI  R26,LOW(0x4)
	BREQ _0x1600C0
	CPI  R26,LOW(0x8)
	BRNE _0x1600BF
_0x1600C0:
	LDI  R30,LOW(10)
	ST   -Y,R30
	CALL _WaitEmptyButtons
; 000B 0378 
; 000B 0379         //  ,     
; 000B 037A         if((Kbd == B_UP)   && (str[Selected] >                             0)) str[Selected]--;
_0x1600BF:
	LDD  R26,Y+6
	CPI  R26,LOW(0x1)
	BRNE _0x1600C3
	MOV  R30,R19
	LDI  R31,0
	MOVW R26,R28
	ADIW R26,10
	ADD  R26,R30
	ADC  R27,R31
	LD   R26,X
	CPI  R26,LOW(0x1)
	BRGE _0x1600C4
_0x1600C3:
	RJMP _0x1600C2
_0x1600C4:
	MOV  R30,R19
	LDI  R31,0
	MOVW R26,R28
	ADIW R26,10
	ADD  R26,R30
	ADC  R27,R31
	LD   R30,X
	SUBI R30,LOW(1)
	ST   X,R30
; 000B 037B         if((Kbd == B_DOWN) && (str[Selected] < NumberOf(EditStrDlgTable) - 1)) str[Selected]++;
_0x1600C2:
	LDD  R26,Y+6
	CPI  R26,LOW(0x2)
	BRNE _0x1600C6
	MOV  R30,R19
	LDI  R31,0
	MOVW R26,R28
	ADIW R26,10
	ADD  R26,R30
	ADC  R27,R31
	LD   R26,X
	CPI  R26,LOW(0x40)
	BRLT _0x1600C7
_0x1600C6:
	RJMP _0x1600C5
_0x1600C7:
	MOV  R30,R19
	LDI  R31,0
	MOVW R26,R28
	ADIW R26,10
	ADD  R26,R30
	ADC  R27,R31
	LD   R30,X
	SUBI R30,-LOW(1)
	ST   X,R30
; 000B 037C     }
_0x1600C5:
; 000B 037D     while(!(Kbd & (B_BACK | B_ENTER)));
	LDD  R30,Y+6
	ANDI R30,LOW(0x30)
	BRNE _0x1600B5
	RJMP _0x1600B4
_0x1600B5:
; 000B 037E 
; 000B 037F     //   ENTER   
; 000B 0380     if(Kbd & B_ENTER)
	LDD  R30,Y+6
	ANDI R30,LOW(0x20)
	BRNE PC+3
	JMP _0x1600C8
; 000B 0381     {
; 000B 0382         //     
; 000B 0383         for(i=0; i < StrLen; i++) Str[i] = EditStrDlgTable[str[i]];
	LDI  R17,LOW(0)
_0x1600CA:
	LDD  R30,Y+32
	MOV  R26,R17
	LDI  R27,0
	LDI  R31,0
	SBRC R30,7
	SER  R31
	CP   R26,R30
	CPC  R27,R31
	BRGE _0x1600CB
	MOV  R30,R17
	LDD  R26,Y+33
	LDD  R27,Y+33+1
	LDI  R31,0
	ADD  R30,R26
	ADC  R31,R27
	MOVW R0,R30
	MOV  R30,R17
	LDI  R31,0
	MOVW R26,R28
	ADIW R26,10
	ADD  R26,R30
	ADC  R27,R31
	LD   R30,X
	LDI  R31,0
	SUBI R30,LOW(-_EditStrDlgTable*2)
	SBCI R31,HIGH(-_EditStrDlgTable*2)
	LPM  R30,Z
	MOVW R26,R0
	ST   X,R30
	SUBI R17,-1
	RJMP _0x1600CA
_0x1600CB:
; 000B 0385 Str[StrLen] = '\0';
	LDD  R30,Y+32
	LDD  R26,Y+33
	LDD  R27,Y+33+1
	LDI  R31,0
	ADD  R26,R30
	ADC  R27,R31
	LDI  R30,LOW(0)
	ST   X,R30
; 000B 0386         //      :
; 000B 0387         //    ,   
; 000B 0388         for(i = StrLen - 1; i >= 0; i--)
	LDD  R30,Y+32
	SUBI R30,LOW(1)
	MOV  R17,R30
_0x1600CD:
	CPI  R17,0
	BRLO _0x1600CE
; 000B 0389         {
; 000B 038A             if(Str[i] != ' ') break; //     -  
	LDD  R26,Y+33
	LDD  R27,Y+33+1
	CLR  R30
	ADD  R26,R17
	ADC  R27,R30
	LD   R26,X
	CPI  R26,LOW(0x20)
	BRNE _0x1600CE
; 000B 038B             else Str[i] = '\0';      //     -
	LDD  R26,Y+33
	LDD  R27,Y+33+1
	CLR  R30
	ADD  R26,R17
	ADC  R27,R30
	ST   X,R30
; 000B 038C         }
	SUBI R17,1
	RJMP _0x1600CD
_0x1600CE:
; 000B 038D         //     
; 000B 038E         return(Str);
	LDD  R30,Y+33
	LDD  R31,Y+33+1
	RJMP _0x206000F
; 000B 038F     }
; 000B 0390     //   NULL
; 000B 0391     return(NULL);
_0x1600C8:
_0x2060010:
	LDI  R30,LOW(0)
	LDI  R31,HIGH(0)
_0x206000F:
	CALL __LOADLOCR6
	ADIW R28,35
	RET
; 000B 0392 }
;
;// *****************************************************************************
;// ***         ***********************************************
;// *****************************************************************************
;// :   ,  - 
;int FromToBox(void ** FromBody,  unsigned char FromBodyPtrType, unsigned char FromN,
; 000B 0399               void ** ToBody,    unsigned char ToBodyPtrType, unsigned char ToN,
; 000B 039A               flash char  * Header, FontProfile * HeaderFont)
; 000B 039B {
_FromToBox:
; 000B 039C     StringType Strings[4];
; 000B 039D     //     
; 000B 039E     char From = 0, To = 0, pos = 0;
; 000B 039F     //    
; 000B 03A0     unsigned char Kbd = 0;
; 000B 03A1     char FromStr[16], ToStr[16];
; 000B 03A2 
; 000B 03A3     Strings[0].Str = (void *)("From:");
	SBIW R28,63
	SBIW R28,1
	CALL __SAVELOCR4
;	*FromBody -> Y+78
;	FromBodyPtrType -> Y+77
;	FromN -> Y+76
;	*ToBody -> Y+74
;	ToBodyPtrType -> Y+73
;	ToN -> Y+72
;	*Header -> Y+70
;	*HeaderFont -> Y+68
;	Strings -> Y+36
;	From -> R17
;	To -> R16
;	pos -> R19
;	Kbd -> R18
;	FromStr -> Y+20
;	ToStr -> Y+4
	LDI  R17,0
	LDI  R16,0
	LDI  R19,0
	LDI  R18,0
	__POINTW1FN _0x160000,3
	STD  Y+36,R30
	STD  Y+36+1,R31
; 000B 03A4     Strings[0].StrPtrType = PTR_FLASH;
	LDI  R30,LOW(0)
	STD  Y+38,R30
; 000B 03A5     Strings[0].StrFont = &Font_6x8;
	LDI  R30,LOW(_Font_6x8)
	LDI  R31,HIGH(_Font_6x8)
	STD  Y+40,R30
	STD  Y+40+1,R31
; 000B 03A6     Strings[0].Color = 0xFF;
	LDI  R30,LOW(255)
	STD  Y+42,R30
; 000B 03A7     Strings[0].VSpace = 3;
	LDI  R30,LOW(3)
	STD  Y+43,R30
; 000B 03A8 
; 000B 03A9     Strings[1].Str = FromStr;
	MOVW R30,R28
	ADIW R30,20
	STD  Y+44,R30
	STD  Y+44+1,R31
; 000B 03AA     Strings[1].StrPtrType = PTR_SRAM;
	MOVW R30,R28
	ADIW R30,46
	LDI  R26,LOW(1)
	STD  Z+0,R26
; 000B 03AB     Strings[1].StrFont = &Font_8x8;
	LDI  R30,LOW(_Font_8x8)
	LDI  R31,HIGH(_Font_8x8)
	STD  Y+48,R30
	STD  Y+48+1,R31
; 000B 03AC     Strings[1].Color = 0xFF;
	MOVW R30,R28
	ADIW R30,50
	LDI  R26,LOW(255)
	STD  Z+0,R26
; 000B 03AD     Strings[1].VSpace = 3;
	MOVW R30,R28
	ADIW R30,51
	LDI  R26,LOW(3)
	STD  Z+0,R26
; 000B 03AE 
; 000B 03AF     Strings[2].Str =(void *)("To:");
	__POINTW1FN _0x160000,9
	STD  Y+52,R30
	STD  Y+52+1,R31
; 000B 03B0     Strings[2].StrPtrType = PTR_FLASH;
	MOVW R30,R28
	ADIW R30,54
	LDI  R26,LOW(0)
	STD  Z+0,R26
; 000B 03B1     Strings[2].StrFont = &Font_6x8;
	LDI  R30,LOW(_Font_6x8)
	LDI  R31,HIGH(_Font_6x8)
	STD  Y+56,R30
	STD  Y+56+1,R31
; 000B 03B2     Strings[2].Color = 0xFF;
	MOVW R30,R28
	ADIW R30,58
	LDI  R26,LOW(255)
	STD  Z+0,R26
; 000B 03B3     Strings[2].VSpace = 3;
	MOVW R30,R28
	ADIW R30,59
	LDI  R26,LOW(3)
	STD  Z+0,R26
; 000B 03B4 
; 000B 03B5     Strings[3].Str = ToStr;
	MOVW R30,R28
	ADIW R30,4
	STD  Y+60,R30
	STD  Y+60+1,R31
; 000B 03B6     Strings[3].StrPtrType = PTR_SRAM;
	MOVW R30,R28
	ADIW R30,62
	LDI  R26,LOW(1)
	STD  Z+0,R26
; 000B 03B7     Strings[3].StrFont = &Font_8x8;
	LDI  R30,LOW(_Font_8x8)
	LDI  R31,HIGH(_Font_8x8)
	__PUTW1SX 64
; 000B 03B8     Strings[3].Color = 0xFF;
	MOVW R30,R28
	ADIW R30,36
	ADIW R30,30
	LDI  R26,LOW(255)
	STD  Z+0,R26
; 000B 03B9     Strings[3].VSpace = 3;
	MOVW R30,R28
	ADIW R30,36
	ADIW R30,31
	LDI  R26,LOW(3)
	STD  Z+0,R26
; 000B 03BA 
; 000B 03BB     do
_0x1600D2:
; 000B 03BC     {
; 000B 03BD         //     
; 000B 03BE              if(FromBodyPtrType == PTR_FLASH) sprintf(FromStr, "%p", FromBody[From]);
	__GETB1SX 77
	CPI  R30,0
	BRNE _0x1600D4
	MOVW R30,R28
	ADIW R30,20
	ST   -Y,R31
	ST   -Y,R30
	__POINTW1FN _0x160000,13
	RJMP _0x1600F7
; 000B 03BF         else if(FromBodyPtrType == PTR_SRAM ) sprintf(FromStr, "%s", FromBody[From]);
_0x1600D4:
	__GETB2SX 77
	CPI  R26,LOW(0x1)
	BRNE _0x1600D6
	MOVW R30,R28
	ADIW R30,20
	ST   -Y,R31
	ST   -Y,R30
	__POINTW1FN _0x160000,16
_0x1600F7:
	ST   -Y,R31
	ST   -Y,R30
	MOV  R30,R17
	__GETW2SX 82
	LDI  R31,0
	LSL  R30
	ROL  R31
	ADD  R26,R30
	ADC  R27,R31
	CALL __GETW1P
	CLR  R22
	CLR  R23
	CALL __PUTPARD1
	LDI  R24,4
	CALL _sprintf
	ADIW R28,8
; 000B 03C0         //     
; 000B 03C1              if(ToBodyPtrType == PTR_FLASH) sprintf(ToStr, "%p", ToBody[To]);
_0x1600D6:
	__GETB1SX 73
	CPI  R30,0
	BRNE _0x1600D7
	MOVW R30,R28
	ADIW R30,4
	ST   -Y,R31
	ST   -Y,R30
	__POINTW1FN _0x160000,13
	RJMP _0x1600F8
; 000B 03C2         else if(ToBodyPtrType == PTR_SRAM ) sprintf(ToStr, "%s", ToBody[To]);
_0x1600D7:
	__GETB2SX 73
	CPI  R26,LOW(0x1)
	BRNE _0x1600D9
	MOVW R30,R28
	ADIW R30,4
	ST   -Y,R31
	ST   -Y,R30
	__POINTW1FN _0x160000,16
_0x1600F8:
	ST   -Y,R31
	ST   -Y,R30
	MOV  R30,R16
	__GETW2SX 78
	LDI  R31,0
	LSL  R30
	ROL  R31
	ADD  R26,R30
	ADC  R27,R31
	CALL __GETW1P
	CLR  R22
	CLR  R23
	CALL __PUTPARD1
	LDI  R24,4
	CALL _sprintf
	ADIW R28,8
; 000B 03C3 
; 000B 03C4         if(pos == 0)
_0x1600D9:
	CPI  R19,0
	BRNE _0x1600DA
; 000B 03C5         {
; 000B 03C6             Strings[1].Color = 0x00;
	MOVW R30,R28
	ADIW R30,50
	LDI  R26,LOW(0)
	STD  Z+0,R26
; 000B 03C7             Strings[3].Color = 0xFF;
	MOVW R30,R28
	ADIW R30,36
	ADIW R30,30
	LDI  R26,LOW(255)
	RJMP _0x1600F9
; 000B 03C8         }
; 000B 03C9         else
_0x1600DA:
; 000B 03CA         {
; 000B 03CB             Strings[1].Color = 0xFF;
	MOVW R30,R28
	ADIW R30,50
	LDI  R26,LOW(255)
	STD  Z+0,R26
; 000B 03CC             Strings[3].Color = 0x00;
	MOVW R30,R28
	ADIW R30,36
	ADIW R30,30
	LDI  R26,LOW(0)
_0x1600F9:
	STD  Z+0,R26
; 000B 03CD         }
; 000B 03CE 
; 000B 03CF         //    
; 000B 03D0         MsgBoxStrEx(Strings, 4, Header, HeaderFont, WidthS / 2, HeightS / 2, 10, 0xFF);
	MOVW R30,R28
	ADIW R30,36
	ST   -Y,R31
	ST   -Y,R30
	LDI  R30,LOW(4)
	ST   -Y,R30
	__GETW1SX 73
	ST   -Y,R31
	ST   -Y,R30
	__GETW1SX 73
	ST   -Y,R31
	ST   -Y,R30
	LDI  R30,LOW(64)
	ST   -Y,R30
	LDI  R30,LOW(32)
	ST   -Y,R30
	LDI  R30,LOW(10)
	ST   -Y,R30
	LDI  R30,LOW(255)
	ST   -Y,R30
	CALL _MsgBoxStrEx
; 000B 03D1 
; 000B 03D2         //   
; 000B 03D3         WaitEmptyButtons(0);
	LDI  R30,LOW(0)
	ST   -Y,R30
	CALL _WaitEmptyButtons
; 000B 03D4         //   
; 000B 03D5         Kbd = WaitButtonPress(0);
	LDI  R30,LOW(0)
	ST   -Y,R30
	CALL _WaitButtonPress
	MOV  R18,R30
; 000B 03D6 
; 000B 03D7         //        Min -  
; 000B 03D8         if((Kbd == B_DOWN) && (pos < 1)) pos++;
	CPI  R18,2
	BRNE _0x1600DD
	CPI  R19,1
	BRLT _0x1600DE
_0x1600DD:
	RJMP _0x1600DC
_0x1600DE:
	SUBI R19,-1
; 000B 03D9         //       Max -  
; 000B 03DA         if((Kbd == B_UP)   && (pos > 0)) pos--;
_0x1600DC:
	CPI  R18,1
	BRNE _0x1600E0
	CPI  R19,1
	BRGE _0x1600E1
_0x1600E0:
	RJMP _0x1600DF
_0x1600E1:
	SUBI R19,1
; 000B 03DB         //        Min -  
; 000B 03DC         if(Kbd == B_LEFT)
_0x1600DF:
	CPI  R18,4
	BRNE _0x1600E2
; 000B 03DD         {
; 000B 03DE             if((pos == 0) && (From > 0)) From--;
	CPI  R19,0
	BRNE _0x1600E4
	CPI  R17,1
	BRGE _0x1600E5
_0x1600E4:
	RJMP _0x1600E3
_0x1600E5:
	SUBI R17,1
; 000B 03DF             if((pos == 1) &&   (To > 0))   To--;
_0x1600E3:
	CPI  R19,1
	BRNE _0x1600E7
	CPI  R16,1
	BRGE _0x1600E8
_0x1600E7:
	RJMP _0x1600E6
_0x1600E8:
	SUBI R16,1
; 000B 03E0         }
_0x1600E6:
; 000B 03E1         //       Max -  
; 000B 03E2         if(Kbd == B_RIGHT)
_0x1600E2:
	CPI  R18,8
	BRNE _0x1600E9
; 000B 03E3         {
; 000B 03E4             if((pos == 0) && (From < FromN - 1)) From++;
	CPI  R19,0
	BRNE _0x1600EB
	__GETB1SX 76
	SUBI R30,LOW(1)
	MOV  R26,R17
	LDI  R27,0
	SBRC R26,7
	SER  R27
	LDI  R31,0
	CP   R26,R30
	CPC  R27,R31
	BRLT _0x1600EC
_0x1600EB:
	RJMP _0x1600EA
_0x1600EC:
	SUBI R17,-1
; 000B 03E5             if((pos == 1) &&   (To <   ToN - 1))   To++;
_0x1600EA:
	CPI  R19,1
	BRNE _0x1600EE
	__GETB1SX 72
	SUBI R30,LOW(1)
	MOV  R26,R16
	LDI  R27,0
	SBRC R26,7
	SER  R27
	LDI  R31,0
	CP   R26,R30
	CPC  R27,R31
	BRLT _0x1600EF
_0x1600EE:
	RJMP _0x1600ED
_0x1600EF:
	SUBI R16,-1
; 000B 03E6         }
_0x1600ED:
; 000B 03E7     }
_0x1600E9:
; 000B 03E8     while((Kbd != B_ENTER) && (Kbd != B_BACK)); //      - 
	CPI  R18,32
	BREQ _0x1600F0
	CPI  R18,16
	BRNE _0x1600F1
_0x1600F0:
	RJMP _0x1600D3
_0x1600F1:
	RJMP _0x1600D2
_0x1600D3:
; 000B 03E9 
; 000B 03EA     //    -   
; 000B 03EB     if(Kbd == B_ENTER) return(((int)From) << 8 | To);
	CPI  R18,32
	BRNE _0x1600F2
	MOV  R31,R17
	LDI  R30,LOW(0)
	MOVW R26,R30
	MOV  R30,R16
	LDI  R31,0
	SBRC R30,7
	SER  R31
	OR   R30,R26
	OR   R31,R27
	RJMP _0x206000E
; 000B 03EC     return(-1);
_0x1600F2:
	LDI  R30,LOW(65535)
	LDI  R31,HIGH(65535)
_0x206000E:
	CALL __LOADLOCR4
	ADIW R28,63
	ADIW R28,17
	RET
; 000B 03ED }
;/*******************************************************************************
;*  User_Interface.c
;*
;*  :  
;*
;*       Copyright (c) 2009 Nick Shl
;*           All rights reserved.
;*
;*
;*  :
;*
;*  Mar 25, 2009  Nick_Shl   
;*
;*/// ***************************************************************************
;#include <mega128.h>
	#ifndef __SLEEP_DEFINED__
	#define __SLEEP_DEFINED__
	.EQU __se_bit=0x20
	.EQU __sm_mask=0x1C
	.EQU __sm_powerdown=0x10
	.EQU __sm_powersave=0x18
	.EQU __sm_standby=0x14
	.EQU __sm_ext_standby=0x1C
	.EQU __sm_adc_noise_red=0x08
	.SET power_ctrl_reg=mcucr
	#endif
;#include <delay.h>
;#include <stdio.h>
;#include <string.h>
;
;#include "Def.h"
;#include "Coder.h"
;#include "Graphic.h"
;#include "Sound.h"
;#include "Demo.h"
;#include "Music.h"
;#include "Variables.h"
;#include "Tasks.h"
;#include "System.h"
;#include "UI_Engine.h"
;#include "User_Interface.h"
;
;//  .      .
;//     WidthS  HeightS   !!!
;#define Trim0posX (WidthS-10-32)
;#define Trim0posY (HeightS-1)
;#define Trim1posX (WidthS-1)
;#define Trim1posY (HeightS-32-10)
;#define Trim2posX 0
;#define Trim2posY (HeightS-32-10)
;#define Trim3posX 10
;#define Trim3posY (HeightS-1)
;
;// *****************************************************************************
;// ***        *******************************************
;// *****************************************************************************
;void wr_trimmer(void)
; 000C 002F {

	.CSEG
_wr_trimmer:
; 000C 0030     char tr[4];
; 000C 0031 
; 000C 0032     tr[0] = CurModel.Mode[FLY_MODE].trimmers[0] / 6 + Trim0posX + 16;
	SBIW R28,4
;	tr -> Y+0
	__POINTW2MN _CurModel,21
	LDS  R30,_FLY_MODE
	LDI  R31,0
	MOVW R22,R26
	LDI  R26,LOW(246)
	LDI  R27,HIGH(246)
	CALL __MULW12U
	MOVW R26,R22
	ADD  R26,R30
	ADC  R27,R31
	SUBI R26,LOW(-242)
	SBCI R27,HIGH(-242)
	LD   R26,X
	LDI  R30,LOW(6)
	CALL __DIVB21
	SUBI R30,-LOW(102)
	ST   Y,R30
; 000C 0033     gfx_Line(Trim0posX, Trim0posY, Trim0posX + 32, Trim0posY, 1);
	LDI  R30,LOW(86)
	LDI  R31,HIGH(86)
	ST   -Y,R31
	ST   -Y,R30
	LDI  R30,LOW(63)
	LDI  R31,HIGH(63)
	ST   -Y,R31
	ST   -Y,R30
	LDI  R30,LOW(118)
	LDI  R31,HIGH(118)
	ST   -Y,R31
	ST   -Y,R30
	LDI  R30,LOW(63)
	LDI  R31,HIGH(63)
	ST   -Y,R31
	ST   -Y,R30
	LDI  R30,LOW(1)
	ST   -Y,R30
	CALL _gfx_Line
; 000C 0034     gfx_PutPixel(Trim0posX     , Trim0posY - 1, 1); gfx_PutPixel(Trim0posX, Trim0posY - 2, 1);
	LDI  R30,LOW(86)
	ST   -Y,R30
	LDI  R30,LOW(62)
	ST   -Y,R30
	LDI  R30,LOW(1)
	ST   -Y,R30
	CALL _gfx_PutPixel
	LDI  R30,LOW(86)
	ST   -Y,R30
	LDI  R30,LOW(61)
	ST   -Y,R30
	LDI  R30,LOW(1)
	ST   -Y,R30
	CALL _gfx_PutPixel
; 000C 0035     gfx_PutPixel(Trim0posX +  4, Trim0posY - 1, 1);
	LDI  R30,LOW(90)
	ST   -Y,R30
	LDI  R30,LOW(62)
	ST   -Y,R30
	LDI  R30,LOW(1)
	ST   -Y,R30
	CALL _gfx_PutPixel
; 000C 0036     gfx_PutPixel(Trim0posX +  8, Trim0posY - 1, 1);
	LDI  R30,LOW(94)
	ST   -Y,R30
	LDI  R30,LOW(62)
	ST   -Y,R30
	LDI  R30,LOW(1)
	ST   -Y,R30
	CALL _gfx_PutPixel
; 000C 0037     gfx_PutPixel(Trim0posX + 12, Trim0posY - 1, 1);
	LDI  R30,LOW(98)
	ST   -Y,R30
	LDI  R30,LOW(62)
	ST   -Y,R30
	LDI  R30,LOW(1)
	ST   -Y,R30
	CALL _gfx_PutPixel
; 000C 0038     gfx_PutPixel(Trim0posX + 16, Trim0posY - 1, 1); gfx_PutPixel(Trim0posX + 16, Trim0posY - 2, 1);
	LDI  R30,LOW(102)
	ST   -Y,R30
	LDI  R30,LOW(62)
	ST   -Y,R30
	LDI  R30,LOW(1)
	ST   -Y,R30
	CALL _gfx_PutPixel
	LDI  R30,LOW(102)
	ST   -Y,R30
	LDI  R30,LOW(61)
	ST   -Y,R30
	LDI  R30,LOW(1)
	ST   -Y,R30
	CALL _gfx_PutPixel
; 000C 0039     gfx_PutPixel(Trim0posX + 20, Trim0posY - 1, 1);
	LDI  R30,LOW(106)
	ST   -Y,R30
	LDI  R30,LOW(62)
	ST   -Y,R30
	LDI  R30,LOW(1)
	ST   -Y,R30
	CALL _gfx_PutPixel
; 000C 003A     gfx_PutPixel(Trim0posX + 24, Trim0posY - 1, 1);
	LDI  R30,LOW(110)
	ST   -Y,R30
	LDI  R30,LOW(62)
	ST   -Y,R30
	LDI  R30,LOW(1)
	ST   -Y,R30
	CALL _gfx_PutPixel
; 000C 003B     gfx_PutPixel(Trim0posX + 28, Trim0posY - 1, 1);
	LDI  R30,LOW(114)
	ST   -Y,R30
	LDI  R30,LOW(62)
	ST   -Y,R30
	LDI  R30,LOW(1)
	ST   -Y,R30
	CALL _gfx_PutPixel
; 000C 003C     gfx_PutPixel(Trim0posX + 32, Trim0posY - 1, 1); gfx_PutPixel(Trim0posX + 32, Trim0posY - 2, 1);
	LDI  R30,LOW(118)
	ST   -Y,R30
	LDI  R30,LOW(62)
	ST   -Y,R30
	LDI  R30,LOW(1)
	ST   -Y,R30
	CALL _gfx_PutPixel
	LDI  R30,LOW(118)
	ST   -Y,R30
	LDI  R30,LOW(61)
	ST   -Y,R30
	LDI  R30,LOW(1)
	ST   -Y,R30
	CALL _gfx_PutPixel
; 000C 003D     gfx_PutPixel(tr[0], Trim0posY - 3, 1);
	LD   R30,Y
	ST   -Y,R30
	LDI  R30,LOW(60)
	ST   -Y,R30
	LDI  R30,LOW(1)
	ST   -Y,R30
	CALL _gfx_PutPixel
; 000C 003E     gfx_Line(tr[0] - 1, Trim0posY - 4, tr[0] + 1, Trim0posY - 4, 1);
	LD   R30,Y
	SUBI R30,LOW(1)
	LDI  R31,0
	SBRC R30,7
	SER  R31
	ST   -Y,R31
	ST   -Y,R30
	LDI  R30,LOW(59)
	LDI  R31,HIGH(59)
	ST   -Y,R31
	ST   -Y,R30
	LDD  R30,Y+4
	SUBI R30,-LOW(1)
	LDI  R31,0
	SBRC R30,7
	SER  R31
	ST   -Y,R31
	ST   -Y,R30
	LDI  R30,LOW(59)
	LDI  R31,HIGH(59)
	ST   -Y,R31
	ST   -Y,R30
	LDI  R30,LOW(1)
	ST   -Y,R30
	CALL _gfx_Line
; 000C 003F     gfx_Line(tr[0] - 2, Trim0posY - 5, tr[0] + 2, Trim0posY - 5, 1);
	LD   R30,Y
	SUBI R30,LOW(2)
	LDI  R31,0
	SBRC R30,7
	SER  R31
	ST   -Y,R31
	ST   -Y,R30
	LDI  R30,LOW(58)
	LDI  R31,HIGH(58)
	ST   -Y,R31
	ST   -Y,R30
	LDD  R30,Y+4
	SUBI R30,-LOW(2)
	LDI  R31,0
	SBRC R30,7
	SER  R31
	ST   -Y,R31
	ST   -Y,R30
	LDI  R30,LOW(58)
	LDI  R31,HIGH(58)
	ST   -Y,R31
	ST   -Y,R30
	LDI  R30,LOW(1)
	ST   -Y,R30
	CALL _gfx_Line
; 000C 0040 
; 000C 0041     tr[1] = CurModel.Mode[FLY_MODE].trimmers[1] / -6 + Trim1posY + 16;
	__POINTW2MN _CurModel,21
	LDS  R30,_FLY_MODE
	LDI  R31,0
	MOVW R22,R26
	LDI  R26,LOW(246)
	LDI  R27,HIGH(246)
	CALL __MULW12U
	ADD  R30,R22
	ADC  R31,R23
	SUBI R30,LOW(-243)
	SBCI R31,HIGH(-243)
	LD   R26,Z
	LDI  R30,LOW(250)
	CALL __DIVB21
	SUBI R30,-LOW(38)
	STD  Y+1,R30
; 000C 0042     gfx_Line(Trim1posX, Trim1posY, Trim1posX, Trim1posY + 32, 1);
	LDI  R30,LOW(127)
	LDI  R31,HIGH(127)
	ST   -Y,R31
	ST   -Y,R30
	LDI  R30,LOW(22)
	LDI  R31,HIGH(22)
	ST   -Y,R31
	ST   -Y,R30
	LDI  R30,LOW(127)
	LDI  R31,HIGH(127)
	ST   -Y,R31
	ST   -Y,R30
	LDI  R30,LOW(54)
	LDI  R31,HIGH(54)
	ST   -Y,R31
	ST   -Y,R30
	LDI  R30,LOW(1)
	ST   -Y,R30
	CALL _gfx_Line
; 000C 0043     gfx_PutPixel(Trim1posX - 1, Trim1posY     , 1); gfx_PutPixel(Trim1posX - 2, Trim1posY, 1);
	LDI  R30,LOW(126)
	ST   -Y,R30
	LDI  R30,LOW(22)
	ST   -Y,R30
	LDI  R30,LOW(1)
	ST   -Y,R30
	CALL _gfx_PutPixel
	LDI  R30,LOW(125)
	ST   -Y,R30
	LDI  R30,LOW(22)
	ST   -Y,R30
	LDI  R30,LOW(1)
	ST   -Y,R30
	CALL _gfx_PutPixel
; 000C 0044     gfx_PutPixel(Trim1posX - 1, Trim1posY +  4, 1);
	LDI  R30,LOW(126)
	ST   -Y,R30
	LDI  R30,LOW(26)
	ST   -Y,R30
	LDI  R30,LOW(1)
	ST   -Y,R30
	CALL _gfx_PutPixel
; 000C 0045     gfx_PutPixel(Trim1posX - 1, Trim1posY +  8, 1);
	LDI  R30,LOW(126)
	ST   -Y,R30
	LDI  R30,LOW(30)
	ST   -Y,R30
	LDI  R30,LOW(1)
	ST   -Y,R30
	CALL _gfx_PutPixel
; 000C 0046     gfx_PutPixel(Trim1posX - 1, Trim1posY + 12, 1);
	LDI  R30,LOW(126)
	ST   -Y,R30
	LDI  R30,LOW(34)
	ST   -Y,R30
	LDI  R30,LOW(1)
	ST   -Y,R30
	CALL _gfx_PutPixel
; 000C 0047     gfx_PutPixel(Trim1posX - 1, Trim1posY + 16, 1); gfx_PutPixel(Trim1posX - 2, Trim1posY + 16, 1);
	LDI  R30,LOW(126)
	ST   -Y,R30
	LDI  R30,LOW(38)
	ST   -Y,R30
	LDI  R30,LOW(1)
	ST   -Y,R30
	CALL _gfx_PutPixel
	LDI  R30,LOW(125)
	ST   -Y,R30
	LDI  R30,LOW(38)
	ST   -Y,R30
	LDI  R30,LOW(1)
	ST   -Y,R30
	CALL _gfx_PutPixel
; 000C 0048     gfx_PutPixel(Trim1posX - 1, Trim1posY + 20, 1);
	LDI  R30,LOW(126)
	ST   -Y,R30
	LDI  R30,LOW(42)
	ST   -Y,R30
	LDI  R30,LOW(1)
	ST   -Y,R30
	CALL _gfx_PutPixel
; 000C 0049     gfx_PutPixel(Trim1posX - 1, Trim1posY + 24, 1);
	LDI  R30,LOW(126)
	ST   -Y,R30
	LDI  R30,LOW(46)
	ST   -Y,R30
	LDI  R30,LOW(1)
	ST   -Y,R30
	CALL _gfx_PutPixel
; 000C 004A     gfx_PutPixel(Trim1posX - 1, Trim1posY + 28, 1);
	LDI  R30,LOW(126)
	ST   -Y,R30
	LDI  R30,LOW(50)
	ST   -Y,R30
	LDI  R30,LOW(1)
	ST   -Y,R30
	CALL _gfx_PutPixel
; 000C 004B     gfx_PutPixel(Trim1posX - 1, Trim1posY + 32, 1); gfx_PutPixel(Trim1posX - 2, Trim1posY + 32, 1);
	LDI  R30,LOW(126)
	ST   -Y,R30
	LDI  R30,LOW(54)
	ST   -Y,R30
	LDI  R30,LOW(1)
	ST   -Y,R30
	CALL _gfx_PutPixel
	LDI  R30,LOW(125)
	ST   -Y,R30
	LDI  R30,LOW(54)
	ST   -Y,R30
	LDI  R30,LOW(1)
	ST   -Y,R30
	CALL _gfx_PutPixel
; 000C 004C     gfx_PutPixel(Trim1posX - 3, tr[1], 1);
	LDI  R30,LOW(124)
	ST   -Y,R30
	LDD  R30,Y+2
	ST   -Y,R30
	LDI  R30,LOW(1)
	ST   -Y,R30
	CALL _gfx_PutPixel
; 000C 004D     gfx_Line(Trim1posX - 4, tr[1] - 1, Trim1posX - 4, tr[1] + 1, 1);
	LDI  R30,LOW(123)
	LDI  R31,HIGH(123)
	ST   -Y,R31
	ST   -Y,R30
	LDD  R30,Y+3
	SUBI R30,LOW(1)
	LDI  R31,0
	SBRC R30,7
	SER  R31
	ST   -Y,R31
	ST   -Y,R30
	LDI  R30,LOW(123)
	LDI  R31,HIGH(123)
	ST   -Y,R31
	ST   -Y,R30
	LDD  R30,Y+7
	SUBI R30,-LOW(1)
	LDI  R31,0
	SBRC R30,7
	SER  R31
	ST   -Y,R31
	ST   -Y,R30
	LDI  R30,LOW(1)
	ST   -Y,R30
	CALL _gfx_Line
; 000C 004E     gfx_Line(Trim1posX - 5, tr[1] - 2, Trim1posX - 5, tr[1] + 2, 1);
	LDI  R30,LOW(122)
	LDI  R31,HIGH(122)
	ST   -Y,R31
	ST   -Y,R30
	LDD  R30,Y+3
	SUBI R30,LOW(2)
	LDI  R31,0
	SBRC R30,7
	SER  R31
	ST   -Y,R31
	ST   -Y,R30
	LDI  R30,LOW(122)
	LDI  R31,HIGH(122)
	ST   -Y,R31
	ST   -Y,R30
	LDD  R30,Y+7
	SUBI R30,-LOW(2)
	LDI  R31,0
	SBRC R30,7
	SER  R31
	ST   -Y,R31
	ST   -Y,R30
	LDI  R30,LOW(1)
	ST   -Y,R30
	CALL _gfx_Line
; 000C 004F 
; 000C 0050     tr[2] = CurModel.Mode[FLY_MODE].trimmers[2]/ -6 + Trim1posY + 16;
	__POINTW2MN _CurModel,21
	LDS  R30,_FLY_MODE
	LDI  R31,0
	MOVW R22,R26
	LDI  R26,LOW(246)
	LDI  R27,HIGH(246)
	CALL __MULW12U
	ADD  R30,R22
	ADC  R31,R23
	SUBI R30,LOW(-244)
	SBCI R31,HIGH(-244)
	LD   R26,Z
	LDI  R30,LOW(250)
	CALL __DIVB21
	SUBI R30,-LOW(38)
	STD  Y+2,R30
; 000C 0051     gfx_Line(Trim2posX, Trim1posY, Trim2posX, Trim1posY + 32, 1);
	LDI  R30,LOW(0)
	LDI  R31,HIGH(0)
	ST   -Y,R31
	ST   -Y,R30
	LDI  R30,LOW(22)
	LDI  R31,HIGH(22)
	ST   -Y,R31
	ST   -Y,R30
	LDI  R30,LOW(0)
	LDI  R31,HIGH(0)
	ST   -Y,R31
	ST   -Y,R30
	LDI  R30,LOW(54)
	LDI  R31,HIGH(54)
	ST   -Y,R31
	ST   -Y,R30
	LDI  R30,LOW(1)
	ST   -Y,R30
	CALL _gfx_Line
; 000C 0052     gfx_PutPixel(Trim2posX + 1, Trim1posY     , 1); gfx_PutPixel(Trim2posX + 2, Trim1posY, 1);
	LDI  R30,LOW(1)
	ST   -Y,R30
	LDI  R30,LOW(22)
	ST   -Y,R30
	LDI  R30,LOW(1)
	ST   -Y,R30
	CALL _gfx_PutPixel
	LDI  R30,LOW(2)
	ST   -Y,R30
	LDI  R30,LOW(22)
	ST   -Y,R30
	LDI  R30,LOW(1)
	ST   -Y,R30
	CALL _gfx_PutPixel
; 000C 0053     gfx_PutPixel(Trim2posX + 1, Trim1posY +  4, 1);
	LDI  R30,LOW(1)
	ST   -Y,R30
	LDI  R30,LOW(26)
	ST   -Y,R30
	LDI  R30,LOW(1)
	ST   -Y,R30
	CALL _gfx_PutPixel
; 000C 0054     gfx_PutPixel(Trim2posX + 1, Trim1posY +  8, 1);
	LDI  R30,LOW(1)
	ST   -Y,R30
	LDI  R30,LOW(30)
	ST   -Y,R30
	LDI  R30,LOW(1)
	ST   -Y,R30
	CALL _gfx_PutPixel
; 000C 0055     gfx_PutPixel(Trim2posX + 1, Trim1posY + 12, 1);
	LDI  R30,LOW(1)
	ST   -Y,R30
	LDI  R30,LOW(34)
	ST   -Y,R30
	LDI  R30,LOW(1)
	ST   -Y,R30
	CALL _gfx_PutPixel
; 000C 0056     gfx_PutPixel(Trim2posX + 1, Trim1posY + 16, 1); gfx_PutPixel(Trim2posX + 2, Trim1posY + 16, 1);
	LDI  R30,LOW(1)
	ST   -Y,R30
	LDI  R30,LOW(38)
	ST   -Y,R30
	LDI  R30,LOW(1)
	ST   -Y,R30
	CALL _gfx_PutPixel
	LDI  R30,LOW(2)
	ST   -Y,R30
	LDI  R30,LOW(38)
	ST   -Y,R30
	LDI  R30,LOW(1)
	ST   -Y,R30
	CALL _gfx_PutPixel
; 000C 0057     gfx_PutPixel(Trim2posX + 1, Trim1posY + 20, 1);
	LDI  R30,LOW(1)
	ST   -Y,R30
	LDI  R30,LOW(42)
	ST   -Y,R30
	LDI  R30,LOW(1)
	ST   -Y,R30
	CALL _gfx_PutPixel
; 000C 0058     gfx_PutPixel(Trim2posX + 1, Trim1posY + 24, 1);
	LDI  R30,LOW(1)
	ST   -Y,R30
	LDI  R30,LOW(46)
	ST   -Y,R30
	LDI  R30,LOW(1)
	ST   -Y,R30
	CALL _gfx_PutPixel
; 000C 0059     gfx_PutPixel(Trim2posX + 1, Trim1posY + 28, 1);
	LDI  R30,LOW(1)
	ST   -Y,R30
	LDI  R30,LOW(50)
	ST   -Y,R30
	LDI  R30,LOW(1)
	ST   -Y,R30
	CALL _gfx_PutPixel
; 000C 005A     gfx_PutPixel(Trim2posX + 1, Trim1posY + 32, 1); gfx_PutPixel(Trim2posX + 2, Trim1posY + 32, 1);
	LDI  R30,LOW(1)
	ST   -Y,R30
	LDI  R30,LOW(54)
	ST   -Y,R30
	LDI  R30,LOW(1)
	ST   -Y,R30
	CALL _gfx_PutPixel
	LDI  R30,LOW(2)
	ST   -Y,R30
	LDI  R30,LOW(54)
	ST   -Y,R30
	LDI  R30,LOW(1)
	ST   -Y,R30
	CALL _gfx_PutPixel
; 000C 005B     gfx_PutPixel(Trim2posX + 3, tr[2], 1);
	LDI  R30,LOW(3)
	ST   -Y,R30
	LDD  R30,Y+3
	ST   -Y,R30
	LDI  R30,LOW(1)
	ST   -Y,R30
	CALL _gfx_PutPixel
; 000C 005C     gfx_Line(Trim2posX + 4, tr[2] - 1, Trim2posX + 4, tr[2] + 1, 1);
	LDI  R30,LOW(4)
	LDI  R31,HIGH(4)
	ST   -Y,R31
	ST   -Y,R30
	LDD  R30,Y+4
	SUBI R30,LOW(1)
	LDI  R31,0
	SBRC R30,7
	SER  R31
	ST   -Y,R31
	ST   -Y,R30
	LDI  R30,LOW(4)
	LDI  R31,HIGH(4)
	ST   -Y,R31
	ST   -Y,R30
	LDD  R30,Y+8
	SUBI R30,-LOW(1)
	LDI  R31,0
	SBRC R30,7
	SER  R31
	ST   -Y,R31
	ST   -Y,R30
	LDI  R30,LOW(1)
	ST   -Y,R30
	CALL _gfx_Line
; 000C 005D     gfx_Line(Trim2posX + 5, tr[2] - 2, Trim2posX + 5, tr[2] + 2, 1);
	LDI  R30,LOW(5)
	LDI  R31,HIGH(5)
	ST   -Y,R31
	ST   -Y,R30
	LDD  R30,Y+4
	SUBI R30,LOW(2)
	LDI  R31,0
	SBRC R30,7
	SER  R31
	ST   -Y,R31
	ST   -Y,R30
	LDI  R30,LOW(5)
	LDI  R31,HIGH(5)
	ST   -Y,R31
	ST   -Y,R30
	LDD  R30,Y+8
	SUBI R30,-LOW(2)
	LDI  R31,0
	SBRC R30,7
	SER  R31
	ST   -Y,R31
	ST   -Y,R30
	LDI  R30,LOW(1)
	ST   -Y,R30
	CALL _gfx_Line
; 000C 005E 
; 000C 005F     tr[3] = CurModel.Mode[FLY_MODE].trimmers[3] / 6 + Trim3posX + 16;
	__POINTW2MN _CurModel,21
	LDS  R30,_FLY_MODE
	LDI  R31,0
	MOVW R22,R26
	LDI  R26,LOW(246)
	LDI  R27,HIGH(246)
	CALL __MULW12U
	ADD  R30,R22
	ADC  R31,R23
	SUBI R30,LOW(-245)
	SBCI R31,HIGH(-245)
	LD   R26,Z
	LDI  R30,LOW(6)
	CALL __DIVB21
	SUBI R30,-LOW(26)
	STD  Y+3,R30
; 000C 0060     gfx_Line(Trim3posX, Trim3posY, Trim3posX + 32, Trim3posY, 1);
	LDI  R30,LOW(10)
	LDI  R31,HIGH(10)
	ST   -Y,R31
	ST   -Y,R30
	LDI  R30,LOW(63)
	LDI  R31,HIGH(63)
	ST   -Y,R31
	ST   -Y,R30
	LDI  R30,LOW(42)
	LDI  R31,HIGH(42)
	ST   -Y,R31
	ST   -Y,R30
	LDI  R30,LOW(63)
	LDI  R31,HIGH(63)
	ST   -Y,R31
	ST   -Y,R30
	LDI  R30,LOW(1)
	ST   -Y,R30
	CALL _gfx_Line
; 000C 0061     gfx_PutPixel(Trim3posX     , Trim3posY - 1, 1); gfx_PutPixel(Trim3posX, Trim3posY - 2, 1);
	LDI  R30,LOW(10)
	ST   -Y,R30
	LDI  R30,LOW(62)
	ST   -Y,R30
	LDI  R30,LOW(1)
	ST   -Y,R30
	CALL _gfx_PutPixel
	LDI  R30,LOW(10)
	ST   -Y,R30
	LDI  R30,LOW(61)
	ST   -Y,R30
	LDI  R30,LOW(1)
	ST   -Y,R30
	CALL _gfx_PutPixel
; 000C 0062     gfx_PutPixel(Trim3posX +  4, Trim3posY - 1, 1);
	LDI  R30,LOW(14)
	ST   -Y,R30
	LDI  R30,LOW(62)
	ST   -Y,R30
	LDI  R30,LOW(1)
	ST   -Y,R30
	CALL _gfx_PutPixel
; 000C 0063     gfx_PutPixel(Trim3posX +  8, Trim3posY - 1, 1);
	LDI  R30,LOW(18)
	ST   -Y,R30
	LDI  R30,LOW(62)
	ST   -Y,R30
	LDI  R30,LOW(1)
	ST   -Y,R30
	CALL _gfx_PutPixel
; 000C 0064     gfx_PutPixel(Trim3posX + 12, Trim3posY - 1, 1);
	LDI  R30,LOW(22)
	ST   -Y,R30
	LDI  R30,LOW(62)
	ST   -Y,R30
	LDI  R30,LOW(1)
	ST   -Y,R30
	CALL _gfx_PutPixel
; 000C 0065     gfx_PutPixel(Trim3posX + 16, Trim3posY - 1, 1); gfx_PutPixel(Trim3posX + 16, Trim3posY - 2, 1);
	LDI  R30,LOW(26)
	ST   -Y,R30
	LDI  R30,LOW(62)
	ST   -Y,R30
	LDI  R30,LOW(1)
	ST   -Y,R30
	CALL _gfx_PutPixel
	LDI  R30,LOW(26)
	ST   -Y,R30
	LDI  R30,LOW(61)
	ST   -Y,R30
	LDI  R30,LOW(1)
	ST   -Y,R30
	CALL _gfx_PutPixel
; 000C 0066     gfx_PutPixel(Trim3posX + 20, Trim3posY - 1, 1);
	LDI  R30,LOW(30)
	ST   -Y,R30
	LDI  R30,LOW(62)
	ST   -Y,R30
	LDI  R30,LOW(1)
	ST   -Y,R30
	CALL _gfx_PutPixel
; 000C 0067     gfx_PutPixel(Trim3posX + 24, Trim3posY - 1, 1);
	LDI  R30,LOW(34)
	ST   -Y,R30
	LDI  R30,LOW(62)
	ST   -Y,R30
	LDI  R30,LOW(1)
	ST   -Y,R30
	CALL _gfx_PutPixel
; 000C 0068     gfx_PutPixel(Trim3posX + 28, Trim3posY - 1, 1);
	LDI  R30,LOW(38)
	ST   -Y,R30
	LDI  R30,LOW(62)
	ST   -Y,R30
	LDI  R30,LOW(1)
	ST   -Y,R30
	CALL _gfx_PutPixel
; 000C 0069     gfx_PutPixel(Trim3posX + 32, Trim3posY - 1, 1); gfx_PutPixel(Trim3posX + 32, Trim3posY - 2, 1);
	LDI  R30,LOW(42)
	ST   -Y,R30
	LDI  R30,LOW(62)
	ST   -Y,R30
	LDI  R30,LOW(1)
	ST   -Y,R30
	CALL _gfx_PutPixel
	LDI  R30,LOW(42)
	ST   -Y,R30
	LDI  R30,LOW(61)
	ST   -Y,R30
	LDI  R30,LOW(1)
	ST   -Y,R30
	CALL _gfx_PutPixel
; 000C 006A     gfx_PutPixel(tr[3], Trim3posY - 3, 1);
	LDD  R30,Y+3
	ST   -Y,R30
	LDI  R30,LOW(60)
	ST   -Y,R30
	LDI  R30,LOW(1)
	ST   -Y,R30
	CALL _gfx_PutPixel
; 000C 006B     gfx_Line(tr[3] - 1, Trim3posY - 4, tr[3] + 1, Trim3posY - 4, 1);
	LDD  R30,Y+3
	SUBI R30,LOW(1)
	LDI  R31,0
	SBRC R30,7
	SER  R31
	ST   -Y,R31
	ST   -Y,R30
	LDI  R30,LOW(59)
	LDI  R31,HIGH(59)
	ST   -Y,R31
	ST   -Y,R30
	LDD  R30,Y+7
	SUBI R30,-LOW(1)
	LDI  R31,0
	SBRC R30,7
	SER  R31
	ST   -Y,R31
	ST   -Y,R30
	LDI  R30,LOW(59)
	LDI  R31,HIGH(59)
	ST   -Y,R31
	ST   -Y,R30
	LDI  R30,LOW(1)
	ST   -Y,R30
	CALL _gfx_Line
; 000C 006C     gfx_Line(tr[3] - 2, Trim3posY - 5, tr[3] + 2, Trim3posY - 5, 1);
	LDD  R30,Y+3
	SUBI R30,LOW(2)
	LDI  R31,0
	SBRC R30,7
	SER  R31
	ST   -Y,R31
	ST   -Y,R30
	LDI  R30,LOW(58)
	LDI  R31,HIGH(58)
	ST   -Y,R31
	ST   -Y,R30
	LDD  R30,Y+7
	SUBI R30,-LOW(2)
	LDI  R31,0
	SBRC R30,7
	SER  R31
	ST   -Y,R31
	ST   -Y,R30
	LDI  R30,LOW(58)
	LDI  R31,HIGH(58)
	ST   -Y,R31
	ST   -Y,R30
	LDI  R30,LOW(1)
	ST   -Y,R30
	CALL _gfx_Line
; 000C 006D }
	RJMP _0x206000D
;
;// *****************************************************************************
;// ***    PPM    ****************************************************
;// *****************************************************************************
;void Show_PPM(unsigned char X, unsigned char Y)
; 000C 0073 {
_Show_PPM:
; 000C 0074     unsigned char i;
; 000C 0075     unsigned char len = 1;
; 000C 0076 
; 000C 0077     if     (CurModel.modulation == 0) gfx_Line(X, Y + 5, X + 100, Y + 5, 0xFF);
	ST   -Y,R17
	ST   -Y,R16
;	X -> Y+3
;	Y -> Y+2
;	i -> R17
;	len -> R16
	LDI  R16,1
	__GETB1MN _CurModel,16
	CPI  R30,0
	BRNE _0x180003
	LDD  R30,Y+3
	LDI  R31,0
	ST   -Y,R31
	ST   -Y,R30
	LDD  R30,Y+4
	SUBI R30,-LOW(5)
	LDI  R31,0
	ST   -Y,R31
	ST   -Y,R30
	LDD  R30,Y+7
	SUBI R30,-LOW(100)
	LDI  R31,0
	ST   -Y,R31
	ST   -Y,R30
	LDD  R30,Y+8
	SUBI R30,-LOW(5)
	RJMP _0x18009B
; 000C 0078     else if(CurModel.modulation == 1) gfx_Line(X, Y, X + 100, Y, 0xFF);
_0x180003:
	__GETB2MN _CurModel,16
	CPI  R26,LOW(0x1)
	BRNE _0x180005
	LDD  R30,Y+3
	LDI  R31,0
	ST   -Y,R31
	ST   -Y,R30
	LDD  R30,Y+4
	LDI  R31,0
	ST   -Y,R31
	ST   -Y,R30
	LDD  R30,Y+7
	SUBI R30,-LOW(100)
	LDI  R31,0
	ST   -Y,R31
	ST   -Y,R30
	LDD  R30,Y+8
_0x18009B:
	LDI  R31,0
	ST   -Y,R31
	ST   -Y,R30
	LDI  R30,LOW(255)
	ST   -Y,R30
	CALL _gfx_Line
; 000C 0079     gfx_Line(X, Y, X, Y + 5, 0xFF);
_0x180005:
	LDD  R30,Y+3
	LDI  R31,0
	ST   -Y,R31
	ST   -Y,R30
	LDD  R30,Y+4
	LDI  R31,0
	ST   -Y,R31
	ST   -Y,R30
	LDD  R30,Y+7
	LDI  R31,0
	ST   -Y,R31
	ST   -Y,R30
	LDD  R30,Y+8
	SUBI R30,-LOW(5)
	LDI  R31,0
	ST   -Y,R31
	ST   -Y,R30
	LDI  R30,LOW(255)
	ST   -Y,R30
	CALL _gfx_Line
; 000C 007A 
; 000C 007B     for(i=0; i < CurModel.num_ch; i++)
	LDI  R17,LOW(0)
_0x180007:
	__GETB1MN _CurModel,20
	MOV  R26,R17
	LDI  R27,0
	LDI  R31,0
	SBRC R30,7
	SER  R31
	CP   R26,R30
	CPC  R27,R31
	BRGE _0x180008
; 000C 007C     {
; 000C 007D         len += output[i] / TimerClockPerSec(0.0002); //    
	MOV  R30,R17
	LDI  R26,LOW(_output)
	LDI  R27,HIGH(_output)
	LDI  R31,0
	LSL  R30
	ROL  R31
	ADD  R26,R30
	ADC  R27,R31
	CALL __GETW1P
	MOVW R26,R30
	LDI  R30,LOW(400)
	LDI  R31,HIGH(400)
	CALL __DIVW21
	ADD  R16,R30
; 000C 007E         gfx_Line(X + len, Y, X + len, Y + 5, 0xFF);
	MOV  R30,R16
	LDD  R26,Y+3
	ADD  R30,R26
	LDI  R31,0
	ST   -Y,R31
	ST   -Y,R30
	LDD  R30,Y+4
	LDI  R31,0
	ST   -Y,R31
	ST   -Y,R30
	MOV  R30,R16
	LDD  R26,Y+7
	ADD  R30,R26
	LDI  R31,0
	ST   -Y,R31
	ST   -Y,R30
	LDD  R30,Y+8
	SUBI R30,-LOW(5)
	LDI  R31,0
	ST   -Y,R31
	ST   -Y,R30
	LDI  R30,LOW(255)
	ST   -Y,R30
	CALL _gfx_Line
; 000C 007F     }
	SUBI R17,-1
	RJMP _0x180007
_0x180008:
; 000C 0080 }
	LDD  R17,Y+1
	LDD  R16,Y+0
_0x206000D:
	ADIW R28,4
	RET
;
;#define TimerPosX ((WidthS - 7 * Font_12x16.W) / 2)
;#define TimerPosY (HeightS-10-16-8)
;
;// *****************************************************************************
;// ***        *******************************************
;// *****************************************************************************
;void MainScreen(void)
; 000C 0089 {
_MainScreen:
; 000C 008A     signed int U_bat;
; 000C 008B     char min[2], sec[2], ms;
; 000C 008C     int time, subtime;
; 000C 008D 
; 000C 008E     //  
; 000C 008F     gfx_ClearBuf();
	SBIW R28,6
	CALL __SAVELOCR6
;	U_bat -> R16,R17
;	min -> Y+10
;	sec -> Y+8
;	ms -> R19
;	time -> R20,R21
;	subtime -> Y+6
	CALL _gfx_ClearBuf
; 000C 0090 
; 000C 0091     gfx_SetXY(0, 0);
	LDI  R30,LOW(0)
	ST   -Y,R30
	ST   -Y,R30
	CALL _gfx_SetXY
; 000C 0092     //  
; 000C 0093     sprintf(tmpBuf, "%d", Settings.ModelNum + 1);
	LDI  R30,LOW(_tmpBuf)
	LDI  R31,HIGH(_tmpBuf)
	ST   -Y,R31
	ST   -Y,R30
	__POINTW1FN _0x180000,0
	ST   -Y,R31
	ST   -Y,R30
	__GETB1MN _Settings,5
	SUBI R30,-LOW(1)
	CALL __CBD1
	CALL __PUTPARD1
	LDI  R24,4
	CALL _sprintf
	ADIW R28,8
; 000C 0094     gfx_PutStr(tmpBuf, 0xFF, &Font_8x12);
	LDI  R30,LOW(_tmpBuf)
	LDI  R31,HIGH(_tmpBuf)
	ST   -Y,R31
	ST   -Y,R30
	LDI  R30,LOW(255)
	ST   -Y,R30
	LDI  R30,LOW(_Font_8x12)
	LDI  R31,HIGH(_Font_8x12)
	ST   -Y,R31
	ST   -Y,R30
	CALL _gfx_PutStr
; 000C 0095     //     3     
; 000C 0096     gfx_ChangeXY(3, (Font_8x12.H - Font_8x8.H) / 2);
	LDI  R30,LOW(3)
	ST   -Y,R30
	__GETB2MN _Font_8x12,1
	__GETB1MN _Font_8x8,1
	SUB  R26,R30
	MOV  R30,R26
	LSR  R30
	ST   -Y,R30
	CALL _gfx_ChangeXY
; 000C 0097     //  
; 000C 0098     if(CurModel.type == TYPE_HELI)
	__GETB2MN _CurModel,15
	CPI  R26,LOW(0x1)
	BRNE _0x180009
; 000C 0099     {
; 000C 009A         gfx_Char(125, 0xFF, &Font_8x8);
	LDI  R30,LOW(125)
	ST   -Y,R30
	LDI  R30,LOW(255)
	ST   -Y,R30
	LDI  R30,LOW(_Font_8x8)
	LDI  R31,HIGH(_Font_8x8)
	ST   -Y,R31
	ST   -Y,R30
	CALL _gfx_Char
; 000C 009B         gfx_Char(126, 0xFF, &Font_8x8);
	LDI  R30,LOW(126)
	ST   -Y,R30
	LDI  R30,LOW(255)
	ST   -Y,R30
	LDI  R30,LOW(_Font_8x8)
	LDI  R31,HIGH(_Font_8x8)
	ST   -Y,R31
	ST   -Y,R30
	CALL _gfx_Char
; 000C 009C     }
; 000C 009D     //  
; 000C 009E     if(CurModel.type == TYPE_PLANE)
_0x180009:
	__GETB1MN _CurModel,15
	CPI  R30,0
	BRNE _0x18000A
; 000C 009F     {
; 000C 00A0         gfx_Char(127, 0xFF, &Font_8x8);
	LDI  R30,LOW(127)
	ST   -Y,R30
	LDI  R30,LOW(255)
	ST   -Y,R30
	LDI  R30,LOW(_Font_8x8)
	LDI  R31,HIGH(_Font_8x8)
	ST   -Y,R31
	ST   -Y,R30
	CALL _gfx_Char
; 000C 00A1         gfx_Char(128, 0xFF, &Font_8x8);
	LDI  R30,LOW(128)
	ST   -Y,R30
	LDI  R30,LOW(255)
	ST   -Y,R30
	LDI  R30,LOW(_Font_8x8)
	LDI  R31,HIGH(_Font_8x8)
	ST   -Y,R31
	ST   -Y,R30
	CALL _gfx_Char
; 000C 00A2     }
; 000C 00A3     //     3     
; 000C 00A4     gfx_ChangeXY(3, - (char)(Font_8x12.H - Font_8x8.H) / 2);
_0x18000A:
	LDI  R30,LOW(3)
	ST   -Y,R30
	__GETB1MN _Font_8x12,1
	__GETB2MN _Font_8x8,1
	SUB  R30,R26
	NEG  R30
	MOV  R26,R30
	LDI  R30,LOW(2)
	CALL __DIVB21
	ST   -Y,R30
	CALL _gfx_ChangeXY
; 000C 00A5     //  
; 000C 00A6     gfx_PutStr(CurModel.name, 0xFF, &Font_8x12);
	__POINTW1MN _CurModel,2
	ST   -Y,R31
	ST   -Y,R30
	LDI  R30,LOW(255)
	ST   -Y,R30
	LDI  R30,LOW(_Font_8x12)
	LDI  R31,HIGH(_Font_8x12)
	ST   -Y,R31
	ST   -Y,R30
	CALL _gfx_PutStr
; 000C 00A7 
; 000C 00A8     //   
; 000C 00A9     if(Cut_enable)
	LDS  R30,_Cut_enable
	CPI  R30,0
	BREQ _0x18000B
; 000C 00AA     {
; 000C 00AB         gfx_SetXY(80, 12);
	LDI  R30,LOW(80)
	ST   -Y,R30
	LDI  R30,LOW(12)
	ST   -Y,R30
	CALL _gfx_SetXY
; 000C 00AC         gfx_Char_8x8(129, 0xFF);
	LDI  R30,LOW(129)
	ST   -Y,R30
	LDI  R30,LOW(255)
	ST   -Y,R30
	CALL _gfx_Char_8x8
; 000C 00AD         gfx_Char_8x8(130, 0xFF);
	LDI  R30,LOW(130)
	ST   -Y,R30
	LDI  R30,LOW(255)
	ST   -Y,R30
	CALL _gfx_Char_8x8
; 000C 00AE         gfx_SetXY(80, 20);
	LDI  R30,LOW(80)
	ST   -Y,R30
	LDI  R30,LOW(20)
	ST   -Y,R30
	CALL _gfx_SetXY
; 000C 00AF         gfx_Char_8x8(131, 0xFF);
	LDI  R30,LOW(131)
	ST   -Y,R30
	LDI  R30,LOW(255)
	ST   -Y,R30
	CALL _gfx_Char_8x8
; 000C 00B0         gfx_Char_8x8(132, 0xFF);
	LDI  R30,LOW(132)
	ST   -Y,R30
	LDI  R30,LOW(255)
	ST   -Y,R30
	CALL _gfx_Char_8x8
; 000C 00B1     }
; 000C 00B2 
; 000C 00B3     //  
; 000C 00B4     gfx_SetXY(WidthS - 6 * Font_4x6.W, Font_8x12.H + (Font_8x8.H - Font_4x6.H) / 2);
_0x18000B:
	LDS  R30,_Font_4x6
	LDI  R26,LOW(6)
	MUL  R30,R26
	MOVW R30,R0
	LDI  R26,LOW(128)
	SUB  R26,R30
	ST   -Y,R26
	__GETBRMN 0,_Font_8x12,1
	__GETB2MN _Font_8x8,1
	__GETB1MN _Font_4x6,1
	SUB  R26,R30
	MOV  R30,R26
	LSR  R30
	ADD  R30,R0
	ST   -Y,R30
	CALL _gfx_SetXY
; 000C 00B5     U_bat = GetBatteryStatus();
	CALL _GetBatteryStatus
	MOVW R16,R30
; 000C 00B6     sprintf(tmpBuf, "%2i.%02iV", U_bat / 100, U_bat % 100);
	LDI  R30,LOW(_tmpBuf)
	LDI  R31,HIGH(_tmpBuf)
	ST   -Y,R31
	ST   -Y,R30
	__POINTW1FN _0x180000,3
	ST   -Y,R31
	ST   -Y,R30
	MOVW R26,R16
	LDI  R30,LOW(100)
	LDI  R31,HIGH(100)
	CALL __DIVW21
	CALL __CWD1
	CALL __PUTPARD1
	MOVW R26,R16
	LDI  R30,LOW(100)
	LDI  R31,HIGH(100)
	CALL __MODW21
	CALL __CWD1
	CALL __PUTPARD1
	LDI  R24,8
	CALL _sprintf
	ADIW R28,12
; 000C 00B7     gfx_PutStr(tmpBuf, 0xFF, &Font_4x6);
	LDI  R30,LOW(_tmpBuf)
	LDI  R31,HIGH(_tmpBuf)
	ST   -Y,R31
	ST   -Y,R30
	LDI  R30,LOW(255)
	ST   -Y,R30
	LDI  R30,LOW(_Font_4x6)
	LDI  R31,HIGH(_Font_4x6)
	ST   -Y,R31
	ST   -Y,R30
	CALL _gfx_PutStr
; 000C 00B8 
; 000C 00B9     //  
; 000C 00BA     gfx_SetXY(0, Font_8x12.H);
	LDI  R30,LOW(0)
	ST   -Y,R30
	__GETB1MN _Font_8x12,1
	ST   -Y,R30
	CALL _gfx_SetXY
; 000C 00BB     gfx_PutStr(CurModel.Mode[FLY_MODE].name, 0xFF, &Font_8x8);
	__POINTW2MN _CurModel,21
	LDS  R30,_FLY_MODE
	LDI  R31,0
	MOVW R22,R26
	LDI  R26,LOW(246)
	LDI  R27,HIGH(246)
	CALL __MULW12U
	ADD  R30,R22
	ADC  R31,R23
	ST   -Y,R31
	ST   -Y,R30
	LDI  R30,LOW(255)
	ST   -Y,R30
	LDI  R30,LOW(_Font_8x8)
	LDI  R31,HIGH(_Font_8x8)
	ST   -Y,R31
	ST   -Y,R30
	CALL _gfx_PutStr
; 000C 00BC 
; 000C 00BD     // 
; 000C 00BE     time = GetTimerValue();
	CALL _GetTimerValue
	MOVW R20,R30
; 000C 00BF     subtime = GetTimerSubValue();
	CALL _GetTimerSubValue
	STD  Y+6,R30
	STD  Y+6+1,R31
; 000C 00C0     min[0] = time/600;         //  -  
	MOVW R26,R20
	LDI  R30,LOW(600)
	LDI  R31,HIGH(600)
	CALL __DIVW21
	STD  Y+10,R30
; 000C 00C1     min[1] = time/60 % 10;     //  -  
	MOVW R26,R20
	LDI  R30,LOW(60)
	LDI  R31,HIGH(60)
	CALL __DIVW21
	MOVW R26,R30
	LDI  R30,LOW(10)
	LDI  R31,HIGH(10)
	CALL __MODW21
	STD  Y+11,R30
; 000C 00C2     sec[0] = time%60 / 10;     //  -  
	MOVW R26,R20
	LDI  R30,LOW(60)
	LDI  R31,HIGH(60)
	CALL __MODW21
	MOVW R26,R30
	LDI  R30,LOW(10)
	LDI  R31,HIGH(10)
	CALL __DIVW21
	STD  Y+8,R30
; 000C 00C3     sec[1] = time%10;          //  -  
	MOVW R26,R20
	LDI  R30,LOW(10)
	LDI  R31,HIGH(10)
	CALL __MODW21
	STD  Y+9,R30
; 000C 00C4     ms     = subtime/100;      // 
	LDD  R26,Y+6
	LDD  R27,Y+6+1
	LDI  R30,LOW(100)
	LDI  R31,HIGH(100)
	CALL __DIVW21
	MOV  R19,R30
; 000C 00C5 
; 000C 00C6     gfx_SetXY(TimerPosX, TimerPosY);
	LDS  R30,_Font_12x16
	LDI  R26,LOW(7)
	MUL  R30,R26
	MOVW R30,R0
	LDI  R26,LOW(128)
	SUB  R26,R30
	MOV  R30,R26
	LSR  R30
	ST   -Y,R30
	LDI  R30,LOW(30)
	ST   -Y,R30
	CALL _gfx_SetXY
; 000C 00C7     gfx_Deg_12x16(min[0], 0xFF);
	LDD  R30,Y+10
	ST   -Y,R30
	LDI  R30,LOW(255)
	ST   -Y,R30
	CALL _gfx_Deg_12x16
; 000C 00C8     gfx_Deg_12x16(min[1], 0xFF);
	LDD  R30,Y+11
	ST   -Y,R30
	LDI  R30,LOW(255)
	ST   -Y,R30
	CALL _gfx_Deg_12x16
; 000C 00C9     gfx_Char(':', 0xFF, &Font_12x16);
	LDI  R30,LOW(58)
	ST   -Y,R30
	LDI  R30,LOW(255)
	ST   -Y,R30
	LDI  R30,LOW(_Font_12x16)
	LDI  R31,HIGH(_Font_12x16)
	ST   -Y,R31
	ST   -Y,R30
	CALL _gfx_Char
; 000C 00CA     gfx_Deg_12x16(sec[0], 0xFF);
	LDD  R30,Y+8
	ST   -Y,R30
	LDI  R30,LOW(255)
	ST   -Y,R30
	CALL _gfx_Deg_12x16
; 000C 00CB     gfx_Deg_12x16(sec[1], 0xFF);
	LDD  R30,Y+9
	ST   -Y,R30
	LDI  R30,LOW(255)
	ST   -Y,R30
	CALL _gfx_Deg_12x16
; 000C 00CC     gfx_Char('.', 0xFF, &Font_12x16);
	LDI  R30,LOW(46)
	ST   -Y,R30
	LDI  R30,LOW(255)
	ST   -Y,R30
	LDI  R30,LOW(_Font_12x16)
	LDI  R31,HIGH(_Font_12x16)
	ST   -Y,R31
	ST   -Y,R30
	CALL _gfx_Char
; 000C 00CD     gfx_Deg_12x16(ms, 0xFF);
	ST   -Y,R19
	LDI  R30,LOW(255)
	ST   -Y,R30
	CALL _gfx_Deg_12x16
; 000C 00CE 
; 000C 00CF     //   
; 000C 00D0     wr_trimmer();
	RCALL _wr_trimmer
; 000C 00D1 
; 000C 00D2     //  PPM   
; 000C 00D3     Show_PPM((WidthS - 100) / 2, HeightS - 15);
	LDI  R30,LOW(14)
	ST   -Y,R30
	LDI  R30,LOW(49)
	ST   -Y,R30
	RCALL _Show_PPM
; 000C 00D4 
; 000C 00D5     //  
; 000C 00D6     gfx_Refresh();
	CALL _gfx_Refresh
; 000C 00D7 }
	CALL __LOADLOCR6
	ADIW R28,12
	RET
;
;// *****************************************************************************
;// ***        ****************************************
;// *****************************************************************************
;void ModelCopy(char AddParam)
; 000C 00DD {
_ModelCopy:
; 000C 00DE     //   
; 000C 00DF     unsigned char i, j;
; 000C 00E0     //    
; 000C 00E1     int result;
; 000C 00E2     //       
; 000C 00E3     char ModelsStr[MAX_MODELS][MODEL_NAME_LEN];
; 000C 00E4     //       
; 000C 00E5     char * ModelsStrPtrs[MAX_MODELS];
; 000C 00E6     //      
; 000C 00E7     char From, To;
; 000C 00E8 
; 000C 00E9 #ifdef DEBUG
; 000C 00EA     printf("ModelCopy();\r");
; 000C 00EB     delay_ms(1);
; 000C 00EC #endif
; 000C 00ED 
; 000C 00EE     //  
; 000C 00EF     for(i=0; i < MAX_MODELS; i++)
	SBIW R28,63
	SBIW R28,12
	CALL __SAVELOCR6
;	AddParam -> Y+81
;	i -> R17
;	j -> R16
;	result -> R18,R19
;	ModelsStr -> Y+16
;	ModelsStrPtrs -> Y+6
;	From -> R21
;	To -> R20
	LDI  R17,LOW(0)
_0x18000D:
	CPI  R17,5
	BRSH _0x18000E
; 000C 00F0     {
; 000C 00F1         //     
; 000C 00F2         for(j=0; j < NumberOf(EEPROM_MODEL[i].name); j++) ModelsStr[i][j] = EEPROM_MODEL[i].name[j];
	LDI  R16,LOW(0)
_0x180010:
	CPI  R16,13
	BRSH _0x180011
	LDI  R26,LOW(13)
	MUL  R17,R26
	MOVW R30,R0
	MOVW R26,R28
	ADIW R26,16
	ADD  R26,R30
	ADC  R27,R31
	MOV  R30,R16
	LDI  R31,0
	ADD  R30,R26
	ADC  R31,R27
	MOVW R22,R30
	MOV  R30,R17
	LDI  R31,0
	LDI  R26,LOW(759)
	LDI  R27,HIGH(759)
	CALL __MULW12U
	__ADDW1MN _EEPROM_MODEL,2
	MOVW R26,R30
	CLR  R30
	ADD  R26,R16
	ADC  R27,R30
	CALL __EEPROMRDB
	MOVW R26,R22
	ST   X,R30
	SUBI R16,-1
	RJMP _0x180010
_0x180011:
; 000C 00F4 ModelsStrPtrs[i] = ModelsStr[i];
	MOV  R30,R17
	LDI  R31,0
	MOVW R26,R28
	ADIW R26,6
	LSL  R30
	ROL  R31
	ADD  R30,R26
	ADC  R31,R27
	MOVW R22,R30
	LDI  R26,LOW(13)
	MUL  R17,R26
	MOVW R30,R0
	MOVW R26,R28
	ADIW R26,16
	ADD  R30,R26
	ADC  R31,R27
	MOVW R26,R22
	ST   X+,R30
	ST   X,R31
; 000C 00F5     }
	SUBI R17,-1
	RJMP _0x18000D
_0x18000E:
; 000C 00F6 
; 000C 00F7     //    
; 000C 00F8     result = FromToBox((void **)ModelsStrPtrs, PTR_SRAM, MAX_MODELS,
; 000C 00F9                        (void **)ModelsStrPtrs, PTR_SRAM, MAX_MODELS,
; 000C 00FA                        "Model Copy:", NULL);
	MOVW R30,R28
	ADIW R30,6
	ST   -Y,R31
	ST   -Y,R30
	LDI  R30,LOW(1)
	ST   -Y,R30
	LDI  R30,LOW(5)
	ST   -Y,R30
	MOVW R30,R28
	ADIW R30,10
	ST   -Y,R31
	ST   -Y,R30
	LDI  R30,LOW(1)
	ST   -Y,R30
	LDI  R30,LOW(5)
	ST   -Y,R30
	__POINTW1FN _0x180000,13
	ST   -Y,R31
	ST   -Y,R30
	LDI  R30,LOW(0)
	LDI  R31,HIGH(0)
	ST   -Y,R31
	ST   -Y,R30
	CALL _FromToBox
	MOVW R18,R30
; 000C 00FB 
; 000C 00FC     //    ( )
; 000C 00FD     if(result != -1)
	LDI  R30,LOW(65535)
	LDI  R31,HIGH(65535)
	CP   R30,R18
	CPC  R31,R19
	BREQ _0x180012
; 000C 00FE     {
; 000C 00FF         //     
; 000C 0100         From = (char)(result >> 8);
	MOVW R30,R18
	CALL __ASRW8
	MOV  R21,R30
; 000C 0101         //     
; 000C 0102         To = (char)(result & 0xFF);
	MOV  R30,R18
	MOV  R20,R30
; 000C 0103         //     
; 000C 0104         if(From != To)
	CP   R20,R21
	BREQ _0x180013
; 000C 0105         {
; 000C 0106             //    
; 000C 0107             MODEL_Copy(From, To);
	ST   -Y,R21
	ST   -Y,R20
	CALL _MODEL_Copy
; 000C 0108             //        -   
; 000C 0109             if(To == Settings.ModelNum) MODEL_Init(Settings.ModelNum);
	__GETB1MN _Settings,5
	CP   R30,R20
	BRNE _0x180014
	__GETB1MN _Settings,5
	ST   -Y,R30
	CALL _MODEL_Init
; 000C 010A         }
_0x180014:
; 000C 010B     }
_0x180013:
; 000C 010C }
_0x180012:
	CALL __LOADLOCR6
	ADIW R28,63
	ADIW R28,19
	RET
;
;// *****************************************************************************
;// ***        ****************************************
;// *****************************************************************************
;void ModeCopy(char AddParam)
; 000C 0112 {
_ModeCopy:
; 000C 0113     //   
; 000C 0114     unsigned char i;
; 000C 0115     //    
; 000C 0116     int result;
; 000C 0117     //       
; 000C 0118     char ModesStr[MAX_MODES][MODE_NAME_LEN];
; 000C 0119     //       
; 000C 011A     char * ModesStrPtrs[MAX_MODES];
; 000C 011B     //      
; 000C 011C     char From, To;
; 000C 011D 
; 000C 011E #ifdef DEBUG
; 000C 011F     printf("ModeCopy();\r");
; 000C 0120     delay_ms(1);
; 000C 0121 #endif
; 000C 0122 
; 000C 0123     //  
; 000C 0124     for(i=0; i < MAX_MODES; i++)
	SBIW R28,39
	CALL __SAVELOCR6
;	AddParam -> Y+45
;	i -> R17
;	result -> R18,R19
;	ModesStr -> Y+12
;	ModesStrPtrs -> Y+6
;	From -> R16
;	To -> R21
	LDI  R17,LOW(0)
_0x180016:
	CPI  R17,3
	BRSH _0x180017
; 000C 0125     {
; 000C 0126         //     
; 000C 0127         strcpy(ModesStr[i], CurModel.Mode[i].name);
	LDI  R26,LOW(11)
	MUL  R17,R26
	MOVW R30,R0
	MOVW R26,R28
	ADIW R26,12
	ADD  R30,R26
	ADC  R31,R27
	ST   -Y,R31
	ST   -Y,R30
	__POINTW2MN _CurModel,21
	MOV  R30,R17
	LDI  R31,0
	MOVW R22,R26
	LDI  R26,LOW(246)
	LDI  R27,HIGH(246)
	CALL __MULW12U
	ADD  R30,R22
	ADC  R31,R23
	ST   -Y,R31
	ST   -Y,R30
	CALL _strcpy
; 000C 0128         //     
; 000C 0129         ModesStrPtrs[i] = ModesStr[i];
	MOV  R30,R17
	LDI  R31,0
	MOVW R26,R28
	ADIW R26,6
	LSL  R30
	ROL  R31
	ADD  R30,R26
	ADC  R31,R27
	MOVW R22,R30
	LDI  R26,LOW(11)
	MUL  R17,R26
	MOVW R30,R0
	MOVW R26,R28
	ADIW R26,12
	ADD  R30,R26
	ADC  R31,R27
	MOVW R26,R22
	ST   X+,R30
	ST   X,R31
; 000C 012A     }
	SUBI R17,-1
	RJMP _0x180016
_0x180017:
; 000C 012B 
; 000C 012C     //    
; 000C 012D     result = FromToBox((void **)ModesStrPtrs, PTR_SRAM, NumberOf(ModesStrPtrs),
; 000C 012E                        (void **)ModesStrPtrs, PTR_SRAM, NumberOf(ModesStrPtrs),
; 000C 012F                        "Mode Copy:", NULL);
	MOVW R30,R28
	ADIW R30,6
	ST   -Y,R31
	ST   -Y,R30
	LDI  R30,LOW(1)
	ST   -Y,R30
	LDI  R30,LOW(3)
	ST   -Y,R30
	MOVW R30,R28
	ADIW R30,10
	ST   -Y,R31
	ST   -Y,R30
	LDI  R30,LOW(1)
	ST   -Y,R30
	LDI  R30,LOW(3)
	ST   -Y,R30
	__POINTW1FN _0x180000,25
	ST   -Y,R31
	ST   -Y,R30
	LDI  R30,LOW(0)
	LDI  R31,HIGH(0)
	ST   -Y,R31
	ST   -Y,R30
	CALL _FromToBox
	MOVW R18,R30
; 000C 0130 
; 000C 0131     //    ( )
; 000C 0132     if(result != -1)
	LDI  R30,LOW(65535)
	LDI  R31,HIGH(65535)
	CP   R30,R18
	CPC  R31,R19
	BREQ _0x180018
; 000C 0133     {
; 000C 0134         //     
; 000C 0135         From = (char)(result >> 8);
	MOVW R30,R18
	CALL __ASRW8
	MOV  R16,R30
; 000C 0136         //     
; 000C 0137         To = (char)(result & 0xFF);
	MOV  R30,R18
	MOV  R21,R30
; 000C 0138         //     
; 000C 0139         if(From != To)
	CP   R21,R16
	BREQ _0x180019
; 000C 013A         {
; 000C 013B             //    
; 000C 013C             MODE_Copy(From, To);
	ST   -Y,R16
	ST   -Y,R21
	CALL _MODE_Copy
; 000C 013D             //       
; 000C 013E             MODEL_Init(Settings.ModelNum);
	__GETB1MN _Settings,5
	ST   -Y,R30
	CALL _MODEL_Init
; 000C 013F         }
; 000C 0140     }
_0x180019:
; 000C 0141 }
_0x180018:
	CALL __LOADLOCR6
	ADIW R28,46
	RET
;
;// *****************************************************************************
;// ***       EEPROM   **********************************
;// *****************************************************************************
;void ModelSave(char AddParam)
; 000C 0147 {
_ModelSave:
; 000C 0148 #ifdef DEBUG
; 000C 0149     printf("ModelSave();\r");
; 000C 014A     delay_ms(1);
; 000C 014B #endif
; 000C 014C 
; 000C 014D     //  
; 000C 014E     MsgBoxF("Are you\nsure ?", &Font_8x12, "Model Save", NULL);
;	AddParam -> Y+0
	__POINTW1FN _0x180000,36
	ST   -Y,R31
	ST   -Y,R30
	LDI  R30,LOW(_Font_8x12)
	LDI  R31,HIGH(_Font_8x12)
	ST   -Y,R31
	ST   -Y,R30
	__POINTW1FN _0x180000,51
	ST   -Y,R31
	ST   -Y,R30
	LDI  R30,LOW(0)
	LDI  R31,HIGH(0)
	ST   -Y,R31
	ST   -Y,R30
	CALL _MsgBoxF
; 000C 014F 
; 000C 0150     //   
; 000C 0151     WaitEmptyButtons(0);
	LDI  R30,LOW(0)
	ST   -Y,R30
	CALL _WaitEmptyButtons
; 000C 0152 
; 000C 0153     //   ,      .
; 000C 0154     //   Enter -  
; 000C 0155     if(WaitButtonPress(B_ENTER | B_BACK) == B_ENTER)
	LDI  R30,LOW(48)
	ST   -Y,R30
	CALL _WaitButtonPress
	CPI  R30,LOW(0x20)
	BRNE _0x18001A
; 000C 0156     {
; 000C 0157         // 
; 000C 0158         Beep(1000, 50, 1);
	LDI  R30,LOW(1000)
	LDI  R31,HIGH(1000)
	ST   -Y,R31
	ST   -Y,R30
	LDI  R30,LOW(50)
	LDI  R31,HIGH(50)
	ST   -Y,R31
	ST   -Y,R30
	LDI  R30,LOW(1)
	ST   -Y,R30
	CALL _Beep
; 000C 0159         //  
; 000C 015A         MsgBoxF("Please\nwait...", &Font_8x12, "Model Save", NULL);
	__POINTW1FN _0x180000,62
	ST   -Y,R31
	ST   -Y,R30
	LDI  R30,LOW(_Font_8x12)
	LDI  R31,HIGH(_Font_8x12)
	ST   -Y,R31
	ST   -Y,R30
	__POINTW1FN _0x180000,51
	ST   -Y,R31
	ST   -Y,R30
	LDI  R30,LOW(0)
	LDI  R31,HIGH(0)
	ST   -Y,R31
	ST   -Y,R30
	CALL _MsgBoxF
; 000C 015B         //      EEPROM
; 000C 015C         MODEL_Save(Settings.ModelNum);
	__GETB1MN _Settings,5
	ST   -Y,R30
	CALL _MODEL_Save
; 000C 015D         // 
; 000C 015E         Beep(1000, 50, 1);
	LDI  R30,LOW(1000)
	LDI  R31,HIGH(1000)
	ST   -Y,R31
	ST   -Y,R30
	LDI  R30,LOW(50)
	LDI  R31,HIGH(50)
	ST   -Y,R31
	ST   -Y,R30
	LDI  R30,LOW(1)
	ST   -Y,R30
	CALL _Beep
; 000C 015F     }
; 000C 0160 }
_0x18001A:
	RJMP _0x206000C
;
;// *****************************************************************************
;// ***        ************************************************
;// *****************************************************************************
;void ModelReset(char AddParam)
; 000C 0166 {
_ModelReset:
; 000C 0167 #ifdef DEBUG
; 000C 0168     printf("ModelReset();\r");
; 000C 0169     delay_ms(1);
; 000C 016A #endif
; 000C 016B 
; 000C 016C     //  
; 000C 016D     MsgBoxF("Are you\nsure ?", &Font_8x12, "Model Reset", NULL);
;	AddParam -> Y+0
	__POINTW1FN _0x180000,36
	ST   -Y,R31
	ST   -Y,R30
	LDI  R30,LOW(_Font_8x12)
	LDI  R31,HIGH(_Font_8x12)
	ST   -Y,R31
	ST   -Y,R30
	__POINTW1FN _0x180000,77
	ST   -Y,R31
	ST   -Y,R30
	LDI  R30,LOW(0)
	LDI  R31,HIGH(0)
	ST   -Y,R31
	ST   -Y,R30
	CALL _MsgBoxF
; 000C 016E 
; 000C 016F     //   
; 000C 0170     WaitEmptyButtons(0);
	LDI  R30,LOW(0)
	ST   -Y,R30
	CALL _WaitEmptyButtons
; 000C 0171 
; 000C 0172     //   ,      .
; 000C 0173     //   Enter -  
; 000C 0174     if(WaitButtonPress(B_ENTER | B_BACK) == B_ENTER)
	LDI  R30,LOW(48)
	ST   -Y,R30
	CALL _WaitButtonPress
	CPI  R30,LOW(0x20)
	BRNE _0x18001B
; 000C 0175     {
; 000C 0176         // 
; 000C 0177         Beep(1000, 50, 1);
	LDI  R30,LOW(1000)
	LDI  R31,HIGH(1000)
	ST   -Y,R31
	ST   -Y,R30
	LDI  R30,LOW(50)
	LDI  R31,HIGH(50)
	ST   -Y,R31
	ST   -Y,R30
	LDI  R30,LOW(1)
	ST   -Y,R30
	CALL _Beep
; 000C 0178         //  
; 000C 0179         MsgBoxF("Please\nwait...", &Font_8x12, "Model Reset", NULL);
	__POINTW1FN _0x180000,62
	ST   -Y,R31
	ST   -Y,R30
	LDI  R30,LOW(_Font_8x12)
	LDI  R31,HIGH(_Font_8x12)
	ST   -Y,R31
	ST   -Y,R30
	__POINTW1FN _0x180000,77
	ST   -Y,R31
	ST   -Y,R30
	LDI  R30,LOW(0)
	LDI  R31,HIGH(0)
	ST   -Y,R31
	ST   -Y,R30
	CALL _MsgBoxF
; 000C 017A         //      EEPROM
; 000C 017B         MODEL_Reset(Settings.ModelNum);
	__GETB1MN _Settings,5
	ST   -Y,R30
	CALL _MODEL_Reset
; 000C 017C         //       EEPROM  SRAM
; 000C 017D         MODEL_Init(Settings.ModelNum);
	__GETB1MN _Settings,5
	ST   -Y,R30
	CALL _MODEL_Init
; 000C 017E         // 
; 000C 017F         Beep(1000, 50, 1);
	LDI  R30,LOW(1000)
	LDI  R31,HIGH(1000)
	ST   -Y,R31
	ST   -Y,R30
	LDI  R30,LOW(50)
	LDI  R31,HIGH(50)
	ST   -Y,R31
	ST   -Y,R30
	LDI  R30,LOW(1)
	ST   -Y,R30
	CALL _Beep
; 000C 0180     }
; 000C 0181 }
_0x18001B:
	RJMP _0x206000C
;
;// *****************************************************************************
;// ***       **********************************************************
;// *****************************************************************************
;flash const char * ModelTypes[] = {
;    "Plane",
;    "Heli"
;};

	.DSEG
;// ***        ***********************************************
;char * ModelTypeGetStr(char * Buf, char AddParam)
; 000C 018C {

	.CSEG
_ModelTypeGetStr:
; 000C 018D     //     
; 000C 018E     sprintf(Buf, "%p", ModelTypes[CurModel.type]);
;	*Buf -> Y+1
;	AddParam -> Y+0
	LDD  R30,Y+1
	LDD  R31,Y+1+1
	ST   -Y,R31
	ST   -Y,R30
	__POINTW1FN _0x180000,100
	ST   -Y,R31
	ST   -Y,R30
	__GETB1MN _CurModel,15
	LDI  R26,LOW(_ModelTypes)
	LDI  R27,HIGH(_ModelTypes)
	LDI  R31,0
	LSL  R30
	ROL  R31
	ADD  R26,R30
	ADC  R27,R31
	CALL __GETW1P
	CLR  R22
	CLR  R23
	CALL __PUTPARD1
	LDI  R24,4
	CALL _sprintf
	ADIW R28,8
; 000C 018F     //     
; 000C 0190     return(Buf);
	JMP  _0x2060008
; 000C 0191 }
;// ***        ***********************************************
;void ModeTypeSet(char AddParam)
; 000C 0194 {
_ModeTypeSet:
; 000C 0195     //    
; 000C 0196     char result;
; 000C 0197 
; 000C 0198     //    
; 000C 0199     result = SelectBoxF((flash char **)ModelTypes, NumberOf(ModelTypes), CurModel.type, NULL, "Model Type:", NULL);
	ST   -Y,R17
;	AddParam -> Y+1
;	result -> R17
	LDI  R30,LOW(_ModelTypes)
	LDI  R31,HIGH(_ModelTypes)
	ST   -Y,R31
	ST   -Y,R30
	LDI  R30,LOW(2)
	ST   -Y,R30
	__GETB1MN _CurModel,15
	ST   -Y,R30
	LDI  R30,LOW(0)
	LDI  R31,HIGH(0)
	ST   -Y,R31
	ST   -Y,R30
	__POINTW1FN _0x180000,103
	ST   -Y,R31
	ST   -Y,R30
	LDI  R30,LOW(0)
	LDI  R31,HIGH(0)
	ST   -Y,R31
	ST   -Y,R30
	CALL _SelectBoxF
	MOV  R17,R30
; 000C 019A 
; 000C 019B     //    ( )
; 000C 019C     if(result != -1)
	CPI  R17,255
	BREQ _0x18001D
; 000C 019D     {
; 000C 019E         //   
; 000C 019F         CurModel.type = result;
	__PUTBMRN _CurModel,15,17
; 000C 01A0     }
; 000C 01A1 }
_0x18001D:
	LDD  R17,Y+0
	RJMP _0x206000A
;
;// *****************************************************************************
;// ***         *********************************************
;// *****************************************************************************
;flash const char * ModulationTypes[] = {
;    "PPM",
;    "IPPM",
;    "PCM"
;};

	.DSEG
;// ***        ********************************************
;char *ModulationTypeGetStr(char * Buf, char AddParam)
; 000C 01AD {

	.CSEG
_ModulationTypeGetStr:
; 000C 01AE     //     
; 000C 01AF     sprintf(Buf, "%p", ModulationTypes[CurModel.modulation]);
;	*Buf -> Y+1
;	AddParam -> Y+0
	LDD  R30,Y+1
	LDD  R31,Y+1+1
	ST   -Y,R31
	ST   -Y,R30
	__POINTW1FN _0x180000,100
	ST   -Y,R31
	ST   -Y,R30
	__GETB1MN _CurModel,16
	LDI  R26,LOW(_ModulationTypes)
	LDI  R27,HIGH(_ModulationTypes)
	LDI  R31,0
	LSL  R30
	ROL  R31
	ADD  R26,R30
	ADC  R27,R31
	CALL __GETW1P
	CLR  R22
	CLR  R23
	CALL __PUTPARD1
	LDI  R24,4
	CALL _sprintf
	ADIW R28,8
; 000C 01B0     //     
; 000C 01B1     return(Buf);
	RJMP _0x2060008
; 000C 01B2 }
;// ***        ********************************************
;void ModulationTypeSet(char AddParam)
; 000C 01B5 {
_ModulationTypeSet:
; 000C 01B6     //    
; 000C 01B7     char result;
; 000C 01B8 
; 000C 01B9     //    
; 000C 01BA     result = SelectBoxF((flash char **)ModulationTypes, NumberOf(ModulationTypes), CurModel.modulation, NULL, "Modulation Type:", NULL);
	ST   -Y,R17
;	AddParam -> Y+1
;	result -> R17
	LDI  R30,LOW(_ModulationTypes)
	LDI  R31,HIGH(_ModulationTypes)
	ST   -Y,R31
	ST   -Y,R30
	LDI  R30,LOW(3)
	ST   -Y,R30
	__GETB1MN _CurModel,16
	ST   -Y,R30
	LDI  R30,LOW(0)
	LDI  R31,HIGH(0)
	ST   -Y,R31
	ST   -Y,R30
	__POINTW1FN _0x180000,128
	ST   -Y,R31
	ST   -Y,R30
	LDI  R30,LOW(0)
	LDI  R31,HIGH(0)
	ST   -Y,R31
	ST   -Y,R30
	CALL _SelectBoxF
	MOV  R17,R30
; 000C 01BB 
; 000C 01BC     //    ( )
; 000C 01BD     if(result != -1)
	CPI  R17,255
	BREQ _0x18001F
; 000C 01BE     {
; 000C 01BF         //   
; 000C 01C0         CurModel.modulation = result;
	__PUTBMRN _CurModel,16,17
; 000C 01C1         //     
; 000C 01C2         TX_SetModulation(CurModel.modulation);
	__GETB1MN _CurModel,16
	ST   -Y,R30
	CALL _TX_SetModulation
; 000C 01C3     }
; 000C 01C4 }
_0x18001F:
	LDD  R17,Y+0
	RJMP _0x206000A
;
;// *****************************************************************************
;// ***         ****************************************
;// *****************************************************************************
;
;// ***          *****************************
;char * ModelChannelsNumGetStr(char * Buf, char AddParam)
; 000C 01CC {
_ModelChannelsNumGetStr:
; 000C 01CD     //     
; 000C 01CE     sprintf(Buf, "%d", CurModel.num_ch);
;	*Buf -> Y+1
;	AddParam -> Y+0
	LDD  R30,Y+1
	LDD  R31,Y+1+1
	ST   -Y,R31
	ST   -Y,R30
	__POINTW1FN _0x180000,0
	ST   -Y,R31
	ST   -Y,R30
	__GETB1MN _CurModel,20
	CALL __CBD1
	CALL __PUTPARD1
	LDI  R24,4
	CALL _sprintf
	ADIW R28,8
; 000C 01CF     //     
; 000C 01D0     return(Buf);
	RJMP _0x2060008
; 000C 01D1 }
;// ***          *****************************
;void ModelChannelsNumSet(char AddParam)
; 000C 01D4 {
_ModelChannelsNumSet:
; 000C 01D5     //    
; 000C 01D6     EditNumDlg(&CurModel.num_ch, PTR_CHAR , 2, MAX_CHANNELS, 1, "Channels");
;	AddParam -> Y+0
	__POINTW1MN _CurModel,20
	ST   -Y,R31
	ST   -Y,R30
	LDI  R30,LOW(3)
	ST   -Y,R30
	LDI  R30,LOW(2)
	LDI  R31,HIGH(2)
	ST   -Y,R31
	ST   -Y,R30
	LDI  R30,LOW(8)
	LDI  R31,HIGH(8)
	ST   -Y,R31
	ST   -Y,R30
	LDI  R30,LOW(1)
	ST   -Y,R30
	__POINTW1FN _0x180000,145
	ST   -Y,R31
	ST   -Y,R30
	CALL _EditNumDlg
; 000C 01D7 }
	RJMP _0x206000C
;
;// *****************************************************************************
;// ***       *****************************************************
;// *****************************************************************************
;
;// ***        *******************************************
;char * ModelNameGetStr(char * Buf, char AddParam)
; 000C 01DF {
_ModelNameGetStr:
; 000C 01E0     //     
; 000C 01E1     sprintf(Buf, "%s", CurModel.name);
;	*Buf -> Y+1
;	AddParam -> Y+0
	LDD  R30,Y+1
	LDD  R31,Y+1+1
	ST   -Y,R31
	ST   -Y,R30
	__POINTW1FN _0x180000,154
	ST   -Y,R31
	ST   -Y,R30
	__POINTW1MN _CurModel,2
	CLR  R22
	CLR  R23
	CALL __PUTPARD1
	LDI  R24,4
	CALL _sprintf
	ADIW R28,8
; 000C 01E2     //     
; 000C 01E3     return(Buf);
	RJMP _0x2060008
; 000C 01E4 }
;// ***        *******************************************
;void ModelNameSet(char AddParam)
; 000C 01E7 {
_ModelNameSet:
; 000C 01E8     //    
; 000C 01E9     EditStrDlg(CurModel.name, NumberOf(CurModel.name) - 1, NULL, "Model Name:", NULL);
;	AddParam -> Y+0
	__POINTW1MN _CurModel,2
	ST   -Y,R31
	ST   -Y,R30
	LDI  R30,LOW(12)
	ST   -Y,R30
	LDI  R30,LOW(0)
	LDI  R31,HIGH(0)
	ST   -Y,R31
	ST   -Y,R30
	__POINTW1FN _0x180000,157
	RJMP _0x206000B
; 000C 01EA }
;
;// *****************************************************************************
;// ***       *****************************************************
;// *****************************************************************************
;
;// ***        *******************************************
;char * ModeNameGetStr(char * Buf, char AddParam)
; 000C 01F2 {
_ModeNameGetStr:
; 000C 01F3     //     
; 000C 01F4     sprintf(Buf, "%s", CurModel.Mode[FLY_MODE].name);
;	*Buf -> Y+1
;	AddParam -> Y+0
	LDD  R30,Y+1
	LDD  R31,Y+1+1
	ST   -Y,R31
	ST   -Y,R30
	__POINTW1FN _0x180000,154
	ST   -Y,R31
	ST   -Y,R30
	__POINTW2MN _CurModel,21
	LDS  R30,_FLY_MODE
	LDI  R31,0
	MOVW R22,R26
	LDI  R26,LOW(246)
	LDI  R27,HIGH(246)
	CALL __MULW12U
	ADD  R30,R22
	ADC  R31,R23
	CLR  R22
	CLR  R23
	CALL __PUTPARD1
	LDI  R24,4
	CALL _sprintf
	ADIW R28,8
; 000C 01F5     //     
; 000C 01F6     return(Buf);
	RJMP _0x2060008
; 000C 01F7 }
;// ***        *******************************************
;void ModeNameSet(char AddParam)
; 000C 01FA {
_ModeNameSet:
; 000C 01FB     //    
; 000C 01FC     EditStrDlg(CurModel.Mode[FLY_MODE].name, NumberOf(CurModel.Mode[FLY_MODE].name) - 1, NULL, "Mode Name:", NULL);
;	AddParam -> Y+0
	__POINTW2MN _CurModel,21
	LDS  R30,_FLY_MODE
	LDI  R31,0
	MOVW R22,R26
	LDI  R26,LOW(246)
	LDI  R27,HIGH(246)
	CALL __MULW12U
	ADD  R30,R22
	ADC  R31,R23
	ST   -Y,R31
	ST   -Y,R30
	LDI  R30,LOW(10)
	ST   -Y,R30
	LDI  R30,LOW(0)
	LDI  R31,HIGH(0)
	ST   -Y,R31
	ST   -Y,R30
	__POINTW1FN _0x180000,169
_0x206000B:
	ST   -Y,R31
	ST   -Y,R30
	LDI  R30,LOW(0)
	LDI  R31,HIGH(0)
	ST   -Y,R31
	ST   -Y,R30
	CALL _EditStrDlg
; 000C 01FD }
_0x206000C:
	ADIW R28,1
	RET
;
;// *****************************************************************************
;// ***       ********************************************************
;// *****************************************************************************
;void ModelSelect(char AddParam)
; 000C 0203 {
_ModelSelect:
; 000C 0204     //   
; 000C 0205     unsigned char i, j;
; 000C 0206     //    
; 000C 0207     char result;
; 000C 0208     //       
; 000C 0209     char ModelsStr[MAX_MODELS][MODEL_NAME_LEN];
; 000C 020A     //       
; 000C 020B     char * ModelsStrPtrs[MAX_MODELS];
; 000C 020C 
; 000C 020D     //  
; 000C 020E     for(i=0; i < MAX_MODELS; i++)
	SBIW R28,63
	SBIW R28,12
	CALL __SAVELOCR4
;	AddParam -> Y+79
;	i -> R17
;	j -> R16
;	result -> R19
;	ModelsStr -> Y+14
;	ModelsStrPtrs -> Y+4
	LDI  R17,LOW(0)
_0x180021:
	CPI  R17,5
	BRSH _0x180022
; 000C 020F     {
; 000C 0210         //     
; 000C 0211         for(j=0; j < MODEL_NAME_LEN; j++) ModelsStr[i][j] = EEPROM_MODEL[i].name[j];
	LDI  R16,LOW(0)
_0x180024:
	CPI  R16,13
	BRSH _0x180025
	LDI  R26,LOW(13)
	MUL  R17,R26
	MOVW R30,R0
	MOVW R26,R28
	ADIW R26,14
	ADD  R26,R30
	ADC  R27,R31
	MOV  R30,R16
	LDI  R31,0
	ADD  R30,R26
	ADC  R31,R27
	MOVW R22,R30
	MOV  R30,R17
	LDI  R31,0
	LDI  R26,LOW(759)
	LDI  R27,HIGH(759)
	CALL __MULW12U
	__ADDW1MN _EEPROM_MODEL,2
	MOVW R26,R30
	CLR  R30
	ADD  R26,R16
	ADC  R27,R30
	CALL __EEPROMRDB
	MOVW R26,R22
	ST   X,R30
	SUBI R16,-1
	RJMP _0x180024
_0x180025:
; 000C 0213 ModelsStrPtrs[i] = ModelsStr[i];
	MOV  R30,R17
	LDI  R31,0
	MOVW R26,R28
	ADIW R26,4
	LSL  R30
	ROL  R31
	ADD  R30,R26
	ADC  R31,R27
	MOVW R22,R30
	LDI  R26,LOW(13)
	MUL  R17,R26
	MOVW R30,R0
	MOVW R26,R28
	ADIW R26,14
	ADD  R30,R26
	ADC  R31,R27
	MOVW R26,R22
	ST   X+,R30
	ST   X,R31
; 000C 0214     }
	SUBI R17,-1
	RJMP _0x180021
_0x180022:
; 000C 0215 
; 000C 0216     //    
; 000C 0217     result = SelectBox((char **)ModelsStrPtrs, MAX_MODELS, Settings.ModelNum, NULL, "Model:", NULL);
	MOVW R30,R28
	ADIW R30,4
	ST   -Y,R31
	ST   -Y,R30
	LDI  R30,LOW(5)
	ST   -Y,R30
	__GETB1MN _Settings,5
	ST   -Y,R30
	LDI  R30,LOW(0)
	LDI  R31,HIGH(0)
	ST   -Y,R31
	ST   -Y,R30
	__POINTW1FN _0x180000,180
	ST   -Y,R31
	ST   -Y,R30
	LDI  R30,LOW(0)
	LDI  R31,HIGH(0)
	ST   -Y,R31
	ST   -Y,R30
	CALL _SelectBox
	MOV  R19,R30
; 000C 0218 
; 000C 0219     //    ( )
; 000C 021A     if(result != -1)
	CPI  R19,255
	BREQ _0x180026
; 000C 021B     {
; 000C 021C         //           
; 000C 021D         #asm("cli")
	cli
; 000C 021E         //   
; 000C 021F         Settings.ModelNum = result;
	__PUTBMRN _Settings,5,19
; 000C 0220         //     EEPROM
; 000C 0221         TX_SaveSettings();
	CALL _TX_SaveSettings
; 000C 0222         //     EEPROM
; 000C 0223         MODEL_Init(Settings.ModelNum);
	__GETB1MN _Settings,5
	ST   -Y,R30
	CALL _MODEL_Init
; 000C 0224         #asm("sei")
	sei
; 000C 0225     }
; 000C 0226 }
_0x180026:
	CALL __LOADLOCR4
	ADIW R28,63
	ADIW R28,17
	RET
;
;// *****************************************************************************
;// ***    ""   *******************************************************
;// *****************************************************************************
;flash MenuButton ModelMenuButtons[] =
;{
; {"Name", ModelNameSet, ModelNameGetStr},
; {"Type", ModeTypeSet, ModelTypeGetStr},
; {"Modulation", ModulationTypeSet, ModulationTypeGetStr},
; {"Channels", ModelChannelsNumSet, ModelChannelsNumGetStr},
; {"Mode Name", ModeNameSet, ModeNameGetStr},
; {"Save", ModelSave, NULL},
; {"Select", ModelSelect, NULL},
; {"Copy", ModelCopy, NULL},
; {"Modes Copy", ModeCopy, NULL},
; {"Reset", ModelReset, NULL}};
;
;void ModelMenu(char AddParam)
; 000C 0239 {
_ModelMenu:
; 000C 023A     //   
; 000C 023B     MenuPad Pad = {"Model", &Font_8x12, &Font_6x8, ModelMenuButtons, NumberOf(ModelMenuButtons), 0, NULL, NULL};
; 000C 023C     //   
; 000C 023D     MenuCycle(&Pad);
	SBIW R28,14
	LDI  R24,14
	LDI  R26,LOW(0)
	LDI  R27,HIGH(0)
	LDI  R30,LOW(_0x180027*2)
	LDI  R31,HIGH(_0x180027*2)
	CALL __INITLOCB
;	AddParam -> Y+14
;	Pad -> Y+0
	MOVW R30,R28
	ST   -Y,R31
	ST   -Y,R30
	CALL _MenuCycle
; 000C 023E }
	ADIW R28,15
	RET
;
;// *****************************************************************************
;// ***         ********************************
;// *****************************************************************************
;static char CurrentControl;
;
;//      "Controls"     
;//      .
;extern flash MenuButton ControlsMenuButtons[];
;
;// ***         *****************************
;char * ControlsVirtualGetStr(char * Buf, char AddParam)
; 000C 024B {
_ControlsVirtualGetStr:
; 000C 024C     //     
; 000C 024D     sprintf(Buf, ControlsMenuButtons[CurModel.Mode[FLY_MODE].Control[CurrentControl].from].str);
;	*Buf -> Y+1
;	AddParam -> Y+0
	LDD  R30,Y+1
	LDD  R31,Y+1+1
	ST   -Y,R31
	ST   -Y,R30
	__POINTW2MN _CurModel,21
	LDS  R30,_FLY_MODE
	LDI  R31,0
	MOVW R22,R26
	LDI  R26,LOW(246)
	LDI  R27,HIGH(246)
	CALL __MULW12U
	MOVW R26,R22
	ADD  R26,R30
	ADC  R27,R31
	ADIW R26,11
	LDS  R30,_CurrentControl_G00C
	LDI  R31,0
	MOVW R22,R26
	LDI  R26,LOW(13)
	LDI  R27,HIGH(13)
	CALL __MULW12U
	MOVW R26,R22
	ADD  R26,R30
	ADC  R27,R31
	ADIW R26,5
	LD   R30,X
	LDI  R26,LOW(7)
	MUL  R30,R26
	MOVW R30,R0
	SUBI R30,LOW(-_ControlsMenuButtons*2)
	SBCI R31,HIGH(-_ControlsMenuButtons*2)
	CALL __GETW1PF
	RJMP _0x2060007
; 000C 024E     //     
; 000C 024F     return(Buf);
; 000C 0250 }
;
;// ***         *****************************
;void ControlsVirtualSet(char AddParam)
; 000C 0254 {
_ControlsVirtualSet:
; 000C 0255     char i;
; 000C 0256     char result = CurModel.Mode[FLY_MODE].Control[CurrentControl].from;
; 000C 0257     flash char * Strings[MAX_CONTROLS];
; 000C 0258 
; 000C 0259     for(i=0; i < MAX_CONTROLS; i++) Strings[i] = ControlsMenuButtons[i].str;
	SBIW R28,22
	ST   -Y,R17
	ST   -Y,R16
;	AddParam -> Y+24
;	i -> R17
;	result -> R16
;	Strings -> Y+2
	__POINTW2MN _CurModel,21
	LDS  R30,_FLY_MODE
	LDI  R31,0
	MOVW R22,R26
	LDI  R26,LOW(246)
	LDI  R27,HIGH(246)
	CALL __MULW12U
	MOVW R26,R22
	ADD  R26,R30
	ADC  R27,R31
	ADIW R26,11
	LDS  R30,_CurrentControl_G00C
	LDI  R31,0
	MOVW R22,R26
	LDI  R26,LOW(13)
	LDI  R27,HIGH(13)
	CALL __MULW12U
	MOVW R26,R22
	ADD  R26,R30
	ADC  R27,R31
	ADIW R26,5
	LD   R30,X
	MOV  R16,R30
	LDI  R17,LOW(0)
_0x180029:
	CPI  R17,11
	BRGE _0x18002A
	MOV  R30,R17
	LDI  R31,0
	MOVW R26,R28
	ADIW R26,2
	LSL  R30
	ROL  R31
	ADD  R30,R26
	ADC  R31,R27
	MOVW R22,R30
	LDI  R26,LOW(7)
	MUL  R17,R26
	MOVW R30,R0
	SUBI R30,LOW(-_ControlsMenuButtons*2)
	SBCI R31,HIGH(-_ControlsMenuButtons*2)
	CALL __GETW1PF
	MOVW R26,R22
	ST   X+,R30
	ST   X,R31
	SUBI R17,-1
	RJMP _0x180029
_0x18002A:
; 000C 025B result = SelectBoxF((flash char **)Strings, CTRL_V1, result, 0, "From:", 0);
	MOVW R30,R28
	ADIW R30,2
	ST   -Y,R31
	ST   -Y,R30
	LDI  R30,LOW(8)
	ST   -Y,R30
	ST   -Y,R16
	LDI  R30,LOW(0)
	LDI  R31,HIGH(0)
	ST   -Y,R31
	ST   -Y,R30
	__POINTW1FN _0x180000,247
	ST   -Y,R31
	ST   -Y,R30
	LDI  R30,LOW(0)
	LDI  R31,HIGH(0)
	ST   -Y,R31
	ST   -Y,R30
	CALL _SelectBoxF
	MOV  R16,R30
; 000C 025C     //    ( )
; 000C 025D     if(result != -1) CurModel.Mode[FLY_MODE].Control[CurrentControl].from = result;
	CPI  R16,255
	BREQ _0x18002B
	__POINTW2MN _CurModel,21
	LDS  R30,_FLY_MODE
	LDI  R31,0
	MOVW R22,R26
	LDI  R26,LOW(246)
	LDI  R27,HIGH(246)
	CALL __MULW12U
	MOVW R26,R22
	ADD  R26,R30
	ADC  R27,R31
	ADIW R26,11
	LDS  R30,_CurrentControl_G00C
	LDI  R31,0
	MOVW R22,R26
	LDI  R26,LOW(13)
	LDI  R27,HIGH(13)
	CALL __MULW12U
	ADD  R30,R22
	ADC  R31,R23
	__PUTBZR 16,5
; 000C 025E }
_0x18002B:
	LDD  R17,Y+1
	LDD  R16,Y+0
	ADIW R28,25
	RET
;
;// ***         **********************************
;char * ControlsReverseGetStr(char * Buf, char AddParam)
; 000C 0262 {
_ControlsReverseGetStr:
; 000C 0263     //       
; 000C 0264     char flash * str;
; 000C 0265     //     
; 000C 0266     if(CurModel.Mode[FLY_MODE].Control[CurrentControl].reverse == 1) str = "OFF";
	ST   -Y,R17
	ST   -Y,R16
;	*Buf -> Y+3
;	AddParam -> Y+2
;	*str -> R16,R17
	__POINTW2MN _CurModel,21
	LDS  R30,_FLY_MODE
	LDI  R31,0
	MOVW R22,R26
	LDI  R26,LOW(246)
	LDI  R27,HIGH(246)
	CALL __MULW12U
	MOVW R26,R22
	ADD  R26,R30
	ADC  R27,R31
	ADIW R26,11
	LDS  R30,_CurrentControl_G00C
	LDI  R31,0
	MOVW R22,R26
	LDI  R26,LOW(13)
	LDI  R27,HIGH(13)
	CALL __MULW12U
	MOVW R26,R22
	ADD  R26,R30
	ADC  R27,R31
	LD   R26,X
	CPI  R26,LOW(0x1)
	BRNE _0x18002C
	__POINTW1FN _0x180000,253
	RJMP _0x18009C
; 000C 0267     else if (CurModel.Mode[FLY_MODE].Control[CurrentControl].reverse == -1) str = "ON";
_0x18002C:
	__POINTW2MN _CurModel,21
	LDS  R30,_FLY_MODE
	LDI  R31,0
	MOVW R22,R26
	LDI  R26,LOW(246)
	LDI  R27,HIGH(246)
	CALL __MULW12U
	MOVW R26,R22
	ADD  R26,R30
	ADC  R27,R31
	ADIW R26,11
	LDS  R30,_CurrentControl_G00C
	LDI  R31,0
	MOVW R22,R26
	LDI  R26,LOW(13)
	LDI  R27,HIGH(13)
	CALL __MULW12U
	MOVW R26,R22
	ADD  R26,R30
	ADC  R27,R31
	LD   R26,X
	CPI  R26,LOW(0xFF)
	BRNE _0x18002E
	__POINTW1FN _0x180000,257
	RJMP _0x18009C
; 000C 0268     else str = "ERROR";
_0x18002E:
	__POINTW1FN _0x180000,260
_0x18009C:
	MOVW R16,R30
; 000C 0269     sprintf(Buf, str);
	LDD  R30,Y+3
	LDD  R31,Y+3+1
	ST   -Y,R31
	ST   -Y,R30
	ST   -Y,R17
	ST   -Y,R16
	LDI  R24,0
	CALL _sprintf
	ADIW R28,4
; 000C 026A     //     
; 000C 026B     return(Buf);
	RJMP _0x2060009
; 000C 026C }
;// ***        ********************************************
;void ControlsReverseSet(char AddParam)
; 000C 026F {
_ControlsReverseSet:
; 000C 0270     char result = CurModel.Mode[FLY_MODE].Control[CurrentControl].reverse == 1 ? 0 : 1;
; 000C 0271     flash char * Strings[2] = {"OFF", "ON"};
; 000C 0272 
; 000C 0273     result = SelectBoxF((flash char **)Strings, 2, result, NULL, "Reverse:", NULL);
	SBIW R28,4
	LDI  R30,LOW(_0x180000*2+253)
	LDI  R31,HIGH(_0x180000*2+253)
	ST   Y,R30
	STD  Y+1,R31
	LDI  R30,LOW(_0x180000*2+257)
	LDI  R31,HIGH(_0x180000*2+257)
	STD  Y+2,R30
	STD  Y+2+1,R31
	ST   -Y,R17
;	AddParam -> Y+5
;	result -> R17
;	Strings -> Y+1
	__POINTW2MN _CurModel,21
	LDS  R30,_FLY_MODE
	LDI  R31,0
	MOVW R22,R26
	LDI  R26,LOW(246)
	LDI  R27,HIGH(246)
	CALL __MULW12U
	MOVW R26,R22
	ADD  R26,R30
	ADC  R27,R31
	ADIW R26,11
	LDS  R30,_CurrentControl_G00C
	LDI  R31,0
	MOVW R22,R26
	LDI  R26,LOW(13)
	LDI  R27,HIGH(13)
	CALL __MULW12U
	MOVW R26,R22
	ADD  R26,R30
	ADC  R27,R31
	LD   R26,X
	CPI  R26,LOW(0x1)
	BRNE _0x180030
	LDI  R30,LOW(0)
	RJMP _0x180031
_0x180030:
	LDI  R30,LOW(1)
_0x180031:
	MOV  R17,R30
	MOVW R30,R28
	ADIW R30,1
	ST   -Y,R31
	ST   -Y,R30
	LDI  R30,LOW(2)
	ST   -Y,R30
	ST   -Y,R17
	LDI  R30,LOW(0)
	LDI  R31,HIGH(0)
	ST   -Y,R31
	ST   -Y,R30
	__POINTW1FN _0x180000,266
	ST   -Y,R31
	ST   -Y,R30
	LDI  R30,LOW(0)
	LDI  R31,HIGH(0)
	ST   -Y,R31
	ST   -Y,R30
	CALL _SelectBoxF
	MOV  R17,R30
; 000C 0274     //    ( )
; 000C 0275     if(result != -1)
	CPI  R17,255
	BRNE PC+3
	JMP _0x180033
; 000C 0276     {
; 000C 0277         if(result == 0) CurModel.Mode[FLY_MODE].Control[CurrentControl].reverse =  1;
	CPI  R17,0
	BRNE _0x180034
	__POINTW2MN _CurModel,21
	LDS  R30,_FLY_MODE
	LDI  R31,0
	MOVW R22,R26
	LDI  R26,LOW(246)
	LDI  R27,HIGH(246)
	CALL __MULW12U
	MOVW R26,R22
	ADD  R26,R30
	ADC  R27,R31
	ADIW R26,11
	LDS  R30,_CurrentControl_G00C
	LDI  R31,0
	MOVW R22,R26
	LDI  R26,LOW(13)
	LDI  R27,HIGH(13)
	CALL __MULW12U
	MOVW R26,R22
	ADD  R26,R30
	ADC  R27,R31
	LDI  R30,LOW(1)
	RJMP _0x18009D
; 000C 0278         else            CurModel.Mode[FLY_MODE].Control[CurrentControl].reverse = -1;
_0x180034:
	__POINTW2MN _CurModel,21
	LDS  R30,_FLY_MODE
	LDI  R31,0
	MOVW R22,R26
	LDI  R26,LOW(246)
	LDI  R27,HIGH(246)
	CALL __MULW12U
	MOVW R26,R22
	ADD  R26,R30
	ADC  R27,R31
	ADIW R26,11
	LDS  R30,_CurrentControl_G00C
	LDI  R31,0
	MOVW R22,R26
	LDI  R26,LOW(13)
	LDI  R27,HIGH(13)
	CALL __MULW12U
	MOVW R26,R22
	ADD  R26,R30
	ADC  R27,R31
	LDI  R30,LOW(255)
_0x18009D:
	ST   X,R30
; 000C 0279     }
; 000C 027A }
_0x180033:
	RJMP _0x2060006
;
;// ***      AddParam   *************************************
;static unsigned char * ControlsRateGetPointer(char Control, char param)
; 000C 027E {
_ControlsRateGetPointer_G00C:
; 000C 027F     switch(param)
;	Control -> Y+1
;	param -> Y+0
	LD   R30,Y
; 000C 0280     {
; 000C 0281         case CTRLS_MINR:
	CPI  R30,LOW(0x2)
	BRNE _0x180039
; 000C 0282             return(&CurModel.Mode[FLY_MODE].Control[Control].minRates);
	__POINTW2MN _CurModel,21
	LDS  R30,_FLY_MODE
	LDI  R31,0
	MOVW R22,R26
	LDI  R26,LOW(246)
	LDI  R27,HIGH(246)
	CALL __MULW12U
	MOVW R26,R22
	ADD  R26,R30
	ADC  R27,R31
	ADIW R26,11
	LDD  R30,Y+1
	LDI  R31,0
	MOVW R22,R26
	LDI  R26,LOW(13)
	LDI  R27,HIGH(13)
	CALL __MULW12U
	ADD  R30,R22
	ADC  R31,R23
	ADIW R30,2
	RJMP _0x206000A
; 000C 0283 
; 000C 0284         case CTRLS_MAXR:
_0x180039:
	CPI  R30,LOW(0x1)
	BRNE _0x18003A
; 000C 0285             return(&CurModel.Mode[FLY_MODE].Control[Control].maxRates);
	__POINTW2MN _CurModel,21
	LDS  R30,_FLY_MODE
	LDI  R31,0
	MOVW R22,R26
	LDI  R26,LOW(246)
	LDI  R27,HIGH(246)
	CALL __MULW12U
	MOVW R26,R22
	ADD  R26,R30
	ADC  R27,R31
	ADIW R26,11
	LDD  R30,Y+1
	LDI  R31,0
	MOVW R22,R26
	LDI  R26,LOW(13)
	LDI  R27,HIGH(13)
	CALL __MULW12U
	ADD  R30,R22
	ADC  R31,R23
	ADIW R30,1
	RJMP _0x206000A
; 000C 0286 
; 000C 0287         case CTRLS_MINDR:
_0x18003A:
	CPI  R30,LOW(0x4)
	BREQ _0x18003C
; 000C 0288         case CTRLS_TCUT:
	CPI  R30,LOW(0x5)
	BRNE _0x18003D
_0x18003C:
; 000C 0289             return(&CurModel.Mode[FLY_MODE].Control[Control].minDRates);
	__POINTW2MN _CurModel,21
	LDS  R30,_FLY_MODE
	LDI  R31,0
	MOVW R22,R26
	LDI  R26,LOW(246)
	LDI  R27,HIGH(246)
	CALL __MULW12U
	MOVW R26,R22
	ADD  R26,R30
	ADC  R27,R31
	ADIW R26,11
	LDD  R30,Y+1
	LDI  R31,0
	MOVW R22,R26
	LDI  R26,LOW(13)
	LDI  R27,HIGH(13)
	CALL __MULW12U
	ADD  R30,R22
	ADC  R31,R23
	ADIW R30,4
	RJMP _0x206000A
; 000C 028A 
; 000C 028B         case CTRLS_MAXDR:
_0x18003D:
	CPI  R30,LOW(0x3)
	BRNE _0x18003F
; 000C 028C             return(&CurModel.Mode[FLY_MODE].Control[Control].maxDRates);
	__POINTW2MN _CurModel,21
	LDS  R30,_FLY_MODE
	LDI  R31,0
	MOVW R22,R26
	LDI  R26,LOW(246)
	LDI  R27,HIGH(246)
	CALL __MULW12U
	MOVW R26,R22
	ADD  R26,R30
	ADC  R27,R31
	ADIW R26,11
	LDD  R30,Y+1
	LDI  R31,0
	MOVW R22,R26
	LDI  R26,LOW(13)
	LDI  R27,HIGH(13)
	CALL __MULW12U
	ADD  R30,R22
	ADC  R31,R23
	ADIW R30,3
	RJMP _0x206000A
; 000C 028D 
; 000C 028E         default:
_0x18003F:
; 000C 028F             return(NULL);
	LDI  R30,LOW(0)
	LDI  R31,HIGH(0)
; 000C 0290     }
; 000C 0291 }
_0x206000A:
	ADIW R28,2
	RET
;
;// ***        ****************************************
;char * ControlsRateGetStr(char * Buf, char AddParam)
; 000C 0295 {
_ControlsRateGetStr:
; 000C 0296     //  
; 000C 0297     unsigned char * val = ControlsRateGetPointer(CurrentControl, AddParam);
; 000C 0298 
; 000C 0299     //     
; 000C 029A     if(val) sprintf(Buf, "%d", *val);
	ST   -Y,R17
	ST   -Y,R16
;	*Buf -> Y+3
;	AddParam -> Y+2
;	*val -> R16,R17
	LDS  R30,_CurrentControl_G00C
	ST   -Y,R30
	LDD  R30,Y+3
	ST   -Y,R30
	RCALL _ControlsRateGetPointer_G00C
	MOVW R16,R30
	MOV  R0,R16
	OR   R0,R17
	BREQ _0x180040
	LDD  R30,Y+3
	LDD  R31,Y+3+1
	ST   -Y,R31
	ST   -Y,R30
	__POINTW1FN _0x180000,0
	ST   -Y,R31
	ST   -Y,R30
	MOVW R26,R16
	LD   R30,X
	CLR  R31
	CLR  R22
	CLR  R23
	CALL __PUTPARD1
	LDI  R24,4
	CALL _sprintf
	ADIW R28,8
; 000C 029B     else    sprintf(Buf, "ERROR");
	RJMP _0x180041
_0x180040:
	LDD  R30,Y+3
	LDD  R31,Y+3+1
	ST   -Y,R31
	ST   -Y,R30
	__POINTW1FN _0x180000,260
	ST   -Y,R31
	ST   -Y,R30
	LDI  R24,0
	CALL _sprintf
	ADIW R28,4
; 000C 029C     //     
; 000C 029D     return(Buf);
_0x180041:
_0x2060009:
	LDD  R30,Y+3
	LDD  R31,Y+3+1
	LDD  R17,Y+1
	LDD  R16,Y+0
	ADIW R28,5
	RET
; 000C 029E }
;
;// ***       **************************************************
;void ControlsRateSet(char AddParam)
; 000C 02A2 {
_ControlsRateSet:
; 000C 02A3     //    
; 000C 02A4     EditNumDlg(ControlsRateGetPointer(CurrentControl, AddParam), PTR_UCHAR, 0, 150, 3, "Control:");
;	AddParam -> Y+0
	LDS  R30,_CurrentControl_G00C
	ST   -Y,R30
	LDD  R30,Y+1
	ST   -Y,R30
	RCALL _ControlsRateGetPointer_G00C
	ST   -Y,R31
	ST   -Y,R30
	LDI  R30,LOW(4)
	ST   -Y,R30
	LDI  R30,LOW(0)
	LDI  R31,HIGH(0)
	ST   -Y,R31
	ST   -Y,R30
	LDI  R30,LOW(150)
	LDI  R31,HIGH(150)
	ST   -Y,R31
	ST   -Y,R30
	LDI  R30,LOW(3)
	ST   -Y,R30
	__POINTW1FN _0x180000,275
	ST   -Y,R31
	ST   -Y,R30
	CALL _EditNumDlg
; 000C 02A5 }
	JMP  _0x2060005
;
;// ***       **************************************************
;void ControlsCurveChange(char AddParam)
; 000C 02A9 {
_ControlsCurveChange:
; 000C 02AA     unsigned char i;
; 000C 02AB     //    
; 000C 02AC     unsigned char Kbd = 0;
; 000C 02AD     char * nodes = CurModel.Mode[FLY_MODE].Control[CurrentControl].nodes;
; 000C 02AE     int x1, x2;
; 000C 02AF     char Y[CURVE_NODES];
; 000C 02B0     char tmp[CURVE_NODES];
; 000C 02B1     unsigned char sel = 0;
; 000C 02B2 
; 000C 02B3     //    
; 000C 02B4     for(i=0; i < CURVE_NODES; i++) tmp[i] = nodes[i];
	SBIW R28,17
	LDI  R30,LOW(0)
	ST   Y,R30
	CALL __SAVELOCR6
;	AddParam -> Y+23
;	i -> R17
;	Kbd -> R16
;	*nodes -> R18,R19
;	x1 -> R20,R21
;	x2 -> Y+21
;	Y -> Y+14
;	tmp -> Y+7
;	sel -> Y+6
	LDI  R16,0
	__POINTW2MN _CurModel,21
	LDS  R30,_FLY_MODE
	LDI  R31,0
	MOVW R22,R26
	LDI  R26,LOW(246)
	LDI  R27,HIGH(246)
	CALL __MULW12U
	MOVW R26,R22
	ADD  R26,R30
	ADC  R27,R31
	ADIW R26,11
	LDS  R30,_CurrentControl_G00C
	LDI  R31,0
	MOVW R22,R26
	LDI  R26,LOW(13)
	LDI  R27,HIGH(13)
	CALL __MULW12U
	ADD  R30,R22
	ADC  R31,R23
	ADIW R30,6
	MOVW R18,R30
	LDI  R17,LOW(0)
_0x180043:
	CPI  R17,7
	BRSH _0x180044
	MOV  R30,R17
	LDI  R31,0
	MOVW R26,R28
	ADIW R26,7
	ADD  R30,R26
	ADC  R31,R27
	MOVW R0,R30
	MOVW R26,R18
	CLR  R30
	ADD  R26,R17
	ADC  R27,R30
	LD   R30,X
	MOVW R26,R0
	ST   X,R30
	SUBI R17,-1
	RJMP _0x180043
_0x180044:
; 000C 02B6 do
_0x180046:
; 000C 02B7     {
; 000C 02B8         //    
; 000C 02B9         gfx_FillRect(63 - 3, 0, 127, 63, 0);
	LDI  R30,LOW(60)
	LDI  R31,HIGH(60)
	ST   -Y,R31
	ST   -Y,R30
	LDI  R30,LOW(0)
	LDI  R31,HIGH(0)
	ST   -Y,R31
	ST   -Y,R30
	LDI  R30,LOW(127)
	LDI  R31,HIGH(127)
	ST   -Y,R31
	ST   -Y,R30
	LDI  R30,LOW(63)
	LDI  R31,HIGH(63)
	ST   -Y,R31
	ST   -Y,R30
	LDI  R30,LOW(0)
	ST   -Y,R30
	CALL _gfx_FillRect
; 000C 02BA 
; 000C 02BB         //      
; 000C 02BC         gfx_DashLine(63, HeightS/2, 127, HeightS/2);
	LDI  R30,LOW(63)
	LDI  R31,HIGH(63)
	ST   -Y,R31
	ST   -Y,R30
	LDI  R30,LOW(32)
	LDI  R31,HIGH(32)
	ST   -Y,R31
	ST   -Y,R30
	LDI  R30,LOW(127)
	LDI  R31,HIGH(127)
	ST   -Y,R31
	ST   -Y,R30
	LDI  R30,LOW(32)
	LDI  R31,HIGH(32)
	ST   -Y,R31
	ST   -Y,R30
	CALL _gfx_DashLine
; 000C 02BD 
; 000C 02BE         //     
; 000C 02BF         for(i=0; i < CURVE_NODES - 2; i++)
	LDI  R17,LOW(0)
_0x180049:
	CPI  R17,5
	BRSH _0x18004A
; 000C 02C0         {
; 000C 02C1             x1 = 63 + (64 * (int)(i+1)) / (CURVE_NODES - 1);
	MOV  R30,R17
	SUBI R30,-LOW(1)
	LDI  R26,LOW(64)
	MUL  R30,R26
	MOVW R30,R0
	MOVW R26,R30
	LDI  R30,LOW(6)
	LDI  R31,HIGH(6)
	CALL __DIVW21
	ADIW R30,63
	MOVW R20,R30
; 000C 02C2             gfx_DashLine(x1, 0, x1, HeightS);
	ST   -Y,R21
	ST   -Y,R20
	LDI  R30,LOW(0)
	LDI  R31,HIGH(0)
	ST   -Y,R31
	ST   -Y,R30
	ST   -Y,R21
	ST   -Y,R20
	LDI  R30,LOW(64)
	LDI  R31,HIGH(64)
	ST   -Y,R31
	ST   -Y,R30
	CALL _gfx_DashLine
; 000C 02C3         }
	SUBI R17,-1
	RJMP _0x180049
_0x18004A:
; 000C 02C4 
; 000C 02C5         //        (Y)
; 000C 02C6         for(i=0; i < CURVE_NODES; i++)
	LDI  R17,LOW(0)
_0x18004C:
	CPI  R17,7
	BRSH _0x18004D
; 000C 02C7         {
; 000C 02C8             Y[i] = ((int)tmp[i] * 100 / -317) + 64/2;
	MOV  R30,R17
	LDI  R31,0
	MOVW R0,R30
	MOVW R26,R28
	ADIW R26,14
	ADD  R30,R26
	ADC  R31,R27
	MOVW R22,R30
	MOVW R30,R0
	MOVW R26,R28
	ADIW R26,7
	ADD  R26,R30
	ADC  R27,R31
	LD   R30,X
	LDI  R26,LOW(100)
	MULS R30,R26
	MOVW R30,R0
	MOVW R26,R30
	LDI  R30,LOW(65219)
	LDI  R31,HIGH(65219)
	CALL __DIVW21
	SUBI R30,-LOW(32)
	MOVW R26,R22
	ST   X,R30
; 000C 02C9         }
	SUBI R17,-1
	RJMP _0x18004C
_0x18004D:
; 000C 02CA 
; 000C 02CB         //    
; 000C 02CC         for(i=0; i < CURVE_NODES - 1; i++)
	LDI  R17,LOW(0)
_0x18004F:
	CPI  R17,6
	BRLO PC+3
	JMP _0x180050
; 000C 02CD         {
; 000C 02CE             x1 = 63 + (64 * (int) i)    / (CURVE_NODES - 1);
	LDI  R26,LOW(64)
	MUL  R17,R26
	MOVW R30,R0
	MOVW R26,R30
	LDI  R30,LOW(6)
	LDI  R31,HIGH(6)
	CALL __DIVW21
	ADIW R30,63
	MOVW R20,R30
; 000C 02CF             x2 = 63 + (64 * (int)(i+1)) / (CURVE_NODES - 1);
	MOV  R30,R17
	SUBI R30,-LOW(1)
	LDI  R26,LOW(64)
	MUL  R30,R26
	MOVW R30,R0
	MOVW R26,R30
	LDI  R30,LOW(6)
	LDI  R31,HIGH(6)
	CALL __DIVW21
	ADIW R30,63
	STD  Y+21,R30
	STD  Y+21+1,R31
; 000C 02D0             gfx_Line(x1, Y[i], x2, Y[i+1], 1);
	ST   -Y,R21
	ST   -Y,R20
	MOV  R30,R17
	LDI  R31,0
	MOVW R26,R28
	ADIW R26,16
	ADD  R26,R30
	ADC  R27,R31
	LD   R30,X
	LDI  R31,0
	SBRC R30,7
	SER  R31
	ST   -Y,R31
	ST   -Y,R30
	LDD  R30,Y+25
	LDD  R31,Y+25+1
	ST   -Y,R31
	ST   -Y,R30
	MOV  R30,R17
	SUBI R30,-LOW(1)
	LDI  R31,0
	MOVW R26,R28
	ADIW R26,20
	ADD  R26,R30
	ADC  R27,R31
	LD   R30,X
	LDI  R31,0
	SBRC R30,7
	SER  R31
	ST   -Y,R31
	ST   -Y,R30
	LDI  R30,LOW(1)
	ST   -Y,R30
	CALL _gfx_Line
; 000C 02D1         }
	SUBI R17,-1
	RJMP _0x18004F
_0x180050:
; 000C 02D2 
; 000C 02D3         //     
; 000C 02D4         x1 = 63 + (64 * (int)sel) / (CURVE_NODES - 1);
	LDD  R30,Y+6
	LDI  R26,LOW(64)
	MUL  R30,R26
	MOVW R30,R0
	MOVW R26,R30
	LDI  R30,LOW(6)
	LDI  R31,HIGH(6)
	CALL __DIVW21
	ADIW R30,63
	MOVW R20,R30
; 000C 02D5         gfx_Rectangle(x1 - 2, Y[sel] - 2, x1 + 2, Y[sel] + 2, 1);
	MOVW R30,R20
	SBIW R30,2
	ST   -Y,R31
	ST   -Y,R30
	LDD  R30,Y+8
	LDI  R31,0
	MOVW R26,R28
	ADIW R26,16
	ADD  R26,R30
	ADC  R27,R31
	LD   R30,X
	SUBI R30,LOW(2)
	LDI  R31,0
	SBRC R30,7
	SER  R31
	ST   -Y,R31
	ST   -Y,R30
	MOVW R30,R20
	ADIW R30,2
	ST   -Y,R31
	ST   -Y,R30
	LDD  R30,Y+12
	LDI  R31,0
	MOVW R26,R28
	ADIW R26,20
	ADD  R26,R30
	ADC  R27,R31
	LD   R30,X
	SUBI R30,-LOW(2)
	LDI  R31,0
	SBRC R30,7
	SER  R31
	ST   -Y,R31
	ST   -Y,R30
	LDI  R30,LOW(1)
	ST   -Y,R30
	CALL _gfx_Rectangle
; 000C 02D6 
; 000C 02D7         //     
; 000C 02D8         gfx_Rectangle(63, 0, 127, 63, 1);
	LDI  R30,LOW(63)
	LDI  R31,HIGH(63)
	ST   -Y,R31
	ST   -Y,R30
	LDI  R30,LOW(0)
	LDI  R31,HIGH(0)
	ST   -Y,R31
	ST   -Y,R30
	LDI  R30,LOW(127)
	LDI  R31,HIGH(127)
	ST   -Y,R31
	ST   -Y,R30
	LDI  R30,LOW(63)
	LDI  R31,HIGH(63)
	ST   -Y,R31
	ST   -Y,R30
	LDI  R30,LOW(1)
	ST   -Y,R30
	CALL _gfx_Rectangle
; 000C 02D9 
; 000C 02DA         //     
; 000C 02DB         sprintf(tmpBuf, "%d", tmp[sel]);
	LDI  R30,LOW(_tmpBuf)
	LDI  R31,HIGH(_tmpBuf)
	ST   -Y,R31
	ST   -Y,R30
	__POINTW1FN _0x180000,0
	ST   -Y,R31
	ST   -Y,R30
	LDD  R30,Y+10
	LDI  R31,0
	MOVW R26,R28
	ADIW R26,11
	ADD  R26,R30
	ADC  R27,R31
	LD   R30,X
	CALL __CBD1
	CALL __PUTPARD1
	LDI  R24,4
	CALL _sprintf
	ADIW R28,8
; 000C 02DC         MsgBoxEx(tmpBuf, 1, NULL, "Curve", NULL, WidthS / 4, HeightS / 2, 4, 0xFF);
	LDI  R30,LOW(_tmpBuf)
	LDI  R31,HIGH(_tmpBuf)
	ST   -Y,R31
	ST   -Y,R30
	LDI  R30,LOW(1)
	ST   -Y,R30
	LDI  R30,LOW(0)
	LDI  R31,HIGH(0)
	ST   -Y,R31
	ST   -Y,R30
	__POINTW1FN _0x180000,284
	ST   -Y,R31
	ST   -Y,R30
	LDI  R30,LOW(0)
	LDI  R31,HIGH(0)
	ST   -Y,R31
	ST   -Y,R30
	LDI  R30,LOW(32)
	ST   -Y,R30
	ST   -Y,R30
	LDI  R30,LOW(4)
	ST   -Y,R30
	LDI  R30,LOW(255)
	ST   -Y,R30
	CALL _MsgBoxEx
; 000C 02DD 
; 000C 02DE         //    
; 000C 02DF         gfx_Refresh();
	CALL _gfx_Refresh
; 000C 02E0 
; 000C 02E1         //   
; 000C 02E2         Kbd = WaitButtonPress(0);
	LDI  R30,LOW(0)
	ST   -Y,R30
	CALL _WaitButtonPress
	MOV  R16,R30
; 000C 02E3         //        0 -  
; 000C 02E4         if((Kbd == B_LEFT)  && (sel > 0)  ) sel--;
	CPI  R16,4
	BRNE _0x180052
	LDD  R26,Y+6
	CPI  R26,LOW(0x1)
	BRSH _0x180053
_0x180052:
	RJMP _0x180051
_0x180053:
	LDD  R30,Y+6
	SUBI R30,LOW(1)
	STD  Y+6,R30
; 000C 02E5         //        CURVE_NODES-1 -  
; 000C 02E6         if((Kbd == B_RIGHT) && (sel < CURVE_NODES - 1)) sel++;
_0x180051:
	CPI  R16,8
	BRNE _0x180055
	LDD  R26,Y+6
	CPI  R26,LOW(0x6)
	BRLO _0x180056
_0x180055:
	RJMP _0x180054
_0x180056:
	LDD  R30,Y+6
	SUBI R30,-LOW(1)
	STD  Y+6,R30
; 000C 02E7         //          0 -  
; 000C 02E8         if((Kbd == B_DOWN) && (tmp[sel] > -100)) tmp[sel]--;
_0x180054:
	CPI  R16,2
	BRNE _0x180058
	LDD  R30,Y+6
	LDI  R31,0
	MOVW R26,R28
	ADIW R26,7
	ADD  R26,R30
	ADC  R27,R31
	LD   R26,X
	LDI  R30,LOW(156)
	CP   R30,R26
	BRLT _0x180059
_0x180058:
	RJMP _0x180057
_0x180059:
	LDD  R30,Y+6
	LDI  R31,0
	MOVW R26,R28
	ADIW R26,7
	ADD  R26,R30
	ADC  R27,R31
	LD   R30,X
	SUBI R30,LOW(1)
	ST   X,R30
; 000C 02E9         //       150 -  
; 000C 02EA         if((Kbd == B_UP)   && (tmp[sel] <  100)) tmp[sel]++;
_0x180057:
	CPI  R16,1
	BRNE _0x18005B
	LDD  R30,Y+6
	LDI  R31,0
	MOVW R26,R28
	ADIW R26,7
	ADD  R26,R30
	ADC  R27,R31
	LD   R26,X
	CPI  R26,LOW(0x64)
	BRLT _0x18005C
_0x18005B:
	RJMP _0x18005A
_0x18005C:
	LDD  R30,Y+6
	LDI  R31,0
	MOVW R26,R28
	ADIW R26,7
	ADD  R26,R30
	ADC  R27,R31
	LD   R30,X
	SUBI R30,-LOW(1)
	ST   X,R30
; 000C 02EB 
; 000C 02EC         // E     -   , ..  
; 000C 02ED         if((Kbd == B_LEFT) || (Kbd == B_RIGHT)) WaitEmptyButtons(0);
_0x18005A:
	CPI  R16,4
	BREQ _0x18005E
	CPI  R16,8
	BRNE _0x18005D
_0x18005E:
	LDI  R30,LOW(0)
	ST   -Y,R30
	CALL _WaitEmptyButtons
; 000C 02EE     }
_0x18005D:
; 000C 02EF     while((Kbd != B_ENTER) && (Kbd != B_BACK)); //      - 
	CPI  R16,32
	BREQ _0x180060
	CPI  R16,16
	BRNE _0x180061
_0x180060:
	RJMP _0x180047
_0x180061:
	RJMP _0x180046
_0x180047:
; 000C 02F0 
; 000C 02F1     //     -   
; 000C 02F2     if(Kbd == B_ENTER) for(i=0; i < CURVE_NODES; i++) nodes[i] = tmp[i];
	CPI  R16,32
	BRNE _0x180062
	LDI  R17,LOW(0)
_0x180064:
	CPI  R17,7
	BRSH _0x180065
	MOV  R30,R17
	LDI  R31,0
	MOVW R26,R30
	ADD  R30,R18
	ADC  R31,R19
	MOVW R0,R30
	MOVW R30,R26
	MOVW R26,R28
	ADIW R26,7
	ADD  R26,R30
	ADC  R27,R31
	LD   R30,X
	MOVW R26,R0
	ST   X,R30
	SUBI R17,-1
	RJMP _0x180064
_0x180065:
; 000C 02F3 }
_0x180062:
	CALL __LOADLOCR6
	ADIW R28,24
	RET
;
;// ***         ********************************
;flash MenuButton ControlsMainSettings[] =
;{{"Reverse",       ControlsReverseSet, ControlsReverseGetStr, CTRLS_REV},
; {"Min Rate",      ControlsRateSet, ControlsRateGetStr, CTRLS_MINR},
; {"Max Rate",      ControlsRateSet, ControlsRateGetStr, CTRLS_MAXR},
; {"Min Dual Rate", ControlsRateSet, ControlsRateGetStr, CTRLS_MAXDR},
; {"Max Dual Rate", ControlsRateSet, ControlsRateGetStr, CTRLS_MINDR},
; {"Curve",         ControlsCurveChange, NULL, CTRLS_CURVE}};
;
;// ***       **********************************************
;flash MenuButton ControlsThrottleSettings[] =
;{{"Reverse",       ControlsReverseSet, ControlsReverseGetStr, CTRLS_REV},
; {"Min Rate",      ControlsRateSet, ControlsRateGetStr, CTRLS_MINR},
; {"Max Rate",      ControlsRateSet, ControlsRateGetStr, CTRLS_MAXR},
; {"T. Cut",        ControlsRateSet, ControlsRateGetStr, CTRLS_TCUT},
; {"Curve",         ControlsCurveChange, NULL, CTRLS_CURVE}};
;
;// ***       **************************************
;flash MenuButton ControlsAuxSettings[] =
;{{"Reverse",       ControlsReverseSet, ControlsReverseGetStr, CTRLS_REV},
; {"Min Rate",      ControlsRateSet, ControlsRateGetStr, CTRLS_MINR},
; {"Max Rate",      ControlsRateSet, ControlsRateGetStr, CTRLS_MAXR},
; {"Curve",         ControlsCurveChange, NULL, CTRLS_CURVE}};
;
;// ***       **************************************
;flash MenuButton ControlsSwSettings[] =
;{{"Reverse",       ControlsReverseSet, ControlsReverseGetStr, CTRLS_REV},
; {"Min Rate",      ControlsRateSet, ControlsRateGetStr, CTRLS_MINR},
; {"Max Rate",      ControlsRateSet, ControlsRateGetStr, CTRLS_MAXR}};
;
;// ***       *************************************
;flash MenuButton ControlsVSettings[] =
;{{"Reverse",       ControlsReverseSet, ControlsReverseGetStr, CTRLS_REV},
; {"Min Rate",      ControlsRateSet, ControlsRateGetStr, CTRLS_MINR},
; {"Max Rate",      ControlsRateSet, ControlsRateGetStr, CTRLS_MAXR},
; {"Curve",         ControlsCurveChange, NULL, CTRLS_CURVE},
; {"From",          ControlsVirtualSet, ControlsVirtualGetStr, CTRLS_FROM}};
;
;void ControlsSettingsMenu(char AddParam)
; 000C 031C {
_ControlsSettingsMenu:
; 000C 031D     //   
; 000C 031E     MenuPad Pad = {"Controls", &Font_8x12, &Font_6x8, NULL, 0, 0, NULL, NULL};
; 000C 031F     //     
; 000C 0320     CurrentControl = AddParam;
	SBIW R28,14
	LDI  R24,14
	LDI  R26,LOW(0)
	LDI  R27,HIGH(0)
	LDI  R30,LOW(_0x180066*2)
	LDI  R31,HIGH(_0x180066*2)
	CALL __INITLOCB
;	AddParam -> Y+14
;	Pad -> Y+0
	LDD  R30,Y+14
	STS  _CurrentControl_G00C,R30
; 000C 0321 
; 000C 0322     //       
; 000C 0323     switch(AddParam)
; 000C 0324     {
; 000C 0325         case CTRL_AIL:
	CPI  R30,0
	BREQ _0x18006B
; 000C 0326         case CTRL_ELE:
	CPI  R30,LOW(0x1)
	BRNE _0x18006C
_0x18006B:
; 000C 0327         case CTRL_RUD:
	RJMP _0x18006D
_0x18006C:
	CPI  R30,LOW(0x3)
	BRNE _0x18006E
_0x18006D:
; 000C 0328             Pad.Buttons = ControlsMainSettings;
	RJMP _0x18009E
; 000C 0329             Pad.ButtonsNum = NumberOf(ControlsMainSettings);
; 000C 032A             break;
; 000C 032B 
; 000C 032C         case CTRL_THR:
_0x18006E:
	CPI  R30,LOW(0x2)
	BRNE _0x18006F
; 000C 032D             Pad.Buttons = ControlsThrottleSettings;
	LDI  R30,LOW(_ControlsThrottleSettings*2)
	LDI  R31,HIGH(_ControlsThrottleSettings*2)
	STD  Y+6,R30
	STD  Y+6+1,R31
; 000C 032E             Pad.ButtonsNum = NumberOf(ControlsThrottleSettings);
	LDI  R30,LOW(5)
	RJMP _0x18009F
; 000C 032F             break;
; 000C 0330 
; 000C 0331         case CTRL_AUX1:
_0x18006F:
	CPI  R30,LOW(0x7)
	BRNE _0x180070
; 000C 0332             Pad.Buttons = ControlsAuxSettings;
	LDI  R30,LOW(_ControlsAuxSettings*2)
	LDI  R31,HIGH(_ControlsAuxSettings*2)
	STD  Y+6,R30
	STD  Y+6+1,R31
; 000C 0333             Pad.ButtonsNum = NumberOf(ControlsAuxSettings);
	LDI  R30,LOW(4)
	RJMP _0x18009F
; 000C 0334             break;
; 000C 0335 
; 000C 0336         case CTRL_SW1:
_0x180070:
	CPI  R30,LOW(0x4)
	BREQ _0x180072
; 000C 0337         case CTRL_SW2:
	CPI  R30,LOW(0x5)
	BRNE _0x180073
_0x180072:
; 000C 0338         case CTRL_SW3:
	RJMP _0x180074
_0x180073:
	CPI  R30,LOW(0x6)
	BRNE _0x180075
_0x180074:
; 000C 0339             Pad.Buttons = ControlsSwSettings;
	LDI  R30,LOW(_ControlsSwSettings*2)
	LDI  R31,HIGH(_ControlsSwSettings*2)
	STD  Y+6,R30
	STD  Y+6+1,R31
; 000C 033A             Pad.ButtonsNum = NumberOf(ControlsSwSettings);
	LDI  R30,LOW(3)
	RJMP _0x18009F
; 000C 033B             break;
; 000C 033C 
; 000C 033D         case CTRL_V1:
_0x180075:
	CPI  R30,LOW(0x8)
	BREQ _0x180077
; 000C 033E         case CTRL_V2:
	CPI  R30,LOW(0x9)
	BRNE _0x180079
_0x180077:
; 000C 033F             Pad.Buttons = ControlsVSettings;
	LDI  R30,LOW(_ControlsVSettings*2)
	LDI  R31,HIGH(_ControlsVSettings*2)
	STD  Y+6,R30
	STD  Y+6+1,R31
; 000C 0340             Pad.ButtonsNum = NumberOf(ControlsVSettings);
	LDI  R30,LOW(5)
	RJMP _0x18009F
; 000C 0341             break;
; 000C 0342 
; 000C 0343         default:
_0x180079:
; 000C 0344             Pad.Buttons = ControlsMainSettings;
_0x18009E:
	LDI  R30,LOW(_ControlsMainSettings*2)
	LDI  R31,HIGH(_ControlsMainSettings*2)
	STD  Y+6,R30
	STD  Y+6+1,R31
; 000C 0345             Pad.ButtonsNum = NumberOf(ControlsMainSettings);
	LDI  R30,LOW(6)
_0x18009F:
	STD  Y+8,R30
; 000C 0346             break;
; 000C 0347     }
; 000C 0348 
; 000C 0349     //   
; 000C 034A     MenuCycle(&Pad);
	JMP  _0x2060004
; 000C 034B }
;
;flash MenuButton ControlsMenuButtons[] =
;{{"Ailerons",  ControlsSettingsMenu, NULL, CTRL_AIL},
; {"Elevator",  ControlsSettingsMenu, NULL, CTRL_ELE},
; {"Throttle",  ControlsSettingsMenu, NULL, CTRL_THR},
; {"Rudder",    ControlsSettingsMenu, NULL, CTRL_RUD},
; {"SW 1",      ControlsSettingsMenu, NULL, CTRL_SW1},
; {"SW 2",      ControlsSettingsMenu, NULL, CTRL_SW2},
; {"SW 3",      ControlsSettingsMenu, NULL, CTRL_SW3},
; {"Aux 1",     ControlsSettingsMenu, NULL, CTRL_AUX1},
; {"Virtual 1", ControlsSettingsMenu, NULL, CTRL_V1},
; {"Virtual 2", ControlsSettingsMenu, NULL, CTRL_V2}};
;
;void ControlsMenu(char AddParam)
; 000C 035A {
_ControlsMenu:
; 000C 035B     //   
; 000C 035C     MenuPad Pad = {"Controls", &Font_8x12, &Font_6x8, ControlsMenuButtons, NumberOf(ControlsMenuButtons), 0, NULL, NULL};
; 000C 035D     //   
; 000C 035E     MenuCycle(&Pad);
	SBIW R28,14
	LDI  R24,14
	LDI  R26,LOW(0)
	LDI  R27,HIGH(0)
	LDI  R30,LOW(_0x18007A*2)
	LDI  R31,HIGH(_0x18007A*2)
	CALL __INITLOCB
;	AddParam -> Y+14
;	Pad -> Y+0
	JMP  _0x2060004
; 000C 035F }
;
;// *****************************************************************************
;// ***    ()   ***********************************************
;// *****************************************************************************
;
;// ***       ******************************************
;static char MixerCurrentChannel;
;
;// ***       ******************************************
;void MixerChangeSetting(char AddParam)
; 000C 036A {
_MixerChangeSetting:
; 000C 036B     //    
; 000C 036C     EditNumDlg(&CurModel.Mode[FLY_MODE].Chanels[MixerCurrentChannel][AddParam], PTR_CHAR, -100, 100, 4, "Mixer");
;	AddParam -> Y+0
	__POINTW2MN _CurModel,21
	LDS  R30,_FLY_MODE
	LDI  R31,0
	MOVW R22,R26
	LDI  R26,LOW(246)
	LDI  R27,HIGH(246)
	CALL __MULW12U
	MOVW R26,R22
	ADD  R26,R30
	ADC  R27,R31
	SUBI R26,LOW(-154)
	SBCI R27,HIGH(-154)
	LDS  R30,_MixerCurrentChannel_G00C
	LDI  R31,0
	MOVW R22,R26
	LDI  R26,LOW(11)
	LDI  R27,HIGH(11)
	CALL __MULW12U
	MOVW R26,R22
	ADD  R26,R30
	ADC  R27,R31
	LD   R30,Y
	LDI  R31,0
	ADD  R30,R26
	ADC  R31,R27
	ST   -Y,R31
	ST   -Y,R30
	LDI  R30,LOW(3)
	ST   -Y,R30
	LDI  R30,LOW(65436)
	LDI  R31,HIGH(65436)
	ST   -Y,R31
	ST   -Y,R30
	LDI  R30,LOW(100)
	LDI  R31,HIGH(100)
	ST   -Y,R31
	ST   -Y,R30
	LDI  R30,LOW(4)
	ST   -Y,R30
	__POINTW1FN _0x180000,440
	ST   -Y,R31
	ST   -Y,R30
	CALL _EditNumDlg
; 000C 036D }
	JMP  _0x2060005
;
;// ***         **********************************
;char * MixerGetStr(char * Buf, char AddParam)
; 000C 0371 {
_MixerGetStr:
; 000C 0372     //     
; 000C 0373     sprintf(Buf, "%d", CurModel.Mode[FLY_MODE].Chanels[MixerCurrentChannel][AddParam]);
;	*Buf -> Y+1
;	AddParam -> Y+0
	LDD  R30,Y+1
	LDD  R31,Y+1+1
	ST   -Y,R31
	ST   -Y,R30
	__POINTW1FN _0x180000,0
	ST   -Y,R31
	ST   -Y,R30
	__POINTW2MN _CurModel,21
	LDS  R30,_FLY_MODE
	LDI  R31,0
	MOVW R22,R26
	LDI  R26,LOW(246)
	LDI  R27,HIGH(246)
	CALL __MULW12U
	MOVW R26,R22
	ADD  R26,R30
	ADC  R27,R31
	SUBI R26,LOW(-154)
	SBCI R27,HIGH(-154)
	LDS  R30,_MixerCurrentChannel_G00C
	LDI  R31,0
	MOVW R22,R26
	LDI  R26,LOW(11)
	LDI  R27,HIGH(11)
	CALL __MULW12U
	MOVW R26,R22
	ADD  R26,R30
	ADC  R27,R31
	LDD  R30,Y+4
	LDI  R31,0
	ADD  R26,R30
	ADC  R27,R31
	LD   R30,X
	CALL __CBD1
	CALL __PUTPARD1
	LDI  R24,4
	CALL _sprintf
	ADIW R28,8
; 000C 0374     //     
; 000C 0375     return(Buf);
	RJMP _0x2060008
; 000C 0376 }
;
;// ***           *************************
;flash MenuButton MixerMenuButtons[] =
;{{"Ailerons",  MixerChangeSetting, MixerGetStr, CTRL_AIL},
; {"Elevator",  MixerChangeSetting, MixerGetStr, CTRL_ELE},
; {"Throttle",  MixerChangeSetting, MixerGetStr, CTRL_THR},
; {"Rudder",    MixerChangeSetting, MixerGetStr, CTRL_RUD},
; {"SW 1",      MixerChangeSetting, MixerGetStr, CTRL_SW1},
; {"SW 2",      MixerChangeSetting, MixerGetStr, CTRL_SW2},
; {"SW 3",      MixerChangeSetting, MixerGetStr, CTRL_SW3},
; {"Aux 1",     MixerChangeSetting, MixerGetStr, CTRL_AUX1},
; {"Virtual 1", MixerChangeSetting, MixerGetStr, CTRL_V1},
; {"Virtual 2", MixerChangeSetting, MixerGetStr, CTRL_V2},
; {"Trim",      MixerChangeSetting, MixerGetStr, CTRL_TRIM}};
;
;// ***          ***********************************
;void ChannelsMixerMenu(char AddParam)
; 000C 0388 {
_ChannelsMixerMenu:
; 000C 0389     // TODO:   
; 000C 038A     char Cap[12];
; 000C 038B     //   
; 000C 038C     MenuPad Pad = {"Mixer", &Font_8x12, &Font_6x8, MixerMenuButtons, NumberOf(MixerMenuButtons), 0, NULL, NULL};
; 000C 038D     //     
; 000C 038E     MixerCurrentChannel = AddParam;
	SBIW R28,26
	LDI  R24,14
	LDI  R26,LOW(0)
	LDI  R27,HIGH(0)
	LDI  R30,LOW(_0x18007B*2)
	LDI  R31,HIGH(_0x18007B*2)
	CALL __INITLOCB
;	AddParam -> Y+26
;	Cap -> Y+14
;	Pad -> Y+0
	LDD  R30,Y+26
	STS  _MixerCurrentChannel_G00C,R30
; 000C 038F     //   
; 000C 0390     snprintf(Cap, sizeof(Cap), "CH %n Mixer", AddParam);
	MOVW R30,R28
	ADIW R30,14
	ST   -Y,R31
	ST   -Y,R30
	LDI  R30,LOW(12)
	LDI  R31,HIGH(12)
	ST   -Y,R31
	ST   -Y,R30
	__POINTW1FN _0x180000,451
	ST   -Y,R31
	ST   -Y,R30
	LDD  R30,Y+32
	CALL __CBD1
	CALL __PUTPARD1
	LDI  R24,4
	CALL _snprintf
	ADIW R28,10
; 000C 0391     //   
; 000C 0392     MenuCycle(&Pad);
	MOVW R30,R28
	ST   -Y,R31
	ST   -Y,R30
	CALL _MenuCycle
; 000C 0393 }
	ADIW R28,27
	RET
;
;// ***          ********************************
;flash MenuButton ChannelsMenuButtons[] =
;{{"CH 1", ChannelsMixerMenu, NULL, 0},
; {"CH 2", ChannelsMixerMenu, NULL, 1},
; {"CH 3", ChannelsMixerMenu, NULL, 2},
; {"CH 4", ChannelsMixerMenu, NULL, 3},
; {"CH 5", ChannelsMixerMenu, NULL, 4},
; {"CH 6", ChannelsMixerMenu, NULL, 5},
; {"CH 7", ChannelsMixerMenu, NULL, 6},
; {"CH 8", ChannelsMixerMenu, NULL, 7}};
;
;// ***           ***************************
;void ChannelsMenu(char AddParam)
; 000C 03A2 {
_ChannelsMenu:
; 000C 03A3     //   
; 000C 03A4     MenuPad Pad = {"Channels", &Font_8x12, &Font_6x8, ChannelsMenuButtons, NumberOf(ChannelsMenuButtons), 0, NULL, NULL};
; 000C 03A5     //         -  ,
; 000C 03A6     //        
; 000C 03A7     if(Pad.ButtonsNum > CurModel.num_ch) Pad.ButtonsNum = CurModel.num_ch;
	SBIW R28,14
	LDI  R24,14
	LDI  R26,LOW(0)
	LDI  R27,HIGH(0)
	LDI  R30,LOW(_0x18007C*2)
	LDI  R31,HIGH(_0x18007C*2)
	CALL __INITLOCB
;	AddParam -> Y+14
;	Pad -> Y+0
	__GETB1MN _CurModel,20
	LDD  R26,Y+8
	CP   R30,R26
	BRGE _0x18007D
	__GETB1MN _CurModel,20
	STD  Y+8,R30
; 000C 03A8     //   
; 000C 03A9     MenuCycle(&Pad);
_0x18007D:
	JMP  _0x2060004
; 000C 03AA }
;
;// *****************************************************************************
;// ***       ********************************************************
;// *****************************************************************************
;
;// ***         **********************************
;char * TimerModeGetStr(char * Buf, char AddParam)
; 000C 03B2 {
_TimerModeGetStr:
; 000C 03B3     //         
; 000C 03B4     sprintf(Buf, (CurModel.timer_mode & 0x02) ? "DOWN" : "UP");
;	*Buf -> Y+1
;	AddParam -> Y+0
	LDD  R30,Y+1
	LDD  R31,Y+1+1
	ST   -Y,R31
	ST   -Y,R30
	__GETB1MN _CurModel,19
	ANDI R30,LOW(0x2)
	BREQ _0x18007E
	__POINTW1FN _0x180000,503
	RJMP _0x18007F
_0x18007E:
	__POINTW1FN _0x180000,508
_0x18007F:
	RJMP _0x2060007
; 000C 03B5     //     
; 000C 03B6     return(Buf);
; 000C 03B7 }
;// ***        ********************************************
;void TimerModeSet(char AddParam)
; 000C 03BA {
_TimerModeSet:
; 000C 03BB     //    
; 000C 03BC     char result;
; 000C 03BD     //    
; 000C 03BE     flash char * Strings[2] = {"UP", "DOWN"};
; 000C 03BF 
; 000C 03C0     //    
; 000C 03C1     result = SelectBoxF((flash char **)Strings, 2, (CurModel.timer_mode & 0x02) ? 1 : 0, NULL, "Timer Mode:", NULL);
	SBIW R28,4
	LDI  R30,LOW(_0x180000*2+508)
	LDI  R31,HIGH(_0x180000*2+508)
	ST   Y,R30
	STD  Y+1,R31
	LDI  R30,LOW(_0x180000*2+503)
	LDI  R31,HIGH(_0x180000*2+503)
	STD  Y+2,R30
	STD  Y+2+1,R31
	ST   -Y,R17
;	AddParam -> Y+5
;	result -> R17
;	Strings -> Y+1
	MOVW R30,R28
	ADIW R30,1
	ST   -Y,R31
	ST   -Y,R30
	LDI  R30,LOW(2)
	ST   -Y,R30
	__GETB1MN _CurModel,19
	ANDI R30,LOW(0x2)
	BREQ _0x180081
	LDI  R30,LOW(1)
	RJMP _0x180082
_0x180081:
	LDI  R30,LOW(0)
_0x180082:
	ST   -Y,R30
	LDI  R30,LOW(0)
	LDI  R31,HIGH(0)
	ST   -Y,R31
	ST   -Y,R30
	__POINTW1FN _0x180000,511
	ST   -Y,R31
	ST   -Y,R30
	LDI  R30,LOW(0)
	LDI  R31,HIGH(0)
	ST   -Y,R31
	ST   -Y,R30
	CALL _SelectBoxF
	MOV  R17,R30
; 000C 03C2 
; 000C 03C3     //    ( )
; 000C 03C4     if(result != -1)
	CPI  R17,255
	BREQ _0x180084
; 000C 03C5     {
; 000C 03C6         //      -   
; 000C 03C7         if(result) CurModel.timer_mode |=  0x02;
	CPI  R17,0
	BREQ _0x180085
	__GETB1MN _CurModel,19
	ORI  R30,2
	RJMP _0x1800A0
; 000C 03C8         //  -   
; 000C 03C9         else       CurModel.timer_mode &= ~0x02;
_0x180085:
	__GETB1MN _CurModel,19
	ANDI R30,0xFD
_0x1800A0:
	__PUTB1MN _CurModel,19
; 000C 03CA     }
; 000C 03CB }
_0x180084:
	RJMP _0x2060006
;
;// ***         ***********************************
;char * TimerSoundGetStr(char * Buf, char AddParam)
; 000C 03CF {
_TimerSoundGetStr:
; 000C 03D0     //         
; 000C 03D1     sprintf(Buf, (CurModel.timer_mode & 0x01) ? "OFF" : "ON");
;	*Buf -> Y+1
;	AddParam -> Y+0
	LDD  R30,Y+1
	LDD  R31,Y+1+1
	ST   -Y,R31
	ST   -Y,R30
	__GETB1MN _CurModel,19
	ANDI R30,LOW(0x1)
	BREQ _0x180087
	__POINTW1FN _0x180000,253
	RJMP _0x180088
_0x180087:
	__POINTW1FN _0x180000,257
_0x180088:
	RJMP _0x2060007
; 000C 03D2     //     
; 000C 03D3     return(Buf);
; 000C 03D4 }
;// ***       **********************************************
;void TimerSoundSet(char AddParam)
; 000C 03D7 {
_TimerSoundSet:
; 000C 03D8     //    
; 000C 03D9     char result;
; 000C 03DA     //    
; 000C 03DB     flash char * Strings[2] = {"OFF", "ON"};
; 000C 03DC 
; 000C 03DD     //    
; 000C 03DE     result = SelectBoxF((flash char **)Strings, 2, (CurModel.timer_mode & 0x01) ? 0 : 1, NULL, "Timer Sound:", NULL);
	SBIW R28,4
	LDI  R30,LOW(_0x180000*2+253)
	LDI  R31,HIGH(_0x180000*2+253)
	ST   Y,R30
	STD  Y+1,R31
	LDI  R30,LOW(_0x180000*2+257)
	LDI  R31,HIGH(_0x180000*2+257)
	STD  Y+2,R30
	STD  Y+2+1,R31
	ST   -Y,R17
;	AddParam -> Y+5
;	result -> R17
;	Strings -> Y+1
	MOVW R30,R28
	ADIW R30,1
	ST   -Y,R31
	ST   -Y,R30
	LDI  R30,LOW(2)
	ST   -Y,R30
	__GETB1MN _CurModel,19
	ANDI R30,LOW(0x1)
	BREQ _0x18008A
	LDI  R30,LOW(0)
	RJMP _0x18008B
_0x18008A:
	LDI  R30,LOW(1)
_0x18008B:
	ST   -Y,R30
	LDI  R30,LOW(0)
	LDI  R31,HIGH(0)
	ST   -Y,R31
	ST   -Y,R30
	__POINTW1FN _0x180000,523
	ST   -Y,R31
	ST   -Y,R30
	LDI  R30,LOW(0)
	LDI  R31,HIGH(0)
	ST   -Y,R31
	ST   -Y,R30
	CALL _SelectBoxF
	MOV  R17,R30
; 000C 03DF 
; 000C 03E0     //    ( )
; 000C 03E1     if(result != -1)
	CPI  R17,255
	BREQ _0x18008D
; 000C 03E2     {
; 000C 03E3         //      -   
; 000C 03E4         if(result) CurModel.timer_mode &= ~0x01;
	CPI  R17,0
	BREQ _0x18008E
	__GETB1MN _CurModel,19
	ANDI R30,0xFE
	RJMP _0x1800A1
; 000C 03E5         //  -   
; 000C 03E6         else       CurModel.timer_mode |=  0x01;
_0x18008E:
	__GETB1MN _CurModel,19
	ORI  R30,1
_0x1800A1:
	__PUTB1MN _CurModel,19
; 000C 03E7     }
; 000C 03E8 }
_0x18008D:
	RJMP _0x2060006
;
;// ***       *********************************************************
;flash MenuButton TimerMenuButtons[] =
;{{"Set",   NULL, NULL},
; {"Mode",  TimerModeSet,  TimerModeGetStr},
; {"Sound", TimerSoundSet, TimerSoundGetStr}};
;
;// ***       ********************************************************
;void TimerMenu(char AddParam)
; 000C 03F2 {
_TimerMenu:
; 000C 03F3     //   
; 000C 03F4     MenuPad Pad = {"Timer", &Font_8x12, &Font_6x8, TimerMenuButtons, NumberOf(TimerMenuButtons), 0, NULL, NULL};
; 000C 03F5     //   
; 000C 03F6     MenuCycle(&Pad);
	SBIW R28,14
	LDI  R24,14
	LDI  R26,LOW(0)
	LDI  R27,HIGH(0)
	LDI  R30,LOW(_0x180090*2)
	LDI  R31,HIGH(_0x180090*2)
	CALL __INITLOCB
;	AddParam -> Y+14
;	Pad -> Y+0
	JMP  _0x2060004
; 000C 03F7 }
;
;// *****************************************************************************
;// ***    "Options"   ******************************************************
;// *****************************************************************************
;
;// ***        *******************************************
;char * OptionsSoundGetStr(char * Buf, char AddParam)
; 000C 03FF {
_OptionsSoundGetStr:
; 000C 0400     //     
; 000C 0401     sprintf(Buf, Settings.SoundFlag ? "ON" : "OFF");
;	*Buf -> Y+1
;	AddParam -> Y+0
	LDD  R30,Y+1
	LDD  R31,Y+1+1
	ST   -Y,R31
	ST   -Y,R30
	__GETB1MN _Settings,3
	CPI  R30,0
	BREQ _0x180091
	__POINTW1FN _0x180000,257
	RJMP _0x180092
_0x180091:
	__POINTW1FN _0x180000,253
_0x180092:
	RJMP _0x2060007
; 000C 0402     //     
; 000C 0403     return(Buf);
; 000C 0404 }
;// ***       *****************************************************
;void OptionsSoundSet(char AddParam)
; 000C 0407 {
_OptionsSoundSet:
; 000C 0408     //    
; 000C 0409     char result;
; 000C 040A     //    
; 000C 040B     flash char * Strings[2] = {"OFF", "ON"};
; 000C 040C 
; 000C 040D     //    
; 000C 040E     result = SelectBoxF((flash char **)Strings, 2, Settings.SoundFlag, NULL, "Sound:", NULL);
	SBIW R28,4
	LDI  R30,LOW(_0x180000*2+253)
	LDI  R31,HIGH(_0x180000*2+253)
	ST   Y,R30
	STD  Y+1,R31
	LDI  R30,LOW(_0x180000*2+257)
	LDI  R31,HIGH(_0x180000*2+257)
	STD  Y+2,R30
	STD  Y+2+1,R31
	ST   -Y,R17
;	AddParam -> Y+5
;	result -> R17
;	Strings -> Y+1
	MOVW R30,R28
	ADIW R30,1
	ST   -Y,R31
	ST   -Y,R30
	LDI  R30,LOW(2)
	ST   -Y,R30
	__GETB1MN _Settings,3
	ST   -Y,R30
	LDI  R30,LOW(0)
	LDI  R31,HIGH(0)
	ST   -Y,R31
	ST   -Y,R30
	__POINTW1FN _0x180000,529
	ST   -Y,R31
	ST   -Y,R30
	LDI  R30,LOW(0)
	LDI  R31,HIGH(0)
	ST   -Y,R31
	ST   -Y,R30
	CALL _SelectBoxF
	MOV  R17,R30
; 000C 040F 
; 000C 0410     //    ( )
; 000C 0411     if(result != -1)
	CPI  R17,255
	BREQ _0x180094
; 000C 0412     {
; 000C 0413         //   
; 000C 0414         Settings.SoundFlag = result;
	__PUTBMRN _Settings,3,17
; 000C 0415         //     EEPROM
; 000C 0416         TX_SaveSettings();
	CALL _TX_SaveSettings
; 000C 0417     }
; 000C 0418 }
_0x180094:
	RJMP _0x2060006
;
;// ***        ***************************************
;char * OptionsBacklightGetStr(char * Buf, char AddParam)
; 000C 041C {
_OptionsBacklightGetStr:
; 000C 041D     //     
; 000C 041E     sprintf(Buf, Settings.BacklightFlag ? "ON" : "OFF");
;	*Buf -> Y+1
;	AddParam -> Y+0
	LDD  R30,Y+1
	LDD  R31,Y+1+1
	ST   -Y,R31
	ST   -Y,R30
	__GETB1MN _Settings,4
	CPI  R30,0
	BREQ _0x180095
	__POINTW1FN _0x180000,257
	RJMP _0x180096
_0x180095:
	__POINTW1FN _0x180000,253
_0x180096:
_0x2060007:
	ST   -Y,R31
	ST   -Y,R30
	LDI  R24,0
	CALL _sprintf
	ADIW R28,4
; 000C 041F     //     
; 000C 0420     return(Buf);
_0x2060008:
	LDD  R30,Y+1
	LDD  R31,Y+1+1
	ADIW R28,3
	RET
; 000C 0421 }
;// ***      **************************************************
;void OptionsBacklightSet(char AddParam)
; 000C 0424 {
_OptionsBacklightSet:
; 000C 0425     //    
; 000C 0426     char result;
; 000C 0427     //    
; 000C 0428     flash char * Strings[2] = {"OFF", "ON"};
; 000C 0429 
; 000C 042A     //    
; 000C 042B     result = SelectBoxF((flash char **)Strings, 2, Settings.BacklightFlag, NULL, "Backlight:", NULL);
	SBIW R28,4
	LDI  R30,LOW(_0x180000*2+253)
	LDI  R31,HIGH(_0x180000*2+253)
	ST   Y,R30
	STD  Y+1,R31
	LDI  R30,LOW(_0x180000*2+257)
	LDI  R31,HIGH(_0x180000*2+257)
	STD  Y+2,R30
	STD  Y+2+1,R31
	ST   -Y,R17
;	AddParam -> Y+5
;	result -> R17
;	Strings -> Y+1
	MOVW R30,R28
	ADIW R30,1
	ST   -Y,R31
	ST   -Y,R30
	LDI  R30,LOW(2)
	ST   -Y,R30
	__GETB1MN _Settings,4
	ST   -Y,R30
	LDI  R30,LOW(0)
	LDI  R31,HIGH(0)
	ST   -Y,R31
	ST   -Y,R30
	__POINTW1FN _0x180000,557
	ST   -Y,R31
	ST   -Y,R30
	LDI  R30,LOW(0)
	LDI  R31,HIGH(0)
	ST   -Y,R31
	ST   -Y,R30
	CALL _SelectBoxF
	MOV  R17,R30
; 000C 042C 
; 000C 042D     //    ( )
; 000C 042E     if(result != -1)
	CPI  R17,255
	BREQ _0x180098
; 000C 042F     {
; 000C 0430         // /      
; 000C 0431         gfx_BackLight(result);
	ST   -Y,R17
	CALL _gfx_BackLight
; 000C 0432         //     EEPROM
; 000C 0433         TX_SaveSettings();
	CALL _TX_SaveSettings
; 000C 0434 
; 000C 0435     }
; 000C 0436 }
_0x180098:
_0x2060006:
	LDD  R17,Y+0
	ADIW R28,6
	RET
;
;// ***          *************************
;void Calibration_AP(char AddParam) {Calibration();}
; 000C 0439 void Calibration_AP(char AddParam) {Calibration();}
_Calibration_AP:
;	AddParam -> Y+0
	CALL _Calibration
	JMP  _0x2060005
;
;// ***       *********************************************************
;flash MenuButton OptionsMenuButtons[] =
;{{"Sound",       OptionsSoundSet,     OptionsSoundGetStr},
; {"Backlight",   OptionsBacklightSet, OptionsBacklightGetStr},
; {"Calibration", Calibration_AP,      NULL}};
;
;// ***       ********************************************************
;void OptionsMenu(char AddParam)
; 000C 0443 {
_OptionsMenu:
; 000C 0444     //   
; 000C 0445     MenuPad Pad = {"Options", &Font_8x12, &Font_6x8, OptionsMenuButtons, NumberOf(OptionsMenuButtons), 0, NULL, NULL};
; 000C 0446     //   
; 000C 0447     MenuCycle(&Pad);
	SBIW R28,14
	LDI  R24,14
	LDI  R26,LOW(0)
	LDI  R27,HIGH(0)
	LDI  R30,LOW(_0x180099*2)
	LDI  R31,HIGH(_0x180099*2)
	CALL __INITLOCB
;	AddParam -> Y+14
;	Pad -> Y+0
	JMP  _0x2060004
; 000C 0448 }
;
;// *****************************************************************************
;// ***       ********************************************************
;// *****************************************************************************
;
;// ***          *************************
;void IO_Test_AP(char AddParam) {IO_Test();}
; 000C 044F void IO_Test_AP(char AddParam) {IO_Test();}
_IO_Test_AP:
;	AddParam -> Y+0
	CALL _IO_Test
	JMP  _0x2060005
;void    Demo_AP(char AddParam) {Demo();}
; 000C 0450 void    Demo_AP(char AddParam) {Demo();}
_Demo_AP:
;	AddParam -> Y+0
	CALL _Demo
	JMP  _0x2060005
;
;// ***       *********************************************************
;flash MenuButton TestMenuButtons[] =
;{{"Model",    ModelMenu,    NULL},
; {"Controls", ControlsMenu, NULL},
; {"Channels", ChannelsMenu, NULL},
; {"Timer",    TimerMenu,    NULL},
; {"Options",  OptionsMenu,  NULL},
; {"IO Test",  IO_Test_AP,   NULL},
; {"Demo",     Demo_AP,      NULL},
; {"Chron",    ChronMenu,    NULL},
; {"Music",    MusicMenu,    NULL}};
;
;// ***       ********************************************************
;void MainMenu(void)
; 000C 0460 {
_MainMenu:
; 000C 0461     //   
; 000C 0462     MenuPad Pad = {"Main Menu", &Font_8x12, &Font_6x8, TestMenuButtons, NumberOf(TestMenuButtons), 0, NULL, NULL};
; 000C 0463     //   
; 000C 0464     MenuCycle(&Pad);
	SBIW R28,14
	LDI  R24,14
	LDI  R26,LOW(0)
	LDI  R27,HIGH(0)
	LDI  R30,LOW(_0x18009A*2)
	LDI  R31,HIGH(_0x18009A*2)
	CALL __INITLOCB
;	Pad -> Y+0
	MOVW R30,R28
	ST   -Y,R31
	ST   -Y,R30
	CALL _MenuCycle
; 000C 0465 }
	ADIW R28,14
	RET
;/*******************************************************************************
;*  Hardware.c
;*
;*  :  
;*
;*       Copyright (c) 2010 Nick Shl
;*           All rights reserved.
;*
;*
;*  :
;*
;*  Apr 06, 2010  Nick_Shl   
;*
;*/// ***************************************************************************
;
;// *****************************************************************************
;// ***       ***************************************************
;// *****************************************************************************
;#include <mega128.h>
	#ifndef __SLEEP_DEFINED__
	#define __SLEEP_DEFINED__
	.EQU __se_bit=0x20
	.EQU __sm_mask=0x1C
	.EQU __sm_powerdown=0x10
	.EQU __sm_powersave=0x18
	.EQU __sm_standby=0x14
	.EQU __sm_ext_standby=0x1C
	.EQU __sm_adc_noise_red=0x08
	.SET power_ctrl_reg=mcucr
	#endif
;#include <delay.h>
;
;// *****************************************************************************
;// ***       ********************************************
;// *****************************************************************************
;#include "Def.h"
;
;// *****************************************************************************
;// ***       ************************************************
;// *****************************************************************************
;void hwl_InitPorts(void)
; 000D 001F {

	.CSEG
_hwl_InitPorts:
; 000D 0020 // Port A initialization
; 000D 0021 //            76543210
; 000D 0022     PORTA = 0b00000110; // PORT - "1" enable pull-up if input
	LDI  R30,LOW(6)
	OUT  0x1B,R30
; 000D 0023     DDRA  = 0b11111001; // DDR  - "1" output, "0" input
	LDI  R30,LOW(249)
	OUT  0x1A,R30
; 000D 0024 
; 000D 0025 // Port B initialization
; 000D 0026 //            76543210
; 000D 0027     PORTB = 0b00001111; // PORT - "1" enable pull-up if input
	LDI  R30,LOW(15)
	OUT  0x18,R30
; 000D 0028     DDRB  = 0b11110000; // DDR  - "1" output, "0" input
	LDI  R30,LOW(240)
	OUT  0x17,R30
; 000D 0029 
; 000D 002A // Port C initialization
; 000D 002B //            76543210
; 000D 002C     PORTC = 0b00000000; // PORT - "1" enable pull-up if input
	LDI  R30,LOW(0)
	OUT  0x15,R30
; 000D 002D     DDRC  = 0b11111111; // DDR  - "1" output, "0" input
	LDI  R30,LOW(255)
	OUT  0x14,R30
; 000D 002E 
; 000D 002F // Port D initialization
; 000D 0030 //            76543210
; 000D 0031     PORTD = 0b11111111; // PORT - "1" enable pull-up if input
	OUT  0x12,R30
; 000D 0032     DDRD  = 0b00000000; // DDR  - "1" output, "0" input
	LDI  R30,LOW(0)
	OUT  0x11,R30
; 000D 0033 
; 000D 0034 // Port E initialization
; 000D 0035 //            76543210
; 000D 0036 //  PORTE = 0b11111111; // PORT - "1" enable pull-up if input
; 000D 0037     PORTE = 0b11111100; // FIX ME: FOR CHRON
	LDI  R30,LOW(252)
	OUT  0x3,R30
; 000D 0038     DDRE  = 0b00000000; // DDR  - "1" output, "0" input
	LDI  R30,LOW(0)
	OUT  0x2,R30
; 000D 0039 
; 000D 003A // Port F initialization
; 000D 003B //            76543210
; 000D 003C     PORTF = 0b00000000; // PORT - "1" enable pull-up if input
	STS  98,R30
; 000D 003D     DDRF  = 0b00000000; // DDR  - "1" output, "0" input
	STS  97,R30
; 000D 003E 
; 000D 003F // Port G initialization
; 000D 0040 //            76543210
; 000D 0041     PORTG = 0b00000011; // PORT - "1" enable pull-up if input
	LDI  R30,LOW(3)
	STS  101,R30
; 000D 0042     DDRG  = 0b11111100; // DDR  - "1" output, "0" input}
	LDI  R30,LOW(252)
	STS  100,R30
; 000D 0043 }
	RET
;
;// *****************************************************************************
;// ***       **********************************************
;// *****************************************************************************
;void hwl_InitTimers(void)
; 000D 0049 {
_hwl_InitTimers:
; 000D 004A // Timer/Counter 0 initialization
; 000D 004B // Clock source: System Clock
; 000D 004C // Clock value: 250,000 kHz
; 000D 004D // Mode: Fast PWM top=FFh
; 000D 004E // OC0 output: Non-Inverted PWM
; 000D 004F     ASSR=0x00;
	LDI  R30,LOW(0)
	OUT  0x30,R30
; 000D 0050     TCCR0=0x6C;
	LDI  R30,LOW(108)
	OUT  0x33,R30
; 000D 0051     TCNT0=0x00;
	LDI  R30,LOW(0)
	OUT  0x32,R30
; 000D 0052     OCR0=0x00;
	OUT  0x31,R30
; 000D 0053 
; 000D 0054 // Timer/Counter 1 initialization
; 000D 0055 // Clock source: System Clock
; 000D 0056 // Clock value: System Clock/8 (1500,000 kHz at 12MHz)
; 000D 0057 // Mode: Fast PWM top=ICR1
; 000D 0058 // OC1A output: Non-Inv.
; 000D 0059 // OC1B output: Discon.
; 000D 005A // OC1C output: Discon.
; 000D 005B // Noise Canceler: Off
; 000D 005C // Input Capture on Falling Edge
; 000D 005D // Timer 1 Overflow Interrupt: Off
; 000D 005E // Input Capture Interrupt: Off
; 000D 005F // Compare A Match Interrupt: Off
; 000D 0060 // Compare B Match Interrupt: Off
; 000D 0061 // Compare C Match Interrupt: Off
; 000D 0062     TCCR1A = 0x82;// 0b 1000 0010
	LDI  R30,LOW(130)
	OUT  0x2F,R30
; 000D 0063     TCCR1B = 0x1A;// 0b 0001 1010
	LDI  R30,LOW(26)
	OUT  0x2E,R30
; 000D 0064     TCNT1H = 0x00;
	LDI  R30,LOW(0)
	OUT  0x2D,R30
; 000D 0065     TCNT1L = 0x00;
	OUT  0x2C,R30
; 000D 0066 
; 000D 0067     ICR1H  = 0x17;//  \ 
	LDI  R30,LOW(23)
	OUT  0x27,R30
; 000D 0068     ICR1L  = 0x70;//  / 
	LDI  R30,LOW(112)
	OUT  0x26,R30
; 000D 0069 
; 000D 006A     OCR1AH = TimerClockPerSec(0.0003) >> 8;  //  \ 
	LDI  R30,LOW(2)
	OUT  0x2B,R30
; 000D 006B     OCR1AL = TimerClockPerSec(0.0003) & 0xFF;//  / 
	LDI  R30,LOW(88)
	OUT  0x2A,R30
; 000D 006C 
; 000D 006D     OCR1BH = 0x00;
	LDI  R30,LOW(0)
	OUT  0x29,R30
; 000D 006E     OCR1BL = 0x00;
	OUT  0x28,R30
; 000D 006F     OCR1CH = 0x00;
	STS  121,R30
; 000D 0070     OCR1CL = 0x00;
	STS  120,R30
; 000D 0071 
; 000D 0072 // Timer/Counter 2 initialization
; 000D 0073 // Clock source: System Clock
; 000D 0074 // Clock value: Timer 2 Stopped
; 000D 0075 // Mode: Normal top=FFh
; 000D 0076 // OC2 output: Disconnected
; 000D 0077     TCCR2 = 0x00;
	OUT  0x25,R30
; 000D 0078     TCNT2 = 0x00;
	OUT  0x24,R30
; 000D 0079     OCR2  = 0x00;
	OUT  0x23,R30
; 000D 007A 
; 000D 007B // Timer/Counter 3 initialization
; 000D 007C // Clock source: System Clock
; 000D 007D // Clock value: System Clock/8
; 000D 007E // Mode: CTC top = OCR3A
; 000D 007F // Noise Canceler: Off
; 000D 0080 // Input Capture on Falling Edge
; 000D 0081 // OC3A output: Discon.
; 000D 0082 // OC3B output: Discon.
; 000D 0083 // OC3C output: Discon.
; 000D 0084 // Timer 3 Overflow Interrupt: Off
; 000D 0085 // Input Capture Interrupt: Off
; 000D 0086 // Compare A Match Interrupt: On
; 000D 0087 // Compare B Match Interrupt: Off
; 000D 0088 // Compare C Match Interrupt: Off
; 000D 0089     TCCR3A = 0x00;
	STS  139,R30
; 000D 008A     TCCR3B = 0x0A;
	LDI  R30,LOW(10)
	STS  138,R30
; 000D 008B     TCNT3H = 0x00;
	LDI  R30,LOW(0)
	STS  137,R30
; 000D 008C     TCNT3L = 0x00;
	STS  136,R30
; 000D 008D     ICR3H  = 0x00;
	STS  129,R30
; 000D 008E     ICR3L  = 0x00;
	STS  128,R30
; 000D 008F #ifdef DEBUG
; 000D 0090     OCR3AH = MainTimerClockPerSec(0.001) >> 8;
; 000D 0091     OCR3AL = MainTimerClockPerSec(0.001) & 0xFF;
; 000D 0092 #else
; 000D 0093     OCR3AH = TimerClockPerSec(TASK_TICK_TIME / 1000.0) >> 8;
	LDI  R30,LOW(156)
	STS  135,R30
; 000D 0094     OCR3AL = TimerClockPerSec(TASK_TICK_TIME / 1000.0) & 0xFF;
	LDI  R30,LOW(64)
	STS  134,R30
; 000D 0095 #endif
; 000D 0096     OCR3BH = 0x00;
	LDI  R30,LOW(0)
	STS  133,R30
; 000D 0097     OCR3BL = 0x00;
	STS  132,R30
; 000D 0098     OCR3CH = 0x00;
	STS  131,R30
; 000D 0099     OCR3CL = 0x00;
	STS  130,R30
; 000D 009A }
	RET
;
;// *****************************************************************************
;// ***    USART0   ************************************************
;// *****************************************************************************
;void hwl_InitUSART0(long BaudRate)
; 000D 00A0 {
_hwl_InitUSART0:
; 000D 00A1 // USART0 initialization
; 000D 00A2 // Communication Parameters: 8 Data, 1 Stop, No Parity
; 000D 00A3 // USART0 Receiver: On
; 000D 00A4 // USART0 Transmitter: On
; 000D 00A5 // USART0 Mode: Asynchronous
; 000D 00A6 // USART0 Baud Rate: BaudRate
; 000D 00A7     UCSR0A = 0x02;
;	BaudRate -> Y+0
	LDI  R30,LOW(2)
	OUT  0xB,R30
; 000D 00A8     UCSR0B = 0xD8;
	LDI  R30,LOW(216)
	OUT  0xA,R30
; 000D 00A9     UCSR0C = 0x06;
	LDI  R30,LOW(6)
	STS  149,R30
; 000D 00AA     UBRR0H = (unsigned char)((AVR_Clock_Freq/(BaudRate*8L)-1) >> 8);
	CALL __GETD1S0
	__GETD2N 0x8
	CALL __MULD12
	__GETD2N 0xF42400
	CALL __DIVD21
	__SUBD1N 1
	MOVW R26,R30
	MOVW R24,R22
	LDI  R30,LOW(8)
	CALL __ASRD12
	STS  144,R30
; 000D 00AB     UBRR0L = (unsigned char)((AVR_Clock_Freq/(BaudRate*8L)-1) & 0xFF);
	CALL __GETD1S0
	__GETD2N 0x8
	CALL __MULD12
	__GETD2N 0xF42400
	CALL __DIVD21
	__SUBD1N 1
	OUT  0x9,R30
; 000D 00AC }
	ADIW R28,4
	RET
;
;// *****************************************************************************
;// ***        **************************************
;// *****************************************************************************
;void hwl_InitMisc(void)
; 000D 00B2 {
_hwl_InitMisc:
; 000D 00B3 // External Interrupt(s) initialization
; 000D 00B4 // INT0: Off
; 000D 00B5 // INT1: Off
; 000D 00B6 // INT2: Off
; 000D 00B7 // INT3: Off
; 000D 00B8 // INT4: Off
; 000D 00B9 // INT5: Off
; 000D 00BA // INT6: Off
; 000D 00BB // INT7: Off
; 000D 00BC     EICRA = 0x00;
	LDI  R30,LOW(0)
	STS  106,R30
; 000D 00BD     EICRB = 0x00;
	OUT  0x3A,R30
; 000D 00BE     EIMSK = 0x00;
	OUT  0x39,R30
; 000D 00BF 
; 000D 00C0 // Timer(s)/Counter(s) Interrupt(s) initialization
; 000D 00C1     TIMSK  = 0x00;
	OUT  0x37,R30
; 000D 00C2     ETIMSK = 0x00;
	STS  125,R30
; 000D 00C3 
; 000D 00C4 // Analog Comparator initialization
; 000D 00C5 // Analog Comparator: Off
; 000D 00C6 // Analog Comparator Input Capture by Timer/Counter 1: Off
; 000D 00C7     ACSR  = 0x80;
	LDI  R30,LOW(128)
	OUT  0x8,R30
; 000D 00C8     SFIOR = 0x00;
	LDI  R30,LOW(0)
	OUT  0x20,R30
; 000D 00C9 
; 000D 00CA // ADC initialization
; 000D 00CB // ADC Voltage Reference: AREF pin
; 000D 00CC     ADMUX  = 0x00;
	OUT  0x7,R30
; 000D 00CD     ADCSRA = 0x87; // ADC Clock frequency: Clock / 128 (125,000 kHz at 16 MHz)
	LDI  R30,LOW(135)
	OUT  0x6,R30
; 000D 00CE //  ADCSRA = 0x86; // ADC Clock frequency: Clock / 64  (187,500 kHz at 12 MHz)
; 000D 00CF }
	RET
;
;// *****************************************************************************
;// ***          **********************************
;// *****************************************************************************
;inline void Sleep(void)
; 000D 00D5 {
_Sleep:
; 000D 00D6     #asm
; 000D 00D7         in   r30, mcucr      //  MCU Control Register
        in   r30, mcucr      //  MCU Control Register
; 000D 00D8         cbr  r30, __sm_mask  //   SM0-SM2 (000 - Idle)
        cbr  r30, __sm_mask  //   SM0-SM2 (000 - Idle)
; 000D 00D9         sbr  r30, __se_bit   //  SleepEnable
        sbr  r30, __se_bit   //  SleepEnable
; 000D 00DA         out  mcucr, r30      //  MCU Control Register
        out  mcucr, r30      //  MCU Control Register
; 000D 00DB         sleep                // 
        sleep                // 
; 000D 00DC         in   r30, mcucr      //  MCU Control Register (  )
        in   r30, mcucr      //  MCU Control Register (  )
; 000D 00DD         cbr  r30, __se_bit   //   SleepEnable -   
        cbr  r30, __se_bit   //   SleepEnable -   
; 000D 00DE         out  mcucr, r30      //  MCU Control Register
        out  mcucr, r30      //  MCU Control Register
; 000D 00DF     #endasm
; 000D 00E0 }
	RET
;
;// *****************************************************************************
;// ***       **************************************************
;// *****************************************************************************
;//     .   
;//      -      
;// .       enum    
;//  AD[].   .
;unsigned int read_adc(unsigned char adc_input)
; 000D 00EA {
_read_adc:
; 000D 00EB     ADCSRA |= 0x10;              // ADIF is cleared by writing a logical one to the flag
;	adc_input -> Y+0
	SBI  0x6,4
; 000D 00EC     ADMUX = adc_input;           // Set ADC channel
	LD   R30,Y
	OUT  0x7,R30
; 000D 00ED     delay_us(125);               // 125 us to stabilize to the new value
	__DELAY_USW 500
; 000D 00EE     ADCSRA |= 0x40;              // Bit6 ADSC - Start the AD conversion
	SBI  0x6,6
; 000D 00EF //    while(ADCSRA & 0x40);      // Wait for the AD conversion to complete (cleared)
; 000D 00F0     while((ADCSRA & 0x10) == 0); // Wait for the AD conversion to complete (ADIF is set)
_0x1A0003:
	SBIS 0x6,4
	RJMP _0x1A0003
; 000D 00F1     return ADCW;
	IN   R30,0x4
	IN   R31,0x4+1
_0x2060005:
	ADIW R28,1
	RET
; 000D 00F2 }
;
;#if 0
;//   .  ,      ,
;//   
;volatile unsigned char ADC_Busy;
;//     
;unsigned int ADC_Data;
;// *****************************************************************************
;// ***       ******************************************************
;// *****************************************************************************
;interrupt [ADC_INT] void adc_isr(void)
;{
;    ADC_Data = ADCW; // Read the AD conversion result
;    ADC_Busy = 0;    //    
;}
;// *****************************************************************************
;// ***       **************************************************
;// *****************************************************************************
;unsigned int read_adc(unsigned char adc_input)
;{
;    ADC_Busy = 1;                //    
;    ADMUX = adc_input;           // Set ADC channel
;    delay_us(125);               // 125 us to stabilize to the new value
;
;    //     "ADC Noise Reduction"   - 
;    //  .       .
;    #asm
;        in   r30,mcucr
;        cbr  r30,__sm_mask
;        sbr  r30,__se_bit | __sm_adc_noise_red
;        out  mcucr,r30
;        sleep
;        cbr  r30,__se_bit
;        out  mcucr,r30
;    #endasm
;    //   ,      ,   
;    while(ADC_Busy); //      - 
;    return ADC_Data;
;}
;#endif
;/*******************************************************************************
;*  Demo.c
;*
;*  : 
;*
;*       Copyright (c) 2007-2009 Nick Shl, focus
;*           All rights reserved.
;*
;*
;*  :
;*
;*  Mar 23, 2009  Nick_Shl   
;*
;*/// ***************************************************************************
;
;// *****************************************************************************
;// ***       ***************************************************
;// *****************************************************************************
;#include <mega128.h>
	#ifndef __SLEEP_DEFINED__
	#define __SLEEP_DEFINED__
	.EQU __se_bit=0x20
	.EQU __sm_mask=0x1C
	.EQU __sm_powerdown=0x10
	.EQU __sm_powersave=0x18
	.EQU __sm_standby=0x14
	.EQU __sm_ext_standby=0x1C
	.EQU __sm_adc_noise_red=0x08
	.SET power_ctrl_reg=mcucr
	#endif
;#include <delay.h>
;#include <stdio.h>
;
;// *****************************************************************************
;// ***       ********************************************
;// *****************************************************************************
;#include "Def.h"
;#include "Hardware.h"
;#include "Coder.h"
;#include "Graphic.h"
;#include "Sound.h"
;#include "Variables.h"
;#include "UI_Engine.h"
;
;// *****************************************************************************
;// ***       ***********************************************
;// *****************************************************************************
;flash unsigned int SuperMarioThemeTable[]={
;0x2932, 0x0001, 0x2932, 0x0001, 0x0002, 0x0001, 0x2932, 0x0001, 0x0002, 0x0001, 0x20B2, 0x0001, 0x2932, 0x0001, 0x0002, 0x0001,
;0x30F2, 0x0001, 0x0002, 0x0001, 0x0004, 0x0001, 0x1872, 0x0001, 0x0002, 0x0001, 0x0004, 0x0001, 0x20B2, 0x0001, 0x0002, 0x0001,
;0x0002, 0x0001, 0x1872, 0x0001, 0x0004, 0x0001, 0x1492, 0x0001, 0x0002, 0x0001, 0x0002, 0x0001, 0x1B82, 0x0001, 0x0002, 0x0001,
;0x1ED2, 0x0001, 0x0002, 0x0001, 0x1D22, 0x0001, 0x1B82, 0x0001, 0x0002, 0x0001, 0x1872, 0x0001, 0x2932, 0x0001, 0x30F2, 0x0001,
;0x3702, 0x0001, 0x0002, 0x0001, 0x2BA2, 0x0001, 0x30F2, 0x0001, 0x0002, 0x0001, 0x2932, 0x0001, 0x0002, 0x0001, 0x20B2, 0x0001,
;0x24B2, 0x0001, 0x1ED2, 0x0001, 0x0004, 0x0001, 0x20B2, 0x0001, 0x0002, 0x0001, 0x0002, 0x0001, 0x1872, 0x0001, 0x0004, 0x0001,
;0x1492, 0x0001, 0x0002, 0x0001, 0x0002, 0x0001, 0x1B82, 0x0001, 0x0002, 0x0001, 0x1ED2, 0x0001, 0x0002, 0x0001, 0x1D22, 0x0001,
;0x1B82, 0x0001, 0x0002, 0x0001, 0x1872, 0x0001, 0x2932, 0x0001, 0x30F2, 0x0001, 0x3702, 0x0001, 0x0002, 0x0001, 0x2BA2, 0x0001,
;0x30F2, 0x0001, 0x0002, 0x0001, 0x2932, 0x0001, 0x0002, 0x0001, 0x20B2, 0x0001, 0x24B2, 0x0001, 0x1ED2, 0x0001, 0x0004, 0x0001,
;0x0004, 0x0001, 0x30F2, 0x0001, 0x2E42, 0x0001, 0x2BA2, 0x0001, 0x26E2, 0x0001, 0x0002, 0x0001, 0x2932, 0x0001, 0x0002, 0x0001,
;0x19F2, 0x0001, 0x1B82, 0x0001, 0x20B2, 0x0001, 0x0002, 0x0001, 0x1B82, 0x0001, 0x20B2, 0x0001, 0x24B2, 0x0001, 0x0004, 0x0001,
;0x30F2, 0x0001, 0x2E42, 0x0001, 0x2BA2, 0x0001, 0x26E2, 0x0001, 0x0002, 0x0001, 0x2932, 0x0001, 0x0002, 0x0001, 0x4162, 0x0001,
;0x0002, 0x0001, 0x4162, 0x0001, 0x4162, 0x0001, 0x0002, 0x0001, 0x0004, 0x0001, 0x0004, 0x0001, 0x30F2, 0x0001, 0x2E42, 0x0001,
;0x2BA2, 0x0001, 0x26E2, 0x0001, 0x0002, 0x0001, 0x2932, 0x0001, 0x0002, 0x0001, 0x19F2, 0x0001, 0x1B82, 0x0001, 0x20B2, 0x0001,
;0x0002, 0x0001, 0x1B82, 0x0001, 0x20B2, 0x0001, 0x24B2, 0x0001, 0x0004, 0x0001, 0x26E2, 0x0001, 0x0002, 0x0001, 0x0002, 0x0001,
;0x24B2, 0x0001, 0x0004, 0x0001, 0x20B2, 0x0001, 0x0002, 0x0001, 0x0004, 0x0001, 0x0009, 0x0001, 0x20B2, 0x0001, 0x20B2, 0x0001,
;0x0002, 0x0001, 0x20B2, 0x0001, 0x0002, 0x0001, 0x20B2, 0x0001, 0x24B2, 0x0001, 0x0002, 0x0001, 0x2932, 0x0001, 0x20B2, 0x0001,
;0x0002, 0x0001, 0x1B82, 0x0001, 0x1872, 0x0001, 0x0002, 0x0001, 0x0004, 0x0001, 0x20B2, 0x0001, 0x20B2, 0x0001, 0x0002, 0x0001,
;0x20B2, 0x0001, 0x0002, 0x0001, 0x20B2, 0x0001, 0x24B2, 0x0001, 0x2932, 0x0001, 0x0009, 0x0001, 0x0009, 0x0001, 0x20B2, 0x0001,
;0x20B2, 0x0001, 0x0002, 0x0001, 0x20B2, 0x0001, 0x0002, 0x0001, 0x20B2, 0x0001, 0x24B2, 0x0001, 0x0002, 0x0001, 0x2932, 0x0001,
;0x20B2, 0x0001, 0x0002, 0x0001, 0x1B82, 0x0001, 0x1872, 0x0001, 0x0002, 0x0001, 0x0004, 0x0001, 0x2932, 0x0001, 0x2932, 0x0001,
;0x0002, 0x0001, 0x2932, 0x0001, 0x0002, 0x0001, 0x20B2, 0x0001, 0x2932, 0x0001, 0x0002, 0x0001, 0x30F2, 0x0001, 0x0002, 0x0001,
;0x0004, 0x0001, 0x1872, 0x0001, 0x0002, 0x0001, 0x0004, 0x0001, 0x20B2, 0x0001, 0x0002, 0x0001, 0x0002, 0x0001, 0x1872, 0x0001,
;0x0004, 0x0001, 0x1492, 0x0001, 0x0002, 0x0001, 0x0002, 0x0001, 0x1B82, 0x0001, 0x0002, 0x0001, 0x1ED2, 0x0001, 0x0002, 0x0001,
;0x1D22, 0x0001, 0x1B82, 0x0001, 0x0002, 0x0001, 0x1872, 0x0001, 0x2932, 0x0001, 0x30F2, 0x0001, 0x3702, 0x0001, 0x0002, 0x0001,
;0x2BA2, 0x0001, 0x30F2, 0x0001, 0x0002, 0x0001, 0x2932, 0x0001, 0x0002, 0x0001, 0x20B2, 0x0001, 0x24B2, 0x0001, 0x1ED2, 0x0001,
;0x0004, 0x0001, 0x20B2, 0x0001, 0x0002, 0x0001, 0x0002, 0x0001, 0x1872, 0x0001, 0x0004, 0x0001, 0x1492, 0x0001, 0x0002, 0x0001,
;0x0002, 0x0001, 0x1B82, 0x0001, 0x0002, 0x0001, 0x1ED2, 0x0001, 0x0002, 0x0001, 0x1D22, 0x0001, 0x1B82, 0x0001, 0x0002, 0x0001,
;0x1872, 0x0001, 0x2932, 0x0001, 0x30F2, 0x0001, 0x3702, 0x0001, 0x0002, 0x0001, 0x2BA2, 0x0001, 0x30F2, 0x0001, 0x0002, 0x0001,
;0x2932, 0x0001, 0x0002, 0x0001, 0x20B2, 0x0001, 0x24B2, 0x0001, 0x1ED2, 0x0001, 0x0004, 0x0001, 0x2932, 0x0001, 0x20B2, 0x0001,
;0x0002, 0x0001, 0x1872, 0x0001, 0x0004, 0x0001, 0x19F2, 0x0001, 0x0002, 0x0001, 0x1B82, 0x0001, 0x2BA2, 0x0001, 0x0002, 0x0001,
;0x2BA2, 0x0001, 0x1B82, 0x0001, 0x0002, 0x0001, 0x0004, 0x0001, 0x1ED3, 0x0001, 0x3703, 0x0001, 0x3703, 0x0001, 0x3703, 0x0001,
;0x30F3, 0x0001, 0x2BA3, 0x0001, 0x2932, 0x0001, 0x20B2, 0x0001, 0x0002, 0x0001, 0x1B82, 0x0001, 0x1872, 0x0001, 0x0002, 0x0001,
;0x0004, 0x0001, 0x2932, 0x0001, 0x20B2, 0x0001, 0x0002, 0x0001, 0x1872, 0x0001, 0x0004, 0x0001, 0x19F2, 0x0001, 0x0002, 0x0001,
;0x1B82, 0x0001, 0x2BA2, 0x0001, 0x0002, 0x0001, 0x2BA2, 0x0001, 0x1B82, 0x0001, 0x0002, 0x0001, 0x0004, 0x0001, 0x1ED2, 0x0001,
;0x2BA2, 0x0001, 0x0002, 0x0001, 0x2BA2, 0x0001, 0x2BA3, 0x0001, 0x2933, 0x0001, 0x24B3, 0x0001, 0x20B2, 0x0001, 0x1492, 0x0001,
;0x0002, 0x0001, 0x1492, 0x0001, 0x1052, 0x0001, 0x0002, 0x0001, 0x0004, 0x0001, 0x0001};
;
;flash unsigned int UnderwolrdThemeTable[]={
;0x1062, 0x0001, 0x20B2, 0x0001, 0x0DC2, 0x0001, 0x1B82, 0x0001, 0x0E92, 0x0001, 0x1D22, 0x0001, 0x0004, 0x0001, 0x0008, 0x0001,
;0x1062, 0x0001, 0x20B2, 0x0001, 0x0DC2, 0x0001, 0x1B82, 0x0001, 0x0E92, 0x0001, 0x1D22, 0x0001, 0x0004, 0x0001, 0x0008, 0x0001,
;0x0AF2, 0x0001, 0x15D2, 0x0001, 0x0932, 0x0001, 0x1262, 0x0001, 0x09C2, 0x0001, 0x1372, 0x0001, 0x0004, 0x0001, 0x0008, 0x0001,
;0x0AF2, 0x0001, 0x15D2, 0x0001, 0x0932, 0x0001, 0x1262, 0x0001, 0x09C2, 0x0001, 0x1372, 0x0001, 0x0004, 0x0001, 0x0004, 0x0001,
;0x1371, 0x0001, 0x1151, 0x0001, 0x1261, 0x0001, 0x1154, 0x0001, 0x1374, 0x0001, 0x1374, 0x0001, 0x0D04, 0x0001, 0x0C44, 0x0001,
;0x1154, 0x0001, 0x1061, 0x0001, 0x1721, 0x0001, 0x15D1, 0x0001, 0x0A51, 0x0001, 0x1D21, 0x0001, 0x1B81, 0x0001, 0x19F2, 0x0001,
;0x1372, 0x0001, 0x0F72, 0x0001, 0x0E92, 0x0001, 0x0DC2, 0x0001, 0x0D02, 0x0001, 0x0008, 0x0001, 0x0008, 0x0001, 0x0008, 0x0001};
;
;
;// *****************************************************************************
;// ***      ****************************************************************
;// *****************************************************************************
;void PlayMusic(char AddParam)
; 000E 005A {

	.CSEG
_PlayMusic:
; 000E 005B     flash char * name;
; 000E 005C     flash unsigned int * MusicTable;
; 000E 005D     unsigned int MusicTableSize;
; 000E 005E 
; 000E 005F     if(AddParam == 0)
	CALL __SAVELOCR6
;	AddParam -> Y+6
;	*name -> R16,R17
;	*MusicTable -> R18,R19
;	MusicTableSize -> R20,R21
	LDD  R30,Y+6
	CPI  R30,0
	BRNE _0x1C0003
; 000E 0060     {
; 000E 0061         MusicTable = SuperMarioThemeTable;
	LDI  R30,LOW(_SuperMarioThemeTable*2)
	LDI  R31,HIGH(_SuperMarioThemeTable*2)
	MOVW R18,R30
; 000E 0062         MusicTableSize = NumberOf(SuperMarioThemeTable);
	__GETWRN 20,21,587
; 000E 0063         name = "Super Mario Theme";
	__POINTW1FN _0x1C0000,0
	RJMP _0x1C000C
; 000E 0064     }
; 000E 0065     else
_0x1C0003:
; 000E 0066     {
; 000E 0067         MusicTable = UnderwolrdThemeTable;
	LDI  R30,LOW(_UnderwolrdThemeTable*2)
	LDI  R31,HIGH(_UnderwolrdThemeTable*2)
	MOVW R18,R30
; 000E 0068         MusicTableSize = NumberOf(UnderwolrdThemeTable);
	__GETWRN 20,21,112
; 000E 0069         name = "Underwolrd Theme";
	__POINTW1FN _0x1C0000,18
_0x1C000C:
	MOVW R16,R30
; 000E 006A     }
; 000E 006B 
; 000E 006C     Settings.SoundFlag = ON;
	LDI  R30,LOW(1)
	__PUTB1MN _Settings,3
; 000E 006D 
; 000E 006E     gfx_ClearBuf();
	CALL _gfx_ClearBuf
; 000E 006F     gfx_SetXY((WidthS - Font_8x12.W*8) >> 1, (HeightS - Font_8x12.H) >> 1);
	LDS  R30,_Font_8x12
	LSL  R30
	LSL  R30
	LSL  R30
	LDI  R26,LOW(128)
	SUB  R26,R30
	MOV  R30,R26
	LSR  R30
	ST   -Y,R30
	__GETB1MN _Font_8x12,1
	LDI  R26,LOW(64)
	SUB  R26,R30
	MOV  R30,R26
	LSR  R30
	ST   -Y,R30
	CALL _gfx_SetXY
; 000E 0070     gfx_PutFlashStr(name, 0xFF, &Font_8x12);
	ST   -Y,R17
	ST   -Y,R16
	LDI  R30,LOW(255)
	ST   -Y,R30
	LDI  R30,LOW(_Font_8x12)
	LDI  R31,HIGH(_Font_8x12)
	ST   -Y,R31
	ST   -Y,R30
	CALL _gfx_PutFlashStr
; 000E 0071 
; 000E 0072     PlaySound(MusicTable, MusicTableSize);
	ST   -Y,R19
	ST   -Y,R18
	ST   -Y,R21
	ST   -Y,R20
	CALL _PlaySound
; 000E 0073 
; 000E 0074     while(IsSoundPlayed() == TRUE)
_0x1C0005:
	CALL _IsSoundPlayed
	CPI  R30,LOW(0x1)
	BRNE _0x1C0007
; 000E 0075     {
; 000E 0076         if(HB_UP || HB_DOWN || HB_LEFT || HB_RIGHT || HB_ENTER) break;
	SBIS 0x10,3
	RJMP _0x1C0009
	SBIS 0x10,1
	RJMP _0x1C0009
	SBIS 0x10,2
	RJMP _0x1C0009
	SBIS 0x10,0
	RJMP _0x1C0009
	SBIC 0x10,5
	RJMP _0x1C0008
_0x1C0009:
	RJMP _0x1C0007
; 000E 0077     }
_0x1C0008:
	RJMP _0x1C0005
_0x1C0007:
; 000E 0078 
; 000E 0079     StopSound();
	CALL _StopSound
; 000E 007A 
; 000E 007B     gfx_ClearBuf();
	CALL _gfx_ClearBuf
; 000E 007C }
	CALL __LOADLOCR6
	ADIW R28,7
	RET
;
;// *****************************************************************************
;// ***    "Music"   ********************************************************
;// *****************************************************************************
;
;// ***       *********************************************************
;flash MenuButton MusicMenuButtons[] =
;{{"Start Mario Theme",      PlayMusic, NULL, 0},
; {"Start Underworld Theme", PlayMusic, NULL, 1}};
;
;// ***       ********************************************************
;void MusicMenu(char AddParam)
; 000E 0089 {
_MusicMenu:
; 000E 008A     //   
; 000E 008B     MenuPad Pad = {"Music", &Font_8x12, &Font_6x8, MusicMenuButtons, NumberOf(MusicMenuButtons), 0, NULL, NULL};
; 000E 008C     //   
; 000E 008D     MenuCycle(&Pad);
	SBIW R28,14
	LDI  R24,14
	LDI  R26,LOW(0)
	LDI  R27,HIGH(0)
	LDI  R30,LOW(_0x1C000B*2)
	LDI  R31,HIGH(_0x1C000B*2)
	CALL __INITLOCB
;	AddParam -> Y+14
;	Pad -> Y+0
_0x2060004:
	MOVW R30,R28
	ST   -Y,R31
	ST   -Y,R30
	CALL _MenuCycle
; 000E 008E }
	ADIW R28,15
	RET
	#ifndef __SLEEP_DEFINED__
	#define __SLEEP_DEFINED__
	.EQU __se_bit=0x20
	.EQU __sm_mask=0x1C
	.EQU __sm_powerdown=0x10
	.EQU __sm_powersave=0x18
	.EQU __sm_standby=0x14
	.EQU __sm_ext_standby=0x1C
	.EQU __sm_adc_noise_red=0x08
	.SET power_ctrl_reg=mcucr
	#endif

	.CSEG
_put_buff_G100:
	ST   -Y,R17
	ST   -Y,R16
	LDD  R26,Y+2
	LDD  R27,Y+2+1
	ADIW R26,2
	CALL __GETW1P
	SBIW R30,0
	BREQ _0x2000010
	LDD  R26,Y+2
	LDD  R27,Y+2+1
	ADIW R26,4
	CALL __GETW1P
	MOVW R16,R30
	SBIW R30,0
	BREQ _0x2000012
	__CPWRN 16,17,2
	BRLO _0x2000013
	MOVW R30,R16
	SBIW R30,1
	MOVW R16,R30
	__PUTW1SNS 2,4
_0x2000012:
	LDD  R26,Y+2
	LDD  R27,Y+2+1
	ADIW R26,2
	LD   R30,X+
	LD   R31,X+
	ADIW R30,1
	ST   -X,R31
	ST   -X,R30
	SBIW R30,1
	LDD  R26,Y+4
	STD  Z+0,R26
	LDD  R26,Y+2
	LDD  R27,Y+2+1
	CALL __GETW1P
	TST  R31
	BRMI _0x2000014
	LD   R30,X+
	LD   R31,X+
	ADIW R30,1
	ST   -X,R31
	ST   -X,R30
_0x2000014:
_0x2000013:
	RJMP _0x2000015
_0x2000010:
	LDD  R26,Y+2
	LDD  R27,Y+2+1
	LDI  R30,LOW(65535)
	LDI  R31,HIGH(65535)
	ST   X+,R30
	ST   X,R31
_0x2000015:
	LDD  R17,Y+1
	LDD  R16,Y+0
	RJMP _0x2060001
__print_G100:
	SBIW R28,6
	CALL __SAVELOCR6
	LDI  R17,0
	LDD  R26,Y+12
	LDD  R27,Y+12+1
	LDI  R30,LOW(0)
	LDI  R31,HIGH(0)
	ST   X+,R30
	ST   X,R31
_0x2000016:
	LDD  R30,Y+18
	LDD  R31,Y+18+1
	ADIW R30,1
	STD  Y+18,R30
	STD  Y+18+1,R31
	SBIW R30,1
	LPM  R30,Z
	MOV  R18,R30
	CPI  R30,0
	BRNE PC+3
	JMP _0x2000018
	MOV  R30,R17
	CPI  R30,0
	BRNE _0x200001C
	CPI  R18,37
	BRNE _0x200001D
	LDI  R17,LOW(1)
	RJMP _0x200001E
_0x200001D:
	ST   -Y,R18
	LDD  R30,Y+13
	LDD  R31,Y+13+1
	ST   -Y,R31
	ST   -Y,R30
	LDD  R30,Y+17
	LDD  R31,Y+17+1
	ICALL
_0x200001E:
	RJMP _0x200001B
_0x200001C:
	CPI  R30,LOW(0x1)
	BRNE _0x200001F
	CPI  R18,37
	BRNE _0x2000020
	ST   -Y,R18
	LDD  R30,Y+13
	LDD  R31,Y+13+1
	ST   -Y,R31
	ST   -Y,R30
	LDD  R30,Y+17
	LDD  R31,Y+17+1
	ICALL
	RJMP _0x20000C9
_0x2000020:
	LDI  R17,LOW(2)
	LDI  R20,LOW(0)
	LDI  R16,LOW(0)
	CPI  R18,45
	BRNE _0x2000021
	LDI  R16,LOW(1)
	RJMP _0x200001B
_0x2000021:
	CPI  R18,43
	BRNE _0x2000022
	LDI  R20,LOW(43)
	RJMP _0x200001B
_0x2000022:
	CPI  R18,32
	BRNE _0x2000023
	LDI  R20,LOW(32)
	RJMP _0x200001B
_0x2000023:
	RJMP _0x2000024
_0x200001F:
	CPI  R30,LOW(0x2)
	BRNE _0x2000025
_0x2000024:
	LDI  R21,LOW(0)
	LDI  R17,LOW(3)
	CPI  R18,48
	BRNE _0x2000026
	ORI  R16,LOW(128)
	RJMP _0x200001B
_0x2000026:
	RJMP _0x2000027
_0x2000025:
	CPI  R30,LOW(0x3)
	BREQ PC+3
	JMP _0x200001B
_0x2000027:
	CPI  R18,48
	BRLO _0x200002A
	CPI  R18,58
	BRLO _0x200002B
_0x200002A:
	RJMP _0x2000029
_0x200002B:
	LDI  R26,LOW(10)
	MUL  R21,R26
	MOV  R21,R0
	MOV  R30,R18
	SUBI R30,LOW(48)
	ADD  R21,R30
	RJMP _0x200001B
_0x2000029:
	MOV  R30,R18
	CPI  R30,LOW(0x63)
	BRNE _0x200002F
	LDD  R30,Y+16
	LDD  R31,Y+16+1
	SBIW R30,4
	STD  Y+16,R30
	STD  Y+16+1,R31
	LDD  R26,Z+4
	ST   -Y,R26
	LDD  R30,Y+13
	LDD  R31,Y+13+1
	ST   -Y,R31
	ST   -Y,R30
	LDD  R30,Y+17
	LDD  R31,Y+17+1
	ICALL
	RJMP _0x2000030
_0x200002F:
	CPI  R30,LOW(0x73)
	BRNE _0x2000032
	LDD  R30,Y+16
	LDD  R31,Y+16+1
	SBIW R30,4
	STD  Y+16,R30
	STD  Y+16+1,R31
	LDD  R26,Y+16
	LDD  R27,Y+16+1
	ADIW R26,4
	CALL __GETW1P
	STD  Y+6,R30
	STD  Y+6+1,R31
	ST   -Y,R31
	ST   -Y,R30
	CALL _strlen
	MOV  R17,R30
	RJMP _0x2000033
_0x2000032:
	CPI  R30,LOW(0x70)
	BRNE _0x2000035
	LDD  R30,Y+16
	LDD  R31,Y+16+1
	SBIW R30,4
	STD  Y+16,R30
	STD  Y+16+1,R31
	LDD  R26,Y+16
	LDD  R27,Y+16+1
	ADIW R26,4
	CALL __GETW1P
	STD  Y+6,R30
	STD  Y+6+1,R31
	ST   -Y,R31
	ST   -Y,R30
	CALL _strlenf
	MOV  R17,R30
	ORI  R16,LOW(8)
_0x2000033:
	ORI  R16,LOW(2)
	ANDI R16,LOW(127)
	LDI  R19,LOW(0)
	RJMP _0x2000036
_0x2000035:
	CPI  R30,LOW(0x64)
	BREQ _0x2000039
	CPI  R30,LOW(0x69)
	BRNE _0x200003A
_0x2000039:
	ORI  R16,LOW(4)
	RJMP _0x200003B
_0x200003A:
	CPI  R30,LOW(0x75)
	BRNE _0x200003C
_0x200003B:
	LDI  R30,LOW(_tbl10_G100*2)
	LDI  R31,HIGH(_tbl10_G100*2)
	STD  Y+6,R30
	STD  Y+6+1,R31
	LDI  R17,LOW(5)
	RJMP _0x200003D
_0x200003C:
	CPI  R30,LOW(0x58)
	BRNE _0x200003F
	ORI  R16,LOW(8)
	RJMP _0x2000040
_0x200003F:
	CPI  R30,LOW(0x78)
	BREQ PC+3
	JMP _0x2000071
_0x2000040:
	LDI  R30,LOW(_tbl16_G100*2)
	LDI  R31,HIGH(_tbl16_G100*2)
	STD  Y+6,R30
	STD  Y+6+1,R31
	LDI  R17,LOW(4)
_0x200003D:
	SBRS R16,2
	RJMP _0x2000042
	LDD  R30,Y+16
	LDD  R31,Y+16+1
	SBIW R30,4
	STD  Y+16,R30
	STD  Y+16+1,R31
	LDD  R26,Y+16
	LDD  R27,Y+16+1
	ADIW R26,4
	CALL __GETW1P
	STD  Y+10,R30
	STD  Y+10+1,R31
	LDD  R26,Y+11
	TST  R26
	BRPL _0x2000043
	CALL __ANEGW1
	STD  Y+10,R30
	STD  Y+10+1,R31
	LDI  R20,LOW(45)
_0x2000043:
	CPI  R20,0
	BREQ _0x2000044
	SUBI R17,-LOW(1)
	RJMP _0x2000045
_0x2000044:
	ANDI R16,LOW(251)
_0x2000045:
	RJMP _0x2000046
_0x2000042:
	LDD  R30,Y+16
	LDD  R31,Y+16+1
	SBIW R30,4
	STD  Y+16,R30
	STD  Y+16+1,R31
	LDD  R26,Y+16
	LDD  R27,Y+16+1
	ADIW R26,4
	CALL __GETW1P
	STD  Y+10,R30
	STD  Y+10+1,R31
_0x2000046:
_0x2000036:
	SBRC R16,0
	RJMP _0x2000047
_0x2000048:
	CP   R17,R21
	BRSH _0x200004A
	SBRS R16,7
	RJMP _0x200004B
	SBRS R16,2
	RJMP _0x200004C
	ANDI R16,LOW(251)
	MOV  R18,R20
	SUBI R17,LOW(1)
	RJMP _0x200004D
_0x200004C:
	LDI  R18,LOW(48)
_0x200004D:
	RJMP _0x200004E
_0x200004B:
	LDI  R18,LOW(32)
_0x200004E:
	ST   -Y,R18
	LDD  R30,Y+13
	LDD  R31,Y+13+1
	ST   -Y,R31
	ST   -Y,R30
	LDD  R30,Y+17
	LDD  R31,Y+17+1
	ICALL
	SUBI R21,LOW(1)
	RJMP _0x2000048
_0x200004A:
_0x2000047:
	MOV  R19,R17
	SBRS R16,1
	RJMP _0x200004F
_0x2000050:
	CPI  R19,0
	BREQ _0x2000052
	SBRS R16,3
	RJMP _0x2000053
	LDD  R30,Y+6
	LDD  R31,Y+6+1
	LPM  R18,Z+
	STD  Y+6,R30
	STD  Y+6+1,R31
	RJMP _0x2000054
_0x2000053:
	LDD  R26,Y+6
	LDD  R27,Y+6+1
	LD   R18,X+
	STD  Y+6,R26
	STD  Y+6+1,R27
_0x2000054:
	ST   -Y,R18
	LDD  R30,Y+13
	LDD  R31,Y+13+1
	ST   -Y,R31
	ST   -Y,R30
	LDD  R30,Y+17
	LDD  R31,Y+17+1
	ICALL
	CPI  R21,0
	BREQ _0x2000055
	SUBI R21,LOW(1)
_0x2000055:
	SUBI R19,LOW(1)
	RJMP _0x2000050
_0x2000052:
	RJMP _0x2000056
_0x200004F:
_0x2000058:
	LDI  R18,LOW(48)
	LDD  R30,Y+6
	LDD  R31,Y+6+1
	CALL __GETW1PF
	STD  Y+8,R30
	STD  Y+8+1,R31
	LDD  R30,Y+6
	LDD  R31,Y+6+1
	ADIW R30,2
	STD  Y+6,R30
	STD  Y+6+1,R31
_0x200005A:
	LDD  R30,Y+8
	LDD  R31,Y+8+1
	LDD  R26,Y+10
	LDD  R27,Y+10+1
	CP   R26,R30
	CPC  R27,R31
	BRLO _0x200005C
	SUBI R18,-LOW(1)
	LDD  R26,Y+8
	LDD  R27,Y+8+1
	LDD  R30,Y+10
	LDD  R31,Y+10+1
	SUB  R30,R26
	SBC  R31,R27
	STD  Y+10,R30
	STD  Y+10+1,R31
	RJMP _0x200005A
_0x200005C:
	CPI  R18,58
	BRLO _0x200005D
	SBRS R16,3
	RJMP _0x200005E
	SUBI R18,-LOW(7)
	RJMP _0x200005F
_0x200005E:
	SUBI R18,-LOW(39)
_0x200005F:
_0x200005D:
	SBRC R16,4
	RJMP _0x2000061
	CPI  R18,49
	BRSH _0x2000063
	LDD  R26,Y+8
	LDD  R27,Y+8+1
	SBIW R26,1
	BRNE _0x2000062
_0x2000063:
	RJMP _0x20000CA
_0x2000062:
	CP   R21,R19
	BRLO _0x2000067
	SBRS R16,0
	RJMP _0x2000068
_0x2000067:
	RJMP _0x2000066
_0x2000068:
	LDI  R18,LOW(32)
	SBRS R16,7
	RJMP _0x2000069
	LDI  R18,LOW(48)
_0x20000CA:
	ORI  R16,LOW(16)
	SBRS R16,2
	RJMP _0x200006A
	ANDI R16,LOW(251)
	ST   -Y,R20
	LDD  R30,Y+13
	LDD  R31,Y+13+1
	ST   -Y,R31
	ST   -Y,R30
	LDD  R30,Y+17
	LDD  R31,Y+17+1
	ICALL
	CPI  R21,0
	BREQ _0x200006B
	SUBI R21,LOW(1)
_0x200006B:
_0x200006A:
_0x2000069:
_0x2000061:
	ST   -Y,R18
	LDD  R30,Y+13
	LDD  R31,Y+13+1
	ST   -Y,R31
	ST   -Y,R30
	LDD  R30,Y+17
	LDD  R31,Y+17+1
	ICALL
	CPI  R21,0
	BREQ _0x200006C
	SUBI R21,LOW(1)
_0x200006C:
_0x2000066:
	SUBI R19,LOW(1)
	LDD  R26,Y+8
	LDD  R27,Y+8+1
	SBIW R26,2
	BRLO _0x2000059
	RJMP _0x2000058
_0x2000059:
_0x2000056:
	SBRS R16,0
	RJMP _0x200006D
_0x200006E:
	CPI  R21,0
	BREQ _0x2000070
	SUBI R21,LOW(1)
	LDI  R30,LOW(32)
	ST   -Y,R30
	LDD  R30,Y+13
	LDD  R31,Y+13+1
	ST   -Y,R31
	ST   -Y,R30
	LDD  R30,Y+17
	LDD  R31,Y+17+1
	ICALL
	RJMP _0x200006E
_0x2000070:
_0x200006D:
_0x2000071:
_0x2000030:
_0x20000C9:
	LDI  R17,LOW(0)
_0x200001B:
	RJMP _0x2000016
_0x2000018:
	LDD  R26,Y+12
	LDD  R27,Y+12+1
	CALL __GETW1P
	CALL __LOADLOCR6
	ADIW R28,20
	RET
_sprintf:
	PUSH R15
	MOV  R15,R24
	SBIW R28,6
	CALL __SAVELOCR4
	MOVW R26,R28
	ADIW R26,12
	CALL __ADDW2R15
	CALL __GETW1P
	SBIW R30,0
	BRNE _0x2000072
	LDI  R30,LOW(65535)
	LDI  R31,HIGH(65535)
	RJMP _0x2060002
_0x2000072:
	MOVW R26,R28
	ADIW R26,6
	CALL __ADDW2R15
	MOVW R16,R26
	MOVW R26,R28
	ADIW R26,12
	CALL __ADDW2R15
	CALL __GETW1P
	STD  Y+6,R30
	STD  Y+6+1,R31
	LDI  R30,LOW(0)
	STD  Y+8,R30
	STD  Y+8+1,R30
	MOVW R26,R28
	ADIW R26,10
	CALL __ADDW2R15
	CALL __GETW1P
	ST   -Y,R31
	ST   -Y,R30
	ST   -Y,R17
	ST   -Y,R16
	LDI  R30,LOW(_put_buff_G100)
	LDI  R31,HIGH(_put_buff_G100)
	ST   -Y,R31
	ST   -Y,R30
	MOVW R30,R28
	ADIW R30,10
	ST   -Y,R31
	ST   -Y,R30
	RCALL __print_G100
	MOVW R18,R30
	LDD  R26,Y+6
	LDD  R27,Y+6+1
	LDI  R30,LOW(0)
	ST   X,R30
	RJMP _0x2060003
_snprintf:
	PUSH R15
	MOV  R15,R24
	SBIW R28,6
	CALL __SAVELOCR4
	__GETWRN 18,19,0
	MOVW R26,R28
	ADIW R26,14
	CALL __ADDW2R15
	CALL __GETW1P
	SBIW R30,0
	BRNE _0x2000073
	LDI  R30,LOW(65535)
	LDI  R31,HIGH(65535)
	RJMP _0x2060002
_0x2000073:
	MOVW R26,R28
	ADIW R26,12
	CALL __ADDW2R15
	CALL __GETW1P
	SBIW R30,0
	BREQ _0x2000074
	MOVW R26,R28
	ADIW R26,6
	CALL __ADDW2R15
	MOVW R16,R26
	MOVW R26,R28
	ADIW R26,14
	CALL __ADDW2R15
	CALL __GETW1P
	STD  Y+6,R30
	STD  Y+6+1,R31
	MOVW R26,R28
	ADIW R26,12
	CALL __ADDW2R15
	CALL __GETW1P
	STD  Y+8,R30
	STD  Y+8+1,R31
	MOVW R26,R28
	ADIW R26,10
	CALL __ADDW2R15
	CALL __GETW1P
	ST   -Y,R31
	ST   -Y,R30
	ST   -Y,R17
	ST   -Y,R16
	LDI  R30,LOW(_put_buff_G100)
	LDI  R31,HIGH(_put_buff_G100)
	ST   -Y,R31
	ST   -Y,R30
	MOVW R30,R28
	ADIW R30,10
	ST   -Y,R31
	ST   -Y,R30
	RCALL __print_G100
	MOVW R18,R30
	LDD  R26,Y+6
	LDD  R27,Y+6+1
	LDI  R30,LOW(0)
	ST   X,R30
_0x2000074:
_0x2060003:
	MOVW R30,R18
_0x2060002:
	CALL __LOADLOCR4
	ADIW R28,10
	POP  R15
	RET

	.CSEG
_memset:
    ldd  r27,y+1
    ld   r26,y
    adiw r26,0
    breq memset1
    ldd  r31,y+4
    ldd  r30,y+3
    ldd  r22,y+2
memset0:
    st   z+,r22
    sbiw r26,1
    brne memset0
memset1:
    ldd  r30,y+3
    ldd  r31,y+4
_0x2060001:
	ADIW R28,5
	RET
_strchr:
    ld   r26,y+
    ld   r30,y+
    ld   r31,y+
strchr0:
    ld   r27,z
    cp   r26,r27
    breq strchr1
    adiw r30,1
    tst  r27
    brne strchr0
    clr  r30
    clr  r31
strchr1:
    ret
_strcpy:
    ld   r30,y+
    ld   r31,y+
    ld   r26,y+
    ld   r27,y+
    movw r24,r26
strcpy0:
    ld   r22,z+
    st   x+,r22
    tst  r22
    brne strcpy0
    movw r30,r24
    ret
_strcpyf:
    ld   r30,y+
    ld   r31,y+
    ld   r26,y+
    ld   r27,y+
    movw r24,r26
strcpyf0:
	lpm  r0,z+
    st   x+,r0
    tst  r0
    brne strcpyf0
    movw r30,r24
    ret
_strlen:
    ld   r26,y+
    ld   r27,y+
    clr  r30
    clr  r31
strlen0:
    ld   r22,x+
    tst  r22
    breq strlen1
    adiw r30,1
    rjmp strlen0
strlen1:
    ret
_strlenf:
    clr  r26
    clr  r27
    ld   r30,y+
    ld   r31,y+
strlenf0:
	lpm  r0,z+
    tst  r0
    breq strlenf1
    adiw r26,1
    rjmp strlenf0
strlenf1:
    movw r30,r26
    ret

	.CSEG

	.DSEG
_rx_buffer0:
	.BYTE 0x20
_tx_buffer0:
	.BYTE 0x20
_Settings:
	.BYTE 0x36

	.ESEG

	.ORG 0x1
_EEPROM_SETTINGS:
	.BYTE 0x36

	.DSEG
_CurModel:
	.BYTE 0x2F7

	.ESEG
_EEPROM_MODEL:
	.BYTE 0xED3

	.DSEG
_tmpStr:
	.BYTE 0x40
_tmpBuf:
	.BYTE 0x20
_Aref:
	.BYTE 0x2
_AD:
	.BYTE 0x10
_AD_NORM:
	.BYTE 0x10
_input:
	.BYTE 0x16
_out_cur:
	.BYTE 0x16
_output:
	.BYTE 0x10
_ADmin:
	.BYTE 0x10
_ADmax:
	.BYTE 0x10
_FLY_MODE:
	.BYTE 0x1
_trim_sound_en:
	.BYTE 0x1
_Cut_enable:
	.BYTE 0x1
_Font_4x6:
	.BYTE 0x7
_Font_6x8:
	.BYTE 0x7
_Font_8x8:
	.BYTE 0x7
_Font_8x12:
	.BYTE 0x7
_Font_12x16:
	.BYTE 0x7
_TickCount_G000:
	.BYTE 0x4
_nb_S0000006000:
	.BYTE 0x1
_del_S0000006000:
	.BYTE 0x2
_InterruptEnterFlag_S0000007000:
	.BYTE 0x1
_MissedIntCount_S0000007000:
	.BYTE 0x1
_LCD_Buf:
	.BYTE 0x400
_LCD_Pos_X:
	.BYTE 0x1
_LCD_Pos_Y:
	.BYTE 0x1
_TrimMask_S0040005000:
	.BYTE 0x1
_SoundTable_G005:
	.BYTE 0x2
_SoundTableSize_G005:
	.BYTE 0x2
_SoundTablePosition_G005:
	.BYTE 0x2
_Delay_S0050005000:
	.BYTE 0x1
_ovf:
	.BYTE 0x1
_dir:
	.BYTE 0x1
_NeedSaveTrimmers_G009:
	.BYTE 0x1
_TimeToTrimmersSave_G009:
	.BYTE 0x4
_KbdStat_G009:
	.BYTE 0x1
_OldKbdStat_S0090002000:
	.BYTE 0x1
_PREV_FLY_MODE_S0090004000:
	.BYTE 0x1
_TimerValue_G009:
	.BYTE 0x2
_TimerSubValue_G009:
	.BYTE 0x2
_CountingFlag_G009:
	.BYTE 0x1
_TimerSound_G009:
	.BYTE 0x1
_counter_S0090006000:
	.BYTE 0x1
_precounter_S0090006000:
	.BYTE 0x1
_U_Bat_G009:
	.BYTE 0x2
_DefModeNames_G00A:
	.BYTE 0x6

	.ESEG

	.ORG 0x0
_EEPROM_TRASH_G00A:
	.BYTE 0x1

	.ORG 0xF0A

	.ORG 0xFFE
_EEPROM_CRC_G00A:
	.BYTE 0x2

	.ORG 0xF0A

	.DSEG
_ModelTypes:
	.BYTE 0x4
_ModulationTypes:
	.BYTE 0x6
_CurrentControl_G00C:
	.BYTE 0x1
_MixerCurrentChannel_G00C:
	.BYTE 0x1

	.CSEG

	.CSEG
_delay_ms:
	ld   r30,y+
	ld   r31,y+
	adiw r30,0
	breq __delay_ms1
__delay_ms0:
	__DELAY_USW 0xFA0
	wdr
	sbiw r30,1
	brne __delay_ms0
__delay_ms1:
	ret

__ADDW2R15:
	CLR  R0
	ADD  R26,R15
	ADC  R27,R0
	RET

__ADDD12:
	ADD  R30,R26
	ADC  R31,R27
	ADC  R22,R24
	ADC  R23,R25
	RET

__SUBD21:
	SUB  R26,R30
	SBC  R27,R31
	SBC  R24,R22
	SBC  R25,R23
	RET

__ANEGW1:
	NEG  R31
	NEG  R30
	SBCI R31,0
	RET

__ANEGD1:
	COM  R31
	COM  R22
	COM  R23
	NEG  R30
	SBCI R31,-1
	SBCI R22,-1
	SBCI R23,-1
	RET

__LSLB12:
	TST  R30
	MOV  R0,R30
	MOV  R30,R26
	BREQ __LSLB12R
__LSLB12L:
	LSL  R30
	DEC  R0
	BRNE __LSLB12L
__LSLB12R:
	RET

__ASRD12:
	TST  R30
	MOV  R0,R30
	MOVW R30,R26
	MOVW R22,R24
	BREQ __ASRD12R
__ASRD12L:
	ASR  R23
	ROR  R22
	ROR  R31
	ROR  R30
	DEC  R0
	BRNE __ASRD12L
__ASRD12R:
	RET

__LSLW4:
	LSL  R30
	ROL  R31
__LSLW3:
	LSL  R30
	ROL  R31
__LSLW2:
	LSL  R30
	ROL  R31
	LSL  R30
	ROL  R31
	RET

__LSRW4:
	LSR  R31
	ROR  R30
__LSRW3:
	LSR  R31
	ROR  R30
__LSRW2:
	LSR  R31
	ROR  R30
	LSR  R31
	ROR  R30
	RET

__ASRW8:
	MOV  R30,R31
	CLR  R31
	SBRC R30,7
	SER  R31
	RET

__CBD1:
	MOV  R31,R30
	ADD  R31,R31
	SBC  R31,R31
	MOV  R22,R31
	MOV  R23,R31
	RET

__CWD1:
	MOV  R22,R31
	ADD  R22,R22
	SBC  R22,R22
	MOV  R23,R22
	RET

__CWD2:
	MOV  R24,R27
	ADD  R24,R24
	SBC  R24,R24
	MOV  R25,R24
	RET

__MULW12U:
	MUL  R31,R26
	MOV  R31,R0
	MUL  R30,R27
	ADD  R31,R0
	MUL  R30,R26
	MOV  R30,R0
	ADD  R31,R1
	RET

__MULD12U:
	MUL  R23,R26
	MOV  R23,R0
	MUL  R22,R27
	ADD  R23,R0
	MUL  R31,R24
	ADD  R23,R0
	MUL  R30,R25
	ADD  R23,R0
	MUL  R22,R26
	MOV  R22,R0
	ADD  R23,R1
	MUL  R31,R27
	ADD  R22,R0
	ADC  R23,R1
	MUL  R30,R24
	ADD  R22,R0
	ADC  R23,R1
	CLR  R24
	MUL  R31,R26
	MOV  R31,R0
	ADD  R22,R1
	ADC  R23,R24
	MUL  R30,R27
	ADD  R31,R0
	ADC  R22,R1
	ADC  R23,R24
	MUL  R30,R26
	MOV  R30,R0
	ADD  R31,R1
	ADC  R22,R24
	ADC  R23,R24
	RET

__MULW12:
	RCALL __CHKSIGNW
	RCALL __MULW12U
	BRTC __MULW121
	RCALL __ANEGW1
__MULW121:
	RET

__MULD12:
	RCALL __CHKSIGND
	RCALL __MULD12U
	BRTC __MULD121
	RCALL __ANEGD1
__MULD121:
	RET

__DIVB21U:
	CLR  R0
	LDI  R25,8
__DIVB21U1:
	LSL  R26
	ROL  R0
	SUB  R0,R30
	BRCC __DIVB21U2
	ADD  R0,R30
	RJMP __DIVB21U3
__DIVB21U2:
	SBR  R26,1
__DIVB21U3:
	DEC  R25
	BRNE __DIVB21U1
	MOV  R30,R26
	MOV  R26,R0
	RET

__DIVB21:
	RCALL __CHKSIGNB
	RCALL __DIVB21U
	BRTC __DIVB211
	NEG  R30
__DIVB211:
	RET

__DIVW21U:
	CLR  R0
	CLR  R1
	LDI  R25,16
__DIVW21U1:
	LSL  R26
	ROL  R27
	ROL  R0
	ROL  R1
	SUB  R0,R30
	SBC  R1,R31
	BRCC __DIVW21U2
	ADD  R0,R30
	ADC  R1,R31
	RJMP __DIVW21U3
__DIVW21U2:
	SBR  R26,1
__DIVW21U3:
	DEC  R25
	BRNE __DIVW21U1
	MOVW R30,R26
	MOVW R26,R0
	RET

__DIVW21:
	RCALL __CHKSIGNW
	RCALL __DIVW21U
	BRTC __DIVW211
	RCALL __ANEGW1
__DIVW211:
	RET

__DIVD21U:
	PUSH R19
	PUSH R20
	PUSH R21
	CLR  R0
	CLR  R1
	CLR  R20
	CLR  R21
	LDI  R19,32
__DIVD21U1:
	LSL  R26
	ROL  R27
	ROL  R24
	ROL  R25
	ROL  R0
	ROL  R1
	ROL  R20
	ROL  R21
	SUB  R0,R30
	SBC  R1,R31
	SBC  R20,R22
	SBC  R21,R23
	BRCC __DIVD21U2
	ADD  R0,R30
	ADC  R1,R31
	ADC  R20,R22
	ADC  R21,R23
	RJMP __DIVD21U3
__DIVD21U2:
	SBR  R26,1
__DIVD21U3:
	DEC  R19
	BRNE __DIVD21U1
	MOVW R30,R26
	MOVW R22,R24
	MOVW R26,R0
	MOVW R24,R20
	POP  R21
	POP  R20
	POP  R19
	RET

__DIVD21:
	RCALL __CHKSIGND
	RCALL __DIVD21U
	BRTC __DIVD211
	RCALL __ANEGD1
__DIVD211:
	RET

__MODB21:
	CLT
	SBRS R26,7
	RJMP __MODB211
	NEG  R26
	SET
__MODB211:
	SBRC R30,7
	NEG  R30
	RCALL __DIVB21U
	MOV  R30,R26
	BRTC __MODB212
	NEG  R30
__MODB212:
	RET

__MODW21:
	CLT
	SBRS R27,7
	RJMP __MODW211
	COM  R26
	COM  R27
	ADIW R26,1
	SET
__MODW211:
	SBRC R31,7
	RCALL __ANEGW1
	RCALL __DIVW21U
	MOVW R30,R26
	BRTC __MODW212
	RCALL __ANEGW1
__MODW212:
	RET

__MODD21U:
	RCALL __DIVD21U
	MOVW R30,R26
	MOVW R22,R24
	RET

__CHKSIGNB:
	CLT
	SBRS R30,7
	RJMP __CHKSB1
	NEG  R30
	SET
__CHKSB1:
	SBRS R26,7
	RJMP __CHKSB2
	NEG  R26
	BLD  R0,0
	INC  R0
	BST  R0,0
__CHKSB2:
	RET

__CHKSIGNW:
	CLT
	SBRS R31,7
	RJMP __CHKSW1
	RCALL __ANEGW1
	SET
__CHKSW1:
	SBRS R27,7
	RJMP __CHKSW2
	COM  R26
	COM  R27
	ADIW R26,1
	BLD  R0,0
	INC  R0
	BST  R0,0
__CHKSW2:
	RET

__CHKSIGND:
	CLT
	SBRS R23,7
	RJMP __CHKSD1
	RCALL __ANEGD1
	SET
__CHKSD1:
	SBRS R25,7
	RJMP __CHKSD2
	CLR  R0
	COM  R26
	COM  R27
	COM  R24
	COM  R25
	ADIW R26,1
	ADC  R24,R0
	ADC  R25,R0
	BLD  R0,0
	INC  R0
	BST  R0,0
__CHKSD2:
	RET

__GETW1P:
	LD   R30,X+
	LD   R31,X
	SBIW R26,1
	RET

__GETD1P_INC:
	LD   R30,X+
	LD   R31,X+
	LD   R22,X+
	LD   R23,X+
	RET

__PUTDP1_DEC:
	ST   -X,R23
	ST   -X,R22
	ST   -X,R31
	ST   -X,R30
	RET

__GETW1PF:
	LPM  R0,Z+
	LPM  R31,Z
	MOV  R30,R0
	RET

__GETW2PF:
	LPM  R26,Z+
	LPM  R27,Z
	RET

__GETD1S0:
	LD   R30,Y
	LDD  R31,Y+1
	LDD  R22,Y+2
	LDD  R23,Y+3
	RET

__PUTD1S0:
	ST   Y,R30
	STD  Y+1,R31
	STD  Y+2,R22
	STD  Y+3,R23
	RET

__PUTPARD1:
	ST   -Y,R23
	ST   -Y,R22
	ST   -Y,R31
	ST   -Y,R30
	RET

__SWAPW12:
	MOV  R1,R27
	MOV  R27,R31
	MOV  R31,R1

__SWAPB12:
	MOV  R1,R26
	MOV  R26,R30
	MOV  R30,R1
	RET

__EEPROMRDW:
	ADIW R26,1
	RCALL __EEPROMRDB
	MOV  R31,R30
	SBIW R26,1

__EEPROMRDB:
	SBIC EECR,EEWE
	RJMP __EEPROMRDB
	PUSH R31
	IN   R31,SREG
	CLI
	OUT  EEARL,R26
	OUT  EEARH,R27
	SBI  EECR,EERE
	IN   R30,EEDR
	OUT  SREG,R31
	POP  R31
	RET

__EEPROMWRW:
	RCALL __EEPROMWRB
	ADIW R26,1
	PUSH R30
	MOV  R30,R31
	RCALL __EEPROMWRB
	POP  R30
	SBIW R26,1
	RET

__EEPROMWRB:
	SBIS EECR,EEWE
	RJMP __EEPROMWRB1
	WDR
	RJMP __EEPROMWRB
__EEPROMWRB1:
	IN   R25,SREG
	CLI
	OUT  EEARL,R26
	OUT  EEARH,R27
	SBI  EECR,EERE
	IN   R24,EEDR
	CP   R30,R24
	BREQ __EEPROMWRB0
	OUT  EEDR,R30
	SBI  EECR,EEMWE
	SBI  EECR,EEWE
__EEPROMWRB0:
	OUT  SREG,R25
	RET

__CPD12:
	CP   R30,R26
	CPC  R31,R27
	CPC  R22,R24
	CPC  R23,R25
	RET

__SAVELOCR6:
	ST   -Y,R21
__SAVELOCR5:
	ST   -Y,R20
__SAVELOCR4:
	ST   -Y,R19
__SAVELOCR3:
	ST   -Y,R18
__SAVELOCR2:
	ST   -Y,R17
	ST   -Y,R16
	RET

__LOADLOCR6:
	LDD  R21,Y+5
__LOADLOCR5:
	LDD  R20,Y+4
__LOADLOCR4:
	LDD  R19,Y+3
__LOADLOCR3:
	LDD  R18,Y+2
__LOADLOCR2:
	LDD  R17,Y+1
	LD   R16,Y
	RET

__INITLOCB:
__INITLOCW:
	ADD  R26,R28
	ADC  R27,R29
__INITLOC0:
	LPM  R0,Z+
	ST   X+,R0
	DEC  R24
	BRNE __INITLOC0
	RET

;END OF CODE MARKER
__END_OF_CODE:
