/*******************************************************************************
*  Graphic.c
*
*  :     
*
*       Copyright (c) 2007-2008 Nick Shl, focus
*           All rights reserved.
*
*
*  :
*
*  Apr 20, 2009  Nick_Shl  
*  Apr 10, 2008  Nick_Shl  ,  
*                             
*  *** **, ****  focus      
*
*/// ***************************************************************************

// *****************************************************************************
// ***       ***************************************************
// *****************************************************************************
#include <stdio.h>
#include <string.h>

// *****************************************************************************
// ***       ********************************************
// *****************************************************************************
#include "Def.h"
#include "Graphic.h"
#include "Fonts.h"
#include "MT12864.h"
#include "CRC.h"
#include "Variables.h"

// *****************************************************************************
// ***       ***********************************************
// *****************************************************************************
FontProfile Font_4x6;
FontProfile Font_6x8;
FontProfile Font_8x8;
FontProfile Font_8x12;
FontProfile Font_12x16;

// *****************************************************************************
// ***       ***********************************************
// *****************************************************************************
inline void gfx_BackLight(unsigned char Cmd)
{
    LCD_BackLight(Cmd);
    Settings.BacklightFlag = Cmd;
}

// *****************************************************************************
// ***           ********************************
// *****************************************************************************
inline void gfx_Refresh(void)
{
	LCD_Refresh();
}

// *****************************************************************************
// ***         ****************************
// *****************************************************************************
void gfx_AutoRefreshTask(void)
{
    //      CRC
    //  -    
    static unsigned int OldCRC;
    //    CRC
    unsigned int NewCRC;

    //  CRC  
    NewCRC = Crc16_ram((unsigned char *)LCD_Buf, sizeof(LCD_Buf));

    //  CRC 
    if(NewCRC != OldCRC)
    {
        //  
    	LCD_Refresh();
        //   CRC
        OldCRC = NewCRC;
    }
}

// *****************************************************************************
// ***        ***********************************************
// *****************************************************************************
void gfx_ClearBuf(void)
{
    //   
    memset(LCD_Buf, 0, sizeof(LCD_Buf));
}

// *****************************************************************************
// ***    .      .   *********
// ***     -  ...    .    *********
// ***         ?                             *********
// ***      -                *********
// *****************************************************************************
void gfx_PutPixel(unsigned char x, unsigned char y, unsigned char color)
{
    unsigned char i;
    unsigned char j;

#ifdef DEBUG
    x &= 0b01111111; // x must be 0 <= x <= 127 Only for this screen !!!
    y &= 0b00111111; // y must be 0 <= y <=  63 Only for this screen !!!
#else
    if(x >=  WidthS) return; //  X    - 
    if(y >= HeightS) return; //  Y    - 
#endif

    color &= 0x01;   // Color must have one last bit

#ifdef GFX_REVERSED
    x = WidthS  - 1 - x; // Reverse X
    y = HeightS - 1 - y; // Reverse Y
#endif

    i = y >> 3;          // y/8;
    j = y & 0b00000111;  // y%8;

    LCD_Buf[i][x] = (LCD_Buf[i][x] & (~(1 << j))) | (color << j);
}

// *****************************************************************************
// ***       *************************************************
// *****************************************************************************
void gfx_InvertPixel(unsigned char x, unsigned char y)
{
    unsigned char i;
    unsigned char j;

#ifdef DEBUG
    x &= 0b01111111; // x must be 0 <= x <= 127 Only for this screen !!!
    y &= 0b00111111; // y must be 0 <= y <=  63 Only for this screen !!!
#else
    if(x >=  WidthS) return; //  X    - 
    if(y >= HeightS) return; //  Y    - 
#endif

#ifdef GFX_REVERSED
    x = WidthS  - 1 - x; // Reverse X
    y = HeightS - 1 - y; // Reverse Y
#endif

    i = y >> 3;          // y/8;
    j = y & 0b00000111;  // y%8;

    LCD_Buf[i][x] = LCD_Buf[i][x] ^ (1 << j);
}

// *****************************************************************************
// ***       *********************************************************
// *****************************************************************************
void gfx_Line(int x1, int y1, int x2, int y2, unsigned char color)
{
    char stepx, stepy;
    int dx, dy, fraction;

    //  dx
    dx = (signed int)x2 - x1;
    //  dx
    dy = (signed int)y2 - y1;

    if(dx < 0)
    {
         dx    = -dx;
         stepx = -1;
    }
    else stepx = 1;

    if(dy < 0)
    {
         dy    = -dy;
         stepy = -1;
    }
    else stepy = 1;

    dx <<= 1;
    dy <<= 1;
    gfx_PutPixel(x1, y1, color);
    if(dx > dy)
    {
        fraction = dy - (dx >> 1);
        while(x1 != x2)
        {
            if(fraction >= 0) // ATENTION: Need use >=, but this make error in PROTEUS
            {
                y1 += stepy;
                fraction -= dx;
            }
            x1 += stepx;
            fraction += dy;
            if((x1 < 0) || (x1 >= WidthS) || (y1 < 0) || (y1 >= HeightS)) continue;
            gfx_PutPixel(x1, y1, color);
        }
    }
    else
    {
        fraction = dx - (dy >> 1);
        while(y1 != y2)
        {
            if(fraction >= 0) // ATENTION: Need use >=, but this make error in PROTEUS
            {
                x1 += stepx;
                fraction -= dy;
            }
            y1 += stepy;
            fraction += dx;
            if((x1 < 0) || (x1 >= WidthS) || (y1 < 0) || (y1 >= HeightS)) continue;
            gfx_PutPixel(x1, y1, color);
        }
    }
}

// *****************************************************************************
// ***         ************************************************
// *****************************************************************************
void gfx_DashLine(int x1, int y1, int x2, int y2)
{
    char stepx, stepy, mode;
    int dx, dy, fraction;

    dy = (signed int)y2 - y1;
    dx = (signed int)x2 - x1;
    mode = 1;

    if(dy < 0)
    {
        dy    = -dy;
        stepy = -1;
    }
    else stepy = 1;

    if(dx < 0)
    {
        dx    = -dx;
        stepx = -1;
    }
    else stepx = 1;

    dx <<= 1;
    dy <<= 1;
    gfx_PutPixel(x1, y1, mode);
    if(dx > dy)
    {
        fraction = dy - (dx >> 1);
        while(x1 != x2)
        {
            if(fraction >= 0)
            {
                y1 += stepy;
                fraction -= dx;
            }
            x1 += stepx;
            fraction += dy;

            if(mode) mode = 0;
            else     mode = 1;

            if((x1 < 0) || (x1 >= WidthS) || (y1 < 0) || (y1 >= HeightS)) continue;
            gfx_PutPixel(x1, y1, mode);
        }
    }
    else
    {
        fraction = dx - (dy >> 1);
        while(y1 != y2)
        {
            if(fraction >= 0)
            {
                x1 += stepx;
                fraction -= dy;
            }
            y1 += stepy;
            fraction += dx;

            if(mode) mode = 0;
            else     mode = 1;

            if((x1 < 0) || (x1 >= WidthS) || (y1 < 0) || (y1 >= HeightS)) continue;
            gfx_PutPixel(x1, y1, mode);
        }
    }
}

// *****************************************************************************
// ***        ***********************************************
// *****************************************************************************
void gfx_Rectangle(int x1, int y1, int x2, int y2, unsigned char color)
{
    gfx_Line(x1, y1, x1, y2, color);
    gfx_Line(x1, y2, x2, y2, color);
    gfx_Line(x2, y1, x2, y2, color);
    gfx_Line(x1, y1, x2, y1, color);
}

// *****************************************************************************
// ***        ***********************************
// *****************************************************************************
void gfx_FillRect(int x1, int y1, int x2, int y2, unsigned char color)
{
    int swap;
    unsigned char i, j;

    if(x1 > x2)
    {
        swap = x1;
        x1 = x2;
        x2 = swap;
    }

    if(y1 > y2)
    {
        swap = y1;
        y1 = y2;
        y2 = swap;
    }

    if(x1 < 0) x1 = 0;
    if(y1 < 0) y1 = 0;
    if(x2 >  WidthS - 1) x2 = WidthS  - 1;
    if(y2 > HeightS - 1) y2 = HeightS - 1;

    for(i = x1; i <= x2; i++)
        for(j = y1; j <= y2; j++) gfx_PutPixel(i, j, color);
}

// *****************************************************************************
// ***        ********************************
// *****************************************************************************
void gfx_InvertRect(int x1, int y1, int x2, int y2)
{
    unsigned char i, j, swap;

    if(x1 > x2)
    {
        swap = x1;
        x1 = x2;
        x2 = swap;
    }

    if(y1 > y2)
    {
        swap = y1;
        y1 = y2;
        y2 = swap;
    }

    for(i = x1; i <= x2; i++)
        for(j = y1; j <= y2; j++) gfx_InvertPixel(i, j);
}

// *****************************************************************************
// ***        *****************************************
// *****************************************************************************
void gfx_SetXY(unsigned char x, unsigned char y)
{
    //    X
    LCD_Pos_X = x;
    //    Y
    LCD_Pos_Y = y;
}

// *****************************************************************************
// ***        ******************************************
// *****************************************************************************
void gfx_ChangeXY(char dX, char dY)
{
    //    X
    LCD_Pos_X += dX;
    //    Y
    LCD_Pos_Y += dY;
}

// *****************************************************************************
// ***     4x6   ***************************************************
// *****************************************************************************
void gfx_Char_4x6(unsigned char c, unsigned char color)
{
    char i, j;
    unsigned char b;

    // c = address of character in the font array
    for(i=0; i < 4; i++)
    {
        b = font4x6[c][i];
        for(j=0; j < 6; j++)
        {
            gfx_PutPixel(LCD_Pos_X, LCD_Pos_Y+j, (~(b ^ color)) & 1);
            b >>= 1;
        }
        LCD_Pos_X++;
    }
}

// *****************************************************************************
// ***     6x8   ***************************************************
// *****************************************************************************
void gfx_Char_6x8(unsigned char c, unsigned char color)
{
    char i, j;
    unsigned char b;

    // c = address of character in the font array
    for(i=0; i < 6; i++)
    {
        b = font6x8[c][i];
        for(j=0; j < 8; j++)
        {
            gfx_PutPixel(LCD_Pos_X, LCD_Pos_Y+j, (~(b ^ color)) & 1);
            b >>= 1;
        }
        LCD_Pos_X++;
    }
}

// *****************************************************************************
// ***     8x8   ***************************************************
// *****************************************************************************
void gfx_Char_8x8(unsigned char c, unsigned char color)
{
    char i, j;
    unsigned char b;

    // c = address of character in the font array
    for(i=0; i < 8; i++)
    {
        b = font8x8[c][i];
        for(j=0; j < 8; j++)
        {
            gfx_PutPixel(LCD_Pos_X, LCD_Pos_Y+j, (~(b ^ color)) & 1);
            b >>= 1;
        }
        LCD_Pos_X++;
    }
}

// *****************************************************************************
// ***     8x12   **************************************************
// *****************************************************************************
void gfx_Char_8x12(unsigned char c, unsigned char color)
{
    char i, j;
    unsigned char b;

    // c = address of character in the font array
    for(i=0; i < 16; i++)
    {
        b = font8x12[c][i];
        for(j=0; j < 8; j++)
        {
            gfx_PutPixel(LCD_Pos_X, LCD_Pos_Y+j, (~(b ^ color)) & 1);
            b >>= 1;
        }
        i++;
        b = font8x12[c][i];
        for(j=8; j < 12; j++)
        {
            gfx_PutPixel(LCD_Pos_X, LCD_Pos_Y+j, (~(b ^ color)) & 1);
            b >>= 1;
        }
        LCD_Pos_X++;
    }
}

// *****************************************************************************
// ***       *******************************************************
// *****************************************************************************
void gfx_Char_12x16(unsigned char c, unsigned char color)
{
    char i, j;
    unsigned char b;

    // c = address of character in the font array
    for(i=0; i < 24; i++)
    {
        b = font12x16[c][i];
        for(j=0; j < 8; j++)
        {
            gfx_PutPixel(LCD_Pos_X, LCD_Pos_Y+j, (~(b ^ color)) & 1);
            b >>= 1;
        }
        i++;
        b = font12x16[c][i];
        for(j=8; j < 16; j++)
        {
            gfx_PutPixel(LCD_Pos_X, LCD_Pos_Y+j, (~(b ^ color)) & 1);
            b >>= 1;
        }
        LCD_Pos_X++;
    }
}

// *****************************************************************************
// ***       *******************************************************
// *****************************************************************************
void gfx_Char(unsigned char c, unsigned char color, FontProfile * font)
{
    char i, j;
    unsigned char b, h, w;

    // c = address of character in the font array
    w = 0;
    for(i=0; i < font->BytesPerChar;)
    {
        h = 0;
        while(h < font->H)
        {
            b = font->FontData[(int)c * font->BytesPerChar + i];
            for(j=0; j < 8; j++)
            {
                gfx_PutPixel(LCD_Pos_X, LCD_Pos_Y + h, (~(b ^ color)) & 1);
                b >>= 1;
                h++;
                if(h == font->H) break;
            }
            i++;
        }
        LCD_Pos_X++;
        w++;
        if(w == font->W) break;
    }
}

// *****************************************************************************
// ***       *******************************************************
// *****************************************************************************
// ***   .     gfx_Char()   ***********
// *****************************************************************************
void gfx_Deg_12x16(unsigned char c, unsigned char color)
{
    gfx_Char(c+0x30, color, &Font_12x16);
}

// *****************************************************************************
// ***          ***************************************
// *****************************************************************************
void gfx_Pict(unsigned char flash * p_arr, unsigned char W, unsigned char H, unsigned char X, unsigned char Y, unsigned char color)
{
    unsigned int i, j, k;

    for(i=0; i < H; i++)
        for(j=0; j < W; j++)
            for(k=0; k < 8; k++) gfx_PutPixel(X + j, Y + i*8 + k, ~((p_arr[j + i*W] >> k) ^ color) & 1);
}

// *****************************************************************************
// ***            *************
// *****************************************************************************
void gfx_PutStr(unsigned char * str, unsigned char color, FontProfile * font)
{
    while(*str !='\0') gfx_Char(*str++, color, font); //font->PutChar(*str++, color);
}

// *****************************************************************************
// ***            ********************
// *****************************************************************************
void gfx_PutFlashStr(unsigned char flash * str, unsigned char color, FontProfile * font)
{
    while(*str !='\0') gfx_Char(*str++, color, font); //font->PutChar(*str++, color);
}

// *****************************************************************************
// ***         *************************************
// *****************************************************************************
void gfx_Init(void)
{
    //   
    LCD_Init();

    //    4x6
    Font_4x6.W = 4;
    Font_4x6.H = 6;
    Font_4x6.FontData = (flash unsigned char *)font4x6;
    Font_4x6.BytesPerChar = 4;
    Font_4x6.PutChar = &gfx_Char_4x6;

    //    6x8
    Font_6x8.W = 6;
    Font_6x8.H = 8;
    Font_6x8.FontData = (flash unsigned char *)font6x8;
    Font_6x8.BytesPerChar = 8;
    Font_6x8.PutChar = &gfx_Char_6x8;

    //    8x8
    Font_8x8.W = 8;
    Font_8x8.H = 8;
    Font_8x8.FontData = (flash unsigned char *)font8x8;
    Font_8x8.BytesPerChar = 8;
    Font_8x8.PutChar = &gfx_Char_8x8;

    //    8x12
    Font_8x12.W = 8;
    Font_8x12.H = 12;
    Font_8x12.FontData = (flash unsigned char *)font8x12;
    Font_8x12.BytesPerChar = 16;
    Font_8x12.PutChar = &gfx_Char_8x12;

    //    12x16
    Font_12x16.W = 12;
    Font_12x16.H = 16;
    Font_12x16.FontData = (flash unsigned char *)font12x16;
    Font_12x16.BytesPerChar = 24;
    Font_12x16.PutChar = &gfx_Char_12x16;
}
