/*******************************************************************************
*  Graphic.h
*
*  :     , 
*
*       Copyright (c) 2007-2008 Nick Shl, focus
*           All rights reserved.
*
*
*  :
*
*  Apr 10, 2008  Nick_Shl   
*
*/// ***************************************************************************

// *****************************************************************************
// ***       *******************************************************
// *****************************************************************************
#define WidthS  128 //   
#define HeightS  64 //   

// *****************************************************************************
// ***       *******************************************************
// *****************************************************************************
typedef struct
{
    unsigned char W; // Width of character
    unsigned char H; // Height of character
    flash unsigned char * FontData;
    unsigned char BytesPerChar; // Bytes Per Char
    void (*PutChar)(unsigned char c, unsigned char color);
} FontProfile;

extern FontProfile Font_4x6;
extern FontProfile Font_6x8;
extern FontProfile Font_8x8;
extern FontProfile Font_8x12;
extern FontProfile Font_12x16;

// *****************************************************************************
// ***         *************************************
// *****************************************************************************
void gfx_Init(void);

// *****************************************************************************
// ***           ********************************
// *****************************************************************************
inline void gfx_Refresh(void);

// *****************************************************************************
// ***       ***********************************************
// *****************************************************************************
inline void gfx_BackLight(unsigned char Cmd);

// *****************************************************************************
// ***           ********************************
// *****************************************************************************
void gfx_AutoRefreshTask(void);

// *****************************************************************************
// ***       ******************************************************
// *****************************************************************************
void gfx_ClearBuf(void);

// *****************************************************************************
// ***    .      .   *********
// *****************************************************************************
void gfx_PutPixel(unsigned char x, unsigned char y, unsigned char color);

// *****************************************************************************
// ***       *********************************************************
// *****************************************************************************
void gfx_Line(int x1, int y1, int x2, int y2, unsigned char color);

// *****************************************************************************
// ***         ************************************************
// *****************************************************************************
void gfx_DashLine(int x1, int y1, int x2, int y2);

// *****************************************************************************
// ***        ***********************************************
// *****************************************************************************
void gfx_Rectangle(int x1, int y1, int x2, int y2, unsigned char color);

// *****************************************************************************
// ***        ***********************************
// *****************************************************************************
void gfx_FillRect(int x1, int y1, int x2, int y2, unsigned char color);

// *****************************************************************************
// ***        *****************************************
// *****************************************************************************
void gfx_SetXY(unsigned char x, unsigned char y);

// *****************************************************************************
// ***        ******************************************
// *****************************************************************************
void gfx_ChangeXY(char dX, char dY);

// *****************************************************************************
// ***       *******************************************************
// *****************************************************************************
void gfx_Char_12x16(unsigned char c, unsigned char color);

// *****************************************************************************
// ***       *******************************************************
// *****************************************************************************
void gfx_Deg_12x16(unsigned char c, unsigned char color);

// *****************************************************************************
// ***     6x4   ***************************************************
// *****************************************************************************
void gfx_Char_4x6(unsigned char c, unsigned char color);

// *****************************************************************************
// ***     8x6   ***************************************************
// *****************************************************************************
void gfx_Char_6x8(unsigned char c, unsigned char color);

// *****************************************************************************
// ***     8x8   ***************************************************
// *****************************************************************************
void gfx_Char_8x8(unsigned char c, unsigned char color);

// *****************************************************************************
// ***     12x8   **************************************************
// *****************************************************************************
void gfx_Char_8x12(unsigned char c, unsigned char color);

// *****************************************************************************
// ***       *******************************************************
// *****************************************************************************
void gfx_Char(unsigned char c, unsigned char color, FontProfile * font);

// *****************************************************************************
// ***          ***************************************
// *****************************************************************************
void gfx_Pict(unsigned char flash * p_arr, unsigned char W, unsigned char H, unsigned char X, unsigned char Y, unsigned char color);

// *****************************************************************************
// ***            *************
// *****************************************************************************
void gfx_PutStr(unsigned char * str, unsigned char color, FontProfile * font);

// *****************************************************************************
// ***            ********************
// *****************************************************************************
void gfx_PutFlashStr(unsigned char flash * str, unsigned char color, FontProfile * font);
