/*******************************************************************************
*  Hardware.c
*
*  :  
*
*       Copyright (c) 2010 Nick Shl
*           All rights reserved.
*
*
*  :
*
*  Apr 06, 2010  Nick_Shl   
*
*/// ***************************************************************************

// *****************************************************************************
// ***       ***************************************************
// *****************************************************************************
#include <mega128.h>
#include <delay.h>

// *****************************************************************************
// ***       ********************************************
// *****************************************************************************
#include "Def.h"

// *****************************************************************************
// ***       ************************************************
// *****************************************************************************
void hwl_InitPorts(void)
{
// Port A initialization
//            76543210
    PORTA = 0b00000110; // PORT - "1" enable pull-up if input
    DDRA  = 0b11111001; // DDR  - "1" output, "0" input

// Port B initialization
//            76543210
    PORTB = 0b00001111; // PORT - "1" enable pull-up if input
    DDRB  = 0b11110000; // DDR  - "1" output, "0" input

// Port C initialization
//            76543210
    PORTC = 0b00000000; // PORT - "1" enable pull-up if input
    DDRC  = 0b11111111; // DDR  - "1" output, "0" input

// Port D initialization
//            76543210
    PORTD = 0b11111111; // PORT - "1" enable pull-up if input
    DDRD  = 0b00000000; // DDR  - "1" output, "0" input

// Port E initialization
//            76543210
//  PORTE = 0b11111111; // PORT - "1" enable pull-up if input
    PORTE = 0b11111100; // FIX ME: FOR CHRON
    DDRE  = 0b00000000; // DDR  - "1" output, "0" input

// Port F initialization
//            76543210
    PORTF = 0b00000000; // PORT - "1" enable pull-up if input
    DDRF  = 0b00000000; // DDR  - "1" output, "0" input

// Port G initialization
//            76543210
    PORTG = 0b00000011; // PORT - "1" enable pull-up if input
    DDRG  = 0b11111100; // DDR  - "1" output, "0" input}
}

// *****************************************************************************
// ***       **********************************************
// *****************************************************************************
void hwl_InitTimers(void)
{
// Timer/Counter 0 initialization
// Clock source: System Clock
// Clock value: 250,000 kHz
// Mode: Fast PWM top=FFh
// OC0 output: Non-Inverted PWM
    ASSR=0x00;
    TCCR0=0x6C;
    TCNT0=0x00;
    OCR0=0x00;

// Timer/Counter 1 initialization
// Clock source: System Clock
// Clock value: System Clock/8 (1500,000 kHz at 12MHz)
// Mode: Fast PWM top=ICR1
// OC1A output: Non-Inv.
// OC1B output: Discon.
// OC1C output: Discon.
// Noise Canceler: Off
// Input Capture on Falling Edge
// Timer 1 Overflow Interrupt: Off
// Input Capture Interrupt: Off
// Compare A Match Interrupt: Off
// Compare B Match Interrupt: Off
// Compare C Match Interrupt: Off
    TCCR1A = 0x82;// 0b 1000 0010
    TCCR1B = 0x1A;// 0b 0001 1010
    TCNT1H = 0x00;
    TCNT1L = 0x00;

    ICR1H  = 0x17;//  \ 
    ICR1L  = 0x70;//  / 

    OCR1AH = TimerClockPerSec(0.0003) >> 8;  //  \ 
    OCR1AL = TimerClockPerSec(0.0003) & 0xFF;//  / 

    OCR1BH = 0x00;
    OCR1BL = 0x00;
    OCR1CH = 0x00;
    OCR1CL = 0x00;

// Timer/Counter 2 initialization
// Clock source: System Clock
// Clock value: Timer 2 Stopped
// Mode: Normal top=FFh
// OC2 output: Disconnected
    TCCR2 = 0x00;
    TCNT2 = 0x00;
    OCR2  = 0x00;

// Timer/Counter 3 initialization
// Clock source: System Clock
// Clock value: System Clock/8
// Mode: CTC top = OCR3A
// Noise Canceler: Off
// Input Capture on Falling Edge
// OC3A output: Discon.
// OC3B output: Discon.
// OC3C output: Discon.
// Timer 3 Overflow Interrupt: Off
// Input Capture Interrupt: Off
// Compare A Match Interrupt: On
// Compare B Match Interrupt: Off
// Compare C Match Interrupt: Off
    TCCR3A = 0x00;
    TCCR3B = 0x0A;
    TCNT3H = 0x00;
    TCNT3L = 0x00;
    ICR3H  = 0x00;
    ICR3L  = 0x00;
#ifdef DEBUG
    OCR3AH = MainTimerClockPerSec(0.001) >> 8;
    OCR3AL = MainTimerClockPerSec(0.001) & 0xFF;
#else
    OCR3AH = TimerClockPerSec(TASK_TICK_TIME / 1000.0) >> 8;
    OCR3AL = TimerClockPerSec(TASK_TICK_TIME / 1000.0) & 0xFF;
#endif
    OCR3BH = 0x00;
    OCR3BL = 0x00;
    OCR3CH = 0x00;
    OCR3CL = 0x00;
}

// *****************************************************************************
// ***    USART0   ************************************************
// *****************************************************************************
void hwl_InitUSART0(long BaudRate)
{
// USART0 initialization
// Communication Parameters: 8 Data, 1 Stop, No Parity
// USART0 Receiver: On
// USART0 Transmitter: On
// USART0 Mode: Asynchronous
// USART0 Baud Rate: BaudRate
    UCSR0A = 0x02;
    UCSR0B = 0xD8;
    UCSR0C = 0x06;
    UBRR0H = (unsigned char)((AVR_Clock_Freq/(BaudRate*8L)-1) >> 8);
    UBRR0L = (unsigned char)((AVR_Clock_Freq/(BaudRate*8L)-1) & 0xFF);
}

// *****************************************************************************
// ***        **************************************
// *****************************************************************************
void hwl_InitMisc(void)
{
// External Interrupt(s) initialization
// INT0: Off
// INT1: Off
// INT2: Off
// INT3: Off
// INT4: Off
// INT5: Off
// INT6: Off
// INT7: Off
    EICRA = 0x00;
    EICRB = 0x00;
    EIMSK = 0x00;

// Timer(s)/Counter(s) Interrupt(s) initialization
    TIMSK  = 0x00;
    ETIMSK = 0x00;

// Analog Comparator initialization
// Analog Comparator: Off
// Analog Comparator Input Capture by Timer/Counter 1: Off
    ACSR  = 0x80;
    SFIOR = 0x00;

// ADC initialization
// ADC Voltage Reference: AREF pin
    ADMUX  = 0x00;
    ADCSRA = 0x87; // ADC Clock frequency: Clock / 128 (125,000 kHz at 16 MHz)
//  ADCSRA = 0x86; // ADC Clock frequency: Clock / 64  (187,500 kHz at 12 MHz)
}

// *****************************************************************************
// ***          **********************************
// *****************************************************************************
inline void Sleep(void)
{
    #asm
        in   r30, mcucr      //  MCU Control Register
        cbr  r30, __sm_mask  //   SM0-SM2 (000 - Idle)
        sbr  r30, __se_bit   //  SleepEnable
        out  mcucr, r30      //  MCU Control Register
        sleep                // 
        in   r30, mcucr      //  MCU Control Register (  )
        cbr  r30, __se_bit   //   SleepEnable -   
        out  mcucr, r30      //  MCU Control Register
    #endasm
}

// *****************************************************************************
// ***       **************************************************
// *****************************************************************************
//     .   
//      -      
// .       enum    
//  AD[].   .
unsigned int read_adc(unsigned char adc_input)
{
    ADCSRA |= 0x10;              // ADIF is cleared by writing a logical one to the flag
    ADMUX = adc_input;           // Set ADC channel
    delay_us(125);               // 125 us to stabilize to the new value
    ADCSRA |= 0x40;              // Bit6 ADSC - Start the AD conversion
//    while(ADCSRA & 0x40);      // Wait for the AD conversion to complete (cleared)
    while((ADCSRA & 0x10) == 0); // Wait for the AD conversion to complete (ADIF is set)
    return ADCW;
}

#if 0
//   .  ,      ,
//   
volatile unsigned char ADC_Busy;
//     
unsigned int ADC_Data;
// *****************************************************************************
// ***       ******************************************************
// *****************************************************************************
interrupt [ADC_INT] void adc_isr(void)
{
    ADC_Data = ADCW; // Read the AD conversion result
    ADC_Busy = 0;    //    
}
// *****************************************************************************
// ***       **************************************************
// *****************************************************************************
unsigned int read_adc(unsigned char adc_input)
{
    ADC_Busy = 1;                //    
    ADMUX = adc_input;           // Set ADC channel
    delay_us(125);               // 125 us to stabilize to the new value

    //     "ADC Noise Reduction"   - 
    //  .       .
    #asm
        in   r30,mcucr
        cbr  r30,__sm_mask
        sbr  r30,__se_bit | __sm_adc_noise_red
        out  mcucr,r30
        sleep
        cbr  r30,__se_bit
        out  mcucr,r30
    #endasm
    //   ,      ,   
    while(ADC_Busy); //      - 
    return ADC_Data;
}
#endif