/*******************************************************************************
*  Demo.c
*
*  : 
*
*       Copyright (c) 2007-2009 Nick Shl, focus
*           All rights reserved.
*
*
*  :
*
*  Mar 23, 2009  Nick_Shl   
*
*/// ***************************************************************************

// *****************************************************************************
// ***       ***************************************************
// *****************************************************************************
#include <mega128.h>
#include <delay.h>
#include <stdio.h>

// *****************************************************************************
// ***       ********************************************
// *****************************************************************************
#include "Def.h"
#include "Hardware.h"
#include "Coder.h"
#include "Graphic.h"
#include "Sound.h"
#include "Variables.h"
#include "UI_Engine.h"

// *****************************************************************************
// ***       ***********************************************
// *****************************************************************************
flash unsigned int SuperMarioThemeTable[]={
0x2932, 0x0001, 0x2932, 0x0001, 0x0002, 0x0001, 0x2932, 0x0001, 0x0002, 0x0001, 0x20B2, 0x0001, 0x2932, 0x0001, 0x0002, 0x0001, 
0x30F2, 0x0001, 0x0002, 0x0001, 0x0004, 0x0001, 0x1872, 0x0001, 0x0002, 0x0001, 0x0004, 0x0001, 0x20B2, 0x0001, 0x0002, 0x0001, 
0x0002, 0x0001, 0x1872, 0x0001, 0x0004, 0x0001, 0x1492, 0x0001, 0x0002, 0x0001, 0x0002, 0x0001, 0x1B82, 0x0001, 0x0002, 0x0001, 
0x1ED2, 0x0001, 0x0002, 0x0001, 0x1D22, 0x0001, 0x1B82, 0x0001, 0x0002, 0x0001, 0x1872, 0x0001, 0x2932, 0x0001, 0x30F2, 0x0001, 
0x3702, 0x0001, 0x0002, 0x0001, 0x2BA2, 0x0001, 0x30F2, 0x0001, 0x0002, 0x0001, 0x2932, 0x0001, 0x0002, 0x0001, 0x20B2, 0x0001, 
0x24B2, 0x0001, 0x1ED2, 0x0001, 0x0004, 0x0001, 0x20B2, 0x0001, 0x0002, 0x0001, 0x0002, 0x0001, 0x1872, 0x0001, 0x0004, 0x0001, 
0x1492, 0x0001, 0x0002, 0x0001, 0x0002, 0x0001, 0x1B82, 0x0001, 0x0002, 0x0001, 0x1ED2, 0x0001, 0x0002, 0x0001, 0x1D22, 0x0001, 
0x1B82, 0x0001, 0x0002, 0x0001, 0x1872, 0x0001, 0x2932, 0x0001, 0x30F2, 0x0001, 0x3702, 0x0001, 0x0002, 0x0001, 0x2BA2, 0x0001, 
0x30F2, 0x0001, 0x0002, 0x0001, 0x2932, 0x0001, 0x0002, 0x0001, 0x20B2, 0x0001, 0x24B2, 0x0001, 0x1ED2, 0x0001, 0x0004, 0x0001, 
0x0004, 0x0001, 0x30F2, 0x0001, 0x2E42, 0x0001, 0x2BA2, 0x0001, 0x26E2, 0x0001, 0x0002, 0x0001, 0x2932, 0x0001, 0x0002, 0x0001, 
0x19F2, 0x0001, 0x1B82, 0x0001, 0x20B2, 0x0001, 0x0002, 0x0001, 0x1B82, 0x0001, 0x20B2, 0x0001, 0x24B2, 0x0001, 0x0004, 0x0001, 
0x30F2, 0x0001, 0x2E42, 0x0001, 0x2BA2, 0x0001, 0x26E2, 0x0001, 0x0002, 0x0001, 0x2932, 0x0001, 0x0002, 0x0001, 0x4162, 0x0001, 
0x0002, 0x0001, 0x4162, 0x0001, 0x4162, 0x0001, 0x0002, 0x0001, 0x0004, 0x0001, 0x0004, 0x0001, 0x30F2, 0x0001, 0x2E42, 0x0001, 
0x2BA2, 0x0001, 0x26E2, 0x0001, 0x0002, 0x0001, 0x2932, 0x0001, 0x0002, 0x0001, 0x19F2, 0x0001, 0x1B82, 0x0001, 0x20B2, 0x0001, 
0x0002, 0x0001, 0x1B82, 0x0001, 0x20B2, 0x0001, 0x24B2, 0x0001, 0x0004, 0x0001, 0x26E2, 0x0001, 0x0002, 0x0001, 0x0002, 0x0001, 
0x24B2, 0x0001, 0x0004, 0x0001, 0x20B2, 0x0001, 0x0002, 0x0001, 0x0004, 0x0001, 0x0009, 0x0001, 0x20B2, 0x0001, 0x20B2, 0x0001, 
0x0002, 0x0001, 0x20B2, 0x0001, 0x0002, 0x0001, 0x20B2, 0x0001, 0x24B2, 0x0001, 0x0002, 0x0001, 0x2932, 0x0001, 0x20B2, 0x0001, 
0x0002, 0x0001, 0x1B82, 0x0001, 0x1872, 0x0001, 0x0002, 0x0001, 0x0004, 0x0001, 0x20B2, 0x0001, 0x20B2, 0x0001, 0x0002, 0x0001, 
0x20B2, 0x0001, 0x0002, 0x0001, 0x20B2, 0x0001, 0x24B2, 0x0001, 0x2932, 0x0001, 0x0009, 0x0001, 0x0009, 0x0001, 0x20B2, 0x0001, 
0x20B2, 0x0001, 0x0002, 0x0001, 0x20B2, 0x0001, 0x0002, 0x0001, 0x20B2, 0x0001, 0x24B2, 0x0001, 0x0002, 0x0001, 0x2932, 0x0001, 
0x20B2, 0x0001, 0x0002, 0x0001, 0x1B82, 0x0001, 0x1872, 0x0001, 0x0002, 0x0001, 0x0004, 0x0001, 0x2932, 0x0001, 0x2932, 0x0001, 
0x0002, 0x0001, 0x2932, 0x0001, 0x0002, 0x0001, 0x20B2, 0x0001, 0x2932, 0x0001, 0x0002, 0x0001, 0x30F2, 0x0001, 0x0002, 0x0001, 
0x0004, 0x0001, 0x1872, 0x0001, 0x0002, 0x0001, 0x0004, 0x0001, 0x20B2, 0x0001, 0x0002, 0x0001, 0x0002, 0x0001, 0x1872, 0x0001, 
0x0004, 0x0001, 0x1492, 0x0001, 0x0002, 0x0001, 0x0002, 0x0001, 0x1B82, 0x0001, 0x0002, 0x0001, 0x1ED2, 0x0001, 0x0002, 0x0001, 
0x1D22, 0x0001, 0x1B82, 0x0001, 0x0002, 0x0001, 0x1872, 0x0001, 0x2932, 0x0001, 0x30F2, 0x0001, 0x3702, 0x0001, 0x0002, 0x0001, 
0x2BA2, 0x0001, 0x30F2, 0x0001, 0x0002, 0x0001, 0x2932, 0x0001, 0x0002, 0x0001, 0x20B2, 0x0001, 0x24B2, 0x0001, 0x1ED2, 0x0001, 
0x0004, 0x0001, 0x20B2, 0x0001, 0x0002, 0x0001, 0x0002, 0x0001, 0x1872, 0x0001, 0x0004, 0x0001, 0x1492, 0x0001, 0x0002, 0x0001, 
0x0002, 0x0001, 0x1B82, 0x0001, 0x0002, 0x0001, 0x1ED2, 0x0001, 0x0002, 0x0001, 0x1D22, 0x0001, 0x1B82, 0x0001, 0x0002, 0x0001, 
0x1872, 0x0001, 0x2932, 0x0001, 0x30F2, 0x0001, 0x3702, 0x0001, 0x0002, 0x0001, 0x2BA2, 0x0001, 0x30F2, 0x0001, 0x0002, 0x0001, 
0x2932, 0x0001, 0x0002, 0x0001, 0x20B2, 0x0001, 0x24B2, 0x0001, 0x1ED2, 0x0001, 0x0004, 0x0001, 0x2932, 0x0001, 0x20B2, 0x0001, 
0x0002, 0x0001, 0x1872, 0x0001, 0x0004, 0x0001, 0x19F2, 0x0001, 0x0002, 0x0001, 0x1B82, 0x0001, 0x2BA2, 0x0001, 0x0002, 0x0001, 
0x2BA2, 0x0001, 0x1B82, 0x0001, 0x0002, 0x0001, 0x0004, 0x0001, 0x1ED3, 0x0001, 0x3703, 0x0001, 0x3703, 0x0001, 0x3703, 0x0001, 
0x30F3, 0x0001, 0x2BA3, 0x0001, 0x2932, 0x0001, 0x20B2, 0x0001, 0x0002, 0x0001, 0x1B82, 0x0001, 0x1872, 0x0001, 0x0002, 0x0001, 
0x0004, 0x0001, 0x2932, 0x0001, 0x20B2, 0x0001, 0x0002, 0x0001, 0x1872, 0x0001, 0x0004, 0x0001, 0x19F2, 0x0001, 0x0002, 0x0001, 
0x1B82, 0x0001, 0x2BA2, 0x0001, 0x0002, 0x0001, 0x2BA2, 0x0001, 0x1B82, 0x0001, 0x0002, 0x0001, 0x0004, 0x0001, 0x1ED2, 0x0001, 
0x2BA2, 0x0001, 0x0002, 0x0001, 0x2BA2, 0x0001, 0x2BA3, 0x0001, 0x2933, 0x0001, 0x24B3, 0x0001, 0x20B2, 0x0001, 0x1492, 0x0001, 
0x0002, 0x0001, 0x1492, 0x0001, 0x1052, 0x0001, 0x0002, 0x0001, 0x0004, 0x0001, 0x0001};

flash unsigned int UnderwolrdThemeTable[]={
0x1062, 0x0001, 0x20B2, 0x0001, 0x0DC2, 0x0001, 0x1B82, 0x0001, 0x0E92, 0x0001, 0x1D22, 0x0001, 0x0004, 0x0001, 0x0008, 0x0001, 
0x1062, 0x0001, 0x20B2, 0x0001, 0x0DC2, 0x0001, 0x1B82, 0x0001, 0x0E92, 0x0001, 0x1D22, 0x0001, 0x0004, 0x0001, 0x0008, 0x0001, 
0x0AF2, 0x0001, 0x15D2, 0x0001, 0x0932, 0x0001, 0x1262, 0x0001, 0x09C2, 0x0001, 0x1372, 0x0001, 0x0004, 0x0001, 0x0008, 0x0001, 
0x0AF2, 0x0001, 0x15D2, 0x0001, 0x0932, 0x0001, 0x1262, 0x0001, 0x09C2, 0x0001, 0x1372, 0x0001, 0x0004, 0x0001, 0x0004, 0x0001, 
0x1371, 0x0001, 0x1151, 0x0001, 0x1261, 0x0001, 0x1154, 0x0001, 0x1374, 0x0001, 0x1374, 0x0001, 0x0D04, 0x0001, 0x0C44, 0x0001, 
0x1154, 0x0001, 0x1061, 0x0001, 0x1721, 0x0001, 0x15D1, 0x0001, 0x0A51, 0x0001, 0x1D21, 0x0001, 0x1B81, 0x0001, 0x19F2, 0x0001, 
0x1372, 0x0001, 0x0F72, 0x0001, 0x0E92, 0x0001, 0x0DC2, 0x0001, 0x0D02, 0x0001, 0x0008, 0x0001, 0x0008, 0x0001, 0x0008, 0x0001}; 


// *****************************************************************************
// ***      ****************************************************************
// *****************************************************************************
void PlayMusic(char AddParam)
{
    flash char * name;
    flash unsigned int * MusicTable;
    unsigned int MusicTableSize;

    if(AddParam == 0)
    {
        MusicTable = SuperMarioThemeTable;
        MusicTableSize = NumberOf(SuperMarioThemeTable);
        name = "Super Mario Theme";
    }
    else
    {
        MusicTable = UnderwolrdThemeTable;
        MusicTableSize = NumberOf(UnderwolrdThemeTable);
        name = "Underwolrd Theme";
    }

    Settings.SoundFlag = ON;

    gfx_ClearBuf();
    gfx_SetXY((WidthS - Font_8x12.W*8) >> 1, (HeightS - Font_8x12.H) >> 1);
    gfx_PutFlashStr(name, 0xFF, &Font_8x12);

    PlaySound(MusicTable, MusicTableSize);

    while(IsSoundPlayed() == TRUE)
    {
        if(HB_UP || HB_DOWN || HB_LEFT || HB_RIGHT || HB_ENTER) break;
    }

    StopSound();

    gfx_ClearBuf();
}

// *****************************************************************************
// ***    "Music"   ********************************************************
// *****************************************************************************

// ***       *********************************************************
flash MenuButton MusicMenuButtons[] =
{{"Start Mario Theme",      PlayMusic, NULL, 0},
 {"Start Underworld Theme", PlayMusic, NULL, 1}};

// ***       ********************************************************
void MusicMenu(char AddParam)
{
    //   
    MenuPad Pad = {"Music", &Font_8x12, &Font_6x8, MusicMenuButtons, NumberOf(MusicMenuButtons), 0, NULL, NULL};
    //   
    MenuCycle(&Pad);
}