/*******************************************************************************
*  System.h
*
*  :  , 
*
*       Copyright (c) 2009 Nick Shl
*           All rights reserved.
*
*
*  :
*
*  Mar 25, 2009  Nick_Shl   
*
*/// ***************************************************************************

// *****************************************************************************
// ***    CRC EEPROM   **************************************************
// *****************************************************************************
inline unsigned short Get_EEPROM_CRC(void);

// *****************************************************************************
// ***     CRC EEPROM   ************************************
// *****************************************************************************
inline unsigned char Is_EEPROM_CRC_Correct(void);

// *****************************************************************************
// ***          EEPROM   ********
// *****************************************************************************
void TX_Init(void);

// *****************************************************************************
// ***       EEPROM   ****************************
// *****************************************************************************
void TX_SaveSettings(void);

// *****************************************************************************
// ***       *************************************************
// *****************************************************************************
void TX_SetModulation(char Modulation);

// *****************************************************************************
// ***      EEPROM   *******************************************
// *****************************************************************************
void MODEL_Init(char ModelNum);

// *****************************************************************************
// ***        EEPROM   ************************
// *****************************************************************************
void MODEL_Save_Trimmers(void);

// *****************************************************************************
// ***      EEPROM   ******************************************
// *****************************************************************************
void MODEL_Save(char To);

// *****************************************************************************
// ***       **************************************************
// *****************************************************************************
void MODEL_Copy(char From, char To);

// *****************************************************************************
// ***        ****************************************
// *****************************************************************************
void MODE_Copy(char From, char To);

// *****************************************************************************
// ***          *********************************
// *****************************************************************************
void MODEL_Reset(char ModelNum);

// *****************************************************************************
// ***      **********************************************************
// *****************************************************************************
void Calibration(void);

// *****************************************************************************
// ***           *******************************
// *****************************************************************************
void TX_Reset(void);

