/*******************************************************************************
*  Tasks.c
*
*  :   
*
*       Copyright (c) 2009 Nick Shl
*           All rights reserved.
*
*
*  :
*
*  Mar 25, 2009  Nick_Shl   
*
*/// ***************************************************************************
#include <mega128.h>
#include <delay.h>
#include <stdio.h>

#include "Def.h"
#include "Tasks.h"
#include "Coder.h"
#include "Sound.h"
#include "System.h"
#include "Variables.h"

// *****************************************************************************
// *****************************************************************************
// ***       ************************************************
// *****************************************************************************
// *****************************************************************************

static unsigned char NeedSaveTrimmers = FALSE;
static unsigned long TimeToTrimmersSave;

// *****************************************************************************
// ***          ***************
// *****************************************************************************
// Time -   100  ,     
inline void Trimmers_Need_Save(unsigned char Time)
{
    NeedSaveTrimmers = TRUE;
    TimeToTrimmersSave = GetRunningTime() + (unsigned long)Time * 100;
}

// *****************************************************************************
// ***        *****************************************
// *****************************************************************************
void Trimmers_Save_Task(unsigned char MissedInterruptsCount)
{
    //        - 
    if(NeedSaveTrimmers == FALSE) return;
    //        - 
    if(TimeToTrimmersSave > GetRunningTime()) return;

    //     
    NeedSaveTrimmers = FALSE;
    //   
    MODEL_Save_Trimmers();

#ifdef DEBUG
        printf("Trimmers_Save_Task(): Trimmers saved, MissedInterruptsCount = %d\r", MissedInterruptsCount);
        delay_ms(1);
#endif
/*
    //   
    char i, j;
    //      CRC
    //  -    
    static unsigned int OldTrimsCRC;
    //    CRC
    unsigned int NewTrimsCRC = 0;
    //    CRC
    unsigned long LastTrimsChangeTime = 0;
    static char Fly_Mode = 0, Model_Num = 0;

    //  CRC  
    for(i=0; i < FLY_MODES; i++)
    {
        NewTrimsCRC += Crc16_ram((unsigned char *)CurModel.Mode[i].trimmers, sizeof(CurModel.Mode[i].trimmers));
    }

    //  CRC 
    if(OldTrimsCRC != NewTrimsCRC)
    {
        //   CRC
        OldTrimsCRC = NewTrimsCRC;
        LastTrimsChangeTime = GetRunningTime();
        return;
    }

    if(LastTrimsChangeTime + 5000 > GetRunningTime()) return;

    for(i=0; i < FLY_MODES; i++)
    {
        NewTrimsCRC += Crc16_ram((unsigned char *)CurModel.Mode[i].trimmers, sizeof(CurModel.Mode[i].trimmers));
    }

    for(i=0; i < FLY_MODES; i++)
    {
        for(j=0; j < MAX_TRIMMERS; j++)
        {
            EEPROM_MODEL[Settings.ModelNum].Mode[i].trimmers[j] = CurModel.Mode[i].trimmers[j];
        }
    }
*/
}

// *****************************************************************************
// *****************************************************************************
// ***      **********************************************************
// *****************************************************************************
// *****************************************************************************

// *****************************************************************************
// ***     -  !                 *********
// ***    AskButtons()    !   *********
// *****************************************************************************
static unsigned char KbdStat = 0;

// *****************************************************************************
// ***       **************************************************
// *****************************************************************************
void Keyboard_Driver_Task(unsigned char MissedInterruptsCount)
{
    unsigned char NewKbdStat = 0;
    static unsigned char OldKbdStat = 0;

    //       
    if(HB_UP)    NewKbdStat |= B_UP;
    if(HB_DOWN)  NewKbdStat |= B_DOWN;
    if(HB_LEFT)  NewKbdStat |= B_LEFT;
    if(HB_RIGHT) NewKbdStat |= B_RIGHT;
    if(HB_BACK)  NewKbdStat |= B_BACK;
    if(HB_ENTER) NewKbdStat |= B_ENTER;

    //     -  
    if(NewKbdStat != OldKbdStat)
    {
        OldKbdStat = NewKbdStat;
    }
    //   ,     -   .
    else if(NewKbdStat != KbdStat)
    {
        KbdStat = NewKbdStat;
#ifdef DEBUG
        printf("Keyboard_Driver_Task(): New Status: KbdStat = 0x%02X, MissedInterruptsCount = %d\r", KbdStat, MissedInterruptsCount);
        delay_ms(1);
#endif
    }
}

// *****************************************************************************
// ***         *************************************
// *****************************************************************************
// Delay  10  
void WaitEmptyButtons(unsigned char Delay)
{
#ifdef DEBUG
    printf("WaitEmptyButtons(%d);\r", Delay);
    delay_ms(1);
#endif
    //   0 -     
    if(Delay == 0) {while(KbdStat) {};}
    //      ,  
    else
    {
        while(KbdStat)
        {
            delay_ms(10);
            Delay--;
            if(Delay == 0) break;
        };
    }

}

// *****************************************************************************
// ***        *********************************************
// *****************************************************************************
unsigned char WaitButtonPress(unsigned char mask)
{
    static char PREV_FLY_MODE = 0;

#ifdef DEBUG
    printf("WaitButtonPress(0x%02X);\r", mask);
    delay_ms(1);
#endif

    //   
    if(mask)
    {
        //        
        while(!(KbdStat & mask));
    }
    // 
    else
    {
        //     
        while(!(KbdStat))
        {
            //        
            if(PREV_FLY_MODE != FLY_MODE)
            {
                PREV_FLY_MODE = FLY_MODE;
                break;
            }
        };
    }
    return(KbdStat);
}

// *****************************************************************************
// ***         *****************************
// *****************************************************************************
inline unsigned char AskButtons(void)
{
#ifdef DEBUG
//        -   
//    printf("AskButtons(): KbdStat = 0x%02X\r", KbdStat);
//    delay_ms(1);
#endif
    return(KbdStat);
}



// *****************************************************************************
// *****************************************************************************
// ***      **************************************************************
// *****************************************************************************
// *****************************************************************************

//   
static int TimerValue;
//   (    -  20 )
static int TimerSubValue;
//  
static unsigned char CountingFlag;
//   
static unsigned char TimerSound;

// *****************************************************************************
// ***        *********************************************
// *****************************************************************************
void Timer_Task(unsigned char MissedInterruptsCount)
{
    //       
    static unsigned char counter;
    static unsigned char precounter;

    //   
    if(CountingFlag == ON)
    {
        //   :    + 
        TimerSubValue += (int)MissedInterruptsCount + 1;

        //     50(   ) -  1 
        if(TimerSubValue >= 50)
        {
            //  50(   ) - 1 
            TimerSubValue -= 50;
            //   ,     
            if(CurModel.timer_mode & 0x02) TimerValue--; // Timer Mode DOWN
            else                           TimerValue++; // Timer Mode UP
#ifdef DEBUG
            printf("Timer_Task(): New Time: time = %d, MissedInterruptsCount = %d\r", TimerValue, MissedInterruptsCount);
            delay_ms(1);
#endif
        }

        //    ,    ,        0
        if((CurModel.timer_mode & 0x01) && (TimerValue == CurModel.timer) && (CountingFlag == ON) && (TimerValue != 0))
        {
            //   
            TimerSound = ON;

            //      
            counter = 0;
            precounter = 0;
        }

        //    ,    0   
        if((CurModel.timer_mode & 0x02) && (TimerValue == 0) && (CountingFlag == ON))
        {
            //   
            CountingFlag = OFF;
            //     
            TimerValue = CurModel.timer;
            TimerSubValue = 0;

            //   
            TimerSound = ON;

            //      
            counter = 0;
            precounter = 0;
        }
    }

    //  
    if(TimerSound == ON)
    {
        if(precounter == 20 || precounter == 0)
        {
            precounter = 0;
            counter++;
            if(counter%2 == 0) Tone(1000); //  
            else               Tone(0);    //  
        }
        if(counter == 25) TimerSound = OFF;
        precounter++;
    }
}

// *****************************************************************************
// ***           **********************
// *****************************************************************************
inline int GetTimerValue(void)
{
    return(TimerValue);
}
inline int GetTimerSubValue(void)
{
    return(TimerSubValue * TASK_TICK_TIME);
}

// *****************************************************************************
// ***      ************************************************
// *****************************************************************************
void Timer_Init(void)
{
    //        
    if(CurModel.timer_mode & 0x02) TimerValue = CurModel.timer; // Timer Mode DOWN
    else                           TimerValue = 0;              // Timer Mode UP
    TimerSubValue = 0;

    CountingFlag = Off;
    TimerSound = Off;
}

// *****************************************************************************
// ***      *******************************************************
// *****************************************************************************
inline void Timer_Start(void)
{
    CountingFlag = On;
}

// *****************************************************************************
// ***      ******************************************************
// *****************************************************************************
inline void Timer_Stop(void)
{
    CountingFlag = Off;
}

// *****************************************************************************
// ***       (/)   ****************
// *****************************************************************************
inline unsigned char GetTimerSoundStatus(void)
{
    return(TimerSound);
}

// *****************************************************************************
// ***        **********************************************
// *****************************************************************************
inline void TimerSoundOff(void)
{
    TimerSound = Off;
}



// *****************************************************************************
// *****************************************************************************
// ***      *************************************************************
// *****************************************************************************
// *****************************************************************************

// *****************************************************************************
// ***      -  !                   ******
// ***    GetBattaryStatus()    !   ******
// *****************************************************************************
static signed int U_Bat = 0;

// *****************************************************************************
// ***       *****************************************************
// *****************************************************************************
void Battery_Driver_Task(unsigned char MissedInterruptsCount)
{
    //       
    U_Bat = AD[ADC_BAT] * 2;
}

// *****************************************************************************
// ***         ************************************
// *****************************************************************************
inline signed int GetBatteryStatus(void)
{
    return(U_Bat);
}
