/*******************************************************************************
*  UI_Engine.c
*
*  :   
*
*       Copyright (c) 2009 Nick Shl
*           All rights reserved.
*
*
*  :
*
*  Mar 25, 2009  Nick_Shl   
*
*/// ***************************************************************************
#include <mega128.h>
#include <delay.h>
#include <stdio.h>
#include <string.h>

#include "Def.h"
#include "Coder.h"
#include "Graphic.h"
#include "Variables.h"
#include "Tasks.h"
#include "System.h"
#include "UI_Engine.h"

// *****************************************************************************
// ***        ***************************************************
// *****************************************************************************
void MenuCycle(MenuPad * Menu)
{
    int i;
    unsigned char Color;
    unsigned char MenuHeaderH = 0;
    unsigned char StartPos = 0;
    unsigned char MenuCount = 0;
    unsigned char Kbd = 0;
    unsigned char ScrollHeight = 0;
    unsigned char ScrollBarHeight = 0;
    unsigned char ScrollBarWidth = 0;
    unsigned char ScrollBarStart = 0;
    unsigned char strLen;
    unsigned char bufLen;
    FontProfile * CaptionFont = Menu->CaptionFont;
    FontProfile * MenuFont = Menu->MenuFont;

#ifdef DEBUG
    printf("MenuCycle();\r");
    delay_ms(1);
#endif

    // 
    if(Menu == NULL) return;          //      - 
    if(Menu->Buttons == NULL) return; //      - 
    if(Menu->ButtonsNum == 0) return; //      0 - 
    if(CaptionFont == NULL) CaptionFont = &Font_8x12; //      -   
    if(MenuFont == NULL) MenuFont = &Font_6x8;        //      -   

    MenuHeaderH = Font_8x8.H + CaptionFont->H;

    //    ,   
    MenuCount = (HeightS - MenuHeaderH - 3) / MenuFont->H;
    //          - 
    if(MenuCount > Menu->ButtonsNum) MenuCount = Menu->ButtonsNum;

    //   :   -   
    ScrollHeight = HeightS - (MenuHeaderH + 2 + 2);

    //    :
    // (    *   ) /   
    ScrollBarHeight = ((unsigned int)MenuCount * ScrollHeight) / Menu->ButtonsNum;
    //        -   
    if(ScrollBarHeight > ScrollHeight/2)
    {
         ScrollBarHeight = ScrollHeight/2;
    }

    //    :
    ScrollBarWidth = 4;//MenuFont->W - 2;

    do{
        //  
        gfx_ClearBuf();

        //   
        gfx_SetXY(0, Font_8x8.H);
        gfx_PutFlashStr(Menu->CaptionStr, 0xFF, CaptionFont);
        gfx_DashLine(0, MenuHeaderH, WidthS, MenuHeaderH);

        //       -  - 
        if(Menu->Before != NULL) Menu->Before();

        do
        {
            //       ,   
            gfx_FillRect(0, 0, WidthS - 1, Font_8x8.H, 0x00);

            gfx_SetXY(0, 0);
            //  
            sprintf(tmpBuf, "%d", Settings.ModelNum + 1);
            gfx_PutStr(tmpBuf, 0xFF, &Font_8x8);
            //     4 
            gfx_ChangeXY(3, 0);
            //  
            if(CurModel.type == TYPE_HELI)
            {
                gfx_Char(125, 0xFF, &Font_8x8);
                gfx_Char(126, 0xFF, &Font_8x8);
            }
            //  
            if(CurModel.type == TYPE_PLANE)
            {
                gfx_Char(127, 0xFF, &Font_8x8);
                gfx_Char(128, 0xFF, &Font_8x8);
            }
            //     4 
            gfx_ChangeXY(3, 0);
            //  
            gfx_PutStr(CurModel.Mode[FLY_MODE].name, 0xFF, &Font_6x8);

            //     :
            //    + (    *     ) /   
            ScrollBarStart = MenuHeaderH + 2 + 1 + (Menu->CurrentPos * (unsigned int)(ScrollHeight - ScrollBarHeight)) / (Menu->ButtonsNum - 1);
            //          ,
            // ..        
            if(Menu->CurrentPos == Menu->ButtonsNum - 1)
            {
                ScrollBarStart = ScrollHeight - ScrollBarHeight + MenuHeaderH + 2 + 1;
            }

            //     
            gfx_FillRect(0, MenuHeaderH + 2, ScrollBarWidth - 1, HeightS - 1, 0x00);
            //   
            gfx_Rectangle(0, MenuHeaderH + 2, ScrollBarWidth - 1, HeightS - 1, 0xFF);
            //    
            gfx_FillRect(0, ScrollBarStart, ScrollBarWidth - 1, ScrollBarStart + ScrollBarHeight, 0xFF);

            //   
            for(i = StartPos; i < StartPos + MenuCount; i++)
            {
                //     
                strLen = (WidthS - (ScrollBarWidth + 2)) / MenuFont->W;

                //    
                memset(tmpStr, ' ', sizeof(tmpStr));

                //     . 
                if(Menu->Buttons[i].GetStr != NULL)
                {
                    //  .   
                    Menu->Buttons[i].GetStr(tmpBuf, Menu->Buttons[i].AddParam);
                    //   
                    bufLen = strlen(tmpBuf);
                    //          - 
                    if(bufLen > strLen) bufLen = strLen;
                    //  .    ,     
                    strcpy(tmpStr + (strLen - bufLen), tmpBuf);
                }

                //         
                strcpyf(tmpStr, Menu->Buttons[i].str);
                //          -    
                if(strlen(tmpStr) < strLen) tmpStr[strlen(tmpStr)] = ' ';
                //     (         )
                tmpStr[strLen] = '\0';

                //   
                gfx_SetXY(ScrollBarWidth + 2, MenuFont->H * (i - StartPos) + MenuHeaderH + 2);
                //   -    
                if(Menu->CurrentPos == i) Color = 0x00;
                else                      Color = 0xFF;
                //  
                gfx_PutStr(tmpStr, Color, MenuFont);
            }
            //  
            gfx_Refresh();

            //   
            WaitEmptyButtons(0);
            //   
            Kbd = WaitButtonPress(0);

            //   ,     
            if((Kbd & B_UP)   && (Menu->CurrentPos > 0))                    Menu->CurrentPos--;
            if((Kbd & B_DOWN) && (Menu->CurrentPos < Menu->ButtonsNum - 1)) Menu->CurrentPos++;

            //       -     
            if(Menu->CurrentPos < StartPos)                 StartPos--;
            if(Menu->CurrentPos > StartPos + MenuCount - 1) StartPos++;
        }
        while(!(Kbd & (B_BACK | B_ENTER)));

        //       -  - 
        if(Menu->After != NULL) Menu->After();

        //         
        if((Kbd & B_ENTER) && (Menu->Buttons[Menu->CurrentPos].fun != NULL))
        {
            //   
            WaitEmptyButtons(0);
            //   
            Menu->Buttons[Menu->CurrentPos].fun(Menu->Buttons[Menu->CurrentPos].AddParam);
        }
    }
    while(!(Kbd & B_BACK));

    //   
    WaitEmptyButtons(0);
}

// *****************************************************************************
// ***        ********************************************
// *****************************************************************************
// FIX ME:     
void MsgBoxStrEx(StringType * Strings, unsigned char N,
                 char flash * Header, FontProfile * HeaderFont,
                 unsigned char CenterX, unsigned char CenterY,
                 unsigned char Width, unsigned char Color)  // Width in chars
{
    //   
	unsigned char i;
    //     
    unsigned char X, Y, W = 0, H = 0, y, StrW, StrCount;
    //     
    unsigned char FontH = 0, FontW = 0;
    //  
	char * p;
    //   
	unsigned char count = 0;

#ifdef DEBUG
    printf("MsgBoxStrEx(%d);\r", N);
    delay_ms(1);
#endif

    // 
    if(Strings == NULL) return;                       //      - 
    if(HeaderFont == NULL) HeaderFont = &Font_4x6; //     -   

    //       
	for(i = 0; i < N; i++)
	{
        if(Strings[i].Str != NULL)
        {
            //      strlen
                 if(Strings[i].StrPtrType == PTR_FLASH) Strings[i].Len = strlenf((char flash *)Strings[i].Str);
            else if(Strings[i].StrPtrType == PTR_SRAM ) Strings[i].Len = strlen((char *)Strings[i].Str);
        }
        else
        {
            Strings[i].Len = 0;
        }

        //       -   
        if(Strings[i].StrFont == NULL) Strings[i].StrFont = &Font_8x12;

        //     
        StrW = Strings[i].StrFont->W * Strings[i].Len;
        //       -  
		if(W < StrW) W = StrW;
        //   
        H += Strings[i].StrFont->H + Strings[i].VSpace;

        if(FontH < Strings[i].StrFont->H) FontH = Strings[i].StrFont->H;
        if(FontW < Strings[i].StrFont->W) FontW = Strings[i].StrFont->W;
	}

    if(Header != NULL)
    {
        //     
        StrW = HeaderFont->W * strlenf(Header);
        //        -  
		if(W < StrW) W = StrW;
    }

    //      -  
    if(W < FontW * Width) W = FontW * Width;

    //    (           0.5 )
	H += FontH;
    //            1 
	W += FontW * 2;

    //      
	X = CenterX - W / 2;
    //      
    Y = CenterY - H / 2;

    // ,  
    if(Header != NULL)
    {
        //       
        Y += HeaderFont->H / 2;
        //    
        gfx_Rectangle(X - 1, Y - HeaderFont->H - 2, X + W + 1, Y + 1, 0x00);
        //    
    	gfx_FillRect(X, Y - HeaderFont->H - 1, X + W, Y, 0xFF);
        //    
        gfx_SetXY(X + 1, Y - HeaderFont->H);
        //  
        gfx_PutFlashStr(Header, 0x00, HeaderFont);
    }

    //     .    
    //  1 ,        
	gfx_FillRect(X - 1, Y, X + W + 1, Y + H + 1, 0x00);
    //     
	gfx_Rectangle(X, Y, X + W, Y + H, 0xFF);

    //    y, ..      
    y = Y + FontH/2;
    //        
	for(i=0; i < N; i++)
	{
        //     X   
        X = CenterX - (Strings[i].StrFont->W * Strings[i].Len) / 2;
        //    
        gfx_SetXY(X, y);

        if(Strings[i].Str != NULL)
        {
             //  
             if(Strings[i].StrPtrType == PTR_FLASH) gfx_PutFlashStr((flash char *)Strings[i].Str, Strings[i].Color, Strings[i].StrFont);
        else if(Strings[i].StrPtrType == PTR_SRAM ) gfx_PutStr((char *)Strings[i].Str, Strings[i].Color, Strings[i].StrFont);
        }

        //   y   
        y += Strings[i].StrFont->H + Strings[i].VSpace;
	}

    //    
    gfx_Refresh();
}

// *****************************************************************************
// ***        ********************************************
// *****************************************************************************
#define MsgBox__MaxLines 5
void MsgBoxEx(void * Body, char BodyPtrType, FontProfile * BodyFont,
              char flash * Header, FontProfile * HeaderFont,
              unsigned char CenterX, unsigned char CenterY,
              unsigned char Width, unsigned char Color)  // Width in chars
{
    //   
	unsigned char i;
    //     
    unsigned char X, Y, W, H, StrW;
    //  
	char * p;
    //    
	char * line[MsgBox__MaxLines];
    //   
	unsigned char length[MsgBox__MaxLines];
    //   
	unsigned char count = 0;

#ifdef DEBUG
    printf("MsgBoxEx();\r");
    delay_ms(1);
#endif

    // 
    if(Body == NULL) return;                       //      - 
    if(BodyFont == NULL) BodyFont = &Font_8x12;    //     -   
    if(HeaderFont == NULL) HeaderFont = &Font_4x6; //     -   

    //    ,     
         if(BodyPtrType == PTR_FLASH) strcpyf(tmpStr, (char flash *)Body);
    else if(BodyPtrType == PTR_SRAM ) strcpy( tmpStr,       (char *)Body);

    //      
	line[count] = tmpStr;

    //   
    H = 0;
    //   
    W = BodyFont->W * Width;

    //       
	for(;count < MsgBox__MaxLines;)
	{
        //   p         '\n'
        p = strchr(line[count], '\n');

        //       
        if(p == NULL)
        {
            //      strlen
        	length[count] = strlen(line[count]);
        }
        else // 
        {
            //      
    		length[count] = p - line[count];
            //    '\n'  '\0',    
	    	*p = '\0';
        }

        //     
        StrW = BodyFont->W * length[count];
        //       -  
		if(W < StrW) W = StrW;
        //   
		H += BodyFont->H;

        //   '\n'    -    -   
        if(p == NULL) break;

        //   
        count++;
        //      
        line[count] = p + 1;
	}

    if(Header != NULL)
    {
        //     
        StrW = HeaderFont->W * strlenf(Header);
        //        -  
		if(W < StrW) W = StrW;
    }

    //            1 
	W += BodyFont->W * 2;
    //            0.5 
	H += BodyFont->H;

    //      
	X = CenterX - W / 2;
    //      
    Y = CenterY - H / 2;

    // ,  
    if(Header != NULL)
    {
        //       
        Y += HeaderFont->H / 2;
        //    
        gfx_Rectangle(X - 1, Y - HeaderFont->H - 2, X + W + 1, Y + 1, 0x00);
        //    
    	gfx_FillRect(X, Y - HeaderFont->H - 1, X + W, Y, 0xFF);
        //    
        gfx_SetXY(X + 1, Y - HeaderFont->H);
        //  
        gfx_PutFlashStr(Header, 0x00, HeaderFont);
    }

    //     .    
    //  1 ,        
	gfx_FillRect(X - 1, Y, X + W + 1, Y + H + 1, 0x00);
    //     
	gfx_Rectangle(X, Y, X + W, Y + H, 0xFF);

    //        
	for(i=0; i < count + 1; i++)
	{
        //     0 -   
		if(length[i] != 0)
		{
            //     X   
            X = CenterX - (BodyFont->W * length[i]) / 2;
            //    
            gfx_SetXY(X, Y + BodyFont->H/2 + i * BodyFont->H);
            //  
			gfx_PutStr(line[i], Color, BodyFont);
		}
	}

    //    
    gfx_Refresh();
}

// *****************************************************************************
// ***         (  FLASH)   *********
// *****************************************************************************
inline void MsgBoxF(char flash * Body, FontProfile * BodyFont, char flash * Header, FontProfile * HeaderFont)
{
    MsgBoxEx((void *)Body, PTR_FLASH, BodyFont, Header, HeaderFont, WidthS/2, HeightS/2, 0, 0xFF);
}

// *****************************************************************************
// ***         (  SRAM)  ************
// *****************************************************************************
inline void MsgBox(char * Body, FontProfile * BodyFont, char flash * Header, FontProfile * HeaderFont)
{
    MsgBoxEx((void *)Body, PTR_SRAM, BodyFont, Header, HeaderFont, WidthS/2, HeightS/2, 0, 0xFF);
}

// *****************************************************************************
// ***         ***********************************************
// *****************************************************************************
char SelectBoxEx(void ** Body, unsigned char BodyPtrType, unsigned char N, unsigned char Selected, FontProfile * BodyFont,
                 char flash * Header, FontProfile * HeaderFont,
                 unsigned char CenterX, unsigned char CenterY)
{
    //   
	unsigned char i;
    //     
    unsigned char Color;

    unsigned char Pos = 0;
    unsigned char StrCount = 0;
    //     
    unsigned char X, Y, W, H, x, strLen, StrW;
    //     
    unsigned char Kbd = 0;

#ifdef DEBUG
    printf("SelectBoxEx();\r");
    delay_ms(1);
#endif

    // 
    if(Body == NULL) return;                       //      - 
    if(BodyFont == NULL) BodyFont = &Font_8x12;    //     -   
    if(HeaderFont == NULL) HeaderFont = &Font_4x6; //     -   

    //     
    W = 0;
    H = 0;

    StrCount = (HeightS - HeaderFont->H - BodyFont->H / 2) / BodyFont->H;

    //       
	for(i = 0; i < N; i++)
	{
        //      strlen
             if(BodyPtrType == PTR_FLASH) strLen = strlenf(((char flash **)Body)[i]);
        else if(BodyPtrType == PTR_SRAM ) strLen = strlen(((char **)Body)[i]);

        //     
        StrW = BodyFont->W * strLen;
        //       -  
		if(W < StrW) W = StrW;
        //   
		if(i < StrCount) H += BodyFont->H;
	}

    if(StrCount > N) StrCount = N;

    if(Header != NULL)
    {
        //     
        StrW = HeaderFont->W * strlenf(Header);
        //        -  
		if(W < StrW) W = StrW;
    }

    //            1 
	W += BodyFont->W * 2;
    //            0.25 
	H += BodyFont->H / 2;

    //      
	X = CenterX - W / 2;
    //      
    Y = CenterY - H / 2;

    // ,  
    if(Header != NULL)
    {
        //       
        Y += HeaderFont->H / 2;
        //    
        gfx_Rectangle(X - 1, Y - HeaderFont->H - 2, X + W + 1, Y + 1, 0x00);
        //    
    	gfx_FillRect(X, Y - HeaderFont->H - 1, X + W, Y, 0xFF);
        //    
        gfx_SetXY(X + 1, Y - HeaderFont->H);
        //  
        gfx_PutFlashStr(Header, 0x00, HeaderFont);
    }

    if(Selected > Pos + StrCount - 1) Pos = Selected + 1 - StrCount;

    do
    {
        //     
	    gfx_FillRect(X - 1, Y, X + W + 1, Y + H + 1, 0x00);
        //     
	    gfx_Rectangle(X, Y, X + W, Y + H, 0xFF);

        //        
	    for(i=Pos; i < Pos + StrCount; i++)
	    {
            //   -    
            if(i == Selected) Color = 0x00;
            else              Color = 0xFF;
            //      strlen
                 if(BodyPtrType == PTR_FLASH) strLen = strlenf(((char flash **)Body)[i]);
            else if(BodyPtrType == PTR_SRAM ) strLen = strlen(((char **)Body)[i]);
            //     X   
            x = CenterX - (BodyFont->W * strLen) / 2;
            //    
            gfx_SetXY(x, Y + BodyFont->H/4 + (i - Pos) * BodyFont->H);
            //  
                 if(BodyPtrType == PTR_FLASH) gfx_PutFlashStr(((char flash **)Body)[i], Color, BodyFont);
            else if(BodyPtrType == PTR_SRAM ) gfx_PutStr(     ((char **)Body)[i], Color, BodyFont);
	    }
        //    
        gfx_Refresh();

        //   
        WaitEmptyButtons(10);
        //   
        Kbd = WaitButtonPress(0);

        //   ,     
        if((Kbd & B_UP)   && (Selected > 0))     Selected--;
        if((Kbd & B_DOWN) && (Selected < N - 1)) Selected++;

        if(Selected > Pos + StrCount - 1) Pos++;
        if(Selected < Pos) Pos--;
    }
    while(!(Kbd & (B_BACK | B_ENTER)));

    //   ENTER   
    if(Kbd & B_ENTER) return(Selected);
    //   -1
    return(-1);
}

// *****************************************************************************
// ***         ***********************************************
// *****************************************************************************
inline char SelectBoxF(flash char ** Body, unsigned char N,  unsigned char Selected, FontProfile * BodyFont,
                       char flash * Header, FontProfile * HeaderFont)
{
    return(SelectBoxEx((void **)Body, PTR_FLASH, N, Selected, BodyFont, Header, HeaderFont, WidthS/2, HeightS/2));
}

// *****************************************************************************
// ***         ***********************************************
// *****************************************************************************
inline char SelectBox(char ** Body, unsigned char N,  unsigned char Selected, FontProfile * BodyFont,
                      char flash * Header, FontProfile * HeaderFont)
{
    return(SelectBoxEx((void **)Body, PTR_SRAM, N, Selected, BodyFont, Header, HeaderFont, WidthS/2, HeightS/2));
}

// *****************************************************************************
// ***           *****************
// *****************************************************************************
char EditNumDlg(void * Val, char PtrType, int Min, int Max, char N, char flash * Header)
{
    //        
    int BackUp;
    //     switch'
    int tmp;
    //    
    unsigned char Kbd = 0;

#ifdef DEBUG
    printf("EditNumDlg();\r");
    delay_ms(1);
#endif

    // 
    if(Val == NULL) return;

    //        
    switch(PtrType)
    {
        case (PTR_CHAR):
            BackUp = (int)*((char *)Val);
            break;

        case (PTR_UCHAR):
            BackUp = (int)*((unsigned char *)Val);
            break;

        case (PTR_INT):
            BackUp = *((int *)Val);
            break;

        default:
            //      
#ifdef DEBUG
            printf("EditNumDlg(): unknown PtrType(%d)\r", PtrType);
            delay_ms(1);
#endif
            return;
    }

    tmp = BackUp;

    do
    {
        //     
        sprintf(tmpBuf, "%d", tmp);
        //    
        MsgBoxEx(tmpBuf, 1, &Font_12x16, Header, NULL, WidthS / 2, HeightS / 2, N, 0xFF);
        //   
        Kbd = WaitButtonPress(0);
        //        Min -    1
        if((Kbd == B_DOWN) && (tmp > Min)) tmp--;
        //       Max -    1
        if((Kbd == B_UP)   && (tmp < Max)) tmp++;
        //    -  
        if(Kbd == B_LEFT)
        {
            if(tmp - 10 > Min) tmp -= 10;  //     10 - 
            else               tmp  = Min; //    
        }
        //    -  
        if(Kbd == B_RIGHT)
        {
            if(tmp + 10 < Max) tmp += 10;  //     10 - 
            else               tmp  = Max; //    
        }

        //     ,     - .
        //         
        //      .
        switch(PtrType)
        {
            case (PTR_CHAR):
                *((char *)Val) = (char)tmp;
                break;

            case (PTR_UCHAR):
                *((unsigned char *)Val) = (unsigned char)tmp;
                break;

            case (PTR_INT):
                *((int *)Val) = tmp;
                break;
        }
    }
    while((Kbd != B_ENTER) && (Kbd != B_BACK)); //      - 

    //    - 
    if(Kbd == B_ENTER)
    {
        //     
        if(BackUp != tmp) return(TRUE);
        //  - 
        else return(FALSE);
    }
    // 
    else
    {
        //   
        switch(PtrType)
        {
            case (PTR_CHAR):
                *((char *)Val) = (char)BackUp;
                break;

            case (PTR_UCHAR):
                *((unsigned char *)Val) = (unsigned char)BackUp;
                break;

            case (PTR_INT):
                *((int *)Val) = BackUp;
                break;
        }

        //    -  
        return(FALSE);
    }
}

flash char EditStrDlgTable[] = {
' ','_','-','0','1','2','3','4','5','6','7','8','9','A','a','B','b','C','c','D',
'd','E','e','F','f','G','g','H','h','I','i','J','j','K','k','L','l','M','m','N',
'n','O','o','P','p','Q','q','R','r','S','s','T','t','U','u','V','v','W','w','X',
'x','Y','y','Z','z'};

// *****************************************************************************
// ***         ***********************************************
// *****************************************************************************
char * EditStrDlg(char * Str, char StrLen, FontProfile * StrFont,
                  char flash * Header, FontProfile * HeaderFont)
{
    //   
	unsigned char i, j;
    //    
    char str[16];
    //   
    unsigned char Selected = 0;
    //     
    unsigned char X, Y, W, H, StrW, x;
    //     
    unsigned char Kbd = 0;

#ifdef DEBUG
    printf("EditStrDlg();\r");
    delay_ms(1);
#endif

    // 
    if(Str == NULL) return;                        //      - 
    if(StrFont == NULL) StrFont = &Font_8x12;      //     -   
    if(HeaderFont == NULL) HeaderFont = &Font_4x6; //     -   
    if(StrLen > NumberOf(str) - 1) StrLen = NumberOf(str) - 1; //         - 

    //    0
    memset(str, 0, NumberOf(str));

    //        
    for(i=0; i < StrLen; i++)
    {
        for(j=0; j < NumberOf(EditStrDlgTable); j++)
        {
            if(Str[i] == EditStrDlgTable[j])
            {
                //    - 
                str[i] = j;
                break;
            }
        }
    }

    //     
    W = (StrFont->W + 1) * StrLen;
    H = StrFont->H;

    if(Header != NULL)
    {
        //     
        StrW = HeaderFont->W * strlenf(Header);
        //        -  
		if(W < StrW) W = StrW;
    }

    //            1 
	W += StrFont->W * 2;
    //            0.5 
	H += StrFont->H;

    //   
	X = (WidthS - W) / 2;
    //   
    Y = (HeightS - H) / 2;

    // ,  
    if(Header != NULL)
    {
        //       
        Y += HeaderFont->H / 2;
        //    
        gfx_Rectangle(X - 1, Y - HeaderFont->H - 2, X + W + 1, Y + 1, 0x00);
        //    
    	gfx_FillRect(X, Y - HeaderFont->H - 1, X + W, Y, 0xFF);
        //    
        gfx_SetXY(X + 1, Y - HeaderFont->H);
        //  
        gfx_PutFlashStr(Header, 0x00, HeaderFont);
    }

    do
    {
        //     
	    gfx_FillRect(X - 1, Y, X + W + 1, Y + H + 1, 0x00);
        //     
	    gfx_Rectangle(X, Y, X + W, Y + H, 0xFF);

        //     X   
        x = (WidthS - (StrFont->W + 1) * StrLen) / 2;

        //        
	    for(i = 0; i < StrLen; i++)
	    {
            //    
            gfx_SetXY(x + i * (StrFont->W + 1), Y + StrFont->H/2);
            //  
            StrFont->PutChar(EditStrDlgTable[str[i]], 0xFF);
	    }

        //     
  	    gfx_Rectangle(x + Selected * (StrFont->W + 1) - 2,          Y + StrFont->H/2 - 1,
                      x + Selected * (StrFont->W + 1) + StrFont->W, Y + StrFont->H/2 + StrFont->H, 0xFF);

        //    
        gfx_Refresh();

        //   
        Kbd = WaitButtonPress(0);

        //   ,     
        if((Kbd == B_LEFT)  && (Selected >          0)) Selected--;
        if((Kbd == B_RIGHT) && (Selected < StrLen - 1)) Selected++;

        //        
        if((Kbd == B_LEFT) || (Kbd == B_RIGHT)) WaitEmptyButtons(10);

        //  ,     
        if((Kbd == B_UP)   && (str[Selected] >                             0)) str[Selected]--;
        if((Kbd == B_DOWN) && (str[Selected] < NumberOf(EditStrDlgTable) - 1)) str[Selected]++;
    }
    while(!(Kbd & (B_BACK | B_ENTER)));

    //   ENTER   
    if(Kbd & B_ENTER)
    {
        //     
        for(i=0; i < StrLen; i++) Str[i] = EditStrDlgTable[str[i]];
        //  -
        Str[StrLen] = '\0';
        //      :
        //    ,   
        for(i = StrLen - 1; i >= 0; i--)
        {
            if(Str[i] != ' ') break; //     -  
            else Str[i] = '\0';      //     -
        }
        //     
        return(Str);
    }
    //   NULL
    return(NULL);
}

// *****************************************************************************
// ***         ***********************************************
// *****************************************************************************
// :   ,  - 
int FromToBox(void ** FromBody,  unsigned char FromBodyPtrType, unsigned char FromN,
              void ** ToBody,    unsigned char ToBodyPtrType, unsigned char ToN,
              flash char  * Header, FontProfile * HeaderFont)
{
    StringType Strings[4];
    //     
    char From = 0, To = 0, pos = 0;
    //    
    unsigned char Kbd = 0;
    char FromStr[16], ToStr[16];

    Strings[0].Str = (void *)("From:");
    Strings[0].StrPtrType = PTR_FLASH;
    Strings[0].StrFont = &Font_6x8;
    Strings[0].Color = 0xFF;
    Strings[0].VSpace = 3;

    Strings[1].Str = FromStr;
    Strings[1].StrPtrType = PTR_SRAM;
    Strings[1].StrFont = &Font_8x8;
    Strings[1].Color = 0xFF;
    Strings[1].VSpace = 3;

    Strings[2].Str =(void *)("To:");
    Strings[2].StrPtrType = PTR_FLASH;
    Strings[2].StrFont = &Font_6x8;
    Strings[2].Color = 0xFF;
    Strings[2].VSpace = 3;

    Strings[3].Str = ToStr;
    Strings[3].StrPtrType = PTR_SRAM;
    Strings[3].StrFont = &Font_8x8;
    Strings[3].Color = 0xFF;
    Strings[3].VSpace = 3;

    do
    {
        //     
             if(FromBodyPtrType == PTR_FLASH) sprintf(FromStr, "%p", FromBody[From]);
        else if(FromBodyPtrType == PTR_SRAM ) sprintf(FromStr, "%s", FromBody[From]);
        //     
             if(ToBodyPtrType == PTR_FLASH) sprintf(ToStr, "%p", ToBody[To]);
        else if(ToBodyPtrType == PTR_SRAM ) sprintf(ToStr, "%s", ToBody[To]);

        if(pos == 0)
        {
            Strings[1].Color = 0x00;
            Strings[3].Color = 0xFF;
        }
        else
        {
            Strings[1].Color = 0xFF;
            Strings[3].Color = 0x00;
        }

        //    
        MsgBoxStrEx(Strings, 4, Header, HeaderFont, WidthS / 2, HeightS / 2, 10, 0xFF);

        //   
        WaitEmptyButtons(0);
        //   
        Kbd = WaitButtonPress(0);

        //        Min -  
        if((Kbd == B_DOWN) && (pos < 1)) pos++;
        //       Max -  
        if((Kbd == B_UP)   && (pos > 0)) pos--;
        //        Min -  
        if(Kbd == B_LEFT)
        {
            if((pos == 0) && (From > 0)) From--;
            if((pos == 1) &&   (To > 0))   To--;
        }
        //       Max -  
        if(Kbd == B_RIGHT)
        {
            if((pos == 0) && (From < FromN - 1)) From++;
            if((pos == 1) &&   (To <   ToN - 1))   To++;
        }
    }
    while((Kbd != B_ENTER) && (Kbd != B_BACK)); //      - 

    //    -   
    if(Kbd == B_ENTER) return(((int)From) << 8 | To);
    return(-1);
}
