/*******************************************************************************
*  User_Interface.c
*
*  :  
*
*       Copyright (c) 2009 Nick Shl
*           All rights reserved.
*
*
*  :
*
*  Mar 25, 2009  Nick_Shl   
*
*/// ***************************************************************************
#include <mega128.h>
#include <delay.h>
#include <stdio.h>
#include <string.h>

#include "Def.h"
#include "Coder.h"
#include "Graphic.h"
#include "Sound.h"
#include "Demo.h"
#include "Music.h"
#include "Variables.h"
#include "Tasks.h"
#include "System.h"
#include "UI_Engine.h"
#include "User_Interface.h"

//  .      .
//     WidthS  HeightS   !!!
#define Trim0posX (WidthS-10-32)
#define Trim0posY (HeightS-1)
#define Trim1posX (WidthS-1)
#define Trim1posY (HeightS-32-10)
#define Trim2posX 0
#define Trim2posY (HeightS-32-10)
#define Trim3posX 10
#define Trim3posY (HeightS-1)

// *****************************************************************************
// ***        *******************************************
// *****************************************************************************
void wr_trimmer(void)
{
    char tr[4];

    tr[0] = CurModel.Mode[FLY_MODE].trimmers[0] / 6 + Trim0posX + 16;
    gfx_Line(Trim0posX, Trim0posY, Trim0posX + 32, Trim0posY, 1);
    gfx_PutPixel(Trim0posX     , Trim0posY - 1, 1); gfx_PutPixel(Trim0posX, Trim0posY - 2, 1);
    gfx_PutPixel(Trim0posX +  4, Trim0posY - 1, 1);
    gfx_PutPixel(Trim0posX +  8, Trim0posY - 1, 1);
    gfx_PutPixel(Trim0posX + 12, Trim0posY - 1, 1);
    gfx_PutPixel(Trim0posX + 16, Trim0posY - 1, 1); gfx_PutPixel(Trim0posX + 16, Trim0posY - 2, 1);
    gfx_PutPixel(Trim0posX + 20, Trim0posY - 1, 1);
    gfx_PutPixel(Trim0posX + 24, Trim0posY - 1, 1);
    gfx_PutPixel(Trim0posX + 28, Trim0posY - 1, 1);
    gfx_PutPixel(Trim0posX + 32, Trim0posY - 1, 1); gfx_PutPixel(Trim0posX + 32, Trim0posY - 2, 1);
    gfx_PutPixel(tr[0], Trim0posY - 3, 1);
    gfx_Line(tr[0] - 1, Trim0posY - 4, tr[0] + 1, Trim0posY - 4, 1);
    gfx_Line(tr[0] - 2, Trim0posY - 5, tr[0] + 2, Trim0posY - 5, 1);

    tr[1] = CurModel.Mode[FLY_MODE].trimmers[1] / -6 + Trim1posY + 16;
    gfx_Line(Trim1posX, Trim1posY, Trim1posX, Trim1posY + 32, 1);
    gfx_PutPixel(Trim1posX - 1, Trim1posY     , 1); gfx_PutPixel(Trim1posX - 2, Trim1posY, 1);
    gfx_PutPixel(Trim1posX - 1, Trim1posY +  4, 1);
    gfx_PutPixel(Trim1posX - 1, Trim1posY +  8, 1);
    gfx_PutPixel(Trim1posX - 1, Trim1posY + 12, 1);
    gfx_PutPixel(Trim1posX - 1, Trim1posY + 16, 1); gfx_PutPixel(Trim1posX - 2, Trim1posY + 16, 1);
    gfx_PutPixel(Trim1posX - 1, Trim1posY + 20, 1);
    gfx_PutPixel(Trim1posX - 1, Trim1posY + 24, 1);
    gfx_PutPixel(Trim1posX - 1, Trim1posY + 28, 1);
    gfx_PutPixel(Trim1posX - 1, Trim1posY + 32, 1); gfx_PutPixel(Trim1posX - 2, Trim1posY + 32, 1);
    gfx_PutPixel(Trim1posX - 3, tr[1], 1);
    gfx_Line(Trim1posX - 4, tr[1] - 1, Trim1posX - 4, tr[1] + 1, 1);
    gfx_Line(Trim1posX - 5, tr[1] - 2, Trim1posX - 5, tr[1] + 2, 1);

    tr[2] = CurModel.Mode[FLY_MODE].trimmers[2]/ -6 + Trim1posY + 16;
    gfx_Line(Trim2posX, Trim1posY, Trim2posX, Trim1posY + 32, 1);
    gfx_PutPixel(Trim2posX + 1, Trim1posY     , 1); gfx_PutPixel(Trim2posX + 2, Trim1posY, 1);
    gfx_PutPixel(Trim2posX + 1, Trim1posY +  4, 1);
    gfx_PutPixel(Trim2posX + 1, Trim1posY +  8, 1);
    gfx_PutPixel(Trim2posX + 1, Trim1posY + 12, 1);
    gfx_PutPixel(Trim2posX + 1, Trim1posY + 16, 1); gfx_PutPixel(Trim2posX + 2, Trim1posY + 16, 1);
    gfx_PutPixel(Trim2posX + 1, Trim1posY + 20, 1);
    gfx_PutPixel(Trim2posX + 1, Trim1posY + 24, 1);
    gfx_PutPixel(Trim2posX + 1, Trim1posY + 28, 1);
    gfx_PutPixel(Trim2posX + 1, Trim1posY + 32, 1); gfx_PutPixel(Trim2posX + 2, Trim1posY + 32, 1);
    gfx_PutPixel(Trim2posX + 3, tr[2], 1);
    gfx_Line(Trim2posX + 4, tr[2] - 1, Trim2posX + 4, tr[2] + 1, 1);
    gfx_Line(Trim2posX + 5, tr[2] - 2, Trim2posX + 5, tr[2] + 2, 1);

    tr[3] = CurModel.Mode[FLY_MODE].trimmers[3] / 6 + Trim3posX + 16;
    gfx_Line(Trim3posX, Trim3posY, Trim3posX + 32, Trim3posY, 1);
    gfx_PutPixel(Trim3posX     , Trim3posY - 1, 1); gfx_PutPixel(Trim3posX, Trim3posY - 2, 1);
    gfx_PutPixel(Trim3posX +  4, Trim3posY - 1, 1);
    gfx_PutPixel(Trim3posX +  8, Trim3posY - 1, 1);
    gfx_PutPixel(Trim3posX + 12, Trim3posY - 1, 1);
    gfx_PutPixel(Trim3posX + 16, Trim3posY - 1, 1); gfx_PutPixel(Trim3posX + 16, Trim3posY - 2, 1);
    gfx_PutPixel(Trim3posX + 20, Trim3posY - 1, 1);
    gfx_PutPixel(Trim3posX + 24, Trim3posY - 1, 1);
    gfx_PutPixel(Trim3posX + 28, Trim3posY - 1, 1);
    gfx_PutPixel(Trim3posX + 32, Trim3posY - 1, 1); gfx_PutPixel(Trim3posX + 32, Trim3posY - 2, 1);
    gfx_PutPixel(tr[3], Trim3posY - 3, 1);
    gfx_Line(tr[3] - 1, Trim3posY - 4, tr[3] + 1, Trim3posY - 4, 1);
    gfx_Line(tr[3] - 2, Trim3posY - 5, tr[3] + 2, Trim3posY - 5, 1);
}

// *****************************************************************************
// ***    PPM    ****************************************************
// *****************************************************************************
void Show_PPM(unsigned char X, unsigned char Y)
{
    unsigned char i;
    unsigned char len = 1;

    if     (CurModel.modulation == 0) gfx_Line(X, Y + 5, X + 100, Y + 5, 0xFF);
    else if(CurModel.modulation == 1) gfx_Line(X, Y, X + 100, Y, 0xFF);
    gfx_Line(X, Y, X, Y + 5, 0xFF);

    for(i=0; i < CurModel.num_ch; i++)
    {
        len += output[i] / TimerClockPerSec(0.0002); //    
        gfx_Line(X + len, Y, X + len, Y + 5, 0xFF);
    }
}

#define TimerPosX ((WidthS - 7 * Font_12x16.W) / 2)
#define TimerPosY (HeightS-10-16-8)

// *****************************************************************************
// ***        *******************************************
// *****************************************************************************
void MainScreen(void)
{
    signed int U_bat;
    char min[2], sec[2], ms;
    int time, subtime;

    //  
    gfx_ClearBuf();

    gfx_SetXY(0, 0);
    //  
    sprintf(tmpBuf, "%d", Settings.ModelNum + 1);
    gfx_PutStr(tmpBuf, 0xFF, &Font_8x12);
    //     3     
    gfx_ChangeXY(3, (Font_8x12.H - Font_8x8.H) / 2);
    //  
    if(CurModel.type == TYPE_HELI)
    {
        gfx_Char(125, 0xFF, &Font_8x8);
        gfx_Char(126, 0xFF, &Font_8x8);
    }
    //  
    if(CurModel.type == TYPE_PLANE)
    {
        gfx_Char(127, 0xFF, &Font_8x8);
        gfx_Char(128, 0xFF, &Font_8x8);
    }
    //     3     
    gfx_ChangeXY(3, - (char)(Font_8x12.H - Font_8x8.H) / 2);
    //  
    gfx_PutStr(CurModel.name, 0xFF, &Font_8x12);

    //   
    if(Cut_enable)
    {
        gfx_SetXY(80, 12);
        gfx_Char_8x8(129, 0xFF);
        gfx_Char_8x8(130, 0xFF);
        gfx_SetXY(80, 20);
        gfx_Char_8x8(131, 0xFF);
        gfx_Char_8x8(132, 0xFF);
    }

    //  
    gfx_SetXY(WidthS - 6 * Font_4x6.W, Font_8x12.H + (Font_8x8.H - Font_4x6.H) / 2);
    U_bat = GetBatteryStatus();
    sprintf(tmpBuf, "%2i.%02iV", U_bat / 100, U_bat % 100);
    gfx_PutStr(tmpBuf, 0xFF, &Font_4x6);

    //  
    gfx_SetXY(0, Font_8x12.H);
    gfx_PutStr(CurModel.Mode[FLY_MODE].name, 0xFF, &Font_8x8);

    // 
    time = GetTimerValue();
    subtime = GetTimerSubValue();
    min[0] = time/600;         //  -  
    min[1] = time/60 % 10;     //  -  
    sec[0] = time%60 / 10;     //  -  
    sec[1] = time%10;          //  -  
    ms     = subtime/100;      // 

    gfx_SetXY(TimerPosX, TimerPosY);
    gfx_Deg_12x16(min[0], 0xFF);
    gfx_Deg_12x16(min[1], 0xFF);
    gfx_Char(':', 0xFF, &Font_12x16);
    gfx_Deg_12x16(sec[0], 0xFF);
    gfx_Deg_12x16(sec[1], 0xFF);
    gfx_Char('.', 0xFF, &Font_12x16);
    gfx_Deg_12x16(ms, 0xFF);

    //   
    wr_trimmer();

    //  PPM   
    Show_PPM((WidthS - 100) / 2, HeightS - 15);

    //  
    gfx_Refresh();
}

// *****************************************************************************
// ***        ****************************************
// *****************************************************************************
void ModelCopy(char AddParam)
{
    //   
    unsigned char i, j;
    //    
    int result;
    //       
    char ModelsStr[MAX_MODELS][MODEL_NAME_LEN];
    //       
    char * ModelsStrPtrs[MAX_MODELS];
    //      
    char From, To;

#ifdef DEBUG
    printf("ModelCopy();\r");
    delay_ms(1);
#endif

    //  
    for(i=0; i < MAX_MODELS; i++)
    {
        //     
        for(j=0; j < NumberOf(EEPROM_MODEL[i].name); j++) ModelsStr[i][j] = EEPROM_MODEL[i].name[j];
        //     
        ModelsStrPtrs[i] = ModelsStr[i];
    }

    //    
    result = FromToBox((void **)ModelsStrPtrs, PTR_SRAM, MAX_MODELS,
                       (void **)ModelsStrPtrs, PTR_SRAM, MAX_MODELS,
                       "Model Copy:", NULL);

    //    ( )
    if(result != -1)
    {
        //     
        From = (char)(result >> 8);
        //     
        To = (char)(result & 0xFF);
        //     
        if(From != To)
        {
            //    
            MODEL_Copy(From, To);
            //        -   
            if(To == Settings.ModelNum) MODEL_Init(Settings.ModelNum);
        }
    }
}

// *****************************************************************************
// ***        ****************************************
// *****************************************************************************
void ModeCopy(char AddParam)
{
    //   
    unsigned char i;
    //    
    int result;
    //       
    char ModesStr[MAX_MODES][MODE_NAME_LEN];
    //       
    char * ModesStrPtrs[MAX_MODES];
    //      
    char From, To;

#ifdef DEBUG
    printf("ModeCopy();\r");
    delay_ms(1);
#endif

    //  
    for(i=0; i < MAX_MODES; i++)
    {
        //     
        strcpy(ModesStr[i], CurModel.Mode[i].name);
        //     
        ModesStrPtrs[i] = ModesStr[i];
    }

    //    
    result = FromToBox((void **)ModesStrPtrs, PTR_SRAM, NumberOf(ModesStrPtrs),
                       (void **)ModesStrPtrs, PTR_SRAM, NumberOf(ModesStrPtrs),
                       "Mode Copy:", NULL);

    //    ( )
    if(result != -1)
    {
        //     
        From = (char)(result >> 8);
        //     
        To = (char)(result & 0xFF);
        //     
        if(From != To)
        {
            //    
            MODE_Copy(From, To);
            //       
            MODEL_Init(Settings.ModelNum);
        }
    }
}

// *****************************************************************************
// ***       EEPROM   **********************************
// *****************************************************************************
void ModelSave(char AddParam)
{
#ifdef DEBUG
    printf("ModelSave();\r");
    delay_ms(1);
#endif

    //  
    MsgBoxF("Are you\nsure ?", &Font_8x12, "Model Save", NULL);

    //   
    WaitEmptyButtons(0);

    //   ,      .
    //   Enter -  
    if(WaitButtonPress(B_ENTER | B_BACK) == B_ENTER)
    {
        // 
        Beep(1000, 50, 1);
        //  
        MsgBoxF("Please\nwait...", &Font_8x12, "Model Save", NULL);
        //      EEPROM
        MODEL_Save(Settings.ModelNum);
        // 
        Beep(1000, 50, 1);
    }
}

// *****************************************************************************
// ***        ************************************************
// *****************************************************************************
void ModelReset(char AddParam)
{
#ifdef DEBUG
    printf("ModelReset();\r");
    delay_ms(1);
#endif

    //  
    MsgBoxF("Are you\nsure ?", &Font_8x12, "Model Reset", NULL);

    //   
    WaitEmptyButtons(0);

    //   ,      .
    //   Enter -  
    if(WaitButtonPress(B_ENTER | B_BACK) == B_ENTER)
    {
        // 
        Beep(1000, 50, 1);
        //  
        MsgBoxF("Please\nwait...", &Font_8x12, "Model Reset", NULL);
        //      EEPROM
        MODEL_Reset(Settings.ModelNum);
        //       EEPROM  SRAM
        MODEL_Init(Settings.ModelNum);
        // 
        Beep(1000, 50, 1);
    }
}

// *****************************************************************************
// ***       **********************************************************
// *****************************************************************************
flash const char * ModelTypes[] = {
    "Plane",
    "Heli"
};
// ***        ***********************************************
char * ModelTypeGetStr(char * Buf, char AddParam)
{
    //     
    sprintf(Buf, "%p", ModelTypes[CurModel.type]);
    //     
    return(Buf);
}
// ***        ***********************************************
void ModeTypeSet(char AddParam)
{
    //    
    char result;

    //    
    result = SelectBoxF((flash char **)ModelTypes, NumberOf(ModelTypes), CurModel.type, NULL, "Model Type:", NULL);

    //    ( )
    if(result != -1)
    {
        //   
        CurModel.type = result;
    }
}

// *****************************************************************************
// ***         *********************************************
// *****************************************************************************
flash const char * ModulationTypes[] = {
    "PPM",
    "IPPM",
    "PCM"
};
// ***        ********************************************
char *ModulationTypeGetStr(char * Buf, char AddParam)
{
    //     
    sprintf(Buf, "%p", ModulationTypes[CurModel.modulation]);
    //     
    return(Buf);
}
// ***        ********************************************
void ModulationTypeSet(char AddParam)
{
    //    
    char result;

    //    
    result = SelectBoxF((flash char **)ModulationTypes, NumberOf(ModulationTypes), CurModel.modulation, NULL, "Modulation Type:", NULL);

    //    ( )
    if(result != -1)
    {
        //   
        CurModel.modulation = result;
        //     
        TX_SetModulation(CurModel.modulation);
    }
}

// *****************************************************************************
// ***         ****************************************
// *****************************************************************************

// ***          *****************************
char * ModelChannelsNumGetStr(char * Buf, char AddParam)
{
    //     
    sprintf(Buf, "%d", CurModel.num_ch);
    //     
    return(Buf);
}
// ***          *****************************
void ModelChannelsNumSet(char AddParam)
{
    //    
    EditNumDlg(&CurModel.num_ch, PTR_CHAR , 2, MAX_CHANNELS, 1, "Channels");
}

// *****************************************************************************
// ***       *****************************************************
// *****************************************************************************

// ***        *******************************************
char * ModelNameGetStr(char * Buf, char AddParam)
{
    //     
    sprintf(Buf, "%s", CurModel.name);
    //     
    return(Buf);
}
// ***        *******************************************
void ModelNameSet(char AddParam)
{
    //    
    EditStrDlg(CurModel.name, NumberOf(CurModel.name) - 1, NULL, "Model Name:", NULL);
}

// *****************************************************************************
// ***       *****************************************************
// *****************************************************************************

// ***        *******************************************
char * ModeNameGetStr(char * Buf, char AddParam)
{
    //     
    sprintf(Buf, "%s", CurModel.Mode[FLY_MODE].name);
    //     
    return(Buf);
}
// ***        *******************************************
void ModeNameSet(char AddParam)
{
    //    
    EditStrDlg(CurModel.Mode[FLY_MODE].name, NumberOf(CurModel.Mode[FLY_MODE].name) - 1, NULL, "Mode Name:", NULL);
}

// *****************************************************************************
// ***       ********************************************************
// *****************************************************************************
void ModelSelect(char AddParam)
{
    //   
    unsigned char i, j;
    //    
    char result;
    //       
    char ModelsStr[MAX_MODELS][MODEL_NAME_LEN];
    //       
    char * ModelsStrPtrs[MAX_MODELS];

    //  
    for(i=0; i < MAX_MODELS; i++)
    {
        //     
        for(j=0; j < MODEL_NAME_LEN; j++) ModelsStr[i][j] = EEPROM_MODEL[i].name[j];
        //     
        ModelsStrPtrs[i] = ModelsStr[i];
    }

    //    
    result = SelectBox((char **)ModelsStrPtrs, MAX_MODELS, Settings.ModelNum, NULL, "Model:", NULL);

    //    ( )
    if(result != -1)
    {
        //           
        #asm("cli")
        //   
        Settings.ModelNum = result;
        //     EEPROM
        TX_SaveSettings();
        //     EEPROM
        MODEL_Init(Settings.ModelNum);
        #asm("sei")
    }
}

// *****************************************************************************
// ***    ""   *******************************************************
// *****************************************************************************
flash MenuButton ModelMenuButtons[] =
{
 {"Name", ModelNameSet, ModelNameGetStr},
 {"Type", ModeTypeSet, ModelTypeGetStr},
 {"Modulation", ModulationTypeSet, ModulationTypeGetStr},
 {"Channels", ModelChannelsNumSet, ModelChannelsNumGetStr},
 {"Mode Name", ModeNameSet, ModeNameGetStr},
 {"Save", ModelSave, NULL},
 {"Select", ModelSelect, NULL},
 {"Copy", ModelCopy, NULL},
 {"Modes Copy", ModeCopy, NULL},
 {"Reset", ModelReset, NULL}};

void ModelMenu(char AddParam)
{
    //   
    MenuPad Pad = {"Model", &Font_8x12, &Font_6x8, ModelMenuButtons, NumberOf(ModelMenuButtons), 0, NULL, NULL};
    //   
    MenuCycle(&Pad);
}

// *****************************************************************************
// ***         ********************************
// *****************************************************************************
static char CurrentControl;

//      "Controls"     
//      .
extern flash MenuButton ControlsMenuButtons[];

// ***         *****************************
char * ControlsVirtualGetStr(char * Buf, char AddParam)
{
    //     
    sprintf(Buf, ControlsMenuButtons[CurModel.Mode[FLY_MODE].Control[CurrentControl].from].str);
    //     
    return(Buf);
}

// ***         *****************************
void ControlsVirtualSet(char AddParam)
{
    char i;
    char result = CurModel.Mode[FLY_MODE].Control[CurrentControl].from;
    flash char * Strings[MAX_CONTROLS];

    for(i=0; i < MAX_CONTROLS; i++) Strings[i] = ControlsMenuButtons[i].str;

    result = SelectBoxF((flash char **)Strings, CTRL_V1, result, NULL, "From:", NULL);
    //    ( )
    if(result != -1) CurModel.Mode[FLY_MODE].Control[CurrentControl].from = result;
}

// ***         **********************************
char * ControlsReverseGetStr(char * Buf, char AddParam)
{
    //       
    char flash * str;
    //     
    if(CurModel.Mode[FLY_MODE].Control[CurrentControl].reverse == 1) str = "OFF";
    else if (CurModel.Mode[FLY_MODE].Control[CurrentControl].reverse == -1) str = "ON";
    else str = "ERROR";
    sprintf(Buf, str);
    //     
    return(Buf);
}
// ***        ********************************************
void ControlsReverseSet(char AddParam)
{
    char result = CurModel.Mode[FLY_MODE].Control[CurrentControl].reverse == 1 ? 0 : 1;
    flash char * Strings[2] = {"OFF", "ON"};

    result = SelectBoxF((flash char **)Strings, 2, result, NULL, "Reverse:", NULL);
    //    ( )
    if(result != -1)
    {
        if(result == 0) CurModel.Mode[FLY_MODE].Control[CurrentControl].reverse =  1;
        else            CurModel.Mode[FLY_MODE].Control[CurrentControl].reverse = -1;
    }
}

// ***      AddParam   *************************************
static unsigned char * ControlsRateGetPointer(char Control, char param)
{
    switch(param)
    {
        case CTRLS_MINR:
            return(&CurModel.Mode[FLY_MODE].Control[Control].minRates);

        case CTRLS_MAXR:
            return(&CurModel.Mode[FLY_MODE].Control[Control].maxRates);

        case CTRLS_MINDR:
        case CTRLS_TCUT:
            return(&CurModel.Mode[FLY_MODE].Control[Control].minDRates);

        case CTRLS_MAXDR:
            return(&CurModel.Mode[FLY_MODE].Control[Control].maxDRates);

        default:
            return(NULL);
    }
}

// ***        ****************************************
char * ControlsRateGetStr(char * Buf, char AddParam)
{
    //  
    unsigned char * val = ControlsRateGetPointer(CurrentControl, AddParam);

    //     
    if(val) sprintf(Buf, "%d", *val);
    else    sprintf(Buf, "ERROR");
    //     
    return(Buf);
}

// ***       **************************************************
void ControlsRateSet(char AddParam)
{
    //    
    EditNumDlg(ControlsRateGetPointer(CurrentControl, AddParam), PTR_UCHAR, 0, 150, 3, "Control:");
}

// ***       **************************************************
void ControlsCurveChange(char AddParam)
{
    unsigned char i;
    //    
    unsigned char Kbd = 0;
    char * nodes = CurModel.Mode[FLY_MODE].Control[CurrentControl].nodes;
    int x1, x2;
    char Y[CURVE_NODES];
    char tmp[CURVE_NODES];
    unsigned char sel = 0;

    //    
    for(i=0; i < CURVE_NODES; i++) tmp[i] = nodes[i];

    do
    {
        //    
        gfx_FillRect(63 - 3, 0, 127, 63, 0);

        //      
        gfx_DashLine(63, HeightS/2, 127, HeightS/2);

        //     
        for(i=0; i < CURVE_NODES - 2; i++)
        {
            x1 = 63 + (64 * (int)(i+1)) / (CURVE_NODES - 1);
            gfx_DashLine(x1, 0, x1, HeightS);
        }

        //        (Y)
        for(i=0; i < CURVE_NODES; i++)
        {
            Y[i] = ((int)tmp[i] * 100 / -317) + 64/2;
        }

        //    
        for(i=0; i < CURVE_NODES - 1; i++)
        {
            x1 = 63 + (64 * (int) i)    / (CURVE_NODES - 1);
            x2 = 63 + (64 * (int)(i+1)) / (CURVE_NODES - 1);
            gfx_Line(x1, Y[i], x2, Y[i+1], 1);
        }

        //     
        x1 = 63 + (64 * (int)sel) / (CURVE_NODES - 1);
        gfx_Rectangle(x1 - 2, Y[sel] - 2, x1 + 2, Y[sel] + 2, 1);

        //     
        gfx_Rectangle(63, 0, 127, 63, 1);

        //     
        sprintf(tmpBuf, "%d", tmp[sel]);
        MsgBoxEx(tmpBuf, 1, NULL, "Curve", NULL, WidthS / 4, HeightS / 2, 4, 0xFF);

        //    
        gfx_Refresh();

        //   
        Kbd = WaitButtonPress(0);
        //        0 -  
        if((Kbd == B_LEFT)  && (sel > 0)  ) sel--;
        //        CURVE_NODES-1 -  
        if((Kbd == B_RIGHT) && (sel < CURVE_NODES - 1)) sel++;
        //          0 -  
        if((Kbd == B_DOWN) && (tmp[sel] > -100)) tmp[sel]--;
        //       150 -  
        if((Kbd == B_UP)   && (tmp[sel] <  100)) tmp[sel]++;

        // E     -   , ..  
        if((Kbd == B_LEFT) || (Kbd == B_RIGHT)) WaitEmptyButtons(0);
    }
    while((Kbd != B_ENTER) && (Kbd != B_BACK)); //      - 

    //     -   
    if(Kbd == B_ENTER) for(i=0; i < CURVE_NODES; i++) nodes[i] = tmp[i];
}

// ***         ********************************
flash MenuButton ControlsMainSettings[] =
{{"Reverse",       ControlsReverseSet, ControlsReverseGetStr, CTRLS_REV},
 {"Min Rate",      ControlsRateSet, ControlsRateGetStr, CTRLS_MINR},
 {"Max Rate",      ControlsRateSet, ControlsRateGetStr, CTRLS_MAXR},
 {"Min Dual Rate", ControlsRateSet, ControlsRateGetStr, CTRLS_MAXDR},
 {"Max Dual Rate", ControlsRateSet, ControlsRateGetStr, CTRLS_MINDR},
 {"Curve",         ControlsCurveChange, NULL, CTRLS_CURVE}};

// ***       **********************************************
flash MenuButton ControlsThrottleSettings[] =
{{"Reverse",       ControlsReverseSet, ControlsReverseGetStr, CTRLS_REV},
 {"Min Rate",      ControlsRateSet, ControlsRateGetStr, CTRLS_MINR},
 {"Max Rate",      ControlsRateSet, ControlsRateGetStr, CTRLS_MAXR},
 {"T. Cut",        ControlsRateSet, ControlsRateGetStr, CTRLS_TCUT},
 {"Curve",         ControlsCurveChange, NULL, CTRLS_CURVE}};

// ***       **************************************
flash MenuButton ControlsAuxSettings[] =
{{"Reverse",       ControlsReverseSet, ControlsReverseGetStr, CTRLS_REV},
 {"Min Rate",      ControlsRateSet, ControlsRateGetStr, CTRLS_MINR},
 {"Max Rate",      ControlsRateSet, ControlsRateGetStr, CTRLS_MAXR},
 {"Curve",         ControlsCurveChange, NULL, CTRLS_CURVE}};

// ***       **************************************
flash MenuButton ControlsSwSettings[] =
{{"Reverse",       ControlsReverseSet, ControlsReverseGetStr, CTRLS_REV},
 {"Min Rate",      ControlsRateSet, ControlsRateGetStr, CTRLS_MINR},
 {"Max Rate",      ControlsRateSet, ControlsRateGetStr, CTRLS_MAXR}};

// ***       *************************************
flash MenuButton ControlsVSettings[] =
{{"Reverse",       ControlsReverseSet, ControlsReverseGetStr, CTRLS_REV},
 {"Min Rate",      ControlsRateSet, ControlsRateGetStr, CTRLS_MINR},
 {"Max Rate",      ControlsRateSet, ControlsRateGetStr, CTRLS_MAXR},
 {"Curve",         ControlsCurveChange, NULL, CTRLS_CURVE},
 {"From",          ControlsVirtualSet, ControlsVirtualGetStr, CTRLS_FROM}};

void ControlsSettingsMenu(char AddParam)
{
    //   
    MenuPad Pad = {"Controls", &Font_8x12, &Font_6x8, NULL, 0, 0, NULL, NULL};
    //     
    CurrentControl = AddParam;

    //       
    switch(AddParam)
    {
        case CTRL_AIL:
        case CTRL_ELE:
        case CTRL_RUD:
            Pad.Buttons = ControlsMainSettings;
            Pad.ButtonsNum = NumberOf(ControlsMainSettings);
            break;

        case CTRL_THR:
            Pad.Buttons = ControlsThrottleSettings;
            Pad.ButtonsNum = NumberOf(ControlsThrottleSettings);
            break;

        case CTRL_AUX1:
            Pad.Buttons = ControlsAuxSettings;
            Pad.ButtonsNum = NumberOf(ControlsAuxSettings);
            break;

        case CTRL_SW1:
        case CTRL_SW2:
        case CTRL_SW3:
            Pad.Buttons = ControlsSwSettings;
            Pad.ButtonsNum = NumberOf(ControlsSwSettings);
            break;

        case CTRL_V1:
        case CTRL_V2:
            Pad.Buttons = ControlsVSettings;
            Pad.ButtonsNum = NumberOf(ControlsVSettings);
            break;

        default:
            Pad.Buttons = ControlsMainSettings;
            Pad.ButtonsNum = NumberOf(ControlsMainSettings);
            break;
    }

    //   
    MenuCycle(&Pad);
}

flash MenuButton ControlsMenuButtons[] =
{{"Ailerons",  ControlsSettingsMenu, NULL, CTRL_AIL},
 {"Elevator",  ControlsSettingsMenu, NULL, CTRL_ELE},
 {"Throttle",  ControlsSettingsMenu, NULL, CTRL_THR},
 {"Rudder",    ControlsSettingsMenu, NULL, CTRL_RUD},
 {"SW 1",      ControlsSettingsMenu, NULL, CTRL_SW1},
 {"SW 2",      ControlsSettingsMenu, NULL, CTRL_SW2},
 {"SW 3",      ControlsSettingsMenu, NULL, CTRL_SW3},
 {"Aux 1",     ControlsSettingsMenu, NULL, CTRL_AUX1},
 {"Virtual 1", ControlsSettingsMenu, NULL, CTRL_V1},
 {"Virtual 2", ControlsSettingsMenu, NULL, CTRL_V2}};

void ControlsMenu(char AddParam)
{
    //   
    MenuPad Pad = {"Controls", &Font_8x12, &Font_6x8, ControlsMenuButtons, NumberOf(ControlsMenuButtons), 0, NULL, NULL};
    //   
    MenuCycle(&Pad);
}

// *****************************************************************************
// ***    ()   ***********************************************
// *****************************************************************************

// ***       ******************************************
static char MixerCurrentChannel;

// ***       ******************************************
void MixerChangeSetting(char AddParam)
{
    //    
    EditNumDlg(&CurModel.Mode[FLY_MODE].Chanels[MixerCurrentChannel][AddParam], PTR_CHAR, -100, 100, 4, "Mixer");
}

// ***         **********************************
char * MixerGetStr(char * Buf, char AddParam)
{
    //     
    sprintf(Buf, "%d", CurModel.Mode[FLY_MODE].Chanels[MixerCurrentChannel][AddParam]);
    //     
    return(Buf);
}

// ***           *************************
flash MenuButton MixerMenuButtons[] =
{{"Ailerons",  MixerChangeSetting, MixerGetStr, CTRL_AIL},
 {"Elevator",  MixerChangeSetting, MixerGetStr, CTRL_ELE},
 {"Throttle",  MixerChangeSetting, MixerGetStr, CTRL_THR},
 {"Rudder",    MixerChangeSetting, MixerGetStr, CTRL_RUD},
 {"SW 1",      MixerChangeSetting, MixerGetStr, CTRL_SW1},
 {"SW 2",      MixerChangeSetting, MixerGetStr, CTRL_SW2},
 {"SW 3",      MixerChangeSetting, MixerGetStr, CTRL_SW3},
 {"Aux 1",     MixerChangeSetting, MixerGetStr, CTRL_AUX1},
 {"Virtual 1", MixerChangeSetting, MixerGetStr, CTRL_V1},
 {"Virtual 2", MixerChangeSetting, MixerGetStr, CTRL_V2},
 {"Trim",      MixerChangeSetting, MixerGetStr, CTRL_TRIM}};

// ***          ***********************************
void ChannelsMixerMenu(char AddParam)
{
    // TODO:   
    char Cap[12];
    //   
    MenuPad Pad = {"Mixer", &Font_8x12, &Font_6x8, MixerMenuButtons, NumberOf(MixerMenuButtons), 0, NULL, NULL};
    //     
    MixerCurrentChannel = AddParam;
    //   
    snprintf(Cap, sizeof(Cap), "CH %n Mixer", AddParam);
    //   
    MenuCycle(&Pad);
}

// ***          ********************************
flash MenuButton ChannelsMenuButtons[] =
{{"CH 1", ChannelsMixerMenu, NULL, 0},
 {"CH 2", ChannelsMixerMenu, NULL, 1},
 {"CH 3", ChannelsMixerMenu, NULL, 2},
 {"CH 4", ChannelsMixerMenu, NULL, 3},
 {"CH 5", ChannelsMixerMenu, NULL, 4},
 {"CH 6", ChannelsMixerMenu, NULL, 5},
 {"CH 7", ChannelsMixerMenu, NULL, 6},
 {"CH 8", ChannelsMixerMenu, NULL, 7}};

// ***           ***************************
void ChannelsMenu(char AddParam)
{
    //   
    MenuPad Pad = {"Channels", &Font_8x12, &Font_6x8, ChannelsMenuButtons, NumberOf(ChannelsMenuButtons), 0, NULL, NULL};
    //         -  ,
    //        
    if(Pad.ButtonsNum > CurModel.num_ch) Pad.ButtonsNum = CurModel.num_ch;
    //   
    MenuCycle(&Pad);
}

// *****************************************************************************
// ***       ********************************************************
// *****************************************************************************

// ***         **********************************
char * TimerModeGetStr(char * Buf, char AddParam)
{
    //         
    sprintf(Buf, (CurModel.timer_mode & 0x02) ? "DOWN" : "UP");
    //     
    return(Buf);
}
// ***        ********************************************
void TimerModeSet(char AddParam)
{
    //    
    char result;
    //    
    flash char * Strings[2] = {"UP", "DOWN"};

    //    
    result = SelectBoxF((flash char **)Strings, 2, (CurModel.timer_mode & 0x02) ? 1 : 0, NULL, "Timer Mode:", NULL);

    //    ( )
    if(result != -1)
    {
        //      -   
        if(result) CurModel.timer_mode |=  0x02;
        //  -   
        else       CurModel.timer_mode &= ~0x02;
    }
}

// ***         ***********************************
char * TimerSoundGetStr(char * Buf, char AddParam)
{
    //         
    sprintf(Buf, (CurModel.timer_mode & 0x01) ? "OFF" : "ON");
    //     
    return(Buf);
}
// ***       **********************************************
void TimerSoundSet(char AddParam)
{
    //    
    char result;
    //    
    flash char * Strings[2] = {"OFF", "ON"};

    //    
    result = SelectBoxF((flash char **)Strings, 2, (CurModel.timer_mode & 0x01) ? 0 : 1, NULL, "Timer Sound:", NULL);

    //    ( )
    if(result != -1)
    {
        //      -   
        if(result) CurModel.timer_mode &= ~0x01;
        //  -   
        else       CurModel.timer_mode |=  0x01;
    }
}

// ***       *********************************************************
flash MenuButton TimerMenuButtons[] =
{{"Set",   NULL, NULL},
 {"Mode",  TimerModeSet,  TimerModeGetStr},
 {"Sound", TimerSoundSet, TimerSoundGetStr}};

// ***       ********************************************************
void TimerMenu(char AddParam)
{
    //   
    MenuPad Pad = {"Timer", &Font_8x12, &Font_6x8, TimerMenuButtons, NumberOf(TimerMenuButtons), 0, NULL, NULL};
    //   
    MenuCycle(&Pad);
}

// *****************************************************************************
// ***    "Options"   ******************************************************
// *****************************************************************************

// ***        *******************************************
char * OptionsSoundGetStr(char * Buf, char AddParam)
{
    //     
    sprintf(Buf, Settings.SoundFlag ? "ON" : "OFF");
    //     
    return(Buf);
}
// ***       *****************************************************
void OptionsSoundSet(char AddParam)
{
    //    
    char result;
    //    
    flash char * Strings[2] = {"OFF", "ON"};

    //    
    result = SelectBoxF((flash char **)Strings, 2, Settings.SoundFlag, NULL, "Sound:", NULL);

    //    ( )
    if(result != -1)
    {
        //   
        Settings.SoundFlag = result;
        //     EEPROM
        TX_SaveSettings();
    }
}

// ***        ***************************************
char * OptionsBacklightGetStr(char * Buf, char AddParam)
{
    //     
    sprintf(Buf, Settings.BacklightFlag ? "ON" : "OFF");
    //     
    return(Buf);
}
// ***      **************************************************
void OptionsBacklightSet(char AddParam)
{
    //    
    char result;
    //    
    flash char * Strings[2] = {"OFF", "ON"};

    //    
    result = SelectBoxF((flash char **)Strings, 2, Settings.BacklightFlag, NULL, "Backlight:", NULL);

    //    ( )
    if(result != -1)
    {
        // /      
        gfx_BackLight(result);
        //     EEPROM
        TX_SaveSettings();

    }
}

// ***          *************************
void Calibration_AP(char AddParam) {Calibration();}

// ***       *********************************************************
flash MenuButton OptionsMenuButtons[] =
{{"Sound",       OptionsSoundSet,     OptionsSoundGetStr},
 {"Backlight",   OptionsBacklightSet, OptionsBacklightGetStr},
 {"Calibration", Calibration_AP,      NULL}};

// ***       ********************************************************
void OptionsMenu(char AddParam)
{
    //   
    MenuPad Pad = {"Options", &Font_8x12, &Font_6x8, OptionsMenuButtons, NumberOf(OptionsMenuButtons), 0, NULL, NULL};
    //   
    MenuCycle(&Pad);
}

// *****************************************************************************
// ***       ********************************************************
// *****************************************************************************

// ***          *************************
void IO_Test_AP(char AddParam) {IO_Test();}
void    Demo_AP(char AddParam) {Demo();}

// ***       *********************************************************
flash MenuButton TestMenuButtons[] =
{{"Model",    ModelMenu,    NULL},
 {"Controls", ControlsMenu, NULL},
 {"Channels", ChannelsMenu, NULL},
 {"Timer",    TimerMenu,    NULL},
 {"Options",  OptionsMenu,  NULL},
 {"IO Test",  IO_Test_AP,   NULL},
 {"Demo",     Demo_AP,      NULL},
 {"Chron",    ChronMenu,    NULL},
 {"Music",    MusicMenu,    NULL}};

// ***       ********************************************************
void MainMenu(void)
{
    //   
    MenuPad Pad = {"Main Menu", &Font_8x12, &Font_6x8, TestMenuButtons, NumberOf(TestMenuButtons), 0, NULL, NULL};
    //   
    MenuCycle(&Pad);
}
