// *****************************************************************************
// ***       ***************************************************
// *****************************************************************************
#define AVR_Clock_Freq 16000000     //   
#define TimerDevider 8              //   
#define TASK_TICK_TIME 20           //     ( )
#define BAUD_RATE 115200            //    UART0

//   -  .     
//  UART0.
//#define DEBUG

//   -     -     .
#define GFX_REVERSED

// ***         *******************************************
#define CURVE_NODES   7
// ***       **************************************************
#define MAX_MODELS    5
// ***      ( n  + -)   ******
#define MODEL_NAME_LEN (12 + 1)
// ***       (n  + -)   *****
#define MODE_NAME_LEN  (10 + 1)

// *****************************************************************************
// ***      ************************************************************
// *****************************************************************************
#define trim_0up        !PINE.7
#define trim_0down      !PINE.6
#define trim_1up        !PINB.2
#define trim_1down      !PINB.3
#define trim_2up        0//   
#define trim_2down      0//   
#define trim_3up        !PINE.4
#define trim_3down      !PINE.5


// *****************************************************************************
// ***       ****************************************************
// *****************************************************************************
#define HB_UP              !PIND.3
#define HB_DOWN            !PIND.1
#define HB_LEFT            !PIND.2
#define HB_RIGHT           !PIND.0
#define HB_BACK            !PIND.4
#define HB_ENTER           !PIND.5

// *****************************************************************************
// ***                                                    ***
// ***    0x00 - 0xFF                                                ***
// *****************************************************************************
#define GAUGE(x)        OCR0 = x

// *****************************************************************************
// ***                                                                 ***
// ***   "1" , "0" . PORTG.2  :(                   ***
// *****************************************************************************
//#define BUZ             PORTG.2
//#define BUZ(x)          PORTG = (PORTG & (~(1 << 2))) | (x << 2)
#define BUZ(x)          PORTB.7 = x

// *****************************************************************************
// ***      **********************************************************
// *****************************************************************************
#define LED1(x)
#define LED2(x)         PORTB.4 = x

// *****************************************************************************
// ***      *******************************************************
// *****************************************************************************
#define MODE_KEY1       !PINE.2
#define MODE_KEY2       !PINE.3

//   SW1  ,    
//   SW1 -  
//#define SW1             !PIND.7
// (   SW1_1  SW1_2) - 
#define SW1_1           !PINA.1
#define SW1_2           !PINA.2
#define SW2             !(PING&(1 << 1)) // PING.1
#define SW3             0
#define SW4             0

#define Tcut_KEY        !(PING&(1 << 0)) // PING.0
#define DUAL_AIL        !PIND.6
#define DUAL_ELE        !PIND.7
#define DUAL_RUD        0

// *****************************************************************************
// ***       **********************************************************
// *****************************************************************************
enum
{
    ADC_AUX2 = 0,
    ADC_AUX3,
    ADC_AUX1,
    ADC_AIL,
    ADC_ELE,
    ADC_THR,
    ADC_RUD,
    ADC_BAT,
    MAX_ADC
};

// *****************************************************************************
// ***       *************************************************
// *****************************************************************************
enum
{
    CTRL_AIL = 0, // \
    CTRL_ELE,     // |   ,   
    CTRL_THR,     // |    4- 
    CTRL_RUD,     // /
    CTRL_SW1,
    CTRL_SW2,
    CTRL_SW3,
    CTRL_AUX1,
    CTRL_V1, //     , CTRL_V1    
    CTRL_V2, // , ..          .
    CTRL_TRIM,
    MAX_CONTROLS
};

// *****************************************************************************
// ***        *************************************
// *****************************************************************************
enum
{
    CTRLS_REV = 0,
    CTRLS_MAXR,
    CTRLS_MINR,
    CTRLS_MAXDR,
    CTRLS_MINDR,
    CTRLS_TCUT,
    CTRLS_FROM,
    CTRLS_CURVE,
    MAX_CTRL_SETTINGS
};

// *****************************************************************************
// ***   Trimmers   ************************************************************
// *****************************************************************************
enum
{
    TRM_AIL = 0,
    TRM_ELE,
    TRM_THR,
    TRM_RUD,
    MAX_TRIMMERS
};

// *****************************************************************************
// ***    PPM   **********************************************************
// *****************************************************************************
enum
{
    CH_AIL = 0,
    CH_ELE,
    CH_THR,
    CH_RUD,
    CH_AUX1,
    CH_AUX2,
    CH_AUX3,
    CH_BAT,
    MAX_CHANNELS
};

// *****************************************************************************
// ***   Model types   *********************************************************
// *****************************************************************************
enum
{
    TYPE_PLANE = 0,
    TYPE_HELI,
    TYPE_GLIDER,
    MAX_TYPES
};

// *****************************************************************************
// ***   Fly modes   ***********************************************************
// *****************************************************************************
enum
{
    M_NORMAL = 0,
    M_IDLEUP,
    M_THOLD,
    MAX_MODES
};

// *****************************************************************************
// ***   TX Modulation types   *************************************************
// *****************************************************************************
enum
{
    MODUL_PPM = 0,
    MODUL_IPPM,
    MODUL_PCM,
    MAX_MODULS
};

// *****************************************************************************
// *****************************************************************************
// ***     -  -   !!!   *************
// *****************************************************************************
// *****************************************************************************

// ***       n    ***********************************
#define TimerClockPerSec(s) ((unsigned long)(s * AVR_Clock_Freq) / TimerDevider)

// ***         ********************************
#define NumberOf(x) (sizeof(x)/sizeof(x[0]))

// ***      *********************************************************
#define TRUE  1
#define FALSE 0
#define ON    1
#define OFF   0
#define On    1
#define Off   0
#define High  1
#define Low   0

// *****************************************************************************
// ***        *******************************************
// *****************************************************************************
enum
{
    // String (char) ptrs
    PTR_FLASH = 0,
    PTR_SRAM,
    PTR_EEPROM,
    // Variables ptrs
    PTR_CHAR,
    PTR_UCHAR,
    PTR_INT,
    PTR_UINT,
    MAX_PTR_TYPES
};

// *****************************************************************************
// *****************************************************************************
// *****************************************************************************
// *****************************************************************************
// *****************************************************************************
