/*******************************************************************************
*  Demo.c
*
*  : 
*
*       Copyright (c) 2007-2009 Nick Shl, focus
*           All rights reserved.
*
*
*  :
*
*  Mar 23, 2009  Nick_Shl   
*
*/// ***************************************************************************

// *****************************************************************************
// ***       ***************************************************
// *****************************************************************************
#include <mega128.h>
#include <delay.h>
#include <stdio.h>

// *****************************************************************************
// ***       ********************************************
// *****************************************************************************
#include "Def.h"
#include "Hardware.h"
#include "Coder.h"
#include "Graphic.h"
#include "Sound.h"
#include "Variables.h"
#include "UI_Engine.h"

// *****************************************************************************
// ***       ***********************************************
// *****************************************************************************
flash unsigned int DataTable[]={
0x0A51, 0x0F71, 0x14A1, 0x1881, 0x0A51, 0x0F71, 0x14A1, 0x1881, 0x0A51, 0x0F71, 0x14A1, 0x1881, 0x0A51, 0x0F71, 0x14A1,
0x1881, 0x0A51, 0x1061, 0x14A1, 0x1B81, 0x0A51, 0x1061, 0x14A1, 0x1B81, 0x0A51, 0x1061, 0x14A1, 0x1B81, 0x0A51, 0x1061,
0x14A1, 0x1B81, 0x0A51, 0x0DC1, 0x1261, 0x1721, 0x0A51, 0x0DC1, 0x1261, 0x1721, 0x0A51, 0x0DC1, 0x1261, 0x1721, 0x0A51,
0x0DC1, 0x1261, 0x1721, 0x0A51, 0x0F71, 0x14A1, 0x1881, 0x0A51, 0x0F71, 0x14A1, 0x1881, 0x0A51, 0x0F71, 0x14A1, 0x1881,
0x0A51, 0x0F71, 0x14A1, 0x1881, 0x0931, 0x1061, 0x1721, 0x1B81, 0x0931, 0x1061, 0x1721, 0x1B81, 0x0931, 0x1061, 0x1721,
0x1B81, 0x0931, 0x1061, 0x1721, 0x1B81, 0x0C41, 0x0F71, 0x1261, 0x1EE1, 0x0C41, 0x0F71, 0x1261, 0x1EE1, 0x0C41, 0x0F71,
0x1261, 0x1EE1, 0x0C41, 0x0F71, 0x1261, 0x1EE1, 0x0831, 0x0C41, 0x14A1, 0x1EE1, 0x0831, 0x0C41, 0x14A1, 0x1EE1, 0x0831,
0x0B91, 0x14A1, 0x1B81, 0x0831, 0x0B91, 0x14A1, 0x1B81, 0x07B1, 0x0C41, 0x14A1, 0x1EE1, 0x07B1, 0x0C41, 0x14A1, 0x1EE1,
0x07B1, 0x0DC1, 0x1061, 0x1371, 0x07B1, 0x0DC1, 0x0F71, 0x1371, 0x0A51, 0x0C41, 0x0F71, 0x14A1, 0x0A51, 0x0C41, 0x0F71,
0x14A1, 0x0A51, 0x0F71, 0x14A1, 0x1881, 0x0A51, 0x0F71, 0x14A1, 0x1881, 0x0931, 0x1261, 0x1881, 0x1B81, 0x0931, 0x1261,
0x1881, 0x1B81, 0x0931, 0x1061, 0x1721, 0x1B81, 0x0931, 0x1061, 0x1721, 0x1B81, 0x0C41, 0x0F71, 0x1261, 0x1881, 0x0C41,
0x0F71, 0x1261, 0x1881, 0x0C41, 0x1261, 0x1881, 0x1EE1, 0x0C41, 0x1261, 0x1881, 0x1EE1, 0x0B91, 0x1721, 0x1EE1, 0x22A1,
0x0B91, 0x1721, 0x1EE1, 0x22A1, 0x0B91, 0x14A1, 0x1D21, 0x22A1, 0x0B91, 0x14A1, 0x1D21, 0x22A1, 0x0F71, 0x1261, 0x1721,
0x24B1, 0x0F71, 0x1261, 0x1721, 0x24B1, 0x0DC1, 0x1EE1, 0x24B1, 0x2E41, 0x0DC1, 0x1EE1, 0x24B1, 0x2E41, 0x0D01, 0x1EE1,
0x24B1, 0x3DC1, 0x0D01, 0x1EE1, 0x24B1, 0x3DC1, 0x0C41, 0x1721, 0x1EE1, 0x24B1, 0x0C41, 0x15E1, 0x1EE1, 0x24B1, 0x0B91,
0x1721, 0x1EE1, 0x22A1, 0x0B91, 0x1721, 0x1EE1, 0x22A1, 0x0B91, 0x1EE1, 0x22A1, 0x2E41, 0x0B91, 0x1EE1, 0x22A1, 0x2E41,
0x0B91, 0x1721, 0x1D21, 0x22A1, 0x0B91, 0x1721, 0x1D21, 0x22A1, 0x0B91, 0x1D21, 0x22A1, 0x2E41, 0x0B91, 0x1D21, 0x22A1,
0x2E41, 0x0F71, 0x3DC1, 0x2E41, 0x24B1, 0x1EE1, 0x2E41, 0x24B1, 0x1EE1, 0x1721, 0x3DC1, 0x1EE1, 0x1721, 0x1261, 0x1061,
0x0F71, 0x0DC1, 0x0C41, 0x3DC1, 0x2E41, 0x24B1, 0x1EE1, 0x2E41, 0x24B1, 0x1EE1, 0x1721, 0x24B1, 0x1EE1, 0x1721, 0x1261,
0x1151, 0x0F71, 0x0C41, 0x0B91, 0x2E41, 0x22A1, 0x1EE1, 0x1721, 0x22A1, 0x1EE1, 0x1721, 0x14A1, 0x1EE1, 0x1D21, 0x1721,
0x1151, 0x0F71, 0x0E91, 0x0B91, 0x0931, 0x1261, 0x1721, 0x1261, 0x0F71, 0x1EE1, 0x1721, 0x0F71, 0x09C1, 0x1EE1, 0x1721,
0x1371, 0x0F71, 0x1B81, 0x1721, 0x0F71, 0x14A1, 0x5261, 0x3DC1, 0x3101, 0x2931, 0x3DC1, 0x3101, 0x2931, 0x1EE1, 0x3101,
0x2931, 0x1EE1, 0x1881, 0x1721, 0x14A1, 0x1261, 0x1061, 0x5261, 0x3DC1, 0x3101, 0x2931, 0x3DC1, 0x3101, 0x2931, 0x1EE1,
0x3101, 0x2931, 0x1EE1, 0x1881, 0x1721, 0x14A1, 0x1061, 0x0F71, 0x3DC1, 0x2E41, 0x2931, 0x1EE1, 0x2E41, 0x2931, 0x1EE1,
0x1B81, 0x2931, 0x26E1, 0x1EE1, 0x1721, 0x14A1, 0x1371, 0x0F71, 0x07B1, 0x0F71, 0x1371, 0x1721, 0x1EE1, 0x26E1, 0x2E41,
0x3DC1, 0x3101, 0x2931, 0x1EE1, 0x1881, 0x1721, 0x1371, 0x0F71, 0x09C1, 0x0A51, 0x0F71, 0x14A1, 0x1881, 0x0A51, 0x0F71,
0x14A1, 0x1881, 0x0A51, 0x0F71, 0x14A1, 0x1881, 0x0A51, 0x0F71, 0x14A1, 0x1881, 0x0A51, 0x1061, 0x14A1, 0x1B81, 0x0A51,
0x1061, 0x14A1, 0x1B81, 0x0A51, 0x1061, 0x14A1, 0x1B81, 0x0A51, 0x1061, 0x14A1, 0x1B81, 0x0A51, 0x0DC1, 0x1261, 0x1721,
0x0A51, 0x0DC1, 0x1261, 0x1721, 0x0A51, 0x0DC1, 0x1261, 0x1721, 0x0A51, 0x0DC1, 0x1261, 0x1721, 0x0A51, 0x0F71, 0x14A1,
0x1881, 0x0A51, 0x0F71, 0x14A1, 0x1881, 0x0A51, 0x0F71, 0x14A1, 0x1881, 0x0A51, 0x0F71, 0x14A1, 0x1881, 0x0931, 0x1061,
0x1721, 0x1B81, 0x0931, 0x1061, 0x1721, 0x1B81, 0x0931, 0x1061, 0x1721, 0x1B81, 0x0931, 0x1061, 0x1721, 0x1B81, 0x0C41,
0x0F71, 0x1261, 0x1EE1, 0x0C41, 0x0F71, 0x1261, 0x1EE1, 0x0C41, 0x0F71, 0x1261, 0x1EE1, 0x0C41, 0x0F71, 0x1261, 0x1EE1,
0x0831, 0x0C41, 0x14A1, 0x1EE1, 0x0831, 0x0C41, 0x14A1, 0x1EE1, 0x0831, 0x0B91, 0x14A1, 0x1B81, 0x0831, 0x0B91, 0x14A1,
0x1B81, 0x0831, 0x0F71, 0x14A1, 0x1881, 0x0831, 0x0F71, 0x14A1, 0x1881, 0x0831, 0x0DC1, 0x14A1, 0x1721, 0x0831, 0x0DC1,
0x14A1, 0x1721, 0x0831, 0x0C41, 0x14A1, 0x1EE1, 0x0831, 0x0C41, 0x14A1, 0x1EE1, 0x0831, 0x0B91, 0x14A1, 0x1B81, 0x0831,
0x0B91, 0x14A1, 0x1B81, 0x07B1, 0x0F71, 0x14A1, 0x1881, 0x07B1, 0x0F71, 0x14A1, 0x1881, 0x07B1, 0x0DC1, 0x1371, 0x1721,
0x07B1, 0x0DC1, 0x1371, 0x1721, 0x0A51, 0x5261, 0x3DC1, 0x3101, 0x2931, 0x1EE1, 0x1881, 0x14A1, 0x0F71, 0x3DC1, 0x3101,
0x2931, 0x1EE1, 0x1881, 0x14A1, 0x0F71, 0x0C41, 0x3101, 0x2931, 0x3101, 0x2E41, 0x3DC1, 0x4DC1, 0x5C81, 0xA4D1, 0x3DC1,
0x3101, 0x2931, 0x1EE1, 0x1881, 0x14A1, 0x0F71, 0x0A5F, 0x000F};

// *****************************************************************************
// ***      ****************************************************************
// *****************************************************************************
void Demo(void)
{
    signed int U_bat;

    Settings.SoundFlag = ON;

    gfx_ClearBuf();

    gfx_SetXY((WidthS - Font_4x6.W) >> 1, (HeightS - Font_4x6.H) >> 1);
    gfx_PutFlashStr("1", 0xFF, &Font_4x6);
    gfx_Refresh();
    delay_ms(500);

    gfx_SetXY((WidthS - Font_6x8.W) >> 1, (HeightS - Font_6x8.H) >> 1);
    gfx_PutFlashStr("2", 0xFF, &Font_6x8);
    gfx_Refresh();
    delay_ms(500);

    gfx_SetXY((WidthS - Font_8x8.W) >> 1, (HeightS - Font_8x8.H) >> 1);
    gfx_PutFlashStr("3", 0xFF, &Font_8x8);
    gfx_Refresh();
    delay_ms(500);

    gfx_SetXY((WidthS - Font_8x12.W*8) >> 1, (HeightS - Font_8x12.H) >> 1);
    gfx_PutFlashStr("!", 0xFF, &Font_8x12);

    U_bat = read_adc(ADC_BAT);
    U_bat = U_bat*2;
    sprintf(tmpBuf, "%2i.%02iV", U_bat/100, U_bat%100);
    gfx_SetXY(0, HeightS - Font_8x12.H);
    gfx_PutStr(tmpBuf, 0xFF, &Font_8x12);

    gfx_Refresh();

    PlaySound(DataTable, NumberOf(DataTable));

    while(IsSoundPlayed() == TRUE)
    {
        gfx_SetXY(0, 0);
        gfx_PutFlashStr("  4x6", 0xFF, &Font_4x6);
        gfx_SetXY(0, 8);
        gfx_PutFlashStr("  6x8", 0xFF, &Font_6x8);
        gfx_SetXY(0, 16);
        gfx_PutFlashStr("  8x8", 0xFF, &Font_8x8);
        gfx_SetXY(0, 24);
        gfx_PutFlashStr("  8x12", 0xFF, &Font_8x12);

        if(Settings.BacklightFlag == ON)
        {
            gfx_SetXY(0, 36);
            gfx_PutFlashStr("  ", 0xFF, &Font_8x12);
        }
        else
        {
            gfx_SetXY(0, 36);
            gfx_PutFlashStr(" ", 0xFF, &Font_8x12);
        }

        U_bat = read_adc(ADC_BAT);
        U_bat = U_bat*2;
        sprintf(tmpBuf, "%2i.%02iV", U_bat/100, U_bat%100);
        gfx_SetXY(0, HeightS - Font_8x12.H);
        gfx_PutStr(tmpBuf, 0xFF, &Font_8x12);

        gfx_Refresh();

        if(HB_UP || HB_DOWN || HB_LEFT || HB_RIGHT || HB_ENTER) break;
    }

    StopSound();

    gfx_ClearBuf();
    gfx_SetXY((WidthS - Font_8x12.W*10) >> 1, ((HeightS - Font_8x12.H) >> 1) - Font_8x12.H);
    gfx_PutFlashStr(" ", 0xFF, &Font_8x12);
    gfx_SetXY((WidthS - Font_8x12.W*9) >> 1, (HeightS - Font_8x12.H) >> 1);
    gfx_PutFlashStr("", 0xFF, &Font_8x12);
    gfx_SetXY((WidthS - Font_8x12.W*9) >> 1, ((HeightS - Font_8x12.H) >> 1) + Font_8x12.H);
    gfx_PutFlashStr("", 0xFF, &Font_8x12);
    gfx_Refresh();

    Tone(1000);
    delay_ms(1000);
    Tone(0);
}

// *****************************************************************************
// ***          *****************************************
// *****************************************************************************
void IO_Test(void)
{
    char i;
    char buf[32];

    #asm("cli")

    gfx_ClearBuf();
    gfx_SetXY((WidthS - 9*Font_8x12.W) >> 1, (HeightS - 1*Font_8x12.H) >> 1);
    gfx_PutFlashStr("Test Mode", 0xFF, &Font_8x12);
    gfx_Refresh();
    delay_ms(500);

    while(!HB_ENTER)
    {
        gfx_ClearBuf();

        for(i=0; i < MAX_ADC; i++)
        {
            sprintf(buf, "AD%d: %4d", i, read_adc(i));
            if(i < 4) gfx_SetXY(0, Font_6x8.H * (i%4));
            else gfx_SetXY(WidthS/2, Font_6x8.H * (i%4));
            gfx_PutStr(buf, 0xFF, &Font_6x8);
        }

        gfx_SetXY(0, Font_6x8.H * 6);
        gfx_PutFlashStr("D: ", 0xFF, &Font_6x8);
        for(i=7; i >= 0; i--)
        {
            gfx_Char('0' + i, (PIND & (1 << i)) ? 0xFF : 0, &Font_6x8);
        }

        gfx_SetXY(0, Font_6x8.H * 7);
        gfx_PutFlashStr("E: ", 0xFF, &Font_6x8);
        for(i=7; i >= 0; i--)
        {
            gfx_Char('0' + i, (PINE & (1 << i)) ? 0xFF : 0, &Font_6x8);
        }

        gfx_SetXY(0, Font_6x8.H * 5);
        gfx_PutFlashStr("A: ", 0xFF, &Font_6x8);
        gfx_Char('2', PINA.2 ? 0xFF : 0, &Font_6x8);
        gfx_Char('1', PINA.1 ? 0xFF : 0, &Font_6x8);

        gfx_SetXY(Font_6x8.W*6, Font_6x8.H * 5);
        gfx_PutFlashStr("B: ", 0xFF, &Font_6x8);
        for(i=3; i >= 0; i--)
        {
            gfx_Char('0' + i, (PINB & (1 << i)) ? 0xFF : 0, &Font_6x8);
        }

        gfx_SetXY(Font_6x8.W*13, Font_6x8.H * 5);
        gfx_PutFlashStr("G: ", 0xFF, &Font_6x8);
        gfx_Char('1', PING&2 ? 0xFF : 0, &Font_6x8);
        gfx_Char('0', PING&1 ? 0xFF : 0, &Font_6x8);

        gfx_Refresh();
    }

    while(!HB_ENTER);
    delay_ms(100);
    while(HB_ENTER);

    #asm("sei")
}


// *****************************************************************************
// ***   Chron   ***************************************************************
// *****************************************************************************

volatile unsigned char ovf;
volatile unsigned char dir;
volatile unsigned char ovf;
// ***   Chron   ***************************************************************
// Timer 1 overflow interrupt service routine
interrupt [TIM1_OVF] void timer1_ovf_isr(void)
{
    ovf = 1;
}

// ***   Chron   ***************************************************************
void Chron(void)
{
    char flag = 1, refresh = 1;
    unsigned int t1[2]={0,0}, t2[2]={0,0};
    unsigned long l;
    char buf[32];

    #asm("cli")

    //  
// Timer/Counter 1 initialization
// Clock source: System Clock
// Clock value: 2000,000 kHz
// Mode: Normal top=FFFFh
// OC1A output: Discon.
// OC1B output: Discon.
// OC1C output: Discon.
// Noise Canceler: Off
// Input Capture on Falling Edge
// Timer 1 Overflow Interrupt: On
// Input Capture Interrupt: Off
// Compare A Match Interrupt: Off
// Compare B Match Interrupt: Off
// Compare C Match Interrupt: Off
    TCCR1A = 0x00;
    TCCR1B = 0x02;
    TCNT1H = 0x00;
    TCNT1L = 0x00;
    ICR1H  = 0x00;
    ICR1L  = 0x00;
    OCR1AH = 0x00;
    OCR1AL = 0x00;
    OCR1BH = 0x00;
    OCR1BL = 0x00;
    OCR1CH = 0x00;
    OCR1CL = 0x00;
    //  USART0
    UCSR0A = 0x00;
    UCSR0B = 0x00;
    UCSR0C = 0x00;
    UBRR0H = 0x00;
    UBRR0L = 0x00;

    // Timer(s)/Counter(s) Interrupt(s) initialization
    TIMSK = 0x04;
    ETIMSK = 0x00;

    #asm("sei")

    while(!HB_BACK)
    {
        if(HB_ENTER)
        {
            flag = 1;
            t1[0] = 0;
            t1[1] = 0;
            t2[0] = 0;
            t2[1] = 0;
            refresh = 1;
        }

        switch(flag)
        {
            case(1):
                if(dir ? !PINE.1 : !PINE.0)
                {
                    t1[0] = 0;
                    TCNT1 = 0;
                    ovf = 0;
                    flag = 2;
                }
                break;

            case(2):
                if(dir ? PINE.1 : PINE.0)
                {
                    t1[1] = TCNT1;
                    flag = 3;
                }
                break;

            case(3):
//                if(dir ? !PINE.1 : !PINE.0) flag = 2; // TEST for checking speed
                if(dir ? !PINE.0 : !PINE.1)
                {
                    t2[0] = TCNT1;
                    flag = 4;
                }
                break;

            case(4):
                if(dir ? PINE.0 : PINE.1)
                {
                    t2[1] = TCNT1;
                    flag = 5;
//                    refresh = 1;
                }
                break;

            case(5):
//                if(dir ? !PINE.0 : !PINE.1) flag = 4; // TEST for checking speed
                if(ovf)
                {
                    flag = 0;
                    refresh = 1;
                }
                break;

            default:

                break;
        }
/*
        if(ovf && (flag > 1))
        {
            gfx_ClearBuf();
            sprintf(buf, "ERROR - TIMER OVERFLOW");
            gfx_Refresh();
            flag = 0;
        }
*/
        if(refresh)
        {
            gfx_ClearBuf();

            gfx_SetXY(0, Font_6x8.H * 0);
            sprintf(buf, "T1S: %5u", t1[0]);
            gfx_PutStr(buf, 0xFF, &Font_6x8);

            gfx_SetXY(WidthS/2, Font_6x8.H * 0);
            sprintf(buf, "T1E: %5u", t1[1]);
            gfx_PutStr(buf, 0xFF, &Font_6x8);

            gfx_SetXY(0, Font_6x8.H * 1);
            sprintf(buf, "T2S: %5u", t2[0]);
            gfx_PutStr(buf, 0xFF, &Font_6x8);

            gfx_SetXY(WidthS/2, Font_6x8.H * 1);
            sprintf(buf, "T2E: %5u", t2[1]);
            gfx_PutStr(buf, 0xFF, &Font_6x8);

            gfx_SetXY(0, Font_6x8.H * 2);
            sprintf(buf, "Speed 1: %3u m/s", 140000l / t2[0]);
            gfx_PutStr(buf, 0xFF, &Font_6x8);

            gfx_SetXY(0, Font_6x8.H * 3);
            sprintf(buf, "Speed 2: %3u m/s", 140000l / (t2[1] - t1[1]));
            gfx_PutStr(buf, 0xFF, &Font_6x8);

            l = ((140000l * t1[1]) / t2[0]) / 200;
            gfx_SetXY(0, Font_6x8.H * 4);
            sprintf(buf, "L1S1: %3u.%1u mm", l/10, l%10);
            gfx_PutStr(buf, 0xFF, &Font_6x8);

            l = ((140000l * t1[1]) / (t2[1] - t1[1])) / 200;
            gfx_SetXY(WidthS/2, Font_6x8.H * 4);
            sprintf(buf, "L1S2: %3u.%1u mm", l/10, l%10);
            gfx_PutStr(buf, 0xFF, &Font_6x8);

            l = ((140000l * (t2[1] - t2[0])) / t2[0]) / 200;
            gfx_SetXY(0, Font_6x8.H * 5);
            sprintf(buf, "L2S1: %3u.%1u mm", l/10, l%10);
            gfx_PutStr(buf, 0xFF, &Font_6x8);

            l = ((140000l * (t2[1] - t2[0])) / (t2[1] - t1[1])) / 200;
            gfx_SetXY(WidthS/2, Font_6x8.H * 5);
            sprintf(buf, "L2S2: %3u.%1u mm", l/10, l%10);
            gfx_PutStr(buf, 0xFF, &Font_6x8);

            gfx_Refresh();
            refresh = 0;
        }
    }

    //  
    hwl_InitUSART0(BAUD_RATE); // USART0 initialization
    hwl_InitTimers(); // Timers/Counters initialization
    TIMSK = 0x10; //      
    ETIMSK = 0x10; //     
}

// *****************************************************************************
// ***    ""   ********************************************************
// *****************************************************************************

// ***        **************************************
char * ChronDirGetStr(char * Buf, char AddParam)
{
    //     
    sprintf(Buf, dir ? "REV" : "NOR");
    //     
    return(Buf);
}
// ***       *****************************************************
void ChronDirSet(char AddParam)
{
    //    
    char result;
    //    
    flash char * Strings[2] = {"NOR", "REV"};

    //    
    result = SelectBoxF((flash char **)Strings, 2, dir, NULL, "Direction:", NULL);

    //    ( )
    if(result != -1) dir = result;  //   
}

// ***          *************************
void Chron_AP(char AddParam) {Chron();}

// ***       *********************************************************
flash MenuButton ChronMenuButtons[] =
{{"Start",       Chron_AP, NULL},
 {"Direction",   ChronDirSet,   ChronDirGetStr}};

// ***       ********************************************************
void ChronMenu(char AddParam)
{
    //   
    MenuPad Pad = {"Chron", &Font_8x12, &Font_6x8, ChronMenuButtons, NumberOf(ChronMenuButtons), 0, NULL, NULL};
    //   
    MenuCycle(&Pad);
}