/*******************************************************************************
*  Math.c
*
*  : 
*
*       Copyright (c) 2007-2008 Nick Shl, focus
*           All rights reserved.
*
*
*  :
*
*  Apr 20, 2009  Nick_Shl  
*  Apr 10, 2008  Nick_Shl  , 
*  *** **, ****  focus      
*
*/// ***************************************************************************

// *****************************************************************************
// ***       ***************************************************
// *****************************************************************************
#include <mega128.h>
#include <string.h>

// *****************************************************************************
// ***       ********************************************
// *****************************************************************************
#include "Def.h"
#include "Coder.h"
#include "Sound.h"
#include "Tasks.h"
#include "Variables.h"

// *****************************************************************************
// ***         ()  ********
// *****************************************************************************
void math_CalcChannel(char CH)
{
    char i;
    signed long Factor;

    //      - 
    if(CH < 0) return;
    //        - 
    if(CH > MAX_CHANNELS) return;

    //     
    output[CH] = 0;

    //   
    for(i=0; i < MAX_CONTROLS; i++)
    {
        //     i   CH  -  
        if(CurModel.Mode[FLY_MODE].Chanels[CH][i] != 0)
        {
            //     i   CH
            Factor = CurModel.Mode[FLY_MODE].Chanels[CH][i];
            //    i   CH
            output[CH] += out_cur[i] * Factor / 100;
        }
    }

    //  :
    //  (+-0,5 ) +  (1,5 )
    output[CH] += TimerClockPerSec(0.0015);
    //   int   :        int
    //  : 1,5   1/666,6(6) ...

    //     0,0009  (0,9 ) - 
    if(output[CH] < TimerClockPerSec(0.0009)) output[CH] = TimerClockPerSec(0.0009);

    //     0,0021  (2,1 ) - 
    if(output[CH] > TimerClockPerSec(0.0021)) output[CH] = TimerClockPerSec(0.0021);
}

// *****************************************************************************
// ***        ******************************************
// *****************************************************************************
signed int math_InterPolEx(signed int Val, signed int Max, signed int K, signed char * Nodes, signed char NodesCount)
{
    unsigned char n;
    signed int n1, n2, ln;
    //  .   long,     
    //    .
    signed long InterPoolSize;

    //         -   
    if(Nodes == NULL) return(Val);
    //       0   -   
    if(NodesCount <= 0) return(Val);

    //      0 - 
    if(Val < 0) Val = 0;
    //        Max
    //     - 
    if(Val >= Max) Val = Max - 1;

    //    -   /   
    InterPoolSize = Max / (NodesCount - 1);

    //     :
    //          
    n  = (Val * (NodesCount - 1)) / Max;
    //     
    n1 = (*(Nodes + n)     * K) / 10;
    //     
    n2 = (*(Nodes + n + 1) * K) / 10;
    //  
    //        (Y)
    //     (X)
    ln = (Val - n * InterPoolSize) * (n2 - n1) / InterPoolSize;

    return(n1 + ln);
}

// *****************************************************************************
// ***       ******************************************************
// *****************************************************************************
static inline signed int math_CurveInterPol(signed int Val, signed char * Nodes)
{
    //  0,5  -    
    Val += TimerClockPerSec(0.0005);
    //       
    return(math_InterPolEx(Val, TimerClockPerSec(0.001), TimerClockPerSec(0.0005) / 10, Nodes, CURVE_NODES));
}

// *****************************************************************************
// ***        ************************************************
// *****************************************************************************
//        . 
//         .
//         .
inline signed int math_InterPol(signed int Val, signed int Max, signed char * Nodes, signed char NodesCount)
{
    //        
    return(math_InterPolEx(Val, Max, 10, Nodes, NodesCount));
}

// *****************************************************************************
// ***       *************************************************
// *****************************************************************************
void math_ChangeTrimmer(signed char * trim, signed char dir)
{
    if(dir == 0) return;
    if((dir > 0) && (*trim + dir >  96)) return;
    if((dir < 0) && (*trim + dir < -96)) return;
    *trim += dir;
    Trimmers_Need_Save(15);
    trim_sound_en = 1;
}

// *****************************************************************************
// ***            *************************
// *****************************************************************************
void math_CalcControls(void)
{
    char i, Dual[MAX_CONTROLS];
    int TrimFactor;
    signed long Factor;
    unsigned char NewTrimMask = 0;
    static unsigned char TrimMask = 0;

    //  
    if(MODE_KEY2)                FLY_MODE = 1;
    if(!MODE_KEY1 && !MODE_KEY2) FLY_MODE = 0;
    if(MODE_KEY1)                FLY_MODE = 2;

    //       
    if(trim_0up)   NewTrimMask |= 0x01;
    if(trim_0down) NewTrimMask |= 0x02;
    if(trim_1up)   NewTrimMask |= 0x04;
    if(trim_1down) NewTrimMask |= 0x08;
    if(trim_2up)   NewTrimMask |= 0x10;
    if(trim_2down) NewTrimMask |= 0x20;
    if(trim_3up)   NewTrimMask |= 0x40;
    if(trim_3down) NewTrimMask |= 0x80;
    //     -  
    if(NewTrimMask != TrimMask)
    {
        TrimMask = NewTrimMask;
    }
    //        - 
    else if(TrimMask != 0)
    {
        // 8    8   
        for(i=0; i<8; i++)
        {
            //     i- 
            if(TrimMask & (1 << i))
                //  i -     
                if(i & 0x01) math_ChangeTrimmer(&CurModel.Mode[FLY_MODE].trimmers[i/2], -1);
                //     
                else         math_ChangeTrimmer(&CurModel.Mode[FLY_MODE].trimmers[i/2],  1);
        }
    }

    //   
    if(Tcut_KEY) Cut_enable = 1;
    else         Cut_enable = 0;

    //      
    for(i=0; i < MAX_ADC; i++)
    {
        AD[i] = read_adc(i);
        //  ADmid unsigned      
        // .     ...
        if(AD[i] > Settings.ADmid[i]) AD_NORM[i] = ((AD[i] - Settings.ADmid[i]) * Settings.Kmax[i]) / 10;
        else                          AD_NORM[i] = ((AD[i] - Settings.ADmid[i]) * Settings.Kmin[i]) / 10;
    }

    //        
    //   
    input[CTRL_AIL]  = AD_NORM[ADC_AIL];
    input[CTRL_ELE]  = AD_NORM[ADC_ELE];
    input[CTRL_THR]  = AD_NORM[ADC_THR];
    input[CTRL_RUD]  = AD_NORM[ADC_RUD];
    input[CTRL_AUX1] = AD_NORM[ADC_AUX1];

#ifdef SW1
    //      SW1 ()
    if(SW1) input[CTRL_SW1] =   TimerClockPerSec(0.0005); // +0,5 
    else    input[CTRL_SW1] = - TimerClockPerSec(0.0005); // -0,5 
#else
    //      SW1 ()
    if(SW1_1)            input[CTRL_SW1] =   TimerClockPerSec(0.0005); // +0,5 
    if(!SW1_1 && !SW1_2) input[CTRL_SW1] =   0;                     //  0   
    if(SW1_2)            input[CTRL_SW1] = - TimerClockPerSec(0.0005); // -0,5 
#endif

    //      SW2 ()
    if(SW2) input[CTRL_SW2] =   TimerClockPerSec(0.0005); // +0,5 
    else    input[CTRL_SW2] = - TimerClockPerSec(0.0005); // -0,5 

    //      SW3 ()
    if(SW3) input[CTRL_SW3] =   TimerClockPerSec(0.0005); // +0,5 
    else    input[CTRL_SW3] = - TimerClockPerSec(0.0005); // -0,5 

    //     
    input[CTRL_V1] = input[CurModel.Mode[FLY_MODE].Control[CTRL_V1].from];
    input[CTRL_V2] = input[CurModel.Mode[FLY_MODE].Control[CTRL_V2].from];

    //      .   0,5 .
    //        .
    input[CTRL_TRIM] = TimerClockPerSec(0.0005);

    //    
    memset(Dual, 0, sizeof(Dual));
    //   
    Dual[CTRL_AIL] = DUAL_AIL;
    Dual[CTRL_ELE] = DUAL_ELE;
    Dual[CTRL_RUD] = DUAL_RUD;

    for(i=0; i < MAX_CONTROLS; i++)
    {
        //      -      .
        if((i == CTRL_SW1) ||
           (i == CTRL_SW2) ||
           (i == CTRL_SW3) ||
           (i == CTRL_TRIM))
        {
            out_cur[i] = input[i];
        }
        else
        {
            //     
            out_cur[i] = math_CurveInterPol(input[i], CurModel.Mode[FLY_MODE].Control[i].nodes);
        }

        // 
        if(Dual[i])
        {
            if(input[i] < 0) Factor = CurModel.Mode[FLY_MODE].Control[i].minDRates;
            else             Factor = CurModel.Mode[FLY_MODE].Control[i].maxDRates;
        }
        else
        {
            if(input[i] < 0) Factor = CurModel.Mode[FLY_MODE].Control[i].minRates;
            else             Factor = CurModel.Mode[FLY_MODE].Control[i].maxRates;
        }
        if(Factor != 100) out_cur[i] = out_cur[i] * Factor / 100;

        //   T.Cut
        if((i == CTRL_THR) && Cut_enable)
        {
            Factor = CurModel.Mode[FLY_MODE].Control[i].minDRates; // minDRates    -   T.Cut
            out_cur[i] = (- TimerClockPerSec(0.0005)) * Factor / 100;
        }

        //      
        // FIX ME:    enum
        if(i < MAX_TRIMMERS)
        {
            TrimFactor = CurModel.Mode[FLY_MODE].trimmers[i];
            out_cur[i] += TrimFactor * 2; // FIX ME:   ,   
        }

        //   
        out_cur[i] *= CurModel.Mode[FLY_MODE].Control[i].reverse;
    }
}
