/*******************************************************************************
*  MT12864.c
*
*  :     
*
*       Copyright (c) 2007-2008 Nick Shl, focus
*           All rights reserved.
*
*
*  :
*
*  Apr 20, 2009  Nick_Shl  
*  Apr 10, 2008  Nick_Shl  ,  
*                             
*  *** **, ****  focus      
*
*/// ***************************************************************************

// *****************************************************************************
// ***       ***************************************************
// *****************************************************************************
#include <mega128.h>
#include <delay.h>

// *****************************************************************************
// ***       ********************************************
// *****************************************************************************
#include "Def.h"
#include "MT12864.h"

// *****************************************************************************
// ***      E  ()  us.                     ***
// ***    1  ,  PROTEUS .   LCD_E            ***
// ***    inline ,    1  .              ***
// ***       .                          ***
// *****************************************************************************
#define E_Del 1
//        8 
#define Del 8

// *****************************************************************************
// ***    .                                                      ***
// ***     - .                                         ***
// *****************************************************************************
#define LCD_BL(x) PORTA.0 = x

// *****************************************************************************
// ***    E  ().                                                ***
// ***     - .                                         ***
// *****************************************************************************
#define LCD_E(x) PORTA.3 = x

// *****************************************************************************
// ***    A0  (/).                                      ***
// ***   "1"  , "0"  .                          ***
// *****************************************************************************
#define LCD_A0(x) PORTA.4 = x

// *****************************************************************************
// ***    RW  (/).                                       ***
// ***  "1" -  , "0" -  .                                ***
// *****************************************************************************
#define LCD_RW(x) PORTA.5 = x

// *****************************************************************************
// ***    CS  ().                                             ***
// ***     -  ???                                       ***
// *****************************************************************************
#define LCD_C1(x) PORTG = (PORTG & (~(1 << 2))) | (x << 2) // PORTG.2
#define LCD_C2(x) PORTA.7 = x
//      . 0 - . 1 - ,  .. ( 2)
//     -    x==0
//#define LCD_CS(x) LCD_C1(x==0 ? High : Low); LCD_C2(x==1 ? High : Low)
inline void LCD_CS(unsigned char x)
{
    if(x == 0) LCD_C1(High);
    else       LCD_C1(Low);
    if(x == 1) LCD_C2(High);
    else       LCD_C2(Low);
}
// *****************************************************************************
// ***    RES  ().                                              ***
// ***     - 1- .  - .                        ***
// *****************************************************************************
#define LCD_RES(x) PORTA.6 = x

// *****************************************************************************
// ***    DATA  ().   *********************************************
// *****************************************************************************
#define LCD_DATA_PORT PORTC
#define LCD_DATA_DDR  DDRC
#define LCD_DATA_PIN  PINC

// *****************************************************************************
// ***           **************************************
// *****************************************************************************
unsigned char LCD_Buf[8][128];

// *****************************************************************************
// ***        ******************************************************
// *****************************************************************************
unsigned char LCD_Pos_X, LCD_Pos_Y;

// *****************************************************************************
// ***       ***********************************************
// *****************************************************************************
void LCD_BackLight(unsigned char Cmd)
{
    LCD_BL(Cmd);
}

// *****************************************************************************
// ***       ,      **********
// *****************************************************************************
void LCD_Wait_Ready(void)
{
//    
    LCD_DATA_PORT = 0x00;
    LCD_DATA_DDR = 0x00;

//  1
    LCD_RW(High);      //  
	LCD_A0(Low);       //   
	LCD_CS(0);         //      
	delay_us(E_Del);   //     (tAW) >140ns
	LCD_E(High);
	delay_us(E_Del);   //    E=1 (       ,     320) >450ns
	while(LCD_DATA_PIN & 0b10000000); //    
	LCD_E(Low);        //   E
	delay_us(E_Del);   //      E=1 > (1000ns-140ns-450ns)

//  2
	LCD_RW(High);      //  
	LCD_A0(Low);       //   
	LCD_CS(1);         //      
	delay_us(E_Del);   //     (tAW) >140ns
	LCD_E(High);
	delay_us(E_Del);   //    E=1 (       ,     320) >450ns
	while(LCD_DATA_PIN & 0b10000000); //    
	LCD_E(Low);        //   E
	delay_us(E_Del);   //      E=1 > (1000ns-140ns-450ns)

//  
	LCD_RW(Low);

//  ,  Proteus  : Logic contension(s) detected on net A**.
	delay_us(Del);

//    
    LCD_DATA_DDR = 0xFF;
}

// *****************************************************************************
// ***         *******************************************
// *****************************************************************************
void LCD_Cmd(unsigned char Chip, unsigned char Cmd)
{
    LCD_CS(Chip);        //  
    LCD_A0(Low);         //  
    LCD_DATA_PORT = Cmd; //    
    delay_us(E_Del);     // 
    LCD_E(High);         //   E
    delay_us(E_Del);     // 
    LCD_E(Low);          //   E
    LCD_Wait_Ready();    //   
}

// *****************************************************************************
// ***         ********************************************
// *****************************************************************************
void LCD_Dat(unsigned char Chip, unsigned char Data)
{
    LCD_CS(Chip);         //  
    LCD_A0(High);         //  
    LCD_DATA_PORT = Data; //    
    delay_us(E_Del);      // 
    LCD_E(High);          //   E
    delay_us(E_Del);      // 
    LCD_E(Low);           //   E
    LCD_Wait_Ready();     //   
}

// *****************************************************************************
// ***   /     **********************************
// *****************************************************************************
inline void LCD_On_Off(unsigned char Chip, unsigned char Data)
{
    LCD_Cmd(Chip, 0b00111110 + (Data & 0x01));
}

// *****************************************************************************
// ***          **********************************
// *****************************************************************************
inline void LCD_Set_First_Str(unsigned char Chip, unsigned char Data)
{
    LCD_Cmd(Chip, 0b11000000 + (Data & 0x3F));
}

// *****************************************************************************
// ***          ************************************
// *****************************************************************************
inline void LCD_Set_Page(unsigned char Chip, unsigned char Data)
{
    LCD_Cmd(Chip, 0b10111000 + (Data & 0x07));
}

// *****************************************************************************
// ***           **********************
// *****************************************************************************
inline void LCD_Set_Col(unsigned char Chip, unsigned char Data)
{
    LCD_Cmd(Chip, 0b01000000 + (Data & 0x3F));
}

// *****************************************************************************
// ***        *****************************************
// *****************************************************************************
void LCD_Init(void)
{
    LCD_RW(Low);    //     
    LCD_C1(High);   //   1
    LCD_C2(High);   //   2
    LCD_RES(Low);   //   RESET 
    delay_us(100);  //   100 
    LCD_RES(High);  //   RESET  
    delay_us(1000); //   1000 
    LCD_Set_First_Str(0, 0); //       0 ( 1)
    LCD_Set_First_Str(1, 0); //       0 ( 2)
    LCD_Set_Page(0, 0); //       ( 1)
    LCD_Set_Page(1, 0); //       ( 2)
    LCD_Set_Col(0, 0);  //        0 ( 1)
    LCD_Set_Col(1, 0);  //        0 ( 2)
    LCD_On_Off(0, On);  //    ( 1)
    LCD_On_Off(1, On);  //    ( 2)

    //     
    LCD_Clear();
}

// *****************************************************************************
// ***        ***********************************************
// *****************************************************************************
void LCD_Clear(void)
{
    unsigned char i, j;
    for(j=0; j < 8; j++)
    {
        LCD_Set_Page(0, j);
        LCD_Set_Col(0, 0);
        LCD_Set_Page(1, j);
        LCD_Set_Col(1, 0);

        for(i=0; i < 64; i++) LCD_Dat(0, 0);
        for(i=0; i < 64; i++) LCD_Dat(1, 0);
    }
}

// *****************************************************************************
// ***    .        *******************
// *****************************************************************************
void LCD_Refresh(void)
{
    unsigned char i, j;

    LCD_Set_First_Str(0, 0);

    for(i=0; i < 8; i++)
    {
        LCD_Set_Page(0, i);
        LCD_Set_Col(0, 0);
        LCD_A0(High);
        LCD_CS(0);
        for(j=0; j < 64; j++)
        {
            LCD_DATA_PORT = LCD_Buf[i][j];
            delay_us(E_Del);
            LCD_E(High);
            delay_us(E_Del);
            LCD_E(Low);
            //        8 
	        delay_us(Del);
        }
    }

    LCD_Set_First_Str(1, 0);

    for(i=0; i < 8; i++)
    {
        LCD_Set_Page(1, i);
        LCD_Set_Col(1, 0);
        LCD_A0(High);
        LCD_CS(1);
        for(j=64; j < 128; j++)
        {
            LCD_DATA_PORT = LCD_Buf[i][j];
            delay_us(E_Del);
            LCD_E(High);
            delay_us(E_Del);
            LCD_E(Low);
            //        8 
	        delay_us(Del);
        }
    }
}