/*******************************************************************************
*  Variables.c
*
*  :  , 
*
*       Copyright (c) 2007-2009 Nick Shl, focus
*           All rights reserved.
*
*
*  :
*
*  Apr 21, 2009  Nick_Shl   
*
*/// ***************************************************************************

// *****************************************************************************
// ***        ***************************************
// *****************************************************************************

// Main parametrs structure for EEPROM
typedef struct {
    int  size;                  // Size of structure. Must be sizeof(TRANSMITTER_SETTINGS)
    char FirstON;               // First ON flag
    char SoundFlag;             // Sound enable flag
    char BacklightFlag;         // Backlight enable flag
    char ModelNum;              // Used model

    //   :
    signed int ADmid[MAX_ADC]; //  
    signed int Kmin[MAX_ADC];  //        .
    signed int Kmax[MAX_ADC];  //        .
} TRANSMITTER_SETTINGS;

// Main parametrs structure for EEPROM
typedef eeprom struct {
    int  size;                  // Size of structure. Must be sizeof(EEPROM_TRANSMITTER_SETTINGS)
    char FirstON;               // First ON flag
    char SoundFlag;             // Sound enable flag
    char BacklightFlag;         // Backlight enable flag
    char ModelNum;              // Last used model

    //   :
    signed int ADmid[MAX_ADC]; //  
    signed int Kmin[MAX_ADC];  //        .
    signed int Kmax[MAX_ADC];  //        .
} EEPROM_TRANSMITTER_SETTINGS;

//     -   EEPROM
extern TRANSMITTER_SETTINGS Settings;

//     -   EEPROM
extern eeprom EEPROM_TRANSMITTER_SETTINGS EEPROM_SETTINGS;

// *****************************************************************************
// ***   ,     ***************************************
// *****************************************************************************

// ***    *********************************************
//  Rates - EPA val in 2% unit
typedef struct
{
    char          reverse;            // 
    unsigned char maxRates;           //  
    unsigned char minRates;           //  
    unsigned char maxDRates;          //     
    unsigned char minDRates;          //     .   T-Cut.
    char          from;               //    -    
    char          nodes[CURVE_NODES]; // 
} CONTROLS_SETTINGS;

// ***      ***********************************
typedef struct {
    char name[MODE_NAME_LEN];                        //    ( 12  + -)
    CONTROLS_SETTINGS         Control[MAX_CONTROLS]; //  
    signed char Chanels[MAX_CHANNELS][MAX_CONTROLS]; //  
    signed char trimmers[MAX_TRIMMERS];              //  
} DEF_MODE;

// ***   ********************************************************
typedef struct {
    int  size;                 //  .   sizeof(MODEL_SETTINGS)
    char name[MODEL_NAME_LEN]; //   ( 12  + -)
    char type;                 //  : ,   ..
    char modulation;           //  : PPM, IPPM  ..
    int  timer;                //   
    char timer_mode;           //    /
    char num_ch;               //    
    DEF_MODE Mode[MAX_MODES];  //    
} MODEL_SETTINGS;

// ***    *********************************************
//  Rates - EPA val in 2% unit
typedef eeprom struct
{
    char          reverse;            // 
    unsigned char maxRates;           //  
    unsigned char minRates;           //  
    unsigned char maxDRates;          //     
    unsigned char minDRates;          //     .   T-Cut.
    char          from;               //    -    
    char          nodes[CURVE_NODES]; // 
} EEPROM_CONTROLS_SETTINGS;

// ***      ***********************************
typedef eeprom struct {
    char name[MODE_NAME_LEN];                        //    ( 12  + -)
    EEPROM_CONTROLS_SETTINGS  Control[MAX_CONTROLS]; //  
    signed char Chanels[MAX_CHANNELS][MAX_CONTROLS]; //  
    signed char trimmers[MAX_TRIMMERS];              //  
} EEPROM_DEF_MODE;

// ***   ********************************************************
typedef eeprom struct {
    int  size;                       //  .   sizeof(EEPROM_MODEL_SETTINGS)
    char name[MODEL_NAME_LEN];       //  
    char type;                       //  : ,   ..
    char modulation;                 //  : PPM, IPPM  ..
    int  timer;                      //   
    char timer_mode;                 //    /
    char num_ch;                     //    
    EEPROM_DEF_MODE Mode[MAX_MODES]; //    
} EEPROM_MODEL_SETTINGS;

//      -   SRAM
extern MODEL_SETTINGS CurModel;
//      -   EEPROM
extern eeprom EEPROM_MODEL_SETTINGS EEPROM_MODEL[MAX_MODELS];

// *****************************************************************************
// ***        *****************************************
// *****************************************************************************
//       
//        
extern char tmpStr[64]; //   
extern char tmpBuf[32]; //    

// *****************************************************************************
// ***      **************************************************************
// *****************************************************************************

//   
extern signed int Aref;

//    
extern signed int AD[MAX_ADC];
//    
extern signed int AD_NORM[MAX_ADC];
//   
extern signed int input[MAX_CONTROLS];
//    ( , ,   ..)
extern signed int out_cur[MAX_CONTROLS];
//    
extern signed int output[MAX_CHANNELS];

//   :
extern signed int ADmin[MAX_ADC]; //   \       .
extern signed int ADmax[MAX_ADC]; //   /    .

//   
extern char FLY_MODE;
//       ,
//   .
extern unsigned char trim_sound_en;
//   -       
//   minDRates
extern char Cut_enable;
